/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.epm.eb.business.rejectbill.RejectBillService;
import kd.epm.eb.common.centralapproval.CentralAppShowInfo;
import kd.epm.eb.common.utils.UserUtils;

public class RejectAdjustmentOrderPlugin
extends AbstractOperationServicePlugIn {
    private static String REJECTADJUSTMENT = "rejectadjustment";
    private static String EB_BGAPPLYBILL = "eb_bgapplybill";

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        String operationKey = e.getOperationKey();
        if (operationKey.equals(REJECTADJUSTMENT)) {
            for (DynamicObject dataEntity : dataEntities) {
                String id = dataEntity.getString("id");
                List approverByBusinessKey = WorkflowServiceHelper.getApproverByBusinessKey((String)id);
                List userMainOrgId = UserServiceHelper.getUserMainOrgId((List)approverByBusinessKey);
                List allApprovalRecord = WorkflowServiceHelper.getAllApprovalRecord((String)id);
                List children = ((IApprovalRecordGroup)allApprovalRecord.get(allApprovalRecord.size() - 1)).getChildren();
                String activityName = ((IApprovalRecordItem)children.get(children.size() - 1)).getActivityName();
                this.generateRejectAdjustmentOrder(activityName, dataEntity);
            }
        }
    }

    private void generateRejectAdjustmentOrder(String activityName, DynamicObject dataEntitys) {
        DynamicObject pkid = QueryServiceHelper.queryOne((String)"eb_centralappbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)dataEntitys.getString("billno"))});
        DynamicObject dataEntity = BusinessDataServiceHelper.loadSingle((Object)pkid.getLong("id"), (String)"eb_centralappbill");
        if (dataEntity.getInt("parentid") != 0) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)EB_BGAPPLYBILL);
            dynamicObject.set("org", (Object)dataEntity.getDynamicObject("reportentity").getLong("id"));
            dynamicObject.set("year", (Object)dataEntity.getString("year.id"));
            dynamicObject.set("version", (Object)dataEntity.getString("version.id"));
            dynamicObject.set("datatype", (Object)dataEntity.getString("datatype.id"));
            dynamicObject.set("applyscheme", (Object)dataEntity.getDynamicObject("reportscheme").getLong("id"));
            dynamicObject.set("model", (Object)dataEntity.getDynamicObject("model").getLong("id"));
            dynamicObject.set("billnumber", (Object)RejectBillService.getInstance().getBhNumber(dataEntity.getString("billno")));
            dynamicObject.set("srcbillnumber", (Object)dataEntity.getString("billno"));
            dynamicObject.set("budgetorg", (Object)dataEntity.getDynamicObject("reportentity").getLong("id"));
            dynamicObject.set("creater", (Object)UserUtils.getUserId());
            dynamicObject.set("createdate", (Object)new Date());
            dynamicObject.set("billtype", (Object)"collectreject");
            dynamicObject.set("billstatus", (Object)"A");
            dynamicObject.set("proposer", (Object)dataEntity.getLong("creater.id"));
            dynamicObject.set("modifier", (Object)UserUtils.getUserId());
            dynamicObject.set("rejectnode", (Object)activityName);
            dynamicObject.set("centralorgid", (Object)dataEntity.getString("centralorg.id"));
            dynamicObject.set("modifydate", (Object)new Date());
            dynamicObject.set("auditor", (Object)UserUtils.getUserId());
            dynamicObject.set("auditdate", (Object)new Date());
            dynamicObject.set("rejectiontype", (Object)"processrejection");
            dynamicObject.set("createrorg", (Object)UserServiceHelper.getUserMainOrgId((long)UserUtils.getUserId()));
            CentralAppShowInfo centralAppShowInfo = new CentralAppShowInfo();
            centralAppShowInfo.setBillNo(dataEntity.get("billno").toString());
            dynamicObject.set("auditpath", (Object)SerializationUtils.toJsonString((Object)centralAppShowInfo));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }
}

