/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval.approveplan;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralapproval.ApproveAdjDimTypeEnum;
import kd.epm.eb.common.centralapproval.entity.ApproveAdTypeEnum;
import kd.epm.eb.common.ebcommon.common.json.JSONObjectUtil;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.centralapproval.approveplan.helper.DynamicObjectParseHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class ApprovalPlanAdjustmentDimension2Plugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String CURRENTLYSELECTDE = "currentlyselected";
    private static final String SYSTEM_MODEL = "model";
    private static final String[] isAdjSysDims = new String[]{SysDimensionEnum.Account.getNumber(), SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.AuditTrail.getNumber()};

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{"entitymember", "accountmember", "userdefinemember", "audittrialmember"});
    }

    public void afterCreateNewData(EventObject e) {
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam(SYSTEM_MODEL);
        this.getPageCache().put(SYSTEM_MODEL, modelId.toString());
        JSONObject jsonObject = this.getJsonObject();
        this.showdate(jsonObject);
        this.setinterfaceVisible();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (kd.epm.eb.common.utils.StringUtils.equals((String)name, (String)"radiogroup")) {
            this.setinterfaceVisible();
        } else if (kd.epm.eb.common.utils.StringUtils.equals((String)name, (String)"entitymember") || kd.epm.eb.common.utils.StringUtils.equals((String)name, (String)"accountmember") || kd.epm.eb.common.utils.StringUtils.equals((String)name, (String)"userdefinemember") || kd.epm.eb.common.utils.StringUtils.equals((String)name, (String)"audittrialmember")) {
            this.handleMemberPropChange(e);
        }
    }

    private void handleMemberPropChange(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (newValue instanceof DynamicObjectCollection) {
            DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)newValue;
            ArrayList memberMapList = new ArrayList(16);
            for (DynamicObject dynamicObject : dynamicObjects) {
                HashMap<String, String> entity = new HashMap<String, String>(16);
                entity.put("id", dynamicObject.getString("fbasedataid_id"));
                DynamicObject fbasedataid = dynamicObject.getDynamicObject("fbasedataid");
                if (fbasedataid != null) {
                    entity.put("name", fbasedataid.getString("name"));
                }
                memberMapList.add(entity);
            }
            this.getModel().setValue("member", (Object)SerializationUtils.toJsonString(memberMapList));
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (kd.epm.eb.common.utils.StringUtils.equals((String)operateKey, (String)"btnok")) {
            JSONObject returndata = this.returndata();
            this.getView().returnDataToParent((Object)returndata);
            this.getView().close();
        }
    }

    private JSONObject returndata() {
        JSONObject returnObject = new JSONObject();
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
        Object radiogroup = this.getModel().getValue("radiogroup");
        Object referencefield = this.getModel().getValue("referencefield");
        Object dimmemlevel = this.getModel().getValue("dimmemlevel");
        Object member = this.getModel().getValue("member");
        Object basedataid = this.getModel().getValue("basedataid");
        MulBasedataDynamicObjectCollection entitymember = (MulBasedataDynamicObjectCollection)this.getModel().getValue("entitymember");
        MulBasedataDynamicObjectCollection accountmember = (MulBasedataDynamicObjectCollection)this.getModel().getValue("accountmember");
        MulBasedataDynamicObjectCollection userdefinemember = (MulBasedataDynamicObjectCollection)this.getModel().getValue("userdefinemember");
        MulBasedataDynamicObjectCollection audittrialmember = (MulBasedataDynamicObjectCollection)this.getModel().getValue("audittrialmember");
        returnObject.put("dimension", (Object)dimension);
        returnObject.put("radiogroup", radiogroup);
        if (kd.epm.eb.common.utils.StringUtils.equals((String)radiogroup.toString(), (String)ApproveAdjDimTypeEnum.RangeTypeEnum.RANGE_LEVEL.getValue()) && kd.epm.eb.common.utils.StringUtils.equals((String)dimension.getString("number"), (String)SysDimensionEnum.Entity.getNumber())) {
            returnObject.put("referencefield", referencefield);
            returnObject.put("dimmemlevel", dimmemlevel);
            if (referencefield == null && dimmemlevel == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53c2\u7167\u5b57\u6bb5\u548c\u8c03\u6574\u6210\u5458\u7ea7\u6b21\u3002", (String)"ApprovalPlanAdjustmentDimensionPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (referencefield == null || kd.epm.eb.common.utils.StringUtils.isEmpty((String)referencefield.toString())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53c2\u7167\u5b57\u6bb5\u3002", (String)"ApprovalPlanAdjustmentDimensionPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (dimmemlevel == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8c03\u6574\u6210\u5458\u7ea7\u6b21\u3002", (String)"ApprovalPlanAdjustmentDimensionPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else if (kd.epm.eb.common.utils.StringUtils.equals((String)radiogroup.toString(), (String)ApproveAdjDimTypeEnum.RangeTypeEnum.RANGE_LEVEL.getValue())) {
            returnObject.put("radiogroup", radiogroup);
            returnObject.put("dimmemlevel", dimmemlevel);
            if (dimmemlevel == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8c03\u6574\u6210\u5458\u7ea7\u6b21\u3002", (String)"ApprovalPlanAdjustmentDimensionPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        if (kd.epm.eb.common.utils.StringUtils.equals((String)radiogroup.toString(), (String)ApproveAdjDimTypeEnum.RangeTypeEnum.RANGE_MEMBER.getValue())) {
            returnObject.put("member", member);
            returnObject.put("basedataid", basedataid);
            if (kd.epm.eb.common.utils.StringUtils.equals((String)SysDimensionEnum.Entity.getNumber(), (String)dimension.getString("number"))) {
                returnObject.put("entitymember", (Object)entitymember);
                if (entitymember.size() == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6307\u5b9a\u6210\u5458\u3002", (String)"ApprovalPlanAdjustmentDimensionPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            } else if (kd.epm.eb.common.utils.StringUtils.equals((String)SysDimensionEnum.Account.getNumber(), (String)dimension.getString("number"))) {
                returnObject.put("accountmember", (Object)accountmember);
                if (accountmember.size() == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6307\u5b9a\u6210\u5458\u3002", (String)"ApprovalPlanAdjustmentDimensionPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            } else if (kd.epm.eb.common.utils.StringUtils.equals((String)SysDimensionEnum.AuditTrail.getNumber(), (String)dimension.getString("number"))) {
                returnObject.put("audittrialmember", (Object)audittrialmember);
                if (audittrialmember.size() == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6307\u5b9a\u6210\u5458\u3002", (String)"ApprovalPlanAdjustmentDimensionPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            } else {
                returnObject.put("userdefinemember", (Object)userdefinemember);
                if (userdefinemember.size() == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6307\u5b9a\u6210\u5458\u3002", (String)"ApprovalPlanAdjustmentDimensionPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        }
        return returnObject;
    }

    private void setinterfaceVisible() {
        JSONObject jsonObject = this.getJsonObject();
        JSONObject dimens = jsonObject.getJSONObject("dimension");
        Object dimension = this.getModel().getValue("dimension");
        if (dimension == null) {
            return;
        }
        Set<Integer> dimmemlevel = this.getAdjDimMemberLevel(dimens.get((Object)"number").toString());
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"radiogroup", "referencefield", "dimmemlevel", "entitymember", "accountmember", "userdefinemember", "audittrialmember"});
        if (dimmemlevel.size() == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"radiogroup", "referencefield", "dimmemlevel", "entitymember", "accountmember", "userdefinemember", "radiorange", "radiomember"});
        } else {
            ApproveAdTypeEnum typeByDimNumber = ApprovalPlanAdjustmentDimension2Plugin.getTypeByDimNumber(dimens.getString("number"));
            if (typeByDimNumber == ApproveAdTypeEnum.TYPE_ONE) {
                this.setTypeOneVisible();
            } else if (typeByDimNumber == ApproveAdTypeEnum.TYPE_TWO) {
                this.setTypeTwoVisible();
            } else {
                this.setTypeOneVisible();
            }
        }
    }

    private void setTypeTwoVisible() {
        Object rangeTypeObj = this.getModel().getValue("radiogroup");
        if (rangeTypeObj == null) {
            return;
        }
        String rangeType = rangeTypeObj.toString();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"entitymember", "accountmember", "userdefinemember", "referencefield", "dimmemlevel"});
        if (kd.epm.eb.common.utils.StringUtils.equals((String)ApproveAdjDimTypeEnum.RangeTypeEnum.RANGE_LEVEL.getValue(), (String)rangeType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"dimmemlevel", "referencefield"});
        } else if (kd.epm.eb.common.utils.StringUtils.equals((String)ApproveAdjDimTypeEnum.RangeTypeEnum.RANGE_MEMBER.getValue(), (String)rangeType)) {
            Object dimension = this.getModel().getValue("dimension");
            if (dimension == null) {
                return;
            }
            JSONObject selectedDimension = this.getJsonObject();
            if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)selectedDimension.toString())) {
                return;
            }
            if (kd.epm.eb.common.utils.StringUtils.equals((String)SysDimensionEnum.Entity.getNumber(), (String)selectedDimension.getJSONObject("dimension").getString("number"))) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"entitymember"});
            }
        }
    }

    private void setTypeOneVisible() {
        Object rangeTypeObj = this.getModel().getValue("radiogroup");
        if (rangeTypeObj == null) {
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"entitymember", "accountmember", "userdefinemember", "audittrialmember", "referencefield", "dimmemlevel"});
        String rangeType = rangeTypeObj.toString();
        if (kd.epm.eb.common.utils.StringUtils.equals((String)ApproveAdjDimTypeEnum.RangeTypeEnum.RANGE_LEVEL.getValue(), (String)rangeType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"dimmemlevel"});
        } else if (kd.epm.eb.common.utils.StringUtils.equals((String)ApproveAdjDimTypeEnum.RangeTypeEnum.RANGE_MEMBER.getValue(), (String)rangeType)) {
            Object dimension = this.getModel().getValue("dimension");
            if (dimension == null) {
                return;
            }
            JSONObject selectedDimension = this.getJsonObject();
            if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)selectedDimension.toString())) {
                return;
            }
            if (kd.epm.eb.common.utils.StringUtils.equals((String)SysDimensionEnum.Entity.getNumber(), (String)selectedDimension.getJSONObject("dimension").getString("number"))) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"entitymember"});
            } else if (kd.epm.eb.common.utils.StringUtils.equals((String)SysDimensionEnum.Account.getNumber(), (String)selectedDimension.getJSONObject("dimension").getString("number"))) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"accountmember"});
            } else if (kd.epm.eb.common.utils.StringUtils.equals((String)SysDimensionEnum.AuditTrail.getNumber(), (String)selectedDimension.getJSONObject("dimension").getString("number"))) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"audittrialmember"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"userdefinemember"});
            }
        }
    }

    private void showdate(JSONObject date) {
        this.setBaseDataId(date.getJSONObject("dimension").getString("number"));
        this.setdimmemlevel(date);
        if (date.getString("type").equals("1")) {
            this.islevel(date);
        } else {
            this.ismember(date);
            this.setreferencefield(date);
            this.setMember(date);
        }
    }

    private void setMember(JSONObject date) {
        ArrayList memberMapList = new ArrayList(16);
        JSONObject jsonObject = JSONObject.parseObject((String)date.getString("dimsid"));
        Set keys = jsonObject.keySet();
        for (String key : keys) {
            HashMap<String, String> entity = new HashMap<String, String>(16);
            entity.put("id", key);
            entity.put("name", jsonObject.getString(key));
            memberMapList.add(entity);
        }
        this.getModel().setValue("member", (Object)SerializationUtils.toJsonString(memberMapList));
    }

    private void setBaseDataId(String dimNumber) {
        if (kd.epm.eb.common.utils.StringUtils.equals((String)SysDimensionEnum.Account.getNumber(), (String)dimNumber)) {
            this.getModel().setValue("basedataid", (Object)"epm_accountmembertree");
        } else if (kd.epm.eb.common.utils.StringUtils.equals((String)SysDimensionEnum.Entity.getNumber(), (String)dimNumber)) {
            this.getModel().setValue("basedataid", (Object)"epm_entitymembertree");
        } else if (kd.epm.eb.common.utils.StringUtils.equals((String)SysDimensionEnum.AuditTrail.getNumber(), (String)dimNumber)) {
            this.getModel().setValue("basedataid", (Object)"epm_audittrialmembertree");
        } else {
            this.getModel().setValue("basedataid", (Object)"epm_userdefinedmembertree");
        }
    }

    private void ismember(JSONObject date) {
        if (kd.epm.eb.common.utils.StringUtils.equals((String)date.getJSONObject("dimension").getString("number"), (String)SysDimensionEnum.Entity.getNumber())) {
            this.getModel().setValue("dimension", (Object)date.getJSONObject("dimension").getString("id"));
            this.getModel().setValue("radiogroup", (Object)date.getString("type"));
            List<Long> keyList = ApprovalPlanAdjustmentDimension2Plugin.getLongList(date.get((Object)"dimsid"));
            this.getModel().setValue("entitymember", (Object)keyList.toArray());
        } else if (kd.epm.eb.common.utils.StringUtils.equals((String)date.getJSONObject("dimension").getString("number"), (String)SysDimensionEnum.Account.getNumber())) {
            this.getModel().setValue("dimension", (Object)date.getJSONObject("dimension").getString("id"));
            this.getModel().setValue("radiogroup", (Object)date.getString("type"));
            List<Long> keyList = ApprovalPlanAdjustmentDimension2Plugin.getLongList(date.get((Object)"dimsid"));
            this.getModel().setValue("accountmember", (Object)keyList.toArray());
        } else if (kd.epm.eb.common.utils.StringUtils.equals((String)date.getJSONObject("dimension").getString("number"), (String)SysDimensionEnum.AuditTrail.getNumber())) {
            this.getModel().setValue("dimension", (Object)date.getJSONObject("dimension").getString("id"));
            this.getModel().setValue("radiogroup", (Object)date.getString("type"));
            List<Long> keyList = ApprovalPlanAdjustmentDimension2Plugin.getLongList(date.get((Object)"dimsid"));
            this.getModel().setValue("audittrialmember", (Object)keyList.toArray());
        } else {
            this.getModel().setValue("dimension", (Object)date.getJSONObject("dimension").getString("id"));
            this.getModel().setValue("radiogroup", (Object)date.getString("type"));
            List<Long> keyList = ApprovalPlanAdjustmentDimension2Plugin.getLongList(date.get((Object)"dimsid"));
            this.getModel().setValue("userdefinemember", (Object)keyList.toArray());
        }
    }

    @NotNull
    private static List<Long> getLongList(Object string) {
        List<Long> keyList = new ArrayList<Long>(16);
        if (StringUtils.isBlank((Object)string)) {
            return keyList;
        }
        JSONObject jsonObject = JSONObjectUtil.parseObjectOrder((String)string.toString());
        Set strings = jsonObject.keySet();
        keyList = strings.stream().map(Long::parseLong).collect(Collectors.toList());
        return keyList;
    }

    private void islevel(JSONObject date) {
        ApproveAdTypeEnum typeByDimNumber = ApprovalPlanAdjustmentDimension2Plugin.getTypeByDimNumber(date.getJSONObject("dimension").getString("number"));
        if (typeByDimNumber == ApproveAdTypeEnum.TYPE_ONE) {
            this.issubjectorcustom(date);
        } else if (typeByDimNumber == ApproveAdTypeEnum.TYPE_TWO) {
            this.isorg(date);
        } else {
            this.issubjectorcustom(date);
        }
    }

    private void isorg(JSONObject date) {
        this.setreferencefield(date);
        this.getModel().setValue("dimension", (Object)date.getJSONObject("dimension").getString("id"));
        this.getModel().setValue("radiogroup", (Object)date.getString("type"));
        this.getModel().setValue("referencefield", date.get((Object)"orgreferencefield"));
        this.getModel().setValue("dimmemlevel", date.get((Object)"dimmemlevel"));
    }

    private void setreferencefield(JSONObject date) {
        List<Map<String, String>> budgetEntityBaseEntityData = DynamicObjectParseHelper.getBudgetEntityBaseEntityData(this.getBillType());
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        String defaultValue = "";
        for (Map<String, String> entityMap : budgetEntityBaseEntityData) {
            for (Map.Entry<String, String> entry : entityMap.entrySet()) {
                String code = entry.getKey();
                String name = entry.getValue();
                if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)defaultValue)) {
                    defaultValue = code;
                }
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(name));
                comboItem.setValue(code);
                comboItems.add(comboItem);
            }
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("referencefield");
        comboEdit.setComboItems(comboItems);
    }

    private String getBillType() {
        Object billtype = this.getView().getFormShowParameter().getCustomParam("billtype");
        if (billtype == null) {
            return "";
        }
        return billtype.toString().split("#")[0];
    }

    private void issubjectorcustom(JSONObject date) {
        this.getModel().setValue("dimension", (Object)date.getJSONObject("dimension").getString("id"));
        this.getModel().setValue("radiogroup", (Object)date.getString("type"));
        this.getModel().setValue("dimmemlevel", (Object)date.getString("dimmemlevel"));
    }

    private void setdimmemlevel(JSONObject date) {
        ComboEdit dimmemlevel = (ComboEdit)this.getControl("dimmemlevel");
        Set<Integer> levels = this.getAdjDimMemberLevel(date.getJSONObject("dimension").getString("number"));
        Map<String, String> typeOneLevels = ApprovalPlanAdjustmentDimension2Plugin.getLevelsByDimNumber(date.getJSONObject("dimension").getString("number"), levels);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        ArrayList<String> values = new ArrayList<String>(typeOneLevels.keySet());
        String defaultKey = (String)values.get(values.size() - 1);
        for (String string : typeOneLevels.keySet()) {
            if (!kd.epm.eb.common.utils.StringUtils.equals((String)ApproveAdjDimTypeEnum.TypeOneLevelEnum.SPECIAL.getValue(), (String)string)) continue;
            defaultKey = string;
            break;
        }
        for (Map.Entry entry : typeOneLevels.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(key);
            comboItem.setCaption(new LocaleString(value));
            items.add(comboItem);
        }
        dimmemlevel.setComboItems(items);
    }

    public static boolean isAdjDim(String dimNumber) {
        List<String> list = Arrays.asList(isAdjSysDims);
        if (list.contains(dimNumber)) {
            return true;
        }
        for (SysDimensionEnum value : SysDimensionEnum.values()) {
            if (!kd.epm.eb.common.utils.StringUtils.equals((String)dimNumber, (String)value.getNumber())) continue;
            return false;
        }
        return true;
    }

    public static Map<String, String> getLevelsByDimNumber(String dimNumber, Set<Integer> levels) {
        Map<String, String> result = new HashMap<String, String>(16);
        ApproveAdTypeEnum typeByDimNumber = ApprovalPlanAdjustmentDimension2Plugin.getTypeByDimNumber(dimNumber);
        if (typeByDimNumber == null) {
            return result;
        }
        switch (typeByDimNumber) {
            case TYPE_ONE: {
                result = ApproveAdjDimTypeEnum.getTypeOneLevels(levels);
                break;
            }
            case TYPE_THREE: {
                result = ApproveAdjDimTypeEnum.getTypeOneLevels(levels);
                break;
            }
            case TYPE_TWO: {
                ApproveAdjDimTypeEnum.TypeTwoLevelEnum[] values;
                for (ApproveAdjDimTypeEnum.TypeTwoLevelEnum value : values = ApproveAdjDimTypeEnum.TypeTwoLevelEnum.values()) {
                    String desc = value.getDesc();
                    String code = value.getValue();
                    result.put(code, desc);
                }
                break;
            }
        }
        return result;
    }

    public static ApproveAdTypeEnum getTypeByDimNumber(String dimNumber) {
        if (!ApprovalPlanAdjustmentDimension2Plugin.isAdjDim(dimNumber)) {
            return null;
        }
        if (kd.epm.eb.common.utils.StringUtils.equals((String)dimNumber, (String)SysDimensionEnum.Entity.getNumber())) {
            return ApproveAdTypeEnum.TYPE_TWO;
        }
        if (kd.epm.eb.common.utils.StringUtils.equals((String)dimNumber, (String)SysDimensionEnum.Account.getNumber())) {
            return ApproveAdTypeEnum.TYPE_ONE;
        }
        if (kd.epm.eb.common.utils.StringUtils.equals((String)dimNumber, (String)SysDimensionEnum.AuditTrail.getNumber())) {
            return ApproveAdTypeEnum.TYPE_THREE;
        }
        boolean flag = false;
        for (SysDimensionEnum value : SysDimensionEnum.values()) {
            if (!kd.epm.eb.common.utils.StringUtils.equals((String)dimNumber, (String)value.getNumber())) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return ApproveAdTypeEnum.TYPE_ONE;
        }
        return null;
    }

    private Set<Integer> getAdjDimMemberLevel(String dimNumber) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)((Long)this.getView().getFormShowParameter().getCustomParam(SYSTEM_MODEL)));
        Long bizModelId = (Long)this.getView().getFormShowParameter().getCustomParam("businessmodel");
        Map dimViewMap = modelCacheHelper.getViewsByBusModel(bizModelId);
        HashSet<Integer> result = new HashSet<Integer>(16);
        List members = modelCacheHelper.getMembers((Long)dimViewMap.get(dimNumber), dimNumber);
        for (Member member : members) {
            this.getMemberAllChildren(member, result);
        }
        return result;
    }

    private void getMemberAllChildren(Member member, Set<Integer> levels) {
        if (member == null) {
            return;
        }
        levels.add(member.getLevel());
        List memberChildren = member.getChildren();
        if (CollectionUtils.isEmpty((Collection)memberChildren)) {
            return;
        }
        for (Member memberChild : memberChildren) {
            this.getMemberAllChildren(memberChild, levels);
        }
    }

    private JSONObject getJsonObject() {
        Object data = this.getView().getFormShowParameter().getCustomParam(CURRENTLYSELECTDE);
        JSONObject jsonData = JSONObjectUtil.parseObjectOrder((String)data.toString());
        return jsonData;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam(SYSTEM_MODEL);
        if (name.endsWith("member")) {
            JSONObject dimens = this.getJsonObject().getJSONObject("dimension");
            String dimId = dimens.getString("id");
            MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)Long.valueOf(dimId)), (String)ListSelectedRow.class.getName());
            Long busModeid = (Long)this.getView().getFormShowParameter().getCustomParam("businessmodel");
            if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)dimId)) {
                f7Param.setMultiSelect(true);
                f7Param.setMustSelected(true);
                f7Param.setEnableView(true);
                f7Param.setBusModelId(busModeid);
                NewF7Utils.openF7((BeforeF7SelectEvent)beforeF7SelectEvent, (MemberF7Parameter)f7Param);
            }
        }
    }
}

