/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval.approveplan;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.centralapproval.ApproveAdjDimTypeEnum;
import kd.epm.eb.common.centralapproval.entity.ApproveAdjMemberRangeDto;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.centralapproval.approveplan.helper.DynamicObjectParseHelper;

public class ApprovePlanAdjSchemeListPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static final String EB_CENTRALADJSCHEMEENTITY = "eb_centraladjschemeentity";

    public void afterCreateNewData(EventObject e) {
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and("businessmodel", "=", (Object)this.getBusinessModelId());
        this.renderList(filter);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search inputSearch = (Search)this.getControl("searchap");
        inputSearch.addEnterListener((SearchEnterListener)this);
    }

    private void renderList(QFilter filter) {
        this.getModel().deleteEntryData("entryentity");
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)EB_CENTRALADJSCHEMEENTITY, (QFilter[])filter.toArray());
        for (Map.Entry entry : dynamicObjectMap.entrySet()) {
            Object dynamicObject2;
            DynamicObject value = (DynamicObject)entry.getValue();
            Long schemeId = value.getLong("id");
            DynamicObjectCollection entryentity1 = value.getDynamicObjectCollection("entryentity");
            HashMap<String, List> maps = new HashMap<String, List>(16);
            DynamicObjectCollection adjmemberentryentity = value.getDynamicObjectCollection("adjmemberentryentity");
            for (Object dynamicObject2 : adjmemberentryentity) {
                String relationrowid = dynamicObject2.getString("relationrowid");
                List members = maps.computeIfAbsent(relationrowid, t -> new ArrayList(16));
                HashMap<String, String> member = new HashMap<String, String>(16);
                member.put("id", dynamicObject2.getDynamicObject("memberid").getString("id"));
                member.put("basedataid", dynamicObject2.getString("basedatatype"));
                member.put("name", dynamicObject2.getDynamicObject("memberid").getString("name"));
                members.add(member);
            }
            ArrayList<String> approveRanges = new ArrayList<String>(16);
            dynamicObject2 = entryentity1.iterator();
            while (dynamicObject2.hasNext()) {
                DynamicObject dynamicObject3 = (DynamicObject)dynamicObject2.next();
                String dimmemlevel = dynamicObject3.getString("dimmemlevel");
                String orgreferencefield = dynamicObject3.getString("orgreferencefield");
                String rowid = dynamicObject3.getString("rowid");
                List members = (List)maps.get(rowid);
                String rangetype = dynamicObject3.getString("rangetype");
                String dimtype = dynamicObject3.getString("dimtype");
                ApproveAdjDimTypeEnum.RangeTypeEnum typeByValue = ApproveAdjDimTypeEnum.RangeTypeEnum.getTypeByValue((String)rangetype);
                ApproveAdjDimTypeEnum dimTypeEnum = ApproveAdjDimTypeEnum.getTypeByValue((String)dimtype);
                ApproveAdjMemberRangeDto approveAdjMemberRangeDto = new ApproveAdjMemberRangeDto();
                approveAdjMemberRangeDto.setMembers(members);
                approveAdjMemberRangeDto.setRangeType(typeByValue);
                approveAdjMemberRangeDto.setDimType(dimTypeEnum);
                approveAdjMemberRangeDto.setOrgReferenceField(orgreferencefield);
                approveAdjMemberRangeDto.setBillType(this.getBillType());
                approveAdjMemberRangeDto.setBillTypeName(this.getBillTypeName());
                approveAdjMemberRangeDto.setDimMemLevel(dimmemlevel);
                DynamicObject dimension = dynamicObject3.getDynamicObject("dimensionid");
                String dimName = dimension.getString("name");
                String dimNumber = dimension.getString("number");
                approveAdjMemberRangeDto.setDimName(dimName);
                approveAdjMemberRangeDto.setDimNum(dimNumber);
                List<Map<String, String>> budgetEntityBaseEntityData = DynamicObjectParseHelper.getBudgetEntityBaseEntityData(this.getBillType());
                approveAdjMemberRangeDto.setBudgetEntityBaseEntityData(budgetEntityBaseEntityData);
                String dimmemrange = ApproveAdjDimTypeEnum.getDimMemberRange((ApproveAdjMemberRangeDto)approveAdjMemberRangeDto, (boolean)true);
                approveRanges.add(dimmemrange);
            }
            int row = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("scheme", (Object)schemeId, row);
            this.getModel().setValue("approverange", (Object)String.join((CharSequence)";", approveRanges), row);
        }
    }

    private String getBillType() {
        Object billType = this.getView().getFormShowParameter().getCustomParam("billType");
        if (billType != null) {
            return billType.toString();
        }
        return "";
    }

    private String getBillTypeName() {
        Object billTypeName = this.getView().getFormShowParameter().getCustomParam("billTypeName");
        if (billTypeName != null) {
            return billTypeName.toString();
        }
        return "";
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (StringUtils.equals((String)operateKey, (String)"btnok")) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u5165\u7684\u65b9\u6848\u3002", (String)"ApprovePlanAdjSchemeListPlugin_01", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            ArrayList<DynamicObject> returnData = new ArrayList<DynamicObject>(16);
            for (int selectRow : selectRows) {
                DynamicObject dynamicObject = (DynamicObject)entryentity.get(selectRow);
                returnData.add(dynamicObject.getDynamicObject("scheme"));
            }
            this.getView().returnDataToParent((Object)SerializationUtils.serializeToBase64(returnData));
            this.getView().close();
        }
    }

    private Long getBusinessModelId() {
        Object businessModelId = this.getView().getFormShowParameter().getCustomParam("businessModelId");
        if (!(businessModelId instanceof Long)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"ApprovePlanAdjSchemeListPlugin_02", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return Long.parseLong(businessModelId.toString());
    }

    @Override
    public Long getModelId() {
        Object modelId = this.getView().getFormShowParameter().getCustomParam("modelId");
        if (!(modelId instanceof Long)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ApprovePlanAdjSchemeListPlugin_03", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return Long.parseLong(modelId.toString());
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String searchValue = searchEnterEvent.getText();
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and("businessmodel", "=", (Object)this.getBusinessModelId());
        filter.and("number", "like", (Object)("%" + searchValue + "%"));
        this.renderList(filter);
    }
}

