/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval.approveplan;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.utils.CheckStringsUtil;
import kd.epm.eb.common.centralapproval.entity.ApproveAdjScheme;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class ApprovePlanAdjSchemePlugin
extends AbstractFormPlugin {
    private static final String EB_CENTRALADJSCHEMEENTITY = "eb_centraladjschemeentity";

    public void afterCreateNewData(EventObject e) {
        List<DynamicObject> adjDimList = this.getAdjDimList();
        if (CollectionUtils.isEmpty(adjDimList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u751f\u6210\u65b9\u6848\u7684\u5ba1\u6279\u8c03\u6574\u7ef4\u5ea6\u8bb0\u5f55\u3002", (String)"ApprovePlanAdjSchemePlugin_01", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (StringUtils.equals((String)operateKey, (String)"btnok")) {
            DynamicObject entity;
            Object number = this.getModel().getValue("number");
            Object name = this.getModel().getValue("name");
            if (number == null || name == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"ApprovePlanAdjSchemePlugin_02", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (!CheckStringsUtil.checkAllowNumStart((String)number.toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u7531\u534a\u89d2\u6570\u5b57\u548c\u534a\u89d2\u5b57\u6bcd\u7ec4\u6210\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ApprovePlanAdjSchemePlugin_03", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
            if (!this.checkName(name.toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4e2d\u6587\u3001\u82f1\u6587\u6216\u6570\u5b57\u4f5c\u4e3a\u540d\u79f0\u3002", (String)"ApprovePlanAdjSchemePlugin_04", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (this.numberIsRepeat(number.toString())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"ApprovePlanAdjSchemePlugin_05", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            ApproveAdjScheme approveAdjScheme = new ApproveAdjScheme();
            approveAdjScheme.setName(name.toString());
            approveAdjScheme.setNumber(number.toString());
            approveAdjScheme.setBusinessModelId(this.getBusinessModelId());
            approveAdjScheme.setModelId(this.getModelId());
            List<DynamicObject> adjDimList = this.getAdjDimList();
            List<DynamicObject> adjMembers = this.getAdjMembers();
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)EB_CENTRALADJSCHEMEENTITY);
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection adjmemberentryentity = dynamicObject.getDynamicObjectCollection("adjmemberentryentity");
            for (DynamicObject object : adjDimList) {
                entity = entryentity.addNew();
                entity.set("dimension", object.get("dimension"));
                entity.set("dimmemlevel", object.get("dimmemlevel"));
                entity.set("dimensionnum", object.get("dimensionnum"));
                entity.set("dimensionid", object.get("dimensionid"));
                entity.set("rangetype", object.get("rangetype"));
                entity.set("dimtype", object.get("dimtype"));
                entity.set("basedataid", object.get("basedataid"));
                entity.set("orgreferencefield", object.get("orgreferencefield"));
                entity.set("rowid", object.get("rowid"));
            }
            for (DynamicObject adjMember : adjMembers) {
                entity = adjmemberentryentity.addNew();
                entity.set("basedatatype", (Object)adjMember.getString("basedatatype"));
                entity.set("memberid", (Object)adjMember.getDynamicObject("memberid").getLong("id"));
                entity.set("relationrowid", (Object)adjMember.getString("relationrowid"));
            }
            dynamicObject.set("name", (Object)approveAdjScheme.getName());
            dynamicObject.set("number", (Object)approveAdjScheme.getNumber());
            dynamicObject.set("businessmodel", (Object)approveAdjScheme.getBusinessModelId());
            dynamicObject.set("model", (Object)approveAdjScheme.getModelId());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ApprovePlanAdjSchemePlugin_06", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkName(String name) {
        String regex = "^[a-zA-Z0-9\\u4E00-\\u9FA5]{1,50}$";
        boolean ismatch = Pattern.matches(regex, name);
        return ismatch;
    }

    private List<DynamicObject> getAdjDimList() {
        Object adjDims = this.getView().getFormShowParameter().getCustomParam("adjdims");
        if (adjDims == null) {
            return new ArrayList<DynamicObject>(0);
        }
        return (List)SerializationUtils.deSerializeFromBase64((String)adjDims.toString());
    }

    private List<DynamicObject> getAdjMembers() {
        Object adjmembers = this.getView().getFormShowParameter().getCustomParam("adjmembers");
        if (adjmembers == null) {
            return new ArrayList<DynamicObject>(0);
        }
        return (List)SerializationUtils.deSerializeFromBase64((String)adjmembers.toString());
    }

    private boolean numberIsRepeat(String number) {
        if (StringUtils.isEmpty((String)number)) {
            return false;
        }
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and("businessmodel", "=", (Object)this.getBusinessModelId());
        filter.and("number", "=", (Object)number);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)EB_CENTRALADJSCHEMEENTITY, (QFilter[])filter.toArray());
        return dynamicObject != null;
    }

    private Long getBusinessModelId() {
        Object businessModelId = this.getView().getFormShowParameter().getCustomParam("businessModelId");
        if (!(businessModelId instanceof Long)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"ApprovePlanAdjSchemePlugin_07", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return Long.parseLong(businessModelId.toString());
    }

    @Override
    public Long getModelId() {
        Object modelId = this.getView().getFormShowParameter().getCustomParam("modelId");
        if (!(modelId instanceof Long)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ApprovePlanAdjSchemePlugin_08", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return Long.parseLong(modelId.toString());
    }
}

