/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval.approveplan;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.utils.CheckStringsUtil;
import kd.epm.eb.common.centralapproval.entity.ApprovePlanClassifyEntity;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class ApprovePlanClassifyPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        TreeNode focusNode = this.getFocusNode();
        if (focusNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5ba1\u6279\u5206\u7c7b\u8282\u70b9\u3002", (String)"ApprovePlanClassifyPlugin_01", (String)"", (Object[])new Object[0]));
        }
        this.getModel().setValue("parentid", (Object)focusNode.getId());
        this.getModel().setValue("model", (Object)this.getModelId());
        this.setDisable();
        this.reFillData();
    }

    private TreeNode getFocusNode() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object focusNode = customParams.get("focusNode");
        if (focusNode != null) {
            return (TreeNode)SerializationUtils.fromJsonString((String)focusNode.toString(), TreeNode.class);
        }
        return null;
    }

    private void setDisable() {
        if (this.isEdit()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        }
    }

    private ApprovePlanClassifyEntity getClassifyEntity() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object classifyEntity = customParams.get("classifyEntity");
        if (classifyEntity == null) {
            return null;
        }
        return (ApprovePlanClassifyEntity)SerializationUtils.fromJsonString((String)classifyEntity.toString(), ApprovePlanClassifyEntity.class);
    }

    private void reFillData() {
        if (this.isEdit()) {
            ApprovePlanClassifyEntity classifyEntity = this.getClassifyEntity();
            if (classifyEntity == null) {
                return;
            }
            this.getModel().setValue("id", (Object)classifyEntity.getId());
            this.getModel().setValue("number", (Object)classifyEntity.getNumber());
            this.getModel().setValue("name", (Object)classifyEntity.getName());
            this.getModel().setValue("parentid", (Object)classifyEntity.getParentId());
            this.getModel().setValue("model", (Object)classifyEntity.getModelId());
        }
    }

    private boolean isEdit() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object isEdit = customParams.get("isEdit");
        if (isEdit instanceof Boolean) {
            return (Boolean)isEdit;
        }
        return false;
    }

    @Override
    public Long getModelId() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object modelId = customParams.get("modelId");
        return IDUtils.toLong(modelId);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"save")) {
            Object number = this.getModel().getValue("number");
            Object name = this.getModel().getValue("name");
            if (number == null || StringUtils.isBlank((CharSequence)number.toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u3002", (String)"ApprovePlanClassifyPlugin_02", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (name == null || StringUtils.isBlank((CharSequence)name.toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\u3002", (String)"ApprovePlanClassifyPlugin_03", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (number.toString().length() > 55) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u6700\u5927\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc755\u4e2a\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ApprovePlanClassifyPlugin_04", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
            if (name.toString().length() > 55) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u6700\u5927\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc755\u4e2a\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ApprovePlanClassifyPlugin_05", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
            if (!CheckStringsUtil.checkAllowNumStart((String)number.toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u7531\u534a\u89d2\u6570\u5b57\u548c\u534a\u89d2\u5b57\u6bcd\u7ec4\u6210\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ApprovePlanClassifyPlugin_06", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
            if (!this.checkName(name.toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4e2d\u6587\u3001\u82f1\u6587\u6216\u6570\u5b57\u4f5c\u4e3a\u540d\u79f0\u3002", (String)"ApprovePlanClassifyPlugin_07", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!this.isEdit()) {
                QFilter filter = new QFilter("number", "=", number);
                filter.and("model", "=", (Object)this.getModelId());
                Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"eb_cenplanclassifyentity", (QFilter[])filter.toArray());
                if (dynamicObjectMap != null && dynamicObjectMap.size() > 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"ApprovePlanClassifyPlugin_08", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            } else {
                args.setCancel(true);
                this.getModel().setDataChanged(false);
                Object id = this.getModel().getValue("id");
                Object parentid = this.getModel().getValue("parentid");
                DynamicObject dataEntity = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (String)"eb_cenplanclassifyentity");
                dataEntity.set("name", name);
                SaveServiceHelper.update((DynamicObject)dataEntity);
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("id", id);
                map.put("parentid", parentid);
                map.put("name", name);
                this.getView().returnDataToParent(map);
                this.getView().close();
            }
        }
    }

    private boolean checkName(String name) {
        String regex = "^[a-zA-Z0-9\\u4E00-\\u9FA5]{1,50}$";
        boolean ismatch = Pattern.matches(regex, name);
        return ismatch;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"save")) {
            Object id = this.getModel().getValue("id");
            Object parentid = this.getModel().getValue("parentid");
            Object name = this.getModel().getValue("name");
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("id", id);
            map.put("parentid", parentid);
            map.put("name", name);
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }
}

