/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval.approveplan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralapproval.ApproveAdjDimTypeEnum;
import kd.epm.eb.common.centralapproval.entity.ApproveAdjDimDto;
import kd.epm.eb.common.entity.memberF7.BaseF7Parameter;
import kd.epm.eb.common.entity.memberF7.LeftTreeF7Parameter;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.centralapproval.approveplan.helper.DynamicObjectParseHelper;
import org.apache.commons.collections4.CollectionUtils;

public class ApprovePlanDimAdjPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{"entitymember", "accountmember", "userdefinemember"});
    }

    public void afterCreateNewData(EventObject e) {
        this.initDimensionList();
        this.initOrgReferenceFields();
        this.initModifyData();
        this.setFieldVisible();
    }

    private void initModifyData() {
        Object currentSelectedRow = this.getView().getFormShowParameter().getCustomParam("currentSelectedRow");
        if (currentSelectedRow == null) {
            return;
        }
        DynamicObject dynamicObject = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)currentSelectedRow.toString());
        String dimension = dynamicObject.getString("dimension");
        String dimmemlevel = dynamicObject.getString("dimmemlevel");
        String rangetype = dynamicObject.getString("rangetype");
        String orgreferencefield = dynamicObject.getString("orgreferencefield");
        this.getModel().setValue("dimension", (Object)dimension);
        this.initDimMemberLevelCombo(dimension.split("#")[1]);
        this.setBaseDataId(dimension.split("#")[1]);
        this.getModel().setValue("radiogroup", (Object)rangetype);
        this.getModel().setValue("referencefield", (Object)orgreferencefield);
        this.getModel().setValue("dimmemlevel", (Object)dimmemlevel);
        this.getModel().setValue("entitymember", (Object)this.getMemberIds().toArray());
        this.getModel().setValue("accountmember", (Object)this.getMemberIds().toArray());
        this.getModel().setValue("userdefinemember", (Object)this.getMemberIds().toArray());
    }

    private List<Long> getMemberIds() {
        List<Long> result = new ArrayList<Long>(16);
        Object memberIds = this.getView().getFormShowParameter().getCustomParam("memberIds");
        if (memberIds == null) {
            return result;
        }
        result = (List)SerializationUtils.deSerializeFromBase64((String)memberIds.toString());
        return result;
    }

    private void initOrgReferenceFields() {
        List<Map<String, String>> budgetEntityBaseEntityData = DynamicObjectParseHelper.getBudgetEntityBaseEntityData(this.getBillType());
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        String defaultValue = "";
        for (Map<String, String> entityMap : budgetEntityBaseEntityData) {
            for (Map.Entry<String, String> entry : entityMap.entrySet()) {
                String code = entry.getKey();
                String name = entry.getValue();
                if (StringUtils.isEmpty((String)defaultValue)) {
                    defaultValue = code;
                }
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(name));
                comboItem.setValue(code);
                comboItems.add(comboItem);
            }
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("referencefield");
        comboEdit.setComboItems(comboItems);
    }

    private String getBillType() {
        Object billtype = this.getView().getFormShowParameter().getCustomParam("billtype");
        if (billtype == null) {
            return "";
        }
        return billtype.toString().split("#")[0];
    }

    private void initDimensionList() {
        Long businessModelId = this.getBusinessModelId();
        List dimensions = this.getIModelCacheHelper().getDimensionListByBusModel(businessModelId);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        String defaultKey = "";
        String defaultNum = "";
        for (Dimension value : dimensions) {
            String number = value.getNumber();
            ComboItem comboItem = new ComboItem();
            if (!ApproveAdjDimTypeEnum.isAdjDim((String)number)) continue;
            if (StringUtils.isEmpty((String)defaultNum)) {
                defaultNum = number;
            }
            String itemValue = value.getId() + "#" + value.getNumber();
            if (StringUtils.isEmpty((String)defaultKey)) {
                defaultKey = itemValue;
            }
            comboItem.setValue(itemValue);
            comboItem.setCaption(new LocaleString(value.getName()));
            comboItems.add(comboItem);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("dimension");
        comboEdit.setComboItems(comboItems);
        this.getModel().setValue("dimension", (Object)defaultKey);
        this.initDimMemberLevelCombo(defaultNum);
        this.setBaseDataId(defaultNum);
    }

    private String initDimMemberLevelCombo(String dimNumber) {
        ComboEdit dimmemlevel = (ComboEdit)this.getControl("dimmemlevel");
        Set<Integer> levels = this.getAdjDimMemberLevel(dimNumber);
        Map typeOneLevels = ApproveAdjDimTypeEnum.getLevelsByDimNumber((String)dimNumber, levels);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        ArrayList values = new ArrayList(typeOneLevels.keySet());
        if (CollectionUtils.isEmpty(values)) {
            return "";
        }
        String defaultKey = (String)values.get(values.size() - 1);
        for (String string : typeOneLevels.keySet()) {
            if (!StringUtils.equals((String)ApproveAdjDimTypeEnum.TypeOneLevelEnum.SPECIAL.getValue(), (String)string)) continue;
            defaultKey = string;
            break;
        }
        for (Map.Entry entry : typeOneLevels.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(key);
            comboItem.setCaption(new LocaleString(value));
            items.add(comboItem);
        }
        dimmemlevel.setComboItems(items);
        this.getModel().setValue("dimmemlevel", (Object)defaultKey);
        return defaultKey;
    }

    private Set<Integer> getAdjDimMemberLevel(String dimNumber) {
        Long businessModelId = this.getBusinessModelId();
        Map dimViewMap = this.getIModelCacheHelper().getViewsByBusModel(businessModelId);
        HashSet<Integer> result = new HashSet<Integer>(16);
        List members = this.getIModelCacheHelper().getMembers((Long)dimViewMap.get(dimNumber), dimNumber);
        for (Member member : members) {
            this.getMemberAllChildren(member, result);
        }
        return result;
    }

    private void getMemberAllChildren(Member member, Set<Integer> levels) {
        if (member == null) {
            return;
        }
        levels.add(member.getLevel());
        List memberChildren = member.getChildren();
        if (CollectionUtils.isEmpty((Collection)memberChildren)) {
            return;
        }
        for (Member memberChild : memberChildren) {
            this.getMemberAllChildren(memberChild, levels);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((String)operateKey, (String)"btnok")) {
            ApproveAdjDimDto approveAdjDimDto = this.checkMustIn();
            this.getView().returnDataToParent((Object)approveAdjDimDto);
            this.getView().close();
        }
    }

    private ApproveAdjDimDto checkMustIn() {
        ApproveAdjDimDto approveAdjDimDto = new ApproveAdjDimDto();
        String modifyDto = this.getPageCache().get("modifyDto");
        if (modifyDto != null) {
            approveAdjDimDto = (ApproveAdjDimDto)SerializationUtils.deSerializeFromBase64((String)modifyDto);
        }
        Object dimension = this.getModel().getValue("dimension");
        Object rangeType = this.getModel().getValue("radiogroup");
        Object referencefield = this.getModel().getValue("referencefield");
        Object dimmemlevel = this.getModel().getValue("dimmemlevel");
        Object member = this.getModel().getValue("member");
        Object basedataid = this.getModel().getValue("basedataid");
        approveAdjDimDto.setBaseDataId(basedataid.toString());
        if (dimension == null || StringUtils.isEmpty((String)dimension.toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"ApprovePlanDimAdjPlugin_01", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (rangeType == null || StringUtils.isEmpty((String)rangeType.toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6307\u5b9a\u5c42\u7ea7\u6216\u6307\u5b9a\u6210\u5458\u3002", (String)"ApprovePlanDimAdjPlugin_02", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String dimensionStr = dimension.toString();
        approveAdjDimDto.setDimension(dimensionStr);
        String[] split = dimensionStr.split("#");
        String dimId = split[0];
        String dimNum = split[1];
        approveAdjDimDto.setDimId(dimId);
        approveAdjDimDto.setDimNum(dimNum);
        approveAdjDimDto.setRangeType(rangeType.toString());
        ApproveAdjDimTypeEnum typeByDimNumber = ApproveAdjDimTypeEnum.getTypeByDimNumber((String)dimNum);
        if (StringUtils.equals((String)ApproveAdjDimTypeEnum.RangeTypeEnum.RANGE_LEVEL.getValue(), (String)rangeType.toString())) {
            if (typeByDimNumber == ApproveAdjDimTypeEnum.TYPE_TWO) {
                if (referencefield == null || StringUtils.isEmpty((String)referencefield.toString())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53c2\u7167\u5b57\u6bb5\u3002", (String)"ApprovePlanDimAdjPlugin_03", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                String referenceStr = referencefield.toString();
                approveAdjDimDto.setReferenceField(referenceStr);
            }
            if (dimmemlevel == null || StringUtils.isEmpty((String)dimmemlevel.toString())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8c03\u6574\u6210\u5458\u7ea7\u6b21\u3002", (String)"ApprovePlanDimAdjPlugin_04", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            approveAdjDimDto.setDimMemLevel(dimmemlevel.toString());
        } else if (StringUtils.equals((String)ApproveAdjDimTypeEnum.RangeTypeEnum.RANGE_MEMBER.getValue(), (String)rangeType.toString()) && member != null && StringUtils.isNotEmpty((String)member.toString())) {
            List members = (List)SerializationUtils.fromJsonString((String)member.toString(), List.class);
            for (Map map : members) {
                map.put("basedataid", basedataid.toString());
            }
            approveAdjDimDto.setMembers(members);
        }
        return approveAdjDimDto;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (StringUtils.equals((String)name, (String)"dimension")) {
            this.handleDimensionPropChange(e);
            this.setFieldVisible();
        } else if (StringUtils.equals((String)name, (String)"radiogroup")) {
            this.setFieldVisible();
        } else if (StringUtils.equals((String)name, (String)"entitymember") || StringUtils.equals((String)name, (String)"accountmember") || StringUtils.equals((String)name, (String)"userdefinemember")) {
            this.handleMemberPropChange(e);
        }
    }

    private void handleMemberPropChange(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (newValue instanceof DynamicObjectCollection) {
            DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)newValue;
            ArrayList memberMapList = new ArrayList(16);
            for (DynamicObject dynamicObject : dynamicObjects) {
                HashMap<String, String> entity = new HashMap<String, String>(16);
                entity.put("id", dynamicObject.getString("fbasedataid_id"));
                DynamicObject fbasedataid = dynamicObject.getDynamicObject("fbasedataid");
                if (fbasedataid != null) {
                    entity.put("name", fbasedataid.getString("name"));
                }
                memberMapList.add(entity);
            }
            this.getModel().setValue("member", (Object)SerializationUtils.toJsonString(memberMapList));
        }
    }

    private void setFieldVisible() {
        Object dimension = this.getModel().getValue("dimension");
        if (dimension == null) {
            return;
        }
        String selectedDimension = dimension.toString();
        if (StringUtils.isEmpty((String)selectedDimension)) {
            return;
        }
        String[] split = selectedDimension.split("#");
        String dimensionNum = split[1];
        ApproveAdjDimTypeEnum typeByDimNumber = ApproveAdjDimTypeEnum.getTypeByDimNumber((String)dimensionNum);
        if (typeByDimNumber == ApproveAdjDimTypeEnum.TYPE_ONE) {
            this.setTypeOneVisible();
        } else if (typeByDimNumber == ApproveAdjDimTypeEnum.TYPE_TWO) {
            this.setTypeTwoVisible();
        }
    }

    private void setTypeOneVisible() {
        Object rangeTypeObj = this.getModel().getValue("radiogroup");
        if (rangeTypeObj == null) {
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"entitymember", "accountmember", "userdefinemember", "referencefield", "dimmemlevel"});
        String rangeType = rangeTypeObj.toString();
        if (StringUtils.equals((String)ApproveAdjDimTypeEnum.RangeTypeEnum.RANGE_LEVEL.getValue(), (String)rangeType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"dimmemlevel"});
        } else if (StringUtils.equals((String)ApproveAdjDimTypeEnum.RangeTypeEnum.RANGE_MEMBER.getValue(), (String)rangeType)) {
            Object dimension = this.getModel().getValue("dimension");
            if (dimension == null) {
                return;
            }
            String selectedDimension = dimension.toString();
            if (StringUtils.isEmpty((String)selectedDimension)) {
                return;
            }
            String[] split = selectedDimension.split("#");
            String dimensionNum = split[1];
            if (StringUtils.equals((String)SysDimensionEnum.Entity.getNumber(), (String)dimensionNum)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"entitymember"});
            } else if (StringUtils.equals((String)SysDimensionEnum.Account.getNumber(), (String)dimensionNum)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"accountmember"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"userdefinemember"});
            }
            this.setBaseDataId(dimensionNum);
        }
    }

    private void setTypeTwoVisible() {
        Object rangeTypeObj = this.getModel().getValue("radiogroup");
        if (rangeTypeObj == null) {
            return;
        }
        String rangeType = rangeTypeObj.toString();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"entitymember", "accountmember", "userdefinemember", "referencefield", "dimmemlevel"});
        if (StringUtils.equals((String)ApproveAdjDimTypeEnum.RangeTypeEnum.RANGE_LEVEL.getValue(), (String)rangeType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"dimmemlevel", "referencefield"});
        } else if (StringUtils.equals((String)ApproveAdjDimTypeEnum.RangeTypeEnum.RANGE_MEMBER.getValue(), (String)rangeType)) {
            Object dimension = this.getModel().getValue("dimension");
            if (dimension == null) {
                return;
            }
            String selectedDimension = dimension.toString();
            if (StringUtils.isEmpty((String)selectedDimension)) {
                return;
            }
            String[] split = selectedDimension.split("#");
            String dimensionNum = split[1];
            if (StringUtils.equals((String)SysDimensionEnum.Entity.getNumber(), (String)dimensionNum)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"entitymember"});
            } else if (StringUtils.equals((String)SysDimensionEnum.Account.getNumber(), (String)dimensionNum)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"accountmember"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"userdefinemember"});
            }
        }
    }

    private void handleDimensionPropChange(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (newValue != null) {
            String dimIdAndNumber = newValue.toString();
            String[] split = dimIdAndNumber.split("#");
            String dimNumber = split[1];
            this.setBaseDataId(dimNumber);
            String defaultKey = this.initDimMemberLevelCombo(dimNumber);
            this.getModel().setValue("dimmemlevel", (Object)defaultKey, rowIndex);
        }
    }

    private void setBaseDataId(String dimNumber) {
        if (StringUtils.equals((String)SysDimensionEnum.Account.getNumber(), (String)dimNumber)) {
            this.getModel().setValue("basedataid", (Object)"epm_accountmembertree");
        } else if (StringUtils.equals((String)SysDimensionEnum.Entity.getNumber(), (String)dimNumber)) {
            this.getModel().setValue("basedataid", (Object)"epm_entitymembertree");
        } else {
            this.getModel().setValue("basedataid", (Object)"epm_userdefinedmembertree");
        }
    }

    private Long getBusinessModelId() {
        Object businessModelId = this.getView().getFormShowParameter().getCustomParam("businessModelId");
        if (!(businessModelId instanceof Long)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"ApprovePlanDimAdjPlugin_05", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return Long.parseLong(businessModelId.toString());
    }

    private Long getViewId(String dimNumber) {
        Long businessModelId = this.getBusinessModelId();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)businessModelId, (String)"eb_businessmodel");
        long dataSetId = dynamicObject.getLong("id");
        return DimensionViewServiceHelper.getViewId((Long)dataSetId, (String)dimNumber);
    }

    @Override
    public Long getModelId() {
        Object modelId = this.getView().getFormShowParameter().getCustomParam("modelId");
        if (!(modelId instanceof Long)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ApprovePlanDimAdjPlugin_06", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return Long.parseLong(modelId.toString());
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Object dimension;
        String name = beforeF7SelectEvent.getProperty().getName();
        if (name.endsWith("member") && (dimension = this.getModel().getValue("dimension")) != null && StringUtils.isNotEmpty((String)dimension.toString())) {
            String dimStr = dimension.toString();
            String dimId = dimStr.split("#")[0];
            String dimNumber = dimStr.split("#")[1];
            QFilter filter = new QFilter("dimension", "=", (Object)Long.parseLong(dimId));
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setMultiSelect(true);
            LeftTreeF7Parameter leftTreeF7Parameter = new LeftTreeF7Parameter();
            leftTreeF7Parameter.setKeepTree(true);
            leftTreeF7Parameter.setViewId(this.getViewId(dimNumber));
            this.switchF7(beforeF7SelectEvent, this.getBusinessModelId(), (BaseF7Parameter)leftTreeF7Parameter);
        }
    }

    public String getCurrentDimNumber(String controlKey) {
        Object dimension = this.getModel().getValue("dimension");
        if (dimension != null && StringUtils.isNotEmpty((String)dimension.toString())) {
            String dimStr = dimension.toString();
            return dimStr.split("#")[1];
        }
        return null;
    }
}

