/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval.approveplan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.formplugin.AbstractListPlugin;
import org.apache.commons.collections.CollectionUtils;

public class CentralSchemeF7ListPlugin
extends AbstractListPlugin {
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    static class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int end) {
            DynamicObjectCollection rows = super.getData(start, end);
            DynamicObjectCollection result = new DynamicObjectCollection();
            if (rows == null || rows.size() == 0) {
                return rows;
            }
            HashMap<String, List> accountNameMap = new HashMap<String, List>(16);
            HashMap<String, List> entityNameMap = new HashMap<String, List>(16);
            ArrayList<Long> ids = new ArrayList<Long>(16);
            for (Object row : rows) {
                long id = row.getLong("id");
                ids.add(id);
            }
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)"eb_centralscheme");
            for (DynamicObject row : rows) {
                String number = row.getString("number");
                long id = row.getLong("id");
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectMap.get(id);
                DynamicObjectCollection accountEntry = dynamicObject.getDynamicObjectCollection("entryentity1");
                for (DynamicObject object : accountEntry) {
                    DynamicObject account = object.getDynamicObject("accountnumber");
                    if (account == null) continue;
                    String accountName = account.getString("name");
                    List accountNames = accountNameMap.computeIfAbsent(number, t -> new ArrayList(16));
                    accountNames.add(accountName);
                }
                DynamicObjectCollection entityEntry = dynamicObject.getDynamicObjectCollection("entryentity2");
                for (DynamicObject object : entityEntry) {
                    DynamicObject entity = object.getDynamicObject("entitynumber1");
                    if (entity == null) continue;
                    String entityName = entity.getString("name");
                    List entityNames = entityNameMap.computeIfAbsent(number, t -> new ArrayList(16));
                    entityNames.add(entityName);
                }
            }
            HashMap<String, DynamicObject> resultMap = new HashMap<String, DynamicObject>(16);
            for (DynamicObject row : rows) {
                String number = row.getString("number");
                DynamicObject dynamicObject = resultMap.computeIfAbsent(number, t -> row);
                List accountNames = (List)accountNameMap.get(number);
                List entityNames = (List)entityNameMap.get(number);
                if (CollectionUtils.isNotEmpty((Collection)accountNames)) {
                    if (!((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)"accountnames")) continue;
                    dynamicObject.set("accountnames", (Object)String.join((CharSequence)";", accountNames));
                }
                if (!CollectionUtils.isNotEmpty((Collection)entityNames) || !((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)"entitynames")) continue;
                dynamicObject.set("entitynames", (Object)String.join((CharSequence)";", entityNames));
            }
            result.addAll(resultMap.values());
            return result;
        }
    }
}

