/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralaudit;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.OperateOptionPrivate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.utils.WorkFlowUtil;
import kd.epm.eb.common.approveBill.CentralBillRptSubmitHelper;
import kd.epm.eb.common.approveBill.Entity.ApproveBillInfo;
import kd.epm.eb.common.approveBill.Entity.ApproveBillStatus;
import kd.epm.eb.common.approveBill.Entity.CentralBillType;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.approveBill.ApproveOptimization;
import kd.epm.eb.formplugin.centralaudit.CentralOptimization;

public class CentralApproveListPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static final Log log = LogFactory.getLog(CentralApproveListPlugin.class);
    private Map<Long, List<Long>> approveMap;
    private Map<String, String> tempName;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        boolean openAll = Convert.toBool(customParams.get("openAll"));
        if (openAll) {
            this.loadReportPanelData();
        } else {
            this.loadListPanelData();
        }
    }

    private void loadReportPanelData() {
        this.loadReportPanelData(this.getApproveMap());
    }

    private void loadReportPanelData(Map<Long, List<Long>> processBillMap) {
        if (processBillMap.size() == 0) {
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"listpanel"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"billpanel"});
        if (this.isFirstLoad()) {
            this.loadMainApproveBill(processBillMap);
        } else {
            this.invokeChildOperation("open", SerializationUtils.toJsonString(processBillMap));
        }
    }

    private void loadMainApproveBill(Map<Long, List<Long>> processBillMap) {
        ArrayList billIds = new ArrayList(16);
        processBillMap.forEach((key, value) -> billIds.addAll(value));
        log.info("CentralApproveListPlugin_bills: {}", new HashSet(billIds));
        if (billIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5ba1\u6279\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u67e5\u770b\u5f52\u53e3\u62a5\u8868\u5931\u8d25\u3002", (String)"CentralApproveListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long curBill = (Long)billIds.get(0);
        Map parentApproveBills = ApproveBillHelper.getParentApproveBills((Set)Sets.newHashSet((Object[])new Long[]{curBill}));
        if ((Long)parentApproveBills.get(curBill) != 0L) {
            curBill = (Long)parentApproveBills.get(curBill);
        }
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("formId", "eb_approvebill");
        map.put("pkId", String.valueOf(curBill));
        FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(map);
        HashMap<String, String> definedCustoms = new HashMap<String, String>(16);
        definedCustoms.put(CentralOptimization.PROCESS_BILL_MAP, SerializationUtils.toJsonString(processBillMap));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        boolean openAll = Convert.toBool(customParams.get("openAll"));
        definedCustoms.put(CentralOptimization.CENTRAL_LIST_OPEN_ALL, String.valueOf(openAll));
        formShowParameter.setCustomParam(CentralOptimization.DEFINED_CUSTOMS, (Object)SerializationUtils.toJsonString(definedCustoms));
        formShowParameter.setCustomParam(CentralOptimization.FROM_CENTRAL_LIST, (Object)true);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("billpanel");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close"));
        this.getView().showForm(formShowParameter);
        String pageId = formShowParameter.getPageId();
        this.putCache("childPage", pageId);
    }

    private void loadListPanelData() {
        this.getModel().deleteEntryData("entryentity");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"billpanel"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"listpanel"});
        Map<Long, List<Long>> approveMap = this.getApproveMap();
        if (approveMap.size() == 0) {
            return;
        }
        HashSet processIds = new HashSet(16);
        HashSet<Long> bills = new HashSet<Long>(16);
        approveMap.forEach((key, value) -> {
            processIds.add(key);
            bills.addAll((Collection<Long>)value);
        });
        Map processInfos = ApproveUtils.getInstance().getTemplateInfoByProcessIds(processIds);
        Map approveBillInfoMap = ApproveBillHelper.loadBillInfo((QFilter[])new QFilter[]{new QFilter("id", "in", bills)});
        Map<Long, String> auditors = this.getCentralAuditors(bills);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Dimension dimension = modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber());
        String searchText = (String)this.getCache("searchText", String.class);
        Map notSubmitRptProcessIds = CentralBillRptSubmitHelper.getNotSubmitRptProcessIds(bills);
        for (Map.Entry<Long, List<Long>> entry : approveMap.entrySet()) {
            Long process = entry.getKey();
            BasedataPojo templateInfo = (BasedataPojo)processInfos.get(process);
            if (templateInfo == null) continue;
            List<Long> approveBills = entry.getValue();
            for (Long approveBill : approveBills) {
                ApproveBillInfo approveBillInfo = (ApproveBillInfo)approveBillInfoMap.get(approveBill);
                if (approveBillInfo == null) continue;
                Long centralOrgId = approveBillInfo.getCentralOrgId();
                Member member = dimension.getMember(approveBillInfo.getOrgViewId(), centralOrgId);
                if (member == null) continue;
                String name = String.format("%s\u3010%s\u3011", templateInfo.getName(), member.getName());
                String number = String.format("%s\u3010%s\u3011", templateInfo.getNumber(), member.getNumber());
                if (StringUtils.isNotEmpty((String)searchText) && !number.contains(searchText) && !name.contains(searchText)) continue;
                String status = approveBillInfo.getBillStatus();
                Set _notSubmitRptProcessIds = notSubmitRptProcessIds.getOrDefault(approveBill, new HashSet(16));
                if (CentralBillType.Child == approveBillInfo.getCentralBillType() && BgTaskStateEnum.INCOMPLETE.getNumber().equals(approveBillInfo.getStatus4Rpt()) && !_notSubmitRptProcessIds.contains(process)) {
                    status = ApproveBillStatus.SUBMIT.getNumber();
                }
                int curIndex = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("number", (Object)number, curIndex);
                this.getModel().setValue("reportname", (Object)name, curIndex);
                this.getModel().setValue("status", (Object)status, curIndex);
                this.getModel().setValue("entity", (Object)member.getId(), curIndex);
                this.getModel().setValue("auditor", (Object)auditors.getOrDefault(approveBill, ""), curIndex);
                this.getModel().setValue("process", (Object)process, curIndex);
                this.getModel().setValue("approvebill", (Object)approveBill, curIndex);
            }
        }
    }

    private Map<Long, String> getCentralAuditors(Set<Long> bills) {
        HashMap<Long, String> auditorMap = new HashMap<Long, String>(16);
        if (bills == null || bills.size() == 0) {
            return auditorMap;
        }
        for (Long bill : bills) {
            String businessKey = String.valueOf(bill);
            List auditors = WorkflowServiceHelper.getApproverByBusinessKey((String)businessKey);
            if (auditors.size() == 0) {
                List allApprovalRecord = WorkFlowUtil.getAllApprovalRecord((String)businessKey);
                for (int i = allApprovalRecord.size() - 1; i >= 0; --i) {
                    List children;
                    IApprovalRecordGroup approvalRecordGroup = (IApprovalRecordGroup)allApprovalRecord.get(i);
                    String groupDecisionType = approvalRecordGroup.getGroupDecisionType();
                    if ("wait".equals(groupDecisionType) || "submit".equals(groupDecisionType) || (children = approvalRecordGroup.getChildren()) == null || children.size() == 0) continue;
                    for (IApprovalRecordItem child : children) {
                        Long userId = child.getUserId();
                        if (userId == null) continue;
                        auditors.add(userId);
                    }
                    break;
                }
            }
            List userInfoByID = UserServiceHelper.getUserInfoByID((List)auditors);
            List userNames = userInfoByID.stream().map(e -> e.getOrDefault("name", "").toString()).collect(Collectors.toList());
            auditorMap.put(bill, String.join((CharSequence)";", userNames));
        }
        return auditorMap;
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_open": {
                this.loadReportPanelData(this.getSelectedData());
                break;
            }
            case "btn_approve": {
                ApproveOptimization.getInstance().batchApprove(this.getView(), "entryentity", this.getPluginName(), this.getModelId());
                break;
            }
            case "btn_export": {
                this.exportData();
                break;
            }
            case "btn_downloadlist": {
                ApproveOptimization.getInstance().openDownloadPage(this.getView(), this.getModelId());
                break;
            }
            case "btn_viewopinion": {
                Long processId = ApproveOptimization.getInstance().getSelectReportId(this.getView(), "entryentity");
                if (processId == null) {
                    return;
                }
                ApproveOptimization.getInstance().viewApproveOpinion(this.getView(), processId, (Long)this.getFocusEntryValue("entryentity", "approvebill", "id"), this.getModelId(), this.getPluginName(), null);
                break;
            }
            case "btn_viewchart": {
                this.viewFlowChart(this.getSelectedData());
                break;
            }
            case "btn_refresh": {
                this.loadListPanelData();
                break;
            }
            case "btn_submit": {
                this.batchSubmit(this.getSelectedData());
                this.loadListPanelData();
                break;
            }
        }
    }

    private void viewFlowChart(Map<Long, List<Long>> selectedData) {
        if (selectedData.size() == 0) {
            return;
        }
        HashSet bills = new HashSet(16);
        selectedData.values().forEach(bills::addAll);
        if (bills.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u5c5e\u4e00\u5f20\u5355\u636e\u7684\u62a5\u8868\u3002", (String)"", (String)"", (Object[])new Object[0]));
            return;
        }
        WorkflowServiceHelper.viewFlowchart((String)this.getView().getPageId(), bills.iterator().next());
    }

    private void batchSubmit(Map<Long, List<Long>> selectedData) {
        if (selectedData.size() == 0) {
            return;
        }
        HashMap processBillMap = new HashMap(16);
        HashSet bills = new HashSet(16);
        HashSet processIds = new HashSet(16);
        selectedData.forEach((key, value) -> {
            processIds.add(key);
            bills.addAll(value);
            value.forEach(e -> {
                List _processIds = processBillMap.computeIfAbsent(e, k -> new ArrayList(16));
                _processIds.add(key);
            });
        });
        Map notSubmitRptProcessIds = CentralBillRptSubmitHelper.getNotSubmitRptProcessIds(bills);
        HashMap<Long, Set> toSubmitRptProcessIds = new HashMap<Long, Set>(16);
        Map approveBillInfoMap = ApproveBillHelper.loadBillInfo((QFilter[])new QFilter[]{new QFilter("id", "in", bills)});
        Map processRefTemplateName = ApproveUtils.getInstance().getProcessRefTemplateName(processIds);
        HashMap<String, String> errMessages = new HashMap<String, String>(16);
        HashMap successInfos = new HashMap(16);
        HashSet successInfo = new HashSet(16);
        for (Map.Entry entry : processBillMap.entrySet()) {
            List _processIds;
            Long l = (Long)entry.getKey();
            ApproveBillInfo approveBillInfo = (ApproveBillInfo)approveBillInfoMap.get(l);
            if (approveBillInfo == null || (_processIds = (List)entry.getValue()) == null) continue;
            for (Long processId : _processIds) {
                String name = this.getTemplateName(approveBillInfo, processRefTemplateName, processId);
                Set notSubmitProcessIds = (Set)notSubmitRptProcessIds.get(l);
                if (!ApproveBillStatus.REJECT.getNumber().equals(approveBillInfo.getBillStatus()) && !ApproveBillStatus.SAVE.getNumber().equals(approveBillInfo.getBillStatus()) || !BgTaskStateEnum.INCOMPLETE.getNumber().equals(approveBillInfo.getStatus4Rpt()) && !BgTaskStateEnum.UNPREPARED.getNumber().equals(approveBillInfo.getStatus4Rpt()) && !BgTaskStateEnum.TEMPSAVE.getNumber().equals(approveBillInfo.getStatus4Rpt()) || notSubmitProcessIds == null || notSubmitProcessIds.size() == 0 || !notSubmitProcessIds.contains(processId)) {
                    errMessages.put(name, ResManager.loadKDString((String)"\u62a5\u8868\u5df2\u63d0\u4ea4\u6216\u5df2\u5b8c\u6210\uff0c\u4e0d\u9700\u8981\u63d0\u4ea4", (String)"CommitCheck_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    continue;
                }
                Set toSubmitProcessIds = toSubmitRptProcessIds.computeIfAbsent(l, k -> new HashSet(16));
                toSubmitProcessIds.add(processId);
            }
        }
        ArrayList<Long> toSubmitBills = new ArrayList<Long>(16);
        for (Map.Entry entry : toSubmitRptProcessIds.entrySet()) {
            ApproveBillInfo approveBillInfo;
            Long billId = (Long)entry.getKey();
            Set toSubmitProcessIds = (Set)entry.getValue();
            Set notSubmitProcessIds = (Set)notSubmitRptProcessIds.get(billId);
            if (notSubmitProcessIds == null || (approveBillInfo = (ApproveBillInfo)approveBillInfoMap.get(billId)) == null) continue;
            if (toSubmitProcessIds.containsAll(notSubmitProcessIds)) {
                toSubmitBills.add(billId);
                continue;
            }
            CentralBillRptSubmitHelper.markRptSubmit((Long)billId, (Collection)toSubmitProcessIds);
            toSubmitProcessIds.forEach(e -> successInfo.add(this.getTemplateName(billId, (Long)e)));
        }
        if (toSubmitBills.size() != 0) {
            OperateOption op = OperateOption.create();
            op.setVariableValue("fromApprove", "true");
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"eb_approvebill", (Object[])toSubmitBills.toArray(), (OperateOption)op);
            if (!operationResult.isSuccess()) {
                List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
                boolean existErr = false;
                for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                    Long billId = ConvertUtils.toLong((Object)iOperateInfo.getPkValue());
                    Set toSubmitProcessIds = toSubmitRptProcessIds.getOrDefault(billId, new HashSet(16));
                    toSubmitProcessIds.forEach(e -> errMessages.put(this.getTemplateName(billId, (Long)e), iOperateInfo.getMessage()));
                    existErr = true;
                }
                if (!existErr && StringUtils.isNotEmpty((String)operationResult.getMessage())) {
                    for (Long toSubmitBill : toSubmitBills) {
                        Set toSubmitProcessIds = toSubmitRptProcessIds.getOrDefault(toSubmitBill, new HashSet(16));
                        toSubmitProcessIds.forEach(e -> errMessages.put(this.getTemplateName(toSubmitBill, (Long)e), operationResult.getMessage()));
                    }
                }
            } else {
                for (Long toSubmitBill : toSubmitBills) {
                    Set toSubmitProcessIds = toSubmitRptProcessIds.getOrDefault(toSubmitBill, new HashSet(16));
                    toSubmitProcessIds.forEach(e -> successInfo.add(this.getTemplateName(toSubmitBill, (Long)e)));
                }
            }
        }
        if (successInfo.size() != 0) {
            successInfos.put(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"", (String)"", (Object[])new Object[0]), successInfo);
        }
        String opName = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"", (String)"", (Object[])new Object[0]);
        CentralAppBillService.getInstance().showOperationResult(opName, successInfos, errMessages, this.getView(), this.getPluginName());
    }

    private String getTemplateName(ApproveBillInfo approveBillInfo, Map<Long, String> processRefTemplateName, Long processId) {
        String signKey;
        String name;
        if (this.tempName == null) {
            this.tempName = new HashMap<String, String>(16);
        }
        if (StringUtils.isEmpty((String)(name = this.tempName.getOrDefault(signKey = approveBillInfo.getBillId() + "!" + processId, "")))) {
            Long centralOrgId = approveBillInfo.getCentralOrgId();
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            Dimension dimension = modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber());
            Member member = dimension.getMember(approveBillInfo.getOrgViewId(), centralOrgId);
            if (member != null) {
                name = String.format("%s\u3010%s\u3011", processRefTemplateName.getOrDefault(processId, ""), member.getName());
            }
            this.tempName.put(signKey, name);
        }
        return name;
    }

    private String getTemplateName(Long approveBillId, Long processId) {
        if (this.tempName == null) {
            return "";
        }
        String signKey = approveBillId + "!" + processId;
        return this.tempName.getOrDefault(signKey, "");
    }

    private void exportData() {
        Map<Long, List<Long>> selectedData = this.getSelectedData();
        if (selectedData.size() == 0) {
            return;
        }
        HashMap processBillMap = new HashMap(16);
        selectedData.forEach((key, value) -> value.forEach(e -> {
            List _processIds = processBillMap.computeIfAbsent(e, k -> new ArrayList(16));
            _processIds.add(key);
        }));
        if (processBillMap.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u5c5e\u4e00\u5f20\u5355\u636e\u7684\u62a5\u8868\u3002", (String)"", (String)"", (Object[])new Object[0]));
            return;
        }
        Map.Entry next = processBillMap.entrySet().iterator().next();
        ApproveOptimization.getInstance().openExportPageFromList(this.getView(), new CloseCallBack((IFormPlugin)this, "reportExportAddActionId"), (Long)next.getKey(), (List)next.getValue(), this.getModelId());
    }

    private Map<Long, List<Long>> getSelectedData() {
        LinkedHashMap<Long, List<Long>> selectedData = new LinkedHashMap<Long, List<Long>>(16);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        if (selectedRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u64cd\u4f5c\u6570\u636e", (String)"", (String)"", (Object[])new Object[0]));
            return selectedData;
        }
        for (int selectedRow : selectedRows) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", selectedRow);
            long processId = rowEntity.getLong("process.id");
            List approveBills = selectedData.computeIfAbsent(processId, k -> new ArrayList());
            approveBills.add(rowEntity.getLong("approvebill.id"));
        }
        return selectedData;
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        super.hyperLinkClick(hyperLinkClickEvent);
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        Long processId = (Long)this.getEntryValue("process", "id", rowIndex);
        Long approveBillId = (Long)this.getEntryValue("approvebill", "id", rowIndex);
        HashMap<Long, List<Long>> selectedData = new HashMap<Long, List<Long>>(16);
        selectedData.put(processId, Collections.singletonList(approveBillId));
        this.loadReportPanelData(selectedData);
    }

    @Override
    public Long getModelId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object model = formShowParameter.getCustomParam("model");
        return ConvertUtils.toLong((Object)model);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String text = searchEnterEvent.getText();
        this.putCache("searchText", text);
        this.loadListPanelData();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("close".equals(actionId)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            boolean openAll = Convert.toBool(customParams.get("openAll"));
            if (openAll) {
                this.getView().close();
            } else {
                this.putCache("firstLoad", Boolean.TRUE);
                this.loadListPanelData();
            }
        } else if ("reportExportAddActionId".equals(actionId)) {
            ApproveOptimization.getInstance().handleCloseCallback(this.getView(), this.getModelId(), closedCallBackEvent.getReturnData());
        } else if ("btn_batchapprove".equals(actionId) && ApproveOptimization.getInstance().isApproveConfirm(closedCallBackEvent.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5ba1\u6279\u6210\u529f", (String)"ReportPreparationListPlugin_46", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.loadListPanelData();
        }
    }

    private Map<Long, List<Long>> getApproveMap() {
        Map customParams;
        Object approveMapJson;
        if (this.approveMap == null && (approveMapJson = (customParams = this.getView().getFormShowParameter().getCustomParams()).get("approveMap")) != null) {
            this.approveMap = (Map)SerializationUtils.deSerializeFromBase64((String)approveMapJson.toString());
            if (this.approveMap == null) {
                this.approveMap = new HashMap<Long, List<Long>>(16);
            }
        }
        return this.approveMap;
    }

    private IFormView getChildView() {
        String childPageId = (String)this.getCache("childPage", String.class);
        return this.getView().getView(childPageId);
    }

    private void invokeChildOperation(String opKey, String param) {
        IFormView childView = this.getChildView();
        if (childView == null) {
            return;
        }
        OperateOptionPrivate optionPrivate = new OperateOptionPrivate();
        optionPrivate.setVariableValue(CentralOptimization.EPM_OP_PARAM, param);
        optionPrivate.setVariableValue("epm_op", opKey);
        childView.invokeOperation("app_optimize", (OperateOption)optionPrivate);
        this.getView().sendFormAction(childView);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (!"app_optimize".equals(operateKey)) {
            return;
        }
        Donothing operate = (Donothing)afterDoOperationEventArgs.getSource();
        OperateOption option = operate.getOption();
        String opKey = option.getVariableValue("epm_op");
        if (CentralOptimization.SHOW_CENTRAL_LIST.equals(opKey)) {
            this.loadListPanelData();
        }
    }

    private boolean isFirstLoad() {
        Boolean firstLoad = (Boolean)this.getCache("firstLoad", Boolean.class, () -> true);
        if (firstLoad.booleanValue()) {
            this.putCache("firstLoad", Boolean.FALSE);
        }
        return firstLoad;
    }
}

