/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralaudit;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.OperateOptionPrivate;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.common.approveBill.Entity.ApproveBillInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;

public class CentralOptimization {
    private static final CentralOptimization instance = new CentralOptimization();
    public static String CENTRAL_BILL_LIST = "centralBillList";
    public static String PROCESS_BILL_MAP = "processBillMap";
    public static String CENTRAL_LIST_OPEN_ALL = "centralOpenAll";
    public static String DEFINED_CUSTOMS = "definedCustoms";
    public static String FROM_CENTRAL_LIST = "formCentralList";
    public static String EPM_OP_PARAM = "epm_op_param";
    public static String SHOW_CENTRAL_LIST = "showCentralList";
    public static String CENTRAL_BILL = "centralBill";

    public static CentralOptimization getInstance() {
        return instance;
    }

    public void openCentralApproveList(IFormView view, Map<String, String> billMap, String pluginName, Long modelId, boolean openAll) {
        HashMap<Long, Long> approveBillMap = new HashMap<Long, Long>(16);
        billMap.forEach((key, value) -> approveBillMap.put(ConvertUtils.toLong((Object)key), ConvertUtils.toLong((Object)value)));
        this.openCentralApproveList(view, modelId, approveBillMap, pluginName, openAll);
    }

    public void openCentralApproveList(IFormView view, Long modelId, Map<Long, Long> approveBillMap, String pluginName, boolean openAll) {
        Map<Long, List<Long>> approveMap = this.getAllRefCentralBillMap(approveBillMap);
        this.openCentralApproveList(view, approveMap, modelId, pluginName, openAll);
    }

    public void openCentralApproveList(IFormView view, Map<Long, List<Long>> approveMap, Long modelId, String pluginName, boolean openAll) {
        if (approveMap == null || approveMap.size() == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u8868\u672a\u5173\u8054\u5f52\u53e3\u5ba1\u6279\u8868", (String)"CentralOptimization_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_centralapprovelist");
        formShowParameter.setCustomParam("model", (Object)modelId);
        formShowParameter.setCustomParam("approveMap", (Object)SerializationUtils.serializeToBase64(approveMap));
        formShowParameter.setCustomParam("openAll", (Object)String.valueOf(openAll));
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCloseCallBack(new CloseCallBack(pluginName, CENTRAL_BILL_LIST));
        if (openAll) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u9884\u7b97\u5ba1\u6838", (String)"CentralOptimization_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        view.showForm(formShowParameter);
    }

    public Map<Long, List<Long>> getAllRefCentralBillMap(Map<Long, Long> approveBillMap) {
        HashMap<Long, List<Long>> approveMap = new HashMap<Long, List<Long>>(16);
        Collection<Long> bills = approveBillMap.values();
        Map tmp = ApproveUtils.getInstance().getApproveRefReportProcessInfo(bills);
        HashMap<Long, Long> approveBillMap_new = new HashMap<Long, Long>(16);
        tmp.forEach((key, value) -> {
            Long bill = (Long)approveBillMap.get(key);
            if (bill != null && bill.equals(value.getApproveBillId())) {
                approveBillMap_new.put((Long)key, bill);
            }
        });
        Map subApproveBillLists = ApproveBillHelper.getSubApproveBillLists(new HashSet(approveBillMap_new.values()), (boolean)false);
        Map processRefTemplateInfo = ApproveUtils.getInstance().getProcessRefTemplateInfo(approveBillMap_new.keySet());
        approveBillMap_new.forEach((key, value) -> {
            List approveBillInfos = (List)subApproveBillLists.get(value);
            if (approveBillInfos != null && approveBillInfos.size() != 0) {
                Long template = processRefTemplateInfo.getOrDefault(key, 0L);
                List filterBills = ApproveUtils.getInstance().getFilterBills(approveBillInfos, template);
                List collect = filterBills.stream().map(ApproveBillInfo::getBillId).collect(Collectors.toList());
                if (collect.size() != 0) {
                    approveMap.put((Long)key, collect);
                }
            }
        });
        return approveMap;
    }

    public Map<String, Object> getAdjustRecords(Set<Long> bills, Set<Long> userIds, Set<String> nodeIds) {
        return new HashMap<String, Object>(16);
    }

    public void addCentralParams(IFormView view, FormShowParameter formShowParameter) {
        Map customParams = view.getFormShowParameter().getCustomParams();
        Boolean fromCentralList = Convert.toBool(customParams.get(FROM_CENTRAL_LIST), (Boolean)false);
        if (fromCentralList.booleanValue()) {
            formShowParameter.setCustomParam(FROM_CENTRAL_LIST, customParams.get(FROM_CENTRAL_LIST));
            formShowParameter.setCustomParam(DEFINED_CUSTOMS, customParams.get(DEFINED_CUSTOMS));
        }
    }

    public boolean isFromCentralList(IFormView view) {
        Map customParams = view.getFormShowParameter().getCustomParams();
        return Convert.toBool(customParams.get(FROM_CENTRAL_LIST), (Boolean)false);
    }

    public Map<String, List<Long>> getProcessBillMap(IFormView view) {
        String customParam;
        HashMap<String, List<Long>> processBillMap = new HashMap<String, List<Long>>(16);
        String processBillMapJson = view.getPageCache().get(PROCESS_BILL_MAP);
        if (StringUtils.isEmpty((String)processBillMapJson) && StringUtils.isNotEmpty((String)(customParam = (String)view.getFormShowParameter().getCustomParam(DEFINED_CUSTOMS)))) {
            Map definedCustoms = (Map)SerializationUtils.fromJsonString((String)customParam, HashMap.class);
            processBillMapJson = definedCustoms.getOrDefault(PROCESS_BILL_MAP, "");
        }
        if (StringUtils.isNotEmpty((String)processBillMapJson)) {
            processBillMap.putAll((Map)SerializationUtils.fromJsonString((String)processBillMapJson, HashMap.class));
        }
        return processBillMap;
    }

    public boolean isCentralOpenAll(IFormView view) {
        String customParam = (String)view.getFormShowParameter().getCustomParam(DEFINED_CUSTOMS);
        if (StringUtils.isNotEmpty((String)customParam)) {
            Map definedCustoms = (Map)SerializationUtils.fromJsonString((String)customParam, HashMap.class);
            return Convert.toBool(definedCustoms.get(CENTRAL_LIST_OPEN_ALL), (Boolean)false);
        }
        return false;
    }

    public Map<Long, String> getCentralBillEntityMap(Set<Long> centralBills, Long modelId) {
        HashMap<Long, String> centralEntityMap = new HashMap<Long, String>(16);
        QFilter qFilter = new QFilter("id", "in", centralBills);
        Map approveBillInfoMap = ApproveBillHelper.loadBillInfo((QFilter[])new QFilter[]{qFilter});
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber());
        for (Map.Entry entry : approveBillInfoMap.entrySet()) {
            Long processId = (Long)entry.getKey();
            ApproveBillInfo billInfo = (ApproveBillInfo)entry.getValue();
            Long centralOrgId = billInfo.getCentralOrgId();
            Member member = dimension.getMember(billInfo.getOrgViewId(), centralOrgId);
            if (member == null) continue;
            centralEntityMap.put(processId, member.getName());
        }
        return centralEntityMap;
    }

    public void invokeParentOperation(String operateKey, IFormView view, boolean needCheckAudit) {
        if (needCheckAudit && !ApproveUtils.getInstance().isFromAuditPage(view)) {
            return;
        }
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return;
        }
        OperateOptionPrivate op = new OperateOptionPrivate();
        op.setVariableValue("epm_op", operateKey);
        parentView.invokeOperation("app_optimize", (OperateOption)op);
        view.sendFormAction(parentView);
    }
}

