/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralized;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.cache.control.BgControlCache;
import kd.epm.eb.common.central.CentralizedServiceImpl;
import kd.epm.eb.common.central.ContralCell;
import kd.epm.eb.common.central.ContralVO;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class CentralControlAddVersion2
extends AbstractBasePlugin
implements BeforeF7SelectListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String TARGETENTITY = "targetentity";
    private static final String SOURCERANGE = "sourcerange";
    private static final String CONTROLPARAM = "controlparam";
    private static CentralizedServiceImpl centralizedService = CentralizedServiceImpl.getInstance();

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SOURCERANGE, "btn_save", "orgrange", "btn_addrow", "btn_delrow"});
        BasedataEdit accounts = (BasedataEdit)this.getView().getControl("accounts");
        accounts.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dimension = (BasedataEdit)this.getView().getControl("dimension");
        dimension.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bussmodel = (BasedataEdit)this.getView().getControl("bussmodel");
        bussmodel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit targetentity = (BasedataEdit)this.getView().getControl(TARGETENTITY);
        targetentity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid orgRange = (EntryGrid)this.getControl(ENTRYENTITY);
        orgRange.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                int row = evt.getRow();
                CentralControlAddVersion2.this.getPageCache().put("orgRow", Integer.toString(row));
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long modelId = (Long)customParams.get("model");
        if (ModelServiceHelper.isBGMDModel((Long)modelId)) {
            boolean isExit = BgControlUtils.hasBgControlRecord((Long)this.getModelId(), (Long)this.getBussModelId());
            if (isExit) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"bussmodel"});
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"model"});
        }
        Long id = (Long)customParams.get("id");
        this.getModel().setValue("model", (Object)modelId);
        this.orgRangVisable();
        this.setDTAndATVisible();
        if (id != null && id != 0L) {
            Object copy = customParams.get("iscopy");
            boolean iscopy = false;
            if (copy != null) {
                iscopy = true;
            }
            if (!iscopy) {
                this.getModel().setValue("pkId", (Object)id);
            }
            this.rebuildModel(modelId, id, iscopy);
            this.orgRangVisable();
        }
    }

    private void orgRangVisable() {
        Object dimension = this.getModel().getValue("dimension");
        if (dimension == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"orgrange"});
        } else if (dimension instanceof DynamicObject) {
            if (((DynamicObject)dimension).getString("number").equals("Entity")) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"orgrange"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"orgrange"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"orgrange"});
        }
        this.getView().updateView();
    }

    private void rebuildModel(Long modelId, Long id, boolean iscopy) {
        ContralVO contral = centralizedService.getContral(id);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (!iscopy) {
            dataEntity.set("number", (Object)contral.getNumber());
        }
        dataEntity.set("description", (Object)contral.getDescription());
        dataEntity.set("enable", (Object)contral.isEnable());
        Long dimId = contral.getControlDimension().getId();
        String dimNumber = contral.getControlDimension().getNumber();
        dataEntity.set("dimension", (Object)BusinessDataServiceHelper.loadSingle((Object)dimId, (String)"epm_dimension"));
        List accountMembers = contral.getAccountMembers();
        Object[] pkIds = accountMembers.stream().map(Member::getId).toArray();
        DynamicObject dddy = BusinessDataServiceHelper.newDynamicObject((String)SysDimensionEnum.Account.getMemberTreemodel());
        Map load = BusinessDataServiceHelper.loadFromCache((Object[])pkIds, (DynamicObjectType)dddy.getDynamicObjectType());
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection(dddy.getDynamicObjectType(), null, new ArrayList(load.values()));
        this.getModel().setValue("accounts", (Object)dynamicObjects);
        this.getModel().setValue("bussmodel", (Object)contral.getBussinessModelId());
        List cells = contral.getCells();
        if (!cells.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, cells.size());
            Map<String, Map<Integer, ContralCell>> entityFromCache = this.getEntityFromCache();
            Map integerContralCellMap = entityFromCache.computeIfAbsent(dimNumber, e -> new HashMap(16));
            for (int i = 0; i < cells.size(); ++i) {
                ContralCell cell = (ContralCell)cells.get(i);
                DynamicObject entity = this.getModel().getEntryRowEntity(ENTRYENTITY, i);
                entity.set(TARGETENTITY, (Object)BusinessDataServiceHelper.loadSingle((Object)cell.getTargetEntity(), (String)SysDimensionEnum.Entity.getMemberTreemodel()));
                List members = cell.getMembers();
                entity.set(SOURCERANGE, (Object)this.toStringMembers(members));
                List orgMembers = cell.getOrgMembers();
                if (orgMembers != null && !orgMembers.isEmpty()) {
                    entity.set("orgrange", (Object)orgMembers.stream().map(Member::getName).collect(Collectors.joining(",")));
                }
                integerContralCellMap.put(i, cell);
            }
            this.cacheEntity(entityFromCache);
        }
        this.getView().updateView();
    }

    @Override
    public Long getModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("model");
    }

    public String getCurrentDimNumber(String controlKey) {
        switch (controlKey) {
            case "accounts": {
                return SysDimensionEnum.Account.getNumber();
            }
            case "targetentity": {
                return SysDimensionEnum.Entity.getNumber();
            }
        }
        return null;
    }

    public String getCurrentDimNumber() {
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("dimension");
        if (dimension == null) {
            return null;
        }
        return dimension.getString("number");
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "dimension": {
                this.addDimensionQfilter(evt);
                break;
            }
            case "accounts": {
                this.openAccountF7(evt);
                break;
            }
            case "bussmodel": {
                this.addBussmodelQfilter(evt);
                break;
            }
            case "targetentity": {
                this.openEntityF7(evt);
                break;
            }
        }
    }

    private void addBussmodelQfilter(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl("bussmodel")).getQFilters();
        if (qFilterList == null) {
            qFilterList = new ArrayList<QFilter>(16);
        }
        qFilterList.add(new QFilter("model", "=", (Object)this.getModelId()));
        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
    }

    private void openAccountF7(BeforeF7SelectEvent evt) {
        Long modelId = this.getModelId();
        Long busModelId = this.getBussModelId();
        if ((CommonUtils.isBgmdModel((Long)this.getModelId()) || ModelUtil.isBGModel((Long)this.getModelId())) && busModelId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"DiffAnalyzeSchemeListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.Account.getNumber()), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(busModelId);
        f7Param.setDatasetIds(BusinessModelServiceHelper.getInstance().queryDataSetIds(f7Param.getBusModelId()));
        f7Param.setCanSelectRoot(false);
        f7Param.setVerifyPermission(false);
        NewF7Utils.openF7((BeforeF7SelectEvent)evt, (MemberF7Parameter)f7Param);
    }

    private void openEntityF7(BeforeF7SelectEvent evt) {
        Long modelId = this.getModelId();
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.Entity.getNumber()), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(this.getBussModelId());
        f7Param.setOnlySelLeaf(true);
        f7Param.setSwitchViewBySelMem(false);
        NewF7Utils.openF7((BeforeF7SelectEvent)evt, (MemberF7Parameter)f7Param);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "dimension": {
                this.dimensionChange((DynamicObject)newValue);
                this.orgRangVisable();
                this.getView().updateView(ENTRYENTITY);
                break;
            }
            case "targetentity": {
                this.targetEntityChange((DynamicObject)newValue);
                this.getView().updateView(ENTRYENTITY);
                break;
            }
            case "sourcerange": {
                if (newValue != null && !StringUtils.isEmpty((String)newValue.toString())) break;
                this.dealSelectReturnData(null, SOURCERANGE);
                break;
            }
            case "orgrange": {
                if (newValue != null && !StringUtils.isEmpty((String)newValue.toString())) break;
                this.dealSelectReturnData(null, "orgrange");
                break;
            }
            case "bussmodel": {
                this.setValueNull();
                break;
            }
        }
    }

    private void setValueNull() {
        this.getModel().setValue("accounts", null);
        this.getModel().setValue("dimension", null);
        this.getModel().deleteEntryData(ENTRYENTITY);
    }

    private void dimensionChange(DynamicObject newValue) {
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (newValue == null) {
            return;
        }
        String dimNumber = newValue.getString("number");
        String dimName = newValue.getString("name");
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
        grid.setColumnProperty(SOURCERANGE, "header", (Object)new LocaleString(ResManager.loadResFormat((String)"\u7ba1\u63a7\u8303\u56f4\uff1a%1", (String)"CentralControlAddVersion2_0", (String)"epm-eb-formplugin", (Object[])new Object[]{dimName})));
        Map<String, Map<Integer, ContralCell>> entityFromCache = this.getEntityFromCache();
        Map<Integer, ContralCell> integerContralCellMap = entityFromCache.get(dimNumber);
        if (MapUtils.isEmpty(integerContralCellMap)) {
            return;
        }
        int max = 0;
        for (Integer integer : integerContralCellMap.keySet()) {
            max = Math.max(integer, max);
        }
        int rowcount = max + 1;
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, rowcount);
        for (int i = 0; i < rowcount; ++i) {
            ContralCell contralCell = integerContralCellMap.get(i);
            if (contralCell == null) continue;
            DynamicObject entity = this.getModel().getEntryRowEntity(ENTRYENTITY, i);
            Long targetEntity = contralCell.getTargetEntity();
            if (targetEntity != null && targetEntity != 0L) {
                entity.set(TARGETENTITY, (Object)BusinessDataServiceHelper.loadSingle((Object)targetEntity, (String)SysDimensionEnum.Entity.getMemberTreemodel()));
            }
            entity.set(SOURCERANGE, (Object)this.toStringMembers(contralCell.getMembers()));
            List orgMembers = contralCell.getOrgMembers();
            if (orgMembers == null || orgMembers.isEmpty()) continue;
            entity.set("orgrange", (Object)orgMembers.stream().map(Member::getName).collect(Collectors.joining(",")));
        }
    }

    private void targetEntityChange(DynamicObject newValue) {
        long targetId = 0L;
        if (newValue != null) {
            targetId = newValue.getLong("id");
        }
        Map<String, Map<Integer, ContralCell>> entityFromCache = this.getEntityFromCache();
        String dimNumber = this.getCurrentDimNumber();
        Map integerContralCellMap = entityFromCache.computeIfAbsent(dimNumber, e -> new HashMap(16));
        int currentRow = this.getCurrentRow();
        ContralCell contralCell = integerContralCellMap.computeIfAbsent(currentRow, e -> new ContralCell());
        contralCell.setTargetEntity(Long.valueOf(targetId));
        this.cacheEntity(entityFromCache);
    }

    private void addDimensionQfilter(BeforeF7SelectEvent evt) {
        List qFilters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        Long modelId = this.getModelId();
        Long bussmodelId = this.getBussModelId();
        QFilter qfNumber = new QFilter("model", "=", (Object)modelId);
        QFilter qfEntity = new QFilter("number", "=", (Object)SysDimensionEnum.Entity.getNumber());
        QFilter qfUserDefined = new QFilter("issysdimension", "=", (Object)false);
        qfEntity.or(qfUserDefined);
        if (CommonUtils.hasBusinessModel((Long)modelId).booleanValue()) {
            if (IDUtils.isEmptyLong((Long)bussmodelId).booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"CentralControlAddVersion2_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            Set<Long> longs = this.getbussmodelDimension(this.getModelId(), bussmodelId);
            QFilter bussNumber = new QFilter("id", "in", longs);
            qFilters.add(qfNumber.and(qfEntity).and(bussNumber));
        } else {
            qFilters.add(qfNumber.and(qfEntity));
        }
    }

    public Set<Long> getbussmodelDimension(Long modelId, Long bussmodelId) {
        QFBuilder builder = new QFBuilder();
        HashSet<Long> dimensionIdSet = new HashSet<Long>();
        if (CommonUtils.hasBusinessModel((Long)modelId).booleanValue()) {
            builder.add(new QFilter("model", "=", (Object)modelId));
            builder.add(new QFilter("businessmodel.id", "=", (Object)bussmodelId));
            String fields = "id,model.id,businessmodel.id,entryentity.id,entryentity.dimensionid";
            DynamicObjectCollection ctrlDims = QueryServiceHelper.query((String)"eb_bgmcontroldimension", (String)fields, (QFilter[])builder.toArrays());
            for (DynamicObject ctrlDim : ctrlDims) {
                dimensionIdSet.add(ctrlDim.getLong("entryentity.dimensionid"));
            }
        }
        return dimensionIdSet;
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "btn_save": {
                this.saveCentral();
                break;
            }
            case "btn_addrow": {
                this.addRow();
                break;
            }
            case "sourcerange": {
                this.openSourceF7();
                break;
            }
            case "orgrange": {
                this.openEntityF7();
                break;
            }
        }
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "btn_delrow": {
                this.delRow();
                break;
            }
        }
    }

    private void saveCentral() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        ContralVO contralVO = new ContralVO();
        contralVO.setId(Long.valueOf(dataEntity.getLong("pkid")));
        contralVO.setNumber(dataEntity.getString("number"));
        contralVO.setDescription(dataEntity.getLocaleString("description"));
        contralVO.setModelId(this.getModelId());
        contralVO.setBussinessModelId(this.getBussModelId().longValue());
        DynamicObject dimension = dataEntity.getDynamicObject("dimension");
        contralVO.setControlDimension(new Dimension(Long.valueOf(dimension.getLong("id")), dimension.getString("name"), dimension.getString("number")));
        DynamicObjectCollection accounts = dataEntity.getDynamicObjectCollection("accounts");
        ArrayList<Member> lists = new ArrayList<Member>(accounts.size());
        for (DynamicObject account : accounts) {
            DynamicObject dynamicObject = (DynamicObject)account.get(1);
            lists.add(new Member(Long.valueOf(dynamicObject.getLong("id")), dynamicObject.getString("name"), dynamicObject.getString("number")));
        }
        contralVO.setAccountMembers(lists);
        Map<String, Map<Integer, ContralCell>> entityFromCache = this.getEntityFromCache();
        Map<Integer, ContralCell> cellMap = entityFromCache.get(contralVO.getControlDimension().getNumber());
        if (cellMap == null || cellMap.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u53e3\u7ba1\u63a7\u8303\u56f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"CentralControlAddVersion2_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        contralVO.setCells(new ArrayList<ContralCell>(cellMap.values()));
        contralVO.setEnable(dataEntity.getBoolean("enable"));
        BgControlCache.clearCentralized((Long)this.getModelId());
        try {
            centralizedService.saveContral(contralVO);
            String appId = this.getView().getFormShowParameter().getAppId();
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "CentralControlAddVersion2_5", "epm-eb-formplugin");
            MultiLangEnumBridge opLog = new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f", "CentralControlAddVersion2_7", "epm-eb-formplugin");
            if (IDUtils.isNotEmptyLong((Long)((Long)customParams.get("id"))).booleanValue()) {
                opName = new MultiLangEnumBridge("\u4fee\u6539", "CentralControlAddVersion2_6", "epm-eb-formplugin");
                opLog = new MultiLangEnumBridge("\u4fee\u6539\u6210\u529f", "CentralControlAddVersion2_8", "epm-eb-formplugin");
            }
            OperationLogUtil.log((String)appId, (String)this.getBizEntityNumber(), null, null, (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opLog, null);
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CentralControlAddVersion2_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void addRow() {
        String dimNumber = this.getCurrentDimNumber();
        if (StringUtils.isEmpty((String)dimNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f52\u53e3\u7ba1\u7406\u8303\u56f4\u3002", (String)"CentralControlAddVersion2_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().createNewEntryRow(ENTRYENTITY);
    }

    private void delRow() {
        Map<String, Map<Integer, ContralCell>> entityCache = this.getEntityFromCache();
        Map currentMap = entityCache.computeIfAbsent(this.getCurrentDimNumber(), e -> new HashMap(16));
        int currentRow = this.getCurrentRow();
        currentMap.remove(currentRow);
        int maxRow = 0;
        for (Integer integer : currentMap.keySet()) {
            maxRow = Math.max(integer, maxRow);
        }
        if (maxRow > currentRow) {
            for (int i = currentRow + 1; i <= maxRow; ++i) {
                ContralCell contralCell = (ContralCell)currentMap.get(i);
                if (contralCell == null) continue;
                currentMap.put(i - 1, contralCell);
            }
            currentMap.remove(maxRow);
        }
        this.cacheEntity(entityCache);
    }

    private void openSourceF7() {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "sourcerangeselect");
        String dimNumber = this.getCurrentDimNumber();
        if (StringUtils.isEmpty((String)dimNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f52\u53e3\u7ba1\u7406\u8303\u56f4\u3002", (String)"CentralControlAddVersion2_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Map<Integer, ContralCell>> entityFromCache = this.getEntityFromCache();
        Map map = entityFromCache.getOrDefault(dimNumber, new HashMap(16));
        int currentRow = this.getCurrentRow();
        Long modelId = this.getModelId();
        Long businessModelId = this.getBussModelId();
        ContralCell contralCell = (ContralCell)map.get(currentRow);
        if ("Entity".equals(dimNumber)) {
            RangeF7Param param = new RangeF7Param();
            param.setEnableView(false);
            param.setCloseCallBack(closeCallBack);
            param.setNeedPermCheck(true);
            param.setBizModelId(businessModelId);
            param.setOpenProperty(true);
            param.setDefaultRange(RangeEnum.ALL);
            param.setUserRange((List)Lists.newArrayList((Object[])new String[]{"10", "50"}));
            param.setLockRangeSelect(true);
            param.setSwitchViewBySelMem(false);
            if (contralCell != null && contralCell.getMembers() != null) {
                ArrayList<MemberCondition> members = new ArrayList<MemberCondition>(contralCell.getMembers().size());
                for (Member member : contralCell.getMembers()) {
                    MemberCondition memberCondition = new MemberCondition(member.getId(), member.getNumber(), member.getName(), null, "50");
                    if (member.isProperty().booleanValue()) {
                        memberCondition.setProp(true);
                    }
                    members.add(memberCondition);
                }
                param.setCon_list(members);
            }
            CustomF7utils.openCustomF7Range((Long)modelId, (String)SysDimensionEnum.Entity.getNumber(), (Long)0L, (IFormView)this.getView(), (RangeF7Param)param);
        } else {
            List members;
            Set<Object> ids = new LinkedHashSet();
            if (contralCell != null && (members = contralCell.getMembers()) != null && !members.isEmpty()) {
                ids = members.stream().map(e -> e.getId()).collect(Collectors.toSet());
            }
            MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
            f7Param.setSwitchViewBySelMem(false);
            f7Param.setSelectIds(ids);
            f7Param.setBusModelId(businessModelId);
            f7Param.setVerifyPermission(false);
            NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
        }
    }

    private void openEntityF7() {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "orgSelect");
        Map<String, Map<Integer, ContralCell>> entityFromCache = this.getEntityFromCache();
        Map map = entityFromCache.getOrDefault(this.getCurrentDimNumber(), new HashMap(16));
        int currentRow = this.getCurrentRow();
        ContralCell contralCell = (ContralCell)map.get(currentRow);
        Long modelId = this.getModelId();
        Long busModelId = this.getBussModelId();
        RangeF7Param param = new RangeF7Param();
        param.setEnableView(false);
        param.setSwitchViewBySelMem(false);
        param.setCloseCallBack(closeCallBack);
        param.setNeedPermCheck(true);
        param.setBizModelId(busModelId);
        param.setOpenProperty(true);
        param.setDefaultRange(RangeEnum.ALL);
        param.setUserRange((List)Lists.newArrayList((Object[])new String[]{"10", "50"}));
        param.setLockRangeSelect(true);
        if (contralCell != null && contralCell.getOrgMembers() != null) {
            ArrayList<MemberCondition> members = new ArrayList<MemberCondition>(contralCell.getOrgMembers().size());
            for (Member orgMemberDto : contralCell.getOrgMembers()) {
                MemberCondition memberCondition = new MemberCondition(orgMemberDto.getId(), orgMemberDto.getNumber(), orgMemberDto.getName(), null, "50");
                if (orgMemberDto.isProperty().booleanValue()) {
                    memberCondition.setProp(true);
                }
                members.add(memberCondition);
            }
            param.setCon_list(members);
        }
        CustomF7utils.openCustomF7Range((Long)modelId, (String)SysDimensionEnum.Entity.getNumber(), (Long)0L, (IFormView)this.getView(), (RangeF7Param)param);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        switch (event.getActionId()) {
            case "sourcerangeselect": {
                if (event.getReturnData() == null) break;
                this.dealSelectReturnData(event.getReturnData(), SOURCERANGE);
                break;
            }
            case "entity": {
                if (event.getReturnData() == null) break;
                this.dealSelectReturnData(event.getReturnData(), "orgrange");
                break;
            }
            case "orgSelect": {
                if (event.getReturnData() == null) {
                    return;
                }
                this.dealSelectReturnData(event.getReturnData(), "orgrange");
                break;
            }
        }
    }

    private void dealSelectReturnData(Object o, String tag) {
        Map<String, Map<Integer, ContralCell>> entityCache = this.getEntityFromCache();
        Map currentMap = null;
        String dimNumber = this.getCurrentDimNumber();
        currentMap = entityCache.computeIfAbsent(dimNumber, e -> new HashMap(16));
        int currentRow = this.getCurrentRow();
        ContralCell contralCell = currentMap.computeIfAbsent(currentRow, e -> new ContralCell());
        if (SOURCERANGE.equals(tag) && !"Entity".equals(dimNumber)) {
            if (o == null) {
                contralCell.setMembers(new ArrayList());
            } else {
                List<Member> members = this.toMembers((ListSelectedRowCollection)o);
                contralCell.setMembers(members);
                this.getModel().setValue(tag, (Object)this.toStringMembers(members), currentRow);
            }
        } else if (o == null) {
            if ("Entity".equals(dimNumber)) {
                contralCell.setMembers(new ArrayList(16));
            } else {
                contralCell.setOrgMembers(new ArrayList(16));
            }
        } else {
            DynamicObjectCollection returnData = (DynamicObjectCollection)o;
            List chooseOrg = returnData.stream().map(k -> new Member(Long.valueOf(k.getLong("id")), k.getString("name"), k.getString("number"), Boolean.valueOf("2".equals(k.getString("type"))))).collect(Collectors.toList());
            if ("Entity".equals(dimNumber)) {
                contralCell.setMembers(chooseOrg);
            } else {
                contralCell.setOrgMembers(chooseOrg);
            }
            this.getModel().setValue(tag, (Object)chooseOrg.stream().map(Member::getName).collect(Collectors.joining(",")), currentRow);
        }
        this.cacheEntity(entityCache);
        this.getView().updateView(ENTRYENTITY);
    }

    private String toStringMembers(List<Member> members) {
        StringBuilder sb = new StringBuilder();
        if (CollectionUtils.isNotEmpty(members)) {
            members.forEach(member -> sb.append(member.getName()).append(","));
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private List<Member> toMembers(ListSelectedRowCollection returnData) {
        if (returnData == null || returnData.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Member> members = new ArrayList<Member>(16);
        for (ListSelectedRow returnDatum : returnData) {
            Map dataMap = returnDatum.getDataMap();
            Member member = new Member(Long.valueOf(dataMap.get("memberid").toString()));
            member.setName(String.valueOf(dataMap.get("name")));
            member.setNumber(String.valueOf(dataMap.get("number")));
            members.add(member);
        }
        return members;
    }

    private int getCurrentRow() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        int size = entryEntity.size();
        if (size > 0) {
            String row = this.getPageCache().get("orgRow");
            if (row != null && Integer.parseInt(row) <= size - 1) {
                return Integer.parseInt(row);
            }
            return size - 1;
        }
        return -1;
    }

    private void cacheEntity(Map<String, Map<Integer, ContralCell>> cells) {
        if (cells == null || cells.isEmpty()) {
            this.getPageCache().put("controlentity", null);
        } else {
            this.getPageCache().put("controlentity", SerializationUtils.serializeToBase64(cells));
        }
    }

    private Map<String, Map<Integer, ContralCell>> getEntityFromCache() {
        String controlentity = this.getPageCache().get("controlentity");
        if (StringUtils.isEmpty((String)controlentity)) {
            return new HashMap<String, Map<Integer, ContralCell>>(16);
        }
        return (Map)SerializationUtils.deSerializeFromBase64((String)controlentity);
    }

    private void setDTAndATVisible() {
        DynamicObject model = ModelUtils.getModel((Long)this.getModelId());
        String reportType = model.getString("reporttype");
        if (ApplicationTypeEnum.BGMD.getIndex().equals(reportType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bussmodel"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bussmodel"});
        }
    }

    private Long getBussModelId() {
        Object bussmodel = this.getModel().getValue("bussmodel");
        if (bussmodel != null) {
            return ((DynamicObject)bussmodel).getLong("id");
        }
        return 0L;
    }

    public String getBizCtrlRangeKey() {
        return "bussmodel";
    }
}

