/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralized;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.centralizedcontrol.service.CentralizedFileService;
import kd.epm.eb.business.centralizedcontrol.service.impl.CentralizedFileServiceImpl;
import kd.epm.eb.business.control.BgmdControlParamQueryService;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class CentralControlImportPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Log logger = LogFactory.getLog(CentralControlImportPlugin.class);
    private CentralizedFileService centralizedFileService;
    private static final String BTN_OK = "btnok";
    private static final String BTN_DOWNLOAD = "btndownload";
    private static final String ATTACHMENT_PANEL = "attachmentpanelap";
    private static final String CONTROLPARAM = "controlparam";

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"newandcover"});
        if (!this.isEb()) {
            Map controlDimsByModel = BgmdControlParamQueryService.getInstance().getControlDimsByModel(this.getModelId().longValue());
            this.getPageCache().put(CONTROLPARAM, SerializationUtils.serializeToBase64((Object)controlDimsByModel));
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_DOWNLOAD});
        AttachmentPanel attach = (AttachmentPanel)this.getControl(ATTACHMENT_PANEL);
        attach.addUploadListener((UploadListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        try {
            String key;
            this.centralizedFileService = this.getFileService();
            switch (key = ((Button)evt.getSource()).getKey()) {
                case "btndownload": {
                    this.handleDownloadClick();
                    break;
                }
                case "btnok": {
                    this.handleOkClick();
                    break;
                }
            }
        }
        catch (Exception exp) {
            logger.error((Throwable)exp);
            throw new KDBizException(ThrowableHelper.toString((Exception)exp));
        }
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        String fileUrl = this.getPageCache().get("file_url");
        List urls = fileUrl == null ? new ArrayList(16) : (List)SerializationUtils.fromJsonString((String)fileUrl, List.class);
        for (Object url : evt.getUrls()) {
            urls.add((String)((Map)url).get("url"));
        }
        if (urls.size() > 0) {
            this.getPageCache().put("file_url", SerializationUtils.toJsonString(urls));
        }
    }

    public void afterRemove(UploadEvent evt) {
        Object[] objects;
        String fileUrl = this.getPageCache().get("file_url");
        if (fileUrl == null) {
            return;
        }
        List urls = (List)SerializationUtils.fromJsonString((String)fileUrl, List.class);
        for (Object object : objects = evt.getUrls()) {
            String url = (String)((Map)object).get("url");
            urls.remove(url);
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString((Object)urls));
    }

    @Override
    public Long getModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("model");
    }

    private void handleDownloadClick() {
        if (!this.hasControlDim()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u8be5\u4f53\u7cfb\u7684\u9884\u7b97\u63a7\u5236\u7ef4\u5ea6\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CentralControlImportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.centralizedFileService.downLoadExcel(this.getView(), this.getPageCache(), this.getModelId().longValue());
    }

    private void handleOkClick() {
        if (!this.hasControlDim()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u8be5\u4f53\u7cfb\u7684\u9884\u7b97\u63a7\u5236\u7ef4\u5ea6\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CentralControlImportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.centralizedFileService.importExcel(this.getPageCache(), this.getView(), this.getModelId().longValue());
    }

    private CentralizedFileService getFileService() {
        if (this.centralizedFileService == null) {
            this.centralizedFileService = CentralizedFileServiceImpl.getInstance();
        }
        return this.centralizedFileService;
    }

    public boolean isBgmd() {
        return (Boolean)this.getView().getFormShowParameter().getCustomParam("isBgmd");
    }

    public boolean isEb() {
        return (Boolean)this.getView().getFormShowParameter().getCustomParam("isEb");
    }

    private boolean hasControlDim() {
        Map controlParamMap;
        if (this.isEb()) {
            return true;
        }
        String controlParamStr = this.getPageCache().get(CONTROLPARAM);
        return StringUtils.isNotEmpty((String)controlParamStr) && (controlParamMap = (Map)SerializationUtils.deSerializeFromBase64((String)controlParamStr)) != null && controlParamMap.size() > 0;
    }
}

