/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralized;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListColumn;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.centralizedcontrol.service.CentralizedFileService;
import kd.epm.eb.business.centralizedcontrol.service.impl.CentralizedFileServiceImpl;
import kd.epm.eb.business.control.BgmdControlParamQueryService;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.control.BgControlCache;
import kd.epm.eb.common.central.CentralizedServiceImpl;
import kd.epm.eb.common.central.CentralizedUtils;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.control.ControlModelFuzzySearchCommon;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;

public class CentralControlListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener,
CreateListColumnsListener,
SetFilterListener,
BasedataFuzzySearchListener,
CreateListDataProviderListener {
    private static final Log log = LogFactory.getLog(CentralControlListPlugin.class);
    private static final String BTN_IMPORT = "btn_import";
    private static final String BTN_EXPORT = "btn_export";
    private static final String CLOSE_CALL_BACK_IMPORT_PAGE = "import_page";
    private final CentralizedFileService centralizedFileService = CentralizedFileServiceImpl.getInstance();

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"model"});
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addCreateListColumnsListener((CreateListColumnsListener)this);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        billList.addSetFilterListener((SetFilterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = UserSelectUtils.getUserSelectModelId((IFormView)this.getView());
        if (!IDUtils.isNotNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"CentralControlListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("model", (Object)modelId);
        this.reFreshBillList();
    }

    public void createListColumns(BeforeCreateListColumnsArgs args) {
        Map<String, String> fildMapped2Name;
        List listColumns = args.getListColumns();
        Long modelId = this.getModelId();
        boolean modelByEb = false;
        if (modelId != null && modelId > 0L) {
            modelByEb = ModelCacheContext.getOrCreate((Long)modelId).getModelobj().isModelByEB();
        }
        if (modelByEb || ModelUtil.isBGModel((Long)modelId)) {
            HashSet<String> toHideKeys = new HashSet<String>(listColumns.size());
            toHideKeys.add("bussmodel.name");
            listColumns.removeIf(col -> toHideKeys.contains(col.getListFieldKey()));
        }
        if ((fildMapped2Name = this.getFildMapped2Name()) != null && !fildMapped2Name.isEmpty()) {
            listColumns.forEach(e -> {
                String key = e.getListFieldKey();
                if (key.startsWith("text") && !key.equals("text0")) {
                    if (fildMapped2Name.containsKey(key)) {
                        e.setVisible(1);
                        e.setCaption(new LocaleString((String)fildMapped2Name.get(key)));
                    } else {
                        e.setVisible(0);
                    }
                }
            });
        } else {
            listColumns.forEach(e -> {
                if (!e.getListFieldKey().equals("text0") && e.getListFieldKey().startsWith("text")) {
                    e.setVisible(0);
                }
            });
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("model".equals(key)) {
            PluginUtils.setModelFilter(e, this.getView());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_add": {
                this.addnew();
                break;
            }
            case "btn_copy": {
                this.copy();
                break;
            }
            case "btn_modify": {
                this.modify();
                break;
            }
            case "btn_delete": {
                break;
            }
            case "btn_start": 
            case "btn_stop": {
                this.setStatus(itemKey);
                break;
            }
            case "btn_refresh": {
                this.reFreshBillList();
                break;
            }
            case "btn_close": {
                this.getView().close();
                break;
            }
            case "btn_import": {
                this.handleImportClick();
                break;
            }
            case "btn_export": {
                this.handleExportClick();
                break;
            }
        }
    }

    private void handleImportClick() {
        long modelId = this.getModelId();
        if (Long.valueOf(0L).equals(modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"DiffAnalyzeSchemeListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openFileDialog();
    }

    private void handleExportClick() {
        Object[] selectPKids = this.getSelectPKids();
        if (selectPKids == null || selectPKids.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"AdjustBillListPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        if (!modelCacheHelper.getModelobj().isModelByEB()) {
            Map controlDimsByModel = BgmdControlParamQueryService.getInstance().getControlDimsByModel(this.getModelId().longValue());
            this.getPageCache().put("controlparam", SerializationUtils.serializeToBase64((Object)controlDimsByModel));
        }
        this.centralizedFileService.exportExcel(selectPKids, this.getView(), this.getPageCache(), this.getModelId().longValue());
    }

    private void openFileDialog() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epm_import");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("model", (Object)this.getModelId());
        showParameter.setCustomParam("isBgmd", (Object)ModelServiceHelper.isBGMDModel((Long)this.getModelId()));
        DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getModelId(), (String)"epm_model");
        showParameter.setCustomParam("isEb", (Object)ModelServiceHelper.isEBModel((DynamicObject)model));
        showParameter.setCaption(ResManager.loadKDString((String)"\u5f52\u53e3\u7ba1\u63a7\u65b9\u6848 - \u5bfc\u5165", (String)"CentralControlListPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)"epm_import");
        showParameter.setFormConfig(formConfig);
        showParameter.addCustPlugin("kd.epm.eb.formplugin.centralized.CentralControlImportPlugin");
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, CLOSE_CALL_BACK_IMPORT_PAGE);
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent event) {
        super.hyperLinkClick(event);
        String fieldName = event.getFieldName();
        if ("number".equalsIgnoreCase(fieldName)) {
            BillList bl = (BillList)this.getControl("billlistap");
            Object focusRowPkId = bl.getFocusRowPkId();
            this.modify(focusRowPkId);
        }
    }

    private void addnew() {
        DynamicObject model = this.getSelModel();
        if (model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"CentralControlListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter param = new FormShowParameter();
        param.setFormId("eb_centralizededit");
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addCallback"));
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("model", (Object)model.getLong("id"));
        this.getView().showForm(param);
    }

    private void modify() {
        Object[] selectPKids = this.getSelectPKids();
        if (selectPKids == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u4fee\u6539\u7684\u6570\u636e\u3002", (String)"CentralControlListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectPKids.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u7ec4\u6570\u636e\u8fdb\u884c\u4fee\u6539\u3002", (String)"CentralControlListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Object selectPKid = selectPKids[0];
        this.modify(selectPKid);
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        if (this.checkAtListOneSelect()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u8be5\u65b9\u6848\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u662f\u5426\u786e\u5b9a\u5220\u9664\uff1f", (String)"CentralControlListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("delete"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String actionId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if (!MessageBoxResult.Yes.equals((Object)result)) {
            return;
        }
        switch (actionId) {
            case "delete": {
                this.deleteData();
            }
        }
    }

    private boolean checkAtListOneSelect() {
        BillList billList = (BillList)this.getControl("billlistap");
        if (billList.getSelectedRows().size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"CentralControlListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void modify(Object selectPKid) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("eb_centralizededit");
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "modifyCallback"));
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("model", (Object)this.getModelId());
        param.setCustomParam("id", selectPKid);
        this.getView().showForm(param);
    }

    private void copy() {
        Object[] selectPKids = this.getSelectPKids();
        if (selectPKids == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u590d\u5236\u7684\u6570\u636e\u3002", (String)"CentralControlListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectPKids.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u7ec4\u6570\u636e\u8fdb\u884c\u590d\u5236\u3002", (String)"CentralControlListPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Object selectPKid = selectPKids[0];
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)selectPKid, (String)"eb_centralized_entity");
        Object dimension = dynamicObject.get("dimension");
        if (dimension != null) {
            FormShowParameter param = new FormShowParameter();
            param.setFormId("eb_centralizededit");
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "modifyCallback"));
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setCustomParam("model", (Object)this.getModelId());
            param.setCustomParam("id", selectPKid);
            param.setCustomParam("iscopy", (Object)0);
            this.getView().showForm(param);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u590d\u5236\u65e7\u65b9\u6848\u3002", (String)"CentralControlListPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void deleteData() {
        Object[] selectPKids = this.getSelectPKids();
        if (selectPKids == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"CentralControlListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        BillList bl = (BillList)this.getControl("billlistap");
        DeleteServiceHelper.delete((IDataEntityType)bl.getEntityType(), (Object[])selectPKids);
        BgControlCache.clearCentralized((Long)this.getModelId());
        this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "CentralControlListPlugin_19", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5f52\u53e3\u7ba1\u63a7\u65b9\u6848\u5220\u9664\u6210\u529f\u3002", "CentralControlListPlugin_20", "epm-eb-formplugin"));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"CentralControlListPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.reFreshBillList();
    }

    private void setStatus(String itemKey) {
        Object[] selectPKids;
        boolean status = true;
        if ("btn_stop".equals(itemKey)) {
            status = false;
        }
        if ((selectPKids = this.getSelectPKids()) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e", (String)"CentralControlListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectPKids.length > 1 && status) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65f6\u4e0d\u652f\u6301\u591a\u6761\u65b9\u6848\u540c\u65f6\u542f\u7528\u3002", (String)"CentralControlListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        BillList bl = (BillList)this.getControl("billlistap");
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])selectPKids, (DynamicObjectType)bl.getEntityType());
        if (load != null) {
            for (DynamicObject object : load) {
                object.set("status", (Object)status);
                if (!status) continue;
                CentralizedServiceImpl.getInstance().changeContralStatus(selectPKids[0], this.getModelId(), status);
            }
            SaveServiceHelper.save((DynamicObject[])load);
            if (status) {
                this.writeLog("enable", new MultiLangEnumBridge("\u5f52\u53e3\u63a7\u5236\u5217\u8868", "CentralControlListPlugin_22", "epm-eb-formplugin"), new MultiLangEnumBridge("\u542f\u7528\u4e00\u6761\u6570\u636e", "CentralControlListPlugin_23", "epm-eb-formplugin"));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"bizRuleGroupListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.writeLog("disable", new MultiLangEnumBridge("\u5f52\u53e3\u63a7\u5236\u5217\u8868", "CentralControlListPlugin_22", "epm-eb-formplugin"), new MultiLangEnumBridge("\u7981\u7528\u4e00\u6761\u6570\u636e", "CentralControlListPlugin_24", "epm-eb-formplugin"));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"bizRuleGroupListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            BgControlCache.clearCentralized((Long)this.getModelId());
        }
        this.reFreshBillList();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if ("MODEL".equalsIgnoreCase(propName)) {
            Object obj = this.getModel().getValue("model");
            if (obj instanceof DynamicObject) {
                Long modelId = ((DynamicObject)obj).getLong("id");
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
                this.getPageCache().put("fildMapped2Name", null);
                this.getPageCache().put("controlparam", null);
                this.getPageCache().put("dimInfo", null);
                this.getPageCache().put("dimInfoByControlDim", null);
            }
            this.reFreshBillList();
            this.dealModelChanged4Bg(e);
        }
    }

    public void setFilter(SetFilterEvent e) {
        BillList billList;
        if (e.getSource() instanceof BillList && "billlistap".equals((billList = (BillList)e.getSource()).getKey())) {
            if (this.getModelId() == null || this.getModelId() == 0L) {
                e.getQFilters().add(new QFilter("id", "=", (Object)0L));
                e.setOrderBy("id");
                return;
            }
            IModelCacheHelper iModelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
            Map centralizedMap = BusinessDataServiceHelper.loadFromCache((String)"eb_centralized_entity", (QFilter[])filter.toArray());
            ArrayList<Long> authorityIds = new ArrayList<Long>(centralizedMap.size());
            Map<Long, Map<String, Set<Long>>> permOrgs = this.getPermOrgs(iModelCacheHelper);
            for (Map.Entry entry : centralizedMap.entrySet()) {
                Sets.SetView notPermEntitySet;
                Long key = (Long)entry.getKey();
                DynamicObject centralized = (DynamicObject)entry.getValue();
                Long bussModelId = 0L;
                if (!iModelCacheHelper.getModelobj().isModelByEB()) {
                    if (centralized.getDynamicObject("bussmodel") == null) continue;
                    bussModelId = centralized.getDynamicObject("bussmodel").getLong("id");
                }
                DynamicObjectCollection orgRange = centralized.getDynamicObjectCollection("orgrange");
                Set entityIdSet = orgRange.stream().filter(obj -> obj.getDynamicObject("entity") != null).map(obj -> obj.getDynamicObject("entity").getLong("id")).collect(Collectors.toSet());
                List entityRangeList = orgRange.stream().map(obj -> obj.getString("entityrange")).collect(Collectors.toList());
                ArrayList entityRangeMembers = new ArrayList(16);
                for (String entityRange : entityRangeList) {
                    entityRangeMembers.addAll(CentralizedUtils.mbgRangeString((IModelCacheHelper)iModelCacheHelper, (String)SysDimensionEnum.Entity.getNumber(), (Long)bussModelId, (String)entityRange));
                }
                Set entityRangeIdSet = entityRangeMembers.stream().filter(k -> k.isProperty() == false).map(Member::getId).collect(Collectors.toSet());
                entityRangeIdSet.addAll(entityIdSet);
                Map<String, Set<Long>> dimPerms = permOrgs.get(bussModelId);
                Set<Long> permEntityMembIdSet = dimPerms.get(SysDimensionEnum.Entity.getNumber());
                if (permEntityMembIdSet != null && CollectionUtils.isNotEmpty((Collection)(notPermEntitySet = Sets.difference(entityRangeIdSet, permEntityMembIdSet)))) continue;
                if (centralized.getDynamicObject("dimension") == null) {
                    return;
                }
                String dimensionNumber = centralized.getDynamicObject("dimension").getString("number");
                if (SysDimensionEnum.Entity.getNumber().equals(dimensionNumber)) {
                    List dimensionRangeStr = orgRange.stream().map(obj -> obj.getString("dimensionrange")).collect(Collectors.toList());
                    ArrayList dimensionRangeMembers = new ArrayList(16);
                    for (String dimensionRange : dimensionRangeStr) {
                        dimensionRangeMembers.addAll(CentralizedUtils.mbgRangeString((IModelCacheHelper)iModelCacheHelper, (String)dimensionNumber, (Long)bussModelId, (String)dimensionRange));
                    }
                    if (dimensionRangeMembers.stream().noneMatch(k -> k.isProperty())) {
                        Sets.SetView notPermDimensionSet;
                        Set dimensionRangeIdSet = dimensionRangeMembers.stream().map(Member::getId).collect(Collectors.toSet());
                        Set<Long> permDimensionMembIdSet = dimPerms.get(dimensionNumber);
                        if (permDimensionMembIdSet != null && CollectionUtils.isNotEmpty((Collection)(notPermDimensionSet = Sets.difference(dimensionRangeIdSet, permDimensionMembIdSet)))) continue;
                    }
                }
                authorityIds.add(key);
            }
            e.getQFilters().add(new QFilter("id", "in", authorityIds));
            e.setOrderBy("id");
        }
    }

    private Map<Long, Map<String, Set<Long>>> getPermOrgs(IModelCacheHelper iModelCacheHelper) {
        HashMap<Long, Map<String, Set<Long>>> permMaps = new HashMap<Long, Map<String, Set<Long>>>();
        if (!iModelCacheHelper.getModelobj().isModelByEB()) {
            DynamicObject[] businessModels;
            for (DynamicObject Dy : businessModels = BusinessDataServiceHelper.load((String)"eb_businessmodel", (String)"id", (QFilter[])new QFBuilder("model", "=", (Object)iModelCacheHelper.getModelobj().getId()).toArray())) {
                Map dimensionMaps = permMaps.getOrDefault(Dy.getLong("id"), new HashMap());
                List views = iModelCacheHelper.getViewGroupViewsByBusModelAndDimNumber(Long.valueOf(Dy.getLong("id")), SysDimensionEnum.Entity.getNumber());
                HashSet entityViewSets = null;
                if (views != null && !views.isEmpty()) {
                    for (Long viewId : views) {
                        Set permEntityMembIdSet = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)iModelCacheHelper.getModelobj().getId(), (Long)Dy.getLong("id"), (Long)viewId, (DimMembPermType)DimMembPermType.READ, (boolean)true);
                        if (permEntityMembIdSet == null) continue;
                        if (entityViewSets == null) {
                            entityViewSets = new HashSet();
                        }
                        entityViewSets.addAll(permEntityMembIdSet);
                    }
                }
                dimensionMaps.put(SysDimensionEnum.Entity.getNumber(), entityViewSets);
                Set definedDimNumbers = iModelCacheHelper.getDimensionListByBusModel(Long.valueOf(Dy.getLong("id"))).stream().filter(k -> !k.isPreset()).map(k -> k.getNumber()).collect(Collectors.toSet());
                for (String definedDimNumber : definedDimNumbers) {
                    HashSet definedMaps = null;
                    List definedViews = iModelCacheHelper.getViewGroupViewsByBusModelAndDimNumber(Long.valueOf(Dy.getLong("id")), definedDimNumber);
                    if (definedViews != null && !definedViews.isEmpty()) {
                        for (Long viewId : definedViews) {
                            Set permEntityMembIdSet = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)iModelCacheHelper.getModelobj().getId(), (Long)Dy.getLong("id"), (Long)viewId, (DimMembPermType)DimMembPermType.READ, (boolean)true);
                            if (permEntityMembIdSet == null) continue;
                            if (definedMaps == null) {
                                definedMaps = new HashSet();
                            }
                            definedMaps.addAll(permEntityMembIdSet);
                        }
                    }
                    dimensionMaps.put(definedDimNumber, definedMaps);
                }
                permMaps.put(Dy.getLong("id"), dimensionMaps);
            }
        } else {
            Set permEntityMembIdSet = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)iModelCacheHelper.getModelobj().getId(), (Long)0L, (Long)0L, (DimMembPermType)DimMembPermType.READ, (boolean)true);
            HashMap<String, Set> entityPerms = new HashMap<String, Set>(16);
            entityPerms.put(SysDimensionEnum.Entity.getNumber(), permEntityMembIdSet);
            Set definedNumbers = iModelCacheHelper.getDimensionList().stream().filter(k -> !k.isPreset()).map(k -> k.getNumber()).collect(Collectors.toSet());
            for (String definedNum : definedNumbers) {
                permEntityMembIdSet = DimMembPermHelper.getPermMembIds((String)definedNum, (Long)iModelCacheHelper.getModelobj().getId(), (Long)0L, (Long)0L, (DimMembPermType)DimMembPermType.READ, (boolean)true);
                entityPerms.put(definedNum, permEntityMembIdSet);
            }
            permMaps.put(0L, entityPerms);
        }
        return permMaps;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("addCallback".equals(actionId)) {
            this.reFreshBillList();
        } else if ("modifyCallback".equals(actionId)) {
            this.reFreshBillList();
        } else if (CLOSE_CALL_BACK_IMPORT_PAGE.equals(actionId)) {
            this.reFreshBillList();
        }
    }

    public DynamicObject getSelModel() {
        Object obj = this.getModel().getValue("model");
        if (obj instanceof DynamicObject) {
            return (DynamicObject)obj;
        }
        return null;
    }

    @Override
    public Long getModelId() {
        Long modelId = 0L;
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model != null) {
            modelId = model.getLong("id");
        }
        return modelId;
    }

    private void reFreshBillList() {
        if (this.getSelModel() != null) {
            this.setDTAndATVisible();
            BillList billList = (BillList)this.getControl("billlistap");
            billList.clearSelection();
            billList.refresh();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"DiffAnalyzeSchemeListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private Object[] getSelectPKids() {
        BillList bl = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = bl.getSelectedRows();
        if (selectedRows == null || selectedRows.size() == 0) {
            return null;
        }
        return selectedRows.getPrimaryKeyValues();
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if ("model".equals(key)) {
            BasedataEdit b = ControlModelFuzzySearchCommon.getInstance().reBuildBasedataEdit(key);
            b.setView(this.getView());
            b.setModel(this.getModel());
            b.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            b.addBasedataFuzzySearchListener((BasedataFuzzySearchListener)this);
            e.setControl((Control)b);
        }
    }

    public void handleData(BasedataFuzzySearchEvent searchEvent) {
        ControlModelFuzzySearchCommon.getInstance().reWriteData(searchEvent);
    }

    private Map<String, String> getFildMapped2Name() {
        if (this.getPageCache().get("fildMapped2Name") != null) {
            Map fildMapped2Name = (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("fildMapped2Name"));
            return fildMapped2Name;
        }
        long modelId = this.getModelId();
        HashMap<String, String> fildMapped2Name = new HashMap<String, String>();
        if (!Long.valueOf(0L).equals(modelId)) {
            QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
            QFilter qfIsSys = new QFilter("issysdimension", "=", (Object)false);
            QFilter[] udqf = new QFilter[]{modelFilter, qfIsSys};
            DynamicObjectCollection dims = QueryServiceHelper.query((String)"epm_dimension", (String)"id, number, shortnumber, name, fieldmapped, issysdimension", (QFilter[])udqf);
            for (DynamicObject dynamicObject : dims) {
            }
        }
        this.getPageCache().put("fildMapped2Name", ObjectSerialUtil.toByteSerialized(fildMapped2Name));
        return fildMapped2Name;
    }

    private void setDTAndATVisible() {
        DynamicObject model = ModelUtils.getModel((Long)this.getModelId());
        String reportType = model.getString("reporttype");
        if (ApplicationTypeEnum.isBGMD((String)reportType)) {
            ((ListColumn)this.getView().getControl("bussmodel")).setVisible(11);
            ((ListColumn)this.getView().getControl("entityrange")).setVisible(11);
        } else {
            ((ListColumn)this.getView().getControl("bussmodel")).setVisible(0);
        }
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs args) {
        if (this.getModelId() == 0L) {
            return;
        }
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                IModelCacheHelper iModelCacheHelper = CentralControlListPlugin.this.getIModelCacheHelper();
                DynamicObjectCollection collection = super.getData(arg0, arg1);
                for (DynamicObject dynamicObject : collection) {
                    if (!dynamicObject.containsProperty("orgrange.entityrange")) continue;
                    try {
                        String o = dynamicObject.getString("orgrange.entityrange");
                        if (!StringUtils.isNotEmpty((String)o)) continue;
                        List members = null;
                        members = iModelCacheHelper.getModelobj().isModelByEB() ? CentralizedUtils.mbgRangeString((IModelCacheHelper)iModelCacheHelper, (String)SysDimensionEnum.Entity.getNumber(), null, (String)o) : CentralizedUtils.mbgRangeString((IModelCacheHelper)iModelCacheHelper, (String)SysDimensionEnum.Entity.getNumber(), (Long)(((MainEntityType)dynamicObject.getDynamicObjectType()).getFields().containsKey("bussmodel") && dynamicObject.get("bussmodel") != null ? dynamicObject.getLong("bussmodel.id") : 0L), (String)o);
                        dynamicObject.set("orgrange.entityrange", (Object)members.stream().map(Member::getName).collect(Collectors.joining(",")));
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                    }
                }
                return collection;
            }
        });
    }

    public String getModelFieldKey() {
        return "model";
    }
}

