/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralrelation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.business.approvetype.ApproveTypeUtils;
import kd.epm.eb.business.centralrelation.CentralRelationService;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CentralRangePlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        this.addF7SelectListener(this, new String[]{"bizmodel", "dimension", "dimensionview", "entityrange"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        Long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        if (IDUtils.isNull((Long)id)) {
            Long model = (Long)this.getView().getFormShowParameter().getCustomParam("model");
            if (IDUtils.isNull((Long)model)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CentralRangePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.getModel().setValue("model", (Object)model);
        }
    }

    public void afterBindData(EventObject e) {
        this.presetDimension();
        Long modelId = this.getModelId();
        boolean bgModel = ModelUtil.isBGModel((Long)modelId);
        if (bgModel) {
            Object id = this.getModel().getValue("id");
            if (IDUtils.isNull((Long)IDUtils.toLong((Object)id))) {
                DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_businessmodel", (String)"id", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
                this.getModel().setValue("bizmodel", (Object)object.getLong("id"));
                this.getModel().setDataChanged(false);
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bizmodel"});
        }
    }

    public void afterLoadData(EventObject e) {
        Object id = this.getModel().getValue("id");
        CentralRelationService instance = CentralRelationService.getInstance();
        DynamicObjectCollection centralSchemes = QueryServiceHelper.query((String)"eb_centralrelscheme", (String)"id,entity", (QFilter[])new QFilter("centralrange", "=", (Object)IDUtils.toLong((Object)id)).toArray());
        if (CollectionUtils.isNotEmpty((Collection)centralSchemes)) {
            HashSet<Long> entityIdSet = new HashSet<Long>(centralSchemes.size());
            HashSet<Long> schemeIdSet = new HashSet<Long>(centralSchemes.size());
            for (DynamicObject scheme : centralSchemes) {
                entityIdSet.add(scheme.getLong("entity"));
                schemeIdSet.add(scheme.getLong("id"));
            }
            boolean exists = instance.queryRelationByScheme(schemeIdSet);
            if (exists) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"add_dim", "del_dim", "bizmodel", "entryentity"});
                this.getPageCache().put("entityIdSet", SerializationUtils.serializeToBase64(entityIdSet));
            } else {
                this.setEntryEntityEnable();
            }
        } else {
            this.setEntryEntityEnable();
        }
    }

    private void setEntryEntityEnable() {
        Long modelId;
        this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"dimension"});
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject object = (DynamicObject)entryEntity.get(i);
            String number = object.getString("dimension.number");
            if (!SysDimensionEnum.Account.getNumber().equals(number)) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"dimensionview"});
            break;
        }
        if (ModelUtil.isBGModel((Long)(modelId = this.getModelId()))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bizmodel"});
        }
    }

    private void presetDimension() {
        DynamicObjectCollection entryEntity;
        Long bizModelId = this.getBizModelId();
        if (IDUtils.isNotNull((Long)bizModelId) && CollectionUtils.isEmpty((Collection)(entryEntity = this.getModel().getEntryEntity("entryentity")))) {
            this.getModel().insertEntryRow("entryentity", 0);
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            Dimension dimension = modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber());
            Map editViewIds = BusinessModelServiceHelper.getEditViewIds((Long)bizModelId);
            Long editView = (Long)editViewIds.get(SysDimensionEnum.Entity.getNumber());
            this.getModel().setValue("dimension", (Object)dimension.getId(), 0);
            this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"dimension"});
            this.getModel().setValue("dimensionview", (Object)editView);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        Long bizModelId = this.getBizModelId();
        if (!"bizmodel".equals(name) && IDUtils.isNull((Long)bizModelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\uff0c\u518d\u64cd\u4f5c\u3002", (String)"CentralRangePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        List qFilters = evt.getCustomQFilters();
        Long modelId = this.getModelId();
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        int row = evt.getRow();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        switch (name) {
            case "dimensionview": {
                DynamicObject entryentity = this.getModel().getEntryRowEntity("entryentity", row);
                DynamicObject dimensionObj = entryentity.getDynamicObject("dimension");
                if (dimensionObj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\uff0c\u518d\u64cd\u4f5c\u3002", (String)"CentralRangePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break;
                }
                qFilters.add(new QFilter("model", "=", (Object)modelId));
                Map viewGroupViewsByBusModel = modelCacheHelper.getViewGroupViewsByBusModel(this.getBizModelId());
                List viewIds = (List)viewGroupViewsByBusModel.get(dimensionObj.getString("number"));
                if (viewIds == null) {
                    viewIds = Lists.newArrayList();
                }
                qFilters.add(new QFilter("id", "in", (Object)viewIds));
                break;
            }
            case "entityrange": {
                DynamicObject entityRow = this.getModel().getEntryRowEntity("entryentity", 0);
                DynamicObject dimensionview = entityRow.getDynamicObject("dimensionview");
                if (dimensionview == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u89c6\u56fe\uff0c\u518d\u64cd\u4f5c\u3002", (String)"CentralRangePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break;
                }
                long viewId = dimensionview.getLong("id");
                MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.Entity.getNumber()), (String)ListSelectedRow.class.getName());
                f7Param.addCustomFilter(qFilters);
                f7Param.setBusModelId(bizModelId);
                f7Param.setViewId(Long.valueOf(viewId));
                f7Param.setMultiSelect(true);
                f7Param.setVerifyPermission(true);
                NewF7Utils.openF7((BeforeF7SelectEvent)evt, (MemberF7Parameter)f7Param);
                break;
            }
            case "dimension": {
                List dimensionList = modelCacheHelper.getDimensionListByBusModel(bizModelId);
                HashSet<Long> dimensionIds = new HashSet<Long>(16);
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                HashSet<Long> hasSelectDimIds = new HashSet<Long>(entryEntity.size());
                for (DynamicObject dynamicObject : entryEntity) {
                    hasSelectDimIds.add(dynamicObject.getLong("dimension.id"));
                }
                for (Dimension dimension : dimensionList) {
                    SysDimensionEnum enumByNumber = SysDimensionEnum.getEnumByNumber((String)dimension.getNumber());
                    if (enumByNumber != null && SysDimensionEnum.Account != enumByNumber) continue;
                    dimensionIds.add(dimension.getId());
                }
                FormShowParameter formShowParameter = evt.getFormShowParameter();
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addDimBack"));
                qFilters.add(new QFilter("id", "in", dimensionIds));
                qFilters.add(new QFilter("id", "not in", hasSelectDimIds));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int rowIndex;
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("bizmodel".equals(name)) {
            this.getModel().setValue("entityrange", null);
            this.getModel().deleteEntryData("entryentity");
            if (newValue != null) {
                this.presetDimension();
            }
        } else if ("dimension".equals(name)) {
            int rowIndex2 = e.getChangeSet()[0].getRowIndex();
            this.getModel().setValue("dimensionview", null, rowIndex2);
            if (newValue instanceof DynamicObject) {
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
                Dimension dimension = modelCacheHelper.getDimension(Long.valueOf(((DynamicObject)newValue).getLong("id")));
                if (SysDimensionEnum.Account.getNumber().equals(dimension.getNumber())) {
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex2, new String[]{"dimensionview"});
                } else {
                    Map viewIds = BusinessModelServiceHelper.getViewIds((Long)this.getBizModelId(), (boolean)true);
                    Long viewId = (Long)viewIds.get(dimension.getNumber());
                    this.getModel().setValue("dimensionview", (Object)viewId, rowIndex2);
                    this.getView().setEnable(Boolean.valueOf(true), rowIndex2, new String[]{"dimensionview"});
                }
            }
        } else if ("dimensionview".equals(name) && (rowIndex = e.getChangeSet()[0].getRowIndex()) == 0) {
            this.getModel().setValue("entityrange", null);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("del_dim".equals(itemKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"CentralRangePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            for (int selectRow : selectRows) {
                if (selectRow != 0) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CentralRangePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().deleteEntryRows("entryentity", selectRows);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        String actionId = event.getActionId();
        if ("addDimBack".equals(actionId) && (returnData = event.getReturnData()) != null) {
            ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            if (listSelectedRows.size() + entryEntity.size() > 11) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u53e3\u7ba1\u7406\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8d85\u8fc710\u4e2a\u3002", (String)"CentralRangePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            this.getModel().deleteEntryRow("entryentity", selectRows[0]);
            int[] rows = this.getModel().batchCreateNewEntryRow("entryentity", listSelectedRows.size());
            for (int i = 0; i < rows.length; ++i) {
                this.getModel().setValue("dimension", listSelectedRows.get(i).getPrimaryKeyValue(), rows[i]);
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opType = ((FormOperate)args.getSource()).getType();
        String needValid = this.getPageCache().get("needValid");
        if ("save".equals(opType) && StringUtils.isEmpty((CharSequence)needValid)) {
            String entityIdSetStr;
            QFilter qFilter;
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            ArrayList<Integer> emptyRows = new ArrayList<Integer>(entryEntity.size());
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject dynamicObject2 = (DynamicObject)entryEntity.get(i);
                String dimensionNumber = dynamicObject2.getString("dimension.number");
                if (StringUtils.isNotEmpty((CharSequence)dimensionNumber)) {
                    DynamicObject dimensionView = dynamicObject2.getDynamicObject("dimensionview");
                    if (SysDimensionEnum.Account.getNumber().equals(dimensionNumber) || dimensionView != null) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u597d\u7ef4\u5ea6\u89c6\u56fe\u3002", (String)"CentralRangePlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                emptyRows.add(i);
            }
            int[] array = new int[emptyRows.size()];
            for (int i = 0; i < emptyRows.size(); ++i) {
                array[i] = (Integer)emptyRows.get(i);
            }
            this.getModel().deleteEntryRows("entryentity", array);
            DynamicObjectCollection entityRange = dataEntity.getDynamicObjectCollection("entityrange");
            if (CollectionUtils.isEmpty((Collection)entityRange)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u53e3\u7ba1\u7406\u7ec4\u7ec7\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"CentralRangePlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean status = dataEntity.getBoolean("status");
            StringBuilder confirmMsg = new StringBuilder();
            boolean needConfirm = false;
            if (status) {
                boolean exists;
                Long modelId = this.getModelId();
                qFilter = new QFilter("model", "=", (Object)modelId);
                long bizModelId = dataEntity.getLong("bizmodel.id");
                qFilter.and(new QFilter("bizmodel", "=", (Object)bizModelId));
                qFilter.and("status", "=", (Object)true);
                long id = dataEntity.getLong("id");
                if (IDUtils.isNotNull((long)id)) {
                    qFilter.and("id", "!=", (Object)id);
                }
                if (exists = QueryServiceHelper.exists((String)"eb_centralrelrange", (QFilter[])qFilter.toArray())) {
                    String msg = ResManager.loadKDString((String)"\u540c\u4e00\u4e1a\u52a1\u6a21\u578b\u4ec5\u5141\u8bb8\u5b58\u5728\u4e00\u4e2a\u751f\u6548\u7684\u5f52\u53e3\u7ba1\u7406\u8303\u56f4\u3002", (String)"CentralRangePlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    if (ModelUtil.isBGModel((Long)modelId)) {
                        msg = ResManager.loadKDString((String)"\u540c\u4e00\u4f53\u7cfb\u4ec5\u5141\u8bb8\u5b58\u5728\u4e00\u4e2a\u751f\u6548\u7684\u5f52\u53e3\u7ba1\u7406\u8303\u56f4\u3002", (String)"CentralRangePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    }
                    this.getView().showTipNotification(msg);
                    args.setCancel(true);
                    return;
                }
            } else {
                Object id = this.getModel().getValue("id");
                qFilter = new QFilter("id", "=", id);
                qFilter.and("bizmodel", "=", (Object)this.getBizModelId());
                DynamicObject dynamicObject3 = BusinessDataServiceHelper.loadSingle((String)"eb_centralrelrange", (String)"id,status", (QFilter[])qFilter.toArray());
                if (dynamicObject3 != null && dynamicObject3.getBoolean("status")) {
                    DynamicObject[] load = BusinessDataServiceHelper.load((String)"eb_centralrelscheme", (String)"id", (QFilter[])new QFilter("centralrange", "=", id).toArray());
                    Set centralSchemeIds = Arrays.stream(load).map(dynamicObject1 -> dynamicObject1.getLong("id")).collect(Collectors.toSet());
                    Set approveTypeNameByCentralSchema = ApproveTypeUtils.getInstance().getApproveTypeNameByCentralSchema(centralSchemeIds);
                    if (CollectionUtils.isNotEmpty((Collection)approveTypeNameByCentralSchema)) {
                        String msg = ResManager.loadResFormat((String)"\u7ba1\u7406\u8303\u56f4\u4e0b\u6709\u5f52\u53e3\u5173\u7cfb\u65b9\u6848\u88ab\u5ba1\u6279\u7c7b\u578b\u5f15\u7528\uff0c\u662f\u5426\u7981\u7528\uff1f\u5f15\u7528\u5ba1\u6279\u7c7b\u578b\uff1a%1\u3002", (String)"CentralRangePlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)";", approveTypeNameByCentralSchema)});
                        confirmMsg.append(msg);
                        needConfirm = true;
                    }
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(entityIdSetStr = this.getPageCache().get("entityIdSet")))) {
                Set entityIdSet = (Set)SerializationUtils.deSerializeFromBase64((String)entityIdSetStr);
                Set collect = entityRange.stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                if (!collect.containsAll(entityIdSet)) {
                    needConfirm = true;
                    confirmMsg.append(ResManager.loadKDString((String)"\u53d8\u66f4\u5f52\u53e3\u7ba1\u7406\u7ec4\u7ec7\u8303\u56f4\u5c06\u4f1a\u6e05\u7a7a\u5bf9\u5e94\u5f52\u53e3\u5173\u7cfb\u65b9\u6848\uff0c\u662f\u5426\u53d8\u66f4\uff1f", (String)"CentralRangePlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
            if (needConfirm) {
                this.getView().showConfirm(confirmMsg.toString(), MessageBoxOptions.YesNo, new ConfirmCallBackListener("saveRangeConfirm", (IFormPlugin)this));
                args.setCancel(true);
            } else {
                long id = this.getModel().getDataEntity().getLong("id");
                QFilter qFilter2 = new QFilter("centralrange", "=", (Object)id);
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_centralrelscheme", (String)"id,entity", (QFilter[])qFilter2.toArray());
                Set allCentralSchemes = dynamicObjects.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
                ApproveTypeUtils.getInstance().updateCentralRelationStatus(allCentralSchemes, status);
                if (!status) {
                    CentralRelationService.getInstance().updateCentralRelationStatus(id);
                }
            }
        } else if ("newentry".equals(opType)) {
            Long bizModelId = this.getBizModelId();
            if (IDUtils.isNull((Long)bizModelId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\uff0c\u518d\u64cd\u4f5c\u3002", (String)"CentralRangePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            if (entryEntity.size() == 10) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u53e3\u7ba1\u7406\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8d85\u8fc710\u4e2a\u3002", (String)"CentralRangePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        MessageBoxResult result;
        String callBackId = event.getCallBackId();
        if ("saveRangeConfirm".equals(callBackId) && MessageBoxResult.Yes == (result = event.getResult())) {
            Set entityIdSet = new HashSet(16);
            String entityIdSetStr = this.getPageCache().get("entityIdSet");
            if (StringUtils.isNotEmpty((CharSequence)entityIdSetStr)) {
                entityIdSet = (Set)SerializationUtils.deSerializeFromBase64((String)entityIdSetStr);
            }
            DynamicObjectCollection entityRange = this.getModel().getDataEntity().getDynamicObjectCollection("entityrange");
            Set collect = entityRange.stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            entityIdSet.removeAll(collect);
            long id = this.getModel().getDataEntity().getLong("id");
            QFilter qFilter = new QFilter("centralrange", "=", (Object)id);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_centralrelscheme", (String)"id,entity", (QFilter[])qFilter.toArray());
            Set allCentralSchemes = dynamicObjects.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
            Set finalEntityIdSet = entityIdSet;
            Set updateCentralSchemes = dynamicObjects.stream().filter(dynamicObject -> finalEntityIdSet.contains(dynamicObject.getLong("entity"))).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"eb_centralrelscheme"), (Object[])updateCentralSchemes.toArray());
            CentralRelationService instance = CentralRelationService.getInstance();
            instance.delCentralRelation(updateCentralSchemes);
            instance.delCentralRelationRelationMemberQuote(new ArrayList(updateCentralSchemes));
            ApproveTypeUtils.getInstance().deleteCentralRelation(updateCentralSchemes);
            boolean status = this.getModel().getDataEntity().getBoolean("status");
            ApproveTypeUtils.getInstance().updateCentralRelationStatus(allCentralSchemes, status);
            if (!status) {
                instance.updateCentralRelationStatus(id);
            }
            this.getPageCache().remove("entityIdSet");
            this.getPageCache().put("needValid", "false");
            this.getView().invokeOperation("save");
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey)) {
            this.getView().returnDataToParent((Object)this.getModel().getDataEntity().getLong("id"));
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CentralRangePlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "CentralRangePlugin_14", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5f52\u53e3\u7ba1\u7406\u8303\u56f4\u5df2\u4fdd\u5b58\u3002", "CentralRangePlugin_15", "epm-eb-formplugin");
            this.writeLog(null, "save", opName, opDesc, null);
            this.getView().close();
        }
    }

    private Long getBizModelId() {
        Object bizmodel = this.getModel().getValue("bizmodel");
        if (bizmodel != null) {
            if (bizmodel instanceof Long) {
                return (Long)bizmodel;
            }
            if (bizmodel instanceof DynamicObject) {
                return ((DynamicObject)bizmodel).getLong("id");
            }
        }
        return 0L;
    }

    @Override
    public Long getModelId() {
        Object model = this.getModel().getValue("model");
        if (model != null) {
            if (model instanceof Long) {
                return (Long)model;
            }
            if (model instanceof DynamicObject) {
                return ((DynamicObject)model).getLong("id");
            }
        }
        return 0L;
    }
}

