/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralrelation;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.centralrelation.CentralRelationService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralrelation.CentralRelationRecord;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.excel.BgExcelWriter;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.lang3.time.DateFormatUtils;

public class CentralRelEntityQueryPlugin
extends AbstractFormPlugin {
    private static final String BTN_EXPORT = "btn_export";
    private static final String ENTRY_ENTITY = "entryentity";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_EXPORT});
    }

    public void afterCreateNewData(EventObject e) {
        this.loadPageData();
    }

    private void loadPageData() {
        this.getModel().beginInit();
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        Map<Long, List<CentralRelationRecord>> centralRelationMap = this.getCurManageEntityCentralRelation();
        if (centralRelationMap.size() > 0) {
            HashSet<Long> allSchemeIds = new HashSet<Long>(16);
            LinkedHashMap<Long, Set> entityToSchemeMap = new LinkedHashMap<Long, Set>(16);
            for (Map.Entry<Long, List<CentralRelationRecord>> entry : centralRelationMap.entrySet()) {
                Long schemeId = entry.getKey();
                List<CentralRelationRecord> value = entry.getValue();
                for (CentralRelationRecord relation : value) {
                    Set schemeIds = entityToSchemeMap.computeIfAbsent(relation.getEntityId(), e -> new HashSet(16));
                    schemeIds.add(schemeId);
                    allSchemeIds.add(schemeId);
                }
            }
            Map centralSchemeNames = CentralRelationService.getInstance().getCentralSchemeNames(allSchemeIds);
            Map centralRangeDimView = CentralRelationService.getInstance().getCentralRangeDimView(this.getCurCentralRangeId());
            int[] index = this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, entityToSchemeMap.size());
            int i = 0;
            IModelCacheHelper modelCache = this.getIModelCacheHelper();
            for (Map.Entry entry : entityToSchemeMap.entrySet()) {
                Long entityId = (Long)entry.getKey();
                Set schemeIds = (Set)entry.getValue();
                Long viewId = centralRangeDimView.getOrDefault("Entity", 0L);
                Member member = modelCache.getMember("Entity", viewId, entityId);
                if (member != null) {
                    this.getModel().setValue("entity", (Object)member.getId(), index[i]);
                    this.getModel().setValue("parent", (Object)member.getParentId(), index[i]);
                }
                if (CollectionUtils.isNotEmpty((Collection)schemeIds)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Long schemeId : schemeIds) {
                        if (centralSchemeNames.get(schemeId) == null) continue;
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(";");
                        }
                        stringBuilder.append((String)centralSchemeNames.get(schemeId));
                    }
                    this.getModel().setValue("scheme", (Object)stringBuilder.toString(), index[i]);
                }
                ++i;
            }
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private Map<Long, List<CentralRelationRecord>> getCurManageEntityCentralRelation() {
        Long curCentralRangeId = this.getCurCentralRangeId();
        Long curManageEntityId = this.getCurManageEntityId();
        return CentralRelationService.getInstance().getCentralRelationByManageEntity(curCentralRangeId, curManageEntityId);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_EXPORT.equals(key)) {
            this.export();
        }
    }

    private void export() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"CentralRelEntityQueryPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)this.getCurCentralRangeId(), (String)"eb_centralrelrange");
        Map centralRangeDimView = CentralRelationService.getInstance().getCentralRangeDimView(this.getCurCentralRangeId());
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5f52\u53e3\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"CentralRelEntityQueryPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Member member = modelCacheHelper.getMember("Entity", (Long)centralRangeDimView.get("Entity"), this.getCurManageEntityId());
        if (member == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5f52\u53e3\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"CentralRelEntityQueryPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String bizModel = dynamicObject.getString("bizmodel.number") + "#" + dynamicObject.getString("bizmodel.name");
        String manageEntity = member.getNumber() + "#" + member.getName();
        BgExcelWriter excelWriter = BgExcelWriter.getInstance().readTemplateByClasspath("centralrelation/centralEntityQuery.xlsx");
        excelWriter.createRow();
        excelWriter.createRow(new Object[]{"", ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b", (String)"CentralRelEntityQueryPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), bizModel});
        excelWriter.createRow(new Object[]{"", ResManager.loadKDString((String)"\u7ec4\u7ec7\u8303\u56f4", (String)"CentralRelEntityQueryPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), manageEntity});
        excelWriter.createRow();
        excelWriter.createRow(new Object[]{"", ResManager.loadKDString((String)"\u5f52\u53e3\u7ec4\u7ec7\u7f16\u7801", (String)"CentralRelEntityQueryPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f52\u53e3\u7ec4\u7ec7\u540d\u79f0", (String)"CentralRelEntityQueryPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u7f16\u7801", (String)"CentralRelEntityQueryPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u540d\u79f0", (String)"CentralRelEntityQueryPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f52\u53e3\u5173\u7cfb\u65b9\u6848", (String)"CentralRelEntityQueryPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0])});
        for (DynamicObject object : entryEntity) {
            String entityNumber = object.getString("entity.number");
            String entityName = object.getString("entity.name");
            String parentNumber = object.getString("parent.number");
            String parentName = object.getString("parent.name");
            String schemeName = object.getString("scheme");
            excelWriter.createRow(new Object[]{"", entityNumber, entityName, parentNumber, parentName, schemeName});
        }
        String fileName = ResManager.loadResFormat((String)"\u5f52\u53e3\u7ec4\u7ec7\u67e5\u8be2%1.xlsx", (String)"CentralRelEntityQueryPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[]{DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        String url = excelWriter.getDownloadUrl(fileName);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    private Long getCurManageEntityId() {
        return IDUtils.toLong((Object)this.getCustomFormParam("centralManageEntityId"));
    }

    private Long getCurCentralRangeId() {
        return IDUtils.toLong((Object)this.getCustomFormParam("centralRangeId"));
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getCustomFormParam("model"));
    }
}

