/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralrelation;

import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralrelation.CentralRelationRecord;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CentralRelRelationExportUtils {
    public static CentralRelRelationExportUtils getInstance() {
        return new CentralRelRelationExportUtils();
    }

    public XSSFWorkbook getExportDataExcelBook(int startCol, IModelCacheHelper modelCache, Set<String> centralRangeDim, List<CentralRelationRecord> records, Map<String, Long> centralRangeDimView) {
        ArrayList<String> centralRangeDimList = new ArrayList<String>(centralRangeDim);
        XSSFWorkbook excelBook = new XSSFWorkbook();
        XSSFSheet billSheet = excelBook.createSheet(ResManager.loadKDString((String)"\u5f52\u53e3\u5173\u7cfb", (String)"CentralRelRelationExportUtils_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.setSheetStyle(startCol, excelBook, billSheet, centralRangeDimList);
        this.createColHeaderRow(startCol, excelBook, billSheet, modelCache, centralRangeDimList);
        if (CollectionUtils.isNotEmpty(records)) {
            CellStyle dateCellStyle = this.getDateCellStyle(excelBook);
            this.createDataRows(startCol, dateCellStyle, billSheet, modelCache, centralRangeDimList, records, centralRangeDimView);
        }
        return excelBook;
    }

    public XSSFWorkbook getImportTemplateExcelBook(IModelCacheHelper modelCache, Set<String> centralRangeDim) {
        return this.getExportDataExcelBook(0, modelCache, centralRangeDim, new ArrayList<CentralRelationRecord>(0), (Map<String, Long>)ImmutableMap.of());
    }

    public XSSFWorkbook getExportRrrTemplateExcelBook(IModelCacheHelper modelCache, Set<String> centralRangeDim) {
        return this.getExportDataExcelBook(1, modelCache, centralRangeDim, new ArrayList<CentralRelationRecord>(0), (Map<String, Long>)ImmutableMap.of());
    }

    public CellStyle getTitleCellStyle(XSSFWorkbook excelBook) {
        XSSFCellStyle cellStyle = excelBook.createCellStyle();
        XSSFFont font = excelBook.createFont();
        font.setFontHeightInPoints((short)20);
        cellStyle.setFont((Font)font);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        return cellStyle;
    }

    public CellStyle getColHeaderCellStyle(XSSFWorkbook excelBook, boolean isMustInput) {
        XSSFCellStyle cellStyle = excelBook.createCellStyle();
        if (isMustInput) {
            XSSFFont font = excelBook.createFont();
            font.setColor(IndexedColors.RED.index);
            cellStyle.setFont((Font)font);
        }
        cellStyle.setFillForegroundColor(new XSSFColor(new Color(240, 240, 240), (IndexedColorMap)new DefaultIndexedColorMap()));
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        return cellStyle;
    }

    public CellStyle getDateCellStyle(XSSFWorkbook excelBook) {
        XSSFCellStyle styleDate = excelBook.createCellStyle();
        XSSFDataFormat formatDate = excelBook.createDataFormat();
        styleDate.setDataFormat(formatDate.getFormat("yyyy-MM-dd"));
        return styleDate;
    }

    public void setSheetStyle(int startCol, XSSFWorkbook excelBook, XSSFSheet billSheet, List<String> centralRangeDim) {
        billSheet.setDefaultColumnWidth(15);
        CellStyle titleCellStyle = this.getTitleCellStyle(excelBook);
        XSSFCellStyle styleDate = excelBook.createCellStyle();
        XSSFDataFormat formatDate = excelBook.createDataFormat();
        styleDate.setDataFormat(formatDate.getFormat("yyyy-MM-dd"));
        billSheet.setDefaultColumnStyle((int)((short)(centralRangeDim.size() * 2 + 1)), (CellStyle)styleDate);
        billSheet.setDefaultColumnStyle((int)((short)(centralRangeDim.size() * 2 + 2)), (CellStyle)styleDate);
        CellRangeAddress region = new CellRangeAddress(0, 0, startCol, centralRangeDim.size() * 2 + 2 + startCol);
        billSheet.addMergedRegion(region);
        XSSFRow titleRow = billSheet.createRow(0);
        titleRow.setHeight((short)500);
        XSSFCell cell = titleRow.createCell(startCol, CellType.STRING);
        cell.setCellValue(ResManager.loadKDString((String)"\u5f52\u53e3\u7ba1\u7406\u5173\u7cfb", (String)"CentralRelRelationExportUtils_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        cell.setCellStyle(titleCellStyle);
        XSSFCell cell1 = billSheet.createRow(1).createCell(startCol);
        XSSFCellStyle redMustInputTipStyle = excelBook.createCellStyle();
        XSSFFont font = excelBook.createFont();
        font.setColor(IndexedColors.RED.index);
        redMustInputTipStyle.setFont((Font)font);
        cell1.setCellStyle((CellStyle)redMustInputTipStyle);
        cell1.setCellValue(ResManager.loadKDString((String)"\u7ea2\u8272*\u5fc5\u586b", (String)"CentralRelRelationExportUtils_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        CellRangeAddressList addressList = new CellRangeAddressList(3, 5000, centralRangeDim.size() * 2 + startCol, centralRangeDim.size() * 2 + startCol);
        DataValidationHelper helper = billSheet.getDataValidationHelper();
        String[] comboItems = new String[]{ResManager.loadKDString((String)"\u542f\u7528", (String)"CentralRelRelationExportUtils_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7981\u7528", (String)"CentralRelRelationExportUtils_5", (String)"epm-eb-formplugin", (Object[])new Object[0])};
        DataValidationConstraint constraint = helper.createExplicitListConstraint(comboItems);
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        billSheet.addValidationData(dataValidation);
    }

    public void createColHeaderRow(int startCol, XSSFWorkbook excelBook, XSSFSheet billSheet, IModelCacheHelper modelCache, List<String> centralRangeDim) {
        CellStyle mustInputCellStyle = this.getColHeaderCellStyle(excelBook, true);
        CellStyle noMustInputCellStyle = this.getColHeaderCellStyle(excelBook, false);
        XSSFRow row = billSheet.createRow(2);
        int i = startCol;
        for (String dimNumber : centralRangeDim) {
            XSSFCell cell1 = row.createCell(i++, CellType.STRING);
            XSSFCell cell2 = row.createCell(i++, CellType.STRING);
            if ("Entity".equals(dimNumber)) {
                cell1.setCellStyle(mustInputCellStyle);
                cell2.setCellStyle(noMustInputCellStyle);
                cell1.setCellValue(ResManager.loadKDString((String)"*\u5f52\u53e3\u7ec4\u7ec7\u7f16\u7801", (String)"CentralRelRelationExportUtils_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                cell2.setCellValue(ResManager.loadKDString((String)"\u5f52\u53e3\u7ec4\u7ec7\u540d\u79f0", (String)"CentralRelRelationExportUtils_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            Dimension dimension = modelCache.getDimension(dimNumber);
            if (dimension == null) continue;
            cell1.setCellStyle(noMustInputCellStyle);
            cell2.setCellStyle(noMustInputCellStyle);
            cell1.setCellValue(ResManager.loadResFormat((String)"%1\u7f16\u7801", (String)"CentralRelRelationExportUtils_8", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getName()}));
            cell2.setCellValue(ResManager.loadResFormat((String)"%1\u540d\u79f0", (String)"CentralRelRelationExportUtils_9", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getName()}));
        }
        XSSFCell cell3 = row.createCell(i++, CellType.STRING);
        cell3.setCellStyle(noMustInputCellStyle);
        cell3.setCellValue(ResManager.loadKDString((String)"\u72b6\u6001", (String)"CentralRelRelationExportUtils_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        XSSFDrawing p = billSheet.createDrawingPatriarch();
        XSSFCell cell4 = row.createCell(i, CellType.STRING);
        cell4.setCellStyle(noMustInputCellStyle);
        cell4.setCellValue(ResManager.loadKDString((String)"\u542f\u7528\u65e5\u671f", (String)"CentralRelRelationExportUtils_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        XSSFComment comment1 = p.createCellComment((ClientAnchor)new XSSFClientAnchor(2, 2, i, i, 3, 3, 5, 6));
        comment1.setString((RichTextString)new XSSFRichTextString(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\uff1aYY-MM-DD\u3002", (String)"CentralRelRelationExportUtils_13", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        cell4.setCellComment((Comment)comment1);
        XSSFCell cell5 = row.createCell(++i, CellType.STRING);
        cell5.setCellStyle(noMustInputCellStyle);
        cell5.setCellValue(ResManager.loadKDString((String)"\u7981\u7528\u65e5\u671f", (String)"CentralRelRelationExportUtils_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        XSSFComment comment2 = p.createCellComment((ClientAnchor)new XSSFClientAnchor(2, 2, i, i, 3, 3, 5, 6));
        comment2.setString((RichTextString)new XSSFRichTextString(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\uff1aYY-MM-DD\u3002", (String)"CentralRelRelationExportUtils_13", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        cell5.setCellComment((Comment)comment2);
    }

    public boolean checkTemplateFormat(IModelCacheHelper modelCache, Set<String> centralRangeDim, List<String> headerList) {
        List<String> colHeaderList = this.getColHeaderList(modelCache, centralRangeDim);
        for (int i = 0; i < colHeaderList.size(); ++i) {
            if (StringUtils.equals((String)colHeaderList.get(i), (String)headerList.get(i))) continue;
            return true;
        }
        return false;
    }

    private List<String> getColHeaderList(IModelCacheHelper modelCache, Set<String> centralRangeDim) {
        ArrayList<String> colHeaderList = new ArrayList<String>(10);
        for (String dimNumber : centralRangeDim) {
            String number = null;
            String name = null;
            if ("Entity".equals(dimNumber)) {
                number = ResManager.loadKDString((String)"*\u5f52\u53e3\u7ec4\u7ec7\u7f16\u7801", (String)"CentralRelRelationExportUtils_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                name = ResManager.loadKDString((String)"\u5f52\u53e3\u7ec4\u7ec7\u540d\u79f0", (String)"CentralRelRelationExportUtils_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            } else {
                Dimension dimension = modelCache.getDimension(dimNumber);
                if (dimension != null) {
                    number = ResManager.loadResFormat((String)"%1\u7f16\u7801", (String)"CentralRelRelationExportUtils_8", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getName(), dimension.getNumber()});
                    name = ResManager.loadResFormat((String)"%1\u540d\u79f0", (String)"CentralRelRelationExportUtils_9", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getName(), dimension.getNumber()});
                }
            }
            colHeaderList.add(number);
            colHeaderList.add(name);
        }
        colHeaderList.add(ResManager.loadKDString((String)"\u72b6\u6001", (String)"CentralRelRelationExportUtils_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        colHeaderList.add(ResManager.loadKDString((String)"\u542f\u7528\u65e5\u671f", (String)"CentralRelRelationExportUtils_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        colHeaderList.add(ResManager.loadKDString((String)"\u7981\u7528\u65e5\u671f", (String)"CentralRelRelationExportUtils_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return colHeaderList;
    }

    public void createDataRows(int startCol, CellStyle dateCellStyle, XSSFSheet billSheet, IModelCacheHelper modelCache, List<String> centralRangeDim, List<CentralRelationRecord> records, Map<String, Long> centralRangeDimView) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        int rowIndex = 3;
        for (CentralRelationRecord record : records) {
            XSSFRow row = billSheet.createRow(rowIndex++);
            int i = startCol;
            Map centralDimMemberInfo = record.getCentralDimMemberInfo();
            for (String dimNumber : centralRangeDim) {
                Member member;
                MemberCondition condition;
                XSSFCell cell1 = row.createCell(i++, CellType.STRING);
                XSSFCell cell2 = row.createCell(i++, CellType.STRING);
                if ("Entity".equals(dimNumber)) {
                    Member member2 = modelCache.getMember(dimNumber, centralRangeDimView.get("Entity"), record.getEntityId());
                    if (member2 == null) continue;
                    cell1.setCellValue(member2.getNumber());
                    cell2.setCellValue(member2.getName());
                    continue;
                }
                if (centralDimMemberInfo == null || (condition = (MemberCondition)centralDimMemberInfo.get(dimNumber)) == null || (member = modelCache.getMember(dimNumber, IDUtils.toLong((Object)condition.getViewId()), condition.getNumber())) == null) continue;
                cell1.setCellValue(member.getNumber());
                RangeEnum rangeEnum = member.isLeaf() ? RangeEnum.ONLY : RangeEnum.ALL;
                cell2.setCellValue(member.getName() + "_" + rangeEnum.getName());
            }
            XSSFCell cell3 = row.createCell(i++, CellType.STRING);
            cell3.setCellValue(record.isStatus() ? ResManager.loadKDString((String)"\u542f\u7528", (String)"CentralRelRelationExportUtils_4", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528", (String)"CentralRelRelationExportUtils_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            XSSFCell cell4 = row.createCell(i++, CellType.STRING);
            cell4.setCellStyle(dateCellStyle);
            if (record.getEnableDate() != null) {
                cell4.setCellValue(sdf.format(record.getEnableDate()));
            }
            XSSFCell cell5 = row.createCell(i, CellType.STRING);
            cell5.setCellStyle(dateCellStyle);
            if (record.getDisableDate() == null) continue;
            cell5.setCellValue(sdf.format(record.getDisableDate()));
        }
    }
}

