/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralrelation;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.epm.eb.business.centralrelation.CentralRelationService;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class CentralRelationBatchSetting
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String EDIT_FIELD = "field";
    private static final String PRE_DIM = "dim_";
    private static final String USER_DEFINE = "userdefine";
    private static final String DIM_ENTITY = "dim_entity";
    private static final String ENABLE_DATE = "enabledate";
    private static final String DISABLE_DATE = "disabledate";
    private static final String PRE_IN_BASE_CLASS_FIELD = "itemclasstypefield";
    private static final String PRE_IN_BASE_DATA_FIELD = "basedatafield";
    private static final String PRE_IN_DATE_FIELD = "datefield";
    private static final String CACHE_FIELD_NAME_MAP = "cache_field_name_map";
    private static final String CACHE_DIM_FIELD_MAP = "cache_dim_field_map";
    private static final String CALL_BACK_DIM_F7 = "dimF7SelectCallBack";
    private static final Set<String> preInFiled = Sets.newHashSet((Object[])new String[]{"basedatafield", "datefield"});
    private static final CentralRelationService centralRelationService = CentralRelationService.getInstance();

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        BasedataEdit entityControl = (BasedataEdit)this.getControl(PRE_IN_BASE_DATA_FIELD);
        entityControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.dynamicCreateComboField();
        this.showMappingFiled();
    }

    private void dynamicCreateComboField() {
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        HashMap<String, String> filedNameMap = new HashMap<String, String>(16);
        HashMap<String, String> dimNumberToFieldMap = new HashMap<String, String>(16);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        Map centralRangeDimView = centralRelationService.getCentralRangeDimView(this.getCentralRangeId());
        int i = 1;
        for (Map.Entry entry : centralRangeDimView.entrySet()) {
            String dimNumber = (String)entry.getKey();
            Dimension dimension = modelCacheHelper.getDimension(dimNumber);
            if (dimension == null) continue;
            String dimName = dimension.getName();
            if ("Entity".equals(dimension.getNumber())) {
                dimName = ResManager.loadKDString((String)"\u5f52\u53e3\u7ec4\u7ec7", (String)"CentralRelationBatchSetting_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
            String filedKey = dimension.isPreset() ? PRE_DIM + dimNumber.toLowerCase() : "dim_userdefine" + i++;
            items.add(new ComboItem(new LocaleString(dimName), filedKey));
            filedNameMap.put(filedKey, dimName);
            dimNumberToFieldMap.put(dimNumber, filedKey);
            dimNumberToFieldMap.put(filedKey, dimNumber);
        }
        String enableDate = ResManager.loadKDString((String)"\u542f\u7528\u65e5\u671f", (String)"CentralRelationBatchSetting_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        items.add(new ComboItem(new LocaleString(enableDate), ENABLE_DATE));
        filedNameMap.put(ENABLE_DATE, enableDate);
        String disableDate = ResManager.loadKDString((String)"\u7981\u7528\u65e5\u671f", (String)"CentralRelationBatchSetting_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        items.add(new ComboItem(new LocaleString(disableDate), DISABLE_DATE));
        filedNameMap.put(DISABLE_DATE, disableDate);
        ComboEdit comboEdit = (ComboEdit)this.getControl(EDIT_FIELD);
        comboEdit.setComboItems(items);
        this.getModel().setValue(EDIT_FIELD, (Object)DIM_ENTITY);
        this.getPageCache().put(CACHE_FIELD_NAME_MAP, SerializationUtils.serializeToBase64(filedNameMap));
        this.getPageCache().put(CACHE_DIM_FIELD_MAP, SerializationUtils.serializeToBase64(dimNumberToFieldMap));
    }

    private Map<String, String> getFiledNameMap() {
        String cache = this.getPageCache().get(CACHE_FIELD_NAME_MAP);
        if (cache != null) {
            return (Map)SerializationUtils.deSerializeFromBase64((String)cache);
        }
        return new HashMap<String, String>(0);
    }

    private Map<String, String> getDimToFieldMap() {
        String cache = this.getPageCache().get(CACHE_DIM_FIELD_MAP);
        if (cache != null) {
            return (Map)SerializationUtils.deSerializeFromBase64((String)cache);
        }
        return new HashMap<String, String>(0);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (key.equals(EDIT_FIELD)) {
            String newValue = (String)e.getChangeSet()[0].getNewValue();
            this.getPageCache().put(EDIT_FIELD, newValue);
            this.showMappingFiled();
        }
    }

    private void showMappingFiled() {
        String curBatchEditField = this.getCurBatchEditField();
        String valueField = this.getValueField(curBatchEditField);
        this.getView().setVisible(Boolean.valueOf(false), preInFiled.toArray(new String[0]));
        if (StringUtils.isNotEmpty((String)valueField)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{valueField});
            Control control = this.getControl(valueField);
            if (control instanceof FieldEdit) {
                String valueFieldName = this.getFiledNameMap().get(curBatchEditField);
                if (valueFieldName == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u9884\u5236\u503c\u5b57\u6bb5\u540d\u79f0\u3002", (String)"CentralRelationBatchSetting_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                ((FieldEdit)control).setCaption(new LocaleString(valueFieldName));
            }
            if (PRE_IN_BASE_DATA_FIELD.equals(valueField)) {
                String dimNumber = this.getDimToFieldMap().get(curBatchEditField);
                this.getModel().setValue(PRE_IN_BASE_CLASS_FIELD, (Object)SysDimensionEnum.getMemberTreemodelByNumber((String)dimNumber));
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.returnParentData();
        }
    }

    private void returnParentData() {
        String curBatchEditField = this.getCurBatchEditField();
        String valueField = this.getValueField(curBatchEditField);
        Object value = this.getModel().getValue(valueField);
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("curBatchEditField", curBatchEditField);
        data.put("value", value);
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String f7Key = event.getProperty().getName();
        if (PRE_IN_BASE_DATA_FIELD.equals(f7Key)) {
            this.dimMemberBeforeF7(event);
        }
    }

    private void dimMemberBeforeF7(BeforeF7SelectEvent event) {
        DynamicObject value;
        Long centralRangeId = this.getCentralRangeId();
        String curBatchEditField = this.getCurBatchEditField();
        String valueField = this.getValueField(curBatchEditField);
        String dimNumber = this.getDimToFieldMap().get(curBatchEditField);
        Map centralRangeDimView = centralRelationService.getCentralRangeDimView(centralRangeId);
        Long viewId = (Long)centralRangeDimView.get(dimNumber);
        Long modelId = this.getModelId();
        Long bizModelId = centralRelationService.getCentralRangeBizModelId(centralRangeId);
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
        f7Param.setCanSelectRoot(false);
        f7Param.setBusModelId(bizModelId);
        if (IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) {
            f7Param.setViewId(viewId);
        }
        if ((value = (DynamicObject)this.getModel().getValue(valueField)) != null) {
            f7Param.setSelectId(Long.valueOf(value.getLong("id")));
        }
        NewF7Utils.openF7((BeforeF7SelectEvent)event, (MemberF7Parameter)f7Param);
    }

    public String getCurBatchEditField() {
        return (String)this.getModel().getValue(EDIT_FIELD);
    }

    private String getValueField(String field) {
        if (field.startsWith(PRE_DIM)) {
            return PRE_IN_BASE_DATA_FIELD;
        }
        if (ENABLE_DATE.equals(field) || DISABLE_DATE.equals(field)) {
            return PRE_IN_DATE_FIELD;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u9884\u5236\u503c\u5b57\u6bb5\u3002", (String)"CentralRelationBatchSetting_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    public Long getSchemeId() {
        return IDUtils.toLong((Object)this.getCustomFormParam("scheme"));
    }

    public Long getCentralRangeId() {
        return IDUtils.toLong((Object)this.getCustomFormParam("centralRangeId"));
    }

    @Override
    public Long getModelId() {
        return (Long)this.getCustomFormParam("model");
    }
}

