/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralrelation;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.centralrelation.CentralRelationService;
import kd.epm.eb.common.applyTemplate.helper.ExcelHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralrelation.CentralRelationRecord;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UploadUtil;
import kd.epm.eb.common.utils.excel.BgExcelReader;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.centralrelation.CentralRelRelationExportUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CentralRelationImportPlugin
extends AbstractBasePlugin
implements UploadListener {
    protected static Log log = LogFactory.getLog(CentralRelationImportPlugin.class);
    private static final String BTN_CANCEL = "btncancel";
    private static final String BTN_DOWNLOAD = "btndownload";
    private static final String BTN_OK = "btnok";
    CentralRelRelationExportUtils exportUtils = CentralRelRelationExportUtils.getInstance();
    CentralRelationService centralRelationService = CentralRelationService.getInstance();

    public void afterCreateNewData(EventObject e) {
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>(16);
        dataMap.put("maxatmcount", 1);
        this.getView().updateControlMetadata("attachmentpanelap", dataMap);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"newandcover"});
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CANCEL, BTN_DOWNLOAD, BTN_OK});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.importData();
                break;
            }
            case "btndownload": {
                this.downImportTemplate();
                break;
            }
        }
    }

    private void downImportTemplate() {
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Set centralRangeDim = this.centralRelationService.getCentralRangeDim(this.getCentralRangeId());
        XSSFWorkbook importTemplateExcelBook = this.exportUtils.getImportTemplateExcelBook(orCreate, centralRangeDim);
        try {
            ExcelHelper.downloadExcel((XSSFWorkbook)importTemplateExcelBook, (String)ResManager.loadKDString((String)"\u5f52\u53e3\u5173\u7cfb\u5bfc\u5165\u6a21\u677f", (String)"CentralRelationImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), (IFormView)this.getView());
        }
        catch (IOException e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadResFormat((String)"\u4e0b\u8f7dExcel\u53d1\u751f\u5f02\u5e38\uff1a%1\u3002", (String)"CentralRelationImportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{ThrowableHelper.toString((Exception)e)}));
        }
    }

    private void importData() {
        String fileUrl = this.getPageCache().get("file_url");
        if (StringUtils.isBlank((CharSequence)fileUrl)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u9644\u4ef6\u3002", (String)"CentralRelationImportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        IModelCacheHelper modelCache = this.getIModelCacheHelper();
        Long centralRangeId = this.getCentralRangeId();
        Map centralRangeDimView = this.centralRelationService.getCentralRangeDimView(centralRangeId);
        Set<String> centralRangeDim = centralRangeDimView.keySet();
        List<List<String>> dataList = this.readExcelData(centralRangeDim, fileUrl);
        if (CollectionUtils.isEmpty(dataList) || dataList.get(0) == null || this.exportUtils.checkTemplateFormat(modelCache, centralRangeDim, dataList.get(0))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        dataList.remove(0);
        dataList.removeIf(e -> e.stream().allMatch(StringUtils::isEmpty));
        if (this.checkExcelDataList(dataList, modelCache, centralRangeDim)) {
            XSSFWorkbook xssfWorkbook = this.exportUtils.getExportRrrTemplateExcelBook(modelCache, centralRangeDim);
            int rowIndex = 3;
            XSSFSheet sheet = xssfWorkbook.getSheetAt(0);
            for (List<String> list : dataList) {
                XSSFRow row = sheet.createRow(rowIndex++);
                for (int i = 0; i < list.size(); ++i) {
                    XSSFCell cell = row.createCell(i);
                    cell.setCellValue(list.get(i));
                }
            }
            try {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u5bfc\u5165\u9519\u8bef\u8be6\u60c5\u3002", (String)"CentralSchemeImportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                ExcelHelper.downloadExcel((XSSFWorkbook)xssfWorkbook, (String)ResManager.loadKDString((String)"\u5f52\u53e3\u5173\u7cfb\u5bfc\u5165\u9519\u8bef\u8be6\u60c5", (String)"CentralRelationImportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), (IFormView)this.getView());
            }
            catch (IOException e2) {
                log.error((Throwable)e2);
                throw new KDBizException(ResManager.loadResFormat((String)"\u4e0b\u8f7dExcel\u53d1\u751f\u5f02\u5e38\uff1a%1\u3002", (String)"CentralRelationImportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{ThrowableHelper.toString((Exception)e2)}));
            }
            return;
        }
        List<CentralRelationRecord> mapObjList = this.toObj(dataList, modelCache, centralRangeDimView);
        if (mapObjList.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6709\u6548\u6570\u636e\u3002", (String)"CentralRelationImportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent(mapObjList);
        this.getView().close();
    }

    private List<CentralRelationRecord> toObj(List<List<String>> dataList, IModelCacheHelper modelCache, Map<String, Long> centralRangeDimView) {
        ArrayList<CentralRelationRecord> records = new ArrayList<CentralRelationRecord>(10);
        boolean centralRangeStatus = this.centralRelationService.getCentralRangeStatus(this.getCentralRangeId());
        Long centralSchemeId = this.getCentralSchemeId();
        Long userId = this.getUserId();
        Date now = TimeServiceHelper.now();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setLenient(false);
        for (List<String> list : dataList) {
            String status;
            CentralRelationRecord record = new CentralRelationRecord();
            records.add(record);
            record.setSchemeId(centralSchemeId);
            record.setModifier(userId);
            record.setModifyDate(now);
            int i = 1;
            for (Map.Entry<String, Long> entry : centralRangeDimView.entrySet()) {
                Member member;
                String dimNumber = entry.getKey();
                Long viewId = entry.getValue();
                String memNum = list.get(i);
                if (StringUtils.isNotEmpty((CharSequence)memNum) && (member = modelCache.getMember(dimNumber, viewId, memNum)) != null) {
                    if ("Entity".equals(dimNumber)) {
                        record.setEntityId(member.getId());
                    } else {
                        record.addCentralDimMemberInfo(viewId, member, RangeEnum.ALL);
                    }
                }
                i += 2;
            }
            if ((status = list.get(i++)) != null) {
                record.setStatus(status.equals(ResManager.loadKDString((String)"\u542f\u7528", (String)"CentralRelRelationExportUtils_4", (String)"epm-eb-formplugin", (Object[])new Object[0])));
            } else {
                record.setStatus(centralRangeStatus);
            }
            String enableDate = list.get(i++);
            Date formatDate = now;
            if (enableDate != null) {
                try {
                    formatDate = StringUtils.isNumeric((CharSequence)enableDate) ? DateUtil.getJavaDate((double)Double.parseDouble(enableDate)) : sdf.parse(enableDate);
                }
                catch (ParseException viewId) {
                    // empty catch block
                }
            }
            record.setEnableDate(formatDate);
            String disableDate = list.get(i);
            if (disableDate == null) continue;
            Date date = null;
            try {
                date = StringUtils.isNumeric((CharSequence)disableDate) ? DateUtil.getJavaDate((double)Double.parseDouble(disableDate)) : sdf.parse(disableDate);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            record.setDisableDate(date);
        }
        return records;
    }

    private boolean checkExcelDataList(List<List<String>> dataList, IModelCacheHelper modelCache, Set<String> centralRangeDim) {
        boolean existErr = false;
        Long centralRangeId = this.getCentralRangeId();
        Long bizModelId = this.centralRelationService.getCentralRangeBizModelId(centralRangeId);
        boolean centralRangeStatus = this.centralRelationService.getCentralRangeStatus(centralRangeId);
        Map centralRangeDimView = this.centralRelationService.getCentralRangeDimView(centralRangeId);
        Map permMemberNums = this.centralRelationService.getPermMemNums(centralRangeDim, this.getModelId(), bizModelId, centralRangeDimView);
        for (List<String> list : dataList) {
            int i = 0;
            ArrayList<String> errTipInfo = new ArrayList<String>(5);
            for (String dimNumber : centralRangeDim) {
                String memNum = list.get(i);
                if (StringUtils.isNotEmpty((CharSequence)memNum)) {
                    Long viewId = (Long)centralRangeDimView.get(dimNumber);
                    Set permMemNums = (Set)permMemberNums.get(dimNumber);
                    Member member = modelCache.getMember(dimNumber, viewId, memNum);
                    if (member == null || "Account".equals(dimNumber) && !this.isInCurrentBizModelAccount(modelCache, member, bizModelId) || member.getNumber().equals(dimNumber) && SysDimensionEnum.include((String)dimNumber, (Boolean)true)) {
                        errTipInfo.add(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c1%\u201d\u7684\u6210\u5458\u201c%2\u201d\u4e0d\u5728\u5f53\u524d\u5f52\u53e3\u65b9\u6848\u5bf9\u5e94\u7684\u5f52\u53e3\u7ba1\u7406\u8303\u56f4\u5185\u3002", (String)"CentralRelationImportPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{modelCache.getDimension(dimNumber).getName(), memNum}));
                    } else if (permMemNums != null && !permMemNums.contains(member.getNumber())) {
                        errTipInfo.add(ResManager.loadResFormat((String)"\u6ca1\u6709%1\u6210\u5458%2\u7684\u6210\u5458\u6570\u636e\u6743\u9650\u3002", (String)"CentralRelationImportPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[]{modelCache.getDimension(dimNumber).getName(), memNum}));
                    }
                } else if ("Entity".equals(dimNumber)) {
                    errTipInfo.add(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5f52\u53e3\u7ec4\u7ec7\u7f16\u7801\u3002", (String)"CentralRelationImportPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                i += 2;
            }
            String status = list.get(i);
            if (StringUtils.isNotEmpty((CharSequence)status)) {
                if (!ResManager.loadKDString((String)"\u542f\u7528", (String)"CentralRelRelationExportUtils_4", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(status) && !ResManager.loadKDString((String)"\u7981\u7528", (String)"CentralRelRelationExportUtils_5", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(status)) {
                    errTipInfo.add(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u72b6\u6001\u3002", (String)"CentralRelationImportPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else if (!centralRangeStatus && ResManager.loadKDString((String)"\u542f\u7528", (String)"CentralRelRelationExportUtils_4", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(status)) {
                    errTipInfo.add(ResManager.loadKDString((String)"\u5f53\u524d\u5f52\u53e3\u5173\u7cfb\u65b9\u6848\u7684\u5f52\u53e3\u7ba1\u7406\u8303\u56f4\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u542f\u7528\u5f52\u53e3\u5173\u7cfb\u3002", (String)"CentralRelationSettingPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
            if (!errTipInfo.isEmpty()) {
                list.add(0, StringUtils.join((Object[])errTipInfo.toArray(), (String)";"));
                existErr = true;
                continue;
            }
            list.add(0, "");
        }
        return existErr;
    }

    private boolean isInCurrentBizModelAccount(IModelCacheHelper modelCache, Member member, Long bizModelId) {
        Long datasetId = member.getDatasetId();
        if (IDUtils.isNotEmptyLong((Long)datasetId).booleanValue()) {
            return IDUtils.equals((Object)bizModelId, (Object)modelCache.getBusModelByDataSet(datasetId));
        }
        return false;
    }

    private List<List<String>> readExcelData(Set<String> centralRangeDim, String fileUrl) {
        int endColIndex = centralRangeDim.size() * 2 + 2;
        List inputStreams = UploadUtil.getFileInputStreams((String)fileUrl);
        ArrayList<List<String>> dataList = new ArrayList<List<String>>(10);
        try {
            for (InputStream inputStream : inputStreams) {
                BgExcelReader excelReader = BgExcelReader.getInstance().readByInputstream(inputStream);
                List data = excelReader.readString(2, 0, endColIndex);
                dataList.addAll(data);
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20Excel\u6587\u6863\u3002", (String)"CentralRelationImportPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return dataList;
    }

    private Long getCentralSchemeId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("centralSchemeId"));
    }

    private Long getCentralRangeId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("centralRangeId"));
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        String file_url = this.getPageCache().get("file_url");
        List urls = null;
        urls = file_url == null ? new ArrayList(10) : (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object url : evt.getUrls()) {
            urls.add((String)((Map)url).get("url"));
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString(urls));
    }

    public void afterRemove(UploadEvent evt) {
        String file_url = this.getPageCache().get("file_url");
        if (file_url != null) {
            Object[] objects;
            List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
            for (Object object : objects = evt.getUrls()) {
                String url = (String)((Map)object).get("url");
                urls.remove(url);
            }
            this.getPageCache().put("file_url", SerializationUtils.toJsonString((Object)urls));
        }
    }
}

