/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralrelation;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.centralrelation.CentralRelationService;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class CentralRelationSchemePlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        this.presetData();
    }

    private void presetData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String openType = (String)formShowParameter.getCustomParam("openType");
        Long centralRange = (Long)formShowParameter.getCustomParam("centralrange");
        Long entity = (Long)formShowParameter.getCustomParam("entity");
        Long model = (Long)formShowParameter.getCustomParam("model");
        if ("edit".equals(openType)) {
            String defaultNumber = CentralRelationService.getInstance().getDefaultRelSchemeNumber(model, entity, centralRange);
            this.getModel().setValue("name", (Object)ResManager.getLocaleString((String)"\u9ed8\u8ba4\u5f52\u53e3\u5173\u7cfb\u65b9\u6848", (String)"CentralRelationSettingPlugin_7", (String)"epm-eb-formplugin"));
            this.getModel().setValue("number", (Object)defaultNumber);
        }
        this.getModel().setValue("centralrange", (Object)centralRange);
        this.getModel().setValue("entity", (Object)entity);
    }

    @Override
    public Long getModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("model");
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opType = ((FormOperate)args.getSource()).getType();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String number = dataEntity.getString("number");
        String name = dataEntity.getString("name");
        String numberError = NumberCheckUtils.checkNumberRule((String)number);
        if (StringUtils.isNotEmpty((CharSequence)numberError)) {
            this.getView().showTipNotification(numberError);
            args.setCancel(true);
            return;
        }
        if (name == null || StringUtils.isEmpty((CharSequence)name.trim())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"CentralRelationSettingPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if ("save".equals(opType)) {
            boolean exists;
            QFilter qFilter = new QFilter("centralrange.model", "=", (Object)this.getModelId()).and("number", "=", (Object)number);
            Object id = this.getModel().getValue("id");
            if (IDUtils.isNotNull((Long)IDUtils.toLong((Object)id))) {
                qFilter.and("id", "!=", id);
            }
            if (exists = QueryServiceHelper.exists((String)"eb_centralrelscheme", (QFilter[])qFilter.toArray())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u4e00\u4f53\u7cfb\u4e0b\u5f52\u53e3\u5173\u7cfb\u65b9\u6848\u7f16\u7801\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"CentralRelationSettingPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey)) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CentralRelationSettingPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.writeLog("save", new MultiLangEnumBridge("\u4fdd\u5b58", "CentralRangePlugin_14", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5f52\u53e3\u5173\u7cfb\u65b9\u6848\u5df2\u4fdd\u5b58\u3002", "CentralRangePlugin_18", "epm-eb-formplugin"));
            List successPkIds = args.getOperationResult().getSuccessPkIds();
            this.getView().returnDataToParent(successPkIds.get(0));
            this.getView().close();
        }
    }
}

