/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralrelation;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.approvetype.ApproveTypeUtils;
import kd.epm.eb.business.centralrelation.CentralRelationService;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.applyTemplate.helper.ExcelHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralrelation.CentralRelationRecord;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.centralrelation.CentralRelRelationExportUtils;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CentralRelationSettingPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TabSelectListener,
BeforeF7SelectListener {
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_SAVE = "btn_save";
    private static final String BTN_QUERY_CENTRAL_ORG = "btn_querycentralorg";
    private static final String BTN_CLOSE = "btn_close";
    private static final String TOOL_BARAP = "toolbarap";
    private static final String TREE_VIEW_AP = "treeviewap";
    protected static final String TAB_AP = "tabap";
    private static final String ADD_SCHEME = "add_scheme";
    private static final String EDIT_SCHEME = "edit_scheme";
    private static final String DELETE_SCHEME = "delete_scheme";
    private static final String TOOL_BAR = "advcontoolbarap";
    private static final String ADD_RELATION = "add_relation";
    private static final String DEL_RELATION = "del_relation";
    private static final String ENABLE_RELATION = "enable_relation";
    private static final String DISABLE_RELATION = "disable_relation";
    private static final String IMPORT_RELATION = "import_relation";
    private static final String EXPORT_SEL_RELATION = "export_selrelation";
    private static final String EXPORT_ALL_RELATION = "export_allrelation";
    private static final String BATCH_SET_RELATION = "batch_set_relation";
    private static final String ADD_RANGE = "add_range";
    private static final String EDIT_RANGE = "edit_range";
    private static final String DELETE_RANGE = "delete_range";
    protected static final String ENTRY_ENTITY = "entryentity";
    private static final String DIM_ENTITY = "dim_entity";
    private static final String ENABLE_DATE = "enabledate";
    private static final String DISABLE_DATE = "disabledate";
    private static final String STATUS = "status";
    private static final String MODIFIER = "modifier";
    private static final String MODIFY_DATE = "modifydate";
    private static final String ADD_RANGE_CALLBACK = "addRangeBack";
    private static final String BATCH_SETTING_CALLBACK = "batchSettingCallBack";
    private static final String ADD_RELSCHEME_BACK = "addRelSchemeBack";
    private static final String DIM_F7_SELECT_CALL_BACK = "dimF7SelectCallBack";
    private static final String CENTRAL_IMPORT_CALL_BACK = "centralRelationCallBack";
    private static final String DELETE_RANGE_CONFIRM = "deleteRangeConfirm";
    private static final String DELETE_RELSCHEME_CONFIRM = "deleteRelSchemeConfirm";
    private static final String TREE_NODE_CLICK_CONFIRM = "treeNodeClickConfirm";
    private static final String TAB_SELECTED_CONFIRM = "tabSelectedConfirm";
    private static final String CLOSE_PAGE_CONFIRM = "closePageConfirm";
    private static final String REFRESH_PAGE_CONFIRM = "refreshPageConfirm";
    private static final String PRE_DIM_FIELD = "dim_";
    private static final String USER_DEFINE = "userdefine";
    protected static final String LEFT_TREE_CACHE = "lefttreecache";
    private static final String CURRENT_NODE_ID = "currentClickNodeId";
    protected static final String CURRENT_TAB_ID = "currentSelectTabId";
    protected static final String DIM_TO_CONTROL_KEY = "dimToControlKeyMap";
    private static final String DATA_CHANGE = "dataChangeSign";
    private static final String TAB_ID_FOR_CONFIRM = "tabIdForConfirm";
    private static final String NODE_ID_FOR_CONFIRM = "nodeIdForConfirm";
    private static final String SELECTING_SIGN = "selectingSign";
    public static final List<String> preDimCols = Arrays.asList("dim_entity", "dim_account", "dim_userdefine1", "dim_userdefine2", "dim_userdefine3", "dim_userdefine4", "dim_userdefine5", "dim_userdefine6", "dim_userdefine7", "dim_userdefine8", "dim_userdefine9", "dim_userdefine10");
    public static final List<String> preDimNameCols = Arrays.asList("dim_entityname", "dim_accountname", "dim_userdefinename1", "dim_userdefinename2", "dim_userdefinename3", "dim_userdefinename4", "dim_userdefinename5", "dim_userdefinename6", "dim_userdefinename7", "dim_userdefinename8", "dim_userdefinename9", "dim_userdefinename10");
    private static final Log log = LogFactory.getLog(CentralRelationSettingPlugin.class);
    private static final CentralRelationService centralRelationService = CentralRelationService.getInstance();
    private static final CentralRelRelationExportUtils exportUtils = CentralRelRelationExportUtils.getInstance();

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOL_BAR, TOOL_BARAP});
        this.addClickListeners(new String[]{ADD_RANGE, EDIT_RANGE, DELETE_RANGE, ADD_SCHEME, EDIT_SCHEME, DELETE_SCHEME, "searchbefore", "searchnext"});
        TreeView leftTree = (TreeView)this.getControl(TREE_VIEW_AP);
        leftTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        for (String preDimCol : preDimCols) {
            BasedataEdit dimF7 = (BasedataEdit)this.getControl(preDimCol);
            if (dimF7 == null) continue;
            dimF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit model = (BasedataEdit)this.getControl("model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(event -> {
            if (this.getDataChange()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u53e3\u5173\u7cfb\u4fe1\u606f\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"CentralRelationSettingPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), this.getView(), this.getPageCache(), new TreeSearchUtil.TreeSearchParam(TREE_VIEW_AP, LEFT_TREE_CACHE));
            this.afterSearchClick();
        });
        Tab tab = (Tab)this.getControl(TAB_AP);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    private void afterSearchClick() {
        String treeViewCache = this.getPageCache().get(LEFT_TREE_CACHE);
        if (StringUtils.isEmpty((CharSequence)treeViewCache)) {
            return;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeViewCache, TreeNode.class);
        String oldNodeCacheName = this.getPageCache().get("oldNodeCacheName");
        String currentNodeId = this.getCurrentTreeNodeId();
        TreeNode treeNode = root.getTreeNode(currentNodeId);
        if (StringUtils.isNotEmpty((CharSequence)oldNodeCacheName)) {
            treeNode = (TreeNode)SerializationUtils.deSerializeFromBase64((String)oldNodeCacheName);
        }
        if (treeNode != null) {
            this.treeNodeClick(new TreeNodeEvent((Object)this, (Object)treeNode.getParentid(), (Object)treeNode.getId()));
        }
    }

    public void afterCreateNewData(EventObject e) {
        Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
        if (!IDUtils.isNotNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"CentralRelationSettingPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("model", (Object)modelId);
        this.getPageCache().put("model", modelId.toString());
        this.refreshLeftTree();
    }

    private void refreshLeftTree() {
        this.clearDataAndCache();
        Long modelId = this.getModelId();
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"CentralRelationSettingPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode root = this.buildLeftTree();
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW_AP);
        List children = root.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            for (TreeNode child : root.getChildren()) {
                treeView.expand(child.getId());
            }
            for (TreeNode child : children) {
                List treeNodeChildren = child.getChildren();
                if (!CollectionUtils.isNotEmpty((Collection)treeNodeChildren)) continue;
                TreeNode node = (TreeNode)treeNodeChildren.get(0);
                treeView.focusNode(node);
                this.doTreeNodeClick(node.getId());
            }
        }
    }

    private TreeNode buildLeftTree() {
        TreeNode root = new TreeNode();
        root.setId("0");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"CentralRelationSettingPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        root.setDisabled(true);
        root.setLongNumber("all");
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW_AP);
        treeView.deleteAllNodes();
        DynamicObject[] relRanges = BusinessDataServiceHelper.load((String)"eb_centralrelrange", (String)"model,bizmodel,status,entryentity.dimension,entryentity.dimensionview,entityrange", (QFilter[])qFilter.toArray(), (String)"createdate desc");
        if (relRanges == null || relRanges.length == 0) {
            treeView.addNode(root);
            return root;
        }
        for (DynamicObject relRange : relRanges) {
            TreeNode child = centralRelationService.buildTreeNode(relRange, true, false, true);
            root.addChild(child);
        }
        treeView.addNode(root);
        this.getPageCache().put(LEFT_TREE_CACHE, SerializationUtils.toJsonString((Object)root));
        return root;
    }

    private void clearDataAndCache() {
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW_AP);
        treeView.deleteAllNodes();
        this.getView().updateView(TREE_VIEW_AP);
        this.clearTab();
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        this.getView().setVisible(Boolean.valueOf(false), preDimCols.toArray(new String[0]));
        this.getView().setVisible(Boolean.valueOf(false), preDimNameCols.toArray(new String[0]));
        this.getPageCache().batchRemove(Arrays.asList(LEFT_TREE_CACHE, CURRENT_NODE_ID, CURRENT_TAB_ID, DIM_TO_CONTROL_KEY));
        this.setDataChange(false);
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        String treeCache = this.getPageCache().get(LEFT_TREE_CACHE);
        switch (key) {
            case "add_range": 
            case "edit_range": {
                this.openRangeForm(key);
                break;
            }
            case "delete_range": {
                this.deleteRange();
                break;
            }
            case "add_scheme": 
            case "edit_scheme": {
                this.openRelScheme(key);
                break;
            }
            case "delete_scheme": {
                this.deleteRelScheme();
                break;
            }
            case "searchbefore": {
                if (StringUtils.isEmpty((CharSequence)treeCache)) {
                    return;
                }
                if (this.getDataChange()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u53e3\u5173\u7cfb\u4fe1\u606f\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"CentralRelationSettingPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(TREE_VIEW_AP, LEFT_TREE_CACHE, "", TreeSearchUtil.SearchBtnStatus.LEFT));
                this.afterSearchClick();
                break;
            }
            case "searchnext": {
                if (StringUtils.isEmpty((CharSequence)treeCache)) {
                    return;
                }
                if (this.getDataChange()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u53e3\u5173\u7cfb\u4fe1\u606f\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"CentralRelationSettingPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(TREE_VIEW_AP, LEFT_TREE_CACHE, "", TreeSearchUtil.SearchBtnStatus.RIGHT));
                this.afterSearchClick();
                break;
            }
        }
    }

    private void deleteRelScheme() {
        Long curCentralSchemeId = this.getCurrentSchemeTabId();
        if (IDUtils.isEmptyLong((Long)curCentralSchemeId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5f52\u53e3\u5173\u7cfb\u65b9\u6848\u3002", (String)"CentralRelationSettingPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Set approveTypeNameByCentralSchema = ApproveTypeUtils.getInstance().getApproveTypeNameByCentralSchema((Set)Sets.newHashSet((Object[])new Long[]{curCentralSchemeId}));
        if (CollectionUtils.isNotEmpty((Collection)approveTypeNameByCentralSchema)) {
            this.getView().showConfirm(ResManager.loadResFormat((String)"\u9009\u4e2d\u7684\u5f52\u53e3\u5173\u7cfb\u65b9\u6848\u88ab\u5ba1\u6279\u7c7b\u578b\u5f15\u7528\uff0c\u662f\u5426\u5220\u9664\uff1f\u5f15\u7528\u5ba1\u6279\u7c7b\u578b\u201c%1\u201d\u3002", (String)"CentralRelationSettingPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)";", approveTypeNameByCentralSchema)}), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DELETE_RELSCHEME_CONFIRM, (IFormPlugin)this));
            return;
        }
        boolean exists = QueryServiceHelper.exists((String)"eb_centralrelation", (QFilter[])new QFilter("scheme", "=", (Object)curCentralSchemeId).toArray());
        if (exists) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u9009\u4e2d\u7684\u5f52\u53e3\u5173\u7cfb\u65b9\u6848\uff1f", (String)"CentralRelationSettingPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DELETE_RELSCHEME_CONFIRM, (IFormPlugin)this));
            return;
        }
        this.doDeleteRelScheme(curCentralSchemeId);
    }

    private void doDeleteRelScheme(Long curCentralSchemeId) {
        DeleteServiceHelper.delete((String)"eb_centralrelscheme", (QFilter[])new QFilter("id", "=", (Object)curCentralSchemeId).toArray());
        HashSet centralSchemeIds = Sets.newHashSet((Object[])new Long[]{curCentralSchemeId});
        centralRelationService.delCentralRelation((Set)centralSchemeIds);
        ApproveTypeUtils.getInstance().deleteCentralRelation((Set)centralSchemeIds);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"CentralRelationSettingPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "CentralRangePlugin_16", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5f52\u53e3\u5173\u7cfb\u65b9\u6848\u5df2\u5220\u9664\u3002", "CentralRangePlugin_19", "epm-eb-formplugin"));
        String lefttreecache = this.getPageCache().get(LEFT_TREE_CACHE);
        if (StringUtils.isNotEmpty((CharSequence)lefttreecache)) {
            String nodeId = this.getCurrentTreeNodeId();
            this.removeCache(CURRENT_TAB_ID);
            this.getModel().deleteEntryData(ENTRY_ENTITY);
            this.refreshTab(nodeId, null, false);
        }
        this.setDataChange(false);
    }

    private void openRelScheme(String key) {
        Long modelId = this.getModelId();
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"CentralRelationSettingPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.getDataChange()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u53e3\u5173\u7cfb\u4fe1\u606f\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"CentralRelationSettingPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.getCurrentTreeNodeId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de6\u4fa7\u6811\u8282\u70b9\u3002", (String)"CentralRelationSettingPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter formShowParameter = new BaseShowParameter();
        if (EDIT_SCHEME.equals(key)) {
            Long currentSchemeId = this.getCurrentSchemeTabId();
            if (IDUtils.isNull((Long)currentSchemeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5f52\u53e3\u5173\u7cfb\u65b9\u6848\u3002", (String)"CentralRelationSettingPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean exists = QueryServiceHelper.exists((String)"eb_centralrelscheme", (Object)currentSchemeId);
            if (exists) {
                formShowParameter.setPkId((Object)currentSchemeId);
            } else {
                formShowParameter.setCustomParam("openType", (Object)"edit");
            }
        } else {
            this.saveDefaultRelScheme(this.getCurrentSchemeTabId());
        }
        String id = this.getCurrentTreeNodeId();
        String[] split = id.split("_");
        formShowParameter.setCustomParam("entity", (Object)IDUtils.toLong((Object)split[1]));
        formShowParameter.setCustomParam("centralrange", (Object)IDUtils.toLong((Object)split[0]));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADD_RELSCHEME_BACK));
        formShowParameter.setCustomParam("model", (Object)modelId);
        formShowParameter.setFormId("eb_centralrelscheme");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void saveDefaultRelScheme(Long curCentralSchemeId) {
        String nodeId = this.getCurrentTreeNodeId();
        if (StringUtils.isEmpty((CharSequence)nodeId) && IDUtils.isNull((Long)curCentralSchemeId)) {
            return;
        }
        boolean exists = QueryServiceHelper.exists((String)"eb_centralrelscheme", (Object)curCentralSchemeId);
        if (!exists) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_centralrelscheme");
            String[] split = nodeId.split("_");
            if (split.length == 2) {
                dynamicObject.set("centralrange", (Object)IDUtils.toLong((Object)split[0]));
                dynamicObject.set("entity", (Object)IDUtils.toLong((Object)split[1]));
                dynamicObject.set("name", (Object)ResManager.getLocaleString((String)"\u9ed8\u8ba4\u5f52\u53e3\u5173\u7cfb\u65b9\u6848", (String)"CentralRelationSettingPlugin_7", (String)"epm-eb-formplugin"));
                String defaultRelSchemeNumber = CentralRelationService.getInstance().getDefaultRelSchemeNumber(this.getModelId(), IDUtils.toLong((Object)split[1]), IDUtils.toLong((Object)split[0]));
                dynamicObject.set("number", (Object)defaultRelSchemeNumber);
                dynamicObject.set("id", (Object)curCentralSchemeId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
        }
    }

    private void deleteRange() {
        String nodeId = this.getCurrentTreeNodeId();
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de6\u4fa7\u6811\u8282\u70b9\u3002", (String)"CentralRelationSettingPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_centralrelscheme", (String)"id", (QFilter[])new QFilter("centralrange", "=", (Object)IDUtils.toLong((Object)nodeId.split("_")[0])).toArray());
        Set relSchemeIds = query.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
        Set approveTypeNameByCentralSchema = ApproveTypeUtils.getInstance().getApproveTypeNameByCentralSchema(relSchemeIds);
        if (CollectionUtils.isNotEmpty((Collection)approveTypeNameByCentralSchema)) {
            this.getView().showConfirm(ResManager.loadResFormat((String)"\u9009\u4e2d\u7684\u5f52\u53e3\u5173\u7cfb\u65b9\u6848\u88ab\u5ba1\u6279\u7c7b\u578b\u5f15\u7528\uff0c\u662f\u5426\u5220\u9664\uff1f\u5f15\u7528\u5ba1\u6279\u7c7b\u578b\u201c%1\u201d\u3002", (String)"CentralRelationSettingPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)";", approveTypeNameByCentralSchema)}), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DELETE_RANGE_CONFIRM, (IFormPlugin)this));
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u9009\u4e2d\u7684\u5f52\u53e3\u7ba1\u7406\u8303\u56f4\uff1f", (String)"CentralRelationSettingPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DELETE_RANGE_CONFIRM, (IFormPlugin)this));
        }
        this.getPageCache().put("needDeleteRelSchemeIds", SerializationUtils.serializeToBase64(relSchemeIds));
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        switch (callBackId) {
            case "deleteRangeConfirm": {
                if (MessageBoxResult.Yes != result) break;
                String needDeleteRelSchemeIds = this.getPageCache().get("needDeleteRelSchemeIds");
                Set relSchemeIds = (Set)SerializationUtils.deSerializeFromBase64((String)needDeleteRelSchemeIds);
                this.doDeleteRange(relSchemeIds);
                break;
            }
            case "deleteRelSchemeConfirm": {
                if (MessageBoxResult.Yes != result) break;
                this.doDeleteRelScheme(this.getCurrentSchemeTabId());
                break;
            }
            case "treeNodeClickConfirm": {
                if (MessageBoxResult.Yes == result) {
                    if (this.checkBeforeSaveCentralRel()) {
                        this.focusTreeNode(this.getCurrentTreeNodeId());
                        break;
                    }
                    this.saveCentralRelation();
                    this.doTreeNodeClick((String)this.getCache(NODE_ID_FOR_CONFIRM, String.class));
                    this.refreshCentralRelation();
                    break;
                }
                this.doTreeNodeClick((String)this.getCache(NODE_ID_FOR_CONFIRM, String.class));
                this.refreshCentralRelation();
                break;
            }
            case "tabSelectedConfirm": {
                if (MessageBoxResult.Yes == result) {
                    if (this.checkBeforeSaveCentralRel()) {
                        Tab tab = (Tab)this.getControl(TAB_AP);
                        this.putCache(SELECTING_SIGN, "1");
                        String tabKey = String.valueOf(this.getCurrentSchemeTabId());
                        tab.selectTab(tabKey);
                        tab.activeTab(tabKey);
                        break;
                    }
                    this.saveCentralRelation();
                    this.doSelectTab((String)this.getCache(TAB_ID_FOR_CONFIRM, String.class));
                    break;
                }
                this.doSelectTab((String)this.getCache(TAB_ID_FOR_CONFIRM, String.class));
                this.setDataChange(false);
                break;
            }
            case "closePageConfirm": {
                if (MessageBoxResult.Yes != result) break;
                this.getView().close();
                break;
            }
            case "refreshPageConfirm": {
                if (MessageBoxResult.Yes != result) break;
                this.refreshLeftTree();
                this.refreshCentralRelation();
                this.showTypeChange(this.getModel().getValue("showtype"));
                break;
            }
        }
    }

    private void doDeleteRange(Set<Long> relSchemeIds) {
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW_AP);
        String nodeId = treeView.getTreeState().getFocusNodeId();
        String lefttreecache = this.getPageCache().get(LEFT_TREE_CACHE);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)lefttreecache, TreeNode.class);
        TreeNode treeNode = root.getTreeNode(nodeId);
        Map data = (Map)treeNode.getData();
        String rangeId = (String)data.get("rangeId");
        root.deleteChildNode(rangeId + "_1");
        treeView.updateNode(root);
        Long centralRangeId = IDUtils.toLong((Object)rangeId);
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"eb_centralrelrange"), (Object[])new Object[]{centralRangeId});
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.CentralRelRange.getType(), Sets.newHashSet((Object[])new Long[]{centralRangeId})});
        centralRelationService.delCentralRelation(relSchemeIds);
        centralRelationService.delCentralRelationRelationMemberQuote(new ArrayList<Long>(relSchemeIds));
        ApproveTypeUtils.getInstance().deleteCentralRelation(relSchemeIds);
        this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "CentralRangePlugin_16", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5f52\u53e3\u7ba1\u7406\u8303\u56f4\u5df2\u5220\u9664\u3002", "CentralRangePlugin_17", "epm-eb-formplugin"));
        this.refreshLeftTree();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        if (this.getDataChange()) {
            this.putCache(NODE_ID_FOR_CONFIRM, nodeId);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f52\u53e3\u5173\u7cfb\u4fe1\u606f\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"CentralRelationSettingPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(TREE_NODE_CLICK_CONFIRM, (IFormPlugin)this));
            return;
        }
        this.doTreeNodeClick(nodeId);
    }

    private void focusTreeNode(String nodeId) {
        String leftTreeCache = this.getPageCache().get(LEFT_TREE_CACHE);
        if (StringUtils.isNotEmpty((CharSequence)leftTreeCache)) {
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)leftTreeCache, TreeNode.class);
            TreeNode node = root.getTreeNode(nodeId);
            TreeView control = (TreeView)this.getControl(TREE_VIEW_AP);
            control.focusNode(node);
        }
    }

    private String getCurrentTreeNodeId() {
        return this.getPageCache().get(CURRENT_NODE_ID);
    }

    protected Long getCurrentCentralRangeId() {
        String treeNodeId = this.getCurrentTreeNodeId();
        if (StringUtils.isEmpty((CharSequence)treeNodeId) || treeNodeId.split("_").length != 2) {
            return 0L;
        }
        return IDUtils.toLong((Object)treeNodeId.split("_")[0]);
    }

    private void doTreeNodeClick(String nodeId) {
        this.getPageCache().put(CURRENT_NODE_ID, nodeId);
        this.removeCache(CURRENT_TAB_ID);
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        this.setCentralDimColVisible();
        this.refreshTab(nodeId, null, true);
    }

    private void refreshTab(String nodeId, String selectTabKey, boolean needPresetTab) {
        String[] split = nodeId.split("_");
        if (split.length != 2) {
            return;
        }
        QFilter qFilter = new QFilter("centralrange", "=", (Object)IDUtils.toLong((Object)split[0])).and("entity", "=", (Object)IDUtils.toLong((Object)split[1]));
        DynamicObject[] centralRelSchemes = BusinessDataServiceHelper.load((String)"eb_centralrelscheme", (String)"id,number,name", (QFilter[])qFilter.toArray(), (String)"createdate");
        this.buildTab(centralRelSchemes, selectTabKey, needPresetTab);
    }

    protected void buildTab(DynamicObject[] centralRelSchemes, String selectTabKey, boolean needPresetTab) {
        Tab tabEdit = (Tab)this.getControl(TAB_AP);
        TabAp tabap = new TabAp();
        tabap.setKey(tabEdit.getKey());
        tabap.setGrow(0);
        if (centralRelSchemes.length == 0 && needPresetTab) {
            TabPageAp page = new TabPageAp();
            page.setKey(String.valueOf(GlobalIdUtil.genGlobalLongId()));
            page.setName(new LocaleString(ResManager.loadKDString((String)"\u9ed8\u8ba4\u5f52\u53e3\u5173\u7cfb\u65b9\u6848", (String)"CentralRelationSettingPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0])));
            tabap.getItems().add(page);
        } else {
            for (DynamicObject centralRelScheme : centralRelSchemes) {
                TabPageAp page = new TabPageAp();
                page.setKey(centralRelScheme.getString("id"));
                page.setName(new LocaleString(centralRelScheme.getString("name")));
                tabap.getItems().add(page);
            }
        }
        Map features = tabap.createControl();
        HashMap<String, String> busyTips = new HashMap<String, String>(1);
        busyTips.put("zh_CN", ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u4faf\u3002", (String)"ReportQueryProcess_52", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        features.put("busyTip", busyTips);
        this.getView().updateControlMetadata(tabap.getKey(), features);
        if (StringUtils.isEmpty((CharSequence)selectTabKey) && CollectionUtils.isNotEmpty((Collection)tabap.getItems())) {
            selectTabKey = ((ControlAp)tabap.getItems().get(0)).getKey();
        }
        this.putCache(SELECTING_SIGN, "1");
        tabEdit.selectTab(selectTabKey);
        tabEdit.activeTab(selectTabKey);
        this.getPageCache().put(CURRENT_TAB_ID, selectTabKey);
    }

    protected void clearTab() {
        Tab tabEdit = (Tab)this.getControl(TAB_AP);
        TabAp tabap = new TabAp();
        tabap.setKey(tabEdit.getKey());
        tabap.setGrow(0);
        Map features = tabap.createControl();
        this.getView().updateControlMetadata(tabap.getKey(), features);
    }

    private void openRangeForm(String key) {
        Long modelId = this.getModelId();
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"CentralRelationSettingPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.getDataChange()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u53e3\u5173\u7cfb\u4fe1\u606f\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"CentralRelationSettingPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter formShowParameter = new BaseShowParameter();
        if (EDIT_RANGE.equals(key)) {
            String nodeId = this.getCurrentTreeNodeId();
            if (StringUtils.isEmpty((CharSequence)nodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de6\u4fa7\u6811\u8282\u70b9\u3002", (String)"CentralRelationSettingPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Long pkId = IDUtils.toLong((Object)nodeId.substring(0, nodeId.indexOf("_")));
            formShowParameter.setPkId((Object)pkId);
        }
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADD_RANGE_CALLBACK));
        formShowParameter.setCustomParam("model", (Object)modelId);
        formShowParameter.setFormId("eb_centralrelrange");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        IDataEntityType parent = e.getProperty().getParent();
        if ("showtype".equals(name)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            this.showTypeChange(newValue);
        } else if (parent != null && ENTRY_ENTITY.equals(parent.getName())) {
            this.centralRelationDataChange(name);
        } else if ("model".equals(name)) {
            this.modelChange();
        }
    }

    private void modelChange() {
        DynamicObject object = (DynamicObject)this.getModel().getValue("model");
        if (object != null && !IDUtils.equals((Object)this.getModelId(), (Object)object.getLong("id"))) {
            this.getPageCache().put("model", object.getString("id"));
            UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)object.getLong("id"));
            this.refreshLeftTree();
            this.showTypeChange(this.getModel().getValue("showtype"));
        } else {
            this.getModel().setValue("model", (Object)this.getModelId());
        }
    }

    private void showTypeChange(Object currentShowType) {
        if (currentShowType == null) {
            return;
        }
        String lefttreecache = this.getPageCache().get(LEFT_TREE_CACHE);
        TreeNode root = new TreeNode();
        if (StringUtils.isNotEmpty((CharSequence)lefttreecache)) {
            root = (TreeNode)SerializationUtils.fromJsonString((String)lefttreecache, TreeNode.class);
        }
        if (root != null && CollectionUtils.isNotEmpty((Collection)root.getChildren())) {
            this.doShowTypeChange(String.valueOf(currentShowType), root);
            TreeView treeView = (TreeView)this.getControl(TREE_VIEW_AP);
            treeView.updateNode(root);
            this.getPageCache().put(LEFT_TREE_CACHE, SerializationUtils.toJsonString((Object)root));
            for (TreeNode child : root.getChildren()) {
                treeView.expand(child.getId());
            }
        }
    }

    private void centralRelationDataChange(String name) {
        HashSet<String> preDimColsSet = new HashSet<String>(preDimCols);
        if (preDimColsSet.contains(name) || STATUS.equals(name) || ENABLE_DATE.equals(name) || DISABLE_DATE.equals(name)) {
            this.getModel().beginInit();
            this.getModel().setValue(MODIFIER, (Object)UserUtils.getUserId());
            this.getModel().setValue(MODIFY_DATE, (Object)TimeServiceHelper.now());
            if (preDimColsSet.contains(name) && !DIM_ENTITY.equals(name)) {
                String dimNameColKey;
                Long currentCentralRangeId = this.getCurrentCentralRangeId();
                Map centralRangeDimView = centralRelationService.getCentralRangeDimView(currentCentralRangeId);
                Object value = this.getModel().getValue(name);
                String dimNumber = this.getDimToControlKeyMap().get(name);
                String string = dimNameColKey = "Account".equals(dimNumber) ? name + "name" : name.replace(USER_DEFINE, "userdefinename");
                if (value instanceof DynamicObject) {
                    Long memberId = ((DynamicObject)value).getLong("id");
                    Member member = this.getIModelCacheHelper().getMember(dimNumber, (Long)centralRangeDimView.get(dimNumber), memberId);
                    if (member != null) {
                        RangeEnum rangeEnum = member.isLeaf() ? RangeEnum.ONLY : RangeEnum.ALL;
                        String rangeNameValue = member.getName() + "_" + rangeEnum.getName();
                        this.getModel().setValue(dimNameColKey, (Object)rangeNameValue);
                    }
                } else {
                    this.getModel().setValue(dimNameColKey, null);
                }
            }
            this.getModel().endInit();
            this.getView().updateView(ENTRY_ENTITY);
            this.setDataChange(true);
        }
    }

    private void doShowTypeChange(String showType, TreeNode root) {
        switch (showType) {
            case "all": {
                this.showAllTreeNode(root);
                break;
            }
            case "name": {
                this.showNameTreeNode(root);
                break;
            }
            case "number": {
                this.showNumberTreeNode(root);
                break;
            }
        }
    }

    private void showNumberTreeNode(TreeNode treeNode) {
        String id = treeNode.getId();
        if (StringUtils.isNotEmpty((CharSequence)id) && !"0".equals(id)) {
            Object data = treeNode.getData();
            String number = (String)((Map)data).get("number");
            treeNode.setText(number);
        }
        if (CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) {
            for (TreeNode childChild : treeNode.getChildren()) {
                this.showNumberTreeNode(childChild);
            }
        }
    }

    private void showNameTreeNode(TreeNode treeNode) {
        String id = treeNode.getId();
        if (StringUtils.isNotEmpty((CharSequence)id) && !"0".equals(id)) {
            Object data = treeNode.getData();
            String name = (String)((Map)data).get("name");
            treeNode.setText(name);
        }
        if (CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) {
            for (TreeNode childChild : treeNode.getChildren()) {
                this.showNameTreeNode(childChild);
            }
        }
    }

    private void showAllTreeNode(TreeNode treeNode) {
        String id = treeNode.getId();
        if (StringUtils.isNotEmpty((CharSequence)id) && !"0".equals(id)) {
            Object data = treeNode.getData();
            String name = (String)((Map)data).get("name");
            String number = (String)((Map)data).get("number");
            treeNode.setText(number + " " + name);
        }
        if (CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) {
            for (TreeNode childChild : treeNode.getChildren()) {
                this.showAllTreeNode(childChild);
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        if (ADD_RANGE_CALLBACK.equals(actionId)) {
            this.addRangeBack();
        } else if (BATCH_SETTING_CALLBACK.equals(actionId)) {
            this.batchSettingRelationCallBack(returnData);
        } else if (ADD_RELSCHEME_BACK.equals(actionId)) {
            this.addRelSchemeBack(returnData);
        } else if (DIM_F7_SELECT_CALL_BACK.equals(actionId)) {
            this.dimF7SelectCallBack(returnData);
        } else if (CENTRAL_IMPORT_CALL_BACK.equals(actionId)) {
            this.centralRelationImportCallBack(returnData);
        }
    }

    private void centralRelationImportCallBack(Object returnData) {
        if (returnData instanceof List) {
            List records = (List)returnData;
            IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
            int beforeRemoveSize = records.size();
            this.removeSaveDimMemberGroupData(modelCacheHelper, records);
            if (records.size() > 0) {
                this.fillCentralRelationData(modelCacheHelper, records);
                this.setDataChange(true);
            }
            if (records.size() < beforeRemoveSize) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002\u81ea\u52a8\u8df3\u8fc7\u7ef4\u5ea6\u6210\u5458\u7ec4\u5408\u91cd\u590d\u7684\u6570\u636e\u3002", (String)"CentralRelationSettingPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"CentralRelationSettingPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void removeSaveDimMemberGroupData(IModelCacheHelper modelCacheHelper, List<CentralRelationRecord> records) {
        StringBuilder builder;
        Map<String, String> dimToControlKeyMap = this.getDimToControlKeyMap();
        Long currentCentralRangeId = this.getCurrentCentralRangeId();
        Set centralRangeDim = centralRelationService.getCentralRangeDim(currentCentralRangeId);
        Map centralRangeDimView = centralRelationService.getCentralRangeDimView(currentCentralRangeId);
        HashSet<String> existDimGroup = new HashSet<String>(16);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            for (DynamicObject object : entryEntity) {
                builder = new StringBuilder();
                for (String dimNumber : centralRangeDim) {
                    String memNum;
                    String colKey = dimToControlKeyMap.get(dimNumber);
                    if (colKey == null || !StringUtils.isNotEmpty((CharSequence)(memNum = object.getString(colKey + ".number")))) continue;
                    builder.append(dimNumber).append("_").append(memNum).append(";");
                }
                existDimGroup.add(builder.toString());
            }
        }
        ArrayList<CentralRelationRecord> needRemoveRel = new ArrayList<CentralRelationRecord>(10);
        for (CentralRelationRecord record : records) {
            Map centralDimMemberInfo;
            builder = new StringBuilder();
            Long entityId = record.getEntityId();
            Member entity = modelCacheHelper.getMember("Entity", (Long)centralRangeDimView.get("Entity"), entityId);
            if (entity != null) {
                builder.append("Entity").append("_").append(entity.getNumber()).append(";");
            }
            if ((centralDimMemberInfo = record.getCentralDimMemberInfo()) != null && centralDimMemberInfo.size() > 0) {
                for (Map.Entry entry : centralDimMemberInfo.entrySet()) {
                    builder.append((String)entry.getKey()).append("_").append(((MemberCondition)entry.getValue()).getNumber()).append(";");
                }
            }
            if (existDimGroup.add(builder.toString())) continue;
            needRemoveRel.add(record);
        }
        if (!needRemoveRel.isEmpty()) {
            records.removeAll(needRemoveRel);
        }
    }

    private void addRelSchemeBack(Object returnData) {
        this.refreshTab(this.getCurrentTreeNodeId(), String.valueOf(returnData), false);
    }

    private void dimF7SelectCallBack(Object returnData) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        String focusField = entryGrid.getEntryState().getFocusField();
        if (StringUtils.isEmpty((CharSequence)focusField) || "0".equals(focusField)) {
            return;
        }
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection rowData = (ListSelectedRowCollection)returnData;
            if (rowData.size() < 1) {
                return;
            }
            int focusRelationRow = this.getFocusRelationRow();
            Map<String, String> dimToControlKeyMap = this.getDimToControlKeyMap();
            this.getModel().beginInit();
            this.fillFirstRow(focusField, focusRelationRow, rowData, dimToControlKeyMap);
            if (rowData.size() > 1) {
                rowData.remove(0);
                this.fillRemainRow(focusField, focusRelationRow, rowData, dimToControlKeyMap);
            }
            this.getModel().endInit();
            this.getView().updateView(ENTRY_ENTITY);
            this.setDataChange(true);
        }
    }

    private Map<String, Object> getCentralRelationRowData(int row, Map<String, String> dimToControlKeyMap, Set<String> centralRangeDim) {
        Long modelId = this.getModelId();
        Long bizModelId = centralRelationService.getCentralRangeBizModelId(this.getCurrentCentralRangeId());
        Map centralRangeDimView = centralRelationService.getCentralRangeDimView(this.getCurrentCentralRangeId());
        HashMap<String, Object> rowDataMap = new HashMap<String, Object>(16);
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, row);
        DataEntityPropertyCollection properties = rowEntity.getDataEntityType().getProperties();
        for (String dim : centralRangeDim) {
            Set readPermMembIds = DimMembPermHelper.getReadPermMembIds((String)dim, (Long)modelId, (Long)bizModelId, (Long)((Long)centralRangeDimView.get(dim)), (boolean)true);
            String dimColKey = dimToControlKeyMap.get(dim);
            String propertyName = dimColKey + "_id";
            if (!properties.containsKey((Object)propertyName)) continue;
            Long value = rowEntity.getLong(propertyName);
            if (readPermMembIds != null && !readPermMembIds.contains(value)) continue;
            rowDataMap.put(dim, value);
        }
        rowDataMap.put(STATUS, rowEntity.get(STATUS));
        rowDataMap.put(ENABLE_DATE, rowEntity.get(ENABLE_DATE));
        rowDataMap.put(DISABLE_DATE, rowEntity.get(DISABLE_DATE));
        return rowDataMap;
    }

    private void fillFirstRow(String focusField, int focusRelationRow, ListSelectedRowCollection rowData, Map<String, String> dimToControlKeyMap) {
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Object firstRowPk = rowData.get(0).getPrimaryKeyValue();
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, focusRelationRow);
        Map dataMap = rowData.get(0).getDataMap();
        Long viewId = IDUtils.toLong(dataMap.get("viewid"));
        Member member = modelCacheHelper.getMember(dimToControlKeyMap.get(focusField), viewId, IDUtils.toLong((Object)firstRowPk));
        if (member != null) {
            rowEntity.set(focusField + "_id", firstRowPk);
            String dimNumber = dimToControlKeyMap.get(focusField);
            if (!"Entity".equals(dimNumber)) {
                RangeEnum rangeEnum = member.isLeaf() ? RangeEnum.ONLY : RangeEnum.ALL;
                String dimNameRangeValue = member.getName() + "_" + rangeEnum.getName();
                if ("Account".equals(dimNumber)) {
                    rowEntity.set(focusField + "name", (Object)dimNameRangeValue);
                } else {
                    rowEntity.set(focusField.replace(USER_DEFINE, "userdefinename"), (Object)dimNameRangeValue);
                }
            }
            rowEntity.set("modifier_id", (Object)UserUtils.getUserId());
            rowEntity.set(MODIFY_DATE, (Object)TimeServiceHelper.now());
        }
    }

    private void fillRemainRow(String focusField, int focusRelationRow, ListSelectedRowCollection rowData, Map<String, String> dimToControlKeyMap) {
        Long centralRangeId = this.getCurrentCentralRangeId();
        Set centralRangeDim = centralRelationService.getCentralRangeDim(centralRangeId);
        Map<String, Object> rowDataMap = this.getCentralRelationRowData(focusRelationRow, dimToControlKeyMap, centralRangeDim);
        Map centralRangeDimView = centralRelationService.getCentralRangeDimView(centralRangeId);
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        int insertRow = focusRelationRow + 1;
        for (ListSelectedRow data : rowData) {
            this.getModel().insertEntryRow(ENTRY_ENTITY, insertRow);
            DynamicObject object = this.getModel().getEntryRowEntity(ENTRY_ENTITY, insertRow);
            for (String dim : centralRangeDim) {
                RangeEnum rangeEnum;
                Member member;
                String dimNameColKey;
                String dimColKey = dimToControlKeyMap.get(dim);
                String propertyName = dimColKey + "_id";
                Long viewId = (Long)centralRangeDimView.get(dim);
                Long value = IDUtils.toLong((Object)(StringUtils.equals((CharSequence)dimColKey, (CharSequence)focusField) ? data.getPrimaryKeyValue() : rowDataMap.get(dim)));
                object.set(propertyName, (Object)value);
                if ("Entity".equals(dim)) continue;
                if ("Account".equals(dim)) {
                    dimNameColKey = dimColKey + "name";
                    member = modelCacheHelper.getMember(dim, viewId, value);
                    if (member == null) continue;
                    rangeEnum = member.isLeaf() ? RangeEnum.ONLY : RangeEnum.ALL;
                    object.set(dimNameColKey, (Object)(member.getName() + "_" + rangeEnum.getName()));
                    continue;
                }
                dimNameColKey = dimColKey.replace(USER_DEFINE, "userdefinename");
                member = modelCacheHelper.getMember(dim, viewId, value);
                if (member == null) continue;
                rangeEnum = member.isLeaf() ? RangeEnum.ONLY : RangeEnum.ALL;
                object.set(dimNameColKey, (Object)(member.getName() + "_" + rangeEnum.getName()));
            }
            object.set(STATUS, rowDataMap.get(STATUS));
            object.set(ENABLE_DATE, rowDataMap.get(ENABLE_DATE));
            object.set(DISABLE_DATE, rowDataMap.get(DISABLE_DATE));
            object.set("modifier_id", (Object)userId);
            object.set(MODIFY_DATE, (Object)now);
            ++insertRow;
        }
    }

    private void addRangeBack() {
        TreeNode root = this.buildLeftTree();
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW_AP);
        treeView.deleteAllNodes();
        treeView.addNode(root);
        String currentClickNodeId = this.getPageCache().get(CURRENT_NODE_ID);
        if (StringUtils.isNotEmpty((CharSequence)currentClickNodeId)) {
            TreeNode focusNode = root.getTreeNode(currentClickNodeId, 20);
            if (focusNode != null) {
                treeView.focusNode(focusNode);
                this.treeNodeClick(new TreeNodeEvent((Object)this, (Object)focusNode.getParentid(), (Object)focusNode.getId()));
            } else {
                TreeNode node;
                List children;
                List treeNodeChildren = root.getChildren();
                if (CollectionUtils.isNotEmpty((Collection)treeNodeChildren) && CollectionUtils.isNotEmpty((Collection)(children = (node = (TreeNode)treeNodeChildren.get(0)).getChildren()))) {
                    TreeNode childNode = (TreeNode)children.get(0);
                    treeView.focusNode(childNode);
                    this.treeNodeClick(new TreeNodeEvent((Object)this, (Object)childNode.getParentid(), (Object)childNode.getId()));
                }
            }
        } else {
            TreeNode node;
            List children;
            List treeNodeChildren = root.getChildren();
            if (CollectionUtils.isNotEmpty((Collection)treeNodeChildren) && CollectionUtils.isNotEmpty((Collection)(children = (node = (TreeNode)treeNodeChildren.get(0)).getChildren()))) {
                TreeNode childNode = (TreeNode)children.get(0);
                treeView.focusNode(childNode);
                this.treeNodeClick(new TreeNodeEvent((Object)this, (Object)childNode.getParentid(), (Object)childNode.getId()));
            }
        }
        this.getPageCache().put(LEFT_TREE_CACHE, SerializationUtils.toJsonString((Object)root));
        for (TreeNode node : root.getChildren()) {
            treeView.expand(node.getId());
        }
        this.refreshCentralRelation();
        this.showTypeChange(this.getModel().getValue("showtype"));
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        Toolbar toolbar = (Toolbar)evt.getSource();
        if (this.getDataChange()) {
            if (BTN_CLOSE.equals(itemKey)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f52\u53e3\u5173\u7cfb\u53d1\u751f\u53d8\u5316\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u9000\u51fa\uff1f", (String)"CentralRelationSettingPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CLOSE_PAGE_CONFIRM, (IFormPlugin)this));
                evt.setCancel(true);
                return;
            }
            if (BTN_REFRESH.equals(itemKey)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f52\u53e3\u5173\u7cfb\u53d1\u751f\u53d8\u5316\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u5237\u65b0\uff1f", (String)"CentralRelationSettingPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(REFRESH_PAGE_CONFIRM, (IFormPlugin)this));
                evt.setCancel(true);
                return;
            }
        }
        if (IDUtils.isEmptyLong((Long)this.getModelId()).booleanValue() && !BTN_CLOSE.equals(itemKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"CentralRelationSettingPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (IDUtils.isEmptyLong((Long)this.getCurrentSchemeTabId()).booleanValue() && (TOOL_BAR.equals(toolbar.getKey()) || BTN_SAVE.equals(itemKey))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5f52\u53e3\u5173\u7cfb\u65b9\u6848\u3002", (String)"CentralRelationSettingPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (BTN_SAVE.equals(itemKey)) {
            evt.setCancel(this.checkBeforeSaveCentralRel());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "add_relation": {
                this.addCentralRelation();
                break;
            }
            case "del_relation": {
                this.delCentralRelation();
                break;
            }
            case "enable_relation": {
                this.enableCentralRelation(true);
                break;
            }
            case "disable_relation": {
                this.enableCentralRelation(false);
                break;
            }
            case "import_relation": {
                this.importCentralRelation();
                break;
            }
            case "export_selrelation": {
                this.exportCentralRelation(false);
                break;
            }
            case "export_allrelation": {
                this.exportCentralRelation(true);
                break;
            }
            case "batch_set_relation": {
                this.batchSettingRelation();
                break;
            }
            case "btn_refresh": {
                this.refreshLeftTree();
                this.showTypeChange(this.getModel().getValue("showtype"));
                break;
            }
            case "btn_querycentralorg": {
                this.queryCentralEntity();
                break;
            }
            case "btn_save": {
                this.saveCentralRelation();
                break;
            }
            case "btn_close": {
                this.getView().close();
                break;
            }
        }
    }

    private void queryCentralEntity() {
        Long centralManageEntityId;
        String cacheTreeNodeId = this.getCurrentTreeNodeId();
        if (StringUtils.isEmpty((CharSequence)cacheTreeNodeId) || cacheTreeNodeId.endsWith("_1") || cacheTreeNodeId.split("_").length != 2) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b58\u5728\u5f52\u53e3\u5173\u7cfb\u7684\u5f52\u53e3\u8303\u56f4\u67e5\u8be2\u3002", (String)"CentralRelationSettingPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String[] split = cacheTreeNodeId.split("_");
        Long centralRangeId = IDUtils.toLong((Object)split[0]);
        QFilter qFilter = new QFilter("scheme.centralrange", "=", (Object)centralRangeId).and("scheme.entity", "=", (Object)(centralManageEntityId = IDUtils.toLong((Object)split[1])));
        if (!QueryServiceHelper.exists((String)"eb_centralrelation", (QFilter[])qFilter.toArray())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b58\u5728\u5f52\u53e3\u5173\u7cfb\u7684\u5f52\u53e3\u8303\u56f4\u67e5\u8be2\u3002", (String)"CentralRelationSettingPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_centralentityquery");
        showParameter.setCustomParam("centralRangeId", (Object)centralRangeId);
        showParameter.setCustomParam("centralManageEntityId", (Object)centralManageEntityId);
        showParameter.setCustomParam("model", (Object)this.getModelId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    protected void refreshCentralRelation() {
        this.setDataChange(false);
        Long schemeId = this.getCurrentSchemeTabId();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        boolean exists = centralRelationService.existRelScheme(schemeId);
        if (!exists) {
            return;
        }
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        List record = centralRelationService.getCentralRelationRecord(schemeId, false);
        this.fillCentralRelationData(modelCacheHelper, record);
    }

    protected void fillCentralRelationData(IModelCacheHelper modelCacheHelper, List<CentralRelationRecord> records) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        Map<String, String> dimToControlKeyMap = this.getDimToControlKeyMap();
        this.getModel().beginInit();
        int[] index = this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, records.size());
        int i = 0;
        for (CentralRelationRecord relation : records) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, index[i]);
            rowEntity.set("dim_entity_id", (Object)relation.getEntityId());
            Map dimMemberInfo = relation.getCentralDimMemberInfo();
            if (dimMemberInfo != null && dimMemberInfo.size() > 0) {
                for (Map.Entry entry : dimMemberInfo.entrySet()) {
                    String dimNumber = (String)entry.getKey();
                    MemberCondition condition = (MemberCondition)entry.getValue();
                    Member member = modelCacheHelper.getMember(dimNumber, IDUtils.toLong((Object)condition.getViewId()), condition.getNumber());
                    String dimColKey = dimToControlKeyMap.get(dimNumber);
                    if (dimColKey == null || member == null) continue;
                    rowEntity.set(dimColKey + "_id", (Object)member.getId());
                    String dimNameColKey = "Account".equals(dimNumber) ? dimColKey + "name" : dimColKey.replace(USER_DEFINE, "userdefinename");
                    RangeEnum rangeEnum = member.isLeaf() ? RangeEnum.ONLY : RangeEnum.ALL;
                    rowEntity.set(dimNameColKey, (Object)(member.getName() + "_" + rangeEnum.getName()));
                }
            }
            rowEntity.set(STATUS, (Object)(relation.isStatus() ? "1" : "0"));
            rowEntity.set(ENABLE_DATE, (Object)relation.getEnableDate());
            rowEntity.set(DISABLE_DATE, (Object)relation.getDisableDate());
            rowEntity.set("modifier_id", (Object)relation.getModifier());
            rowEntity.set(MODIFY_DATE, (Object)relation.getModifyDate());
            ++i;
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    protected void setCentralDimColVisible() {
        HashMap<String, String> dimToControlKeyMap = new HashMap<String, String>(16);
        Set centralRangeDim = centralRelationService.getCentralRangeDim(this.getCurrentCentralRangeId());
        int i = 1;
        HashSet<String> visibleCols = new HashSet<String>(16);
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        for (String dimNumber : centralRangeDim) {
            String dimColNameKey;
            String dimColKey;
            if ("Entity".equals(dimNumber) || "Account".equals(dimNumber)) {
                dimColKey = PRE_DIM_FIELD + dimNumber.toLowerCase();
                dimColNameKey = dimColKey + "name";
            } else {
                TextEdit dimNameCol;
                dimColKey = "dim_userdefine" + i;
                dimColNameKey = "dim_userdefinename" + i;
                BasedataEdit dimCol = (BasedataEdit)this.getControl(dimColKey);
                Dimension dimension = modelCacheHelper.getDimension(dimNumber);
                if (dimCol != null && dimension != null) {
                    dimCol.setCaption(new LocaleString(dimension.getName()));
                }
                if ((dimNameCol = (TextEdit)this.getControl(dimColNameKey)) != null && dimension != null) {
                    dimNameCol.setCaption(new LocaleString(ResManager.loadResFormat((String)"%1\u540d\u79f0", (String)"CentralRelationSettingPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getName()})));
                }
                ++i;
            }
            dimToControlKeyMap.put(dimNumber, dimColKey);
            dimToControlKeyMap.put(dimColKey, dimNumber);
            visibleCols.add(dimColKey);
            visibleCols.add(dimColNameKey);
        }
        this.getView().setVisible(Boolean.valueOf(false), preDimCols.toArray(new String[0]));
        this.getView().setVisible(Boolean.valueOf(false), preDimNameCols.toArray(new String[0]));
        this.getView().setVisible(Boolean.valueOf(true), visibleCols.toArray(new String[0]));
        this.getPageCache().put(DIM_TO_CONTROL_KEY, SerializationUtils.serializeToBase64(dimToControlKeyMap));
    }

    private Map<String, String> getDimToControlKeyMap() {
        String cache = this.getPageCache().get(DIM_TO_CONTROL_KEY);
        if (cache != null) {
            return (Map)SerializationUtils.deSerializeFromBase64((String)cache);
        }
        return new HashMap<String, String>(0);
    }

    private boolean checkBeforeSaveCentralRel() {
        IModelCacheHelper modelCacheHelper;
        Long schemeId = this.getCurrentSchemeTabId();
        List<CentralRelationRecord> records = this.packCentralRelation(schemeId, modelCacheHelper = this.getIModelCacheHelper(), true, null);
        if (records == null) {
            return true;
        }
        return this.checkMemberRangeIntersect(records);
    }

    private boolean checkMemberRangeIntersect(List<CentralRelationRecord> records) {
        if (CollectionUtils.isNotEmpty(records)) {
            Set centralRangeDim = centralRelationService.getCentralRangeDim(this.getCurrentCentralRangeId());
            if (centralRangeDim.size() < 1) {
                throw new KDBizException("centralRangeDim is error!");
            }
            HashMap<Integer, String[]> rowDimMemberInfo = new HashMap<Integer, String[]>(16);
            HashMap<Integer, CentralRelationRecord> rowCentralRelationInfo = new HashMap<Integer, CentralRelationRecord>(16);
            IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
            for (CentralRelationRecord record : records) {
                String[] longNumbers = new String[centralRangeDim.size() - 1];
                Map centralDimMemberInfo = record.getCentralDimMemberInfo();
                if (centralDimMemberInfo != null) {
                    int i = 0;
                    for (String dim : centralRangeDim) {
                        Member member;
                        if ("Entity".equals(dim)) continue;
                        MemberCondition condition = (MemberCondition)centralDimMemberInfo.get(dim);
                        if (condition != null && (member = modelCacheHelper.getMember(dim, IDUtils.toLong((Object)condition.getViewId()), condition.getNumber())) != null) {
                            longNumbers[i] = member.getLongNumber();
                        }
                        ++i;
                    }
                }
                Long centralEntityId = record.getEntityId();
                Date enableDate = record.getEnableDate();
                Date disableDate = record.getDisableDate();
                for (Map.Entry entry : rowDimMemberInfo.entrySet()) {
                    Integer rowSeq = (Integer)entry.getKey();
                    CentralRelationRecord rowRelation = (CentralRelationRecord)rowCentralRelationInfo.get(rowSeq);
                    if (rowRelation == null || !IDUtils.equals((Object)centralEntityId, (Object)rowRelation.getEntityId())) continue;
                    Date rowEnableDate = rowRelation.getEnableDate();
                    Date rowDisableDate = rowRelation.getDisableDate();
                    if (enableDate != null && rowEnableDate != null && (rowDisableDate != null && rowDisableDate.compareTo(enableDate) <= 0 || disableDate != null && rowEnableDate.compareTo(disableDate) > 0)) continue;
                    boolean isExistIntersect = true;
                    String[] memLongNumbers = (String[])entry.getValue();
                    for (int i1 = 0; i1 < memLongNumbers.length; ++i1) {
                        if (!StringUtils.isNotEmpty((CharSequence)memLongNumbers[i1]) || !StringUtils.isNotEmpty((CharSequence)longNumbers[i1]) || StringUtils.equals((CharSequence)memLongNumbers[i1], (CharSequence)longNumbers[i1]) || memLongNumbers[i1].startsWith(longNumbers[i1] + "!") || longNumbers[i1].startsWith(memLongNumbers[i1] + "!")) continue;
                        isExistIntersect = false;
                        break;
                    }
                    if (!isExistIntersect) continue;
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f52\u53e3\u5173\u7cfb\u7b2c%1\u884c\u548c\u7b2c%2\u884c\u751f\u6548\u671f\u95f4\u5185\u6210\u5458\u8303\u56f4\u5b58\u5728\u4ea4\u96c6\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CentralRelationSettingPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[]{rowSeq, record.getSeq()}));
                    return true;
                }
                rowDimMemberInfo.put(record.getSeq(), longNumbers);
                rowCentralRelationInfo.put(record.getSeq(), record);
            }
        }
        return false;
    }

    private void saveCentralRelation() {
        if (!this.checkHasModifyPerm()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6682\u65e0\u201c\u5f52\u53e3\u5173\u7cfb\u8bbe\u7f6e\u201d\u7684\u201c\u4fee\u6539\u201d\u64cd\u4f5c\u6743\u9650\u3002", (String)"CentralRelationSettingPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Long modelId = this.getModelId();
        Long schemeId = this.getCurrentSchemeTabId();
        Long centralRangeId = this.getCurrentCentralRangeId();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        this.saveDefaultRelScheme(schemeId);
        Long bizModelId = centralRelationService.getCentralRangeBizModelId(centralRangeId);
        List<CentralRelationRecord> records = this.packCentralRelation(schemeId, modelCacheHelper, false, null);
        centralRelationService.delCentralRelation((Set)Sets.newHashSet((Object[])new Long[]{schemeId}));
        centralRelationService.saveCentralRelationRecord(records);
        centralRelationService.delCentralRelationRelationMemberQuote(Collections.singletonList(schemeId));
        centralRelationService.addCentralRelationRecordQuote(modelId, bizModelId, records);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CentralRelationSettingPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.writeLog("save", new MultiLangEnumBridge("\u4fdd\u5b58", "CentralRangePlugin_14", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5f52\u53e3\u5173\u7cfb\u5df2\u4fdd\u5b58\u3002", "CentralRangePlugin_20", "epm-eb-formplugin"));
        this.refreshCentralRelation();
        this.setDataChange(false);
    }

    private List<CentralRelationRecord> packCentralRelation(Long schemeId, IModelCacheHelper modelCacheHelper, boolean needCheck, Set<Integer> selectRows) {
        ArrayList<CentralRelationRecord> records = new ArrayList<CentralRelationRecord>(10);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            boolean centralRangeStatus = centralRelationService.getCentralRangeStatus(this.getCurrentCentralRangeId());
            Map centralRangeDimView = centralRelationService.getCentralRangeDimView(this.getCurrentCentralRangeId());
            Map<String, String> dimToControlKeyMap = this.getDimToControlKeyMap();
            RangeEnum range = RangeEnum.ALL;
            for (DynamicObject object : entryEntity) {
                int seq = object.getInt("seq");
                if (selectRows != null && !selectRows.contains(seq - 1)) continue;
                CentralRelationRecord record = new CentralRelationRecord();
                Date enableDate = object.getDate(ENABLE_DATE);
                Date disableDate = object.getDate(DISABLE_DATE);
                if (enableDate != null) {
                    enableDate.setHours(0);
                    enableDate.setMinutes(0);
                    enableDate.setSeconds(0);
                }
                if (disableDate != null) {
                    disableDate.setHours(23);
                    disableDate.setMinutes(59);
                    disableDate.setSeconds(59);
                }
                if (needCheck) {
                    if (object.get(DIM_ENTITY) == null || enableDate == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u53e3\u5173\u7cfb\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u586b\u3002", (String)"CentralRelationSettingPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return null;
                    }
                    if (disableDate != null && enableDate.compareTo(disableDate) > 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7981\u7528\u65f6\u95f4\u5e94\u665a\u4e8e\u542f\u7528\u65f6\u95f4\uff0c\u6216\u4e0d\u586b\u3002", (String)"CentralRelationSettingPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return null;
                    }
                }
                record.setSchemeId(schemeId);
                record.setEntityId(Long.valueOf(object.getLong("dim_entity_id")));
                for (Map.Entry entry : centralRangeDimView.entrySet()) {
                    String dimNumber = (String)entry.getKey();
                    if ("Entity".equals(dimNumber)) continue;
                    Long viewId = (Long)entry.getValue();
                    String colKey = dimToControlKeyMap.get(dimNumber);
                    Member member = modelCacheHelper.getMember(dimNumber, (Long)centralRangeDimView.get(dimNumber), Long.valueOf(object.getLong(colKey + "_id")));
                    if (member == null) continue;
                    record.addCentralDimMemberInfo(viewId, member, range);
                }
                record.setStatus(centralRangeStatus && object.getBoolean(STATUS));
                record.setEnableDate(enableDate);
                record.setDisableDate(disableDate);
                record.setModifier(Long.valueOf(object.getLong("modifier_id")));
                record.setModifyDate(object.getDate(MODIFY_DATE));
                record.setSeq(seq);
                records.add(record);
            }
        }
        return records;
    }

    private void addCentralRelation() {
        int[] rows = this.getSelCentralRelationRows();
        int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        Object entity = null;
        if (rows != null && rows.length != 0) {
            entity = this.getModel().getValue(DIM_ENTITY, rows[rows.length - 1]);
        } else if (rowCount > 0) {
            entity = this.getModel().getValue(DIM_ENTITY, rowCount - 1);
        }
        Long centralRangeId = this.getCurrentCentralRangeId();
        Long bizModelId = centralRelationService.getCentralRangeBizModelId(centralRangeId);
        Map centralRangeDimView = centralRelationService.getCentralRangeDimView(centralRangeId);
        Set readPermMembIds = DimMembPermHelper.getReadPermMembIds((String)"Entity", (Long)this.getModelId(), (Long)bizModelId, (Long)((Long)centralRangeDimView.get("Entity")), (boolean)true);
        if (entity instanceof DynamicObject && readPermMembIds != null && !readPermMembIds.contains(((DynamicObject)entity).getLong("id"))) {
            entity = null;
        }
        boolean centralRangeStatus = centralRelationService.getCentralRangeStatus(centralRangeId);
        this.getModel().beginInit();
        int row = this.getModel().createNewEntryRow(ENTRY_ENTITY);
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, row);
        rowEntity.set(DIM_ENTITY, entity);
        rowEntity.set(STATUS, (Object)(centralRangeStatus ? "1" : "0"));
        rowEntity.set(ENABLE_DATE, (Object)TimeServiceHelper.now());
        rowEntity.set("modifier_id", (Object)UserUtils.getUserId());
        rowEntity.set(MODIFY_DATE, (Object)TimeServiceHelper.now());
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
        this.setDataChange(true);
    }

    private void delCentralRelation() {
        int[] rows = this.getSelCentralRelationRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"CentralRelationSettingPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryRows(ENTRY_ENTITY, rows);
        this.getView().updateView(ENTRY_ENTITY);
        this.setDataChange(true);
    }

    private void importCentralRelation() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epm_import");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("model", (Object)this.getModelId());
        showParameter.setCustomParam("centralSchemeId", (Object)this.getCurrentSchemeTabId());
        showParameter.setCustomParam("centralRangeId", (Object)this.getCurrentCentralRangeId());
        showParameter.setCaption(ResManager.loadKDString((String)"\u5f52\u53e3\u65b9\u6848\u5bfc\u5165", (String)"CentralRelationSettingPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)"epm_import");
        formConfig.getPlugins().clear();
        showParameter.setFormConfig(formConfig);
        showParameter.addCustPlugin("kd.epm.eb.formplugin.centralrelation.CentralRelationImportPlugin");
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, CENTRAL_IMPORT_CALL_BACK);
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    private void exportCentralRelation(boolean isAll) {
        HashSet<Integer> selectRows;
        if (isAll) {
            int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
            if (rowCount == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"CentralRelationSettingPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            selectRows = new HashSet(rowCount);
            for (int i = 0; i < rowCount; ++i) {
                selectRows.add(i);
            }
        } else {
            int[] rows = this.getSelCentralRelationRows();
            if (rows == null || rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"CentralRelationSettingPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            selectRows = Arrays.stream(rows).boxed().collect(Collectors.toSet());
        }
        this.exportCentralRelation(selectRows);
    }

    private void exportCentralRelation(Set<Integer> selectRows) {
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Set centralRangeDim = centralRelationService.getCentralRangeDim(this.getCurrentCentralRangeId());
        Map centralRangeDimView = centralRelationService.getCentralRangeDimView(this.getCurrentCentralRangeId());
        List<CentralRelationRecord> records = this.packCentralRelation(this.getCurrentSchemeTabId(), modelCacheHelper, false, selectRows);
        XSSFWorkbook exportDataExcelBook = exportUtils.getExportDataExcelBook(0, modelCacheHelper, centralRangeDim, records, centralRangeDimView);
        try {
            ExcelHelper.downloadExcel((XSSFWorkbook)exportDataExcelBook, (String)ResManager.loadKDString((String)"\u5f52\u53e3\u5173\u7cfb", (String)"CentralRelationSettingPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]), (IFormView)this.getView());
        }
        catch (IOException e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadResFormat((String)"\u4e0b\u8f7dExcel\u53d1\u751f\u5f02\u5e38\uff1a%1\u3002", (String)"CentralRelationImportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{ThrowableHelper.toString((Exception)e)}));
        }
    }

    private void enableCentralRelation(boolean enable) {
        int[] rows = this.getSelCentralRelationRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"CentralRelationSettingPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!centralRelationService.getCentralRangeStatus(this.getCurrentCentralRangeId()) && enable) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5f52\u53e3\u5173\u7cfb\u65b9\u6848\u7684\u5f52\u53e3\u7ba1\u7406\u8303\u56f4\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u542f\u7528\u5f52\u53e3\u5173\u7cfb\u3002", (String)"CentralRelationSettingPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String status = enable ? "1" : "0";
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        this.getModel().beginInit();
        for (int row : rows) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, row);
            rowEntity.set(STATUS, (Object)status);
            rowEntity.set("modifier_id", (Object)userId);
            rowEntity.set(MODIFY_DATE, (Object)now);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
        this.doSelCentralRelationRows(rows);
        this.getView().showSuccessNotification(enable ? ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"CentralRelationSettingPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"CentralRelationSettingPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.setDataChange(true);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String f7Key = event.getProperty().getName();
        if ("model".equals(f7Key)) {
            this.modelBeforeF7(event);
        } else if (f7Key.startsWith(PRE_DIM_FIELD)) {
            this.dimBeforeF7(event);
        }
    }

    private void dimBeforeF7(BeforeF7SelectEvent event) {
        Long modelId = this.getModelId();
        Long centralRangeId = this.getCurrentCentralRangeId();
        Map<String, String> dimToControlKeyMap = this.getDimToControlKeyMap();
        String dimNumber = dimToControlKeyMap.get(event.getProperty().getName());
        if (dimNumber == null) {
            return;
        }
        Long bizModelId = centralRelationService.getCentralRangeBizModelId(centralRangeId);
        Map centralRangeDimView = centralRelationService.getCentralRangeDimView(centralRangeId);
        Long viewId = (Long)centralRangeDimView.get(dimNumber);
        MemberF7Parameter f7Param = "Entity".equals(dimNumber) ? NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName()) : NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
        f7Param.setCanSelectRoot(!SysDimensionEnum.include((String)dimNumber, (Boolean)true));
        f7Param.setBusModelId(bizModelId);
        if (IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) {
            f7Param.setViewId(viewId);
        }
        NewF7Utils.openF7((BeforeF7SelectEvent)event, (MemberF7Parameter)f7Param, (CloseCallBack)NewF7Utils.closeCallBack((IFormPlugin)this, (String)DIM_F7_SELECT_CALL_BACK));
    }

    private void modelBeforeF7(BeforeF7SelectEvent e) {
        if (this.getDataChange()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u53e3\u5173\u7cfb\u4fe1\u606f\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"CentralRelationSettingPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        ArrayList qFilterList = ((BasedataEdit)this.getControl("model")).getQFilters();
        if (qFilterList == null) {
            qFilterList = new ArrayList();
        }
        qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
    }

    private void batchSettingRelation() {
        int[] selectRows = this.getSelCentralRelationRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CentralRelationSettingPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_centralrel_batchset");
        showParameter.setCustomParam("scheme", (Object)this.getCurrentSchemeTabId());
        showParameter.setCustomParam("model", (Object)this.getModelId());
        showParameter.setCustomParam("centralRangeId", (Object)this.getCurrentCentralRangeId());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BATCH_SETTING_CALLBACK));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void batchSettingRelationCallBack(Object returnData) {
        Map data = (Map)returnData;
        String curBatchEditField = (String)data.get("curBatchEditField");
        Object value = data.get("value");
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        Long centralRangeId = this.getCurrentCentralRangeId();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        int[] selectRows = this.getSelCentralRelationRows();
        this.getModel().beginInit();
        for (int selectRow : selectRows) {
            this.getModel().setValue(curBatchEditField, value, selectRow);
            this.getModel().setValue("modifier_id", (Object)userId, selectRow);
            this.getModel().setValue(MODIFY_DATE, (Object)now, selectRow);
        }
        HashSet<String> preDimColsSet = new HashSet<String>(preDimCols);
        if (preDimColsSet.contains(curBatchEditField) && !DIM_ENTITY.equals(curBatchEditField)) {
            Long memberId;
            Member member;
            String dimNumber = this.getDimToControlKeyMap().get(curBatchEditField);
            Long viewId = centralRelationService.getCentralRangeDimView(centralRangeId).getOrDefault(dimNumber, 0L);
            String rangeNameValue = null;
            if (value instanceof DynamicObject && (member = modelCacheHelper.getMember(dimNumber, viewId, memberId = Long.valueOf(((DynamicObject)value).getLong("id")))) != null) {
                RangeEnum rangeEnum = member.isLeaf() ? RangeEnum.ONLY : RangeEnum.ALL;
                rangeNameValue = member.getName() + "_" + rangeEnum.getName();
            }
            String dimNameColKey = "Account".equals(dimNumber) ? curBatchEditField + "name" : curBatchEditField.replace(USER_DEFINE, "userdefinename");
            for (int selectRow : selectRows) {
                this.getModel().setValue(dimNameColKey, rangeNameValue, selectRow);
            }
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
        this.setDataChange(true);
        this.doSelCentralRelationRows(selectRows);
    }

    private void doSelCentralRelationRows(int[] selectRows) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.selectRows(selectRows, selectRows[0]);
    }

    private int[] getSelCentralRelationRows() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        return entryGrid.getSelectRows();
    }

    private int getFocusRelationRow() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        return entryGrid.getEntryState().getFocusRow();
    }

    private Long getCurrentSchemeTabId() {
        String cache = (String)this.getCache(CURRENT_TAB_ID, String.class);
        return IDUtils.toLong((Object)cache);
    }

    private void setDataChange(boolean dataChange) {
        if (dataChange) {
            this.getPageCache().put(DATA_CHANGE, "1");
        } else {
            this.getPageCache().remove(DATA_CHANGE);
        }
    }

    private boolean getDataChange() {
        return this.getPageCache().get(DATA_CHANGE) != null;
    }

    @Override
    public Long getModelId() {
        String cache = this.getPageCache().get("model");
        if (StringUtils.isNotEmpty((CharSequence)cache)) {
            return IDUtils.toLong((Object)cache);
        }
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model != null) {
            return model.getLong("id");
        }
        return 0L;
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        boolean selecting = this.getPageCache().get(SELECTING_SIGN) == null;
        this.removeCache(SELECTING_SIGN);
        if (this.getDataChange() && selecting) {
            this.putCache(TAB_ID_FOR_CONFIRM, tabKey);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f52\u53e3\u5173\u7cfb\u4fe1\u606f\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"CentralRelationSettingPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(TAB_SELECTED_CONFIRM, (IFormPlugin)this));
            return;
        }
        if (!this.getDataChange()) {
            this.doSelectTab(tabKey);
        }
    }

    protected void doSelectTab(String tabId) {
        this.getPageCache().put(CURRENT_TAB_ID, tabId);
        this.refreshCentralRelation();
    }

    private boolean checkHasModifyPerm() {
        Long modelId;
        Long userId = this.getUserId();
        if (!MemberPermHelper.ifUserHasRootPermByModel((Long)userId, (Long)(modelId = this.getModelId()))) {
            return this.checkItemPermission(userId, modelId, this.getBizAppId(), this.getView().getEntityId(), "4715a0df000000ac") != 0;
        }
        return true;
    }
}

