/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralrelation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.centralrelation.CentralRelationShotService;
import kd.epm.eb.formplugin.centralrelation.CentralRelationSettingPlugin;

public class CentralRelationShotFixPlugin
extends CentralRelationSettingPlugin
implements BeforeF7SelectListener,
TabSelectListener {
    private static Long centralRangeId = null;

    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"refresh"});
        this.addF7SelectListener(this, new String[]{"approvebill"});
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.getModel().deleteEntryData("entryentity");
        this.getView().setVisible(Boolean.valueOf(false), CentralRelationSettingPlugin.preDimCols.toArray(new String[0]));
        this.getView().setVisible(Boolean.valueOf(false), CentralRelationSettingPlugin.preDimNameCols.toArray(new String[0]));
        this.getPageCache().batchRemove(Arrays.asList("lefttreecache", "currentSelectTabId", "dimToControlKeyMap"));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        listShowParameter.setFormId("bos_list");
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("modelid", "=", (Object)this.getModelId()));
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u9884\u7b97\u5ba1\u6838\u5355\u636e\u5217\u8868", (String)"", (String)"", (Object[])new Object[0]));
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("approvebill".equals(name)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            this.dealCentralOrgRefresh(newValue);
            this.dealShotRefresh(newValue);
        } else if ("model".equals(name)) {
            this.getModel().setValue("approvebill", null);
        }
    }

    private void dealCentralOrgRefresh(Object newValue) {
        if (newValue instanceof DynamicObject) {
            DynamicObject approveBill = (DynamicObject)newValue;
            long centralOrg = approveBill.getLong("centralorg.id");
            this.getModel().setValue("entity", (Object)centralOrg);
        } else {
            this.getModel().setValue("entity", null);
        }
    }

    private void dealShotRefresh(Object newValue) {
        this.getModel().deleteEntryData("entryentity");
        if (newValue instanceof DynamicObject) {
            DynamicObject approveBill = (DynamicObject)newValue;
            DynamicObjectCollection schemes = approveBill.getDynamicObjectCollection("entryentity_centralschema");
            if (schemes == null || schemes.size() == 0) {
                return;
            }
            ArrayList<DynamicObject> schemes_list = new ArrayList<DynamicObject>(16);
            for (DynamicObject scheme : schemes) {
                schemes_list.add(scheme.getDynamicObject("centralschema"));
            }
            this.removeCache("currentSelectTabId");
            centralRangeId = this.getCentralRangeId(schemes_list);
            this.setCentralDimColVisible();
            this.buildTab(schemes_list.toArray(new DynamicObject[0]), null, false);
            this.refreshCentralRelation();
        } else {
            this.getView().setVisible(Boolean.valueOf(false), CentralRelationSettingPlugin.preDimCols.toArray(new String[0]));
            this.getView().setVisible(Boolean.valueOf(false), CentralRelationSettingPlugin.preDimNameCols.toArray(new String[0]));
            this.getPageCache().batchRemove(Arrays.asList("lefttreecache", "currentSelectTabId", "dimToControlKeyMap"));
            this.clearTab();
        }
    }

    @Override
    protected Long getCurrentCentralRangeId() {
        if (centralRangeId == null) {
            DynamicObject approveBill = (DynamicObject)this.getValue("approvebill", null);
            if (approveBill == null) {
                return 0L;
            }
            DynamicObjectCollection schemes = approveBill.getDynamicObjectCollection("entryentity_centralschema");
            if (schemes == null || schemes.size() == 0) {
                return 0L;
            }
            ArrayList<DynamicObject> schemes_list = new ArrayList<DynamicObject>(16);
            for (DynamicObject scheme : schemes) {
                schemes_list.add(scheme.getDynamicObject("centralschema"));
            }
            centralRangeId = this.getCentralRangeId(schemes_list);
        }
        return centralRangeId;
    }

    private Long getCentralRangeId(List<DynamicObject> schemes) {
        List schemeIds = schemes.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        if (schemeIds.size() == 0) {
            return 0L;
        }
        QFilter qFilter = new QFilter("id", "in", schemeIds);
        DynamicObject relScheme = QueryServiceHelper.queryOne((String)"eb_centralrelscheme", (String)"centralrange", (QFilter[])new QFilter[]{qFilter});
        if (relScheme == null) {
            return 0L;
        }
        return relScheme.getLong("centralrange");
    }

    @Override
    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        this.doSelectTab(tabKey);
    }

    @Override
    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if (!"refresh".equals(controlKey)) {
            return;
        }
        DynamicObject bill = (DynamicObject)this.getValue("approvebill", null);
        if (bill == null) {
            return;
        }
        Long billId = bill.getLong("id");
        CentralRelationShotService instance = CentralRelationShotService.getInstance();
        Map centralRelationShot = instance.getCentralRelationShot(billId);
        instance.saveCentralRelationShot(new HashSet(centralRelationShot.keySet()), Collections.singleton(billId));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u751f\u6210\u5feb\u7167\u6210\u529f", (String)"", (String)"", (Object[])new Object[0]));
        this.dealCentralOrgRefresh(bill);
        this.dealShotRefresh(bill);
    }

    @Override
    public Long getModelId() {
        DynamicObject model = (DynamicObject)this.getValue("model", null);
        if (model == null) {
            return 0L;
        }
        return model.getLong("id");
    }
}

