/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.combinoffset;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.olap.OlapServiceCaller;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.metadata.KDCell;
import kd.epm.eb.olap.impl.utils.KDOlapRequestUtils;
import kd.epm.eb.olap.service.AlgoCalcUtils;
import kd.epm.eb.olap.service.OlapManager;
import kd.epm.eb.olap.service.request.SaveRequest;

public class OffsetEntryService {
    private static final Log log = LogFactory.getLog(OffsetEntryService.class);
    private static final String K_DATASETID = "datasetid!";
    private static final String K_VALUE = "value!";
    private static volatile OffsetEntryService INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OffsetEntryService getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<OffsetEntryService> clazz = OffsetEntryService.class;
        synchronized (OffsetEntryService.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new OffsetEntryService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private OffsetEntryService() {
    }

    public List<Map<String, String>> convertOlapData(Long id, IModelCacheHelper orCreate) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_offsetentry");
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("Version", object.getString("version.number"));
        map.put("DataType", object.getString("datatype.number"));
        map.put("Entity", object.getString("offsetorg.number"));
        map.put("BudgetPeriod", object.getString("period.number"));
        map.put("AuditTrail", object.getString("audittrail.number"));
        map.put("ChangeType", object.getString("changetype.number"));
        map.put("Currency", object.getString("currency.number"));
        map.put("InternalCompany", "ICNone");
        for (int i = 1; i < 7; ++i) {
            DynamicObject selfdim = object.getDynamicObject("selfdim" + i);
            if (selfdim == null) continue;
            map.put(selfdim.getString("dimension.number"), selfdim.getString("number"));
        }
        boolean isMoney = object.getDynamicObject("metric") != null;
        boolean isAmount = object.getDynamicObject("metricqty") != null;
        DynamicObjectCollection entryentity = object.getDynamicObjectCollection("entryentity");
        Map<String, List<DynamicObject>> collect = entryentity.stream().collect(Collectors.groupingBy(e -> e.getString("account.number")));
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(10);
        for (Map.Entry<String, List<DynamicObject>> entry : collect.entrySet()) {
            BigDecimal money = BigDecimal.ZERO;
            BigDecimal amount = BigDecimal.ZERO;
            HashMap<String, String> map1 = new HashMap<String, String>(map);
            map1.put("Account", entry.getKey());
            List<DynamicObject> values = entry.getValue();
            Long datasetid = values.get(0).getLong("account.dataset.id");
            map1.put(K_DATASETID, String.valueOf(datasetid));
            List<Dimension> dims = orCreate.getDimensionList(datasetid).stream().filter(d -> !d.isPreset()).collect(Collectors.toList());
            dims.forEach(d -> map1.computeIfAbsent(d.getNumber(), v -> d.getNoneNumber()));
            for (DynamicObject value : values) {
                money = money.add(value.getBigDecimal("amount"));
                amount = amount.add(value.getBigDecimal("amountqty"));
            }
            if (isMoney) {
                map1.put("Metric", "Money");
                map1.put(K_VALUE, money.toString());
                list.add(map1);
            }
            if (!isAmount) continue;
            HashMap<String, String> map2 = new HashMap<String, String>(map1);
            map2.put("Metric", "Amount");
            map2.put(K_VALUE, amount.toString());
            list.add(map2);
        }
        return list;
    }

    public Map<Long, List<IKDCell>> handleOlapData(List<Map<String, String>> olapData, IModelCacheHelper orCreate, boolean isadd) {
        HashMap<Long, List<IKDCell>> originalData = new HashMap<Long, List<IKDCell>>(16);
        for (Map<String, String> olapDatum : olapData) {
            String datasetid = olapDatum.remove(K_DATASETID);
            String value = olapDatum.remove(K_VALUE);
            SelectCommandInfo queryInfo = new SelectCommandInfo();
            queryInfo.addDims(orCreate.getDimensionNums(Long.valueOf(Long.parseLong(datasetid))));
            queryInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            for (Map.Entry<String, String> e : olapDatum.entrySet()) {
                if (!queryInfo.getDimensions().contains(e.getKey())) continue;
                queryInfo.addFilter(e.getKey(), new String[]{e.getValue()});
            }
            IKDOlapRequest olapRequest = KDOlapRequestUtils.of((Long)orCreate.getModelobj().getId(), (Long)Long.parseLong(datasetid), (SelectCommandInfo)queryInfo, (boolean)true);
            List cells = new OlapServiceCaller().get(olapRequest);
            if (cells != null && cells.size() > 0) {
                BigDecimal getValue = ((IKDCell)cells.get(0)).getValue().getDecimal();
                originalData.computeIfAbsent(Long.parseLong(datasetid), v -> new ArrayList()).addAll(cells);
                if (getValue == null) {
                    getValue = BigDecimal.ZERO;
                }
                BigDecimal inputValue = new BigDecimal(value);
                value = isadd ? getValue.subtract(inputValue).toString() : getValue.add(inputValue).toString();
            } else {
                value = BigDecimal.ZERO.subtract(new BigDecimal(value)).toString();
            }
            olapDatum.put(K_VALUE, value);
            olapDatum.put(K_DATASETID, datasetid);
        }
        return originalData;
    }

    public void saveOlap(List<Map<String, String>> olapData, IModelCacheHelper modelCache, Map<Long, List<IKDCell>> originalData, String functionName) {
        Map<String, List<Map>> group = olapData.stream().collect(Collectors.groupingBy(d -> (String)d.get(K_DATASETID)));
        Long modelId = modelCache.getModelobj().getId();
        try {
            for (Map.Entry<String, List<Map>> entry : group.entrySet()) {
                List<Map> values = entry.getValue();
                ArrayList<IKDCell> cells = new ArrayList<IKDCell>(values.size());
                long datasetId = Long.parseLong(entry.getKey());
                String[] dimensionNums = modelCache.getDimensionNums(Long.valueOf(datasetId));
                for (Map value : values) {
                    String[] mems = new String[dimensionNums.length];
                    for (int i = 0; i < dimensionNums.length; ++i) {
                        mems[i] = (String)value.get(dimensionNums[i]);
                    }
                    IKDCell cell = KDCell.of((String[])mems);
                    BigDecimal val = new BigDecimal((String)value.get(K_VALUE));
                    if (BigDecimal.ZERO.compareTo(val) == 0) {
                        val = null;
                    }
                    cell.setValue(KDValue.valueOf((BigDecimal)val));
                    cells.add(cell);
                }
                List dimensionList = modelCache.getDimensionList(Long.valueOf(datasetId));
                List bgCellList = cells.stream().map(kdCell -> AlgoCalcUtils.toBGCell((IKDCell)kdCell, (IModelCacheHelper)modelCache, (List)dimensionList)).collect(Collectors.toList());
                OlapManager.getInstance().saveList(new SaveRequest(modelId, Long.valueOf(datasetId), bgCellList));
            }
        }
        catch (Exception e) {
            this.rollBackOlapData(modelCache, originalData, functionName);
            log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    public void rollBackOlapData(IModelCacheHelper modelCache, Map<Long, List<IKDCell>> originalDatas, String functionName) {
        long modelId = modelCache.getModelobj().getId();
        try {
            for (Map.Entry<Long, List<IKDCell>> entry : originalDatas.entrySet()) {
                Long datasetId = entry.getKey();
                List dimensionList = modelCache.getDimensionList(datasetId);
                List bgCellList = entry.getValue().stream().map(kdCell -> AlgoCalcUtils.toBGCell((IKDCell)kdCell, (IModelCacheHelper)modelCache, (List)dimensionList)).collect(Collectors.toList());
                OlapManager.getInstance().saveList(new SaveRequest(Long.valueOf(modelId), datasetId, bgCellList));
            }
        }
        catch (Exception e) {
            log.error("offset :" + functionName, originalDatas);
            log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    public void checkMemberPermission(IModelCacheHelper modelCacheHelper, List<Map<String, String>> olapData, DimMembPermType permType) {
        if (olapData != null && !olapData.isEmpty() && modelCacheHelper != null && permType != null) {
            HashSet<String> noPermDims = new HashSet<String>(16);
            Long modelId = modelCacheHelper.getModelobj().getId();
            Map<String, List<Map>> groupByDS = olapData.stream().collect(Collectors.groupingBy(d -> (String)d.get(K_DATASETID)));
            for (Map.Entry<String, List<Map>> entry : groupByDS.entrySet()) {
                boolean hasDimGroups;
                List<Map> values = entry.getValue();
                Long datasetId = IDUtils.toLong((Object)entry.getKey());
                Long busmodelid = modelCacheHelper.getBusModelByDataSet(datasetId);
                Map dimensionViews = modelCacheHelper.getViewsByBusModel(busmodelid);
                Set dimensionNums = modelCacheHelper.getDimensionList(datasetId).stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                List dimGroups = DimMembPermHelper.getPermDimGroupWithData((Long)modelId, (Long)datasetId);
                boolean bl = hasDimGroups = dimGroups != null && !dimGroups.isEmpty();
                if (hasDimGroups) {
                    DimMemberPermChecker dimMemberPermChecker = permType == DimMembPermType.WRITE ? DimMembPermHelper.getWritePermChecker((Long)modelId, (Long)datasetId) : DimMembPermHelper.getReadPermChecker((Long)modelId, (Long)datasetId);
                    for (Map value : values) {
                        HashMap memberGroup = new HashMap(16);
                        LinkedList memberMsg = new LinkedList();
                        value.forEach((k, v) -> {
                            Member member;
                            if (dimensionNums.contains(k) && (member = modelCacheHelper.getMember(k, (Long)dimensionViews.get(k), v)) != null) {
                                memberGroup.put(k, new MemberItem(true, member.getId(), member.getNumber()));
                                memberMsg.add(member.getName());
                            }
                        });
                        if (dimMemberPermChecker.check(memberGroup)) continue;
                        throw new KDBizException(ResManager.loadResFormat((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u7ef4\u5ea6\u7ec4\u5408%1\u7684\u6210\u5458%2\u6743\u9650\u3002", (String)"OffsetEntryService_2", (String)"epm-eb-formplugin", (Object[])new Object[]{memberMsg, permType.getName()}));
                    }
                    continue;
                }
                HashMap dimMembers = new HashMap(16);
                for (Map value : values) {
                    value.forEach((k, v) -> {
                        if (dimensionNums.contains(k)) {
                            Set memNumbers = dimMembers.computeIfAbsent(k, f -> new HashSet(16));
                            memNumbers.add(v);
                        }
                    });
                }
                for (Map.Entry entry1 : dimMembers.entrySet()) {
                    Long viewId;
                    String dimNumber = (String)entry1.getKey();
                    Set permMembNumbers = DimMembPermHelper.getPermMembNumbers((String)dimNumber, (Long)modelId, (Long)busmodelid, (Long)(viewId = (Long)dimensionViews.get(dimNumber)), (DimMembPermType)permType, (boolean)true);
                    if (permMembNumbers == null || permMembNumbers.containsAll((Collection)entry1.getValue())) continue;
                    noPermDims.add(dimNumber);
                }
            }
            if (!noPermDims.isEmpty()) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%1\u7ef4\u5ea6\u7684\u6210\u5458%2\u6743\u9650\u3002", (String)"OffsetEntryService_1", (String)"epm-eb-formplugin", (Object[])new Object[]{noPermDims, permType.getName()}));
            }
        }
    }
}

