/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.combinoffset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.combinoffset.OffsetHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.IMemberPermCache;
import kd.epm.eb.common.permission.MemberPermCacheServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;

public class OffsetExcuteReportPlugin
extends AbstractListPlugin {
    private Map<String, String> fildMapped2Name = null;
    private IMemberPermCache memberPerm = null;
    private Long busmodelId = null;

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List listColumns = args.getListColumns();
        Map<String, String> fildMapped2Name = this.getFildMapped2Name();
        if (fildMapped2Name != null && !fildMapped2Name.isEmpty()) {
            listColumns.forEach(e -> {
                String key = e.getListFieldKey();
                if (key.startsWith("selfdim")) {
                    if (fildMapped2Name.containsKey(key)) {
                        e.setVisible(11);
                        e.setCaption(new LocaleString((String)fildMapped2Name.get(key)));
                    } else {
                        e.setVisible(0);
                    }
                }
            });
        } else {
            listColumns.forEach(e -> {
                if (e.getListFieldKey().startsWith("selfdim")) {
                    e.setVisible(0);
                }
            });
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Set noPermMems = this.getMemberPerm().getNopermMems(SysDimensionEnum.Entity.getNumber(), Long.valueOf(0L));
        if (noPermMems != null) {
            e.getQFilters().add(new QFilter("offsetexelog", "=", (Object)this.getLogEntryId()).and("cslorg.number", "not in", (Object)noPermMems));
        } else {
            e.getQFilters().add(new QFilter("offsetexelog", "=", (Object)this.getLogEntryId()));
        }
        e.setOrderBy("offsetrule.number,cslorg.number,period.number");
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button button = (Button)this.getView().getControl("btn_export");
        if (button != null) {
            button.addClickListener((ClickListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if ("btn_export".equals(((Button)evt.getSource()).getKey())) {
            this.getView().invokeOperation("exportlist");
        }
    }

    public Map<String, String> getFildMapped2Name() {
        if (this.fildMapped2Name == null) {
            Long busModelId;
            this.fildMapped2Name = new HashMap<String, String>(16);
            Long modelId = this.getModelId();
            List assistDims = OffsetHelper.getAssistDims((Long)modelId, (Long)(busModelId = this.getBusModelId()));
            if (assistDims != null && !assistDims.isEmpty()) {
                QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
                QFilter numberFilter = new QFilter("number", "in", (Object)assistDims.toArray());
                QFilter[] udqf = new QFilter[]{modelFilter, numberFilter};
                DynamicObjectCollection dims = QueryServiceHelper.query((String)"epm_dimension", (String)"id, number, shortnumber, name, fieldmapped, issysdimension", (QFilter[])udqf, (String)"dseq");
                int i = 1;
                for (DynamicObject d : dims) {
                    if (d.getBoolean("issysdimension")) continue;
                    this.fildMapped2Name.put("selfdim" + i + ".name", d.getString("name"));
                    ++i;
                }
            }
        }
        return this.fildMapped2Name;
    }

    public IMemberPermCache getMemberPerm() {
        if (this.memberPerm == null) {
            this.memberPerm = MemberPermCacheServiceHelper.build(null, (Long)this.getModelId(), (Long)this.getBusModelId(), null);
        }
        return this.memberPerm;
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
    }

    public Long getBusModelId() {
        if (this.busmodelId == null) {
            String parameterdata = null;
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getLogEntryId(), (String)"eb_offsetexecutelog", (String)"parameterdata");
            if (dynamicObject != null && (parameterdata = dynamicObject.getString("parameterdata")) != null) {
                JSONObject jsonObject = JSON.parseObject((String)parameterdata);
                this.busmodelId = IDUtils.toLong((Object)jsonObject.getString("busmodelID"));
            }
        }
        return this.busmodelId;
    }

    public Long getLogEntryId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("logEntryId"));
    }
}

