/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.combinoffset;

import com.alibaba.fastjson.JSON;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.epm.eb.business.combinoffset.OffsetExecuteParam;
import kd.epm.eb.business.combinoffset.OffsetExecutor;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.entity.memberF7.SingleTreeF7Parameter;
import kd.epm.eb.common.enums.OffsetExecuteStatusEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MemberF7.ParameterF7Builder;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;

public class OffsetExecutePlugin
extends AbstractFormPlugin
implements ProgresssListener,
BeforeF7SelectListener {
    private static final String CTRL_KEY_MODEL = "model";
    private static final String CTRL_KEY_BUSMODEL = "busmodel";
    private static final String CTRL_KEY_DATATYPE = "datatype";
    private static final String CTRL_KEY_VERSION = "version";
    private static final String CTRL_KEY_ENTRYENTITY = "entryentity";
    private static final String CTRL_KEY_ORG = "org";
    private static final String CTRL_KEY_ORG_VIEW = "orgview";
    private static final String CTRL_KEY_BEGINPEIOD = "beginperiod";
    private static final String CTRL_KEY_ENDPEIOD = "endperiod";
    private static final String CTRL_KEY_PROGRESSBAR = "progressbar";
    private static final String CTRL_KEY_BAREXECUTE = "barexecute";
    private static final String CTRL_KEY_BARBACKGROUNDEXE = "barbackgroundexe";
    private static final String CTRL_KEY_BARCANCEL = "barcancel";
    private static ThreadPool threadPool = null;

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap", "showtoolbarap"});
        PluginUtils.registerF7Listener(new String[]{CTRL_KEY_MODEL, CTRL_KEY_BUSMODEL, CTRL_KEY_DATATYPE, CTRL_KEY_VERSION, CTRL_KEY_ORG, CTRL_KEY_BEGINPEIOD, CTRL_KEY_ENDPEIOD}, true, false, this);
    }

    @Override
    public void registerListener(EventObject e) {
        ProgressBar progressBar = (ProgressBar)this.getControl(CTRL_KEY_PROGRESSBAR);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        String busmodelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_BUSMODEL_ID");
        if (!StringUtils.isEmpty((String)modelId)) {
            this.getModel().setValue(CTRL_KEY_MODEL, (Object)Long.valueOf(modelId));
        }
        if (!StringUtils.isEmpty((String)busmodelId)) {
            this.getModel().setValue(CTRL_KEY_BUSMODEL, (Object)Long.valueOf(busmodelId));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{CTRL_KEY_BUSMODEL});
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{CTRL_KEY_MODEL});
        this.setUserSelect(IDUtils.toLong((Object)modelId), IDUtils.toLong((Object)busmodelId));
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "barexecute": {
                this.execute(false);
                break;
            }
            case "barbackgroundexe": {
                this.execute(true);
                break;
            }
            case "barcancel": {
                this.cancelExecute();
                break;
            }
            case "addrow": {
                this.getModel().createNewEntryRow(CTRL_KEY_ENTRYENTITY);
                break;
            }
            case "deleterow": {
                int[] rows = this.getEnterySelectRows();
                if (rows.length > 0) {
                    this.getModel().deleteEntryRows(CTRL_KEY_ENTRYENTITY, rows);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u884c\u3002", (String)"OffsetExecutePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void execute(boolean backgroundExe) {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{CTRL_KEY_BAREXECUTE, CTRL_KEY_BARBACKGROUNDEXE});
        List<OffsetExecuteParam> paramList = this.getOffsetExecuteParam();
        String loginIP = RequestContext.getOrCreate().getLoginIP();
        String traceId = RequestContext.getOrCreate().getTraceId();
        paramList.forEach(param -> OffsetExecutePlugin.getThreadPool().execute(() -> {
            RequestContext.getOrCreate().setLoginIP(loginIP);
            RequestContext.getOrCreate().setTraceId(traceId);
            OffsetExecutor offsetExecutor = new OffsetExecutor(param, this.getView().getPageId(), traceId);
            offsetExecutor.execute();
        }, RequestContext.get()));
        this.getPageCache().put("startprogress", "true");
        if (!backgroundExe) {
            ProgressBar progressBar = (ProgressBar)this.getControl(CTRL_KEY_PROGRESSBAR);
            progressBar.start();
            progressBar.setPercent(0, ResManager.loadKDString((String)"\u6267\u884c\u4e2d", (String)"OffsetExecutePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().close();
        }
        this.writeLog("execute", new MultiLangEnumBridge("\u6267\u884c\u5408\u5e76\u62b5\u6d88", "OffsetExecutePlugin_8", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5408\u5e76\u62b5\u6d88\u5df2\u6267\u884c\u3002", "OffsetExecutePlugin_9", "epm-eb-formplugin"));
    }

    private void showForm() {
        ListShowParameter formShowParameter = new ListShowParameter();
        formShowParameter.setFormId("eb_offsetexecute_report");
        formShowParameter.setBillFormId("eb_offsetexelogentry");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setShowTitle(true);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u672a\u751f\u6210\u62b5\u9500\u5206\u5f55\u5217\u8868", (String)"OffsetExecutePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        String logEntryId = this.getPageCache().get("logEntryId");
        formShowParameter.setCustomParam("logEntryId", (Object)this.getPageCache().get("logEntryId"));
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)(this.getModelId() + ""));
        formShowParameter.setCustomParam("KEY_BUSMODEL_ID", (Object)(this.getBusModelId() + ""));
        formShowParameter.setPageId(this.getView().getPageId() + "_" + logEntryId);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void setUserSelect(Long modelId, Long bizModelId) {
        QFilter parameterFilter = new QFilter(CTRL_KEY_MODEL, "=", (Object)modelId);
        parameterFilter.and("creater", "=", (Object)this.getUserId());
        String selectFields = "id,creater,model,parameterdata";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName().concat(".setUserSelect"), (String)"eb_offsetexecutelog", (String)selectFields, (QFilter[])parameterFilter.toArray(), (String)"createdate desc", (int)1);
        OffsetExecuteParam offsetExecuteParam = null;
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            String parameterData = next.getString("parameterdata");
            offsetExecuteParam = (OffsetExecuteParam)JSON.parseObject((String)parameterData, OffsetExecuteParam.class);
        }
        if (null != offsetExecuteParam) {
            Date startDate = offsetExecuteParam.getStartDate();
            LocalDateTime startDateTime = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            LocalDate lastLocalDate = startDateTime.with(TemporalAdjusters.lastDayOfMonth()).toLocalDate();
            LocalDateTime of = LocalDateTime.of(lastLocalDate, LocalTime.MAX);
            LocalDateTime localDateTime = of.minusNanos(of.getNano());
            this.setPeriod(startDateTime, localDateTime, modelId, CTRL_KEY_BEGINPEIOD);
            Date endDate = offsetExecuteParam.getEndDate();
            LocalDateTime endDateTime = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            LocalDateTime firstDayOfMonth = endDateTime.with(TemporalAdjusters.firstDayOfMonth()).toLocalDate().atStartOfDay();
            this.setPeriod(firstDayOfMonth, endDateTime, modelId, CTRL_KEY_ENDPEIOD);
            String versionNumber = offsetExecuteParam.getVersion();
            this.validateAndSetMember(versionNumber, "epm_versionmembertree", modelId, bizModelId, SysDimensionEnum.Version.getNumber(), CTRL_KEY_VERSION);
            String dataTypeNumber = offsetExecuteParam.getDatatype();
            this.validateAndSetMember(dataTypeNumber, "epm_datatypemembertree", modelId, bizModelId, SysDimensionEnum.DataType.getNumber(), CTRL_KEY_DATATYPE);
        }
    }

    private void setPeriod(LocalDateTime startDateTime, LocalDateTime endDateTime, Long modelId, String field) {
        long dataTypeId;
        boolean bol;
        boolean bl = bol = startDateTime == null || endDateTime == null || modelId == null || StringUtils.isEmpty((String)field);
        if (bol) {
            return;
        }
        QFilter qFilter = new QFilter(CTRL_KEY_MODEL, "=", (Object)modelId);
        qFilter.and("startdate", "=", (Object)startDateTime);
        qFilter.and("enddate", "=", (Object)endDateTime);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_bperiodmembertree", (String)"id,number,startdate,enddate", (QFilter[])qFilter.toArray());
        long l = dataTypeId = dynamicObject == null ? 0L : dynamicObject.getLong("id");
        if (dataTypeId != 0L) {
            this.getModel().setValue(field, (Object)dataTypeId);
        }
    }

    private void validateAndSetMember(String number, String entityNumber, Long modelId, Long bizModelId, String dimensionNumber, String field) {
        long dataTypeId;
        boolean bol;
        boolean bl = bol = StringUtils.isEmpty((String)number) || StringUtils.isEmpty((String)entityNumber) || StringUtils.isEmpty((String)field) || modelId == null;
        if (bol) {
            return;
        }
        QFilter numberFilter = new QFilter(CTRL_KEY_MODEL, "=", (Object)modelId);
        numberFilter.and("number", "=", (Object)number);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)entityNumber, (String)"id,number", (QFilter[])numberFilter.toArray());
        long l = dataTypeId = dynamicObject == null ? 0L : dynamicObject.getLong("id");
        if (dataTypeId != 0L) {
            Set permMembIds = DimMembPermHelper.getPermMembIds((String)dimensionNumber, (Long)modelId, (Long)bizModelId, (Long)0L, (DimMembPermType)DimMembPermType.READ, (boolean)true);
            if (permMembIds == null) {
                this.getModel().setValue(field, (Object)dataTypeId);
            } else if (permMembIds.contains(dataTypeId)) {
                this.getModel().setValue(field, (Object)dataTypeId);
            }
        }
    }

    public static ThreadPool getThreadPool() {
        if (threadPool == null) {
            threadPool = OffsetExecuteThreadPool.createExecutorService("controlCalcPools", 2, 10);
        }
        return threadPool;
    }

    private void cancelExecute() {
        this.getPageCache().put("startprogress", "false");
    }

    private int[] getEnterySelectRows() {
        EntryGrid eg = (EntryGrid)this.getControl(CTRL_KEY_ENTRYENTITY);
        return eg.getSelectRows();
    }

    private List<OffsetExecuteParam> getOffsetExecuteParam() {
        long modelId = this.getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        long bizModelId = ((DynamicObject)this.getModel().getValue(CTRL_KEY_BUSMODEL)).getLong("id");
        String datatype = ((DynamicObject)this.getModel().getValue(CTRL_KEY_DATATYPE)).getString("number");
        String version = ((DynamicObject)this.getModel().getValue(CTRL_KEY_VERSION)).getString("number");
        DynamicObject beginPeriod = (DynamicObject)this.getModel().getValue(CTRL_KEY_BEGINPEIOD);
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue(CTRL_KEY_ENDPEIOD);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(CTRL_KEY_ENTRYENTITY);
        if (entryEntity.getRowCount() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u5e76\u8303\u56f4\u3002", (String)"OffsetExecutePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (beginPeriod == null || endPeriod == null || beginPeriod.getDate("startDate") == null || endPeriod.getDate("startDate") == null || endPeriod.getDate("endDate") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u8303\u56f4\u3002", (String)"OffsetExecutePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (beginPeriod.getDate("startDate").after(endPeriod.getDate("startDate"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u671f\u95f4\u4e0d\u5141\u8bb8\u665a\u4e8e\u7ed3\u675f\u671f\u95f4\u3002", (String)"OffsetExecutePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        HashMap<Long, Set> viewMems = new HashMap<Long, Set>(16);
        for (DynamicObject dy : entryEntity) {
            DynamicObject org = (DynamicObject)dy.get(CTRL_KEY_ORG);
            if (org == null) continue;
            Long viewId = ((DynamicObject)dy.get(CTRL_KEY_ORG_VIEW)).getLong("id");
            Set orgNumbers = viewMems.computeIfAbsent(viewId, k -> new HashSet(16));
            List members = modelCache.getMember(SysDimensionEnum.Entity.getNumber(), viewId, org.getString("number"), dy.getInt("range"));
            members.forEach(e -> {
                if (!e.isLeaf()) {
                    orgNumbers.add(e.getNumber());
                }
            });
        }
        List<OffsetExecuteParam> paramList = viewMems.entrySet().stream().map(entry -> {
            Long viewId = (Long)entry.getKey();
            Set orgNumbers = (Set)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)orgNumbers)) {
                return null;
            }
            QFBuilder qb = new QFBuilder();
            qb.add(CTRL_KEY_MODEL, "=", (Object)modelId);
            qb.add("mergernode", "=", (Object)Boolean.FALSE);
            qb.add("number", "in", (Object)orgNumbers.toArray());
            qb.add("view", "=", (Object)viewId);
            DynamicObjectCollection toRemove = QueryServiceHelper.query((String)"eb_viewmember", (String)"id, number, name", (QFilter[])qb.toArrays());
            toRemove.forEach(e -> orgNumbers.remove(e.getString("number")));
            if (CollectionUtils.isEmpty((Collection)orgNumbers)) {
                return null;
            }
            return new OffsetExecuteParam(Long.valueOf(modelId), Long.valueOf(bizModelId), datatype, version, beginPeriod.getDate("startDate"), endPeriod.getDate("endDate"), viewId, new ArrayList(orgNumbers));
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (paramList.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u5408\u5e76\u8303\u56f4\u4e2d\u65e0\u5408\u5e76\u8282\u70b9\u3002", (String)"OffsetExecutePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return paramList;
    }

    public void onProgress(ProgressEvent e) {
        String startProgress = this.getPageCache().get("startprogress");
        if (StringUtils.isEmpty((String)startProgress)) {
            return;
        }
        int progress = 0;
        String cacheProgress = this.getPageCache().get("progress");
        String text = ResManager.loadKDString((String)"\u6267\u884c\u4e2d", (String)"OffsetExecutePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((String)cacheProgress)) {
            progress = Integer.parseInt(cacheProgress);
        }
        if (progress >= 100) {
            text = ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210", (String)"OffsetExecutePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{CTRL_KEY_BARCANCEL});
            if (this.getPageCache().get("logEntryId") != null) {
                this.showForm();
            }
            if (this.getPageCache().get("msg") != null) {
                String status = this.getPageCache().get("status");
                if (OffsetExecuteStatusEnum.SUCCESS.getIndex().equals(status)) {
                    this.getView().showSuccessNotification(this.getPageCache().get("msg"));
                } else {
                    this.getView().showTipNotification(this.getPageCache().get("msg"));
                }
            }
            this.getView().hideLoading(false);
        }
        if (startProgress.equals("false")) {
            text = ResManager.loadKDString((String)"\u5df2\u53d6\u6d88\u6267\u884c", (String)"OffsetExecutePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        e.setProgress(progress);
        e.setText(text);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (key.equals(CTRL_KEY_MODEL)) {
            ArrayList qFilterList = ((BasedataEdit)this.getControl(CTRL_KEY_MODEL)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList(16);
            }
            qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        } else {
            ParameterF7Builder builder = new ParameterF7Builder("single");
            builder.setOpenAnalyseView(false).setForceDisableView(true);
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(key)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>(16);
            }
            qFilterList.add(new QFilter("model.id", "=", (Object)this.getModelId()));
            if (key.equals(CTRL_KEY_ORG)) {
                Long viewId;
                Object viewIdObj = this.getModel().getValue(CTRL_KEY_ORG_VIEW);
                if (viewIdObj == null) {
                    viewId = this.getOrgViewId();
                    this.getModel().setValue(CTRL_KEY_ORG_VIEW, (Object)viewId);
                } else {
                    viewId = ((DynamicObject)viewIdObj).getLong("id");
                }
                builder.setDefauteViewid(viewId);
                qFilterList.add(new QFilter("mergernode", "=", (Object)Boolean.TRUE));
            } else if (key.equals(CTRL_KEY_BEGINPEIOD) || key.equals(CTRL_KEY_ENDPEIOD) || key.equals(CTRL_KEY_VERSION) || key.equals(CTRL_KEY_DATATYPE)) {
                builder.setKeepTree(true);
                builder.setOnlyNeedLeaf(true);
            }
            builder.setqFilters(qFilterList);
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            if (!key.equals(CTRL_KEY_BUSMODEL)) {
                List qFilters;
                SingleTreeF7Parameter f7Parameter = (SingleTreeF7Parameter)builder.build();
                BasedataEdit basedataEdit = (BasedataEdit)e.getSource();
                String dimNumber = this.getCurrentDimNumber(basedataEdit.getKey());
                MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)this.getModelId(), (DynamicObject)NewF7Utils.getDimension((Long)this.getModelId(), (String)dimNumber), (String)ListSelectedRow.class.getName());
                f7Param.setBusModelId(this.getBusModelId());
                if (IDUtils.isNotNull((Long)f7Parameter.getViewId())) {
                    f7Param.setViewId(f7Parameter.getViewId());
                }
                if (CollectionUtils.isNotEmpty((Collection)f7Parameter.getDataSetIds())) {
                    f7Param.setDatasetIds(f7Parameter.getDataSetIds());
                }
                f7Param.setOnlySelLeaf(f7Parameter.isOnlyLeaf());
                f7Param.setShowVariable(f7Parameter.isNeedVar());
                f7Param.setVerifyPermission(f7Parameter.isCheckPerm());
                f7Param.setEnableView(f7Parameter.isForceDisableView());
                f7Param.setHideDecompose(!f7Parameter.isQueryDecompose());
                f7Param.setShowDebitAndCredit(f7Parameter.isShowDrcrdirect());
                if (f7Parameter.getOptionalNumber() != null && !f7Parameter.getOptionalNumber().isEmpty()) {
                    List members = f7Param.getModelCacheHelper().getMembers(f7Param.getDimensionNumber(), f7Param.getViewId(), (Collection)f7Parameter.getOptionalNumber());
                    f7Param.setSelectRangeIds(members.stream().filter(Objects::nonNull).map(BaseCache::getId).collect(Collectors.toSet()));
                }
                if (e.getFormShowParameter() instanceof ListShowParameter && CollectionUtils.isNotEmpty((Collection)(qFilters = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters()))) {
                    f7Param.addCustomCommFilter(qFilters);
                }
                if (key.equals(CTRL_KEY_ORG) || key.equals(CTRL_KEY_VERSION) || key.equals(CTRL_KEY_DATATYPE)) {
                    f7Param.setPermType(DimMembPermType.WRITE);
                }
                NewF7Utils.openF7((BeforeF7SelectEvent)e, (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "DIMF7_" + key));
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (evt.getReturnData() == null) {
            return;
        }
        String actionId = evt.getActionId();
        if (actionId.startsWith("DIMF7_")) {
            Long viewId;
            String key = actionId.replaceFirst("DIMF7_", "");
            ListSelectedRowCollection rows = (ListSelectedRowCollection)evt.getReturnData();
            ListSelectedRow selectedRow = rows.get(0);
            this.getModel().setValue(key, selectedRow.getPrimaryKeyValue());
            if (key.equals(CTRL_KEY_ORG) && (viewId = (Long)selectedRow.getDataMap().get("viewid")) != null) {
                this.getModel().setValue(CTRL_KEY_ORG_VIEW, (Object)viewId);
            }
        }
    }

    private Long getOrgViewId() {
        Long modelId = this.getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        return modelCache.getViewByBusModelAndDimNumber(this.getBusModelId(), SysDimensionEnum.Entity.getNumber());
    }

    public String getCurrentDimNumber(String controlKey) {
        switch (controlKey) {
            case "datatype": {
                return SysDimensionEnum.DataType.getNumber();
            }
            case "version": {
                return SysDimensionEnum.Version.getNumber();
            }
            case "org": {
                return SysDimensionEnum.Entity.getNumber();
            }
            case "beginperiod": 
            case "endperiod": {
                return SysDimensionEnum.BudgetPeriod.getNumber();
            }
        }
        return super.getCurrentDimNumber(controlKey);
    }

    @Override
    public Long getModelId() {
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (modelId != null) {
            return Long.parseLong(modelId);
        }
        return super.getModelId();
    }

    public Long getBusModelId() {
        String busModelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_BUSMODEL_ID");
        if (StringUtils.isNotEmpty((String)busModelId)) {
            return Long.valueOf(busModelId);
        }
        return 0L;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equals(CTRL_KEY_MODEL)) {
            Object ob = e.getChangeSet()[0].getNewValue();
            Long modelId = ob == null ? 0L : ((DynamicObject)ob).getLong("id");
            if (IDUtils.isNotNull((Long)modelId)) {
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
                this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
            }
        } else if (!e.getProperty().getName().equals(CTRL_KEY_DATATYPE) && e.getProperty().getName().equals(CTRL_KEY_ORG)) {
            this.getModel().setValue(CTRL_KEY_ORG_VIEW, (Object)this.getOrgViewId());
        }
    }

    static class OffsetExecuteThreadPool {
        OffsetExecuteThreadPool() {
        }

        private static ThreadPool createExecutorService(String poolName, int coreThread, int maxThread) {
            return ThreadPools.newCachedThreadPool((String)poolName, (int)coreThread, (int)maxThread);
        }
    }
}

