/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.combinoffset;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BaseDataColumnDependFieldSetEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.combinoffset.OffsetHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.OffsetEntryStatusEnum;
import kd.epm.eb.common.enums.OffsetExecuteStatusEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BgData;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.member.EntityServiceHelper;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.formplugin.combinoffset.OffsetEntryService;
import kd.epm.eb.formplugin.filterContainerModelListPlugin;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import kd.epm.eb.olap.api.metadata.IKDCell;
import org.apache.commons.collections4.CollectionUtils;

public class OffsetPaperPlugin
extends filterContainerModelListPlugin {
    private Log log = LogFactory.getLog(OffsetPaperPlugin.class);
    public static final String MODEL_COMBOITEMS = "MODEL_COMBOITEMS";
    private Long modelID = null;
    private List<ComboItem> model_comboItems;
    private static final List<String> modelFilterList = Arrays.asList("busmodel.id", "datatype.id", "version.id", "cslorg.id", "period.id", "currency.id", "offsetcatalog");

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"amount"});
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                Iterator iterator = rows.iterator();
                while (iterator.hasNext()) {
                    try {
                        DynamicObject row = (DynamicObject)iterator.next();
                        Object d = ((DynamicObject)row.get("entryentity.account")).get("drcrdirect");
                        if (d != null && "5".equals(d)) {
                            row.set("entryentity.amountd", row.get("entryentity.amount"));
                            row.set("entryentity.amountc", null);
                            continue;
                        }
                        if (d == null || !"6".equals(d)) continue;
                        row.set("entryentity.amountc", row.get("entryentity.amount"));
                        row.set("entryentity.amountd", null);
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                return rows;
            }
        });
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List listColumns = args.getListColumns();
        Map<String, String> fildMapped2Name = this.getFildMapped2Name();
        if (fildMapped2Name != null && !fildMapped2Name.isEmpty()) {
            listColumns.forEach(e -> {
                String key = e.getListFieldKey();
                if (key.startsWith("selfdim")) {
                    if (fildMapped2Name.containsKey(key)) {
                        e.setVisible(11);
                        e.setCaption(new LocaleString((String)fildMapped2Name.get(key)));
                    } else {
                        e.setVisible(0);
                    }
                }
            });
        } else {
            listColumns.forEach(e -> {
                if (e.getListFieldKey().startsWith("selfdim")) {
                    e.setVisible(0);
                }
            });
        }
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Set permissions = EntityServiceHelper.getOffsetEntityId((IModelCacheHelper)this.getIModelCacheHelper(), (Long)this.getBusModelId());
        if (permissions != null) {
            e.getQFilters().add(new QFilter("model.id", "=", (Object)this.getModelId()).and("cslorg", "in", (Object)permissions));
        } else {
            e.getQFilters().add(new QFilter("model.id", "=", (Object)this.getModelId()));
        }
        e.setOrderBy("modifytime,number,cslorg.number,period.number");
    }

    @Override
    protected String getModelIDFilterKey() {
        return "model.id";
    }

    @Override
    protected String getModelFilterKey() {
        return "model.name";
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (MessageBoxResult.Yes.getValue() == messageBoxClosedEvent.getResult().getValue()) {
            if ("deleteOffsetEntry".equals(messageBoxClosedEvent.getCallBackId())) {
                this.deleteOffsetEntry();
            } else if ("recalculate".equals(messageBoxClosedEvent.getCallBackId())) {
                this.recalculate();
            }
        }
    }

    private void recalculate() {
        Long busmodelId;
        Long modelId = IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"));
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"eb_offsetentry", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("busmodel", "=", (Object)(busmodelId = IDUtils.toLong((Object)this.getPageCache().get("KEY_BUSMODEL_ID"))))});
        if (dynamicObjectMap != null && !dynamicObjectMap.isEmpty()) {
            IModelCacheHelper modelCacheHelper;
            List bgdatas;
            Collection offsetEntryObjects = dynamicObjectMap.values();
            LinkedList<DynamicObject> repairedObjects = new LinkedList<DynamicObject>();
            for (DynamicObject dynamicObject : offsetEntryObjects) {
                DynamicObject offsetOrg;
                if (dynamicObject.getDynamicObject("offsetorg") != null || dynamicObject.getDynamicObject("cslorg") == null || (offsetOrg = BusinessDataServiceHelper.loadSingleFromCache((String)SysDimensionEnum.Entity.getMemberTreemodel(), (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("number", "=", (Object)(dynamicObject.getString("cslorg.number") + "offsetentry"))})) == null) continue;
                dynamicObject.set("offsetorg", (Object)offsetOrg);
                repairedObjects.add(dynamicObject);
            }
            if (repairedObjects.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])repairedObjects.toArray(new DynamicObject[0]));
            }
            if ((bgdatas = OffsetHelper.getBgDataFromOffsetEntryObjects(offsetEntryObjects, (IModelCacheHelper)(modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId)))) != null && bgdatas.size() > 0) {
                try {
                    Map<String, List<BgData>> stringBgDataMap = bgdatas.stream().collect(Collectors.groupingBy(e -> e.getDatasetId() + "," + (String)e.getMemberMap().get(SysDimensionEnum.Metric.getNumber())));
                    for (Map.Entry<String, List<BgData>> entry : stringBgDataMap.entrySet()) {
                        String[] keySplit = null;
                        if (entry.getKey() == null || entry.getValue() == null || (keySplit = entry.getKey().split(",")).length <= 1) continue;
                        Long dataSetId = IDUtils.toLong((Object)keySplit[0]);
                        String metricNumber = keySplit[1];
                        HashMap deleteRange = new HashMap(16);
                        deleteRange.put(SysDimensionEnum.Entity.getNumber(), entry.getValue().stream().map(e -> e.getMemberNumber(SysDimensionEnum.Entity.getNumber())).collect(Collectors.toSet()));
                        ShrekOlapServiceHelper.deleteData((Long)modelId, (Long)dataSetId, deleteRange, (String)metricNumber);
                    }
                }
                catch (Exception e2) {
                    this.log.error((Throwable)e2);
                }
            }
            String numberStr = offsetEntryObjects.stream().map(e -> e.getString("number")).collect(Collectors.joining(","));
            OffsetHelper.mergeBgdatasAndSaveToOlap((List)bgdatas, (IModelCacheHelper)modelCacheHelper, (String)numberStr);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u8ba1\u7b97\u6210\u529f\u3002", (String)"OffsetPaperPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (this.getPageCache().get("KEY_MODEL_ID") == null) {
            return;
        }
        String itemKey = evt.getItemKey();
        if ("execute".equals(itemKey)) {
            FormShowParameter param = new FormShowParameter();
            param.setFormId("eb_offsetexecute");
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "eb_offsetexecute_closecallback"));
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
            param.setCustomParam("KEY_BUSMODEL_ID", (Object)this.getPageCache().get("KEY_BUSMODEL_ID"));
            this.getView().showForm(param);
        } else if ("executelog".equals(itemKey)) {
            ListShowParameter param = new ListShowParameter();
            param.setFormId("bos_list");
            param.setBillFormId("eb_offsetexecutelog");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
            param.setCustomParam("KEY_BUSMODEL_ID", (Object)this.getPageCache().get("KEY_BUSMODEL_ID"));
            this.getView().showForm((FormShowParameter)param);
        } else if ("refresh".equals(itemKey)) {
            this.refreshBillList();
        } else if ("addnew".equals(itemKey)) {
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"eb_offsetentry", (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"))), new QFilter("busmodel", "=", (Object)IDUtils.toLong((Object)this.getPageCache().get("KEY_BUSMODEL_ID"))), new QFilter("creator", "=", (Object)UserUtils.getUserId()), new QFilter("status", "=", (Object)OffsetEntryStatusEnum.INPUT.getIndex())}, (String)"createtime desc");
            FormShowParameter param = new FormShowParameter();
            param.setFormId("eb_offsetentry_addnew");
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "eb_offsetentry_addnew_closecallback"));
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            if (dynamicObjectMap != null && !dynamicObjectMap.isEmpty()) {
                param.setCustomParam("id", (Object)((DynamicObject)dynamicObjectMap.entrySet().iterator().next().getValue()).getString("id"));
                param.setCustomParam("copytag", (Object)"1");
            } else {
                param.setCustomParams((Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("filter"), Map.class));
            }
            this.getView().showForm(param);
        } else if ("modify".equals(itemKey)) {
            BillList bl = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = bl.getSelectedRows();
            if (selectedRows == null || selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u4fee\u6539\u7684\u6570\u636e\u3002", (String)"OffsetPaperPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectedRows.getPrimaryKeyValues().length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u7ec4\u6570\u636e\u8fdb\u884c\u4fee\u6539\u3002", (String)"OffsetPaperPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)selectedRows.get(0).getPrimaryKeyValue(), (String)"eb_offsetentry", (String)"status");
            if (object == null) {
                return;
            }
            if (OffsetEntryStatusEnum.SYSGEN.getIndex().equals(object.getString("status"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4fee\u6539\u7cfb\u7edf\u751f\u6210\u6570\u636e\u3002", (String)"OffsetPaperPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter param = new FormShowParameter();
            param.setFormId("eb_offsetentry_addnew");
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "eb_offsetentry_addnew_closecallback"));
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setCaption(ResManager.loadKDString((String)"\u62b5\u9500\u5206\u5f55\u2014\u7f16\u8f91", (String)"OffsetPaperPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            param.setCustomParam("id", (Object)selectedRows.getPrimaryKeyValues()[0].toString());
            param.setCustomParam("model", (Object)this.getPageCache().get("KEY_MODEL_ID"));
            this.getView().showForm(param);
        } else if ("delete".equals(itemKey)) {
            BillList bl = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = bl.getSelectedRows();
            if (selectedRows == null || selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"OffsetPaperPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u9009\u62e9\u7684\u8bb0\u5f55\uff1f", (String)"OffsetPaperPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteOffsetEntry", (IFormPlugin)this));
        } else if ("btn_copy".equals(itemKey)) {
            BillList bl = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = bl.getSelectedRows();
            if (selectedRows == null || selectedRows.getPrimaryKeyValues().length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"OffsetPaperPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)selectedRows.get(0).getPrimaryKeyValue(), (String)"eb_offsetentry", (String)"status");
            if (object == null) {
                return;
            }
            FormShowParameter param = new FormShowParameter();
            param.setFormId("eb_offsetentry_addnew");
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "eb_offsetentry_addnew_closecallback"));
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setCustomParam("id", (Object)selectedRows.getPrimaryKeyValues()[0].toString());
            param.setCustomParam("copytag", (Object)"1");
            this.getView().showForm(param);
        } else if ("recalculate".equals(itemKey)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u6839\u636e\u5f53\u524d\u62b5\u9500\u5206\u5f55\u91cd\u65b0\u8ba1\u7b97\u62b5\u9500\u6570\u636e\uff1f", (String)"OffsetPaperPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("recalculate"));
        }
    }

    private void deleteOffsetEntry() {
        BillList bl = (BillList)this.getControl("billlistap");
        Map datas = BusinessDataServiceHelper.loadFromCache((String)"eb_offsetentry", (String)"id,status,busmodel", (QFilter[])new QFilter("id", "in", (Object)bl.getSelectedRows().getPrimaryKeyValues()).toArray());
        if (datas.size() > 0) {
            List<DynamicObject> obs = datas.values().stream().filter(d -> OffsetEntryStatusEnum.INPUT.getIndex().equals(d.getString("status"))).collect(Collectors.toList());
            if (obs.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u624b\u5de5\u5f55\u5165\u7684\u62b5\u9500\u5206\u5f55\u8fdb\u884c\u5220\u9664\u3002", (String)"OffsetPaperPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean skip = false;
            if (obs.size() < datas.size()) {
                skip = true;
            }
            try (TXHandle tx = TX.requiresNew((String)"deleteOffset");){
                try {
                    String tip = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"OffsetPaperPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    if (skip) {
                        tip = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f,\u5df2\u7ecf\u8fc7\u6ee4\u975e\u624b\u5de5\u5f55\u5165\u7684\u62b5\u9500\u5206\u5f55\u3002", (String)"OffsetPaperPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    }
                    OffsetEntryService service = OffsetEntryService.getInstance();
                    ArrayList<Map<String, String>> lists = new ArrayList<Map<String, String>>(10);
                    IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
                    ArrayList ids = new ArrayList(obs.size());
                    obs.forEach(d -> {
                        lists.addAll(service.convertOlapData(d.getLong("id"), orCreate));
                        ids.add(d.getLong("id"));
                    });
                    Map<Long, List<IKDCell>> originalData = service.handleOlapData(lists, orCreate, false);
                    DeleteServiceHelper.delete((IDataEntityType)bl.getEntityType(), (Object[])ids.toArray());
                    service.saveOlap(lists, orCreate, originalData, "deleteOffsetEntry");
                    this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "OffsetPaperPlugin_5", "epm-eb-formplugin"), new MultiLangEnumBridge("\u62b5\u9500\u5206\u5f55\u5220\u9664\u6210\u529f\u3002", "OffsetPaperPlugin_6", "epm-eb-formplugin"));
                    this.getView().showSuccessNotification(tip);
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw new KDBizException((Throwable)e, new ErrorCode("delete", e.getMessage()), new Object[0]);
                }
            }
            this.refreshBillList();
        }
    }

    protected void refreshBillList() {
        BillList bl = (BillList)this.getControl("billlistap");
        bl.refresh();
        bl.clearEntryState();
        bl.clearSelection();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getActionId().equals("eb_offsetexecute_closecallback")) {
            Map backData = (Map)e.getReturnData();
            if (backData != null && OffsetExecuteStatusEnum.SUCCESS.getIndex().equals(backData.get("status")) && !StringUtils.isEmpty((String)((String)backData.get("msg")))) {
                this.getView().showMessage((String)backData.get("msg"));
            }
            this.refreshBillList();
        } else if (e.getActionId().equals("eb_offsetentry_addnew_closecallback")) {
            this.refreshBillList();
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        String selectModelFilterId;
        List commonFilterColumns = args.getCommonFilterColumns();
        List filterCol = commonFilterColumns.stream().filter(e -> e.getFieldName().equals("model.name")).collect(Collectors.toList());
        List busfilterCol = commonFilterColumns.stream().filter(e -> e.getFieldName().equals("busmodel.name")).collect(Collectors.toList());
        CommonFilterColumn cfc = (CommonFilterColumn)filterCol.get(0);
        CommonFilterColumn buscfc = (CommonFilterColumn)busfilterCol.get(0);
        ControlFilters filters = cfc.getContext().getControlFilters();
        if (filters != null && filters.getFilter("model.id") != null && filters.getFilter("model.id").size() > 0 && !"".equals(selectModelFilterId = filters.getFilter("model.id").get(0).toString())) {
            this.getPageCache().put("KEY_MODEL_ID", selectModelFilterId);
        }
        if (this.getPageCache().get(MODEL_COMBOITEMS) != null) {
            this.model_comboItems = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(MODEL_COMBOITEMS));
        } else {
            ArrayList modelQFilters = new ArrayList(16);
            modelQFilters.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
            DynamicObjectCollection col = QueryServiceHelper.query((String)"model", (String)"epm_model", (String)"id,name", (QFilter[])modelQFilters.toArray(new QFilter[0]), null);
            cfc.getComboItems().clear();
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
            col.forEach(e -> comboItems.add(new ComboItem(new LocaleString(e.getString("name")), e.getString("id"))));
            this.model_comboItems = comboItems;
            this.getPageCache().put(MODEL_COMBOITEMS, ObjectSerialUtil.toByteSerialized(this.model_comboItems));
        }
        if (this.model_comboItems != null && !this.model_comboItems.isEmpty()) {
            cfc.setComboItems(this.model_comboItems);
            cfc.setDefaultValue(this.model_comboItems.get(0).getValue());
            if (this.getPageCache().get("KEY_MODEL_ID") == null) {
                Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
                if (IDUtils.isNotNull((Long)modelId)) {
                    cfc.setDefaultValue(modelId.toString());
                    this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
                } else {
                    this.getPageCache().put("KEY_MODEL_ID", this.model_comboItems.get(0).getValue());
                }
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u4efb\u4f55\u4f53\u7cfb\u3002", (String)"OffsetPaperPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.modelID = IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"));
        if (this.modelID != 0L) {
            Model model = ModelCacheContext.getOrCreate((Long)this.modelID).getModelobj();
            Map dims = model.getDimensions();
            HashMap dimNum2Combitems = new HashMap(16);
            dims.values().forEach(d -> {
                String dimNumber = d.getNumber();
                if (SysDimensionEnum.BudgetPeriod.getNumber().equals(d.getNumber())) {
                    dimNumber = "period";
                }
                String dimNum = dimNumber + ".name";
                List mems = d.getAllMembers();
                ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
                mems.forEach(m -> {
                    if (!dimNum.equals("Entity.name") && m.isLeaf()) {
                        comboItems.add(new ComboItem(new LocaleString(m.getName()), m.getId().toString()));
                    }
                });
                if (dimNum.equals("Entity.name")) {
                    Long modelId = Long.valueOf(this.getPageCache().get("KEY_MODEL_ID"));
                    List<DynamicObject> list = this.queryEntityMember(modelId);
                    for (DynamicObject dynamicObject : list) {
                        comboItems.add(new ComboItem(new LocaleString(dynamicObject.getString("name")), dynamicObject.get("id").toString()));
                    }
                    dimNum2Combitems.put("cslorg.name", comboItems);
                } else {
                    dimNum2Combitems.put(dimNum.toLowerCase(), comboItems);
                }
            });
            DynamicObjectCollection busmodels = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id, name, number", (QFilter[])new QFilter[]{new QFilter("model.id", "=", (Object)this.modelID)});
            ArrayList busmodel_comboItems = new ArrayList(16);
            dimNum2Combitems.put("busmodel.name", busmodel_comboItems);
            busmodels.forEach(dynamicObject -> busmodel_comboItems.add(new ComboItem(new LocaleString(dynamicObject.getString("name")), dynamicObject.getString("id"))));
            if (!busmodel_comboItems.isEmpty()) {
                String busmodelid = this.getPageCache().get("filterContainerSearchClickKEY_BUSMODEL_ID");
                if (StringUtils.isEmpty((String)busmodelid)) {
                    busmodelid = ((ComboItem)busmodel_comboItems.get(0)).getValue();
                }
                buscfc.setDefaultValue(busmodelid);
                this.getPageCache().put("KEY_BUSMODEL_ID", busmodelid);
            }
            commonFilterColumns.forEach(e -> {
                if (e instanceof CommonFilterColumn && dimNum2Combitems.containsKey(e.getFieldName())) {
                    ((CommonFilterColumn)e).setComboItems((List)dimNum2Combitems.get(e.getFieldName()));
                }
            });
        }
        this.getPageCache().put("filter", SerializationUtils.toJsonString(this.getQfilterProperty(filters)));
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (!"model.id".equals(fieldName)) {
            ArrayList<QFilter> qFilters = args.getQfilters();
            if (qFilters == null) {
                qFilters = new ArrayList<QFilter>(16);
                args.setQfilters(qFilters);
            }
            qFilters.add(new QFilter("model.id", "=", (Object)IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"))));
            switch (fieldName) {
                case "period.id": {
                    qFilters.add(new QFilter("isLeaf", "=", (Object)Boolean.TRUE));
                    break;
                }
                case "cslorg.id": {
                    Map dimViews = this.getIModelCacheHelper().getViewsByBusModel(this.getBusModelId());
                    Long viewId = null;
                    if (dimViews != null) {
                        viewId = (Long)dimViews.get(SysDimensionEnum.Entity.getNumber());
                    }
                    QFilter filter1 = new QFilter("number", "!=", (Object)"RatePreset");
                    if (DimensionViewServiceHelper.getInstance().isBaseView(viewId)) {
                        filter1.and("mergernode", "=", (Object)true);
                    } else {
                        DynamicObjectCollection clsOrgs = QueryServiceHelper.query((String)"eb_viewmember", (String)"id, number, name", (QFilter[])new QFilter[]{new QFilter("model.id", "=", (Object)this.getModelId()), new QFilter("mergernode", "=", (Object)Boolean.TRUE), new QFilter("view", "=", (Object)viewId)});
                        filter1.and(new QFilter("number", "in", clsOrgs.stream().map(d -> d.getString("number")).collect(Collectors.toSet())));
                    }
                    qFilters.add(filter1);
                    break;
                }
                case "datatype.id": {
                    QFilter dataTypeFilter = new QFilter("number", "!=", (Object)"DataType");
                    qFilters.add(dataTypeFilter);
                    break;
                }
                case "currency.id": {
                    QFilter currentFilter = new QFilter("number", "!=", (Object)"Currency");
                    qFilters.add(currentFilter);
                }
                case "version.id": {
                    QFilter versionFilter = new QFilter("number", "!=", (Object)"Version");
                    qFilters.add(versionFilter);
                }
            }
            if (!this.checkSelectedIsCurModel(args.getRefEntityId(), qFilters, args.getSelectedIds()).booleanValue()) {
                args.setSelectedIds(new Object[0]);
            }
        }
    }

    private Boolean checkSelectedIsCurModel(String entityId, List<QFilter> qFilters, Object[] selectedIds) {
        if (selectedIds != null) {
            QFBuilder qFilter = new QFBuilder("id", "in", (Object)IDUtils.toLongs((Object[])selectedIds));
            qFilter.add(qFilters);
            return QueryServiceHelper.exists((String)entityId, (QFilter[])qFilter.toArrays());
        }
        return false;
    }

    private List<DynamicObject> queryEntityMember(Long modelId) {
        String entityName = "epm_entitymembertree";
        String selectField = "id,number,name,parent,mergernode,dseq,isleaf,level";
        QFilter filter1 = new QFilter("model", "=", (Object)modelId);
        QFilter filter2 = new QFilter("mergernode", "=", (Object)true);
        QFilter filter3 = new QFilter("number", "!=", (Object)"RatePreset");
        QFilter[] filters = new QFilter[]{filter1, filter2, filter3};
        return QueryServiceHelper.query((String)entityName, (String)selectField, (QFilter[])filters);
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter != null) {
            if ("model.id".equals(((List)currentCommonFilter.get("FieldName")).get(0))) {
                this.getPageCache().put("KEY_MODEL_ID", String.valueOf(((List)currentCommonFilter.get("Value")).get(0)));
                this.modelChange();
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)IDUtils.toLong(((List)currentCommonFilter.get("Value")).get(0)));
            } else if ("busmodel.id".equals(((List)currentCommonFilter.get("FieldName")).get(0))) {
                this.getPageCache().put("KEY_BUSMODEL_ID", String.valueOf(((List)currentCommonFilter.get("Value")).get(0)));
                this.getPageCache().put("filterContainerSearchClickKEY_BUSMODEL_ID", String.valueOf(((List)currentCommonFilter.get("Value")).get(0)));
                this.modelChange();
            }
        }
        this.dealSchemeSearchMem(args);
    }

    @Override
    protected Map<String, List<String>> getResetContainerFilterMap() {
        HashMap<String, List<String>> resetContainerFilterMap = new HashMap<String, List<String>>(16);
        resetContainerFilterMap.put("model.id", modelFilterList);
        return resetContainerFilterMap;
    }

    public void baseDataColumnDependFieldSet(BaseDataColumnDependFieldSetEvent args) {
        super.baseDataColumnDependFieldSet(args);
    }

    public void modelChange() {
        this.modelID = IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"));
        if (this.modelID != null && this.modelID != 0L) {
            this.getPageCache().put("fildMapped2Name", null);
        }
    }

    public Map<String, String> getFildMapped2Name() {
        if (this.getPageCache().get("fildMapped2Name") != null) {
            Map fildMapped2Name = (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("fildMapped2Name"));
            return fildMapped2Name;
        }
        HashMap<String, String> fildMapped2Name = new HashMap<String, String>();
        HashMap<String, String> fildMapped2Number = new HashMap<String, String>();
        HashMap<String, String> fildMapped2ShortNumber = new HashMap<String, String>();
        Long busmodel = IDUtils.toLong((Object)this.getPageCache().get("KEY_BUSMODEL_ID"));
        List assistDims = OffsetHelper.getAssistDims((Long)this.getModelId(), (Long)busmodel);
        if (assistDims != null && !assistDims.isEmpty()) {
            Long model = IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"));
            QFilter modelFilter = new QFilter("model", "=", (Object)model);
            QFilter numberFilter = new QFilter("number", "in", (Object)assistDims.toArray());
            QFilter[] udqf = new QFilter[]{modelFilter, numberFilter};
            DynamicObjectCollection dims = QueryServiceHelper.query((String)"epm_dimension", (String)"id, number, shortnumber, name, fieldmapped, issysdimension", (QFilter[])udqf, (String)"dseq");
            int i = 1;
            for (DynamicObject d : dims) {
                if (d.getBoolean("issysdimension")) continue;
                fildMapped2Name.put("selfdim" + i + ".name", d.getString("name"));
                fildMapped2Number.put("selfdim" + i + ".number", d.getString("number"));
                fildMapped2ShortNumber.put("selfdim" + i + ".shortnumber", d.getString("shortnumber"));
                ++i;
            }
        }
        this.getPageCache().put("fildMapped2Name", ObjectSerialUtil.toByteSerialized(fildMapped2Name));
        this.getPageCache().put("fildMapped2Number", ObjectSerialUtil.toByteSerialized(fildMapped2Number));
        this.getPageCache().put("fildMapped2ShortNumber", ObjectSerialUtil.toByteSerialized(fildMapped2ShortNumber));
        return fildMapped2Name;
    }

    private Map<String, Object> getQfilterProperty(ControlFilters filters) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        String model = this.getPageCache().get("KEY_MODEL_ID");
        map.put("model", model);
        map.put("datatype", "");
        map.put("version", "");
        if (filters != null) {
            if (filters.getFilter("version.id") != null && filters.getFilter("version.id").size() > 0) {
                map.put("version", filters.getFilter("version.id").get(0));
            }
            if (filters.getFilter("datatype.id") != null && filters.getFilter("datatype.id").size() > 0) {
                map.put("datatype", filters.getFilter("datatype.id").get(0));
            }
        }
        return map;
    }

    @Override
    public Long getModelId() {
        String strModelId = this.getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isNotEmpty((String)strModelId)) {
            return Long.valueOf(strModelId);
        }
        return 0L;
    }

    public Long getBusModelId() {
        String strBusModelId = this.getPageCache().get("KEY_BUSMODEL_ID");
        if (StringUtils.isNotEmpty((String)strBusModelId)) {
            return Long.valueOf(strBusModelId);
        }
        return 0L;
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
            args.setCancel(true);
            return;
        }
        super.billListHyperLinkClick(args);
        BillList bl = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = bl.getSelectedRows();
        FormShowParameter param = new FormShowParameter();
        param.setFormId("eb_offsetentry_addnew");
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "eb_offsetentry_addnew_closecallback"));
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCaption(ResManager.loadKDString((String)"\u62b5\u9500\u5206\u5f55\u2014\u67e5\u770b", (String)"OffsetPaperPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        param.setCustomParam("id", (Object)selectedRows.getPrimaryKeyValues()[0].toString());
        param.setCustomParam("model", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        param.setCustomParam("review", (Object)"1");
        this.getView().showForm(param);
        args.setCancel(true);
    }

    private void dealSchemeSearchMem(FilterContainerSearchClickArgs args) {
        List schemeFilter = (List)args.getFilterValues().get("schemefilter");
        if (CollectionUtils.isEmpty((Collection)schemeFilter)) {
            return;
        }
        for (Map map : schemeFilter) {
            Object FieldName = ((List)map.get("FieldName")).get(0);
            List ids = (List)map.get("Id");
            if (CollectionUtils.isEmpty((Collection)ids)) continue;
            String id = String.valueOf(ids.get(0));
            if ("model.name".equals(FieldName)) {
                this.getPageCache().put("KEY_MODEL_ID", id);
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)IDUtils.toLong((Object)id));
            } else if ("busmodel.name".equals(FieldName)) {
                this.getPageCache().put("KEY_BUSMODEL_ID", String.valueOf(id));
                this.getPageCache().put("filterContainerSearchClickKEY_BUSMODEL_ID", String.valueOf(id));
            }
            this.modelChange();
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        AdminModelUtil.checkAdminModeBeforeItemClick(evt, this.getModelId(), this.getView(), Sets.newHashSet((Object[])new String[]{"close"}));
    }
}

