/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.combinoffset;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;

public class OffsetRuleCatalogEditPlugin
extends AbstractBasePlugIn {
    private static final String ASSISTDIM = "assistdim";
    private static final String DIM_PREFIX = "selfdim";
    private DynamicObject[] dynamicObjects = null;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Object objModel = map.get("model");
        Object objParent = map.get("parent");
        Object busModel = map.get("busmodel");
        this.getModel().setValue("model", objModel);
        if (!"0".equals(objParent)) {
            this.getModel().setValue("parent", objParent);
            this.getModel().setValue("busmodel", busModel);
            if (objModel == null || objParent == null || busModel == null) {
                return;
            }
            int seq = this.getCurNodeSequence(map.get("model").toString(), map.get("parent").toString());
            this.getModel().setValue("sequence", (Object)seq);
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ASSISTDIM});
    }

    public void afterLoadData(EventObject e) {
        Object assistdim = this.getModel().getValue(ASSISTDIM);
        if (assistdim != null) {
            this.getPageCache().put("oldAssistdim", String.valueOf(assistdim));
        }
        this.getView().getFormShowParameter().getStatus();
        boolean ispreset = (Boolean)this.getModel().getValue("ispreset");
        Integer level = (Integer)this.getModel().getValue("level");
        if (ispreset) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "name", "parent"});
        }
        if (level != null && level != 2) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ASSISTDIM});
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "parent"});
        Map map = this.getView().getFormShowParameter().getCustomParams();
        this.initAssistdim(map);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        if (e.getSource() instanceof Save) {
            String assistdim = (String)this.getModel().getValue(ASSISTDIM);
            String sortedassistdim = this.getPageCache().get(ASSISTDIM);
            List sorteddims = null;
            ArrayList<String> selectedDims = new ArrayList<String>(16);
            if (sortedassistdim != null) {
                sorteddims = (List)SerializationUtils.fromJsonString((String)sortedassistdim, List.class);
                if (assistdim != null) {
                    String[] assdimSplit = assistdim.split(",");
                    ArrayList<String> dims = new ArrayList<String>(16);
                    for (String d : assdimSplit) {
                        if (!StringUtils.isNotEmpty((String)d)) continue;
                        dims.add(d);
                    }
                    if (dims.size() > 6) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8bbe\u7f6e\u8f85\u52a9\u7ef4\u5ea6\u6570\u91cf\u4e0a\u9650\u4e3a6\u3002", (String)"OffsetRuleCatalogEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    StringBuilder sb = new StringBuilder();
                    for (String item : sorteddims) {
                        if (!dims.contains(item)) continue;
                        sb.append(item).append(",");
                        selectedDims.add(item);
                    }
                    if (sb.indexOf(",") > 0) {
                        sb.deleteCharAt(sb.lastIndexOf(","));
                    }
                    this.getModel().setValue(ASSISTDIM, (Object)sb.toString());
                }
            }
            String oldAssistdim = this.getPageCache().get("oldAssistdim");
            String shortNumberMapStr = this.getPageCache().get("shortNumberMap");
            Map<Object, DynamicObject> offsetEntries = this.checkExistOffsetEntry();
            if (offsetEntries != null && offsetEntries.size() > 0) {
                if (StringUtils.isNotEmpty((String)oldAssistdim) && assistdim == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u6a21\u578b\u4e0b\u5df2\u4ea7\u751f\u62b5\u9500\u5206\u5f55\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u4e4b\u524d\u5df2\u6dfb\u52a0\u7684\u62b5\u9500\u8f85\u52a9\u7ef4\u5ea6\u3002", (String)"OffsetRuleCatalogEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                if (assistdim != null) {
                    String[] stringArray;
                    if (StringUtils.isEmpty((String)oldAssistdim)) {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = "";
                    } else {
                        stringArray = oldAssistdim.split(",");
                    }
                    String[] oldAssdimSplit = stringArray;
                    int index = 1;
                    HashMap<String, String> oldDimNumberMap = new HashMap<String, String>(16);
                    HashMap<String, Long> noneMemberIDs = new HashMap<String, Long>(16);
                    IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
                    for (String dimNumber : oldAssdimSplit) {
                        if (!StringUtils.isNotEmpty((String)dimNumber)) continue;
                        if (!assistdim.contains(dimNumber)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u6a21\u578b\u4e0b\u5df2\u4ea7\u751f\u62b5\u9500\u5206\u5f55\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u4e4b\u524d\u5df2\u6dfb\u52a0\u7684\u62b5\u9500\u8f85\u52a9\u7ef4\u5ea6\u3002", (String)"OffsetRuleCatalogEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        }
                        oldDimNumberMap.put(dimNumber, DIM_PREFIX + index++);
                    }
                    if (sorteddims != null) {
                        index = 1;
                        Map shortNumberMap = shortNumberMapStr == null ? new HashMap(16) : (Map)SerializationUtils.fromJsonString((String)shortNumberMapStr, Map.class);
                        for (String dimNumber : sorteddims) {
                            Member noneMember = modelCacheHelper.getMember(dimNumber, null, (String)shortNumberMap.get(dimNumber) + "None");
                            if (noneMember == null) continue;
                            noneMemberIDs.put(dimNumber, noneMember.getId());
                        }
                    }
                    HashMap<Object, Long[]> sortedIDS = new HashMap<Object, Long[]>(offsetEntries.size());
                    for (Map.Entry<Object, DynamicObject> entry : offsetEntries.entrySet()) {
                        Long[] ids = new Long[selectedDims.size()];
                        for (int i = 0; i < selectedDims.size(); ++i) {
                            String dimNumber = (String)selectedDims.get(i);
                            if (!oldDimNumberMap.containsKey(dimNumber)) {
                                ids[i] = (Long)noneMemberIDs.get(dimNumber);
                                continue;
                            }
                            DynamicObject dynamicObject = null;
                            dynamicObject = entry.getValue().getDynamicObject((String)oldDimNumberMap.get(dimNumber));
                            if (dynamicObject == null) continue;
                            ids[i] = dynamicObject.getLong("id");
                        }
                        sortedIDS.put(entry.getKey(), ids);
                    }
                    for (Map.Entry<Object, DynamicObject> entry : offsetEntries.entrySet()) {
                        DynamicObject dynamicObject = entry.getValue();
                        Long[] ids = (Long[])sortedIDS.get(entry.getKey());
                        if (ids == null) continue;
                        for (int i = 0; i < ids.length; ++i) {
                            dynamicObject.set(DIM_PREFIX + (i + 1), (Object)ids[i]);
                        }
                    }
                    this.dynamicObjects = offsetEntries.values().toArray(new DynamicObject[0]);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean issuccess = e.getOperationResult().getValidateResult().isSuccess();
        List ids = e.getOperationResult().getSuccessPkIds();
        if (e.getSource() instanceof Save && issuccess) {
            if (this.dynamicObjects != null) {
                SaveServiceHelper.save((DynamicObject[])this.dynamicObjects);
            }
            this.getView().returnDataToParent((Object)ids);
            this.getView().close();
        }
    }

    private int getCurNodeSequence(String modelId, String parentId) {
        QFilter model = new QFilter("model", "=", (Object)Long.valueOf(modelId));
        QFilter parent = new QFilter("parent", "=", (Object)Long.valueOf(parentId));
        QFilter[] filters = new QFilter[]{model, parent};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"eb_offsetrulecatalog", (String)"sequence", (QFilter[])filters, (String)"sequence desc");
        if (dcs != null && dcs.size() > 0) {
            DynamicObject dyMaxSeq = (DynamicObject)dcs.iterator().next();
            String strSeq = dyMaxSeq.getString("sequence");
            return (strSeq.isEmpty() ? 0 : Integer.parseInt(strSeq)) + 1;
        }
        return 1;
    }

    protected void initAssistdim(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"eb_businessmodel", (String)"id, name, number, viewentry.dimension.number,viewentry.dimension.name,viewentry.dimension.shortnumber", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)Long.valueOf(map.get("model").toString())), new QFilter("number", "=", map.get("number")), new QFilter("viewentry.dimension.issysdimension", "=", (Object)"0")}, (String)"viewentry.dimension.dseq");
        if (ds.isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ASSISTDIM});
            return;
        }
        if (ds != null) {
            Row row = null;
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
            ArrayList<String> assistdim = new ArrayList<String>(16);
            HashMap<String, String> shortNumberMap = new HashMap<String, String>(16);
            ComboItem item = null;
            while (ds.hasNext()) {
                row = ds.next();
                item = new ComboItem(new LocaleString(row.getString("viewentry.dimension.name")), row.getString("viewentry.dimension.number"));
                items.add(item);
                assistdim.add(item.getValue());
                shortNumberMap.put(row.getString("viewentry.dimension.number"), row.getString("viewentry.dimension.shortnumber"));
            }
            MulComboEdit control = (MulComboEdit)this.getControl(ASSISTDIM);
            control.setComboItems(items);
            this.getPageCache().put(ASSISTDIM, SerializationUtils.toJsonString(assistdim));
            this.getPageCache().put("shortNumberMap", SerializationUtils.toJsonString(shortNumberMap));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    private Map<Object, DynamicObject> checkExistOffsetEntry() {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        return BusinessDataServiceHelper.loadFromCache((String)"eb_offsetentry", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)Long.valueOf(map.get("model").toString())), new QFilter("busmodel.number", "=", map.get("number"))});
    }

    private Long getModelId() {
        return IDUtils.toLong(this.getView().getFormShowParameter().getCustomParams().get("model"));
    }
}

