/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.combinoffset;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.combinoffset.OffsetRule;
import kd.epm.eb.business.utils.EPMTreeUtils;
import kd.epm.eb.common.enums.OffsetCatalogEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;

public class OffsetRuleListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final String CTRL_KEY_CATALOGTREE = "catalogtree";
    private static final String CTRL_KEY_MODEL = "modelbd";
    private static final String ADD_CATALOG_CLOSECALLBACK = "ADD_CATALOG_CLOSECALLBACK";
    private static final String ADD_OFFSETRULE_CLOSECALLBACK = "ADD_OFFSETRULE_CLOSECALLBACK";
    private static final String BILLLISTAP = "billlistap";
    private static final String FOCUSNODEID = "focusnodeid";
    private static final String HEADNODEID = "headnodeid";
    private static final String KEY_SUB_MAIN_TAB = "_submaintab_";
    public static final String KEY_MODEL_ID = "KEY_MODEL_ID";
    public static final String EB_OFFSETRULECATALOG = "eb_offsetrulecatalog";
    public static final String EB_OFFSETRULE = "eb_offsetrule";
    public static final String EB_OFFSETRULESETTING = "eb_offsetrulesetting";
    public static final String OFFSETRULE_CATALOG_ID = "OFFSETRULE_CATALOG_ID";
    public static final String OFFSETRULESETTING_CLOSECALLBACK = "OFFSETRULESETTING_CLOSECALLBACK";
    public static final String OFFSETRYLE_EDIT = "offsetRule_edit";
    public static final String OFFSETRULE_INFO = "OFFSETRULE_INFO";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.setBillFormId(EB_OFFSETRULE);
        billList.setOrderBy("modifytime");
        this.addListeners();
    }

    protected void addListeners() {
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit modelBaseDate = (BasedataEdit)this.getView().getControl(CTRL_KEY_MODEL);
        modelBaseDate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"btn_addnewcatalog", "btn_modifycatalog", "btn_deletecatalog", "btn_up", "btn_down"});
        TreeView tview = (TreeView)this.getControl(CTRL_KEY_CATALOGTREE);
        tview.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                OffsetRuleListPlugin.this.getPageCache().put(OffsetRuleListPlugin.FOCUSNODEID, evt.getNodeId().toString());
                OffsetRuleListPlugin.this.refreshBillList();
            }
        });
        final BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addPagerClickListener(new PagerClickListener(){

            public void pagerClick(PagerClickEvent pagerClickEvent) {
                if (!OffsetRuleListPlugin.this.validateModel()) {
                    return;
                }
                OffsetRuleListPlugin.this.refreshBillList();
            }
        });
        billList.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent setFilterEvent) {
                QFilter qFilter1 = OffsetRuleListPlugin.this.getqFilter();
                if (qFilter1 == null) {
                    qFilter1 = new QFilter("model", "=", (Object)OffsetRuleListPlugin.this.getModelId());
                }
                setFilterEvent.getQFilters().add(qFilter1);
            }
        });
        billList.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent e) {
                OffsetRuleListPlugin.super.hyperLinkClick(e);
                long id = (Long)billList.getFocusRowPkId();
                OffsetRuleListPlugin.this.hyperLink(e, String.valueOf(id));
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam(KEY_MODEL_ID));
        if (IDUtils.isNull((Long)modelId)) {
            modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)CTRL_KEY_MODEL, (boolean)false);
        } else {
            UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
        }
        if (IDUtils.isNull((Long)modelId)) {
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            billList.setFilter(new QFilter("1", "!=", (Object)1));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4efb\u4f55\u4f53\u7cfb\uff0c\u8bf7\u5148\u65b0\u589e\u4f53\u7cfb\u3002", (String)"OffsetRuleListPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(CTRL_KEY_MODEL, (Object)modelId);
        this.modelChange(modelId);
        if ("true".equals(this.getPageCache().get("needRefreshTree"))) {
            this.refreshTree();
            this.getPageCache().put("needRefreshTree", "false");
        }
    }

    protected boolean validateModel() {
        if (StringUtils.isEmpty((String)this.getPageCache().get(KEY_MODEL_ID))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4efb\u4f55\u4f53\u7cfb\uff0c\u8bf7\u5148\u65b0\u589e\u4f53\u7cfb\u3002", (String)"OffsetRuleListPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void refreshBillList() {
        QFilter qFilter1 = this.getqFilter();
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.setFilter(qFilter1);
        billList.setClearSelection(true);
        billList.refresh();
    }

    protected QFilter getqFilter() {
        if (StringUtils.isNotEmpty((String)this.getPageCache().get(FOCUSNODEID))) {
            Long nodeid = Long.parseLong(this.getPageCache().get(FOCUSNODEID));
            boolean isallchild = Boolean.parseBoolean(this.getModel().getValue("treecheckbox").toString());
            QFilter qFilter1 = new QFilter("offsetrulecatalog", "=", (Object)nodeid);
            QFilter qFilter2 = null;
            if (isallchild) {
                List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("treelist"), List.class);
                ArrayList<Long> list = new ArrayList<Long>(16);
                this.queryAllChildNodeList(nodeid, treeList, list);
                if (list.size() > 0) {
                    qFilter2 = new QFilter("offsetrulecatalog", "in", list);
                }
            }
            qFilter1 = qFilter2 == null ? qFilter1 : qFilter1.or(qFilter2);
            return qFilter1;
        }
        return null;
    }

    private List<Long> queryAllChildNodeList(Long nodeid, List<Map<String, String>> treeList, List<Long> allnodelist) {
        for (Map<String, String> m : treeList) {
            if (m.get("parentid") == null || !m.get("parentid").equals(nodeid.toString())) continue;
            allnodelist.add(Long.valueOf(m.get("id")));
            this.queryAllChildNodeList(Long.valueOf(m.get("id")), treeList, allnodelist);
        }
        return allnodelist;
    }

    private void deleteRule() {
        Object[] selectedRows = this.getSelectedPKId("delete");
        if (selectedRows != null && selectedRows.length > 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664?", (String)"OffsetRuleListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_comfirm", (IFormPlugin)this));
        }
    }

    private Object[] getSelectedPKId(String flag) {
        BillList bill = (BillList)this.getView().getControl(BILLLISTAP);
        if (bill.getSelectedRows().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"OffsetRuleListPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        if (bill.getSelectedRows().size() > 1 && "edit".equals(flag)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u540c\u65f6\u4fee\u6539\u591a\u884c\uff0c\u8bf7\u9009\u62e9\u5176\u4e2d\u4e00\u884c\u3002", (String)"OffsetRuleListPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        return bill.getSelectedRows().getPrimaryKeyValues();
    }

    private DynamicObject[] getSelectedRowsDetail(Object[] pkids) {
        BillList bill = (BillList)this.getView().getControl(BILLLISTAP);
        if (pkids != null && pkids.length > 0) {
            return BusinessDataServiceHelper.load((Object[])pkids, (DynamicObjectType)bill.getEntityType());
        }
        return null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "treecheckbox": {
                if (!this.validateModel()) break;
                this.refreshBillList();
                break;
            }
            case "modelbd": {
                Long modelId = UserSelectUtil.getF7SelectId((IFormView)this.getView(), (String)CTRL_KEY_MODEL);
                if (IDUtils.isNull((Long)modelId)) {
                    this.getModel().setValue(CTRL_KEY_MODEL, (Object)this.getPageCache().get(KEY_MODEL_ID));
                    break;
                }
                if (modelId.equals(IDUtils.toLong((Object)this.getPageCache().get(KEY_MODEL_ID)))) {
                    return;
                }
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
                this.modelChange(modelId);
                break;
            }
        }
    }

    private void modelChange(Long modelid) {
        this.getPageCache().put(KEY_MODEL_ID, modelid.toString());
        FilterParameter fp = new FilterParameter();
        QFilter filter = new QFilter("model", "=", (Object)modelid);
        fp.setFilter(filter);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.setFilterParameter(fp);
        this.getPageCache().put(FOCUSNODEID, null);
        this.getPageCache().put(HEADNODEID, null);
        this.refreshTree();
        this.refreshBillList();
    }

    private void refreshTree() {
        TreeView Tree = (TreeView)this.getControl(CTRL_KEY_CATALOGTREE);
        Tree.deleteAllNodes();
        this.handleOldData();
        this.initTree();
    }

    private void handleOldData() {
        QFilter q3;
        QFilter q2;
        Set busModels = BusinessModelServiceHelper.getInstance().getBusModelsByModelId(this.getModelId()).keySet();
        QFilter q1 = new QFilter("model", "=", (Object)this.getModelId());
        DynamicObjectCollection oldCatalog = QueryServiceHelper.query((String)EB_OFFSETRULECATALOG, (String)"id, name, number", (QFilter[])new QFilter[]{q1, q2 = new QFilter("longnumber", "!=", (Object)"root"), q3 = new QFilter("busmodel", "not in", busModels)});
        if (oldCatalog == null || oldCatalog.isEmpty()) {
            return;
        }
        List ocids = oldCatalog.stream().map(oc -> oc.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection oldRule = QueryServiceHelper.query((String)EB_OFFSETRULE, (String)"id, name, number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("offsetrulecatalog", "in", ocids)});
        if (oldRule == null || oldRule.isEmpty()) {
            DeleteServiceHelper.delete((String)EB_OFFSETRULECATALOG, (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("id", "in", ocids)});
            return;
        }
        List orids = oldRule.stream().map(or -> or.getLong("id")).collect(Collectors.toList());
        boolean hasOldEntry = QueryServiceHelper.exists((String)"eb_offsetentry", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("offsetrule", "in", orids)});
        if (hasOldEntry) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u65e7\u62b5\u9500\u5206\u5f55\u6570\u636e\u3002", (String)"OffsetRuleListPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DeleteServiceHelper.delete((String)EB_OFFSETRULE, (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("id", "in", orids)});
        DeleteServiceHelper.delete((String)EB_OFFSETRULECATALOG, (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("id", "in", ocids)});
    }

    private void initTree() {
        TreeNode rootTreeNode = new TreeNode();
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(16);
        String algoKey = this.getClass().getName();
        Long modelID = Long.parseLong(this.getPageCache().get(KEY_MODEL_ID));
        String selectFields = "id,name,number,parent,longnumber, ispreset, isleaf, level, busmodel";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelID);
        QFilter[] filters = new QFilter[]{fmodelid};
        String headid = "";
        DynamicObjectCollection busmodels = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id, name, number", (QFilter[])filters);
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)algoKey, (String)EB_OFFSETRULECATALOG, (String)selectFields, (QFilter[])filters, null);
        ArrayList treeList = new ArrayList(16);
        if (dcs != null && dcs.size() > 0) {
            HashMap<String, String> memberMap;
            for (DynamicObject dynamicObject : dcs) {
                memberMap = new HashMap<String, String>(16);
                memberMap.put("id", dynamicObject.get("id").toString());
                memberMap.put("number", (String)dynamicObject.get("number"));
                memberMap.put("longnumber", (String)dynamicObject.get("longnumber"));
                memberMap.put("name", (String)dynamicObject.get("name"));
                memberMap.put("parentid", dynamicObject.get("parent").toString());
                memberMap.put("ispreset", dynamicObject.getString("ispreset"));
                memberMap.put("isleaf", dynamicObject.getString("isleaf"));
                memberMap.put("level", dynamicObject.getString("level"));
                memberMap.put("busmodel", dynamicObject.getString("busmodel"));
                busmodels.removeIf(m -> dynamicObject.get("number").equals(m.getString("number")));
                treeList.add(memberMap);
                if (!"0".equals(dynamicObject.get("parent").toString())) continue;
                headid = dynamicObject.get("id").toString();
                rootTreeNode.setId(headid);
                rootTreeNode.setParentid("");
                rootTreeNode.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"OffsetRuleListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                if (this.getPageCache().get(FOCUSNODEID) == null) {
                    this.getPageCache().put(FOCUSNODEID, headid);
                }
                this.getPageCache().put(HEADNODEID, headid);
            }
            if (!busmodels.isEmpty()) {
                this.createBusModelNodes(busmodels, dynamicObjects, modelID, Long.parseLong(headid), rootTreeNode);
                for (DynamicObject dynamicObject : dynamicObjects) {
                    memberMap = new HashMap(16);
                    memberMap.put("id", dynamicObject.getString("id"));
                    memberMap.put("number", dynamicObject.getString("number"));
                    memberMap.put("longnumber", dynamicObject.getString("longnumber"));
                    memberMap.put("name", dynamicObject.getString("name"));
                    memberMap.put("parentid", dynamicObject.getString("parent"));
                    memberMap.put("ispreset", dynamicObject.getString("ispreset"));
                    memberMap.put("isleaf", dynamicObject.getString("isleaf"));
                    memberMap.put("level", dynamicObject.getString("level"));
                    memberMap.put("busmodel", dynamicObject.getString("busmodel"));
                    treeList.add(memberMap);
                }
                SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[dynamicObjects.size()]));
                this.getPageCache().put("needRefreshTree", "true");
            }
        } else {
            DynamicObject root = this.createOneCatalog(modelID, null, rootTreeNode, "root", "root", ResManager.loadKDString((String)"\u5168\u90e8", (String)"OffsetRuleListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), true);
            dynamicObjects.add(root);
            if (!busmodels.isEmpty()) {
                root.set("isleaf", (Object)0);
                this.createBusModelNodes(busmodels, dynamicObjects, modelID, root.getLong("id"), rootTreeNode);
            }
            for (DynamicObject dynamicObject : dynamicObjects) {
                HashMap<String, String> memberMap = new HashMap<String, String>(16);
                memberMap.put("id", dynamicObject.getString("id"));
                memberMap.put("number", dynamicObject.getString("number"));
                memberMap.put("longnumber", dynamicObject.getString("longnumber"));
                memberMap.put("name", dynamicObject.getString("name"));
                memberMap.put("level", dynamicObject.getString("level"));
                memberMap.put("ispreset", dynamicObject.getString("ispreset"));
                memberMap.put("isleaf", dynamicObject.getString("isleaf"));
                memberMap.put("parentid", dynamicObject.getString("parent"));
                memberMap.put("busmodel", dynamicObject.getString("busmodel"));
                treeList.add(memberMap);
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[dynamicObjects.size()]));
            this.getPageCache().put("needRefreshTree", "true");
            this.getPageCache().put(FOCUSNODEID, headid);
            this.getPageCache().put(HEADNODEID, headid);
        }
        this.getPageCache().put("treelist", SerializationUtils.toJsonString(treeList));
        dynamicObjects.stream().map(item -> item.getString("id")).forEach(id -> rootTreeNode.deleteChildNode(id));
        EPMTreeUtils.setEntryNode((TreeNode)rootTreeNode, treeList, (String)headid);
        EPMTreeUtils.spreadAllNode((TreeNode)rootTreeNode);
        TreeView tree = (TreeView)this.getControl(CTRL_KEY_CATALOGTREE);
        tree.addNode(rootTreeNode);
        tree.focusNode(rootTreeNode);
    }

    private void createBusModelNodes(DynamicObjectCollection busmodels, List<DynamicObject> dynamicObjects, Long modelID, Long parentId, TreeNode parentTreeNode) {
        if (busmodels != null && !busmodels.isEmpty()) {
            for (DynamicObject busModel : busmodels) {
                DynamicObject busModelNode = this.createOneCatalog(modelID, parentId, parentTreeNode, busModel.getString("number"), "root." + busModel.getString("number"), busModel.getString("name"), true);
                busModelNode.set("busmodel", (Object)busModel.getLong("id"));
                busModelNode.set("isleaf", (Object)0);
                dynamicObjects.add(busModelNode);
                DynamicObject interOffsetNode = this.createOneCatalog(modelID, busModelNode.getLong("id"), parentTreeNode.getTreeNode(busModelNode.getString("id"), 3), busModel.getString("number") + "." + OffsetCatalogEnum.INTEROFFSET.getNumber(), "root." + busModel.getString("number") + "." + OffsetCatalogEnum.INTEROFFSET.getNumber(), OffsetCatalogEnum.INTEROFFSET.getName(), true);
                interOffsetNode.set("busmodel", (Object)busModel.getLong("id"));
                dynamicObjects.add(interOffsetNode);
                DynamicObject tradeOffsetNode = this.createOneCatalog(modelID, busModelNode.getLong("id"), parentTreeNode.getTreeNode(busModelNode.getString("id"), 3), busModel.getString("number") + "." + OffsetCatalogEnum.TRADEOFFSET.getNumber(), "root." + busModel.getString("number") + "." + OffsetCatalogEnum.TRADEOFFSET.getNumber(), OffsetCatalogEnum.TRADEOFFSET.getName(), true);
                tradeOffsetNode.set("busmodel", (Object)busModel.getLong("id"));
                dynamicObjects.add(tradeOffsetNode);
            }
        }
    }

    private DynamicObject createOneCatalog(Long modelID, Long parentId, TreeNode parentTreeNode, String number, String longnumber, String name, boolean ispreset) {
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        DynamicObject dynamicObject = ORM.create().newDynamicObject(EB_OFFSETRULECATALOG);
        dynamicObject.set("id", (Object)DBServiceHelper.genGlobalLongId());
        dynamicObject.set("parent", (Object)parentId);
        dynamicObject.set("level", (Object)(longnumber == null ? 1 : longnumber.split("\\.").length));
        dynamicObject.set("isleaf", (Object)1);
        dynamicObject.set("ispreset", (Object)(ispreset ? 1 : 0));
        dynamicObject.set("name", (Object)name);
        dynamicObject.set("number", (Object)number);
        dynamicObject.set("longnumber", (Object)longnumber);
        dynamicObject.set("model", (Object)modelID);
        dynamicObject.set("sequence", (Object)1);
        dynamicObject.set("creator", (Object)userId);
        dynamicObject.set("createtime", (Object)now);
        dynamicObject.set("modifier", (Object)userId);
        dynamicObject.set("modifytime", (Object)now);
        if (parentId == null) {
            dynamicObject.set("ispreset", (Object)1);
            parentTreeNode.setId(dynamicObject.getString("id"));
            parentTreeNode.setText(dynamicObject.getString("name"));
        } else {
            parentTreeNode.addChild(new TreeNode(dynamicObject.getString("parent"), dynamicObject.getString("id"), dynamicObject.getString("name")));
        }
        return dynamicObject;
    }

    private Object[] queryRuleByCatalogIds(Object[] pks) {
        QFilter filter1 = new QFilter("offsetrulecatalog", "in", (Object)pks);
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)EB_OFFSETRULE, (String)"id", (QFilter[])new QFilter[]{filter1});
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (DynamicObject d : dcs) {
            ids.add(d.getLong("id"));
        }
        return BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)EB_OFFSETRULE));
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        if (!this.validateModel()) {
            return;
        }
        switch (key = evt.getItemKey()) {
            case "btn_addnew": {
                this.getPageCache().put("operation", "add");
                this.showFormCombinOffset();
                break;
            }
            case "btn_modify": {
                Object[] selectRows = this.getSelectedPKId("edit");
                if (selectRows == null) break;
                this.getPageCache().put("operation", "edit");
                this.editCombinOffsetNumber(selectRows[0].toString());
                break;
            }
            case "btn_delete": {
                this.deleteRule();
                break;
            }
            case "btn_refresh": {
                this.refreshTree();
                this.refreshBillList();
                break;
            }
            case "btn_enable": {
                this.enableOrDisable("enable");
                break;
            }
            case "btn_disable": {
                this.enableOrDisable("disable");
                break;
            }
        }
    }

    public void enableOrDisable(String status) {
        DynamicObject[] rules = this.getSelectedRowsDetail(this.getSelectedPKId("isable"));
        if (rules != null && rules.length > 0) {
            if ("enable".equals(status)) {
                for (DynamicObject object : rules) {
                    object.set("enable", (Object)1);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"OffsetRuleListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.writeLog("enable", new MultiLangEnumBridge("\u542f\u7528", "OffsetRuleListPlugin_5", "epm-eb-formplugin"), new MultiLangEnumBridge("\u542f\u7528\u62b5\u9500\u89c4\u5219\u6210\u529f\u3002", "OffsetRuleListPlugin_6", "epm-eb-formplugin"));
            } else {
                for (DynamicObject object : rules) {
                    object.set("enable", (Object)0);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"OffsetRuleListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.writeLog("disable", new MultiLangEnumBridge("\u7981\u7528", "OffsetRuleListPlugin_8", "epm-eb-formplugin"), new MultiLangEnumBridge("\u62b5\u9500\u89c4\u5219\u7981\u7528\u6210\u529f\u3002", "OffsetRuleListPlugin_9", "epm-eb-formplugin"));
            }
            SaveServiceHelper.save((DynamicObject[])rules);
            this.refreshBillList();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if (!this.validateModel()) {
            return;
        }
        String nodeId = this.getPageCache().get(FOCUSNODEID);
        if (nodeId == null) {
            nodeId = "0";
        }
        Map<String, String> nodedetail = this.getNodeDetailById(nodeId);
        switch (c.getKey().toLowerCase()) {
            case "btn_addnewcatalog": {
                this.showFormCatalog(nodeId, true);
                break;
            }
            case "btn_modifycatalog": {
                this.showFormCatalog(nodeId, false);
                break;
            }
            case "btn_deletecatalog": {
                if (nodedetail != null && Boolean.parseBoolean(nodedetail.get("ispreset"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u5206\u7c7b\u4e0d\u80fd\u5220\u9664\u3002", (String)"OffsetRuleListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u88ab\u5220\u9664\u5206\u7c7b\u4e0b\u7684\u62b5\u9500\u89c4\u5219\u5c06\u4f1a\u88ab\u79fb\u52a8\u5230\u5176\u76f4\u63a5\u4e0a\u7ea7\u5206\u7c7b\u4e0a\uff0c\u662f\u5426\u5220\u9664\uff1f", (String)"OffsetRuleListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deletecatalog_comfirm", (IFormPlugin)this));
                break;
            }
            case "btn_up": {
                this.catelogUpAndDown("btn_up");
                break;
            }
            case "btn_down": {
                this.catelogUpAndDown("btn_down");
                break;
            }
        }
    }

    private void catelogUpAndDown(String key) {
        Map<String, Object> nodeMap = this.getFocusNode();
        if (nodeMap.size() == 0 || nodeMap == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u6a21\u677f\u5206\u7c7b\u3002", (String)"OffsetRuleListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String nodeId = nodeMap.get("id").toString();
        if ("btn_up".equals(key)) {
            this.catalogMove(nodeId, "up");
        } else {
            this.catalogMove(nodeId, "down");
        }
    }

    private void catalogMove(String selectId, String operate) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)EB_OFFSETRULECATALOG);
        DynamicObject nodeObject = BusinessDataServiceHelper.loadSingle((Object)selectId, (DynamicObjectType)dynamicObject.getDynamicObjectType());
        int seq = nodeObject.getInt("sequence");
        int level = nodeObject.getInt("level");
        if (level == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u5206\u7c7b\u4e0d\u80fd\u4e0a\u79fb\u3001\u4e0b\u79fb\u3002", (String)"OffsetRuleListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (seq != 0) {
            DynamicObject parent = (DynamicObject)nodeObject.get("parent");
            String parentId = parent.getString("id");
            QFilter qFilter2 = new QFilter("parent", "=", (Object)parentId);
            DynamicObjectCollection allSize = QueryServiceHelper.query((String)EB_OFFSETRULECATALOG, (String)"id", (QFilter[])new QFilter[]{qFilter2});
            if (allSize.size() == 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u89c4\u5219\u76ee\u5f55\u53ea\u5b58\u5728\u4e00\u4e2a\u5206\u7c7b\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3001\u4e0b\u79fb\u3002", (String)"OffsetRuleListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (seq == 1 && "up".equals(operate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u89c4\u5219\u76ee\u5f55\u5df2\u5230\u8fbe\u6700\u9876\u5c42\uff0c\u4e0d\u80fd\u7ee7\u7eed\u4e0a\u79fb\u3002", (String)"OffsetRuleListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (seq == allSize.size() && "down".equals(operate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u89c4\u5219\u76ee\u5f55\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u5e95\u5c42\uff0c\u4e0d\u80fd\u4e0b\u79fb\u3002", (String)"OffsetRuleListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter qFilterDown = new QFilter("sequence", ">", (Object)seq);
            QFilter qFilterUp = new QFilter("sequence", "<", (Object)seq);
            String sequenceUp = "sequence";
            String sequenceDown = "sequence desc";
            DynamicObjectCollection querys = null;
            querys = "up".equals(operate) ? QueryServiceHelper.query((String)this.getClass().getName(), (String)EB_OFFSETRULECATALOG, (String)"id,sequence", (QFilter[])new QFilter[]{qFilterUp, qFilter2}, (String)sequenceUp, (int)1) : QueryServiceHelper.query((String)this.getClass().getName(), (String)EB_OFFSETRULECATALOG, (String)"id,sequence", (QFilter[])new QFilter[]{qFilterDown, qFilter2}, (String)sequenceDown, (int)1);
            if (querys.size() > 0 && querys != null) {
                DynamicObject node2 = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)querys.get(0)).getString("id"), (DynamicObjectType)dynamicObject.getDynamicObjectType());
                node2.set("sequence", (Object)seq);
                nodeObject.set("sequence", (Object)((DynamicObject)querys.get(0)).getInt("sequence"));
                SaveServiceHelper.save((IDataEntityType)dynamicObject.getDynamicObjectType(), (Object[])new Object[]{node2, nodeObject});
                this.writeLog("update", new MultiLangEnumBridge("\u4fee\u6539", "OffsetRuleListPlugin_17", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4fee\u6539\u5206\u7c7b\u6210\u529f", "OffsetRuleListPlugin_18", "epm-eb-formplugin"));
                this.refreshTree();
                TreeNode node = new TreeNode(parentId, selectId, nodeObject.getString("name"));
                ((TreeView)this.getControl(CTRL_KEY_CATALOGTREE)).focusNode(node);
            } else if ("up".equals(operate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u89c4\u5219\u76ee\u5f55\u5df2\u5230\u8fbe\u6700\u9876\u5c42\uff0c\u4e0d\u80fd\u7ee7\u7eed\u4e0a\u79fb\u3002", (String)"OffsetRuleListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u89c4\u5219\u76ee\u5f55\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u5e95\u5c42\uff0c\u4e0d\u80fd\u4e0b\u79fb\u3002", (String)"OffsetRuleListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void showFormCatalog(String nodeId, boolean isAddNew) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("model", this.getPageCache().get(KEY_MODEL_ID));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADD_CATALOG_CLOSECALLBACK);
        if (isAddNew) {
            boolean canAddnew;
            Map<String, String> nodedetail = this.getNodeDetailById(nodeId);
            if (nodedetail == null) {
                return;
            }
            String longnumber = nodedetail.get("longnumber");
            boolean bl = canAddnew = "true".equals(nodedetail.get("ispreset")) && (longnumber.endsWith(OffsetCatalogEnum.INTEROFFSET.getNumber()) || longnumber.endsWith(OffsetCatalogEnum.TRADEOFFSET.getNumber()));
            if (!canAddnew) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8282\u70b9\u4e0d\u5141\u8bb8\u65b0\u589e\u5206\u7c7b\u3002", (String)"OffsetRuleListPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            long id = Long.parseLong(nodeId);
            params.put("parent", id);
            params.put("busmodel", nodedetail.get("busmodel"));
            this.showForm(EB_OFFSETRULECATALOG, params, closeCallBack, ShowType.Modal, 0L);
        } else if (nodeId.equals(this.getPageCache().get(HEADNODEID))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"OffsetRuleListPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            long id = Long.parseLong(nodeId);
            Map<String, String> node = this.getNodeDetailById(nodeId);
            if (node == null) {
                return;
            }
            params.put("number", node.get("number"));
            this.showForm(EB_OFFSETRULECATALOG, params, closeCallBack, ShowType.Modal, id);
        }
    }

    private void showFormCombinOffset() {
        String catelogId = this.getPageCache().get(FOCUSNODEID);
        if (catelogId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u89c4\u5219\u5206\u7c7b\u3002", (String)"OffsetRuleListPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, String> map = this.getNodeDetailById(catelogId);
        if (map == null) {
            return;
        }
        String level = map.get("level");
        if (catelogId.equals(this.getPageCache().get(HEADNODEID)) || "2".equals(level)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8282\u70b9\u4e0d\u5141\u8bb8\u65b0\u589e\u62b5\u9500\u89c4\u5219\u3002", (String)"OffsetRuleListPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, EB_OFFSETRULE);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(EB_OFFSETRULE);
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam(KEY_MODEL_ID, (Object)this.getPageCache().get(KEY_MODEL_ID));
        formShowParameter.setCustomParam("KEY_BUSMODEL_ID", (Object)map.get("busmodel"));
        formShowParameter.setCustomParam(OFFSETRULE_CATALOG_ID, (Object)catelogId);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u62b5\u9500\u89c4\u5219", (String)"OffsetRuleListPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }

    private void editCombinOffset(String id) {
        DynamicObject[] dynamicObjects = this.getSelectedRowsDetail(new String[]{id});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        OffsetRule offsetRule = new OffsetRule();
        offsetRule.setId(Long.valueOf(Long.parseLong(id)));
        offsetRule.setModelID(this.getModelId());
        offsetRule.setBusmodelID(Long.valueOf(dynamicObjects[0].getLong("busmodel.id")));
        offsetRule.setCatalogID(Long.valueOf(Long.parseLong(dynamicObjects[0].get("offsetrulecatalog.id").toString())));
        offsetRule.setNumber(dynamicObjects[0].get("number").toString());
        offsetRule.setName(dynamicObjects[0].get("name").toString());
        offsetRule.setDescription(dynamicObjects[0].get("description").toString());
        offsetRule.setEntityViewId(Long.valueOf(dynamicObjects[0].getLong("entityview.id")));
        this.showFormOffsetRuleSetting(offsetRule);
    }

    private void editCombinOffsetNumber(String id) {
        String catelogId = this.getPageCache().get(FOCUSNODEID);
        if (catelogId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u89c4\u5219\u5206\u7c7b\u3002", (String)"OffsetRuleListPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("formId", EB_OFFSETRULE);
        map.put("pkId", id);
        FormShowParameter form = FormShowParameter.createFormShowParameter(map);
        form.setStatus(OperationStatus.EDIT);
        form.setCaption(ResManager.loadKDString((String)"\u62b5\u9500\u89c4\u5219 - \u7f16\u8f91", (String)"OffsetRuleListPlugin_44", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        form.setCustomParam("id", (Object)id);
        form.setCustomParam("isEdit", (Object)true);
        form.setCustomParam(KEY_MODEL_ID, (Object)this.getPageCache().get(KEY_MODEL_ID));
        form.setCustomParam(OFFSETRULE_CATALOG_ID, (Object)catelogId);
        form.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, OFFSETRYLE_EDIT);
        form.setCloseCallBack(closeCallBack);
        this.getView().showForm(form);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key;
        super.closedCallBack(closedCallBackEvent);
        switch (key = closedCallBackEvent.getActionId()) {
            case "ADD_CATALOG_CLOSECALLBACK": {
                ArrayList ids;
                ArrayList arrayList = ids = closedCallBackEvent.getReturnData() == null ? null : (ArrayList)closedCallBackEvent.getReturnData();
                if (ids == null || ids.size() <= 0) break;
                this.refreshTree();
                String nodeid = ((Long)ids.get(0)).toString();
                List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("treelist"), List.class);
                for (Map m : treeList) {
                    if (!nodeid.equals(m.get("id"))) continue;
                    TreeNode node = new TreeNode((String)m.get("parentid"), (String)m.get("id"), (String)m.get("name"));
                    ((TreeView)this.getControl(CTRL_KEY_CATALOGTREE)).focusNode(node);
                    this.getPageCache().put(FOCUSNODEID, nodeid);
                }
                this.refreshBillList();
                break;
            }
            case "eb_offsetrule": {
                Object returndata = closedCallBackEvent.getReturnData();
                if (returndata == null) break;
                OffsetRule offsetrule = (OffsetRule)ObjectSerialUtil.deSerializedBytes((String)((String)returndata));
                this.showFormOffsetRuleSetting(offsetrule);
                break;
            }
            case "offsetRule_edit": {
                Object data = closedCallBackEvent.getReturnData();
                if (data != null) {
                    OffsetRule offsetrule = (OffsetRule)ObjectSerialUtil.deSerializedBytes((String)((String)data));
                    this.saveEditOffsetRule(offsetrule);
                }
                this.refreshTree();
                this.refreshBillList();
                break;
            }
            case "OFFSETRULESETTING_CLOSECALLBACK": {
                this.getPageCache().put(FOCUSNODEID, this.getPageCache().get(HEADNODEID));
                this.refreshTree();
                this.refreshBillList();
                break;
            }
        }
    }

    private void saveEditOffsetRule(OffsetRule newData) {
        Long id = newData.getId();
        DynamicObject offsetRule = BusinessDataServiceHelper.loadSingle((Object)id, (String)EB_OFFSETRULE);
        offsetRule.set("name", (Object)newData.getName());
        offsetRule.set("number", (Object)newData.getNumber());
        offsetRule.set("description", (Object)newData.getDescription());
        offsetRule.set("modifier", (Object)UserUtils.getUserId());
        offsetRule.set("modifytime", (Object)TimeServiceHelper.now());
        DynamicObject[] dynamicObjects = new DynamicObject[]{offsetRule};
        try {
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fee\u6539", "OffsetRuleListPlugin_17", "epm-eb-formplugin");
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u7f16\u53f7\u201c%1$s\u201d\uff0c\u4fee\u6539\u6210\u529f\u3002", "AbstractBasePlugin_19", "epm-eb-formplugin");
            this.writeLog(null, "update", opName, opDescription, new String[]{newData.getNumber()});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f\u3002", (String)"OffsetRuleListPlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fee\u6539", "OffsetRuleListPlugin_17", "epm-eb-formplugin");
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u7f16\u53f7\u201c%1$s\u201d\uff0c\u4fee\u6539\u5931\u8d25\u3002", "AbstractBasePlugin_20", "epm-eb-formplugin");
            this.writeLog(null, "update", opName, opDescription, new String[]{newData.getNumber()});
            throw new KDBizException(e.getMessage());
        }
    }

    private Map<String, Object> getFocusNode() {
        TreeView tree = (TreeView)this.getControl(CTRL_KEY_CATALOGTREE);
        Map nodeMap = tree.getTreeState().getFocusNode();
        return nodeMap;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String confirmId = messageBoxClosedEvent.getCallBackId();
        if ("delete_comfirm".equals(confirmId) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            LinkedHashSet offsetRuleIds;
            DynamicObject[] selectedRowsDetail;
            Object[] selectedPKId = this.getSelectedPKId("delete");
            if (selectedPKId == null) {
                return;
            }
            Set<Long> set = this.getUsedRuleIdSet();
            ArrayList<Long> ids = new ArrayList<Long>(16);
            if (set != null && set.size() > 0) {
                for (Object pkId : selectedPKId) {
                    if (set.contains(Long.parseLong(pkId.toString()))) continue;
                    ids.add((Long)pkId);
                }
                selectedRowsDetail = this.getSelectedRowsDetail(ids.toArray(new Object[ids.size()]));
                offsetRuleIds = Sets.newLinkedHashSet();
                if (selectedRowsDetail != null) {
                    for (DynamicObject dynamicObject : selectedRowsDetail) {
                        offsetRuleIds.add(dynamicObject.getLong("id"));
                    }
                }
                if (ids.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5df2\u4ea7\u751f\u62b5\u9500\u5206\u5f55\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"OffsetRuleListPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else if (ids.size() == selectedPKId.length) {
                    DeleteServiceHelper.delete((String)EB_OFFSETRULE, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                    this.deleteQuote(offsetRuleIds);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"OffsetRuleListPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "OffsetRuleListPlugin_30", "epm-eb-formplugin"), new MultiLangEnumBridge("\u6210\u529f\u5220\u9664%1$s\u6761\u6570\u636e\u3002", "OffsetRuleListPlugin_30_repair", "epm-eb-formplugin"), new String[]{ids.size() + ""});
                } else {
                    DeleteServiceHelper.delete((String)EB_OFFSETRULE, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                    this.deleteQuote(offsetRuleIds);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u5220\u9664\u6210\u529f\uff0c\u81ea\u52a8\u8df3\u8fc7\u5df2\u4ea7\u751f\u62b5\u9500\u5206\u5f55\u7684\u62b5\u9500\u89c4\u5219\u3002", (String)"OffsetRuleListPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "OffsetRuleListPlugin_30", "epm-eb-formplugin"), new MultiLangEnumBridge("\u6210\u529f\u5220\u9664%1$s\u6761\u6570\u636e\u3002", "OffsetRuleListPlugin_30_repair", "epm-eb-formplugin"), new String[]{ids.size() + ""});
                }
            } else {
                selectedRowsDetail = this.getSelectedRowsDetail(selectedPKId);
                offsetRuleIds = Sets.newLinkedHashSet();
                if (selectedRowsDetail != null) {
                    for (DynamicObject dynamicObject : selectedRowsDetail) {
                        offsetRuleIds.add(dynamicObject.getLong("id"));
                    }
                }
                DeleteServiceHelper.delete((String)EB_OFFSETRULE, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedPKId)});
                this.deleteQuote(offsetRuleIds);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"OffsetRuleListPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "OffsetRuleListPlugin_30", "epm-eb-formplugin"), new MultiLangEnumBridge("\u6210\u529f\u5220\u9664%1$s\u6761\u6570\u636e\u3002", "OffsetRuleListPlugin_30_repair", "epm-eb-formplugin"), new String[]{selectedPKId.length + ""});
            }
            this.refreshBillList();
        }
        if ("deletecatalog_comfirm".equals(confirmId) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            DynamicObject[] proTemplates;
            Map<String, Object> nodeMap = this.getFocusNode();
            Long nodeId = IDUtils.toLong((Object)nodeMap.get("id"));
            String parentId = nodeMap.get("parentid").toString();
            List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("treelist"), List.class);
            ArrayList<Long> childenNodeIds = new ArrayList<Long>(16);
            this.queryAllChildNodeList(nodeId, treeList, childenNodeIds);
            childenNodeIds.add(nodeId);
            for (DynamicObject proTemplate : proTemplates = (DynamicObject[])this.queryRuleByCatalogIds(childenNodeIds.toArray())) {
                proTemplate.set("offsetrulecatalog", (Object)parentId);
            }
            SaveServiceHelper.save((DynamicObject[])proTemplates);
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)EB_OFFSETRULECATALOG), (Object[])childenNodeIds.toArray());
            this.refreshTree();
            this.refreshBillList();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"OffsetRuleListPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "OffsetRuleListPlugin_30", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5220\u9664\u62b5\u9500\u89c4\u5219\u5206\u7c7b\u6210\u529f\u3002", "OffsetRuleListPlugin_34", "epm-eb-formplugin"));
        }
    }

    private void deleteQuote(Set<Long> offsetRuleIds) {
        if (offsetRuleIds == null || offsetRuleIds.size() == 0) {
            return;
        }
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.OffsetRule.getType(), offsetRuleIds});
    }

    private Map<String, String> getNodeDetailById(String nodeid) {
        List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("treelist"), List.class);
        if (treeList != null && nodeid != null) {
            for (Map node : treeList) {
                if (!((String)node.get("id")).equals(nodeid)) continue;
                return node;
            }
        }
        return null;
    }

    private Set<Long> getUsedRuleIdSet() {
        HashSet<Long> set = new HashSet<Long>(16);
        String entityName = "eb_offsetentry";
        String selectedFiled = "id,offsetrule.id";
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entityName, (String)selectedFiled, (QFilter[])filters);
        if (dynamicObjects != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (dynamicObject.get("offsetrule.id") == null || "0".equals(dynamicObject.get("offsetrule.id").toString())) continue;
                set.add(Long.parseLong(dynamicObject.get("offsetrule.id").toString()));
            }
        }
        return set;
    }

    private void showFormOffsetRuleSetting(OffsetRule offsetRule) {
        IFormView mainview = this.getView().getMainView();
        String pageid = this.getView().getPageId() + offsetRule.getCatalogID() + offsetRule.getNumber();
        IFormView toshowview = null;
        if (mainview != null) {
            toshowview = mainview.getView(pageid);
        }
        if (toshowview == null) {
            FormShowParameter param = new FormShowParameter();
            param.setCustomParam(OFFSETRULE_INFO, (Object)ObjectSerialUtil.toByteSerialized((Object)offsetRule));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, OFFSETRULESETTING_CLOSECALLBACK);
            param.setCloseCallBack(closeCallBack);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.getOpenStyle().setTargetKey(KEY_SUB_MAIN_TAB);
            param.setFormId(EB_OFFSETRULESETTING);
            param.setCaption(ResManager.loadResFormat((String)"\u7f16\u8f91\u62b5\u9500\u89c4\u5219-%1", (String)"OffsetRuleListPlugin_35_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{offsetRule.getNumber()}));
            param.setCustomParam(KEY_MODEL_ID, (Object)offsetRule.getModelID());
            param.setCustomParam("KEY_BUSMODEL_ID", (Object)offsetRule.getBusmodelID());
            param.setCustomParam("operation", (Object)this.getPageCache().get("operation"));
            if (this.getView().getParentView() != null) {
                param.setParentPageId(this.getView().getParentView().getPageId());
            }
            param.setPageId(pageid);
            this.getView().showForm(param);
        } else {
            toshowview.activate();
            this.getView().sendFormAction(toshowview);
        }
    }

    private void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType, long id) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (id != 0L) {
            param.setPkId((Object)id);
            param.setStatus(OperationStatus.EDIT);
        }
        if (params.size() > 0) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (((BasedataEdit)e.getSource()).getKey().equals(CTRL_KEY_MODEL) && StringUtils.isNotEmpty((String)CTRL_KEY_MODEL) && this.getControl(CTRL_KEY_MODEL) != null) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ArrayList qFilterList = ((BasedataEdit)this.getControl(CTRL_KEY_MODEL)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList(16);
            }
            qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
        if (CTRL_KEY_MODEL.equals(key)) {
            ListShowParameter rel_show = (ListShowParameter)e.getFormShowParameter();
            rel_show.setBillFormId("epm_model");
            e.setFormShowParameter((FormShowParameter)rel_show);
        }
    }

    public void hyperLink(HyperLinkClickEvent e, String id) {
        boolean exists = QueryServiceHelper.exists((String)EB_OFFSETRULE, (Object)id);
        if (exists) {
            this.getPageCache().put("operation", "edit");
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u67e5\u8be2", "OffsetRuleListPlugin_48", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u7f16\u53f7\uff1a%1$s\uff0c\u67e5\u770b\u62b5\u6d88\u89c4\u5219\u6210\u529f\u3002", "OffsetRuleListPlugin_49", "epm-eb-formplugin");
            String[] opDescArgs = new String[]{id};
            this.writeLog(id, "view", opName, opDesc, opDescArgs);
            this.editCombinOffset(id);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u5220\u9664\u3002", (String)"OffsetRuleListPlugin_46", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.refreshBillList();
        }
    }

    @Override
    public Long getModelId() {
        Long modelId = 0L;
        DynamicObject model = (DynamicObject)this.getModel().getValue(CTRL_KEY_MODEL);
        if (model != null) {
            modelId = model.getLong("id");
        }
        return modelId;
    }
}

