/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.combinoffset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.combinoffset.OffsetRule;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.AuditTrailUseEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.VarhandleEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class OffsetRuleSettingPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener {
    private static final String CTRL_KEY_AUDITTRAIL = "audittrail";
    private static final String CTRL_KEY_DESTAUDITTRAIL = "destaudittrail";
    private static final String CTRL_KEY_CURRENCY = "currency";
    private static final String CTRL_KEY_SENDACCOUNT = "sendaccount";
    private static final String CTRL_KEY_ACCEPTACCOUNT = "acceptaccount";
    private static final String ENTITYVIEW = "entityview";
    private static final String ASSISTDIM = "assistdim";
    private static final String VARACCOUNT = "varaccount";
    private static final String ENTRYENTITYSEND = "entryentitysend";
    private static final String ENTRYENTITYRECV = "entryentityrecv";
    public static final String OFFSETRULE_INFO = "OFFSETRULE_INFO";
    public static final String OFFSETRULE_CACHE = "offsetRule";
    public static final String TREENTRYENTITY = "treeentryentity";
    private Map<String, String> metricMap = new HashMap<String, String>(16);
    private static final String MONEY = "Money";
    private static final String AMOUNT = "Amount";

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        this.addTextF7SelectListeners(CTRL_KEY_SENDACCOUNT, CTRL_KEY_ACCEPTACCOUNT, VARACCOUNT);
        this.addF7SelectListeners(CTRL_KEY_AUDITTRAIL, CTRL_KEY_DESTAUDITTRAIL, CTRL_KEY_CURRENCY, ENTITYVIEW);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREENTRYENTITY);
        treeEntry.addCellClickListener(this::registerListener);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    private void addF7SelectListeners(String ... f7Keys) {
        BasedataEdit f7 = null;
        for (String f7Key : f7Keys) {
            f7 = (BasedataEdit)this.getControl(f7Key);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(this::beforeF7Select);
        }
    }

    private void addTextF7SelectListeners(String ... f7Keys) {
        TextEdit f7 = null;
        for (String f7Key : f7Keys) {
            f7 = (TextEdit)this.getControl(f7Key);
            if (f7 == null) continue;
            f7.addClickListener((ClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID").toString();
        String busmodelId = this.getView().getFormShowParameter().getCustomParam("KEY_BUSMODEL_ID").toString();
        if (StringUtils.isEmpty((String)busmodelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bfb\u53d6\u4e1a\u52a1\u6a21\u578b\u5931\u8d25\uff0c\u8bf7\u8fd4\u56de\u540e\u91cd\u8bd5\u3002", (String)"OffsetRuleSettingPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        OffsetRule offsetRule = (OffsetRule)ObjectSerialUtil.deSerializedBytes((String)((String)this.getView().getFormShowParameter().getCustomParam(OFFSETRULE_INFO)));
        this.getPageCache().put(OFFSETRULE_CACHE, ObjectSerialUtil.toByteSerialized((Object)offsetRule));
        this.getModel().setValue("model", (Object)modelId);
        this.getModel().setValue("busmodel", (Object)busmodelId);
        this.getPageCache().put("KEY_MODEL_ID", modelId);
        this.getPageCache().put("KEY_BUSMODEL_ID", busmodelId);
        this.initAssistdim((DynamicObject)this.getModel().getValue("model"), Long.valueOf(busmodelId));
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap4"});
        this.getPageCache().put("dataChange", "false");
        this.initMetricMap();
        if ("edit".equals(this.getView().getFormShowParameter().getCustomParam("operation").toString())) {
            Long viewId = offsetRule.getEntityViewId();
            if (IDUtils.isEmptyLong((Long)viewId).booleanValue()) {
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)IDUtils.toLong((Object)modelId));
                viewId = modelCache.getViewByBusModelAndDimNumber(IDUtils.toLong((Object)busmodelId), SysDimensionEnum.Entity.getNumber());
            }
            this.getModel().setValue(ENTITYVIEW, (Object)viewId);
            this.initTree();
            this.setAllRuleData(offsetRule.getId());
        }
    }

    private void setAllRuleData(Long id) {
        Map<String, DynamicObjectCollection> map = this.queryRuleDataById(id);
        if (map == null || map.size() == 0) {
            return;
        }
        DynamicObjectCollection accounts = map.get("accounts");
        DynamicObjectCollection orgs = map.get("orgs");
        this.setHeadValue((DynamicObject)accounts.get(0));
        this.setAccountValue(accounts);
        this.setOrgsValue(orgs);
    }

    private TreeNode getAccountTree() {
        DynamicObjectCollection memberColls = this.queryDimmember("epm_accountmembertree", null);
        TreeNode accountTree = this.buildTree(memberColls);
        return accountTree;
    }

    private void setHeadValue(DynamicObject headValue) {
        IDataModel dataModel = this.getModel();
        dataModel.setValue(CTRL_KEY_AUDITTRAIL, (Object)headValue.getLong("audittrail.id"));
        dataModel.setValue(CTRL_KEY_DESTAUDITTRAIL, (Object)headValue.getLong("destaudittrail.id"));
        dataModel.setValue(CTRL_KEY_CURRENCY, (Object)headValue.getLong("currency.id"));
        String assistdim = headValue.getString(ASSISTDIM);
        if (assistdim != null && !"".equals(assistdim)) {
            String assisdimsNumber = "," + assistdim + ",";
            dataModel.setValue(ASSISTDIM, (Object)assisdimsNumber);
        }
        String varhandle = headValue.getString("varhandle");
        dataModel.setValue("varhandle", (Object)varhandle);
        if (VarhandleEnum.SPECIFYACCOUNT.getIndex().equals(varhandle)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap4"});
            dataModel.setValue("varaccountid", (Object)headValue.getLong("varaccount.id"));
            dataModel.setValue(VARACCOUNT, (Object)headValue.getString("varaccount.name"));
        }
        Long metricid = headValue.getLong("metric.id");
        Long metricqtyid = headValue.getLong("metricqty.id");
        String listValue = null;
        listValue = this.isNotNull(metricid) && this.isNotNull(metricqtyid) ? "Money,Amount" : (this.isNotNull(metricid) ? MONEY : (this.isNotNull(metricqtyid) ? AMOUNT : null));
        dataModel.setValue("metriclist", (Object)listValue);
        if (StringUtils.equals((String)VarhandleEnum.USEBIG.getIndex(), (String)varhandle)) {
            this.enableAndVisibleUnilateral(true);
            dataModel.setValue("checkunilateral", (Object)StringUtils.equals((String)VarhandleEnum.USEBIG.getIndex(), (String)headValue.getString("unilateral")));
        } else {
            this.enableAndVisibleUnilateral(false);
        }
    }

    private void enableAndVisibleUnilateral(boolean enableAndVisible) {
        this.getView().setVisible(Boolean.valueOf(enableAndVisible), new String[]{"checkunilateral"});
        this.getView().setEnable(Boolean.valueOf(enableAndVisible), new String[]{"checkunilateral"});
    }

    private List<String> getAssistdim() {
        ArrayList<String> dims = new ArrayList<String>(16);
        if (this.getModel().getValue(ASSISTDIM) != null) {
            String[] selectItem = this.getModel().getValue(ASSISTDIM).toString().split(",");
            for (int i = 0; i < selectItem.length; ++i) {
                if ("".equals(selectItem[i])) continue;
                dims.add(selectItem[i]);
            }
        }
        return dims;
    }

    private boolean isNotNull(Long value) {
        return value != null && value != 0L;
    }

    private void setAccountValue(DynamicObjectCollection accounts) {
        DynamicObjectCollection entryentitysend = this.getModel().getEntryEntity(ENTRYENTITYSEND);
        DynamicObjectCollection entryentityrecv = this.getModel().getEntryEntity(ENTRYENTITYRECV);
        for (DynamicObject account : accounts) {
            DynamicObject entity;
            if (account.getBoolean("accounts.senderaccount")) {
                entity = entryentitysend.addNew();
                entity.set("sendaccountid", (Object)account.getString("accounts.account.id"));
                entity.set("sendnumber", (Object)account.getString("accounts.account.number"));
                entity.set(CTRL_KEY_SENDACCOUNT, (Object)account.getString("accounts.account.name"));
                entity.set("isleafsend", (Object)account.getString("accounts.account.isleaf"));
                continue;
            }
            entity = entryentityrecv.addNew();
            entity.set("acceptaccountid", (Object)account.getString("accounts.account.id"));
            entity.set("acceptnumber", (Object)account.getString("accounts.account.number"));
            entity.set(CTRL_KEY_ACCEPTACCOUNT, (Object)account.getString("accounts.account.name"));
            entity.set("isleafrecv", (Object)account.getString("accounts.account.isleaf"));
        }
        this.getView().updateView(ENTRYENTITYSEND);
        this.getView().updateView(ENTRYENTITYRECV);
    }

    private void setOrgsValue(DynamicObjectCollection orgs) {
        if (orgs == null || orgs.size() == 0) {
            return;
        }
        DynamicObjectCollection orgEntity = this.getModel().getEntryEntity(TREENTRYENTITY);
        for (DynamicObject org : orgs) {
            String id = org.getString("orgs.org.id");
            for (DynamicObject dynamicObject : orgEntity) {
                if (!dynamicObject.get("orgid").toString().equals(id)) continue;
                dynamicObject.set("enable", (Object)true);
            }
        }
    }

    protected void initAssistdim(DynamicObject model, Long busModel) {
        if (model == null) {
            return;
        }
        DataSet catalogDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_offsetrulecatalog", (String)ASSISTDIM, (QFilter[])new QFilter[]{new QFilter("busmodel", "=", (Object)busModel), new QFilter("level", "=", (Object)2)}, null);
        if (catalogDs == null || catalogDs.isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ASSISTDIM});
            return;
        }
        String dimStr = "";
        while (catalogDs.hasNext()) {
            Row row = catalogDs.next();
            dimStr = row.getString(ASSISTDIM);
        }
        String[] numbers = dimStr.split(",");
        if (numbers.length == 0) {
            return;
        }
        QFilter filter = new QFilter("number", "in", (Object)numbers);
        QFBuilder qfBuilder = new QFBuilder(new QFilter("model", "=", model.getPkValue()));
        qfBuilder.add(filter);
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"epm_dimension", (String)"id, name, number", (QFilter[])qfBuilder.add("issysdimension", "=", (Object)"0").toArrays(), (String)"dseq");
        if (ds == null || ds.isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ASSISTDIM});
            return;
        }
        Row row = null;
        HashMap<String, String> dimensionMap = new HashMap<String, String>(16);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        ComboItem item = null;
        while (ds.hasNext()) {
            row = ds.next();
            item = new ComboItem(new LocaleString(row.getString("name")), row.getString("number"));
            items.add(item);
            dimensionMap.put(row.getString("number"), row.getString("name"));
        }
        MulComboEdit control = (MulComboEdit)this.getControl(ASSISTDIM);
        control.setComboItems(items);
        this.getPageCache().put(ASSISTDIM, SerializationUtils.serializeToBase64(dimensionMap));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String confirmId = messageBoxClosedEvent.getCallBackId();
        if ("dataChange_comfirm".equals(confirmId) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getView().close();
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String varhandle = this.getModel().getValue("varhandle").toString();
        int rowCount = 0;
        int index = -1;
        switch (formOperate.getOperateKey()) {
            case "newentry": {
                rowCount = this.getModel().getEntryRowCount(ENTRYENTITYSEND);
                if (rowCount == 1 && !"3".equals(varhandle)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u552f\u4e00\u7684\u53d1\u9001\u65b9\u79d1\u76ee\u3002", (String)"OffsetRuleSettingPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                if (rowCount != 100) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u9001\u65b9\u6700\u591a\u5305\u542b100\u4e2a\u79d1\u76ee\uff0c\u8bf7\u5220\u9664\u540e\u518d\u589e\u52a0\u3002", (String)"OffsetRuleSettingPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "newentry2": {
                rowCount = this.getModel().getEntryRowCount(ENTRYENTITYRECV);
                if (rowCount == 1 && !"3".equals(varhandle)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u552f\u4e00\u7684\u63a5\u6536\u65b9\u79d1\u76ee\u3002", (String)"OffsetRuleSettingPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                if (rowCount != 100) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u63a5\u6536\u65b9\u6700\u591a\u5305\u542b100\u4e2a\u79d1\u76ee\uff0c\u8bf7\u5220\u9664\u540e\u518d\u589e\u52a0\u3002", (String)"OffsetRuleSettingPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "deleteentry": {
                index = this.getModel().getEntryCurrentRowIndex(ENTRYENTITYSEND);
                if (index != -1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u6210\u672c\u8d39\u7528\u79d1\u76ee\u3002", (String)"OffsetRuleSettingPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "deleteentry2": {
                index = this.getModel().getEntryCurrentRowIndex(ENTRYENTITYRECV);
                if (index != -1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u6210\u672c\u8d39\u7528\u79d1\u76ee\u3002", (String)"OffsetRuleSettingPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "close": {
                if (!Boolean.parseBoolean(this.getPageCache().get("dataChange"))) break;
                args.setCancel(true);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6709\u672a\u4fdd\u5b58\u7684\u66f4\u6539\u5185\u5bb9\u3002\u82e5\u76f4\u63a5\u9000\u51fa\uff0c\u8fd9\u4e9b\u66f4\u6539\u5c06\u4e22\u5931\uff0c\u786e\u8ba4\u9000\u51fa\uff1f", (String)"OffsetRuleSettingPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Save, new ConfirmCallBackListener("dataChange_comfirm", (IFormPlugin)this));
                break;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        Long modelId = model.getLong("id");
        Long busModelId = this.getBaseDataId(this.getModel(), "busmodel");
        MemberF7Parameter f7Param = null;
        if (key.equals(CTRL_KEY_DESTAUDITTRAIL) || key.equals(CTRL_KEY_AUDITTRAIL)) {
            QFilter filter = null;
            if (key.equals(CTRL_KEY_DESTAUDITTRAIL)) {
                filter = new QFilter("use", "=", (Object)AuditTrailUseEnum.AUTO_OFFSET.getCode());
            } else if (key.equals(CTRL_KEY_AUDITTRAIL)) {
                filter = new QFilter("use", "!=", (Object)AuditTrailUseEnum.AUTO_OFFSET.getCode());
            } else if (key.equals(CTRL_KEY_CURRENCY)) {
                // empty if block
            }
            f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.AuditTrail.getNumber()), (String)ListSelectedRow.class.getName());
            f7Param.setPermType(DimMembPermType.WRITE);
            f7Param.addCustomFilter(filter);
        } else if (key.equals(CTRL_KEY_CURRENCY)) {
            f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.Currency.getNumber()), (String)ListSelectedRow.class.getName());
        }
        if (f7Param != null) {
            f7Param.setBusModelId(busModelId);
            f7Param.setOnlySelLeaf(true);
            NewF7Utils.openF7((BeforeF7SelectEvent)e, (MemberF7Parameter)f7Param);
        }
        if (key.equals(ENTITYVIEW)) {
            Long viewId;
            List viewIds;
            List qFilters = e.getCustomQFilters();
            qFilters.add(new QFilter("model", "=", (Object)modelId));
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            Map viewGroup = modelCache.getViewGroupViewsByBusModel(busModelId);
            if (MapUtils.isNotEmpty((Map)viewGroup) && CollectionUtils.isNotEmpty((Collection)(viewIds = (List)viewGroup.get(SysDimensionEnum.Entity.getNumber())))) {
                qFilters.add(new QFilter("id", "in", (Object)viewIds));
            }
            if (IDUtils.isNotEmptyLong((Long)(viewId = this.getViewId())).booleanValue()) {
                ((ListShowParameter)e.getFormShowParameter()).setSelectedRow((Object)viewId);
            }
        }
    }

    public String getCurrentDimNumber(String controlKey) {
        String dimNumber = null;
        switch (controlKey) {
            case "audittrail": 
            case "destaudittrail": {
                dimNumber = SysDimensionEnum.AuditTrail.getNumber();
                break;
            }
            case "currency": {
                dimNumber = SysDimensionEnum.Currency.getNumber();
                break;
            }
        }
        return dimNumber;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "sendaccount": {
                this.openAccountF7(key, !"3".equals(this.getModel().getValue("varhandle")), (String)this.getModel().getValue("metriclist"));
                break;
            }
            case "acceptaccount": {
                this.openAccountF7(key, !"3".equals(this.getModel().getValue("varhandle")), (String)this.getModel().getValue("metriclist"));
                break;
            }
            case "varaccount": {
                this.openAccountF7(key, true, (String)this.getModel().getValue("metriclist"));
                break;
            }
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        switch (evt.getItemKey()) {
            case "btn_save": {
                if (BusinessModelServiceHelper.checkExistDim((IModelCacheHelper)this.getIModelCacheHelper(), (Long)this.getBusModelId(), (String)"InternalCompany")) break;
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u6a21\u578b\u6ca1\u6709\u5173\u8054\u5f80\u6765\u7ec4\u7ec7\u7ef4\u5ea6\uff0c\u8bf7\u5728\u4e1a\u52a1\u6a21\u578b\u5173\u8054\u5f80\u6765\u7ec4\u7ec7\u7ef4\u5ea6\u3002", (String)"OffsetExecutor_3", (String)"epm-eb-business", (Object[])new Object[0]), Integer.valueOf(2000));
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("btn_save".equals(key)) {
            this.deleteInvalidLine();
            if (!this.checkOrg()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u542f\u7528\u5408\u5e76\u8303\u56f4\u7ec4\u7ec7\uff0c\u8bf7\u81f3\u5c11\u542f\u7528\u4e00\u4e2a\u3002", (String)"OffsetRuleSettingPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.saveOffsetRule();
        }
    }

    private boolean checkOrg() {
        List<Long> orgList = this.mergeOrgSelected();
        return orgList.size() != 0;
    }

    private void deleteInvalidLine() {
        DynamicObjectCollection send = this.getModel().getEntryEntity(ENTRYENTITYSEND);
        DynamicObjectCollection recv = this.getModel().getEntryEntity(ENTRYENTITYRECV);
        send.removeIf(a -> StringUtils.isEmpty((String)a.getString("sendnumber")));
        recv.removeIf(a -> StringUtils.isEmpty((String)a.getString("acceptnumber")));
        this.getModel().updateEntryCache(send);
        this.getModel().updateEntryCache(recv);
        this.getView().updateView(ENTRYENTITYSEND);
        this.getView().updateView(ENTRYENTITYRECV);
    }

    private boolean isExsitSaveRule(Long id) {
        String entityName = "eb_offsetrule";
        QFilter filter = new QFilter("id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        return QueryServiceHelper.exists((String)entityName, (QFilter[])filters);
    }

    private void saveOffsetRule() {
        if (!(this.validate() && this.validate1() && this.valiDrcrdirect())) {
            return;
        }
        IDataModel iDataModel = this.getModel();
        OffsetRule offsetRule = this.getOffsetRule();
        Long id = offsetRule.getId();
        List<Long> orgList = this.mergeOrgSelected();
        DynamicObject offsetRuleObj = this.isExsitSaveRule(id) ? BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_offsetrule") : BusinessDataServiceHelper.newDynamicObject((String)"eb_offsetrule");
        this.setRuleInfo(offsetRule, offsetRuleObj);
        DynamicObjectCollection accounts = (DynamicObjectCollection)offsetRuleObj.get("accounts");
        accounts.clear();
        List<DynamicObject> objectList = this.saveOffsetRuleAcounts(accounts.getDynamicObjectType());
        if (objectList.size() > 0) {
            accounts.addAll(objectList);
        }
        offsetRuleObj.set("accounts", (Object)accounts);
        DynamicObjectCollection orgs = (DynamicObjectCollection)offsetRuleObj.get("orgs");
        orgs.clear();
        this.fillOrgsToBill(orgs, orgList);
        offsetRuleObj.set("orgs", (Object)orgs);
        this.setOffsetRuleValue(offsetRuleObj, offsetRule, iDataModel);
        DynamicObject[] dynamicObjects = new DynamicObject[]{offsetRuleObj};
        try {
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            this.addDimMemberQuote(offsetRuleObj);
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "OffsetRuleSettingPlugin_7", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u7f16\u53f7\u201c%1$s\u201d\uff0c\u4fdd\u5b58\u6210\u529f\u3002", "AbstractBasePlugin_11", "epm-eb-formplugin");
            String[] opDescArgs = new String[]{offsetRuleObj.getString("number")};
            this.writeLog(offsetRuleObj.getString("number"), "save", opName, opDesc, opDescArgs);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"OffsetRuleSettingPlugin_44", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getPageCache().put("dataChange", "false");
        }
        catch (Exception e) {
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "OffsetRuleSettingPlugin_7", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u7f16\u53f7\u201c%1$s\u201d\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", "AbstractBasePlugin_12", "epm-eb-formplugin");
            String[] opDescArgs = new String[]{offsetRuleObj.getString("number")};
            this.writeLog(offsetRuleObj.getString("number"), "save", opName, opDesc, opDescArgs);
            throw new KDBizException(e.getMessage());
        }
    }

    private void addDimMemberQuote(DynamicObject offsetRule) {
        String varAccount;
        List<String> accountNumbers;
        String currencyNumber;
        String atNumberTar;
        Member member;
        String atNumber;
        Dimension dimension;
        if (offsetRule == null) {
            return;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Long modelId = this.getModelId();
        Long offsetRuleId = offsetRule.getLong("id");
        Long busModelId = offsetRule.getLong("busmodel_id");
        Map dimensionMap = modelCacheHelper.getDimensionMap();
        ArrayList<MemberQuoteDao> quotes = new ArrayList<MemberQuoteDao>(16);
        List<String> orgList = this.mergeOrgNumber();
        if (orgList.size() > 0) {
            dimension = (Dimension)dimensionMap.get(SysDimensionEnum.Entity.getNumber());
            Long orgViewId = this.getBaseDataId(this.getModel(), ENTITYVIEW);
            quotes.add(new MemberQuoteDao(modelId, busModelId, dimension.getId(), (Collection)dimension.getMemberId(orgViewId, orgList), MemberQuoteResourceEnum.OffsetRule, offsetRuleId));
        }
        if ((atNumber = this.getBaseDataNumber(CTRL_KEY_AUDITTRAIL)) != null && (member = (dimension = (Dimension)dimensionMap.get(SysDimensionEnum.AuditTrail.getNumber())).getMember(atNumber)) != null) {
            quotes.add(new MemberQuoteDao(modelId, busModelId, dimension.getId(), member.getId(), MemberQuoteResourceEnum.OffsetRule, offsetRuleId));
        }
        if ((atNumberTar = this.getBaseDataNumber(CTRL_KEY_DESTAUDITTRAIL)) != null && (member = (dimension = (Dimension)dimensionMap.get(SysDimensionEnum.AuditTrail.getNumber())).getMember(atNumberTar)) != null) {
            quotes.add(new MemberQuoteDao(modelId, busModelId, dimension.getId(), member.getId(), MemberQuoteResourceEnum.OffsetRule, offsetRuleId));
        }
        if ((currencyNumber = this.getBaseDataNumber(CTRL_KEY_CURRENCY)) != null && (member = (dimension = (Dimension)dimensionMap.get(SysDimensionEnum.Currency.getNumber())).getMember(currencyNumber)) != null) {
            quotes.add(new MemberQuoteDao(modelId, busModelId, dimension.getId(), member.getId(), MemberQuoteResourceEnum.OffsetRule, offsetRuleId));
        }
        if ((accountNumbers = this.getAcountsNumber()) != null && accountNumbers.size() > 0) {
            dimension = (Dimension)dimensionMap.get(SysDimensionEnum.Account.getNumber());
            quotes.add(new MemberQuoteDao(modelId, busModelId, dimension.getId(), (Collection)dimension.getMemberId(accountNumbers), MemberQuoteResourceEnum.OffsetRule, offsetRuleId));
        }
        if ((varAccount = this.getBaseDataNumber("varaccountid")) != null && (member = (dimension = (Dimension)dimensionMap.get(SysDimensionEnum.Account.getNumber())).getMember(varAccount)) != null) {
            quotes.add(new MemberQuoteDao(modelId, busModelId, dimension.getId(), member.getId(), MemberQuoteResourceEnum.OffsetRule, offsetRuleId));
        }
        LinkedHashSet<Long> memberIds = new LinkedHashSet<Long>();
        dimension = (Dimension)dimensionMap.get(SysDimensionEnum.Metric.getNumber());
        String metricNumber = this.getBaseDataNumber("metric");
        if (metricNumber != null && (member = dimension.getMember(metricNumber)) != null) {
            memberIds.add(member.getId());
        }
        if ((metricNumber = this.getBaseDataNumber("metricqty")) != null && (member = dimension.getMember(metricNumber)) != null) {
            memberIds.add(member.getId());
        }
        if (StringUtils.isNotEmpty((String)(metricNumber = (String)this.getModel().getValue("metriclist")))) {
            String[] _metrics = metricNumber.split(",");
            int in = _metrics.length;
            for (int i = 0; i < in; ++i) {
                member = dimension.getMember(_metrics[i].trim());
                if (member == null) continue;
                memberIds.add(member.getId());
            }
        }
        if (!memberIds.isEmpty()) {
            quotes.add(new MemberQuoteDao(modelId, busModelId, dimension.getId(), memberIds, MemberQuoteResourceEnum.OffsetRule, offsetRuleId));
        }
        if (quotes.size() > 0) {
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
        }
    }

    private List<String> getAcountsNumber() {
        ArrayList<String> list = new ArrayList<String>(16);
        DynamicObjectCollection send = this.getModel().getEntryEntity(ENTRYENTITYSEND);
        DynamicObjectCollection recv = this.getModel().getEntryEntity(ENTRYENTITYRECV);
        for (DynamicObject dynamicObject : send) {
            list.add(dynamicObject.getString("sendnumber"));
        }
        for (DynamicObject dynamicObject : recv) {
            list.add(dynamicObject.getString("acceptnumber"));
        }
        return list;
    }

    private void setRuleInfo(OffsetRule offsetRule, DynamicObject offsetRuleObj) {
        offsetRuleObj.set("id", (Object)offsetRule.getId());
        offsetRuleObj.set("name", (Object)offsetRule.getName());
        offsetRuleObj.set("number", (Object)offsetRule.getNumber());
        offsetRuleObj.set("description", (Object)offsetRule.getDescription());
        offsetRuleObj.set("offsetrulecatalog", (Object)offsetRule.getCatalogID());
        if (offsetRuleObj.get("creator") == null) {
            offsetRuleObj.set("creator", (Object)UserUtils.getUserId());
            offsetRuleObj.set("createtime", (Object)TimeServiceHelper.now());
        }
        offsetRuleObj.set("modifier", (Object)UserUtils.getUserId());
        offsetRuleObj.set("modifytime", (Object)TimeServiceHelper.now());
        if (offsetRuleObj.get("enable") == null) {
            offsetRuleObj.set("enable", (Object)1);
        }
    }

    private List<Long> mergeOrgSelected() {
        DynamicObjectCollection selectedList = this.getModel().getEntryEntity(TREENTRYENTITY);
        ArrayList<Long> orgList = new ArrayList<Long>(16);
        if (selectedList == null || selectedList.size() == 0) {
            return orgList;
        }
        for (DynamicObject dynamicObject : selectedList) {
            if (dynamicObject.get("enable") == null || !Boolean.parseBoolean(dynamicObject.get("enable").toString())) continue;
            orgList.add(Long.parseLong(dynamicObject.get("orgid").toString()));
        }
        return orgList;
    }

    private List<String> mergeOrgNumber() {
        DynamicObjectCollection selectedList = this.getModel().getEntryEntity(TREENTRYENTITY);
        ArrayList<String> orgNumberList = new ArrayList<String>(16);
        if (selectedList == null || selectedList.size() == 0) {
            return orgNumberList;
        }
        for (DynamicObject dynamicObject : selectedList) {
            if (dynamicObject.get("enable") == null || !Boolean.parseBoolean(dynamicObject.get("enable").toString())) continue;
            orgNumberList.add(dynamicObject.getString("orgnumber"));
        }
        return orgNumberList;
    }

    private void fillOrgsToBill(DynamicObjectCollection Orgs, List<Long> orgSelected) {
        DynamicObjectType dynamicObjectType = Orgs.getDynamicObjectType();
        for (Long orgId : orgSelected) {
            DynamicObject org = new DynamicObject(dynamicObjectType);
            org.set("org", (Object)orgId);
            Orgs.add((Object)org);
        }
    }

    private void setOffsetRuleValue(DynamicObject offsetRuleObj, OffsetRule offsetRule, IDataModel iDataModel) {
        offsetRuleObj.set("model", (Object)offsetRule.getModelID());
        offsetRuleObj.set("busmodel", (Object)offsetRule.getBusmodelID());
        offsetRuleObj.set("offsetrulecatalog", (Object)offsetRule.getCatalogID());
        offsetRuleObj.set(CTRL_KEY_AUDITTRAIL, (Object)this.getBaseDataId(iDataModel, CTRL_KEY_AUDITTRAIL));
        offsetRuleObj.set(CTRL_KEY_DESTAUDITTRAIL, (Object)this.getBaseDataId(iDataModel, CTRL_KEY_DESTAUDITTRAIL));
        offsetRuleObj.set(CTRL_KEY_CURRENCY, (Object)this.getBaseDataId(iDataModel, CTRL_KEY_CURRENCY));
        offsetRuleObj.set(ENTITYVIEW, (Object)this.getBaseDataId(iDataModel, ENTITYVIEW));
        if (this.moneyMetricSelected()) {
            offsetRuleObj.set("metric", (Object)this.getMetricMap().get(MONEY));
        } else {
            offsetRuleObj.set("metric", null);
        }
        if (this.amountMetricSelected()) {
            offsetRuleObj.set("metricqty", (Object)this.getMetricMap().get(AMOUNT));
        } else {
            offsetRuleObj.set("metricqty", null);
        }
        String index = (String)iDataModel.getValue("varhandle");
        if ("3".equals(index)) {
            offsetRuleObj.set(VARACCOUNT, (Object)this.getBaseDataId(iDataModel, "varaccountid"));
        }
        offsetRuleObj.set("varhandle", (Object)((String)iDataModel.getValue("varhandle")));
        if (iDataModel.getValue(ASSISTDIM) != null) {
            String[] selectItem = iDataModel.getValue(ASSISTDIM).toString().split(",");
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < selectItem.length; ++i) {
                if ("".equals(selectItem[i])) continue;
                str.append(selectItem[i]);
                if (i >= selectItem.length - 1) continue;
                str.append(",");
            }
            offsetRuleObj.set(ASSISTDIM, (Object)str.toString());
        } else {
            offsetRuleObj.set(ASSISTDIM, (Object)"");
        }
        offsetRuleObj.set("unilateral", (Object)((Boolean)iDataModel.getValue("checkunilateral") != false ? "1" : "0"));
    }

    private Long getBaseDataId(IDataModel iDataModel, String name) {
        DynamicObject dynamicObject = (DynamicObject)iDataModel.getValue(name);
        return dynamicObject == null ? null : Long.valueOf(dynamicObject.getLong("id"));
    }

    private String getBaseDataNumber(String name) {
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(name);
        return dynamicObject == null ? null : dynamicObject.getString("number");
    }

    private OffsetRule getOffsetRule() {
        OffsetRule offsetRule = (OffsetRule)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(OFFSETRULE_CACHE));
        if (offsetRule == null) {
            offsetRule = new OffsetRule();
        }
        return offsetRule;
    }

    private List<DynamicObject> saveOffsetRuleAcounts(DynamicObjectType dynamicObjectType) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
        DynamicObjectCollection send = this.getModel().getEntryEntity(ENTRYENTITYSEND);
        DynamicObjectCollection recv = this.getModel().getEntryEntity(ENTRYENTITYRECV);
        for (DynamicObject dynamicObject : send) {
            DynamicObject saveSend = new DynamicObject(dynamicObjectType);
            saveSend.set("account", (Object)dynamicObject.getLong("sendaccountid"));
            saveSend.set("senderaccount", (Object)true);
            list.add(saveSend);
        }
        for (DynamicObject dynamicObject : recv) {
            DynamicObject recvSend = new DynamicObject(dynamicObjectType);
            recvSend.set("account", (Object)dynamicObject.getLong("acceptaccountid"));
            recvSend.set("senderaccount", (Object)false);
            list.add(recvSend);
        }
        return list;
    }

    private boolean validate() {
        DynamicObjectCollection send = this.getModel().getEntryEntity(ENTRYENTITYSEND);
        DynamicObjectCollection recv = this.getModel().getEntryEntity(ENTRYENTITYRECV);
        String varhandle = this.getModel().getValue("varhandle").toString();
        if (send.size() == 0 && recv.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e24\u4e2a\u5206\u5f55\u4e2d\u81f3\u5c11\u6709\u4e00\u4e2a\u5206\u5f55\u5fc5\u987b\u6709\u79d1\u76ee\u3002", (String)"OffsetRuleSettingPlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!(send.size() != 0 && recv.size() != 0 || "3".equals(varhandle) && this.getModel().getValue("varaccountid") != null)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5dee\u5f02\u5904\u7406\u4e3a\u53d6\u5927\u6216\u53d6\u5c0f\u65f6\uff0c\u53d1\u9001\u65b9\u79d1\u76ee\u548c\u63a5\u6536\u65b9\u79d1\u76ee\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"OffsetRuleSettingPlugin_46", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean valiDrcrdirect() {
        if (!this.moneyMetricSelected()) {
            return true;
        }
        DynamicObjectCollection send = this.getModel().getEntryEntity(ENTRYENTITYSEND);
        DynamicObjectCollection recv = this.getModel().getEntryEntity(ENTRYENTITYRECV);
        int sendRow = this.isDrcrdirect(send, "sendaccountid");
        int recvRow = this.isDrcrdirect(recv, "acceptaccountid");
        if (sendRow != -1) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u53d1\u9001\u65b9\u79d1\u76ee\u7b2c%1\u884c\u6570\u636e\u501f\u8d37\u7c7b\u578b\u4e0d\u4e3a\u501f\u6216\u8d37\u3002", (String)"OffsetRuleSettingPlugin_11_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{sendRow}));
            return false;
        }
        if (recvRow != -1) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u63a5\u6536\u65b9\u79d1\u76ee\u7b2c%1\u884c\u6570\u636e\u501f\u8d37\u7c7b\u578b\u5e94\u4e3a\u501f\u6216\u8d37\u3002", (String)"OffsetRuleSettingPlugin_13_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{recvRow}));
            return false;
        }
        String varhandle = this.getModel().getValue("varhandle").toString();
        if ("3".equals(varhandle)) {
            String dirct;
            String string = dirct = this.getModel().getValue("varaccountid") == null ? "" : ((DynamicObject)this.getModel().getValue("varaccountid")).getString("drcrdirect");
            if (!"5".equals(dirct) && !"6".equals(dirct)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5dee\u989d\u9879\u79d1\u76ee\u501f\u8d37\u7c7b\u578b\u4e0d\u4e3a\u501f\u6216\u8d37\u3002", (String)"OffsetRuleSettingPlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            HashSet<Integer> sendSet = new HashSet<Integer>();
            for (Object dynamicObject : send) {
                long sendaccountid = dynamicObject.getLong("sendaccountid");
                DynamicObject dynamicObjects = QueryServiceHelper.queryOne((String)"epm_accountmembertree", (String)"id,drcrdirect", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sendaccountid)});
                if (dynamicObjects == null) continue;
                sendSet.add(dynamicObjects.getInt("drcrdirect"));
            }
            if (sendSet.size() >= 2) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u9001\u65b9\u79d1\u76ee\u7684\u501f\u8d37\u65b9\u5411\u9700\u4e00\u81f4\u3002", (String)"OffsetRuleSettingPlugin_60", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            HashSet<Integer> acceptSet = new HashSet<Integer>();
            for (DynamicObject dynamicObject : recv) {
                long acceptaccountid = dynamicObject.getLong("acceptaccountid");
                DynamicObject dynamicObjects = QueryServiceHelper.queryOne((String)"epm_accountmembertree", (String)"id,drcrdirect", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)acceptaccountid)});
                if (dynamicObjects == null) continue;
                acceptSet.add(dynamicObjects.getInt("drcrdirect"));
            }
            if (acceptSet.size() >= 2) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u63a5\u6536\u65b9\u79d1\u76ee\u7684\u501f\u8d37\u65b9\u5411\u9700\u4e00\u81f4\u3002", (String)"OffsetRuleSettingPlugin_61", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (acceptSet.size() > 0 && sendSet.size() > 0) {
                ArrayList sendDrcrdirect = new ArrayList(sendSet);
                ArrayList acceptDrcrdirect = new ArrayList(acceptSet);
                if (((Integer)sendDrcrdirect.get(0)).equals(acceptDrcrdirect.get(0))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u9001\u65b9\u79d1\u76ee\u548c\u63a5\u6536\u65b9\u79d1\u76ee\u7684\u501f\u8d37\u65b9\u5411\u9700\u76f8\u53cd\u3002", (String)"OffsetRuleSettingPlugin_62", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return false;
                }
            }
        } else {
            HashSet accountIds = new HashSet(16);
            send.forEach(e -> accountIds.add(e.getLong("sendaccountid")));
            recv.forEach(e -> accountIds.add(e.getLong("acceptaccountid")));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"epm_accountmembertree", (String)"id,drcrdirect", (QFilter[])new QFilter[]{new QFilter("id", "in", accountIds)});
            int direct = -1;
            for (DynamicObject d : dynamicObjects) {
                if (d.getInt("drcrdirect") == direct) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u9001\u65b9\u79d1\u76ee\u548c\u63a5\u6536\u65b9\u79d1\u76ee\u7684\u501f\u8d37\u65b9\u5411\u9700\u76f8\u53cd\u3002", (String)"OffsetRuleSettingPlugin_62", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return false;
                }
                direct = d.getInt("drcrdirect");
            }
        }
        return true;
    }

    private boolean moneyMetricSelected() {
        return (this.getModel().getValue("metriclist") + "").contains(MONEY);
    }

    private boolean amountMetricSelected() {
        return (this.getModel().getValue("metriclist") + "").contains(AMOUNT);
    }

    private String[] getMetrics() {
        return (this.getModel().getValue("metriclist") + "").split(",");
    }

    private int isDrcrdirect(DynamicObjectCollection accounts, String id) {
        int row = -1;
        HashMap<Long, Integer> map = new HashMap<Long, Integer>(16);
        for (DynamicObject account : accounts) {
            map.put(account.getLong(id), Integer.valueOf(account.getString("seq")));
        }
        QFilter qFilter1 = new QFilter("id", "in", map.keySet());
        QFilter qFilter2 = new QFilter("drcrdirect", "=", (Object)"0");
        QFilter[] qFilters = new QFilter[]{qFilter1, qFilter2};
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_accountmembertree", (String)"id,drcrdirect", (QFilter[])qFilters);
        if (dynamicObject != null) {
            return (Integer)map.get(dynamicObject.getLong("id"));
        }
        return row;
    }

    private List<String> offsetRuleAcounts() {
        ArrayList<String> list = new ArrayList<String>(16);
        DynamicObjectCollection send = this.getModel().getEntryEntity(ENTRYENTITYSEND);
        DynamicObjectCollection recv = this.getModel().getEntryEntity(ENTRYENTITYRECV);
        for (DynamicObject dynamicObject : send) {
            list.add(dynamicObject.getString("sendaccountid"));
        }
        for (DynamicObject dynamicObject : recv) {
            list.add(dynamicObject.getString("acceptaccountid"));
        }
        return list;
    }

    private boolean validate1() {
        ArrayList<String> orgIds = new ArrayList<String>(16);
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(TREENTRYENTITY);
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (!dynamicObject.getBoolean("enable")) continue;
            orgIds.add(dynamicObject.getString("orgid"));
        }
        if (orgIds.size() == 0) {
            return true;
        }
        Map<String, List<DynamicObject>> map = this.getEnableOrgsFormOthers();
        Set<String> ruleIds = this.getRulesWithConflictOrg(map, orgIds);
        if (ruleIds == null || ruleIds.isEmpty()) {
            return true;
        }
        for (String ruleId : ruleIds) {
            HashSet<String> accountIds = new HashSet<String>(16);
            for (DynamicObject dynamicObject : map.get(ruleId)) {
                accountIds.add(dynamicObject.getString("accounts.account.id"));
            }
            for (String offsetRuleAcount : this.offsetRuleAcounts()) {
                if (!accountIds.contains(offsetRuleAcount)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u67d0\u4e9b\u79d1\u76ee\u5728\u5176\u4ed6\u89c4\u5219\u7684\u540c\u4e00\u5408\u5e76\u8303\u56f4\u4e0b\u5df2\u5b58\u5728\u3002", (String)"OffsetRuleSettingPlugin_49", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private Set<String> getRulesWithConflictOrg(Map<String, List<DynamicObject>> map, List<String> orgIds) {
        HashSet<String> ruleIds = new HashSet<String>(16);
        for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
            for (DynamicObject dynamicObject : entry.getValue()) {
                if (!orgIds.contains(dynamicObject.getString("orgs.org.id"))) continue;
                ruleIds.add(entry.getKey());
            }
        }
        return ruleIds;
    }

    private Map<String, List<DynamicObject>> getEnableOrgsFormOthers() {
        HashMap<String, List<DynamicObject>> map = new HashMap<String, List<DynamicObject>>(16);
        OffsetRule offsetRule = this.getOffsetRule();
        Long id = offsetRule.getId();
        List<DynamicObject> list = null;
        String entityName = "eb_offsetrule";
        String selectedFiled = "id,orgs.org.id,orgs.org.name,accounts.account.id,accounts.account.name";
        QFilter filter = new QFilter("model", "=", (Object)((DynamicObject)this.getModel().getValue("model")).getLong("id"));
        QFilter filter1 = null;
        if (id != null) {
            filter1 = new QFilter("id", "!=", (Object)id);
        }
        filter = filter1 == null ? filter : filter.and(filter1);
        QFilter fMetric = null;
        QFilter fMetricqty = null;
        if (this.moneyMetricSelected()) {
            fMetric = new QFilter("metric", "=", (Object)Long.valueOf(this.getMetricMap().get(MONEY)));
        }
        if (this.amountMetricSelected()) {
            fMetricqty = new QFilter("metricqty", "=", (Object)Long.valueOf(this.getMetricMap().get(AMOUNT)));
        }
        if (fMetric != null && fMetricqty != null) {
            filter = filter.and(fMetric.or(fMetricqty));
        } else if (fMetric != null || fMetricqty != null) {
            filter = filter.and(fMetric != null ? fMetric : fMetricqty);
        }
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)entityName, (String)selectedFiled, (QFilter[])filters);
        for (DynamicObject dc : dcs) {
            if (map.containsKey(dc.getString("id"))) {
                list = (List)map.get(dc.getString("id"));
                list.add(dc);
            } else {
                list = new ArrayList<DynamicObject>(16);
                list.add(dc);
            }
            map.put(dc.getString("id"), list);
        }
        return map;
    }

    private DynamicObject queryAccountInfo() {
        String entityName = "epm_dimension";
        String selectFields = "id,number,name,dseq";
        QFilter fmodelid = new QFilter("model", "=", (Object)this.getModelId());
        QFilter fnumber = new QFilter("number", "=", (Object)"Account");
        QFilter[] filters = new QFilter[]{fmodelid, fnumber};
        return QueryServiceHelper.queryOne((String)entityName, (String)selectFields, (QFilter[])filters);
    }

    private Map<String, DynamicObjectCollection> queryRuleDataById(Long id) {
        String entityName = "eb_offsetrule";
        String selectFields = "audittrail.id,destaudittrail.id,metric.id,metricqty.id,currency.id,assistdim,varhandle,varaccount.id,varaccount.name,accounts.account.id,accounts.account.number,accounts.account.name,accounts.account.isleaf,accounts.senderaccount,unilateral";
        String selectFields1 = "orgs.org.id";
        QFilter filter = new QFilter("id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection accounts = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters);
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)entityName, (String)selectFields1, (QFilter[])filters);
        HashMap<String, DynamicObjectCollection> result = new HashMap<String, DynamicObjectCollection>(16);
        result.put("accounts", accounts);
        result.put("orgs", orgs);
        return result;
    }

    private void openAccountF7(String contrlKey, Boolean onlyAllowLeaf, String metrics) {
        Long bizRangeId;
        DynamicObject dynamicObject;
        String number;
        Long id;
        List<Long> echoId = null;
        if (CTRL_KEY_SENDACCOUNT.equals(contrlKey)) {
            int index = this.getModel().getEntryCurrentRowIndex(ENTRYENTITYSEND);
            DynamicObjectCollection send = this.getModel().getEntryEntity(ENTRYENTITYSEND);
            if (index >= 0 && send != null && send.size() > index) {
                id = ((DynamicObject)send.get(index)).getLong("sendaccountid");
                number = ((DynamicObject)send.get(index)).getString("sendnumber");
                if (IDUtils.isNotNull((Long)id) && StringUtils.isNotEmpty((String)number)) {
                    echoId = Collections.singletonList(id);
                }
            }
        } else if (CTRL_KEY_ACCEPTACCOUNT.equals(contrlKey)) {
            int index = this.getModel().getEntryCurrentRowIndex(ENTRYENTITYRECV);
            DynamicObjectCollection recv = this.getModel().getEntryEntity(ENTRYENTITYRECV);
            if (index >= 0 && recv != null && recv.size() > index) {
                id = ((DynamicObject)recv.get(index)).getLong("acceptaccountid");
                number = ((DynamicObject)recv.get(index)).getString("acceptnumber");
                if (IDUtils.isNotNull((Long)id) && StringUtils.isNotEmpty((String)number)) {
                    echoId = Collections.singletonList(id);
                }
            }
        } else if (VARACCOUNT.equals(contrlKey) && (dynamicObject = (DynamicObject)this.getModel().getValue("varaccountid")) != null) {
            echoId = Collections.singletonList(dynamicObject.getLong("id"));
        }
        Long modelId = this.getModelId();
        Long busModelId = Long.parseLong(this.getPageCache().get("KEY_BUSMODEL_ID"));
        QFilter qFilter = new QFilter("model.id", "=", (Object)modelId).and(new QFilter("dataset.businessmodel.id", "=", (Object)busModelId));
        QFilter dimQf = this.getDimQfilter(this.getAssistdim(), busModelId);
        if (dimQf != null) {
            qFilter.and(dimQf);
        }
        if ((bizRangeId = this.getBaseDataId(this.getModel(), "busmodel")) == null) {
            bizRangeId = 0L;
        }
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.Account.getNumber()), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(bizRangeId);
        f7Param.setDatasetIds(BusinessModelServiceHelper.getInstance().queryDataSetIds(f7Param.getBusModelId()));
        if (echoId != null && !echoId.isEmpty()) {
            f7Param.setSelectIds(new HashSet<Long>(echoId));
        }
        f7Param.setPermType(DimMembPermType.WRITE);
        String closeBackKey = contrlKey;
        if (onlyAllowLeaf.booleanValue()) {
            if (StringUtils.isNotEmpty((String)metrics)) {
                QFilter qFilter2;
                if (metrics.contains(MONEY)) {
                    qFilter.and("drcrdirect", "!=", (Object)"0");
                }
                if ((qFilter2 = this.getMetricQfilter(metrics, modelId, busModelId)) != null) {
                    qFilter.and(qFilter2);
                }
            }
            f7Param.addCustomFilter(Collections.singletonList(qFilter));
            f7Param.setOnlySelLeaf(true);
        } else {
            f7Param.addCustomFilter(Collections.singletonList(qFilter));
            f7Param.setMultiSelect(true);
            closeBackKey = contrlKey + "multi";
        }
        f7Param.setShowDebitAndCredit(true);
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, closeBackKey));
    }

    private QFilter getDimQfilter(List<String> dims, Long busModelId) {
        if (dims.size() == 0) {
            return null;
        }
        QFilter qFilter = new QFilter("dataset.businessmodel.id", "=", (Object)busModelId);
        QFilter qFilter1 = new QFilter("dataset.entryentity.datasetdim.number", "in", dims);
        HashMap account = new HashMap(16);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"query_Account", (String)"epm_accountmembertree", (String)"id,dataset.entryentity.datasetdim.number", (QFilter[])new QFilter[]{qFilter, qFilter1}, (String)"dseq asc");
        if (!ds.isEmpty()) {
            for (Row row : ds) {
                Set<String> set;
                if (account.get(row.getLong("id")) == null) {
                    set = new HashSet<String>(16);
                    set.add(row.getString("dataset.entryentity.datasetdim.number"));
                    account.put(row.getLong("id"), set);
                    continue;
                }
                set = (Set)account.get(row.getLong("id"));
                set.add(row.getString("dataset.entryentity.datasetdim.number"));
                account.put(row.getLong("id"), set);
            }
        }
        ArrayList ids = new ArrayList(16);
        if (account.size() > 0) {
            for (Map.Entry entry : account.entrySet()) {
                if (!((Set)entry.getValue()).containsAll(dims)) continue;
                ids.add(entry.getKey());
            }
        }
        if (ids.size() > 0) {
            return new QFilter("id", "in", ids);
        }
        return new QFilter("id", "=", (Object)-1);
    }

    private QFilter getMetricQfilter(String metrics, Long modelId, Long busModelId) {
        String[] metricArr;
        if (',' == metrics.charAt(0)) {
            metrics = metrics.substring(1);
        }
        if ((metricArr = metrics.split(",")).length == 1) {
            if (MONEY.equals(metricArr[0])) {
                return new QFilter("entryentity.metric.number", "=", (Object)metricArr[0]).and(new QFilter("drcrdirect", "in", (Object)new String[]{"5", "6"}));
            }
            return new QFilter("entryentity.metric.number", "=", (Object)metricArr[0]);
        }
        if (metricArr.length == 2) {
            List<String> list = Arrays.asList(metricArr);
            QFilter qFilter = new QFilter("model.id", "=", (Object)modelId).and(new QFilter("dataset.businessmodel.id", "=", (Object)busModelId));
            QFilter qFilter1 = new QFilter("entryentity.metric.number", "in", list);
            HashMap account = new HashMap(16);
            ArrayList<Long> ids = new ArrayList<Long>(16);
            DataSet ds = QueryServiceHelper.queryDataSet((String)"query_Account", (String)"epm_accountmembertree", (String)"id,entryentity.metric.number,drcrdirect", (QFilter[])new QFilter[]{qFilter, qFilter1}, (String)"dseq asc");
            if (!ds.isEmpty()) {
                for (Row row : ds) {
                    Set<String> set;
                    String drcrdirect = row.getString("drcrdirect");
                    if (account.get(row.getLong("id")) == null) {
                        set = new HashSet<String>(16);
                        set.add(row.getString("entryentity.metric.number"));
                        account.put(row.getLong("id"), set);
                        continue;
                    }
                    set = (Set)account.get(row.getLong("id"));
                    set.add(row.getString("entryentity.metric.number"));
                    account.put(row.getLong("id"), set);
                    if (!set.containsAll(list) || !"5".equals(drcrdirect) && !"6".equals(drcrdirect)) continue;
                    ids.add(row.getLong("id"));
                }
            }
            if (ids.size() > 0) {
                return new QFilter("id", "in", ids);
            }
            return new QFilter("id", "=", (Object)-1);
        }
        return null;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (CTRL_KEY_SENDACCOUNT.equals(closedCallBackEvent.getActionId())) {
            this.fillAccount(closedCallBackEvent, "send");
        }
        if (CTRL_KEY_ACCEPTACCOUNT.equals(closedCallBackEvent.getActionId())) {
            this.fillAccount(closedCallBackEvent, "accept");
        }
        if ("sendaccountmulti".equals(closedCallBackEvent.getActionId())) {
            this.fillAccountBatch(closedCallBackEvent, "send");
        }
        if ("acceptaccountmulti".equals(closedCallBackEvent.getActionId())) {
            this.fillAccountBatch(closedCallBackEvent, "accept");
        }
        if (closedCallBackEvent.getActionId().contains(VARACCOUNT) && closedCallBackEvent.getReturnData() != null) {
            ListSelectedRowCollection list = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (list == null || list.size() == 0) {
                return;
            }
            ListSelectedRow row = list.get(0);
            Map dataMap = row.getDataMap();
            this.getModel().setValue("varaccountid", dataMap.get("id"));
            this.getModel().setValue(VARACCOUNT, dataMap.get("name"));
        }
    }

    private DynamicObjectCollection getAccounts(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        boolean hasMoney = this.moneyMetricSelected();
        boolean hasAmount = this.amountMetricSelected();
        HashSet moneyAccSet = new HashSet(16);
        HashSet amountAccSet = new HashSet(16);
        DynamicObjectCollection collection = null;
        String entityName = "epm_accountmembertree";
        String selects = "id,number,name,parent,dseq,isleaf,level,entryentity.metric.number";
        QFilter qFilter = new QFilter("id", "in", ids);
        QFilter metricFilter = new QFilter("entryentity.metric.number", "in", (Object)new String[]{hasMoney ? MONEY : "", hasAmount ? AMOUNT : ""});
        collection = QueryServiceHelper.query((String)entityName, (String)selects, (QFilter[])new QFilter[]{qFilter, metricFilter});
        if (!hasMoney || !hasAmount) {
            return collection;
        }
        collection.forEach(e -> {
            if (MONEY.equals(e.get("entryentity.metric.number"))) {
                moneyAccSet.add(e.getLong("id"));
            } else if (AMOUNT.equals(e.get("entryentity.metric.number"))) {
                amountAccSet.add(e.getLong("id"));
            }
        });
        moneyAccSet.retainAll(amountAccSet);
        collection.removeIf(e -> !moneyAccSet.contains(e.getLong("id")) || !MONEY.equals(e.getString("entryentity.metric.number")));
        return collection;
    }

    private void fillAccountBatch(ClosedCallBackEvent closedCallBackEvent, String accountType) {
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        ListSelectedRowCollection list = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (list == null || list.size() == 0) {
            return;
        }
        LinkedList<Long> idList = new LinkedList<Long>();
        String entity = null;
        String number = null;
        String name = null;
        String id = null;
        String leaf = null;
        String tipsName = null;
        if ("send".equals(accountType)) {
            entity = ENTRYENTITYSEND;
            number = "sendnumber";
            name = CTRL_KEY_SENDACCOUNT;
            id = "sendaccountid";
            leaf = "isleafsend";
            tipsName = ResManager.loadKDString((String)"\u63a5\u6536\u65b9", (String)"OffsetRuleSettingPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        } else {
            entity = ENTRYENTITYRECV;
            number = "acceptnumber";
            name = CTRL_KEY_ACCEPTACCOUNT;
            id = "acceptaccountid";
            leaf = "isleafrecv";
            tipsName = ResManager.loadKDString((String)"\u53d1\u9001\u65b9", (String)"OffsetRuleSettingPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(entity);
        int[] selectRows = entryGrid.getSelectRows();
        for (ListSelectedRow row : list) {
            Long accountId = IDUtils.toLong((Object)row.getPrimaryKeyValue());
            int sameRow = this.validateEntityRow(accountId, entity, id);
            if (sameRow == -1 && this.validateSendAndRecv(accountId, "send".equals(accountType), false)) {
                idList.add(accountId);
                continue;
            }
            if (sameRow != selectRows[0]) continue;
            idList.add(0, accountId);
        }
        if (idList.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u9001\u65b9\u6216\u63a5\u6536\u65b9\u79d1\u76ee\u5df2\u5b58\u5728\u5168\u90e8\u6240\u9009\u79d1\u76ee\u6216\u79d1\u76ee\u5b50\u7ea7\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"OffsetRuleSettingPlugin_50", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        int size = this.getModel().getEntryEntity(entity).size();
        int maxSize = 0;
        DynamicObjectCollection dynamicObjects = this.getAccounts(idList);
        maxSize = dynamicObjects.size() + size - 1 >= 100 ? 101 - size : dynamicObjects.size();
        for (int i = 0; i < maxSize; ++i) {
            DynamicObject dynamicObject = null;
            if (i == 0) {
                this.getModel().beginInit();
                if (this.getModel().getEntryEntity(entity) != null && this.getModel().getEntryEntity(entity).size() != 0) {
                    this.getModel().deleteEntryRow(entity, selectRows[0]);
                }
                this.getModel().insertEntryRow(entity, selectRows[0]);
                this.getModel().endInit();
                dynamicObject = this.getModel().getEntryRowEntity(entity, selectRows[0]);
            } else {
                this.getModel().beginInit();
                this.getModel().insertEntryRow(entity, selectRows[0] + i);
                this.getModel().endInit();
                dynamicObject = this.getModel().getEntryRowEntity(entity, selectRows[0] + i);
            }
            dynamicObject.set(number, (Object)((DynamicObject)dynamicObjects.get(i)).getString("number"));
            dynamicObject.set(name, (Object)((DynamicObject)dynamicObjects.get(i)).getString("name"));
            dynamicObject.set(id, (Object)((DynamicObject)dynamicObjects.get(i)).getString("id"));
            dynamicObject.set(leaf, (Object)((DynamicObject)dynamicObjects.get(i)).getString("isleaf"));
        }
        if (list.size() == 1 && dynamicObjects.size() < idList.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u542b\u6240\u9009\u5ea6\u91cf\u7684\u79d1\u76ee\u3002", (String)"OffsetRuleSettingPlugin_51", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (idList.size() == list.size() && dynamicObjects.size() < idList.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u81ea\u52a8\u7565\u8fc7\u4e0d\u542b\u6240\u9009\u5ea6\u91cf\u7684\u79d1\u76ee\u3002", (String)"OffsetRuleSettingPlugin_52", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (idList.size() < list.size() && dynamicObjects.size() < idList.size()) {
            if (dynamicObjects.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u542b\u6240\u9009\u5ea6\u91cf\u4e14\u4e0d\u4e0e\u5f53\u524d\u5217\u8868\u6709\u6570\u636e\u51b2\u7a81\u7684\u79d1\u76ee\u3002", (String)"OffsetRuleSettingPlugin_53", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            } else {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5df2\u81ea\u52a8\u7565\u8fc7\u4e0d\u542b\u6240\u9009\u5ea6\u91cf\u7684\u79d1\u76ee\u3001\u5217\u8868\u4e2d\u5df2\u5b58\u5728\u6216\u4e0e%1\u5217\u8868\u542b\u6709\u5305\u542b\u5173\u7cfb\u7684\u79d1\u76ee\u3002", (String)"OffsetRuleSettingPlugin_23_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{tipsName}), Integer.valueOf(3000));
            }
        } else if (idList.size() < list.size() && dynamicObjects.size() == idList.size()) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5df2\u81ea\u52a8\u7565\u8fc7\u5217\u8868\u4e2d\u5df2\u5b58\u5728\u6216\u4e0e%1\u5217\u8868\u542b\u6709\u5305\u542b\u5173\u7cfb\u7684\u79d1\u76ee\u3002", (String)"OffsetRuleSettingPlugin_25_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{tipsName}));
        }
        this.getView().updateView(entity);
    }

    private void fillAccount(ClosedCallBackEvent closedCallBackEvent, String accountType) {
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        ListSelectedRowCollection list = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (list == null || list.size() == 0) {
            return;
        }
        ListSelectedRow row = list.get(0);
        Map dataMap = row.getDataMap();
        String entity = null;
        String number = null;
        String name = null;
        String id = null;
        String leaf = null;
        if ("send".equals(accountType)) {
            entity = ENTRYENTITYSEND;
            number = "sendnumber";
            name = CTRL_KEY_SENDACCOUNT;
            id = "sendaccountid";
            leaf = "isleafsend";
        } else {
            entity = ENTRYENTITYRECV;
            number = "acceptnumber";
            name = CTRL_KEY_ACCEPTACCOUNT;
            id = "acceptaccountid";
            leaf = "isleafrecv";
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(entity);
        int[] selectRows = entryGrid.getSelectRows();
        int sameRow = this.validateEntityRow(IDUtils.toLong((Object)row.getPrimaryKeyValue()), entity, id);
        if (sameRow != -1 && selectRows[0] != sameRow) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6240\u9009\u79d1\u76ee\u4e0e\u7b2c%1\u884c\u76f8\u540c\u3002", (String)"OffsetRuleSettingPlugin_26_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{sameRow + 1}));
            return;
        }
        if (!this.validateSendAndRecv(IDUtils.toLong((Object)row.getPrimaryKeyValue()), "send".equals(accountType), true)) {
            return;
        }
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(entity);
        DynamicObject dynamicObject = (DynamicObject)entryentity.get(selectRows[0]);
        dynamicObject.set(number, (Object)row.getNumber());
        dynamicObject.set(name, (Object)row.getName());
        dynamicObject.set(id, row.getPrimaryKeyValue());
        dynamicObject.set(leaf, dataMap.get("isleaf"));
        this.getView().updateView(entity);
    }

    private int validateEntityRow(Long id, String entityName, String idKey) {
        int row = -1;
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(entityName);
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                if (id.longValue() != ((DynamicObject)dynamicObjects.get(i)).getLong(idKey)) continue;
                row = i;
                return row;
            }
        }
        return row;
    }

    private boolean validateSendAndRecv(Long id, boolean isSend, boolean isShowTip) {
        TreeNode root = this.getAccountTree();
        HashMap<Long, TreeNode> map = new HashMap<Long, TreeNode>(16);
        HashMap<Long, TreeNode> childMap = new HashMap<Long, TreeNode>(16);
        Map<Long, TreeNode> parentMap = null;
        this.getCurrentAccountTreeNode(root, map);
        if (map.size() == 0 || map.get(id) == null) {
            return false;
        }
        TreeNode currentNode = (TreeNode)map.get(id);
        this.getCurrentAccountTreeNode(currentNode, childMap);
        parentMap = this.getParentNodeMap(currentNode);
        if (isSend) {
            DynamicObjectCollection entryentitys = this.getModel().getEntryEntity(ENTRYENTITYRECV);
            if (entryentitys.size() > 0) {
                int samerow = this.validateSameNode(entryentitys, String.valueOf(id), "acceptaccountid");
                int childrow = this.validateChildOrParent(entryentitys, childMap, "acceptaccountid");
                int parentrow = this.validateChildOrParent(entryentitys, parentMap, "acceptaccountid");
                if (samerow != -1) {
                    if (isShowTip) {
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u63a5\u6536\u65b9\u79d1\u76ee\u7b2c%1\u884c\u5df2\u5b58\u5728\u8be5\u79d1\u76ee\u6210\u5458\u3002", (String)"OffsetRuleSettingPlugin_55_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{samerow}));
                    }
                    return false;
                }
                if (childrow != -1) {
                    if (isShowTip) {
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u63a5\u6536\u65b9\u79d1\u76ee\u7b2c%1\u884c\u5df2\u5b58\u5728\u8be5\u79d1\u76ee\u6210\u5458\u7684\u5b50\u7ea7\u6210\u5458\u3002", (String)"OffsetRuleSettingPlugin_56_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{childrow}));
                    }
                    return false;
                }
                if (parentrow != -1) {
                    if (isShowTip) {
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u63a5\u6536\u65b9\u79d1\u76ee\u7b2c%1\u884c\u5df2\u5b58\u5728\u8be5\u79d1\u76ee\u6210\u5458\u7236\u7ea7\u6210\u5458\u3002", (String)"OffsetRuleSettingPlugin_57_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{parentrow}));
                    }
                    return false;
                }
            }
        } else {
            DynamicObjectCollection entryentitysend = this.getModel().getEntryEntity(ENTRYENTITYSEND);
            if (entryentitysend.size() > 0) {
                int samerow = this.validateSameNode(entryentitysend, String.valueOf(id), "sendaccountid");
                int childrow = this.validateChildOrParent(entryentitysend, childMap, "sendaccountid");
                int parentrow = this.validateChildOrParent(entryentitysend, parentMap, "sendaccountid");
                if (samerow != -1) {
                    if (isShowTip) {
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u53d1\u9001\u65b9\u79d1\u76ee\u7b2c%1\u884c\u5df2\u5b58\u5728\u8be5\u79d1\u76ee\u6210\u5458\u3002", (String)"OffsetRuleSettingPlugin_11_55_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{samerow}));
                    }
                    return false;
                }
                if (childrow != -1) {
                    if (isShowTip) {
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u53d1\u9001\u65b9\u79d1\u76ee\u7b2c%1\u884c\u5df2\u5b58\u5728\u8be5\u79d1\u76ee\u6210\u5458\u7684\u5b50\u7ea7\u6210\u5458\u3002", (String)"OffsetRuleSettingPlugin_11_56_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{childrow}));
                    }
                    return false;
                }
                if (parentrow != -1) {
                    if (isShowTip) {
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u53d1\u9001\u65b9\u79d1\u76ee\u7b2c%1\u884c\u5df2\u5b58\u5728\u8be5\u79d1\u76ee\u6210\u5458\u7684\u7236\u7ea7\u6210\u5458\u3002", (String)"OffsetRuleSettingPlugin_11_57_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{parentrow}));
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private int validateSameNode(DynamicObjectCollection entryentitys, String id, String entityAccountId) {
        int row = -1;
        for (DynamicObject entryentity : entryentitys) {
            if (!id.equals(entryentity.getString(entityAccountId))) continue;
            row = entryentity.getInt("seq");
            break;
        }
        return row;
    }

    private int validateChildOrParent(DynamicObjectCollection entryentitys, Map<Long, TreeNode> map, String entityAccountId) {
        int row = -1;
        if (map.size() == 0) {
            return row;
        }
        Set<Long> set = map.keySet();
        for (DynamicObject entryentity : entryentitys) {
            if (entryentity.getString(entityAccountId) == null || "".equals(entryentity.getString(entityAccountId)) || !set.contains(Long.parseLong(entryentity.getString(entityAccountId)))) continue;
            row = entryentity.getInt("seq");
            break;
        }
        return row;
    }

    private Map<Long, TreeNode> getParentNodeMap(TreeNode node) {
        HashMap<Long, TreeNode> parentMap = new HashMap<Long, TreeNode>(16);
        while (!"Account".equals(node.getDynamicObject().getString("number")) && !"Account".equals(node.getParentNode().getDynamicObject().getString("number"))) {
            parentMap.put(node.getParentNode().getId(), node.getParentNode());
            node = node.getParentNode();
        }
        return parentMap;
    }

    private void getCurrentAccountTreeNode(TreeNode treeNode, Map<Long, TreeNode> accountTreeMap) {
        if (treeNode.getChildrenMap() == null) {
            return;
        }
        for (TreeNode treeNode1 : treeNode.getChildrenMap().values()) {
            accountTreeMap.put(treeNode1.getId(), treeNode1);
            this.getCurrentAccountTreeNode(treeNode1, accountTreeMap);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propNmae = e.getProperty().getName();
        this.getPageCache().put("dataChange", "true");
        switch (propNmae) {
            case "varhandle": {
                String _varHandle = (String)this.getModel().getValue("varhandle");
                if (VarhandleEnum.SPECIFYACCOUNT.getIndex().equals(_varHandle)) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap4"});
                } else {
                    int rowCount1 = this.getModel().getEntryRowCount(ENTRYENTITYSEND);
                    int rowCount2 = this.getModel().getEntryRowCount(ENTRYENTITYRECV);
                    if (rowCount1 > 1 || rowCount2 > 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u610f\u4e00\u65b9\u5b58\u5728\u591a\u4e2a\u6210\u672c\u79d1\u76ee\u65f6\u5fc5\u987b\u9009\u62e9\u6307\u5b9a\u5dee\u989d\u9879\u3002", (String)"OffsetRuleSettingPlugin_58", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.getModel().setValue("varhandle", (Object)3);
                        break;
                    }
                    if (rowCount1 == 1 && ("0".equals(this.getModel().getEntryRowEntity(ENTRYENTITYSEND, 0).getString("isleafsend")) || "false".equals(this.getModel().getEntryRowEntity(ENTRYENTITYSEND, 0).getString("isleafsend"))) || rowCount2 == 1 && ("0".equals(this.getModel().getEntryRowEntity(ENTRYENTITYRECV, 0).getString("isleafrecv")) || "false".equals(this.getModel().getEntryRowEntity(ENTRYENTITYRECV, 0).getString("isleafrecv")))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u79d1\u76ee\u4e3a\u975e\u660e\u7ec6\u79d1\u76ee\u65f6\u5fc5\u987b\u9009\u62e9\u6307\u5b9a\u5dee\u989d\u9879\u3002", (String)"OffsetRuleSettingPlugin_59", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        this.getModel().setValue("varhandle", (Object)3);
                        break;
                    }
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap4"});
                }
                if (StringUtils.equals((String)VarhandleEnum.USEBIG.getIndex(), (String)_varHandle)) {
                    this.enableAndVisibleUnilateral(Boolean.TRUE);
                    break;
                }
                this.getModel().setValue("checkunilateral", (Object)Boolean.FALSE);
                this.enableAndVisibleUnilateral(Boolean.FALSE);
                break;
            }
            case "sendaccount": 
            case "acceptaccount": {
                String entity = null;
                String account = null;
                String accountNumber = null;
                if (CTRL_KEY_SENDACCOUNT.equals(propNmae)) {
                    entity = ENTRYENTITYSEND;
                    account = CTRL_KEY_SENDACCOUNT;
                    accountNumber = "sendnumber";
                } else {
                    entity = ENTRYENTITYRECV;
                    account = CTRL_KEY_ACCEPTACCOUNT;
                    accountNumber = "acceptnumber";
                }
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity(entity);
                EntryGrid entryGrid = (EntryGrid)this.getControl(entity);
                int[] selectRows = entryGrid.getSelectRows();
                DynamicObject dynamicObject = (DynamicObject)entryentity.get(selectRows[0]);
                Object obj = this.getModel().getValue(account, selectRows[0]);
                if (obj instanceof DynamicObject) {
                    dynamicObject.set(accountNumber, (Object)((DynamicObject)this.getModel().getValue(account, selectRows[0])).getString("number"));
                } else {
                    dynamicObject.set(accountNumber, null);
                }
                this.getView().updateView(entity);
                break;
            }
            case "metriclist": {
                this.clearAccounts();
                break;
            }
            case "assistdim": {
                this.clearAccounts();
                break;
            }
            case "varaccount": {
                if (!StringUtils.isEmpty((String)((String)e.getChangeSet()[0].getNewValue()))) break;
                this.getModel().setValue("varaccountid", null);
                break;
            }
            case "entityview": {
                Object newValue = e.getChangeSet()[0].getNewValue();
                if (!Objects.nonNull(newValue)) break;
                this.initTree();
                break;
            }
        }
    }

    private void clearAccounts() {
        DynamicObjectCollection rec;
        DynamicObjectCollection send = this.getModel().getEntryEntity(ENTRYENTITYSEND);
        if (send != null && send.size() > 0) {
            for (DynamicObject o : send) {
                o.set("sendaccountid", null);
                o.set("sendnumber", null);
                o.set(CTRL_KEY_SENDACCOUNT, null);
                o.set("isleafsend", null);
            }
        }
        if ((rec = this.getModel().getEntryEntity(ENTRYENTITYRECV)) != null && rec.size() > 0) {
            for (DynamicObject o : rec) {
                o.set("acceptaccountid", null);
                o.set("acceptnumber", null);
                o.set(CTRL_KEY_ACCEPTACCOUNT, null);
                o.set("isleafrecv", null);
            }
        }
        this.getModel().setValue("varaccountid", null);
        this.getModel().setValue(VARACCOUNT, null);
        this.getView().updateView(ENTRYENTITYSEND);
        this.getView().updateView(ENTRYENTITYRECV);
        this.getView().updateView(VARACCOUNT);
    }

    private Long getViewId() {
        DynamicObject dyObj = (DynamicObject)this.getModel().getValue(ENTITYVIEW);
        long viewId = dyObj == null ? 0L : dyObj.getLong("id");
        return viewId;
    }

    private DynamicObjectCollection queryDimmember(String entity, Long viewId) {
        String selectFields;
        String entityName = entity;
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        qFilter.and(new QFilter("membersource", "!=", (Object)MemberSourceEnum.ANALYZE_VIEW.getIndex()));
        QFilter[] filters = null;
        if ("epm_entitymembertree".equals(entityName)) {
            selectFields = "id,memberid,number,name,parent,mergernode,dseq,isleaf,level";
            entityName = "eb_viewmember";
            qFilter.and(new QFilter("view", "=", (Object)viewId));
            qFilter.and(new QFilter("disable", "=", (Object)false));
        } else {
            selectFields = "id,number,name,parent,dseq,isleaf,level";
        }
        filters = new QFilter[]{qFilter};
        return QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters, (String)"level desc");
    }

    private void setTreeEntryEntity(TreeNode treeNode, DynamicObjectCollection treeentryentity, AtomicInteger rowIndex) {
        if (treeNode.getChildrenMap() == null) {
            return;
        }
        for (TreeNode treeNode1 : treeNode.getChildrenMap().values()) {
            DynamicObject dynamicObject = treeNode1.getDynamicObject();
            DynamicObject entityDy = (DynamicObject)treeentryentity.get(rowIndex.getAndIncrement());
            entityDy.set("id", (Object)dynamicObject.getLong("id"));
            entityDy.set("pid", (Object)dynamicObject.getLong("parent"));
            entityDy.set("orgid", (Object)dynamicObject.getLong("memberid"));
            entityDy.set("parent", (Object)dynamicObject.getLong("parent"));
            entityDy.set("orgnumber", dynamicObject.get("number"));
            entityDy.set("bizorg", dynamicObject.get("name"));
            entityDy.set("isleaf", dynamicObject.get("isleaf"));
            entityDy.set("ismergenode", dynamicObject.get("mergernode"));
            entityDy.set("enable", (Object)false);
            this.setTreeEntryEntity(treeNode1, treeentryentity, rowIndex);
        }
    }

    private void initTreeEntryentity(TreeNode rootNode) {
        this.getModel().deleteEntryData(TREENTRYENTITY);
        AtomicInteger rowCount = new AtomicInteger(0);
        this.removeRootAndLeaf(rootNode, rowCount);
        if (rowCount.get() <= 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(TREENTRYENTITY, rowCount.get());
        AtomicInteger rowIndex = new AtomicInteger(0);
        DynamicObjectCollection treeentryentity = this.getModel().getEntryEntity(TREENTRYENTITY);
        this.setTreeEntryEntity(rootNode, treeentryentity, rowIndex);
    }

    private void removeRootAndLeaf(TreeNode treeNode, AtomicInteger rowCount) {
        Collection<TreeNode> children;
        if (treeNode.getChildrenMap() == null || CollectionUtils.isEmpty(treeNode.getChildrenMap().values())) {
            return;
        }
        if (treeNode.getId() == 0L && CollectionUtils.isNotEmpty(children = treeNode.getChildrenMap().values())) {
            treeNode.setChildrenMap(children.iterator().next().getChildrenMap());
        }
        if (MapUtils.isEmpty(treeNode.getChildrenMap())) {
            return;
        }
        Iterator<TreeNode> ite = treeNode.getChildrenMap().values().iterator();
        while (ite.hasNext()) {
            TreeNode node = ite.next();
            if ("true".equals(node.getDynamicObject().getString("isleaf"))) {
                ite.remove();
                continue;
            }
            rowCount.incrementAndGet();
            this.removeRootAndLeaf(node, rowCount);
        }
    }

    private void initTree() {
        Long viewId = this.getViewId();
        DynamicObjectCollection memberColls = this.queryDimmember("epm_entitymembertree", viewId);
        TreeNode treeNode = this.buildTree(memberColls);
        this.initTreeEntryentity(treeNode);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(TREENTRYENTITY);
        treeEntryGrid.setCollapse(false);
        DynamicObjectCollection treeentryentitys = this.getModel().getEntryEntity(TREENTRYENTITY);
        for (int i = 0; i < treeentryentitys.size(); ++i) {
            if (Boolean.parseBoolean(this.getModel().getValue("ismergenode", i).toString())) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"enable"});
        }
        this.getView().updateView(TREENTRYENTITY);
    }

    private TreeNode buildTree(DynamicObjectCollection memberColls) {
        HashMap<Long, TreeNode> idNodeMap = new HashMap<Long, TreeNode>(16);
        for (DynamicObject memberObject : memberColls) {
            boolean isleaf = (Boolean)memberObject.get("isleaf");
            long id = memberObject.getLong("id");
            TreeNode treeNode = (TreeNode)idNodeMap.get(id);
            if (treeNode == null) {
                treeNode = new TreeNode(id, isleaf);
            }
            if (treeNode.isIsleaf()) {
                treeNode.setChildrenMap(null);
            }
            treeNode.init(memberObject, idNodeMap);
        }
        return (TreeNode)idNodeMap.get(0L);
    }

    private void initMetricMap() {
        String entityName = "epm_metricmembertree";
        String selectFields = "id,number";
        QFilter fmodelid = new QFilter("model", "=", (Object)this.getModelId());
        QFilter[] filters = new QFilter[]{fmodelid};
        DynamicObjectCollection col = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters);
        col.forEach(e -> {
            this.metricMap.put(e.getString("number"), e.getString("id"));
            this.metricMap.put(e.getString("id"), e.getString("number"));
        });
    }

    private Map<String, String> getMetricMap() {
        if (this.metricMap.isEmpty()) {
            this.initMetricMap();
        }
        return this.metricMap;
    }

    @Override
    public Long getModelId() {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        return model == null ? 0L : model.getLong("id");
    }

    public Long getBusModelId() {
        DynamicObject busModel = (DynamicObject)this.getModel().getValue("busmodel");
        return busModel != null ? busModel.getLong("id") : 0L;
    }

    private class TreeNode {
        private Long id;
        private boolean isleaf;
        private DynamicObject dynamicObject;
        private TreeNode parentNode = null;
        private Map<Integer, TreeNode> childrenMap = new TreeMap<Integer, TreeNode>();

        TreeNode(Long id, boolean isleaf) {
            this.id = id;
            this.isleaf = isleaf;
        }

        public void init(DynamicObject memberObject, HashMap<Long, TreeNode> idNodeMap) {
            long parent = memberObject.getLong("parent");
            int dseq = memberObject.getInt("dseq");
            this.setDynamicObject(memberObject);
            TreeNode parentNode = idNodeMap.get(parent);
            if (parentNode == null) {
                parentNode = new TreeNode(parent, false);
                idNodeMap.put(parentNode.getId(), parentNode);
            }
            this.setParentNode(parentNode);
            Map<Integer, TreeNode> childMap = this.getParentNode().getChildrenMap();
            int dseq2 = dseq;
            while (childMap.containsKey(dseq2)) {
                ++dseq2;
            }
            if (dseq2 != dseq) {
                TreeNode treeNode = childMap.get(dseq);
                this.getParentNode().getChildrenMap().put(dseq2, treeNode);
            }
            this.getParentNode().getChildrenMap().put(dseq, this);
        }

        public Long getId() {
            return this.id;
        }

        public boolean isIsleaf() {
            return this.isleaf;
        }

        public DynamicObject getDynamicObject() {
            return this.dynamicObject;
        }

        public void setDynamicObject(DynamicObject dynamicObject) {
            this.dynamicObject = dynamicObject;
        }

        public TreeNode getParentNode() {
            return this.parentNode;
        }

        public void setParentNode(TreeNode parentNode) {
            this.parentNode = parentNode;
        }

        public Map<Integer, TreeNode> getChildrenMap() {
            return this.childrenMap;
        }

        public void setChildrenMap(Map<Integer, TreeNode> childrenMap) {
            this.childrenMap = childrenMap;
        }
    }
}

