/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.utils.BgRegisterUtils;
import kd.epm.eb.ebSpread.common.util.StringUtil;
import kd.epm.eb.formplugin.AbstractListPlugin;

public class AddbillQFilter
extends AbstractListPlugin {
    private static final String COMBOFILED0 = "combofield0";
    private static final String COMBOFILED1 = "combofield1";
    private static final String COMBOFILED2 = "combofield2";
    private static final String COMBOFILED3 = "combofield3";
    private static final String COMBOFILED = "combofield";
    private static final String ICONAP = "iconap";
    private static final String EXPRESSION = "expression";
    private static final String SUBJECT = "subject";
    private static final String Model = "model";
    private static final String ASSGRPMAIN = "entries.maincfassgrp";
    private static final String ASSGRP = "entries.assgrp";
    private static Log log = LogFactory.getLog(AddbillQFilter.class);

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"confirm", "cancel"});
    }

    public void afterCreateNewData(EventObject e) {
        Map<String, String> billMessage = this.getBillMessage();
        this.setCombxValue(billMessage, COMBOFILED0, Boolean.TRUE);
        this.setFiledEnable(COMBOFILED0);
        this.setComFlexVisable(COMBOFILED1, Boolean.TRUE);
        List<IDataEntityProperty> propertyValue = this.getPropertyValue(billMessage.keySet().toArray()[0].toString());
        Map<String, Map<String, String>> nodeNumberAndNameMap = this.getNodeNumberAndNameMap(COMBOFILED1);
        Map<String, Map<String, String>> baseDataKey = this.getBaseDataKey(COMBOFILED1);
        this.getField(propertyValue, nodeNumberAndNameMap.get(COMBOFILED1), baseDataKey.get(COMBOFILED1), Boolean.FALSE);
        this.sortNumberAndNameMap(nodeNumberAndNameMap, COMBOFILED1);
        this.putValueToChache(nodeNumberAndNameMap, baseDataKey);
        this.setCombxValue(nodeNumberAndNameMap.get(COMBOFILED1), COMBOFILED1, Boolean.TRUE);
        this.showNextComBx(COMBOFILED1);
        this.initNextComBoxValue(COMBOFILED1);
        this.setCombxValue(this.getNodeNumberAndNameMap(this.getNumberAndNameKey(COMBOFILED1, this.getNextComboxName(COMBOFILED1))).get(this.getNumberAndNameKey(COMBOFILED1, this.getNextComboxName(COMBOFILED1))), this.getNextComboxName(COMBOFILED1), Boolean.FALSE);
        this.setSelectValue(COMBOFILED1);
        this.getNextComboxMessage(COMBOFILED1);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        switch (key = Control2.getKey()) {
            case "confirm": {
                this.returnDataToParent();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "combofield1": 
            case "combofield2": {
                this.getNextComboxMessage(key);
                if (COMBOFILED2.equals(key) && !ASSGRP.equals(this.getComboxValue(COMBOFILED1))) {
                    this.setSelectValue(key);
                    break;
                }
                this.showNextComBx(key);
                this.setSelectValue(key);
                this.initNextComBoxValue(key);
                this.setCombxValue(this.getNodeNumberAndNameMap(this.getNumberAndNameKey(key, this.getNextComboxName(key))).get(this.getNumberAndNameKey(key, this.getNextComboxName(key))), this.getNextComboxName(key), Boolean.FALSE);
                break;
            }
            case "combofield3": {
                this.setSelectValue(key);
                break;
            }
        }
    }

    private void getNextComboxMessage(String key) {
        String value = this.getComboxValue(key);
        String nextComboxName = this.getNextComboxName(key);
        Map<String, Map<String, String>> baseDataKey = this.getBaseDataKey(nextComboxName);
        Map<String, Map<String, String>> nodeNumberAndNameMap = this.getNodeNumberAndNameMap(nextComboxName);
        if (baseDataKey.get(key).containsKey(value)) {
            String billNumber = baseDataKey.get(key).get(value);
            if (ASSGRP.equals(value) || ASSGRPMAIN.equals(value)) {
                List flexProperties = FlexEntityMetaUtils.getFlexProperties((int)Integer.parseInt(billNumber));
                this.getFlexField(flexProperties, nodeNumberAndNameMap.get(nextComboxName), baseDataKey.get(nextComboxName));
            } else {
                List<IDataEntityProperty> propertyValue = this.getPropertyValue(billNumber);
                this.getField(propertyValue, nodeNumberAndNameMap.get(nextComboxName), baseDataKey.get(nextComboxName), Boolean.TRUE);
            }
        }
        this.putValueToChache(nodeNumberAndNameMap, baseDataKey);
    }

    private void sortNumberAndNameMap(Map<String, Map<String, String>> nodeNumberAndNameMap, String key) {
        Map<String, String> map = nodeNumberAndNameMap.get(key);
        ArrayList<Map.Entry<String, String>> infoIds = new ArrayList<Map.Entry<String, String>>(map.entrySet());
        Collections.sort(infoIds, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        this.putSortDataToMap(infoIds, key, nodeNumberAndNameMap);
    }

    private void putSortDataToMap(List<Map.Entry<String, String>> infoIds, String key, Map<String, Map<String, String>> nodeNumberAndNameMap) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(infoIds.size());
        for (Map.Entry<String, String> mapEntry : infoIds) {
            map.put(mapEntry.getKey(), mapEntry.getValue());
        }
        nodeNumberAndNameMap.put(key, map);
    }

    public String getNumberAndNameKey(String key, String nextComboxKey) {
        String comboxValue = this.getComboxValue(key);
        return nextComboxKey + "." + comboxValue;
    }

    private void initNextComBoxValue(String key) {
        String value = this.getComboxValue(key);
        if (StringUtil.isEmptyString((String)value)) {
            return;
        }
        Map<String, Map<String, String>> baseDataKeys = this.getBaseDataKey(key);
        Map<String, String> baseDataKey = baseDataKeys.get(key);
        if (!baseDataKey.containsKey(value)) {
            return;
        }
        String nextComboxName = this.getNextComboxName(key) + "." + this.getComboxValue(key);
        Map<String, Map<String, String>> nodeNumberAndNameMap = this.getNodeNumberAndNameMap(nextComboxName);
        String billNumber = baseDataKey.get(value);
        if (ASSGRP.equals(value) || ASSGRPMAIN.equals(value)) {
            List flexProperties = FlexEntityMetaUtils.getFlexProperties((int)Integer.parseInt(billNumber));
            this.getFlexField(flexProperties, nodeNumberAndNameMap.get(nextComboxName), baseDataKey);
        } else {
            List<IDataEntityProperty> propertyValue = this.getPropertyValue(billNumber);
            this.getField(propertyValue, nodeNumberAndNameMap.get(nextComboxName), baseDataKey, Boolean.TRUE);
        }
        this.sortNumberAndNameMap(nodeNumberAndNameMap, nextComboxName);
        nodeNumberAndNameMap.put(nextComboxName, nodeNumberAndNameMap.get(nextComboxName));
        this.putValueToChache(nodeNumberAndNameMap, baseDataKeys);
    }

    private void putValueToChache(Map<String, Map<String, String>> nodeNumberAndNameMap, Map<String, Map<String, String>> baseDataKey) {
        this.getPageCache().put("basedata", SerializationUtils.serializeToBase64(baseDataKey));
        this.getPageCache().put("property", SerializationUtils.serializeToBase64(nodeNumberAndNameMap));
    }

    private void showNextComBx(String comboxKey) {
        String nextCombox = this.getNextComboxName(comboxKey);
        String nextIconap = this.getNextIconapName(comboxKey);
        String comboxValue = this.getComboxValue(comboxKey);
        if (this.getBaseDataKey(comboxKey).get(comboxKey).containsKey(comboxValue)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{nextIconap, nextCombox});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{nextIconap, nextCombox});
        }
        this.getModel().setValue(nextCombox, null);
    }

    private String getNextComboxName(String comboxKey) {
        int comboxLevel = this.getComboxLevel(comboxKey);
        String nextCombox = COMBOFILED + (comboxLevel + 1);
        return nextCombox;
    }

    private String getPerComboxName(String comboxKey) {
        int comboxLevel = this.getComboxLevel(comboxKey);
        String nextCombox = COMBOFILED + (comboxLevel - 1);
        return nextCombox;
    }

    private String getNextIconapName(String comboxKey) {
        int comboxLevel = this.getComboxLevel(comboxKey);
        String nextIconap = ICONAP + comboxLevel;
        return nextIconap;
    }

    private String getComboxValue(String key) {
        Object value = this.getModel().getValue(key);
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    private int getComboxLevel(String key) {
        String level_s = key.substring(key.length() - 1);
        try {
            int level = Integer.parseInt(level_s);
            return level;
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private void setSelectValue(String combox) {
        int comboxLevel = this.getComboxLevel(combox);
        StringBuilder sb_ex = new StringBuilder();
        StringBuilder sb_su = new StringBuilder();
        sb_su.append(this.getBillMessage().values().toArray()[0]);
        for (int i = 1; i <= comboxLevel; ++i) {
            String key = COMBOFILED + i;
            String mapKey = i >= 2 ? this.getNumberAndNameKey(this.getPerComboxName(key), key) : key;
            String comboxValue = this.getComboxValue(key);
            Map<String, String> nodeNumberAndNameMap = this.getNodeNumberAndNameMap(mapKey).get(mapKey);
            if (StringUtil.isEmptyString((String)comboxValue)) continue;
            sb_ex.append(".").append(comboxValue);
            sb_su.append(".").append(nodeNumberAndNameMap.get(comboxValue));
        }
        if (sb_ex.length() > 0) {
            sb_ex.insert(0, Model);
            this.getModel().setValue(EXPRESSION, (Object)sb_ex.toString());
            this.getModel().setValue(SUBJECT, (Object)sb_su.toString());
        }
    }

    public Map<String, Map<String, String>> getNodeNumberAndNameMap(String key) {
        HashMap<String, Map<String, String>> nodeNumberAndNameMap;
        String property = this.getPageCache().get("property");
        if (StringUtils.isEmpty((String)property)) {
            HashMap map = new HashMap(16);
            nodeNumberAndNameMap = new HashMap<String, Map<String, String>>(24);
            nodeNumberAndNameMap.put(key, map);
        } else {
            nodeNumberAndNameMap = (HashMap<String, Map<String, String>>)SerializationUtils.deSerializeFromBase64((String)property);
            if (nodeNumberAndNameMap.get(key) == null) {
                HashMap map = new HashMap(16);
                nodeNumberAndNameMap.put(key, map);
            }
        }
        return nodeNumberAndNameMap;
    }

    public Map<String, Map<String, String>> getBaseDataKey(String key) {
        HashMap<String, Map<String, String>> baseDataList;
        String baseData = this.getPageCache().get("basedata");
        if (StringUtils.isEmpty((String)baseData)) {
            HashMap numberAndEntry = new HashMap(8);
            baseDataList = new HashMap<String, Map<String, String>>(16);
            baseDataList.put(key, numberAndEntry);
        } else {
            baseDataList = (HashMap<String, Map<String, String>>)SerializationUtils.deSerializeFromBase64((String)baseData);
            if (baseDataList.get(key) == null) {
                HashMap numberAndEntry = new HashMap(8);
                baseDataList.put(key, numberAndEntry);
            }
        }
        return baseDataList;
    }

    private void getField(List<IDataEntityProperty> properties, Map<String, String> nodeNumberAndNameMap, Map<String, String> baseDataKey, boolean isNeedFlexPropValue) {
        for (IDataEntityProperty property : properties) {
            String baseEntityId;
            String number = property.getName();
            LocaleString displayName = property.getDisplayName();
            if (number == null || displayName == null) continue;
            String name = displayName.getLocaleValue();
            nodeNumberAndNameMap.put(number, name);
            if (property.getParent() instanceof EntryType) {
                String baseEntityId2;
                nodeNumberAndNameMap.remove(number);
                number = property.getParent().getName() + "." + number;
                name = property.getParent().getDisplayName().getLocaleValue() + "." + name;
                if (property.getParent() instanceof SubEntryType && property.getParent().getParent() != null) {
                    number = property.getParent().getParent().getName() + "." + number;
                    name = property.getParent().getParent().getDisplayName().getLocaleValue() + "." + name;
                }
                nodeNumberAndNameMap.put(number, name);
                if (property instanceof FlexProp) {
                    int flexTypeId = ((FlexProp)property).getFlexTypeId();
                    if (isNeedFlexPropValue) continue;
                    baseDataKey.put(number, String.valueOf(flexTypeId));
                    continue;
                }
                if (!(property instanceof BasedataProp) || StringUtil.isEmptyString((String)(baseEntityId2 = ((BasedataProp)property).getBaseEntityId()))) continue;
                baseDataKey.put(number, baseEntityId2);
                continue;
            }
            if (!(property instanceof BasedataProp) || StringUtil.isEmptyString((String)(baseEntityId = ((BasedataProp)property).getBaseEntityId()))) continue;
            baseDataKey.put(number, baseEntityId);
        }
    }

    private void getFlexField(List<FlexProperty> properties, Map<String, String> nodeNumberAndNameMap, Map<String, String> baseDataKey) {
        for (FlexProperty property : properties) {
            String glNumber = property.getNumber();
            String glName = property.getGLName();
            String valueSource = property.getValueSource();
            if (glNumber == null || glName == null) continue;
            nodeNumberAndNameMap.put(glNumber, glName);
            baseDataKey.put(glNumber, valueSource);
        }
    }

    private List<IDataEntityProperty> getPropertyValue(String fieldtable) {
        Collection values;
        try {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)fieldtable);
            values = mainType.getAllFields().values();
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        List<IDataEntityProperty> collect = values.stream().collect(Collectors.toList());
        return collect;
    }

    private void setFiledEnable(String filedKey) {
        this.getView().setEnable(Boolean.FALSE, new String[]{filedKey});
    }

    private void setDefaultValue(String filedKey, String value, Boolean isSet) {
        if (isSet.booleanValue()) {
            this.getModel().setValue(filedKey, (Object)value);
        }
    }

    private Map<String, String> getBillMessage() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entityNumber = (String)formShowParameter.getCustomParam("entityNumber");
        HashMap<String, String> message = new HashMap<String, String>(16);
        if (entityNumber.contains("!!")) {
            message.put(entityNumber.substring(0, entityNumber.indexOf("!!")), entityNumber.substring(entityNumber.indexOf("!!") + 2));
        }
        return message;
    }

    private void setCombxValue(Map<String, String> billMessage, String number, boolean isSetDefaultValue) {
        ComboEdit control = (ComboEdit)this.getControl(number);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        try {
            if (COMBOFILED2.equals(number)) {
                String com1Value;
                Map<String, String> billMap = this.getBillMessage();
                String fieldTable = billMap.keySet().toArray()[0].toString();
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)fieldTable);
                IDataEntityProperty dataEntityProperty = BgRegisterUtils.getField((MainEntityType)mainType, (String)(com1Value = this.getComboxValue(COMBOFILED1)), (StringBuilder)new StringBuilder());
                IFieldHandle fieldHandle = (IFieldHandle)dataEntityProperty;
                List list = fieldHandle.createFilterFields(mainType);
                if (list == null) {
                    return;
                }
                for (FilterField field : list) {
                    if (field == null || field.getFieldName() != null && field.getFieldName().split("\\.").length > 2 || field.getFieldProp() instanceof BasedataProp) continue;
                    String caption = this.getLastText(field.getCaption().toString());
                    String value = this.getLastText(field.getFieldName());
                    items.add(new ComboItem(new LocaleString(caption), value));
                }
            } else {
                for (Map.Entry<String, String> mapEntry : billMessage.entrySet()) {
                    items.add(new ComboItem(new LocaleString(mapEntry.getValue()), mapEntry.getKey()));
                }
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u5b57\u6bb5\u5c5e\u6027\u65f6\u53d1\u751f\u9519\u8bef", (String)"AddbillQFilter_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            log.error(ResManager.loadKDString((String)"\u751f\u6210\u5b57\u6bb5\u5c5e\u6027\u65f6\u53d1\u751f\u9519\u8bef", (String)"AddbillQFilter_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Throwable)e);
        }
        control.setComboItems(items);
        if (items.size() > 0) {
            this.setDefaultValue(number, ((ComboItem)items.get(0)).getValue(), isSetDefaultValue);
        }
    }

    private void setComFlexVisable(String filedKey, Boolean isVisible) {
        this.getView().setVisible(isVisible, new String[]{filedKey});
    }

    private void returnDataToParent() {
        this.checkValue();
        Object expression = this.getModel().getValue(EXPRESSION);
        Object subject = this.getModel().getValue(SUBJECT);
        HashMap<String, Object> mapData = new HashMap<String, Object>(16);
        mapData.put(EXPRESSION, expression);
        mapData.put(SUBJECT, subject);
        this.getView().returnDataToParent(mapData);
        this.getView().close();
    }

    private void checkValue() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entityNumber = (String)formShowParameter.getCustomParam("entityNumber");
        if (entityNumber != null && entityNumber.contains("!!")) {
            entityNumber = entityNumber.substring(0, entityNumber.indexOf("!!"));
        }
        if ("gl_voucher".equals(entityNumber)) {
            return;
        }
        Map<String, String> baseDataKey = this.getBaseDataKey(COMBOFILED1).get(COMBOFILED1);
        String firstField = this.getComboxValue(COMBOFILED1);
        Map<String, String> billMessage = this.getBillMessage();
        String fieldTable = billMessage.keySet().toArray()[0].toString();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)fieldTable);
        DynamicProperty property = null;
        String checkField = null;
        if (baseDataKey.containsKey(firstField)) {
            String secondField = this.getComboxValue(this.getNextComboxName(COMBOFILED1));
            if (StringUtil.isEmptyString((String)secondField)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u6027\u8868\u8fbe\u5f0f\u9700\u8981\u9009\u5230\u53f6\u5b50\u8282\u70b9\uff0c\u8bf7\u5f80\u4e0b\u9009\u62e9\u3002", (String)"AddbillQFilter_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            property = this.getProp(mainType, firstField);
            if (property == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u672a\u627e\u5230\u8be5\u5b57\u6bb5\uff0c\u8bf7\u6838\u5b9e\u3002", (String)"AddbillQFilter_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            checkField = property.getName() + "." + secondField;
        } else {
            property = this.getProp(mainType, firstField);
            if (property == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u672a\u627e\u5230\u8be5\u5b57\u6bb5\uff0c\u8bf7\u6838\u5b9e\u3002", (String)"AddbillQFilter_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            checkField = property.getName();
        }
        if (property != null && StringUtils.isEmpty((String)property.getAlias())) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u5b57\u6bb5\u201c%s\u201d\u65e0\u5b9e\u4f53\u5b57\u6bb5\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u6761\u4ef6\u5b57\u6bb5\u3002", (String)"AddbillQFilter_4", (String)"epm-eb-formplugin", (Object[])new Object[]{property.getName()}));
        }
        if (property instanceof BasedataProp) {
            IFieldHandle fieldHandle = (IFieldHandle)property;
            List list = fieldHandle.createFilterFields(mainType);
            String finalFieldKey = checkField;
            Optional<FilterField> first = list.stream().filter(k -> k.getFieldName().equals(finalFieldKey)).findFirst();
            if (!first.isPresent()) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u672a\u627e\u5230\u5c5e\u6027\u201c%s\u201d,\u8bf7\u5728\u5143\u6570\u636e\u786e\u8ba4\uff0c\u201c\u5f15\u7528\u5c5e\u6027\u201d\u6709\u6dfb\u52a0\u6b64\u5c5e\u6027\u3002", (String)"AddbillQFilter_2", (String)"epm-eb-formplugin", (Object[])new Object[]{finalFieldKey}));
            }
            FilterField field = first.get();
            IDataEntityProperty fieldProp = field.getFieldProp();
            if (fieldProp instanceof BasedataProp) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672b\u7ea7\u5c5e\u6027\u4e0d\u5141\u8bb8\u9009\u62e9\u57fa\u7840\u8d44\u6599\u5c5e\u6027\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AddbillQFilter_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private DynamicProperty getProp(MainEntityType mainType, String key) {
        if (key.contains(".")) {
            String a = key.substring(0, key.indexOf("."));
            String b = key.substring(key.indexOf(".") + 1);
            if (b.contains(".")) {
                return this.getProp(mainType, b);
            }
            if (mainType.getAllEntities().containsKey(a) && mainType.getAllEntities().get(a) != null) {
                return ((EntityType)mainType.getAllEntities().get(a)).getProperty(b);
            }
        } else {
            return mainType.getProperty(key);
        }
        return null;
    }

    private String getLastText(String text) {
        if (!text.contains(".")) {
            return text;
        }
        int index = text.lastIndexOf(".");
        return text.substring(index + 1);
    }
}

