/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.central.OrgMemberDto;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.dao.rulecontrol.ControlRuleAllotOrgPojo;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.enums.F7RangeTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.control.ControlRuleHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public interface AllotOrg {
    default public void showOrgAllotForm(AbstractFormPlugin plugin) {
        RangeF7Param param = new RangeF7Param();
        param.setEnableView(false);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, "orgSelect");
        param.setCloseCallBack(closeCallBack);
        param.setSwitchViewBySelMem(false);
        param.setNeedPermCheck(true);
        param.setBizModelId(this.getBussModelId());
        param.setOpenProperty(true);
        param.setRangeType(F7RangeTypeEnum.CUSTOMIZE);
        param.setDefaultRange(RangeEnum.ALL);
        param.setUserRange((List)Lists.newArrayList((Object[])new String[]{"10", "50"}));
        param.setLockRangeSelect(true);
        param.setMustSelected(false);
        List<OrgMemberDto> checkedOrg = this.getCheckedOrg();
        if (!checkedOrg.isEmpty()) {
            ArrayList<MemberCondition> members = new ArrayList<MemberCondition>(checkedOrg.size());
            for (OrgMemberDto orgMemberDto : checkedOrg) {
                MemberCondition memberCondition = new MemberCondition(orgMemberDto.getId(), orgMemberDto.getNumber(), orgMemberDto.getName(), null, "50");
                if ("property".equals(orgMemberDto.getType())) {
                    memberCondition.setProp(true);
                }
                members.add(memberCondition);
            }
            param.setCon_list(members);
        }
        CustomF7utils.openCustomF7Range((Long)plugin.getModelId(), (String)SysDimensionEnum.Entity.getNumber(), null, (IFormView)plugin.getView(), (RangeF7Param)param);
    }

    default public void setOrg(DynamicObject dynamicObject) {
        List<OrgMemberDto> checkedOrgs = this.getCheckedOrg();
        ArrayList needSaveRecord = new ArrayList(16);
        StringBuilder showOrgName = new StringBuilder();
        DeleteServiceHelper.delete((String)"eb_ocntrolrule_allotorg", (QFilter[])new QFilter[]{new QFilter("controlrulemainid", "=", (Object)dynamicObject.getLong("id"))});
        dynamicObject.set("showorgrange", null);
        checkedOrgs.forEach(checkedOrg -> {
            DynamicObject orgEntity = BusinessDataServiceHelper.newDynamicObject((String)"eb_ocntrolrule_allotorg");
            orgEntity.set("allottime", (Object)TimeServiceHelper.now());
            orgEntity.set("controlrulemainid", (Object)dynamicObject.getLong("id"));
            if ("property".equals(checkedOrg.getType())) {
                orgEntity.set("property", (Object)checkedOrg.getId());
            } else {
                Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"eb_viewmember", (QFilter[])new QFilter("id", "=", (Object)checkedOrg.getId()).toArray());
                if (objectMap != null && objectMap.size() > 0) {
                    Long memberid = objectMap.values().toArray(new DynamicObject[0])[0].getLong("memberid");
                    orgEntity.set("allotedorg", (Object)memberid);
                    orgEntity.set("allotedorgview", (Object)checkedOrg.getId());
                } else {
                    orgEntity.set("allotedorg", (Object)checkedOrg.getId());
                }
            }
            if (checkedOrg.getViewId() != null) {
                orgEntity.set("entityview", (Object)checkedOrg.getViewId());
            }
            needSaveRecord.add(orgEntity);
            showOrgName.append(checkedOrg.getName());
        });
        SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"eb_ocntrolrule_allotorg"), (Object[])needSaveRecord.toArray());
        if (StringUtils.isNotEmpty((CharSequence)showOrgName) && showOrgName.length() < 600) {
            dynamicObject.set("showorgrange", (Object)showOrgName.toString());
        }
    }

    default public List<String> valideBeforeSave(DynamicObject[] mainDynamics) {
        ArrayList<String> errorList = new ArrayList<String>(16);
        List<OrgMemberDto> checkedOrgIds = this.getCheckedOrg();
        if (CollectionUtils.isEmpty(checkedOrgIds)) {
            return errorList;
        }
        Object model = mainDynamics[0].get("model");
        Long modelId = 0L;
        modelId = model instanceof DynamicObject ? Long.valueOf(((DynamicObject)model).getLong("id")) : (Long)model;
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension account = modelCache.getDimension(SysDimensionEnum.Account.getNumber());
        Long accountId = account.getId();
        Map<Integer, Long> controlDimMap = ControlRuleHelper.getControlDimMap(modelId, this.getBussModelId());
        List<ControlRuleAllotOrgPojo> newRules = ControlRuleHelper.getControlRuleAllotOrgPojos(mainDynamics, controlDimMap, accountId, modelCache, this.getBussModelId());
        if (mainDynamics.length > 1) {
            errorList.addAll(this.checkSelf(newRules, modelCache, accountId));
            if (!errorList.isEmpty()) {
                return errorList;
            }
        }
        List orgIds = checkedOrgIds.stream().filter(k -> "org".equals(k.getType())).map(k -> k.getId()).collect(Collectors.toList());
        Set<Long> propertyIds = checkedOrgIds.stream().filter(k -> "property".equals(k.getType())).map(k -> k.getId()).collect(Collectors.toSet());
        DynamicObjectCollection dyList = QueryServiceHelper.query((String)"eb_viewmember", (String)"memberid", (QFilter[])QFBuilder.newQFilter().add("id", "in", orgIds).toArray());
        List dimmemberid = dyList.stream().map(member -> member.getLong("memberid")).collect(Collectors.toList());
        dimmemberid.addAll(orgIds);
        Map<Long, HashSet<Long>> orgPropretyIdMap = this.getSameOrgPropretyIds(propertyIds);
        QFilter qFilter = new QFilter("controlrulemainid", "not in", Arrays.stream(mainDynamics).map(k -> k.getLong("id")).collect(Collectors.toSet()));
        qFilter.and(new QFilter("controlrulemainid.bussmodel.id", "=", (Object)this.getBussModelId()));
        QFilter qfOrg = new QFilter("allotedorg.id", "in", dimmemberid).or("allotedorgview.id", "in", orgIds).or("property.id", "in", orgPropretyIdMap.keySet());
        qFilter.and(qfOrg);
        List<Map<String, String>> docs = ControlRuleHelper.getAllotorgList(new QFilter[]{qFilter});
        HashMap<Long, List> docOrgMap = new HashMap<Long, List>();
        for (Map<String, String> doc : docs) {
            Long id = IDUtils.toLong((Object)doc.get("controlrulemainid"));
            List ids = docOrgMap.computeIfAbsent(id, k -> new ArrayList());
            ids.add(doc);
        }
        Set ids = docs.stream().map(item -> IDUtils.toLong(item.get("controlrulemainid"))).collect(Collectors.toSet());
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"eb_bgcontrolrulemain");
        DynamicObject[] oldMainObjs = (DynamicObject[])BusinessDataServiceHelper.load((Object[])ids.toArray(), (IDataEntityType)dy.getDataEntityType());
        List<ControlRuleAllotOrgPojo> oldRules = ControlRuleHelper.getControlRuleAllotOrgPojos(oldMainObjs, controlDimMap, accountId, modelCache, this.getBussModelId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (ControlRuleAllotOrgPojo newRule : newRules) {
            for (ControlRuleAllotOrgPojo oldRule : oldRules) {
                if (!ControlRuleHelper.dateOverlap(sdf, newRule.getEffectiveDate(), newRule.getInvalidDate(), oldRule.getEffectiveDate(), oldRule.getInvalidDate())) continue;
                List oldDocs = (List)docOrgMap.get(oldRule.getRuleId());
                this.checkControlRuleAllotOrg(errorList, modelCache, accountId, controlDimMap, propertyIds, orgPropretyIdMap, newRule, oldRule, oldDocs);
            }
        }
        return errorList.stream().distinct().collect(Collectors.toList());
    }

    default public void checkControlRuleAllotOrg(List<String> errorList, IModelCacheHelper modelCache, Long accountId, Map<Integer, Long> controlDimMap, Set<Long> propertyIds, Map<Long, HashSet<Long>> orgPropretyIdMap, ControlRuleAllotOrgPojo newRule, ControlRuleAllotOrgPojo oldRule, List<Map<String, String>> oldDocs) {
        Set oldAccountIds;
        Map oblIndex = newRule.getOblIndex();
        Map oldOblIndex = oldRule.getOblIndex();
        Map accountMembersIndexMap = oblIndex == null ? null : (Map)oblIndex.get(accountId);
        Map oldAccountMembersIndexMap = oldOblIndex == null ? null : (Map)oldOblIndex.get(accountId);
        Long maxCountNoOblDimId = newRule.getMaxCountNoOblDimId();
        if (oldRule.getMaxNoOblDimCount().compareTo(newRule.getMaxNoOblDimCount()) > 0) {
            maxCountNoOblDimId = oldRule.getMaxCountNoOblDimId();
        }
        Map maxUserDefineMembersIndexMap = oblIndex == null ? null : (Map)oblIndex.get(maxCountNoOblDimId);
        Map oldMaxUserDefineMembersIndexMap = oldOblIndex == null ? null : (Map)oldOblIndex.get(maxCountNoOblDimId);
        ArrayList<Long[]> retainRuleMembers = new ArrayList<Long[]>(16);
        ArrayList<Long[]> oldRetainRuleMembers = new ArrayList<Long[]>(16);
        HashSet<Integer> accountIndexSet = new HashSet<Integer>(16);
        HashSet<Integer> oldAccountIndexSet = new HashSet<Integer>(16);
        Set accountIds = accountMembersIndexMap == null ? (Set)newRule.getNoOblMembers().get(accountId) : accountMembersIndexMap.keySet();
        Set set = oldAccountIds = oldAccountMembersIndexMap == null ? (Set)oldRule.getNoOblMembers().get(accountId) : oldAccountMembersIndexMap.keySet();
        if (accountIds.size() < oldAccountIds.size()) {
            for (Long accountMemberId : accountIds) {
                Set<Integer> accountMemberIndexSet = this.getMemberIndexSet(accountMembersIndexMap, accountMemberId);
                Set<Integer> oldAccountMemberIndexSet = this.getMemberIndexSet(oldAccountMembersIndexMap, accountMemberId);
                if (!oldAccountIds.contains(accountMemberId)) continue;
                this.handleAccountMemberOverControlRule(errorList, modelCache, controlDimMap, propertyIds, orgPropretyIdMap, newRule, oldRule, oldDocs, maxCountNoOblDimId, maxUserDefineMembersIndexMap, oldMaxUserDefineMembersIndexMap, retainRuleMembers, oldRetainRuleMembers, accountIndexSet, oldAccountIndexSet, accountMemberId, accountMemberIndexSet, oldAccountMemberIndexSet);
            }
        } else {
            for (Long accountMemberId : oldAccountIds) {
                Set<Integer> accountMemberIndexSet = this.getMemberIndexSet(accountMembersIndexMap, accountMemberId);
                Set<Integer> oldAccountMemberIndexSet = this.getMemberIndexSet(oldAccountMembersIndexMap, accountMemberId);
                if (!accountIds.contains(accountMemberId)) continue;
                this.handleAccountMemberOverControlRule(errorList, modelCache, controlDimMap, propertyIds, orgPropretyIdMap, newRule, oldRule, oldDocs, maxCountNoOblDimId, maxUserDefineMembersIndexMap, oldMaxUserDefineMembersIndexMap, retainRuleMembers, oldRetainRuleMembers, accountIndexSet, oldAccountIndexSet, accountMemberId, accountMemberIndexSet, oldAccountMemberIndexSet);
            }
        }
    }

    default public Set<Integer> getMemberIndexSet(Map<Long, Set<Integer>> membersIndexMap, Long memberId) {
        return membersIndexMap == null ? null : membersIndexMap.get(memberId);
    }

    default public void handleAccountMemberOverControlRule(List<String> errorList, IModelCacheHelper modelCache, Map<Integer, Long> controlDimMap, Set<Long> propertyIds, Map<Long, HashSet<Long>> orgPropretyIdMap, ControlRuleAllotOrgPojo newRule, ControlRuleAllotOrgPojo oldRule, List<Map<String, String>> oldDocs, Long maxCountControlDimId, Map<Long, Set<Integer>> maxUserDefineMembersIndexMap, Map<Long, Set<Integer>> oldMaxUserDefineMembersIndexMap, List<Long[]> retainRuleMembers, List<Long[]> oldRetainRuleMembers, Set<Integer> accountIndexSet, Set<Integer> oldAccountIndexSet, Long accountMemberId, Set<Integer> accountMemberIndexSet, Set<Integer> oldAccountMemberIndexSet) {
        boolean hasOver = true;
        boolean hasSameMember = false;
        if (newRule.getUserDefineDimCompose().equals(oldRule.getUserDefineDimCompose())) {
            hasSameMember = true;
            hasOver = this.checkControlRuleSameMembers(controlDimMap, maxCountControlDimId, maxUserDefineMembersIndexMap, oldMaxUserDefineMembersIndexMap, newRule, oldRule, retainRuleMembers, oldRetainRuleMembers, accountIndexSet, oldAccountIndexSet, accountMemberIndexSet, oldAccountMemberIndexSet);
        } else if (!newRule.getUserDefineDimCount().equals(oldRule.getUserDefineDimCount())) {
            hasOver = false;
        }
        if (hasOver) {
            Member accountMember = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, accountMemberId);
            if (CollectionUtils.isNotEmpty(oldDocs)) {
                StringBuilder stringBuilder = new StringBuilder();
                String message = hasSameMember ? (oldRule.getUserDefineDimCount() > 0 ? stringBuilder.append(ResManager.loadResFormat((String)"\u79d1\u76ee\uff1a%1,\u5df2\u5206\u914d\u76f8\u540c\u79d1\u76ee\u548c\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u7684\u6210\u5458\u7ec4\u5408\u7684\u63a7\u5236\u65b9\u5f0f", (String)"AllotOrg_3", (String)"epm-eb-formplugin", (Object[])new Object[]{accountMember.getName()})).toString() : stringBuilder.append(ResManager.loadResFormat((String)"\u79d1\u76ee\uff1a%1,\u5df2\u5206\u914d\u4e0d\u5e26\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u6210\u5458\u7684\u63a7\u5236\u65b9\u5f0f", (String)"AllotOrg_5", (String)"epm-eb-formplugin", (Object[])new Object[]{accountMember.getName()})).toString()) : (newRule.getUserDefineDimCount() > 0 ? stringBuilder.append(ResManager.loadResFormat((String)"\u79d1\u76ee\uff1a%1,\u5df2\u5206\u914d\u76f8\u540c\u79d1\u76ee\u548c\u4e0d\u540c\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u7684\u6210\u5458\u7ec4\u5408\u7684\u63a7\u5236\u65b9\u5f0f", (String)"AllotOrg_4", (String)"epm-eb-formplugin", (Object[])new Object[]{accountMember.getName()})).toString() : stringBuilder.append(ResManager.loadResFormat((String)"\u79d1\u76ee\uff1a%1,\u5df2\u5206\u914d\u4e0d\u5e26\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u6210\u5458\u7684\u63a7\u5236\u65b9\u5f0f", (String)"AllotOrg_5", (String)"epm-eb-formplugin", (Object[])new Object[]{accountMember.getName()})).toString());
                this.handleControlRuleAllotOrgErrorList(errorList, propertyIds, orgPropretyIdMap, modelCache, oldDocs, message);
            } else if (hasSameMember) {
                if (oldRule.getUserDefineDimCount() > 0) {
                    errorList.add(ResManager.loadResFormat((String)"\u79d1\u76ee\uff1a%1\uff0c\u5b58\u5728\u76f8\u540c\u79d1\u76ee\u548c\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u7684\u6210\u5458\u7ec4\u5408\u7684\u63a7\u5236\u65b9\u5f0f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AllotOrg_8", (String)"epm-eb-formplugin", (Object[])new Object[]{accountMember.getName()}));
                } else {
                    errorList.add(ResManager.loadResFormat((String)"\u79d1\u76ee\uff1a%1\uff0c\u5b58\u5728\u4e0d\u5e26\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u6210\u5458\u7684\u63a7\u5236\u65b9\u5f0f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AllotOrg_9", (String)"epm-eb-formplugin", (Object[])new Object[]{accountMember.getName()}));
                }
            } else if (newRule.getUserDefineDimCount() > 0) {
                errorList.add(ResManager.loadResFormat((String)"\u79d1\u76ee\uff1a%1\uff0c\u5b58\u5728\u76f8\u540c\u79d1\u76ee\u548c\u4e0d\u540c\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u7684\u6210\u5458\u7ec4\u5408\u7684\u63a7\u5236\u65b9\u5f0f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AllotOrg_10", (String)"epm-eb-formplugin", (Object[])new Object[]{accountMember.getName()}));
            } else {
                errorList.add(ResManager.loadResFormat((String)"\u79d1\u76ee\uff1a%1\uff0c\u5b58\u5728\u4e0d\u5e26\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u6210\u5458\u7684\u63a7\u5236\u65b9\u5f0f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AllotOrg_9", (String)"epm-eb-formplugin", (Object[])new Object[]{accountMember.getName()}));
            }
        }
    }

    default public boolean checkControlRuleSameMembers(Map<Integer, Long> controlDimMap, Long maxCountControlDimId, Map<Long, Set<Integer>> maxUserDefineMembersIndexMap, Map<Long, Set<Integer>> oldMaxUserDefineMembersIndexMap, ControlRuleAllotOrgPojo newRule, ControlRuleAllotOrgPojo oldRule, List<Long[]> retainRuleMembers, List<Long[]> oldRetainRuleMembers, Set<Integer> accountIndexSet, Set<Integer> oldAccountIndexSet, Set<Integer> accountMemberIndexSet, Set<Integer> oldAccountMemberIndexSet) {
        Set memberIds = maxUserDefineMembersIndexMap == null ? (Set)newRule.getNoOblMembers().get(maxCountControlDimId) : maxUserDefineMembersIndexMap.keySet();
        Set oldMemberIds = oldMaxUserDefineMembersIndexMap == null ? (Set)oldRule.getNoOblMembers().get(maxCountControlDimId) : oldMaxUserDefineMembersIndexMap.keySet();
        Collection<Long> controlDimIds = controlDimMap.values();
        boolean hasOverControlDim = false;
        if (maxUserDefineMembersIndexMap != null && oldMaxUserDefineMembersIndexMap != null) {
            if (memberIds.size() < oldMemberIds.size()) {
                for (Long userDefineMemberId : memberIds) {
                    if (!hasOverControlDim) {
                        Set<Integer> userDefineMemberIndexSet = this.getMemberIndexSet(maxUserDefineMembersIndexMap, userDefineMemberId);
                        Set<Integer> oldUserDefineMemberIndexSet = this.getMemberIndexSet(oldMaxUserDefineMembersIndexMap, userDefineMemberId);
                        if (!oldMemberIds.contains(userDefineMemberId)) continue;
                        hasOverControlDim = this.handleUserDefineMemberOverControlRule(newRule, oldRule, retainRuleMembers, oldRetainRuleMembers, accountIndexSet, oldAccountIndexSet, accountMemberIndexSet, oldAccountMemberIndexSet, controlDimIds, userDefineMemberIndexSet, oldUserDefineMemberIndexSet);
                        continue;
                    }
                    break;
                }
            } else {
                for (Long userDefineMemberId : oldMemberIds) {
                    if (!hasOverControlDim) {
                        Set<Integer> userDefineMemberIndexSet = this.getMemberIndexSet(maxUserDefineMembersIndexMap, userDefineMemberId);
                        Set<Integer> oldUserDefineMemberIndexSet = this.getMemberIndexSet(oldMaxUserDefineMembersIndexMap, userDefineMemberId);
                        if (!memberIds.contains(userDefineMemberId)) continue;
                        hasOverControlDim = this.handleUserDefineMemberOverControlRule(newRule, oldRule, retainRuleMembers, oldRetainRuleMembers, accountIndexSet, oldAccountIndexSet, accountMemberIndexSet, oldAccountMemberIndexSet, controlDimIds, userDefineMemberIndexSet, oldUserDefineMemberIndexSet);
                        continue;
                    }
                    break;
                }
            }
        } else if (maxUserDefineMembersIndexMap == null && oldMaxUserDefineMembersIndexMap == null) {
            hasOverControlDim = this.handleHasNotMaxUserDefineControlDim(newRule, oldRule, controlDimIds);
        } else if (maxUserDefineMembersIndexMap != null) {
            Long userDefineMemberId;
            Set<Integer> userDefineMemberIndexSet;
            Iterator iterator = memberIds.iterator();
            while (iterator.hasNext() && !(hasOverControlDim = this.handleHasNewMaxUserDefineControlDim(newRule, oldRule, retainRuleMembers, accountIndexSet, accountMemberIndexSet, controlDimIds, userDefineMemberIndexSet = this.getMemberIndexSet(maxUserDefineMembersIndexMap, userDefineMemberId = (Long)iterator.next())))) {
            }
        } else {
            Long userDefineMemberId;
            Set<Integer> oldUserDefineMemberIndexSet;
            Iterator iterator = oldMemberIds.iterator();
            while (iterator.hasNext() && !(hasOverControlDim = this.handleHasOldMaxUserDefineControlDim(newRule, oldRule, oldRetainRuleMembers, oldAccountIndexSet, oldAccountMemberIndexSet, controlDimIds, oldUserDefineMemberIndexSet = this.getMemberIndexSet(oldMaxUserDefineMembersIndexMap, userDefineMemberId = (Long)iterator.next())))) {
            }
        }
        boolean hasOver = hasOverControlDim;
        return hasOver;
    }

    default public boolean handleHasOldMaxUserDefineControlDim(ControlRuleAllotOrgPojo newRule, ControlRuleAllotOrgPojo oldRule, List<Long[]> oldRetainRuleMembers, Set<Integer> oldAccountIndexSet, Set<Integer> oldAccountMemberIndexSet, Collection<Long> controlDimIds, Set<Integer> oldUserDefineMemberIndexSet) {
        oldAccountIndexSet.clear();
        if (oldAccountMemberIndexSet != null) {
            oldAccountIndexSet.addAll(oldAccountMemberIndexSet);
        }
        oldRetainRuleMembers.clear();
        if (oldUserDefineMemberIndexSet != null) {
            oldAccountIndexSet.retainAll(oldUserDefineMemberIndexSet);
        }
        for (Integer index : oldAccountIndexSet) {
            if (oldRule.getOblMembers().size() <= index) continue;
            oldRetainRuleMembers.add((Long[])oldRule.getOblMembers().get(index));
        }
        boolean hasOverOtherControlDim = true;
        boolean loopCount = false;
        if (oldAccountIndexSet != null && oldRetainRuleMembers.isEmpty()) {
            hasOverOtherControlDim = false;
        } else {
            HashSet memberIds = new HashSet(16);
            for (Long controlDim : controlDimIds) {
                if (newRule.getAllMemberDimIds().contains(controlDim) || oldRule.getAllMemberDimIds().contains(controlDim) || newRule.getNoOblMembers().get(controlDim) == null || oldRule.getNoOblMembers().get(controlDim) == null) continue;
                memberIds.clear();
                memberIds.addAll((Collection)newRule.getNoOblMembers().get(controlDim));
                memberIds.retainAll((Collection)oldRule.getNoOblMembers().get(controlDim));
                if (!memberIds.isEmpty()) continue;
                hasOverOtherControlDim = false;
                break;
            }
            if (hasOverOtherControlDim) {
                if (oldRetainRuleMembers.isEmpty()) {
                    oldRetainRuleMembers.add(new Long[0]);
                }
                block2: for (Long[] oldRuleRuleMember : oldRetainRuleMembers) {
                    for (Long controlDim : controlDimIds) {
                        if (!newRule.getOblDimIndexes().containsKey(controlDim) && !oldRule.getOblDimIndexes().containsKey(controlDim)) continue;
                        memberIds.clear();
                        if (oldRule.getOblDimIndexes().containsKey(controlDim)) {
                            memberIds.addAll(Sets.newHashSet((Object[])new Long[]{oldRuleRuleMember[(Integer)oldRule.getOblDimIndexes().get(controlDim)]}));
                        } else if (oldRule.getNoOblMembers().get(controlDim) != null) {
                            memberIds.addAll((Collection)oldRule.getNoOblMembers().get(controlDim));
                        }
                        if (newRule.getAllMemberDimIds().contains(controlDim) || newRule.getNoOblMembers().get(controlDim) == null) continue;
                        memberIds.retainAll((Collection)newRule.getNoOblMembers().get(controlDim));
                        if (!memberIds.isEmpty()) continue;
                        hasOverOtherControlDim = false;
                        break block2;
                    }
                }
            }
        }
        boolean hasOverControlDim = hasOverOtherControlDim;
        return hasOverControlDim;
    }

    default public boolean handleHasNewMaxUserDefineControlDim(ControlRuleAllotOrgPojo newRule, ControlRuleAllotOrgPojo oldRule, List<Long[]> retainRuleMembers, Set<Integer> accountIndexSet, Set<Integer> accountMemberIndexSet, Collection<Long> controlDimIds, Set<Integer> userDefineMemberIndexSet) {
        accountIndexSet.clear();
        if (accountMemberIndexSet != null) {
            accountIndexSet.addAll(accountMemberIndexSet);
        }
        retainRuleMembers.clear();
        if (userDefineMemberIndexSet != null) {
            accountIndexSet.retainAll(userDefineMemberIndexSet);
        }
        for (Integer index : accountIndexSet) {
            if (newRule.getOblMembers().size() <= index) continue;
            retainRuleMembers.add((Long[])newRule.getOblMembers().get(index));
        }
        boolean hasOverOtherControlDim = true;
        boolean loopCount = false;
        if (accountMemberIndexSet != null && retainRuleMembers.isEmpty()) {
            hasOverOtherControlDim = false;
        } else {
            HashSet<Long> memberIds = new HashSet<Long>(16);
            for (Long controlDim : controlDimIds) {
                if (newRule.getAllMemberDimIds().contains(controlDim) || oldRule.getAllMemberDimIds().contains(controlDim) || newRule.getNoOblMembers().get(controlDim) == null || oldRule.getNoOblMembers().get(controlDim) == null) continue;
                memberIds.clear();
                memberIds.addAll((Collection)newRule.getNoOblMembers().get(controlDim));
                memberIds.retainAll((Collection)oldRule.getNoOblMembers().get(controlDim));
                if (!memberIds.isEmpty()) continue;
                hasOverOtherControlDim = false;
                break;
            }
            if (hasOverOtherControlDim) {
                if (retainRuleMembers.isEmpty()) {
                    retainRuleMembers.add(new Long[0]);
                }
                block2: for (Long[] ruleMember : retainRuleMembers) {
                    for (Long controlDim : controlDimIds) {
                        if (!newRule.getOblDimIndexes().containsKey(controlDim) && !oldRule.getOblDimIndexes().containsKey(controlDim)) continue;
                        memberIds.clear();
                        if (newRule.getOblDimIndexes().containsKey(controlDim)) {
                            memberIds.add(ruleMember[(Integer)newRule.getOblDimIndexes().get(controlDim)]);
                        } else if (newRule.getNoOblMembers().get(controlDim) != null) {
                            memberIds.addAll((Collection)newRule.getNoOblMembers().get(controlDim));
                        }
                        if (oldRule.getAllMemberDimIds().contains(controlDim) || oldRule.getNoOblMembers().get(controlDim) == null) continue;
                        memberIds.retainAll((Collection)oldRule.getNoOblMembers().get(controlDim));
                        if (!memberIds.isEmpty()) continue;
                        hasOverOtherControlDim = false;
                        break block2;
                    }
                }
            }
        }
        boolean hasOverControlDim = hasOverOtherControlDim;
        return hasOverControlDim;
    }

    default public boolean handleHasNotMaxUserDefineControlDim(ControlRuleAllotOrgPojo newRule, ControlRuleAllotOrgPojo oldRule, Collection<Long> controlDimIds) {
        HashSet memberIds = new HashSet(16);
        boolean hasOverOtherControlDim = true;
        for (Long controlDim : controlDimIds) {
            if (newRule.getAllMemberDimIds().contains(controlDim) || oldRule.getAllMemberDimIds().contains(controlDim) || newRule.getNoOblMembers().get(controlDim) == null || oldRule.getNoOblMembers().get(controlDim) == null) continue;
            memberIds.clear();
            memberIds.addAll((Collection)newRule.getNoOblMembers().get(controlDim));
            memberIds.retainAll((Collection)oldRule.getNoOblMembers().get(controlDim));
            if (!memberIds.isEmpty()) continue;
            hasOverOtherControlDim = false;
            break;
        }
        return hasOverOtherControlDim;
    }

    default public boolean handleUserDefineMemberOverControlRule(ControlRuleAllotOrgPojo newRule, ControlRuleAllotOrgPojo oldRule, List<Long[]> retainRuleMembers, List<Long[]> oldRetainRuleMembers, Set<Integer> accountIndexSet, Set<Integer> oldAccountIndexSet, Set<Integer> accountMemberIndexSet, Set<Integer> oldAccountMemberIndexSet, Collection<Long> controlDimIds, Set<Integer> userDefineMemberIndexSet, Set<Integer> oldUserDefineMemberIndexSet) {
        accountIndexSet.clear();
        oldAccountIndexSet.clear();
        if (accountMemberIndexSet != null) {
            accountIndexSet.addAll(accountMemberIndexSet);
        }
        if (oldAccountMemberIndexSet != null) {
            oldAccountIndexSet.addAll(oldAccountMemberIndexSet);
        }
        retainRuleMembers.clear();
        oldRetainRuleMembers.clear();
        if (userDefineMemberIndexSet != null) {
            accountIndexSet.retainAll(userDefineMemberIndexSet);
        }
        if (oldUserDefineMemberIndexSet != null) {
            oldAccountIndexSet.retainAll(oldUserDefineMemberIndexSet);
        }
        for (Integer index : accountIndexSet) {
            if (newRule.getOblMembers().size() <= index) continue;
            retainRuleMembers.add((Long[])newRule.getOblMembers().get(index));
        }
        for (Integer index : oldAccountIndexSet) {
            if (oldRule.getOblMembers().size() <= index) continue;
            oldRetainRuleMembers.add((Long[])oldRule.getOblMembers().get(index));
        }
        boolean hasOverOtherControlDim = true;
        boolean loopCount = false;
        if (accountMemberIndexSet != null && retainRuleMembers.isEmpty()) {
            hasOverOtherControlDim = false;
        } else if (oldAccountIndexSet != null && oldRetainRuleMembers.isEmpty()) {
            hasOverOtherControlDim = false;
        } else {
            HashSet<Long> memberIds = new HashSet<Long>(16);
            for (Long controlDim : controlDimIds) {
                if (newRule.getAllMemberDimIds().contains(controlDim) || oldRule.getAllMemberDimIds().contains(controlDim) || newRule.getNoOblMembers().get(controlDim) == null || oldRule.getNoOblMembers().get(controlDim) == null) continue;
                memberIds.clear();
                memberIds.addAll((Collection)newRule.getNoOblMembers().get(controlDim));
                memberIds.retainAll((Collection)oldRule.getNoOblMembers().get(controlDim));
                if (!memberIds.isEmpty()) continue;
                hasOverOtherControlDim = false;
                break;
            }
            if (hasOverOtherControlDim) {
                if (retainRuleMembers.isEmpty()) {
                    retainRuleMembers.add(new Long[0]);
                }
                if (oldRetainRuleMembers.isEmpty()) {
                    oldRetainRuleMembers.add(new Long[0]);
                }
                block3: for (Long[] ruleMember : retainRuleMembers) {
                    for (Long[] oldRuleRuleMember : oldRetainRuleMembers) {
                        for (Long controlDim : controlDimIds) {
                            if (!newRule.getOblDimIndexes().containsKey(controlDim) && !oldRule.getOblDimIndexes().containsKey(controlDim)) continue;
                            memberIds.clear();
                            if (newRule.getOblDimIndexes().containsKey(controlDim)) {
                                memberIds.add(ruleMember[(Integer)newRule.getOblDimIndexes().get(controlDim)]);
                            } else if (newRule.getNoOblMembers().get(controlDim) != null) {
                                memberIds.addAll((Collection)newRule.getNoOblMembers().get(controlDim));
                            }
                            if (oldRule.getOblDimIndexes().containsKey(controlDim)) {
                                memberIds.retainAll(Sets.newHashSet((Object[])new Long[]{oldRuleRuleMember[(Integer)oldRule.getOblDimIndexes().get(controlDim)]}));
                            } else {
                                memberIds.retainAll((Collection)oldRule.getNoOblMembers().get(controlDim));
                            }
                            if (!memberIds.isEmpty()) continue;
                            hasOverOtherControlDim = false;
                            break block3;
                        }
                    }
                }
            }
        }
        boolean hasOverControlDim = hasOverOtherControlDim;
        return hasOverControlDim;
    }

    default public void handleControlRuleAllotOrgErrorList(List<String> errorList, Set<Long> propertyIds, Map<Long, HashSet<Long>> orgPropretyIdMap, IModelCacheHelper modelcache, List<Map<String, String>> oldDocs, String message) {
        for (Map<String, String> doc : oldDocs) {
            String errMessage = "";
            if (doc.get("type") != null && "property".equals(doc.get("type"))) {
                HashSet<Long> orgId = orgPropretyIdMap.get(IDUtils.toLong((Object)doc.get("orgId")));
                String orgName = orgId.stream().map(k -> modelcache.getDimension("Entity").getStructOfMember(k).getName()).collect(Collectors.joining("\u3001"));
                errMessage = ResManager.loadResFormat((String)"\u7ec4\u7ec7\uff1a%1\uff0c\u81ea\u5b9a\u4e49\u5c5e\u6027\uff1a%2", (String)"AllotOrg_12", (String)"epm-eb-formplugin", (Object[])new Object[]{orgName, doc.get("orgName")});
            } else {
                errMessage = errMessage + ResManager.loadResFormat((String)"\u7ec4\u7ec7\uff1a%1", (String)"AllotOrg_1", (String)"epm-eb-formplugin", (Object[])new Object[]{doc.get("orgName")});
            }
            errMessage = ResManager.loadResFormat((String)"%1\uff0c%2", (String)"AllotOrg_11", (String)"epm-eb-formplugin", (Object[])new Object[]{errMessage, message});
            if (doc.get("type") != null && "property".equals(doc.get("type")) && propertyIds.stream().noneMatch(k -> k.equals(IDUtils.toLong(doc.get("orgId"))))) {
                errMessage = ResManager.loadResFormat((String)"%1\uff0c\u540c\u4e00\u4e2a\u7ec4\u7ec7\u5173\u8054\u7684\u591a\u4e2a\u81ea\u5b9a\u4e49\u5c5e\u6027\u6210\u5458\u4e0d\u5141\u8bb8\u5206\u914d\u76f8\u540c\u7ef4\u5ea6\u6210\u5458\u7684\u63a7\u5236\u65b9\u5f0f", (String)"AllotOrg_6", (String)"epm-eb-formplugin", (Object[])new Object[]{errMessage});
            }
            errMessage = ResManager.loadResFormat((String)"%1\uff0c\u8bf7\u68c0\u67e5", (String)"AllotOrg_7", (String)"epm-eb-formplugin", (Object[])new Object[]{errMessage});
            errorList.add(errMessage);
        }
    }

    default public Map<Long, HashSet<Long>> getSameOrgPropretyIds(Set<Long> propertyIds) {
        HashMap<Long, HashSet<Long>> proOrgMap = new HashMap<Long, HashSet<Long>>(16);
        if (CollectionUtils.isEmpty(propertyIds)) {
            return proOrgMap;
        }
        StringBuilder sql = new StringBuilder("select fpropertyvalueid,fid from t_eb_memberpropertyvalue where fid in (select fid from t_eb_memberpropertyvalue where fpropertyvalueid in ( ");
        sql.append(StringUtils.join(propertyIds, (String)","));
        sql.append("))");
        try (DataSet ds = DB.queryDataSet((String)"dimensionpropertyById", (DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), null);){
            if (ds != null) {
                Row row = null;
                while (ds.hasNext()) {
                    row = ds.next();
                    Set orgIds = proOrgMap.computeIfAbsent(row.getLong("fpropertyvalueid"), k -> Sets.newHashSet());
                    orgIds.add(row.getLong("fid"));
                }
            }
        }
        return proOrgMap;
    }

    public List<OrgMemberDto> getCheckedOrg();

    default public List<String> checkSelf(List<ControlRuleAllotOrgPojo> rules, IModelCacheHelper modelCache, Long accountId) {
        return Lists.newArrayList();
    }

    public Long getBussModelId();
}

