/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Sets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.flex.FlexType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.businessfield.FlexField;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.billlist.BillListUtil;
import kd.epm.eb.common.enums.BgBillTreeTypeEnum;
import kd.epm.eb.common.enums.BillFieldTypeEmum;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.TreeNodeUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.control.utils.BgRegisterUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;

public class BillFieldAddPlugin
extends AbstractListPlugin
implements ClickListener,
TreeNodeClickListener,
BeforeF7SelectListener,
TreeNodeQueryListener {
    private static final Log log = LogFactory.getLog(BillFieldAddPlugin.class);
    private static final String CACHE_NUMBER_AND_NAME = "cacheLeftTreeNumberAndName";
    private static final String regedEntityNums = "regedEntityNums";
    public static final String rightTreeNodeNumbers = "rightTreeNodeNumbers";
    public static final String rightCurrentNode = "rightCurrentNode";
    protected static final String treeLeft = "treeleft";
    protected static final String treeRight = "treeright";
    private static final String beginTreeRight = "beginTreeRight";
    private static final String formtype = "formtype";

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeleft = (TreeView)this.getView().getControl(treeLeft);
        TreeView treeright = (TreeView)this.getView().getControl(treeRight);
        BasedataEdit application = (BasedataEdit)this.getView().getControl("application");
        BasedataEdit bill = (BasedataEdit)this.getView().getControl("bill");
        application.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        bill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        treeleft.addTreeNodeClickListener((TreeNodeClickListener)this);
        treeright.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                String nodeId = evt.getNodeId().toString();
                BillFieldAddPlugin.this.cacheCurrentNodeId(nodeId);
            }
        });
        treeleft.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        this.addClickListeners(new String[]{"baradd", "baritemaddlevel"});
        this.addClickListeners(new String[]{"btngo", "btnallgo", "btnback", "btnallback", "addreg"});
        this.addClickListeners(new String[]{"allchoose", "allclear", "allexpand", "allshrink"});
        this.addClickListeners(new String[]{"searchbefore", "searchnext", "searchbefore1", "searchnext1"});
        Search sl = (Search)this.getControl("searchapleft");
        sl.addEnterListener(event -> TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), this.getView(), this.getPageCache(), new TreeSearchUtil.TreeSearchParam(treeLeft, treeLeft, "left")));
        Search s2 = (Search)this.getControl("searchapright");
        s2.addEnterListener(event -> TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), this.getView(), this.getPageCache(), new TreeSearchUtil.TreeSearchParam(treeRight, treeRight, "right")));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("application") != null) {
            this.getModel().setValue("application", customParams.get("application"));
        }
        this.setVisible(customParams);
        if (customParams.get("bill") != null) {
            this.getModel().setValue("bill", customParams.get("bill"));
            this.propertyChange_bill();
        }
    }

    private void setVisible(Map<String, Object> customParams) {
        if ("operation".equals(customParams.get(formtype))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"addreg"});
            Label btngo = (Label)this.getControl("btngo");
            btngo.setText(ResManager.loadKDString((String)"\u6dfb\u52a0", (String)"BillFieldAddPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void propertyChange_bill() {
        this.inittreeLeft();
        this.inittreeRight();
        this.checkRegedDataIsChanged();
        this.cacheDeleteNodeIds(null);
        String showtype = (String)this.getValue("showtype", null);
        this.changeShowType(showtype);
    }

    public void checkRegedDataIsChanged() {
        TreeNode rightTree = this.getCacheRightRoot();
        Map<String, String> leftTreeNumAndNames = this.getLeftNodeNumAndNameMap();
        ArrayList nodeList = new ArrayList(16);
        TreeNodeUtils.treeConvertList((TreeNode)rightTree, nodeList);
        StringBuilder errorInfo = new StringBuilder();
        if (leftTreeNumAndNames != null) {
            for (TreeNode node : nodeList) {
                Map nodeData = (Map)node.getData();
                if (nodeData == null || nodeData.get("nodeType") == null) continue;
                String name = node.getText();
                String number = node.getLongNumber();
                if (leftTreeNumAndNames.containsKey(number)) continue;
                errorInfo.append(name);
                errorInfo.append("(");
                errorInfo.append(number);
                errorInfo.append("),");
            }
            if (errorInfo.length() != 0) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5b57\u6bb5\uff1a%1 \u5728\u6ce8\u518c\u6e90\u4e2d\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BillFieldAddPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{errorInfo.substring(0, errorInfo.length() - 1)}));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        if ("changepage".equals(mbce.getCallBackId()) && MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
            this.getModel().setDataChanged(false);
            this.openNewPage("baritemaddlevel");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("valueexpression".equals(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            Object expression = returnData.get("expression");
            Object subject = returnData.get("subject");
            if (expression == null || subject == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c5e\u6027\u7684\u7f16\u7801\u6216\u540d\u79f0\u4e3a\u7a7a\u3002", (String)"BillFieldAddPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeView rightTree = (TreeView)this.getView().getControl(treeRight);
            String focusNodeId = this.getPageCache().get(rightCurrentNode);
            if (focusNodeId == null) {
                String form = (String)this.getView().getFormShowParameter().getCustomParam(formtype);
                if (!"operation".equals(form)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f3\u4fa7\u5217\u8868\u4e2d\u7684\u8282\u70b9\u3002", (String)"BillFieldAddPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                focusNodeId = "7";
            } else {
                if ("-1".equals(focusNodeId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f3\u4fa7\u7684\u7b2c\u4e8c\u5c42\u8282\u70b9\u3002", (String)"BillFieldAddPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (Long.parseLong(focusNodeId) > (long)BillFieldTypeEmum.values().length) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f3\u4fa7\u7684\u7b2c\u4e8c\u5c42\u8282\u70b9\u3002", (String)"BillFieldAddPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            TreeNode rightRoot = this.getCacheRightRoot();
            TreeNode rightFocusNode = rightRoot.getTreeNode(focusNodeId, 10);
            List<String> cacheRightNumbers = this.getCacheRightNumbers();
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            if (cacheRightNumbers.contains(expression.toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u8df3\u8fc7\u53f3\u4fa7\u5217\u8868\u4e2d\u5b58\u5728\u7684\u5b57\u6bb5\u3002", (String)"BillFieldAddPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                ArrayList<TreeNode> children = rightFocusNode.getChildren();
                if (children == null) {
                    children = new ArrayList<TreeNode>();
                    rightFocusNode.setChildren(children);
                }
                TreeNode newNode = new TreeNode();
                newNode.setId(String.valueOf(DBServiceHelper.genGlobalLongId()));
                newNode.setText(subject.toString());
                newNode.setLongNumber(expression.toString());
                data.put("fieldAlias", expression.toString());
                data.put("name", subject.toString());
                data.put("isentryfield", false);
                data.put("isnew", true);
                newNode.setData(data);
                children.add(newNode);
                cacheRightNumbers.add(expression.toString());
            }
            this.cacheRightRoot(rightRoot);
            this.cacheRightNumbers(cacheRightNumbers);
            rightTree.updateNode(rightRoot);
            rightTree.expand(rightRoot.getId());
            rightTree.expand(focusNodeId);
            rightTree.focusNode(rightFocusNode);
        }
    }

    private void openNewPage(String key) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(16);
        map.put("openNewPage", true);
        this.getView().returnDataToParent(map);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_addbillfield");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.ADDNEW);
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam(formtype);
        showParameter.setCustomParam(formtype, (Object)customParam);
        if ("operation".equals(customParam)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u5355\u636e\u64cd\u4f5c\u6ce8\u518c", (String)"BillFieldAddPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            showParameter.setCaption(ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5\u6ce8\u518c", (String)"BillFieldAddPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm(showParameter);
        this.getView().close();
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        this.addEntityFields(nodeId);
    }

    public void queryTreeNodeChildren(TreeNodeEvent paramTreeNodeEvent) {
        Map data;
        TreeNode root = this.getCacheLeftRoot();
        if (root == null || paramTreeNodeEvent == null || paramTreeNodeEvent.getNodeId() == null || root.getTreeNode(String.valueOf(paramTreeNodeEvent.getNodeId())) == null) {
            return;
        }
        TreeNode node = root.getTreeNode(String.valueOf(paramTreeNodeEvent.getNodeId()));
        String valueSource = null;
        if (node.getData() instanceof Map && (data = (Map)node.getData()).get("valueSource") != null) {
            valueSource = String.valueOf(data.get("valueSource"));
        }
        if (StringUtils.isNotEmpty(valueSource)) {
            Map<String, String> nodeNumberAndNameMap = this.getLeftNodeNumAndNameMap();
            this.queryChildNodeProp(nodeNumberAndNameMap, valueSource, node);
            this.cacheLeftNodeNumAndNameMap(nodeNumberAndNameMap);
            this.cacheLeftRoot(root);
            node.setIsOpened(true);
            TreeView treeleft = (TreeView)this.getView().getControl(treeLeft);
            if (treeleft != null) {
                treeleft.updateNode(root);
                treeleft.focusNode(node);
            }
        }
    }

    private void addEntityFields(String nodeId) {
        TreeNode leftTreeNode = this.getCacheLeftRoot();
        TreeNode currentNode = leftTreeNode.getTreeNode(nodeId, 5);
        if (currentNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u8282\u70b9\u4fe1\u606f\u5931\u8d25\u3002", (String)"BillFieldAddPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObject app = (DynamicObject)this.getModel().getValue("application");
        if (app == null || app.getString("longnumber") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e94\u7528\uff08\u6570\u636e\u6e90\uff09\u4fe1\u606f\u5931\u8d25", (String)"BillFieldAddPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Map nodeDate = (Map)currentNode.getData();
        Long sourceId = app.getLong("longnumber");
        if (nodeDate == null) {
            return;
        }
        String fieldType = (String)nodeDate.get("fieldType");
        if (fieldType == null || !fieldType.equals("REF")) {
            return;
        }
        String fieldTabel = (String)nodeDate.get("fieldTable");
        QFBuilder qb = new QFBuilder();
        qb.add("group", "=", (Object)sourceId);
        qb.add("number", "=", (Object)fieldTabel);
        try {
            DynamicObjectCollection entityProp = QueryServiceHelper.query((String)"isc_metadata_schema", (String)"prop_entryentity.prop_name as propNum,prop_entryentity.prop_label as propName,prop_entryentity.id as propId", (QFilter[])qb.toArrays());
            Map<String, String> nodeNumberAndNameMap = this.getLeftNodeNumAndNameMap();
            if (entityProp == null || entityProp.isEmpty()) {
                throw new Exception();
            }
            TreeNode child = null;
            currentNode.setChildren(null);
            for (DynamicObject prop : entityProp) {
                String nubmer = prop.getString("propNum");
                String name = prop.getString("propName");
                child = this.createChildNode(nubmer, name, null, null, currentNode, true, nodeNumberAndNameMap);
                currentNode.addChild(child);
            }
            this.cacheLeftRoot(leftTreeNode);
            TreeView treeLeft = (TreeView)this.getView().getControl(treeLeft);
            treeLeft.deleteAllNodes();
            treeLeft.addNode(leftTreeNode);
            treeLeft.expand(leftTreeNode.getId());
            treeLeft.checkNodeWithoutChild(currentNode);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ece\u96c6\u6210\u5e73\u53f0\u83b7\u53d6\u8be5\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u662f\u5426\u5b58\u5728\u3002", (String)"BillFieldAddPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public Map<String, String> getLeftNodeNumAndNameMap() {
        Map<String, String> nodeNumberAndNameMap = new HashMap<String, String>(16);
        String str = this.getPageCache().get(CACHE_NUMBER_AND_NAME);
        if (str != null) {
            nodeNumberAndNameMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_NUMBER_AND_NAME), Map.class);
        }
        return nodeNumberAndNameMap;
    }

    public void cacheLeftNodeNumAndNameMap(Map<String, String> nodeNumberAndNameMap) {
        if (nodeNumberAndNameMap != null) {
            this.getPageCache().put(CACHE_NUMBER_AND_NAME, SerializationUtils.toJsonString(nodeNumberAndNameMap));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter showParameter;
        if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals("application")) {
            showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<? extends QFilter> qFilters = ((BasedataEdit)this.getControl("application")).getQFilters();
            if (qFilters == null) {
                qFilters = new ArrayList<QFilter>(16);
            }
            qFilters.addAll(this.getModelIdQfilter(BgBillTreeTypeEnum.APPLICATION.getNumber()));
            qFilters.add(this.getOuterFilter());
            showParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
        }
        if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals("bill")) {
            showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> billQfilters = ((BasedataEdit)this.getControl("bill")).getQFilters();
            DynamicObject application = (DynamicObject)this.getModel().getValue("application");
            if (application == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e94\u7528", (String)"BillFieldAddPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Long parent = application.getLong("id");
            if (billQfilters == null) {
                billQfilters = new ArrayList<QFilter>(16);
            }
            billQfilters.add(new QFilter("parent", "=", (Object)parent));
            billQfilters.addAll(this.getModelIdQfilter(BgBillTreeTypeEnum.BILL.getNumber()));
            showParameter.setListFilterParameter(new ListFilterParameter(billQfilters, null));
        }
    }

    private QFilter getOuterFilter() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String actionType = (String)formShowParameter.getCustomParam(formtype);
        QFilter qf = null;
        if ("operation".equals(actionType)) {
            qf = new QFilter("isfromouter", "=", (Object)false);
        }
        return qf;
    }

    private Collection<? extends QFilter> getModelIdQfilter(String billTreeType) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("billtype", "=", (Object)billTreeType));
        return qFilters;
    }

    private void inittreeLeft() {
        TreeView treeleft = (TreeView)this.getView().getControl(treeLeft);
        DynamicObject bill = (DynamicObject)this.getModel().getValue("bill");
        String id = bill.getString("id");
        String name = bill.getLocaleString("name").getLocaleValue();
        String number = bill.getString("number");
        String operation = (String)this.getView().getFormShowParameter().getCustomParam(formtype);
        TreeNode root = "operation".equals(operation) ? this.initOperationLeftTree() : this.initFieldLeftTree();
        root.setId(id);
        root.setText(name);
        root.setLongNumber(number);
        root.setData(new HashMap(16));
        treeleft.deleteAllNodes();
        this.cacheLeftRoot(root);
        treeleft.addNode(root);
        treeleft.updateNode(root);
        treeleft.expand(root.getId());
    }

    private void inittreeLeft(String showType) {
        TreeView treeleft = (TreeView)this.getView().getControl(treeLeft);
        TreeNode rootleft = this.getCacheLeftRoot();
        if (rootleft == null) {
            return;
        }
        this.dealNode(rootleft, showType);
        this.cacheLeftRoot(rootleft);
        List checkedNodeIds = treeleft.getTreeState().getCheckedNodeIds();
        treeleft.updateNode(rootleft);
        for (String id : checkedNodeIds) {
            TreeNode treeNode = rootleft.getTreeNode(id, 20);
            treeleft.checkNode(treeNode);
        }
        treeleft.expand(rootleft.getId());
    }

    private void inittreeRight(String showType) {
        TreeView treeright = (TreeView)this.getView().getControl(treeRight);
        TreeNode rootright = this.getCacheRightRoot();
        if (rootright == null) {
            return;
        }
        this.dealNode(rootright, showType);
        this.cacheRightRoot(rootright);
        List checkedNodeIds = treeright.getTreeState().getCheckedNodeIds();
        treeright.updateNode(rootright);
        for (String id : checkedNodeIds) {
            TreeNode treeNode = rootright.getTreeNode(id, 20);
            treeright.checkNode(treeNode);
        }
        treeright.expand(rootright.getId());
    }

    private void dealNode(TreeNode node, String showType) {
        if (node.getData() != null && ((Map)node.getData()).get("name") != null && ((Map)node.getData()).get("number") != null) {
            String text;
            switch (showType) {
                case "1": {
                    text = (String)((Map)node.getData()).get("number");
                    break;
                }
                case "2": {
                    text = ((Map)node.getData()).get("number") + " " + ((Map)node.getData()).get("name");
                    break;
                }
                default: {
                    text = (String)((Map)node.getData()).get("name");
                }
            }
            node.setText(text);
        }
        if (node.getChildren() != null) {
            for (TreeNode treeNode : node.getChildren()) {
                this.dealNode(treeNode, showType);
            }
        }
    }

    private void inittreeRight() {
        TreeView treeright = (TreeView)this.getView().getControl(treeRight);
        TreeNode rightRoot = this.getRigthRoot();
        this.cacheBeginRightRoot(rightRoot);
        this.cacheRightRoot(rightRoot);
        treeright.deleteAllNodes();
        if (rightRoot == null) {
            return;
        }
        treeright.addNode(rightRoot);
        treeright.updateNode(rightRoot);
        treeright.focusNode((TreeNode)rightRoot.getChildren().get(0));
        this.cacheCurrentNodeId(((TreeNode)rightRoot.getChildren().get(0)).getId());
        rightRoot.setIsOpened(true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newVal = e.getChangeSet()[0].getNewValue();
        if ("bill".equals(name)) {
            if (newVal == null) {
                this.getModel().getDataEntity().set("bill", e.getChangeSet()[0].getOldValue());
            } else {
                this.propertyChange_bill();
            }
        } else if ("showtype".equals(name)) {
            String newValue = (String)newVal;
            this.changeShowType(newValue);
        } else if ("application".equals(name)) {
            String newBillId = null;
            if (newVal != null) {
                Long parentId = ((DynamicObject)newVal).getLong("id");
                QFBuilder qb = new QFBuilder();
                qb.add("parent", "=", (Object)parentId);
                DynamicObject bill = QueryServiceHelper.queryOne((String)"eb_structofbill", (String)"id", (QFilter[])qb.toArrays());
                if (bill != null) {
                    newBillId = bill.getString("id");
                }
                this.getModel().setValue("bill", (Object)newBillId);
            } else {
                this.getModel().getDataEntity().set("application", e.getChangeSet()[0].getOldValue());
            }
        }
    }

    private void changeShowType(String showType) {
        this.getPageCache().put("showtype", showType);
        this.inittreeLeft(showType);
        this.inittreeRight(showType);
    }

    public void click(EventObject evt) {
        TreeNode leftRoot;
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "baradd": {
                String type = (String)this.getView().getFormShowParameter().getCustomParam(formtype);
                if (this.checkCurrentDataIsNew(type)) {
                    this.baradd();
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5df2\u88ab\u4fee\u6539\uff0c\u5c06\u91cd\u65b0\u52a0\u8f7d\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"BillFieldAddPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.getModel().createNewData();
                break;
            }
            case "baritemaddlevel": {
                this.baradd();
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                HashMap<String, Boolean> map = new HashMap<String, Boolean>(16);
                map.putAll(customParams);
                map.put("opennewpage", true);
                this.getView().returnDataToParent(map);
                this.getView().close();
                break;
            }
            case "btngo": {
                this.btngo();
                break;
            }
            case "btnback": {
                this.btnback();
                break;
            }
            case "addreg": {
                this.addreg();
            }
        }
        if ("allchoose".equals(key)) {
            leftRoot = this.getCacheLeftRoot();
            if (leftRoot == null) {
                return;
            }
            TreeView treeleft = (TreeView)this.getView().getControl(treeLeft);
            ArrayList treeList = new ArrayList(16);
            TreeNodeUtils.treeConvertList((TreeNode)leftRoot, treeList);
            treeleft.checkNodes(treeList);
        } else if ("allclear".equals(key)) {
            leftRoot = this.getCacheLeftRoot();
            if (leftRoot == null) {
                return;
            }
            TreeView treeleft = (TreeView)this.getView().getControl(treeLeft);
            this.allClear(leftRoot, treeleft);
        } else if ("allexpand".equals(key)) {
            this.spreadAll();
        } else if ("allshrink".equals(key)) {
            this.collapseAll();
        } else if ("searchbefore".equals(key)) {
            TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(treeRight, treeRight, "right", TreeSearchUtil.SearchBtnStatus.LEFT));
        } else if ("searchnext".equals(key)) {
            TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(treeRight, treeRight, "right", TreeSearchUtil.SearchBtnStatus.RIGHT));
        } else if ("searchbefore1".equals(key)) {
            TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(treeLeft, treeLeft, "left", TreeSearchUtil.SearchBtnStatus.LEFT));
        } else if ("searchnext1".equals(key)) {
            TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(treeLeft, treeLeft, "left", TreeSearchUtil.SearchBtnStatus.RIGHT));
        }
    }

    private void addreg() {
        String isFromOuter = (String)this.getView().getFormShowParameter().getCustomParam("isFromOuter");
        if (isFromOuter != null && isFromOuter.equals("true")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5916\u90e8\u5355\u636e\u4e0d\u5141\u8bb8\u6dfb\u52a0\u5c5e\u6027\u3002", (String)"BillFieldAddPlugin_49", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String focusNodeId = this.getPageCache().get(rightCurrentNode);
        if (!String.valueOf(BillFieldTypeEmum.REGSITFIELD.getIndex()).equals(focusNodeId)) {
            TreeNode rightRoot = this.getCacheRightRoot();
            TreeNode childNode = rightRoot.getTreeNode(String.valueOf(BillFieldTypeEmum.REGSITFIELD.getIndex()));
            if (childNode != null && (childNode = childNode.getTreeNode(focusNodeId)) != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e0a\u7ea7\u5206\u7c7b\u8282\u70b9\u201c\u63a7\u5236\u6761\u4ef6\u201d\u540e\u6dfb\u52a0\u5c5e\u6027\u3002", (String)"BillFieldAddPlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u5728\u63a7\u5236\u6761\u4ef6\u8282\u70b9\u4e0b\u6dfb\u52a0\u5c5e\u6027\u3002", (String)"BillFieldAddPlugin_46", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openPage();
    }

    private void openPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_valueexpression");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        DynamicObject application = (DynamicObject)this.getModel().getValue("application");
        DynamicObject bill = (DynamicObject)this.getModel().getValue("bill");
        this.chenckApplicationAndBill(application, bill);
        showParameter.setCustomParam("entityNumber", (Object)(bill.getString("number") + "!!" + bill.getString("name")));
        showParameter.setStatus(OperationStatus.ADDNEW);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "valueexpression");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void chenckApplicationAndBill(DynamicObject application, DynamicObject bill) {
        if (application == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528\u4e0e\u5355\u636e\u3002", (String)"BillFieldAddPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (bill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e", (String)"BillFieldAddPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void baradd() {
        DynamicObject application = (DynamicObject)this.getModel().getValue("application");
        DynamicObject bill = (DynamicObject)this.getModel().getValue("bill");
        this.chenckApplicationAndBill(application, bill);
        TreeNode rightroot = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(treeRight), TreeNode.class);
        ArrayList<TreeNode> addNodes = new ArrayList<TreeNode>(16);
        this.getNewNodes(rightroot, addNodes);
        String bizSystemAlias = application.getString("name");
        Long bizSystemId = application.getLong("id");
        String bizUnitAlias = bill.getString("name");
        Long bizUnitId = bill.getLong("id");
        String fieldtable = bill.getString("fieldtable");
        List<String> checkInfo = this.checkRefBeforeSave(addNodes, bizUnitId, bizSystemId);
        try (TXHandle tx = TX.required((String)"eb_billfieldadd");){
            try {
                if (!checkInfo.isEmpty()) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u90e8\u5206\u88ab\u79fb\u9664\u7684\u5b57\u6bb5\u6216\u64cd\u4f5c\u672a\u901a\u8fc7\u6821\u9a8c\u3002", (String)"BillFieldAddPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]), StringUtils.join(checkInfo, (String)"\r\n"), MessageTypes.Default);
                } else {
                    this.saveForAll(rightroot, addNodes, bizUnitAlias, bizUnitId, bizSystemAlias, bizSystemId, fieldtable);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BillFieldAddPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                log.error("billfield baradd error.", (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
        this.getView().close();
    }

    public List<String> checkRefBeforeSave(List<TreeNode> newNodes, Long billId, Long appId) {
        List<Long> deletedIds = this.getCacheDeleteNodeIds();
        List<String> refInfo = new ArrayList<String>(16);
        if (deletedIds == null || deletedIds.isEmpty()) {
            return refInfo;
        }
        BillListUtil billListUtil = new BillListUtil();
        DynamicInfoCollection checkResult = billListUtil.checkFieldRef(deletedIds, billId, appId);
        refInfo = billListUtil.getRefedInfo(checkResult);
        return refInfo;
    }

    private void deleteDataById(List<Long> cacheDeleteNodeIds, String fieldtable) {
        QFilter qFilter = new QFilter("fieldtable", "=", (Object)fieldtable);
        qFilter.and("id", "in", cacheDeleteNodeIds);
        DeleteServiceHelper.delete((String)"eb_bgcontrolbizreg", (QFilter[])new QFilter[]{qFilter});
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "BillFieldAddPlugin_16", "epm-eb-formplugin");
        MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u5220\u9664\u6210\u529f", "BillFieldAddPlugin_17", "epm-eb-formplugin");
        OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"delete", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, null);
    }

    private void getNewNodes(TreeNode node, List<TreeNode> addNodes) {
        List children = node.getChildren();
        if (((Boolean)((Map)node.getData()).get("isnew")).booleanValue()) {
            addNodes.add(node);
        }
        if (children != null && children.size() > 0) {
            for (TreeNode child : children) {
                this.getNewNodes(child, addNodes);
            }
        }
    }

    private void saveForAll(TreeNode rightRoot, List<TreeNode> addNodes, String bizUnitAlias, Long bizUnitId, String bizSystemAlias, Long bizSystemId, String fieldtable) {
        this.saveForShow(rightRoot, addNodes, bizUnitId, fieldtable);
        this.saveForSys(addNodes, bizUnitAlias, bizUnitId, bizSystemAlias, bizSystemId, fieldtable);
    }

    private void saveForSys(List<TreeNode> addNodes, String bizUnitAlias, Long bizUnitId, String bizSystemAlias, Long bizSystemId, String fieldtable) {
        this.deleteForSys();
        ArrayList<DynamicObject> sysz = new ArrayList<DynamicObject>(16);
        DynamicObject bill = (DynamicObject)this.getModel().getValue("bill");
        MainEntityType entityType = null;
        EntityMetadata entityMeta = null;
        String form = (String)this.getView().getFormShowParameter().getCustomParam(formtype);
        for (TreeNode addNode : addNodes) {
            Object flexField;
            DynamicObject sys = BusinessDataServiceHelper.newDynamicObject((String)"eb_bgcontrolbizreg");
            sys.set("id", (Object)Long.parseLong(addNode.getId()));
            String parentid = addNode.getParentid();
            BillFieldTypeEmum type = BillFieldTypeEmum.getBillFieldTypeEmumByIndex((int)Integer.parseInt(parentid));
            sys.set("type", (Object)type.getNumber());
            sys.set("typename", (Object)type.getCnName());
            Long userId = UserUtils.getUserId();
            sys.set("creator", (Object)userId);
            sys.set("modifier", (Object)userId);
            LocalDateTime localDateTime = LocalDateTime.now();
            ZoneId zone = ZoneId.systemDefault();
            Instant instant = localDateTime.atZone(zone).toInstant();
            Date createTime = Date.from(instant);
            sys.set("createtime", (Object)createTime);
            sys.set("modifytime", (Object)createTime);
            HashMap data = (HashMap)addNode.getData();
            sys.set("name", data.get("name"));
            String fieldAlias = (String)data.get("fieldAlias");
            if (bill != null) {
                LocaleString ls = ResManager.getLocaleString((String)"\u4fdd\u5b58", (String)"BillFieldAddPlugin_18", (String)"epm-eb-formplugin");
                LocaleString name = new LocaleString(StringUtils.toNoEmptyString(data.get("name")));
                StringBuilder currname = new StringBuilder();
                if ("field".equals(form)) {
                    if (entityType == null) {
                        entityType = EntityMetadataCache.getDataEntityType((String)bill.getString("number"));
                    }
                    if (entityType != null) {
                        String field = fieldAlias;
                        if (BillFieldTypeEmum.REGSITFIELD == type && field.startsWith("model.")) {
                            field = field.substring("model.".length());
                        }
                        for (String locale : ls.keySet()) {
                            currname.setLength(0);
                            BgRegisterUtils.getField((MainEntityType)entityType, (String)field, (StringBuilder)currname, (String)locale);
                            if (currname.length() <= 0) continue;
                            name.put(locale, (Object)currname.toString());
                        }
                        sys.set("name", (Object)name);
                    }
                } else {
                    MainEntity rootEntity;
                    List operations;
                    Operation operation;
                    if (entityMeta == null) {
                        entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)bill.getString("number"), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Entity);
                    }
                    if (entityMeta != null && (operation = (operations = (rootEntity = entityMeta.getRootEntity()).getOperations()).stream().filter(k -> k.getKey().equals(fieldAlias)).findAny().get()) != null) {
                        name.putAll((Map)operation.getName());
                        sys.set("name", (Object)name);
                    }
                }
            }
            if ((flexField = data.get("flexField")) != null) {
                sys.set("fieldalias", flexField);
                Object valueSource = data.get("valueSource");
                Object flexDataTable = data.get("flexDataTable");
                sys.set("flexdatatable", flexDataTable);
                sys.set("valuesource", valueSource);
                sys.set("isflex", (Object)true);
            } else {
                sys.set("fieldalias", (Object)fieldAlias);
                sys.set("isflex", (Object)false);
            }
            sys.set("number", (Object)fieldAlias);
            sys.set("isprefab", (Object)"0");
            sys.set("isDefault", (Object)"0");
            sys.set("bizUnitAlias", (Object)bizUnitAlias);
            sys.set("bizUnitId", (Object)bizUnitId);
            sys.set("bizSystemAlias", (Object)bizSystemAlias);
            sys.set("bizSystemId", (Object)bizSystemId);
            boolean isentryfield = (Boolean)this.getNodeProperty("isentryfield", addNode);
            sys.set("isentryfield", (Object)isentryfield);
            sys.set("fieldtable", (Object)fieldtable);
            sysz.add(sys);
        }
        SaveServiceHelper.save((DynamicObject[])sysz.toArray(new DynamicObject[0]));
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "BillFieldAddPlugin_18", "epm-eb-formplugin");
        MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f", "BillFieldAddPlugin_15", "epm-eb-formplugin");
        OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"save", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, null);
    }

    private void deleteForSys() {
        List<Long> cacheDeleteNodeIds = this.getCacheDeleteNodeIds();
        if (cacheDeleteNodeIds != null) {
            this.deleteDataById(cacheDeleteNodeIds, ((DynamicObject)this.getModel().getValue("bill")).getString("fieldtable"));
        }
    }

    private void saveForShow(TreeNode rightRoot, List<TreeNode> addNodes, Long bizUnitId, String fieldtable) {
        this.saveFor3Show(rightRoot, addNodes, bizUnitId, fieldtable);
    }

    private void saveFor3Show(TreeNode rightRoot, List<TreeNode> addNodes, Long bizUnitId, String fieldtable) {
        TreeNode beginRightRoot = this.getBeginRightRoot();
        for (TreeNode treeNode : rightRoot.getChildren()) {
            MultiLangEnumBridge opDescription;
            MultiLangEnumBridge opName;
            DynamicObject show = null;
            if (0 == (Integer)((Map)treeNode.getData()).get("beginstate") && treeNode.getChildren() != null && treeNode.getChildren().size() > 0) {
                show = BusinessDataServiceHelper.newDynamicObject((String)"eb_conbizregdata");
                show.set("id", (Object)DBServiceHelper.genGlobalLongId());
                LinkedHashMap node = (LinkedHashMap)treeNode.getData();
                show.set("fielddimension", (Object)this.getCnName(node.get("name")));
                show.set("bill", (Object)bizUnitId);
                show.set("fieldtable", (Object)fieldtable);
            } else {
                LinkedHashMap node;
                QFilter qFilter;
                if (0 == (Integer)((Map)treeNode.getData()).get("beginstate") && (treeNode.getChildren() == null || treeNode.getChildren().size() == 0)) continue;
                if (1 == (Integer)((Map)treeNode.getData()).get("beginstate") && (treeNode.getChildren() == null || treeNode.getChildren().size() == 0)) {
                    qFilter = new QFilter("fieldtable", "=", (Object)fieldtable);
                    node = (LinkedHashMap)treeNode.getData();
                    qFilter.and("fielddimension", "in", (Object)Sets.newHashSet((Object[])new Object[]{this.getCnName(node.get("name")), node.get("name")}));
                    DeleteServiceHelper.delete((String)"eb_conbizregdata", (QFilter[])qFilter.toArray());
                    opName = new MultiLangEnumBridge("\u5220\u9664", "BillFieldAddPlugin_16", "epm-eb-formplugin");
                    opDescription = new MultiLangEnumBridge("\u5220\u9664\u6210\u529f", "BillFieldAddPlugin_17", "epm-eb-formplugin");
                    OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"delete", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, null);
                    continue;
                }
                qFilter = new QFilter("bill", "=", (Object)bizUnitId);
                node = (LinkedHashMap)treeNode.getData();
                qFilter.and("fielddimension", "in", (Object)Sets.newHashSet((Object[])new Object[]{this.getCnName(node.get("name")), node.get("name")}));
                show = BusinessDataServiceHelper.loadSingle((String)"eb_conbizregdata", (String)"entryentity.id,entryentity.number,entryentity.name,entryentity.isprefab", (QFilter[])new QFilter[]{qFilter});
            }
            if (show == null) continue;
            DynamicObjectCollection docs = show.getDynamicObjectCollection("entryentity");
            HashMap<String, Long> rightIds = new HashMap<String, Long>(16);
            this.addRightIds(rightRoot, rightIds);
            if (docs != null && docs.size() > 0) {
                ListIterator iterator = docs.listIterator();
                while (iterator.hasNext()) {
                    DynamicObject doc = (DynamicObject)iterator.next();
                    if (rightRoot.getTreeNode(doc.getString("id"), 10) != null || rightIds.containsKey(doc.getString("number"))) continue;
                    iterator.remove();
                }
            }
            for (TreeNode node : treeNode.getChildren()) {
                if (beginRightRoot.getTreeNode(node.getId(), 10) != null) continue;
                DynamicObject doc = docs.addNew();
                HashMap data = (HashMap)node.getData();
                String fieldAlias = (String)data.get("fieldAlias");
                doc.set("id", (Object)Long.parseLong(node.getId()));
                doc.set("number", (Object)fieldAlias);
                doc.set("name", data.get("name"));
                doc.set("isprefab", (Object)false);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{show});
            opName = new MultiLangEnumBridge("\u4fdd\u5b58", "BillFieldAddPlugin_18", "epm-eb-formplugin");
            opDescription = new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f", "BillFieldAddPlugin_15", "epm-eb-formplugin");
            OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"save", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, null);
        }
    }

    private void addRightIds(TreeNode rightRoot, Map<String, Long> rightIds) {
        Map data;
        if (rightRoot == null) {
            return;
        }
        if (rightRoot.getData() instanceof Map && (data = (Map)rightRoot.getData()).get("number") != null && IDUtils.isNotNull((Long)IDUtils.toLong((Object)rightRoot.getId()))) {
            rightIds.put(String.valueOf(data.get("number")), IDUtils.toLong((Object)rightRoot.getId()));
        }
        if (rightRoot.getChildren() != null) {
            for (TreeNode c : rightRoot.getChildren()) {
                this.addRightIds(c, rightIds);
            }
        }
    }

    private String getCnName(Object name) {
        String n = StringUtils.toNoEmptyString((Object)name);
        if (StringUtils.isEmpty((String)n)) {
            return n;
        }
        return BillFieldTypeEmum.getCnNameByName((String)n);
    }

    public DynamicObjectCollection getLatestData(String type) {
        QFilter qFilter = new QFilter("bizUnitId", "=", (Object)((DynamicObject)this.getModel().getValue("bill")).getLong("id"));
        List nodeNumbers = BillFieldTypeEmum.getFieldNumByType((String)type);
        qFilter.and("type", "in", (Object)nodeNumbers);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_bgcontrolbizreg", (String)"id,name,number,type,typename,isprefab", (QFilter[])new QFilter[]{qFilter});
        return query;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void btngo() {
        List<String> cacheRightNumbers;
        TreeView leftTree = (TreeView)this.getView().getControl(treeLeft);
        TreeView rightTree = (TreeView)this.getView().getControl(treeRight);
        List selectedNodes = leftTree.getTreeState().getSelectedNodes();
        if (selectedNodes == null || selectedNodes.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u5de6\u4fa7\u6570\u636e\u3002", (String)"BillFieldAddPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String focusNodeId = this.getPageCache().get(rightCurrentNode);
        String form = (String)this.getView().getFormShowParameter().getCustomParam(formtype);
        if (focusNodeId == null) {
            if (!"operation".equals(form)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f3\u4fa7\u5217\u8868\u4e2d\u7684\u8282\u70b9\u3002", (String)"BillFieldAddPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            focusNodeId = String.valueOf(BillFieldTypeEmum.TAKEOPERATION.getIndex());
        } else {
            if ("-1".equals(focusNodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f3\u4fa7\u7684\u7b2c\u4e8c\u5c42\u8282\u70b9\u3002", (String)"BillFieldAddPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (Long.parseLong(focusNodeId) > (long)BillFieldTypeEmum.values().length) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f3\u4fa7\u7684\u7b2c\u4e8c\u5c42\u8282\u70b9\u3002", (String)"BillFieldAddPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        TreeNode rightRoot = this.getCacheRightRoot();
        TreeNode cacheLeftRoot = this.getCacheLeftRoot();
        TreeNode rightFocusNode = rightRoot.getTreeNode(focusNodeId, 10);
        List childNodes = rightFocusNode.getChildren();
        if (String.valueOf(BillFieldTypeEmum.WARNING.getIndex()).equals(focusNodeId)) {
            if (childNodes != null && childNodes.size() > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53f3\u4fa7\u9884\u8b66\u8282\u70b9\u5df2\u6709\u6ce8\u518c\u5b57\u6bb5\uff08\u9884\u8b66\u8282\u70b9\u4ec5\u5141\u8bb8\u589e\u52a0\u4e00\u4e2a\u6ce8\u518c\u5b57\u6bb5\uff09\u3002", (String)"BillFieldAddPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectedNodes != null && selectedNodes.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53f3\u4fa7\u9884\u8b66\u8282\u70b9\u53ea\u80fd\u6ce8\u518c\u4e00\u4e2a\u5b57\u6bb5\u3002", (String)"BillFieldAddPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if ("operation".equals(form)) {
            cacheRightNumbers = this.getCacheRightNumbers();
        } else {
            cacheRightNumbers = new ArrayList<String>(10);
            if (childNodes != null) {
                for (TreeNode childNode : childNodes) {
                    cacheRightNumbers.add(childNode.getLongNumber());
                }
            }
        }
        Boolean skiped = false;
        ArrayList<String> checkedNodeIds = new ArrayList<String>(16);
        for (Map checkedNode : selectedNodes) {
            String id = (String)checkedNode.get("id");
            TreeNode node = cacheLeftRoot.getTreeNode(id, 10);
            Map data = (Map)node.getData();
            String fieldType = (String)data.get("fieldType");
            if (node.getChildren() == null || fieldType != null && (fieldType.equals("REF") || fieldType.equals("flex")) || BillFieldTypeEmum.WRITEOFFFIELD.getNumber().equals(rightFocusNode.getLongNumber())) {
                checkedNodeIds.add(id);
                String longNumber = node.getLongNumber();
                if (cacheRightNumbers.contains(longNumber) || id.equals(cacheLeftRoot.getId())) {
                    if ("operation".equals(form)) {
                        TreeNode treeNode = rightRoot.getChildren().stream().filter(k -> k.getChildren() != null && k.getChildren().stream().anyMatch(j -> longNumber.equals(j.getLongNumber()))).findFirst().get();
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8be5\u64cd\u4f5c\u5df2\u9009\u4e8e%1\u4e0b\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0\u3002", (String)"BillFieldAddPlugin_44", (String)"epm-eb-formplugin", (Object[])new Object[]{treeNode.getText()}));
                        return;
                    }
                    skiped = true;
                    continue;
                }
                String parent = (String)checkedNode.get("parent");
                ArrayList<TreeNode> children = rightFocusNode.getChildren();
                if (children == null) {
                    children = new ArrayList<TreeNode>();
                    rightFocusNode.setChildren(children);
                }
                TreeNode newNode = new TreeNode();
                newNode.setId(String.valueOf(DBServiceHelper.genGlobalLongId()));
                newNode.setText(node.getText());
                newNode.setLongNumber(longNumber);
                data.put("isnew", true);
                newNode.setData((Object)data);
                children.add(newNode);
                cacheRightNumbers.add(longNumber);
                continue;
            }
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5df2\u8df3\u8fc7\u8868\u5355\u4f53\u201c%1\u201d\u3002", (String)"BillFieldAddPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[]{checkedNode.get("text")}));
        }
        if (skiped.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u8df3\u8fc7\u53f3\u4fa7\u5217\u8868\u4e2d\u5b58\u5728\u7684\u5b57\u6bb5\u3002", (String)"BillFieldAddPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.cacheRightRoot(rightRoot);
        this.cacheRightNumbers(cacheRightNumbers);
        rightTree.updateNode(rightRoot);
        leftTree.uncheckNodes(checkedNodeIds);
        rightTree.expand(rightRoot.getId());
        rightTree.expand(focusNodeId);
        rightTree.focusNode(rightFocusNode);
    }

    private void btnback() {
        List<Long> strings;
        DynamicInfoCollection checkResult;
        BillListUtil billListUtil;
        List checkInfo;
        QFilter qFilter;
        DynamicObject dynamicObject;
        List<String> useFiled;
        TreeView treeright = (TreeView)this.getView().getControl(treeRight);
        String rightFocusId = this.getPageCache().get(rightCurrentNode);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)rightFocusId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f3\u4fa7\u5217\u8868\u4e2d\u7684\u8282\u70b9\u3002", (String)"BillFieldAddPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode rightRoot = this.getCacheRightRoot();
        DynamicObject application = (DynamicObject)this.getModel().getValue("application");
        DynamicObject bill = (DynamicObject)this.getModel().getValue("bill");
        Long bizSystemId = application.getLong("id");
        Long bizUnitId = bill.getLong("id");
        if (String.valueOf(BillFieldTypeEmum.REGSITFIELD.getIndex()).equals(rightRoot.getTreeNode(rightFocusId, 20).getParentid()) && (useFiled = this.getUseFiled()).contains(rightRoot.getTreeNode(rightFocusId, 20).getLongNumber())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u8282\u70b9\u5df2\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u79fb\u9664\u3002", (String)"BillFieldAddPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (rightRoot.getNodeLevel(rightFocusId, 0) < 2) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u8282\u70b9\u4e0d\u53ef\u79fb\u9664\u3002", (String)"BillFieldAddPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("delete".equalsIgnoreCase(rightRoot.getTreeNode(rightFocusId, 20).getLongNumber()) && (dynamicObject = QueryServiceHelper.queryOne((String)"eb_bgcontrolbizreg", (String)"isdefault", (QFilter[])(qFilter = new QFilter("id", "=", (Object)IDUtils.toLong((Object)rightFocusId))).toArray())) != null && dynamicObject.getBoolean("isdefault")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5220\u9664\u201d\u4e3a\u9884\u5236\u64cd\u4f5c\uff0c\u4e0d\u53ef\u79fb\u9664\u3002", (String)"BillFieldAddPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List<String> cacheRightNumbers = this.getCacheRightNumbers();
        TreeNode node = rightRoot.getTreeNode(rightFocusId, 10);
        LinkedHashMap map = (LinkedHashMap)node.getData();
        if (map.get("isprefab") != null && ((Boolean)map.get("isprefab")).booleanValue()) {
            TreeNode parentNode;
            boolean isrepeat = false;
            String parentId = node.getParentid();
            if (parentId != null && (parentNode = rightRoot.getTreeNode(parentId)) != null) {
                for (TreeNode childNode : parentNode.getChildren()) {
                    LinkedHashMap _map;
                    if (childNode.equals(node) || childNode.getLongNumber() == null || !childNode.getLongNumber().equals(node.getLongNumber()) || (_map = (LinkedHashMap)childNode.getData()).get("isprefab") == null || !((Boolean)_map.get("isprefab")).booleanValue()) continue;
                    isrepeat = true;
                    break;
                }
            }
        }
        if (!(checkInfo = (billListUtil = new BillListUtil()).getRefedInfo(checkResult = billListUtil.checkFieldRef(strings = Collections.singletonList(IDUtils.toLong((Object)rightFocusId)), bizUnitId, bizSystemId))).isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u90e8\u5206\u88ab\u79fb\u9664\u7684\u5b57\u6bb5\u6216\u64cd\u4f5c\u672a\u901a\u8fc7\u6821\u9a8c\u3002", (String)"BillFieldAddPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]), StringUtils.join((Collection)checkInfo, (String)"\r\n"), MessageTypes.Default);
            return;
        }
        cacheRightNumbers.remove(node.getLongNumber());
        if (!((Boolean)((Map)node.getData()).get("isnew")).booleanValue()) {
            this.refreshDeleteNodeIds(Long.parseLong(node.getId()));
        }
        rightRoot.deleteChildNode(rightFocusId);
        TreeNode parent = rightRoot.getTreeNode(node.getParentid(), 10);
        if (parent.getChildren().size() <= 0) {
            parent.setChildren(null);
        }
        this.getPageCache().put(rightCurrentNode, null);
        treeright.updateNode(rightRoot);
        treeright.expand(rightRoot.getId());
        treeright.expand(node.getParentid());
        this.cacheRightRoot(rightRoot);
        this.cacheRightNumbers(cacheRightNumbers);
    }

    private List<String> getUseFiled() {
        ArrayList<String> list = new ArrayList<String>(16);
        StringBuilder sql = new StringBuilder("select fserqfilter from t_eb_dimmaterulebill");
        try {
            DataSet ds = DB.queryDataSet((String)"queryMateRule", (DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), null);
            Object object = null;
            try {
                if (ds != null) {
                    for (Row row : ds) {
                        list.add(row.getString("fserqfilter"));
                    }
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
        ArrayList<String> list1 = new ArrayList<String>(16);
        for (String s : list) {
            if (StringUtils.isEmpty((String)s) || s.startsWith("{")) continue;
            if (s.startsWith("tabpage") && s.indexOf(",") > 0) {
                s = s.substring(s.indexOf(",") + 1);
            }
            Map map = (Map)SerializationUtils.deSerializeFromBase64((String)s);
            Map newMap = new HashMap<String, Map>(10);
            if (map != null) {
                if (map.values().iterator().next() instanceof Map) {
                    newMap = map;
                } else {
                    newMap.put("tabpage", map);
                }
            }
            for (Map.Entry mapEntry : newMap.entrySet()) {
                Map value = (Map)mapEntry.getValue();
                for (Map.Entry map1 : value.entrySet()) {
                    if (!((String)map1.getKey()).startsWith("filedqf")) continue;
                    list1.add((String)map1.getValue());
                }
            }
        }
        return list1;
    }

    private List<Long> getCacheDeleteNodeIds() {
        String deletenumbers = this.getPageCache().get("deletenodes");
        if (deletenumbers == null) {
            return null;
        }
        return SerializationUtils.fromJsonStringToList((String)deletenumbers, Long.class);
    }

    private void cacheDeleteNodeIds(List<Long> deleteIds) {
        this.getPageCache().put("deletenodes", SerializationUtils.toJsonString(deleteIds));
    }

    private void refreshDeleteNodeIds(Long id) {
        if (id == null) {
            return;
        }
        String deleteIds = this.getPageCache().get("deletenodes");
        if (deleteIds == null || "null".equals(deleteIds)) {
            ArrayList<Long> ids = new ArrayList<Long>(16);
            ids.add(id);
            this.getPageCache().put("deletenodes", JSONArray.toJSONString(ids));
        } else {
            List ids = JSONArray.parseArray((String)deleteIds, Long.class);
            ids.add(id);
            this.getPageCache().put("deletenodes", JSONArray.toJSONString((Object)ids));
        }
    }

    private TreeNode initOperationLeftTree() {
        DynamicObject bill = (DynamicObject)this.getModel().getValue("bill");
        String isFromOuter = (String)this.getView().getFormShowParameter().getCustomParam("isFromOuter");
        String fieldtable = bill.getString("fieldtable");
        TreeNode root = new TreeNode();
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(16);
        root.setChildren(nodes);
        if (isFromOuter == null || !isFromOuter.equals("true")) {
            EntityMetadata entityMeta = null;
            try {
                entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)fieldtable, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Entity);
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u8be5\u5143\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u8be5\u5143\u6570\u636e\u662f\u5426\u5c5e\u4e8e\u5355\u636e\u7c7b\u578b\u3002", (String)"BillFieldAddPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (entityMeta == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u8be5\u5143\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u8be5\u5143\u6570\u636e\u662f\u5426\u5c5e\u4e8e\u5355\u636e\u7c7b\u578b\u3002", (String)"BillFieldAddPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            MainEntity rootEntity = entityMeta.getRootEntity();
            List operations = rootEntity.getOperations();
            this.getOperationField(operations, nodes);
        }
        return root;
    }

    private TreeNode initFieldLeftTree() {
        DynamicObject bill = (DynamicObject)this.getModel().getValue("bill");
        String isFromOuter = bill.getString("isfromouter");
        TreeNode root = new TreeNode();
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(16);
        root.setChildren(nodes);
        if (isFromOuter != null && isFromOuter.equals("true")) {
            DynamicObject application = (DynamicObject)this.getModel().getValue("application");
            String outerBillId = bill.getString("longnumber");
            String sourceId = application.getString("longnumber");
            this.getOuterBillField(root, outerBillId, sourceId);
        } else {
            EntityMetadata entityMeta;
            String fieldtable = bill.getString("fieldtable");
            try {
                entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)fieldtable, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Entity);
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u8be5\u5143\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u8be5\u5143\u6570\u636e\u662f\u5426\u5c5e\u4e8e\u5355\u636e\u7c7b\u578b\u3002", (String)"BillFieldAddPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (entityMeta == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u8be5\u5143\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u8be5\u5143\u6570\u636e\u662f\u5426\u5c5e\u4e8e\u5355\u636e\u7c7b\u578b\u3002", (String)"BillFieldAddPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            MainEntity rootEntity = entityMeta.getRootEntity();
            List items = rootEntity.getItems();
            HashMap<String, String> nodeNumberAndNameMap = new HashMap<String, String>(16);
            this.getField(items, nodes, root, false, nodeNumberAndNameMap);
            this.getPageCache().put(CACHE_NUMBER_AND_NAME, SerializationUtils.toJsonString(nodeNumberAndNameMap));
        }
        return root;
    }

    private void getOuterBillField(TreeNode root, String outerBillId, String sourceId) {
        DynamicObject outerBill = null;
        try {
            outerBill = BusinessDataServiceHelper.loadSingle((Object)Convert.toLong((Object)outerBillId), (String)"isc_metadata_schema");
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
        HashMap<String, String> nodeNumberAndNameMap = new HashMap<String, String>(16);
        if (outerBill != null) {
            DynamicObjectCollection billFields = outerBill.getDynamicObjectCollection("prop_entryentity");
            DynamicInfoCollection refFieldInfo = new DynamicInfoCollection(ResManager.loadKDString((String)"\u5206\u5f55\u8282\u70b9\u4fe1\u606f", (String)"BillFieldAddPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[]{"nodeId", "entryNum"});
            String cacheBillField = this.getPageCache().get(regedEntityNums);
            Set entityNums = cacheBillField != null ? (Set)SerializationUtils.fromJsonString((String)cacheBillField, Set.class) : new HashSet(16);
            for (DynamicObject field : billFields) {
                String fieldNum = field.getString("prop_name");
                String fieldName = field.getString("prop_label");
                String fieldType = field.getString("data_type");
                String fieldSchema = field.getString("data_schema");
                TreeNode childNode = this.createChildNode(fieldNum, fieldName, fieldType, fieldSchema, root, false, nodeNumberAndNameMap);
                root.addChild(childNode);
                if (fieldType == null || !fieldType.equals("ENTRIES") && (!fieldType.equals("REF") || !entityNums.contains(fieldNum))) continue;
                refFieldInfo.addInfo(new Object[]{childNode.getId(), fieldSchema});
            }
            if (!refFieldInfo.isEmpty()) {
                DynamicObject[] refBills;
                QFBuilder qb = new QFBuilder();
                qb.add("group", "=", (Object)Convert.toLong((Object)sourceId));
                qb.add("number", "in", (Object)refFieldInfo.getAllValOfOneProp("entryNum"));
                for (DynamicObject bill : refBills = BusinessDataServiceHelper.load((String)"isc_metadata_schema", (String)"id,number,prop_entryentity.prop_label,prop_entryentity.prop_name", (QFilter[])qb.toArrays())) {
                    String number = bill.getString("number");
                    List infos = refFieldInfo.getAllInfoByOneProp("entryNum", (Object)number);
                    infos.forEach(info -> {
                        String nodeId = String.valueOf(info.getValueByPropIndex(0));
                        TreeNode node = root.getTreeNode(nodeId, 5);
                        if (node != null) {
                            TreeNode childNode1 = null;
                            DynamicObjectCollection Fields = bill.getDynamicObjectCollection("prop_entryentity");
                            for (DynamicObject field : Fields) {
                                String fieldNum = field.getString("prop_name");
                                String fieldName = field.getString("prop_label");
                                childNode1 = this.createChildNode(fieldNum, fieldName, "fieldtype", "fieldtable", node, true, nodeNumberAndNameMap);
                                node.addChild(childNode1);
                            }
                        }
                    });
                }
            }
        }
        this.getPageCache().put(CACHE_NUMBER_AND_NAME, SerializationUtils.toJsonString(nodeNumberAndNameMap));
    }

    private void getOperationField(List<Operation> operations, ArrayList<TreeNode> nodes) {
        HashMap<String, String> numberAndNameMap = new HashMap<String, String>(16);
        for (Operation operation : operations) {
            String CNname = operation.getName().getLocaleValue();
            String key = operation.getKey();
            TreeNode childNode = this.createOperationNode(key, CNname, numberAndNameMap);
            nodes.add(childNode);
        }
        this.getPageCache().put(CACHE_NUMBER_AND_NAME, SerializationUtils.toJsonString(numberAndNameMap));
    }

    private TreeNode createOperationNode(String number, String CNname, Map<String, String> numberAndNameMap) {
        TreeNode node = new TreeNode();
        node.setId(String.valueOf(DBServiceHelper.genGlobalLongId()));
        node.setText(CNname);
        node.setLongNumber(number);
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("fieldAlias", number);
        data.put("number", number);
        data.put("isentryfield", false);
        data.put("name", CNname);
        node.setData(data);
        numberAndNameMap.put(number, CNname);
        return node;
    }

    private void getField(List<EntityItem<?>> properties, List<TreeNode> nodes, TreeNode parentNode, boolean isentryfield, Map<String, String> nodeNumberAndNameMap) {
        for (EntityItem<?> property : properties) {
            String number = property.getKey();
            LocaleString displayName = property.getName();
            if (number == null || displayName == null) continue;
            TreeNode childNode = this.createChildNode(number, displayName.getLocaleValue(), null, null, parentNode, isentryfield, nodeNumberAndNameMap);
            nodes.add(childNode);
            if (property instanceof EntryEntity) {
                EntryEntity property1 = (EntryEntity)property;
                List items = property1.getItems();
                ArrayList<TreeNode> nodes1 = new ArrayList<TreeNode>(16);
                childNode.setChildren(nodes1);
                this.getField(items, nodes1, childNode, true, nodeNumberAndNameMap);
                continue;
            }
            if (!(property instanceof FlexField)) continue;
            int flexTypeId = ((FlexField)property).getFlexType();
            FlexType ft = FlexEntityMetaUtils.getFlexType((int)flexTypeId);
            List flexProperties = FlexEntityMetaUtils.getFlexProperties((int)flexTypeId);
            ArrayList<TreeNode> nodes1 = new ArrayList<TreeNode>(16);
            childNode.setChildren(nodes1);
            String flexDataTable = ft.getFlexDataTable();
            this.getFlexField(flexProperties, flexDataTable, nodes1, childNode, nodeNumberAndNameMap);
        }
    }

    private void getFlexField(List<FlexProperty> properties, String flexDataTable, List<TreeNode> nodes, TreeNode parentNode, Map<String, String> nodeNumberAndNameMap) {
        String sourceNumber = parentNode.getLongNumber();
        int count = 0;
        for (FlexProperty property : properties) {
            String glName;
            ++count;
            String number = property.getNumber();
            String valueSource = property.getValueSource();
            String flexField = property.getFlexField();
            String string = glName = property.getName() == null || property.getName().getLocaleValue_zh_CN() == null ? property.getGLName() : property.getName().getLocaleValue_zh_CN();
            if (number != null && glName != null) {
                TreeNode childNode = this.createChildNode(number, glName, null, null, parentNode, true, nodeNumberAndNameMap);
                HashMap data = (HashMap)childNode.getData();
                data.put("flexDataTable", flexDataTable);
                data.put("sourceNumber", sourceNumber);
                data.put("flexField", flexField);
                data.put("valueSource", valueSource);
                data.put("fieldType", "flex");
                nodes.add(childNode);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)valueSource) && count < 150) {
                    this.queryChildNodeProp(nodeNumberAndNameMap, valueSource, childNode);
                    continue;
                }
                ArrayList childs = new ArrayList(16);
                childNode.setChildren(childs);
                childNode.setLeaf(false);
                childNode.setIsOpened(false);
                continue;
            }
            log.info("billfieldadd_flex number or name is null,number:{},name:{}", (Object)number, (Object)glName);
        }
    }

    protected void queryChildNodeProp(Map<String, String> nodeNumberAndNameMap, String valueSource, TreeNode childNode) {
        List<IDataEntityProperty> propertyValue = this.getPropertyValue(valueSource);
        ArrayList<TreeNode> childs = new ArrayList<TreeNode>(16);
        for (IDataEntityProperty childProperty : propertyValue) {
            String number2 = childProperty.getName();
            LocaleString displayName = childProperty.getDisplayName();
            if (number2 == null || displayName == null) continue;
            String name = displayName.getLocaleValue();
            TreeNode childNode2 = this.createChildNode(number2, name, null, null, childNode, true, nodeNumberAndNameMap);
            childs.add(childNode2);
        }
        if (!childs.isEmpty()) {
            childNode.setChildren(childs);
        }
    }

    private List<IDataEntityProperty> getPropertyValue(String fieldtable) {
        Collection values;
        try {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)fieldtable);
            values = mainType.getAllFields().values();
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        List<IDataEntityProperty> collect = values.stream().collect(Collectors.toList());
        return collect;
    }

    private TreeNode createChildNode(String number, String displayName, String filelType, String fieldTable, TreeNode parentNode, boolean isentryfield, Map<String, String> nodeNumberAndNameMap) {
        String realNumber;
        String realName;
        TreeNode node = new TreeNode();
        node.setId(String.valueOf(DBServiceHelper.genGlobalLongId()));
        node.setParentid(parentNode.getId());
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        if (isentryfield) {
            HashMap data1 = (HashMap)parentNode.getData();
            String parentName = (String)data1.get("name");
            realName = parentName + "." + displayName;
            realNumber = parentNode.getLongNumber() + "." + number;
        } else {
            realName = displayName;
            realNumber = number;
        }
        nodeNumberAndNameMap.put(realNumber, realName);
        data.put("name", realName);
        data.put("number", realNumber);
        if (filelType != null) {
            data.put("fieldType", filelType);
        }
        if (fieldTable != null) {
            data.put("fieldTable", fieldTable);
        }
        if (realNumber != null) {
            data.put("fieldAlias", realNumber);
        }
        data.put("isentryfield", isentryfield);
        node.setData(data);
        node.setLongNumber(realNumber);
        node.setText(realName);
        return node;
    }

    public boolean checkCurrentDataIsNew(String type) {
        TreeNode beginRoot = this.getBeginRightRoot();
        ArrayList<String> nodeIds = new ArrayList<String>(16);
        this.getLeftTreeFieldNodeIds(beginRoot, nodeIds);
        DynamicObjectCollection newData = this.getLatestData(type);
        if (newData.size() != nodeIds.size()) {
            return false;
        }
        for (DynamicObject data : newData) {
            String id = data.getString("id");
            nodeIds.remove(id);
        }
        return nodeIds.isEmpty();
    }

    public void getLeftTreeFieldNodeIds(TreeNode root, List<String> nodeIds) {
        List childs = root.getChildren();
        Map nodeData = (Map)root.getData();
        if (childs == null || childs.isEmpty()) {
            if (nodeData.get("nodeType") != null) {
                String id = root.getId();
                nodeIds.add(id);
            }
        } else {
            for (TreeNode child : childs) {
                this.getLeftTreeFieldNodeIds(child, nodeIds);
            }
        }
    }

    protected TreeNode getRigthRoot() {
        HashMap<String, Object> datas;
        String name;
        TreeNode node;
        BillFieldTypeEmum[] values;
        if (this.getModel().getValue("bill") == null) {
            return null;
        }
        TreeNode rightNode = new TreeNode();
        rightNode.setId("-1");
        rightNode.setLongNumber("0");
        ArrayList<TreeNode> twoNodes = new ArrayList<TreeNode>(16);
        rightNode.setChildren(twoNodes);
        HashMap<String, Boolean> rootData = new HashMap<String, Boolean>(16);
        rootData.put("isnew", false);
        rightNode.setData(rootData);
        String form = (String)this.getView().getFormShowParameter().getCustomParam(formtype);
        ArrayList<String> nodeNumbers = new ArrayList<String>(16);
        if ("operation".equals(form)) {
            rightNode.setText(ResManager.loadKDString((String)"\u6ce8\u518c\u64cd\u4f5c", (String)"BillFieldAddPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            for (BillFieldTypeEmum value : values = BillFieldTypeEmum.values()) {
                if (!"operation".equals(value.getType())) continue;
                nodeNumbers.add(value.getNumber());
                node = new TreeNode();
                node.setId(value.getIndex() + "");
                node.setLongNumber(value.getNumber());
                name = value.getName();
                node.setText(name);
                datas = new HashMap<String, Object>(16);
                datas.put("number", value);
                datas.put("name", name);
                datas.put("isnew", false);
                datas.put("isprefab", false);
                datas.put("beginstate", 0);
                node.setData(datas);
                twoNodes.add(node);
            }
        } else if ("field".equals(form)) {
            rightNode.setText(ResManager.loadKDString((String)"\u6ce8\u518c\u5b57\u6bb5", (String)"BillFieldAddPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            for (BillFieldTypeEmum value : values = BillFieldTypeEmum.values()) {
                if (!"field".equals(value.getType())) continue;
                nodeNumbers.add(value.getNumber());
                node = new TreeNode();
                node.setId(value.getIndex() + "");
                node.setLongNumber(value.getNumber());
                name = value.getName();
                node.setText(name);
                datas = new HashMap(16);
                datas.put("number", value);
                datas.put("name", name);
                datas.put("isnew", false);
                datas.put("isprefab", false);
                datas.put("beginstate", 0);
                node.setData(datas);
                twoNodes.add(node);
            }
        }
        HashMap threeMap = new HashMap(16);
        DynamicObjectCollection query = this.getLatestData(form);
        HashSet<String> entityNums = new HashSet<String>(16);
        for (DynamicObject dynamicObject : query) {
            ArrayList<TreeNode> treeNodes;
            node = new TreeNode();
            node.setId(dynamicObject.getString("id"));
            name = dynamicObject.getString("name");
            String number = dynamicObject.getString("number");
            if (number.contains(".")) {
                entityNums.add(number.substring(0, number.indexOf(".")));
            }
            node.setText(name);
            node.setLongNumber(number);
            nodeNumbers.add(number);
            String type = dynamicObject.getString("type");
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            data.put("name", name);
            data.put("number", number);
            data.put("isnew", false);
            data.put("isprefab", dynamicObject.getBoolean("isprefab"));
            data.put("nodeType", form);
            node.setData(data);
            type = org.apache.commons.lang3.StringUtils.trim((String)type);
            if (threeMap.containsKey(type)) {
                treeNodes = (ArrayList<TreeNode>)threeMap.get(type);
                treeNodes.add(node);
                continue;
            }
            treeNodes = new ArrayList<TreeNode>(16);
            treeNodes.add(node);
            threeMap.put(type, treeNodes);
        }
        this.getPageCache().put(regedEntityNums, SerializationUtils.toJsonString(entityNums));
        for (TreeNode twoNode : twoNodes) {
            List treeNodes;
            if (!threeMap.containsKey(twoNode.getLongNumber()) || (treeNodes = (List)threeMap.get(twoNode.getLongNumber())) == null || treeNodes.size() < 1) continue;
            Map data = (Map)twoNode.getData();
            data.put("beginstate", 1);
            twoNode.setChildren(treeNodes);
        }
        this.cacheRightNumbers(nodeNumbers);
        return rightNode;
    }

    protected TreeNode isMatch(TreeNode rightFocusNode, TreeNode copy) {
        if (rightFocusNode.getChildren() != null) {
            for (TreeNode focusChild : rightFocusNode.getChildren()) {
                if (!focusChild.getId().equals(copy.getId()) && !focusChild.getText().equals(copy.getText())) continue;
                return focusChild;
            }
        }
        return null;
    }

    private void cacheCurrentNodeId(String nodeId) {
        this.getPageCache().put(rightCurrentNode, nodeId);
    }

    public void allClear(TreeNode leftRoot, final TreeView treeleft) {
        treeleft.uncheckNode(leftRoot.getId());
        if (leftRoot.getChildren() != null) {
            leftRoot.getChildren().forEach(new Consumer<TreeNode>(){

                @Override
                public void accept(TreeNode t) {
                    BillFieldAddPlugin.this.allClear(t, treeleft);
                }
            });
        }
    }

    protected void allChoose(final TreeView treeleft, TreeNode leftRoot) {
        if (leftRoot.getChildren() != null) {
            treeleft.checkNodes(leftRoot.getChildren());
            leftRoot.getChildren().forEach(new Consumer<TreeNode>(){

                @Override
                public void accept(TreeNode t) {
                    BillFieldAddPlugin.this.allChoose(treeleft, t);
                }
            });
        }
    }

    protected void collapseAll() {
        TreeNode leftRoot = this.getCacheLeftRoot();
        if (leftRoot == null) {
            return;
        }
        TreeView treeleft = (TreeView)this.getView().getControl(treeLeft);
        if (leftRoot.getChildren() != null) {
            this.collapseChild(leftRoot, treeleft);
        }
        treeleft.deleteAllNodes();
        treeleft.addNode(leftRoot);
    }

    protected void spreadAll() {
        TreeNode leftRoot = this.getCacheLeftRoot();
        if (leftRoot == null) {
            return;
        }
        TreeView treeleft = (TreeView)this.getView().getControl(treeLeft);
        if (leftRoot.getChildren() != null) {
            leftRoot.setIsOpened(true);
            this.spreadChild(leftRoot, treeleft);
        }
        treeleft.deleteAllNodes();
        treeleft.addNode(leftRoot);
    }

    protected void collapseChild(TreeNode leftRoot, final TreeView treeleft) {
        leftRoot.getChildren().forEach(new Consumer<TreeNode>(){

            @Override
            public void accept(TreeNode t) {
                if (t.getChildren() != null) {
                    t.setIsOpened(false);
                    BillFieldAddPlugin.this.collapseChild(t, treeleft);
                }
            }
        });
    }

    protected void spreadChild(TreeNode leftRoot, final TreeView treeleft) {
        leftRoot.getChildren().forEach(new Consumer<TreeNode>(){

            @Override
            public void accept(TreeNode t) {
                if (t.getChildren() != null) {
                    t.setIsOpened(true);
                    BillFieldAddPlugin.this.spreadChild(t, treeleft);
                }
            }
        });
    }

    protected void setTreeFocus(TreeView tree, TreeNode node) {
        tree.focusNode(node);
    }

    protected void cacheLeftRoot(TreeNode rootleft) {
        if (rootleft == null) {
            this.getPageCache().put(treeLeft, null);
        } else {
            Queue<TreeNode> queue = TreeSearchUtil.getQueue(rootleft);
            while (!queue.isEmpty()) {
                TreeNode node = queue.poll();
                List children = node.getChildren();
                if (children == null) continue;
                for (TreeNode child : children) {
                    child.setParentid(node.getId());
                }
            }
            this.getPageCache().put(treeLeft, SerializationUtils.toJsonString((Object)rootleft));
        }
    }

    protected TreeNode getCacheLeftRoot() {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(treeLeft))) {
            TreeNode leftRoot = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(treeLeft), TreeNode.class);
            return leftRoot;
        }
        return null;
    }

    private void cacheBeginRightRoot(TreeNode rootRight) {
        if (rootRight == null) {
            this.getPageCache().put(beginTreeRight, null);
        } else {
            Queue<TreeNode> queue = TreeSearchUtil.getQueue(rootRight);
            while (!queue.isEmpty()) {
                TreeNode node = queue.poll();
                List children = node.getChildren();
                if (children == null) continue;
                for (TreeNode child : children) {
                    child.setParentid(node.getId());
                }
            }
            this.getPageCache().put(beginTreeRight, SerializationUtils.toJsonString((Object)rootRight));
        }
    }

    protected void cacheRightRoot(TreeNode rootRight) {
        if (rootRight == null) {
            this.getPageCache().put(treeRight, null);
        } else {
            Queue<TreeNode> queue = TreeSearchUtil.getQueue(rootRight);
            while (!queue.isEmpty()) {
                TreeNode node = queue.poll();
                List children = node.getChildren();
                if (children == null) continue;
                for (TreeNode child : children) {
                    child.setParentid(node.getId());
                }
            }
            this.getPageCache().put(treeRight, SerializationUtils.toJsonString((Object)rootRight));
        }
    }

    protected TreeNode getBeginRightRoot() {
        if (this.getPageCache().get(beginTreeRight) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e", (String)"BillFieldAddPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        TreeNode rightRoot = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(beginTreeRight), TreeNode.class);
        return rightRoot;
    }

    protected TreeNode getCacheRightRoot() {
        TreeNode rightRoot = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(treeRight), TreeNode.class);
        return rightRoot;
    }

    protected void cacheRightNumbers(List<String> rightNodeMumbers) {
        this.getPageCache().put(rightTreeNodeNumbers, SerializationUtils.toJsonString(rightNodeMumbers));
    }

    protected List<String> getCacheRightNumbers() {
        List rightNumbers = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(rightTreeNodeNumbers), List.class);
        return rightNumbers;
    }

    protected <T> T getNodeProperty(String key, TreeNode rightNode) {
        Object data = rightNode.getData();
        Map nodeData = (Map)data;
        return (T)(nodeData.get(key) != null ? nodeData.get(key) : nodeData.get(key.toUpperCase()));
    }
}

