/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.MapType;
import java.awt.Color;
import java.awt.font.FontRenderContext;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.utils.CommonShowDetail;
import kd.epm.eb.common.utils.CommonShowDetailEntry;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CommonShowListPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(CommonShowListPlugin.class);
    private static final String combotype = "combotype";
    private static final String combofield = "combofield";
    private static final String defaultDetail = "empty";
    private static final String btnexport = "btnexport";
    private static final FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getView().getFormShowParameter().getCustomParam("detailtitle") != null) {
            this.getView().setFormTitle(new LocaleString((String)this.getView().getFormShowParameter().getCustomParam("detailtitle")));
        }
        try {
            LinkedHashMap<String, CommonShowDetail> detailMap = CommonShowListPlugin.getDetailMap(this.getView());
            if (detailMap == null || detailMap.isEmpty()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelapfilter", "entryentity"});
                return;
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelapfilter", "entryentity"});
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(detailMap.size());
            for (Map.Entry<String, CommonShowDetail> entry : detailMap.entrySet()) {
                items.add(new ComboItem(new LocaleString(entry.getKey()), entry.getKey()));
                if (items.size() != 1) continue;
                this.getModel().setValue(combotype, (Object)((ComboItem)items.get(0)).getValue());
            }
            ComboEdit combo = (ComboEdit)this.getView().getControl(combotype);
            combo.setComboItems(items);
            this.loadDetailType(((ComboItem)items.get(0)).getValue());
            if (StringUtils.isNotEmpty((String)((String)this.getView().getFormShowParameter().getCustomParam("detailtypetitle")))) {
                combo.setCaption(new LocaleString((String)this.getView().getFormShowParameter().getCustomParam("detailtypetitle")));
                this.getView().setVisible(Boolean.valueOf(true), new String[]{combotype});
            } else {
                log.info("hide-combotype");
                this.getView().setVisible(Boolean.valueOf(false), new String[]{combotype});
            }
        }
        catch (Throwable ex) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelapfilter", "entryentity"});
            log.info("load-error{}", (Object)ex);
            return;
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        e.getProperty();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        Object propValue = changeData.getNewValue();
        if (combofield.equals(propName)) {
            String detailType = CommonShowListPlugin.getDetailType(this.getModel());
            this.loadDetail(detailType, (String)propValue);
        } else if (combotype.equals(propName)) {
            this.loadDetailType((String)propValue);
        }
    }

    private static String getDetailType(IDataModel dataModel) {
        if (dataModel == null) {
            return "";
        }
        return (String)dataModel.getValue(combotype);
    }

    private static CommonShowDetail getDetail(IFormView view, String detailType) {
        LinkedHashMap<String, CommonShowDetail> detailMap = CommonShowListPlugin.getDetailMap(view);
        if (detailMap != null) {
            return detailMap.get(detailType);
        }
        return null;
    }

    public static CommonShowDetailEntry getEntry(IFormView view) {
        if (view == null || view.getModel() == null) {
            return new CommonShowDetailEntry();
        }
        CommonShowDetail detail = CommonShowListPlugin.getDetail(view, CommonShowListPlugin.getDetailType(view.getModel()));
        String propvalue = (String)view.getModel().getValue(combofield);
        return detail == null || combofield == null ? new CommonShowDetailEntry() : detail.getEntry(propvalue, propvalue);
    }

    private static LinkedHashMap<String, CommonShowDetail> getDetailMap(IFormView view) {
        if (view == null) {
            return new LinkedHashMap<String, CommonShowDetail>(1);
        }
        Object object = view.getFormShowParameter().getCustomParam("detaildata");
        if (object == null) {
            return null;
        }
        try {
            LinkedHashMap detailMap = new LinkedHashMap(1);
            String jonsString = null;
            jonsString = "detailcompress".equals(view.getFormShowParameter().getCustomParam("detailcompress")) ? CommonShowDetail.unCompressDetail((String)StringUtils.toNoEmptyString((Object)object)) : JSONUtils.toString((Object)object);
            if (view.getFormShowParameter().getCustomParam("detailtypetitle") != null) {
                MapType detailMapType = JSONUtils.getMapper().getTypeFactory().constructMapType(Map.class, String.class, CommonShowDetail.class);
                detailMap = (LinkedHashMap)JSONUtils.parse((String)jonsString, (JavaType)detailMapType);
            } else {
                CommonShowDetail detail = (CommonShowDetail)JSONUtils.parse((String)jonsString, CommonShowDetail.class);
                detailMap.put(defaultDetail, detail);
            }
            return detailMap;
        }
        catch (Throwable ex) {
            log.info("parse-json-error{}", (Object)ex);
            return null;
        }
    }

    private void loadDetailType(String detailType) {
        ComboEdit combo = (ComboEdit)this.getView().getControl(combofield);
        CommonShowDetail detail = CommonShowListPlugin.getDetail(this.getView(), detailType);
        if (detail == null) {
            return;
        }
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(detail.getAliasMap().size());
        for (Map.Entry entry : detail.getAliasMap().entrySet()) {
            items.add(new ComboItem(new LocaleString((String)entry.getValue()), (String)entry.getKey()));
            if (items.size() != 1) continue;
            this.getModel().setValue(combofield, (Object)((ComboItem)items.get(0)).getValue());
        }
        combo.setComboItems(items);
        if (items.size() > 0) {
            this.loadDetail(detailType, ((ComboItem)items.get(0)).getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDetail(String detailType, String value) {
        CommonShowDetail detail = CommonShowListPlugin.getDetail(this.getView(), detailType);
        if (detail == null || detail.getEntryMap().isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelapfilter", "entryentity"});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelapfilter", "entryentity"});
        ComboEdit combo = (ComboEdit)this.getView().getControl(combofield);
        if (StringUtils.isEmpty((String)detail.getShowAlias())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{combofield});
        } else {
            combo.setCaption(new LocaleString(detail.getShowAlias()));
        }
        CommonShowDetailEntry entry = detail.getEntry(value, value);
        if (entry == null) {
            entry = new CommonShowDetailEntry();
        }
        this.getModel().deleteEntryData("entryentity");
        EntryGrid table = (EntryGrid)this.getControl("entryentity");
        try {
            this.getModel().beginInit();
            String field = null;
            CommonShowDetailEntry.Column column = null;
            int totalCols = table.getItems().size();
            ArrayList<Container> groups = new ArrayList<Container>(2);
            Control control = null;
            ArrayList<CommonShowDetailEntry.Column> noGroupCols = new ArrayList<CommonShowDetailEntry.Column>(10);
            LinkedHashMap<String, List> groupCols = new LinkedHashMap<String, List>(2);
            for (int i = 0; i < entry.getColumns().size(); ++i) {
                column = (CommonShowDetailEntry.Column)entry.getColumns().get(i);
                if (StringUtils.isEmpty((String)column.getGroupKey())) {
                    noGroupCols.add(column);
                    continue;
                }
                groupCols.computeIfAbsent(column.getGroupKey(), f -> new ArrayList(2)).add(column);
            }
            int colIndex = 0;
            for (int c = 0; c < totalCols; ++c) {
                control = (Control)table.getItems().get(c);
                if (control instanceof Container) {
                    groups.add((Container)control);
                    continue;
                }
                if (!(control instanceof FieldEdit)) continue;
                field = control.getKey();
                if (noGroupCols.size() <= colIndex) {
                    table.setColumnProperty(field, "vi", (Object)Boolean.FALSE);
                    continue;
                }
                column = (CommonShowDetailEntry.Column)noGroupCols.get(colIndex++);
                column.setColumnField(field);
                table.setColumnProperty(field, "vi", (Object)(!entry.getHideColumnKey().contains(column.getColumnKey()) ? 1 : 0));
                table.setColumnProperty(field, "header", (Object)column.getColumnAlias());
                if (column.getMaxShowLength() > 0) {
                    table.setColumnProperty(field, "maxlength", (Object)column.getMaxShowLength());
                    continue;
                }
                table.setColumnProperty(field, "maxlength", (Object)150);
            }
            Iterator it = groupCols.entrySet().iterator();
            for (int c = 0; c < groups.size(); ++c) {
                if (!it.hasNext()) {
                    for (Control subC : ((Container)groups.get(c)).getItems()) {
                        if (!(subC instanceof FieldEdit)) continue;
                        table.setColumnProperty(subC.getKey(), "vi", (Object)Boolean.FALSE);
                    }
                    continue;
                }
                Map.Entry group = it.next();
                String colAlias = ((List)group.getValue()).isEmpty() ? defaultDetail : ((CommonShowDetailEntry.Column)((List)group.getValue()).get(0)).getGroupAlias();
                table.setColumnProperty(((Container)groups.get(c)).getKey(), "header", (Object)colAlias);
                colIndex = 0;
                for (Control subC : ((Container)groups.get(c)).getItems()) {
                    if (!(subC instanceof FieldEdit)) continue;
                    field = ((FieldEdit)subC).getFieldKey();
                    if (((List)group.getValue()).size() <= colIndex) {
                        table.setColumnProperty(field, "vi", (Object)Boolean.FALSE);
                        continue;
                    }
                    column = (CommonShowDetailEntry.Column)((List)group.getValue()).get(colIndex++);
                    column.setColumnField(field);
                    table.setColumnProperty(field, "vi", (Object)(!entry.getHideColumnKey().contains(column.getColumnKey()) ? 1 : 0));
                    table.setColumnProperty(field, "header", (Object)column.getColumnAlias());
                    if (column.getMaxShowLength() > 0) {
                        table.setColumnProperty(field, "maxlength", (Object)column.getMaxShowLength());
                        continue;
                    }
                    table.setColumnProperty(field, "maxlength", (Object)150);
                }
            }
            if (entry.getDatas().isEmpty()) {
                return;
            }
            this.getModel().batchCreateNewEntryRow("entryentity", entry.getDatas().size());
            DynamicObject obj = null;
            Object[] rowDatas = null;
            List fields = table.getFieldEdits();
            totalCols = fields.size();
            HashMap<String, Integer> colIndexMap = new HashMap<String, Integer>(entry.getColumns().size());
            for (int c = 0; c < entry.getColumns().size(); ++c) {
                colIndexMap.put(((CommonShowDetailEntry.Column)entry.getColumns().get(c)).getColumnField(), c);
            }
            this.cacheColIndexMap(colIndexMap);
            if (entry.getColumns().size() == 1 && ((CommonShowDetailEntry.Column)entry.getColumns().get(0)).getColumnField() != null) {
                table.setColumnProperty(((CommonShowDetailEntry.Column)entry.getColumns().get(0)).getColumnField(), "w", (Object)"100%");
            } else {
                table.setColumnProperty(((CommonShowDetailEntry.Column)entry.getColumns().get(0)).getColumnField(), "w", (Object)"150px");
            }
            for (int r = 0; r < entry.getDatas().size(); ++r) {
                rowDatas = (Object[])entry.getDatas().get(r);
                obj = this.getModel().getEntryRowEntity("entryentity", r);
                for (int c = 0; c < rowDatas.length; ++c) {
                    field = ((CommonShowDetailEntry.Column)entry.getColumns().get(c)).getColumnField();
                    if (colIndexMap.get(field) == null) {
                        obj.set(field, (Object)"");
                        continue;
                    }
                    colIndex = (Integer)colIndexMap.get(field);
                    column = (CommonShowDetailEntry.Column)entry.getColumns().get(colIndex);
                    if (column.getMaxShowLength() > 0) {
                        String data = StringUtils.toNoEmptyString((Object)rowDatas[(Integer)colIndexMap.get(field)]);
                        if (data.length() >= column.getMaxShowLength()) {
                            data = data.substring(0, column.getMaxShowLength() - 10) + "...";
                        }
                        obj.set(field, (Object)data);
                        continue;
                    }
                    obj.set(field, rowDatas[colIndex]);
                }
            }
        }
        finally {
            this.getModel().endInit();
        }
        table.setPageIndex(1);
        this.getView().updateView("entryentity");
    }

    private void cacheColIndexMap(Map<String, Integer> colIndexMap) {
        if (colIndexMap == null) {
            this.getPageCache().remove("colIndexMap");
        } else {
            this.getPageCache().put("colIndexMap", JSONUtils.toString(colIndexMap));
        }
    }

    private Map<String, Integer> getColIndexMap() {
        String cache = this.getPageCache().get("colIndexMap");
        if (StringUtils.isEmpty((String)cache)) {
            return new HashMap<String, Integer>(1);
        }
        MapType javaType = JSONUtils.getMapper().getTypeFactory().constructMapType(Map.class, String.class, Integer.class);
        return (Map)JSONUtils.parse((String)cache, (JavaType)javaType);
    }

    public void itemClick(ItemClickEvent evt) {
        int row;
        super.itemClick(evt);
        if (!btnexport.equals(evt.getItemKey())) {
            return;
        }
        EntryGrid table = (EntryGrid)this.getControl("entryentity");
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirm_exprot", (IFormPlugin)this);
        int rowCount = this.getView().getModel().getEntryRowCount("entryentity");
        int n = row = rowCount == 0 ? this.getView().getModel().getEntryRowCount("entryentity") : rowCount;
        if (table.getEntryState().getSelectedRows().length > 0) {
            row = table.getEntryState().getSelectedRows().length;
        }
        if (row == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"ExportEntry_1", (String)"bos-export", (Object[])new Object[0]));
            return;
        }
        String msg = MessageFormat.format(ResManager.loadKDString((String)"\u672c\u6b21\u5c06\u5bfc\u51fa{0}\u884c\u6570\u636e\uff0c\u70b9\u51fb\u201c\u786e\u5b9a\u201d\u5f00\u59cb\u6267\u884c\u3002", (String)"ExportEntry_3", (String)"bos-export", (Object[])new Object[0]), row);
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, confirmCallBacks);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        XSSFCell cell;
        XSSFRow row;
        if (!"confirm_exprot".equals(e.getCallBackId()) || !MessageBoxResult.Yes.equals((Object)e.getResult())) {
            return;
        }
        CommonShowDetailEntry entry = CommonShowListPlugin.getEntry(this.getView());
        if (entry.getColumns().isEmpty() || entry.getDatas().isEmpty()) {
            return;
        }
        XSSFRow groupHeader = null;
        String caption = this.getView().getFormShowParameter().getFormConfig().getCaption().getLocaleValue();
        if (this.getView().getFormShowParameter().getCustomParam("detailtitle") != null) {
            caption = (String)this.getView().getFormShowParameter().getCustomParam("detailtitle");
        }
        XSSFWorkbook workBook = new XSSFWorkbook();
        XSSFSheet sheet = workBook.createSheet();
        XSSFCellStyle style = workBook.createCellStyle();
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFCellStyle headerStyle = workBook.createCellStyle();
        headerStyle.setAlignment(HorizontalAlignment.CENTER);
        headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headerStyle.setFillForegroundColor(new XSSFColor(new Color(212, 212, 212), (IndexedColorMap)new DefaultIndexedColorMap()));
        headerStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        XSSFFont font = workBook.getFontAt(style.getFontIndex());
        HashMap<Integer, Integer> maxChars = new HashMap<Integer, Integer>();
        boolean hasGroup = false;
        for (CommonShowDetailEntry.Column col : entry.getColumns()) {
            if (!StringUtils.isNotEmpty((String)col.getGroupKey())) continue;
            hasGroup = true;
            break;
        }
        if (hasGroup) {
            groupHeader = sheet.createRow(0);
            row = sheet.createRow(1);
        } else {
            row = sheet.createRow(0);
        }
        ArrayList<Integer> colIndexs = new ArrayList<Integer>();
        HashMap<String, Integer[]> groupMap = new HashMap<String, Integer[]>();
        ArrayList<Integer> groupIndex = new ArrayList<Integer>(10);
        for (int i = 0; i < entry.getColumns().size(); ++i) {
            CommonShowDetailEntry.Column col = (CommonShowDetailEntry.Column)entry.getColumns().get(i);
            if (entry.getHideColumnKey().contains(col.getColumnKey())) continue;
            colIndexs.add(i);
            this.storeMaxChars(maxChars, colIndexs.size() - 1, col.getColumnAlias());
            if (StringUtils.isNotEmpty((String)col.getGroupKey())) {
                groupIndex.add(colIndexs.size() - 1);
                if (groupMap.containsKey(col.getGroupKey())) {
                    ((Integer[])groupMap.get((Object)col.getGroupKey()))[1] = colIndexs.size() - 1;
                } else {
                    groupMap.put(col.getGroupKey(), new Integer[]{colIndexs.size() - 1, colIndexs.size() - 1});
                }
            }
            cell = row.createCell(colIndexs.size() - 1, CellType.STRING);
            cell.setCellValue(((CommonShowDetailEntry.Column)entry.getColumns().get(i)).getColumnAlias());
            cell.setCellStyle((CellStyle)headerStyle);
            if (!hasGroup || groupHeader == null) continue;
            cell = groupHeader.createCell(colIndexs.size() - 1, CellType.STRING);
            if (StringUtils.isNotEmpty((String)col.getGroupKey())) {
                cell.setCellValue(col.getGroupAlias());
            } else {
                cell.setCellValue(col.getColumnAlias());
            }
            cell.setCellStyle((CellStyle)headerStyle);
        }
        if (hasGroup) {
            for (int c = 0; c < colIndexs.size(); ++c) {
                if (groupIndex.contains(c)) continue;
                sheet.addMergedRegion(new CellRangeAddress(0, 1, c, c));
            }
            for (Integer[] gindex : groupMap.values()) {
                if (gindex[0] == null || gindex[0].equals(gindex[1])) continue;
                sheet.addMergedRegion(new CellRangeAddress(0, 0, gindex[0].intValue(), gindex[1].intValue()));
            }
        }
        Object[] rowDatas = null;
        String value = null;
        int in = Math.min(0x100000, entry.getDatas().size());
        for (int i = 0; i < in; ++i) {
            rowDatas = (Object[])entry.getDatas().get(i);
            row = sheet.createRow(i + (hasGroup ? 2 : 1));
            if (rowDatas == null) continue;
            for (int c = 0; c < colIndexs.size(); ++c) {
                cell = row.createCell(c, CellType.STRING);
                cell.setCellStyle((CellStyle)style);
                value = StringUtils.toNoEmptyString((Object)rowDatas[(Integer)colIndexs.get(c)]);
                if (value.length() > 32000) {
                    value = value.substring(0, 32000) + "...";
                }
                this.storeMaxChars(maxChars, c, value);
                cell.setCellValue(value);
            }
        }
        sheet.setDefaultColumnWidth(10);
        for (Map.Entry charLen : maxChars.entrySet()) {
            if ((Integer)charLen.getValue() < 5) {
                sheet.setColumnWidth(((Integer)charLen.getKey()).intValue(), 2048);
                continue;
            }
            sheet.setColumnWidth(((Integer)charLen.getKey()).intValue(), ((Integer)charLen.getValue() + 3) * 256);
        }
        try {
            String url = ImportAndExportUtil.writeFile((Workbook)workBook, (String)caption);
            if (StringUtils.isNotEmpty((String)url)) {
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
            }
        }
        catch (IOException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
    }

    private void storeMaxChars(Map<Integer, Integer> maxChars, int colIndex, String value) {
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        try {
            String[] lines;
            for (String line : lines = value.split("\\n")) {
                String txt = line + "0";
                int width = txt.getBytes(Charset.forName("GBK")).length;
                width = Math.min(width, 120);
                maxChars.put(colIndex, Math.max(maxChars.computeIfAbsent(colIndex, f -> 6), width));
            }
        }
        catch (Throwable e) {
            log.info("storeMaxChars-error{}", (Object)e);
        }
    }
}

