/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.utils.CommonShowDetail;
import kd.epm.eb.common.utils.CommonShowDetailEntry;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NumberUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;

public class ControlBillCheckListPlugin
extends AbstractListPlugin {
    public static final Log logger = LogFactory.getLog(ControlBillCheckListPlugin.class);
    private static final String OPER_MODIFY = "modify";
    private static final String CACHE_IS_HYPERLINK_CLICK = "isHyperLinkClick";
    private static final String STR_TRUE = "true";
    private static final String CHECK_MEATDATA = "bgc_controlbillcheck";
    private static int colindex = 0;
    public static final int COL_CHECKNO = colindex++;
    public static final int COL_CHECKNAME = colindex++;
    public static final int COL_BILLTYPE = colindex++;
    public static final int COL_BILLID = colindex++;
    public static final int COL_BILLNO = colindex++;
    public static final int COL_TIMEFIELDNAME = colindex++;
    public static final int COL_TIMEFIELD = colindex++;
    public static final int COL_OPERATOR = colindex++;
    public static final int COL_OPERTIME = colindex++;
    public static final int COL_OPERTIMEMATCH = colindex++;
    public static final int COL_MODEL = colindex++;
    public static final int COL_BUSSMODEL = colindex++;
    public static final int COL_RECORDOPER = colindex++;
    public static final int COL_RECORDTIME = colindex++;
    public static final int COL_RECORDTIMEMATCH = colindex++;
    public static final int COL_RECORDTABLE = colindex++;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        this.getPageCache().put(CACHE_IS_HYPERLINK_CLICK, STR_TRUE);
    }

    public void doEBCheckPermission(Long modelId, Long userId, String appId, String entityNumber, String permItemId, String permItemDesc) {
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        BillList bl;
        ListSelectedRowCollection selectedRows;
        super.beforeDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        if (Arrays.asList("enable", "disable").contains(opType)) {
            DynamicObject[] schemes;
            List<Long> ids = args.getListSelectedData().stream().map(k -> k.getPrimaryKeyValue()).collect(Collectors.toList());
            if (ids.isEmpty()) {
                return;
            }
            for (DynamicObject scheme : schemes = BusinessDataServiceHelper.load((Object[])ids.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)CHECK_MEATDATA))) {
                scheme.set("status", (Object)"enable".equals(opType));
            }
            SaveServiceHelper.save((DynamicObject[])schemes);
            String numberString = Arrays.stream(schemes).map(k -> k.getString("number")).collect(Collectors.joining(","));
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fee\u6539", "OperationLogUtil_1101", "epm-eb-common");
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u7f16\u53f7\u201c%1$s\u201d\uff0c\u4fee\u6539\u6210\u529f\u3002", "OperationLogUtil_1104", "epm-eb-common");
            this.writeLog(null, opType, opName, opDescription, new String[]{numberString});
        } else if (OPER_MODIFY.equals(opType) && !StringUtils.equals((String)STR_TRUE, (String)this.getPageCache().get(CACHE_IS_HYPERLINK_CLICK)) && (selectedRows = (bl = (BillList)this.getControl("billlistap")).getSelectedRows()) != null && selectedRows.getPrimaryKeyValues().length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u4fee\u6539\uff0c\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u4fee\u6539\u3002", (String)"ControlBillCheckListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        this.getPageCache().remove(CACHE_IS_HYPERLINK_CLICK);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("check".equals(evt.getItemKey())) {
            this.doCheck();
        }
    }

    private void doCheck() {
        if (this.getSelectedCheck(true) == null) {
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5f00\u59cb\u63a7\u5236\u8bb0\u5f55\u68c0\u67e5\uff1f\u8be5\u68c0\u67e5\u53ef\u80fd\u6bd4\u8f83\u8017\u65f6\u3002", (String)"ControlBillCheckListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("check_comfirm", (IFormPlugin)this));
    }

    private DynamicObject[] getSelectedCheck(boolean issimple) {
        HashSet ids = new HashSet(10);
        BillList bl = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = bl.getSelectedRows();
        if (selectedRows != null) {
            selectedRows.forEach(f -> ids.add(IDUtils.toLong((Object)f.getPrimaryKeyValue())));
        }
        DynamicObject[] objs = null;
        if (!ids.isEmpty()) {
            QFilter filter = new QFilter("id", "in", ids).and("status", "=", (Object)Boolean.TRUE);
            objs = BusinessDataServiceHelper.load((String)CHECK_MEATDATA, (String)(issimple ? "id" : "id,number,name,bill.id,bill.name,bill.number,timedvalue,timefield.number,timefield.name,operatorfield.number,condition"), (QFilter[])filter.toArray(), (String)"bill.fieldtable,number");
        }
        if (objs == null || objs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u542f\u7528\u7684\u8bb0\u5f55\u8fdb\u884c\u68c0\u67e5\u64cd\u4f5c\u3002", (String)"ControlBillCheckListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        return objs;
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if (!"check_comfirm".equals(callBackId)) {
            return;
        }
        DynamicObject[] objs = this.getSelectedCheck(false);
        if (objs == null || objs.length == 0) {
            return;
        }
        CommonShowDetail detail = new CommonShowDetail("");
        CommonShowDetailEntry entry = detail.getEntry("", "");
        entry.addColumn(String.valueOf(COL_CHECKNO), ResManager.loadKDString((String)"\u89c4\u5219\u7f16\u7801", (String)"ControlBillCheckListPlugin_COL_CHECKNO", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        entry.addColumn(String.valueOf(COL_CHECKNAME), ResManager.loadKDString((String)"\u89c4\u5219\u540d\u79f0", (String)"ControlBillCheckListPlugin_COL_CHECKNAME", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        entry.addColumn(String.valueOf(COL_BILLTYPE), ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"ControlBillCheckListPlugin_COL_BILLTYPE", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        entry.addColumn(String.valueOf(COL_BILLID), ResManager.loadKDString((String)"\u5355\u636eID", (String)"ControlBillCheckListPlugin_COL_BILLID", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        entry.addColumn(String.valueOf(COL_BILLNO), ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801", (String)"ControlBillCheckListPlugin_COL_COL_BILLNO", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        entry.addColumn(String.valueOf(COL_TIMEFIELDNAME), ResManager.loadKDString((String)"\u65f6\u95f4\u5b57\u6bb5", (String)"ControlBillCheckListPlugin_COL_TIMEFIELDNAME", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        entry.addColumn(String.valueOf(COL_TIMEFIELD), ResManager.loadKDString((String)"\u65f6\u95f4", (String)"ControlBillCheckListPlugin_COL_TIMEFIELD", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        entry.addColumn(String.valueOf(COL_OPERATOR), ResManager.loadKDString((String)"\u63a7\u5236\u64cd\u4f5c", (String)"ControlBillCheckListPlugin_COL_OPERATOR", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        entry.addColumn(String.valueOf(COL_OPERTIME), ResManager.loadKDString((String)"\u63a7\u5236\u64cd\u4f5c\u65f6\u95f4", (String)"ControlBillCheckListPlugin_COL_OPERTIME", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        entry.addColumn(String.valueOf(COL_OPERTIMEMATCH), ResManager.loadKDString((String)"\u64cd\u4f5c\u662f\u5426\u5339\u914d", (String)"ControlBillCheckListPlugin_COL_OPERTIMEMATCH", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        entry.addColumn(String.valueOf(COL_MODEL), ResManager.loadKDString((String)"\u9884\u7b97\u4f53\u7cfb", (String)"ControlBillCheckListPlugin_COL_MODEL", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        entry.addColumn(String.valueOf(COL_BUSSMODEL), ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b", (String)"ControlBillCheckListPlugin_COL_BUSSMODEL", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        entry.addColumn(String.valueOf(COL_RECORDOPER), ResManager.loadKDString((String)"\u6263\u51cf\u64cd\u4f5c", (String)"ControlBillCheckListPlugin_COL_RECORDOPER", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        entry.addColumn(String.valueOf(COL_RECORDTIME), ResManager.loadKDString((String)"\u6263\u51cf\u65f6\u95f4", (String)"ControlBillCheckListPlugin_COL_RECORDTIME", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        entry.addColumn(String.valueOf(COL_RECORDTIMEMATCH), ResManager.loadKDString((String)"\u6263\u51cf\u662f\u5426\u5339\u914d", (String)"ControlBillCheckListPlugin_COL_RECORDTIMEMATCH", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        entry.addColumn(String.valueOf(COL_RECORDTABLE), ResManager.loadKDString((String)"\u63a7\u5236\u8bb0\u5f55", (String)"ControlBillCheckListPlugin_COL_RECORDTABLE", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        HashSet<String> timeFields = new HashSet<String>(10);
        for (DynamicObject obj : objs) {
            this.innerCheck(obj, entry, timeFields);
        }
        String yes = ResManager.loadKDString((String)"\u662f", (String)"ControlBillCheckListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String no = ResManager.loadKDString((String)"\u5426", (String)"ControlBillCheckListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        if (timeFields.size() == 1) {
            if (StringUtils.isEmpty((String)((String)timeFields.iterator().next()))) {
                entry.getHideColumnKey().add(String.valueOf(COL_TIMEFIELDNAME));
                entry.getHideColumnKey().add(String.valueOf(COL_TIMEFIELD));
                entry.getHideColumnKey().add(String.valueOf(COL_OPERTIMEMATCH));
                entry.getHideColumnKey().add(String.valueOf(COL_RECORDTIMEMATCH));
            } else {
                entry.getHideColumnKey().add(String.valueOf(COL_TIMEFIELDNAME));
                for (CommonShowDetailEntry.Column col : entry.getColumns()) {
                    if (!String.valueOf(COL_TIMEFIELD).equals(col.getColumnKey())) continue;
                    col.setColumnAlias((String)timeFields.iterator().next());
                    break;
                }
            }
        }
        for (Object[] rowDatas : entry.getDatas()) {
            String time = (String)rowDatas[COL_TIMEFIELD];
            if (StringUtils.isNotEmpty((String)time) && time.length() > 10 && NumberUtils.isNumber((String)time.substring(0, 4))) {
                rowDatas[ControlBillCheckListPlugin.COL_OPERTIMEMATCH] = StringUtils.isEmpty((String)((String)rowDatas[COL_OPERTIMEMATCH])) ? no : yes;
                rowDatas[ControlBillCheckListPlugin.COL_RECORDTIMEMATCH] = StringUtils.isEmpty((String)((String)rowDatas[COL_RECORDTIMEMATCH])) ? no : yes;
                continue;
            }
            rowDatas[ControlBillCheckListPlugin.COL_OPERTIMEMATCH] = "";
            rowDatas[ControlBillCheckListPlugin.COL_RECORDTIMEMATCH] = "";
        }
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("detaildata", detail);
        params.put("detailtitle", ResManager.loadKDString((String)"\u63a7\u5236\u5355\u636e\u68c0\u67e5\u62a5\u544a", (String)"ControlBillCheckListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("eb_bgcommonshowlist");
        parameter.setCustomParams(params);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private void innerCheck(DynamicObject obj, CommonShowDetailEntry entry, Set<String> timeFields) {
        if (obj == null) {
            return;
        }
        String entityNumber = obj.getDynamicObject("bill").getString("number");
        if (StringUtils.isEmpty((String)entityNumber)) {
            logger.info("entitynumber-empty = " + obj.getString("number"));
            return;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (mainEntityType.getPrimaryKey() == null) {
            logger.info("Bill-PrimaryKey-Empty:" + entityNumber);
            return;
        }
        String condition = obj.getString("condition");
        if (StringUtils.isEmpty((String)condition)) {
            logger.info("condition-Empty:" + obj.getString("number"));
            return;
        }
        FilterCondition filterConditiond = (FilterCondition)SerializationUtils.fromJsonString((String)condition, FilterCondition.class);
        FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterConditiond);
        filterBuilder.buildFilter();
        QFilter filter = filterBuilder.getQFilter();
        if (filter == null) {
            logger.info("condition-Empty:" + obj.getString("number"));
            return;
        }
        String billnofield = "billno";
        String billidfield = mainEntityType.getPrimaryKey().getName();
        if (mainEntityType.getProperty(billnofield) == null && mainEntityType.getProperty(billnofield = "number") == null) {
            billnofield = billidfield;
        }
        DynamicObject timeobj = obj.getDynamicObject("timefield");
        String timefield = null;
        String timefieldname = "";
        String timeerror = "";
        int timedvalue = obj.getInt("timedvalue");
        if (timeobj != null) {
            timefield = obj.getString("timefield.number");
            if (timefield == null) {
                timeerror = ResManager.loadKDString((String)"\u5b57\u6bb5\u4e0d\u5b58\u5728", (String)"ControlBillCheckListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            } else {
                DynamicProperty prop = mainEntityType.getProperty(timefield);
                timefieldname = obj.getString("timefield.name");
                if (prop == null) {
                    timefield = null;
                    timeerror = ResManager.loadKDString((String)"\u5b57\u6bb5\u4e0d\u5b58\u5728", (String)"ControlBillCheckListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                } else if (!prop.getPropertyType().isAssignableFrom(Date.class)) {
                    timefield = null;
                    timeerror = ResManager.loadKDString((String)"\u975e\u65f6\u95f4\u5b57\u6bb5", (String)"ControlBillCheckListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
            }
        }
        timeFields.add(timefieldname);
        StringBuilder fields = new StringBuilder(billidfield).append(billidfield.equals(billnofield) ? "" : ", " + billnofield).append(StringUtils.isEmpty((String)timefield) ? "" : "," + timefield);
        LinkedHashMap<String, Object[]> billDatas = new LinkedHashMap<String, Object[]>(100);
        LinkedHashMap<String, Long> billDates = new LinkedHashMap<String, Long>(100);
        Object[] rowDatas = null;
        String billId = null;
        SimpleDateFormat timeformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryBillForCheck", (String)entityNumber, (String)fields.toString(), (QFilter[])filter.toArray(), (String)billnofield);){
            if (ds != null) {
                for (Object row : ds) {
                    rowDatas = new Object[colindex];
                    Arrays.fill(rowDatas, "");
                    billId = row.getString(billidfield);
                    entry.getDatas().add(rowDatas);
                    billDatas.put(billId, rowDatas);
                    rowDatas[ControlBillCheckListPlugin.COL_CHECKNO] = obj.getString("number");
                    rowDatas[ControlBillCheckListPlugin.COL_CHECKNAME] = obj.getString("name");
                    rowDatas[ControlBillCheckListPlugin.COL_BILLTYPE] = mainEntityType.getDisplayName().getLocaleValue();
                    rowDatas[ControlBillCheckListPlugin.COL_BILLID] = billId;
                    rowDatas[ControlBillCheckListPlugin.COL_BILLNO] = row.getString(billnofield);
                    rowDatas[ControlBillCheckListPlugin.COL_TIMEFIELDNAME] = timefieldname;
                    if (StringUtils.isNotEmpty((String)timefield)) {
                        rowDatas[ControlBillCheckListPlugin.COL_TIMEFIELD] = timeformat.format(row.getDate(timefield));
                        billDates.put(billId, row.getDate(timefield).getTime());
                        continue;
                    }
                    rowDatas[ControlBillCheckListPlugin.COL_TIMEFIELD] = timeerror;
                }
            }
        }
        if (billDatas.isEmpty()) {
            rowDatas = new Object[colindex];
            entry.getDatas().add(rowDatas);
            Arrays.fill(rowDatas, "");
            rowDatas[ControlBillCheckListPlugin.COL_CHECKNO] = obj.getString("number");
            rowDatas[ControlBillCheckListPlugin.COL_CHECKNAME] = obj.getString("name");
            rowDatas[ControlBillCheckListPlugin.COL_BILLTYPE] = mainEntityType.getDisplayName().getLocaleValue();
            rowDatas[ControlBillCheckListPlugin.COL_BILLID] = ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"ControlBillCheckListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            return;
        }
        SqlBuilder build = new SqlBuilder().append("select fbillid,foperation,fcreatedate from t_eb_bgcontroloperlog where ", new Object[0]).append("fentitynumber = ?", new Object[]{entityNumber}).appendIn(" and fbillid ", billDatas.keySet().toArray());
        DynamicObjectCollection opf = obj.getDynamicObjectCollection("operatorfield");
        ArrayList<Object> opset = new ArrayList<Object>(opf.size());
        if (opf != null && !opf.isEmpty()) {
            for (DynamicObject opobj : opf) {
                if (StringUtils.isNotEmpty((String)opobj.getDynamicObject("fbasedataid").getString("number"))) {
                    opset.add(opobj.getDynamicObject("fbasedataid").getString("number"));
                    continue;
                }
                logger.info("operator-null");
            }
            build.appendIn(" and foperation", opset);
        }
        String time = null;
        DataSet ds = DB.queryDataSet((String)"queryControlOpLog", (DBRoute)BgBaseConstant.epm, (SqlBuilder)build);
        Object object = null;
        try {
            if (ds != null) {
                for (Row row : ds) {
                    billId = row.getString("fbillid");
                    time = timeformat.format(row.getDate("fcreatedate"));
                    this.matchtime(timedvalue, billDatas, billDates, billId, time, row.getString("foperation"), row.getDate("fcreatedate").getTime(), COL_OPERATOR, COL_OPERTIME, COL_OPERTIMEMATCH);
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        HashMap<String, Set> controlIndexMap = new HashMap<String, Set>(10);
        build = new SqlBuilder().append("select fbizid, ftable from t_eb_bgcontrolindex where ", new Object[0]);
        build.append("fentitynumber = ?", new Object[]{entityNumber});
        build.appendIn(" and fbizid ", billDatas.keySet().toArray());
        Throwable throwable = null;
        try (DataSet ds2 = DB.queryDataSet((String)"queryControlIndex", (DBRoute)BgBaseConstant.epm, (SqlBuilder)build);){
            if (ds2 != null) {
                for (Row row : ds2) {
                    controlIndexMap.computeIfAbsent(row.getString("ftable"), f -> new HashSet(16)).add(row.getString("fbizid"));
                }
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        for (Map.Entry entry2 : controlIndexMap.entrySet()) {
            this.queryControlRecord(entityNumber, (String)entry2.getKey(), (Set)entry2.getValue(), timedvalue, billDatas, billDates, timeformat, opset);
        }
    }

    private void queryControlRecord(String entityNumber, String tablename, Set<String> billids, int timedvalue, Map<String, Object[]> billDatas, Map<String, Long> billDates, SimpleDateFormat timeformat, List<Object> opset) {
        DynamicObject busModel = null;
        HashSet<Long> modelIds = new HashSet<Long>(10);
        if (!tablename.equals("t_eb_bgcontrolrecord")) {
            Long busmodelid = Long.parseLong(tablename.substring("t_eb_cr".length()));
            busModel = BusinessDataServiceHelper.loadSingleFromCache((Object)busmodelid, (String)"eb_businessmodel", (String)"id, name, number");
        }
        SqlBuilder build = new SqlBuilder().append("select fmodelid,fbizid,foperation,fcreatetime from " + tablename + " where ", new Object[0]);
        build.appendIn("fbizid ", billids.toArray());
        build.append(" and fentitynumber = ?", new Object[]{entityNumber});
        if (opset != null && !opset.isEmpty()) {
            build.appendIn(" and foperation ", opset);
        }
        ArrayList<Object[]> thisDatas = new ArrayList<Object[]>(billids.size());
        Object[] rowDatas = null;
        String billId = null;
        String time = null;
        Long modelid = null;
        DataSet ds = DB.queryDataSet((String)"queryControlRecord", (DBRoute)BgBaseConstant.epm, (SqlBuilder)build);
        Object object = null;
        try {
            if (ds != null) {
                for (Row row : ds) {
                    billId = row.getString("fbizid");
                    time = timeformat.format(row.getDate("fcreatetime"));
                    modelid = row.getLong("fmodelid");
                    modelIds.add(modelid);
                    rowDatas = billDatas.get(billId);
                    thisDatas.add(rowDatas);
                    rowDatas[ControlBillCheckListPlugin.COL_RECORDTABLE] = tablename;
                    rowDatas[ControlBillCheckListPlugin.COL_MODEL] = modelid;
                    if (busModel != null) {
                        rowDatas[ControlBillCheckListPlugin.COL_BUSSMODEL] = busModel.getString("name");
                    }
                    this.matchtime(timedvalue, billDatas, billDates, billId, time, row.getString("foperation"), row.getDate("fcreatetime").getTime(), COL_RECORDOPER, COL_RECORDTIME, COL_RECORDTIMEMATCH);
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        Map models = null;
        if (!modelIds.isEmpty()) {
            models = BusinessDataServiceHelper.loadFromCache((String)"epm_model", (String)"id, number,name, reporttype", (QFilter[])new QFilter("id", "in", modelIds).toArray());
        }
        for (Object[] rowDatas1 : thisDatas) {
            modelid = IDUtils.toLong((Object)rowDatas1[COL_MODEL]);
            if (models == null || models.get(modelid) == null) continue;
            rowDatas1[ControlBillCheckListPlugin.COL_MODEL] = ((DynamicObject)models.get(modelid)).getString("name");
            if (BizModel.isBgmdModel((DynamicObject)((DynamicObject)models.get(modelid)))) continue;
            rowDatas1[ControlBillCheckListPlugin.COL_BUSSMODEL] = "";
        }
    }

    private void matchtime(int timedvalue, Map<String, Object[]> billDatas, Map<String, Long> billDates, String billId, String time, String operator, long timems, int opIndex, int optimeindex, int opmatchindex) {
        Object[] rowDatas = billDatas.get(billId);
        if (billDates.containsKey(billId)) {
            boolean ismatch;
            boolean bl = ismatch = Math.abs(timems - billDates.get(billId)) <= (long)timedvalue;
            if (StringUtils.isEmpty((String)((String)rowDatas[COL_OPERTIMEMATCH]))) {
                if (ismatch) {
                    rowDatas[opIndex] = operator;
                    rowDatas[optimeindex] = time;
                    rowDatas[opmatchindex] = "yes";
                } else {
                    rowDatas[opIndex] = operator;
                    rowDatas[optimeindex] = time;
                }
            } else if (ismatch && time.compareTo((String)rowDatas[opIndex]) > 0) {
                rowDatas[opIndex] = operator;
                rowDatas[optimeindex] = time;
            }
        } else if (StringUtils.isEmpty((String)((String)rowDatas[opIndex])) || time.compareTo((String)rowDatas[opIndex]) > 0) {
            rowDatas[opIndex] = operator;
            rowDatas[optimeindex] = time;
        }
    }

    @Override
    public boolean isCheckModel() {
        return false;
    }
}

