/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.enums.BillFieldTypeEmum;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.utils.BgRegisterUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class ControlBillCheckPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static final Log logger = LogFactory.getLog(ControlBillCheckPlugin.class);
    private static final String CONDITION = "condition";
    private static final String FILTER_GRIDAP = "filtergridap";
    private static final int CONDITION_MAX_LENGTH = 2000;
    private static final String OPER_SAVE = "save";
    private static final String APPLICATION = "application";
    private static final String BILL = "bill";
    private static final String TIMEFIELD = "timefield";
    private static final String OPERATORFIELD = "operatorfield";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit edit = (BasedataEdit)this.getView().getControl(BILL);
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        edit = (BasedataEdit)this.getView().getControl(TIMEFIELD);
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        edit = (BasedataEdit)this.getView().getControl(OPERATORFIELD);
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object iscopy = this.getView().getFormShowParameter().getCustomParam("iscopy");
        if (!OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus()) || iscopy != null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{APPLICATION, BILL});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{APPLICATION, BILL});
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_GRIDAP);
        filterGrid.setEntityNumber(this.getEntityNumber());
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key;
        switch (key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey()) {
            case "bill": {
                this.addF7Filter(beforeF7SelectEvent, new QFilter("parent", "=", (Object)this.getF7FilterId(beforeF7SelectEvent, APPLICATION)));
                break;
            }
            case "timefield": {
                this.addF7Filter(beforeF7SelectEvent, new QFilter("bizunitid", "=", (Object)this.getF7FilterId(beforeF7SelectEvent, BILL)).and("type", "=", (Object)BillFieldTypeEmum.PERIOD.getNumber()).and("number", "not like", (Object)"%.%"));
                break;
            }
            case "operatorfield": {
                this.addF7Filter(beforeF7SelectEvent, new QFilter("bizunitid", "=", (Object)this.getF7FilterId(beforeF7SelectEvent, BILL)).and("type", "in", (Object)Sets.newHashSet((Object[])new String[]{BillFieldTypeEmum.TAKEOPERATION.getNumber(), BillFieldTypeEmum.RUNOPERATION.getNumber()})));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Long getF7FilterId(BeforeF7SelectEvent e, String field) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicProperty property = dataEntity.getDynamicObjectType().getProperty(field);
        if (dataEntity == null) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u4e0d\u5305\u542b\u5b57\u6bb5%1\uff0c\u8bf7\u68c0\u67e5", (String)"AbstractBasePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{field}));
            e.setCancel(true);
            return 0L;
        }
        Object o = dataEntity.get(property.getName());
        if (o == null) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u5148\u9009\u62e9%1", (String)"AbstractBasePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{property.getDisplayName().toString()}));
            e.setCancel(true);
            return 0L;
        }
        DynamicObject dynamicObject = (DynamicObject)o;
        return dynamicObject.getLong("id");
    }

    public void addF7Filter(BeforeF7SelectEvent e, QFilter qFilter) {
        this.addF7Filters(e, Lists.newArrayList((Object[])new QFilter[]{qFilter}));
    }

    public void addF7Filters(BeforeF7SelectEvent e, List<QFilter> filters) {
        if (e == null) {
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        ArrayList<QFilter> qFilters = showParameter.getListFilterParameter().getQFilters();
        if (qFilters == null) {
            qFilters = new ArrayList<QFilter>(16);
        }
        if (filters != null) {
            qFilters.addAll(filters);
        }
        showParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
        showParameter.setShowApproved(false);
        showParameter.setShowUsed(false);
        NewF7Utils.dealSelectRows((ListShowParameter)showParameter, (BeforeF7SelectEvent)e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_GRIDAP);
        String entitynumber = this.getEntityNumber();
        if (entitynumber != null) {
            filterGrid.setEntityNumber(entitynumber);
        }
        this.getView().setEnable(Boolean.valueOf(entitynumber != null), new String[]{FILTER_GRIDAP});
        String filterObj = this.getModel().getValue(CONDITION) == null ? "" : this.getModel().getValue(CONDITION).toString();
        FilterCondition filterCondition = null;
        if (StringUtils.isNotEmpty((String)filterObj)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterObj, FilterCondition.class);
        } else if (filterGrid.getFilterGridState() != null && filterGrid.getFilterGridState().getFilterCondition() != null && CollectionUtils.isNotEmpty((Collection)filterGrid.getFilterGridState().getFilterCondition().getFilterRow())) {
            filterCondition = filterGrid.getFilterGridState().getFilterCondition();
            filterCondition.getFilterRow().clear();
        }
        filterGrid.SetValue(filterCondition);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "bill": {
                this.resetFilter(this.getEntityNumber());
                break;
            }
            case "application": {
                this.getModel().setValue(BILL, null);
            }
        }
    }

    private void resetFilter(String entitynumber) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_GRIDAP);
        FilterCondition filterCondition = this.getFilterCondition();
        if (filterCondition != null && filterCondition.getFilterRow() != null) {
            filterCondition.getFilterRow().clear();
        }
        filterGrid.SetValue(filterCondition);
        if (entitynumber != null) {
            filterGrid.setEntityNumber(entitynumber);
        } else {
            filterGrid.setFieldColumns(new ArrayList(1));
        }
        filterGrid.bindData(null);
        this.getView().setEnable(Boolean.valueOf(entitynumber != null), new String[]{FILTER_GRIDAP});
        this.getModel().setValue(TIMEFIELD, null);
        this.getModel().setValue(OPERATORFIELD, null);
        this.getView().updateView();
    }

    private String getEntityNumber() {
        DynamicObject billObj = (DynamicObject)this.getModel().getValue(BILL);
        return billObj == null ? null : billObj.getString("number");
    }

    public void doEBCheckPermission(Long modelId, Long userId, String appId, String entityNumber, String permItemId, String permItemDesc) {
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (OPER_SAVE.equals(operate.getOperateKey())) {
            String tips;
            if (!this.validate()) {
                args.setCancel(true);
            }
            if (StringUtils.isNotEmpty((String)(tips = NumberCheckUtils.checkNumberRule((String)this.getModel().getValue("number").toString())))) {
                throw new KDBizException(tips);
            }
            FilterCondition filterCondition = this.getFilterCondition();
            String condition = null;
            if (filterCondition != null && filterCondition.getFilterRow() != null) {
                boolean hasTimeFilter = false;
                if (filterCondition.getFilterRow() != null) {
                    MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.getEntityNumber());
                    for (SimpleFilterRow filterRow : filterCondition.getFilterRow()) {
                        IDataEntityProperty prop = BgRegisterUtils.getField((MainEntityType)mainEntityType, (String)filterRow.getFieldName(), null);
                        if (prop == null || !prop.getPropertyType().isAssignableFrom(Date.class)) continue;
                        hasTimeFilter = true;
                        break;
                    }
                }
                if (!hasTimeFilter) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u89c4\u5219\u6761\u4ef6\u5fc5\u987b\u5305\u542b\u65f6\u95f4\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"ControlBillCheckPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                condition = SerializationUtils.toJsonString((Object)filterCondition);
                if (condition.length() > 2000) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u89c4\u5219\u6761\u4ef6\u8d85\u51fa\u9650\u5236\u957f\u5ea6\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"ControlBillCheckPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
            this.getModel().setValue(CONDITION, condition);
            if (this.getModel().getValue("timedvalue") == null) {
                this.getModel().setValue("timedvalue", (Object)300);
            }
        }
    }

    private FilterCondition getFilterCondition() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_GRIDAP);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        return filterCondition;
    }

    private boolean validate() {
        boolean result = true;
        IDataModel model = this.getModel();
        Object value = model.getValue("number");
        Object name = model.getValue("name");
        if (Objects.nonNull(value)) {
            if (value.toString().matches("[\u4e00-\u9fa5]+")) {
                result = false;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u5141\u8bb8\u8f93\u5165\u4e2d\u6587\u3002", (String)"ControlBillCheckPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (StringUtils.isEmpty((String)value.toString().trim()) || StringUtils.isEmpty((String)name.toString())) {
                result = false;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7f16\u7801\u6216\u540d\u79f0\u201d\u3002", (String)"ControlBillCheckPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        return result;
    }

    public boolean triggerPropChange() {
        return true;
    }

    @Override
    public boolean isCheckModel() {
        return false;
    }
}

