/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.ControlMessageEnum;
import kd.epm.eb.common.enums.ControlMessageTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class ControlMessageSetPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String MESSAGE_TYPE = "messagetype";
    private static final String MESSAGE_TITLE = "messagetitle";
    private static final String MESSAGE_CONTENT_TEXT = "text";
    private static final String MESSAGE_CONTENT = "messagecontent";
    private static final String RESTORE_DEFAULT = "restoredefault";
    private static final String APPLY_OTHER_BILL = "applyotherbill";
    private static final String TREE_VIEW_MESSAGE = "treeviewmessage";
    private static final String BTN_OK = "btnok";
    private static final String BTN_OK_BACK = "btnokback";
    private static final String CACHE_TREE_VIEW_MESSAGE = "cache_tree_view_message";
    private static final String CACHE_CONTROL_MESSAGE_LIST = "cache_control_message_list";
    private static final String CACHE_MESSAGE_TITLE = "cache_message_title";
    private static final String CACHE_MESSAGE_CONTENT = "cache_message_content";
    private static final String CACHE_SAVE_TYPE = "cache_save_type";
    private static final String CACHE_OLD_DATA = "cache_old_data";
    private static final int MAX_LEVEL = 16;
    private static final String FOCUS = "focus";
    private static final String SPECIAL_FIELD = "special_field";
    private static final String CHANGE_MESSAGE_TYPE = "change_message_type";
    private static final String BILL = "bill";
    private static final String DEFAULT_MESSAGE_CONTENT = "{entity.number} - {entity.name}\uff0c{account.number} - {account.name}\uff0c{userdefineddim.all}\uff0c{period.number} - {period.name}\uff1b";
    private static final int MESSAGE_CONTENT_MAX_LENGTH = 2000;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{RESTORE_DEFAULT, APPLY_OTHER_BILL, BTN_OK, BTN_OK_BACK});
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW_MESSAGE);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTreeViewMessage();
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params.get(BILL) != null) {
            Long bill = IDUtils.toLong(params.get(BILL));
            this.getPageCache().put(BILL, String.valueOf(bill));
            this.changeControlMessage(bill, ControlMessageTypeEnum.BUDGET_NOT_ENOUGH.getNumber());
        }
    }

    private void changeControlMessage(Long bill, String messageType) {
        QFilter qFilter = new QFilter(BILL, "=", (Object)bill);
        qFilter.and(new QFilter(MESSAGE_TYPE, "=", (Object)messageType));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bgc_controlmessage", (String)"messagetype,messagetitle,messagecontent", (QFilter[])qFilter.toArray());
        if (dynamicObject != null) {
            boolean hasL = false;
            SqlBuilder sql = new SqlBuilder();
            sql.append("select fid from t_eb_controlmessage_l", new Object[0]);
            sql.append(" where fid = ?", new Object[]{dynamicObject.getLong("id")});
            try (DataSet ds = DB.queryDataSet((String)"queryHasL", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                hasL = ds != null && ds.hasNext();
            }
            this.getModel().setValue(MESSAGE_TYPE, (Object)dynamicObject.getString(MESSAGE_TYPE));
            this.getModel().setValue(MESSAGE_TITLE, (Object)this.processGLang(dynamicObject.getLocaleString(MESSAGE_TITLE), hasL));
            this.getModel().setValue(MESSAGE_CONTENT_TEXT, (Object)this.processGLang(dynamicObject.getLocaleString(MESSAGE_CONTENT), hasL));
        } else {
            this.setDefaultControlMessage();
        }
        this.getPageCache().put(CACHE_MESSAGE_TITLE, JSONUtils.toString((Object)this.getModel().getValue(MESSAGE_TITLE)));
        this.getPageCache().put(CACHE_MESSAGE_CONTENT, JSONUtils.toString((Object)this.getModel().getValue(MESSAGE_CONTENT_TEXT)));
    }

    private ILocaleString processGLang(ILocaleString localeString, boolean hasL) {
        if (hasL) {
            return localeString;
        }
        if (localeString != null && localeString.keySet().contains("GLang")) {
            String msg = (String)localeString.get((Object)"GLang");
            LocaleString basemsg = BgControlUtils.getDefaultMessageTitle();
            if (basemsg != null) {
                for (String key : basemsg.keySet()) {
                    localeString.put((Object)key, (Object)msg);
                }
            }
        }
        return localeString;
    }

    private void initTreeViewMessage() {
        TreeNode rootLeft = null;
        HashMap<String, TreeNode> allNode = new HashMap<String, TreeNode>(16);
        ArrayList<String> controlMessages = new ArrayList<String>(16);
        for (ControlMessageEnum controlMessageEnum : ControlMessageEnum.values()) {
            controlMessages.add(controlMessageEnum.getNumber());
            TreeNode node = new TreeNode();
            node.setId(controlMessageEnum.getId());
            node.setText(controlMessageEnum.getName());
            node.setParentid(controlMessageEnum.getParentId());
            HashMap<String, String> data = new HashMap<String, String>(16);
            data.put("name", controlMessageEnum.getName());
            data.put("number", controlMessageEnum.getNumber());
            data.put("id", controlMessageEnum.getId());
            node.setData(data);
            if (rootLeft == null) {
                rootLeft = node;
            } else if (allNode.containsKey(node.getParentid())) {
                TreeNode parentNode = (TreeNode)allNode.get(node.getParentid());
                if (parentNode.getChildren() == null) {
                    parentNode.setChildren(new ArrayList(16));
                }
                parentNode.getChildren().add(node);
            }
            allNode.put(node.getId(), node);
        }
        if (rootLeft == null) {
            return;
        }
        this.getPageCache().put(CACHE_TREE_VIEW_MESSAGE, SerializationUtils.toJsonString(rootLeft));
        this.getPageCache().put(CACHE_CONTROL_MESSAGE_LIST, SerializationUtils.toJsonString(controlMessages));
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW_MESSAGE);
        treeView.deleteAllNodes();
        treeView.updateNode(rootLeft);
        treeView.addNode(rootLeft);
        treeView.expand(rootLeft.getId());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String prop;
        super.propertyChanged(e);
        switch (prop = e.getProperty().getName()) {
            case "messagetype": {
                this.setDataToPageCache(e);
                if (!StringUtils.equals((String)this.getPageCache().get(CACHE_MESSAGE_TITLE), (String)JSONUtils.toString((Object)this.getModel().getValue(MESSAGE_TITLE))) || !StringUtils.equals((String)this.getPageCache().get(CACHE_MESSAGE_CONTENT), (String)String.valueOf(this.getModel().getValue(MESSAGE_CONTENT_TEXT)))) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d8\u5316\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5207\u6362\u63d0\u793a\u7c7b\u578b\u3002", (String)"ControlMessageSetPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CHANGE_MESSAGE_TYPE, (IFormPlugin)this));
                    break;
                }
                Long bill = Long.valueOf(this.getPageCache().get(BILL));
                String messageType = String.valueOf(this.getModel().getValue(MESSAGE_TYPE));
                this.changeControlMessage(bill, messageType);
                break;
            }
        }
    }

    private void setDataToPageCache(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet != null && changeSet[0].getOldValue() != null) {
            this.getPageCache().put(CACHE_OLD_DATA, changeSet[0].getOldValue().toString());
        }
    }

    private void setOldData(String key) {
        this.getModel().beginInit();
        String oldData = this.getPageCache().get(CACHE_OLD_DATA);
        if (oldData != null) {
            this.getModel().setValue(key, (Object)oldData);
        }
        this.getView().updateView(key);
        this.getModel().endInit();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": 
            case "btnokback": {
                this.saveControlMessage(key);
                break;
            }
            case "restoredefault": {
                this.setDefaultControlMessage();
                break;
            }
            case "applyotherbill": {
                this.openApplyOtherBill();
                break;
            }
        }
    }

    private void saveControlMessage(String key) {
        ILocaleString messageContent;
        List<String> checkResultsContent;
        this.getPageCache().put(CACHE_SAVE_TYPE, key);
        List<String> controlMessageList = this.getControlMessageList();
        IDataModel model = this.getModel();
        ILocaleString messageTitle = (ILocaleString)model.getValue(MESSAGE_TITLE);
        StringBuilder checkResultSb = new StringBuilder();
        List<String> checkResultsTitle = this.getCheckResults(controlMessageList, messageTitle);
        if (CollectionUtils.isNotEmpty(checkResultsTitle)) {
            checkResultSb.append(ResManager.loadResFormat((String)"\u63d0\u793a\u6807\u9898\u8f93\u5165\u7684\u5173\u952e\u5b57\uff1a%1\u3002", (String)"ControlMessageSetPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{StringUtils.join(checkResultsTitle, (String)"\u3001")}));
        }
        if (CollectionUtils.isNotEmpty(checkResultsContent = this.getCheckResults(controlMessageList, messageContent = (ILocaleString)model.getValue(MESSAGE_CONTENT_TEXT)))) {
            checkResultSb.append(ResManager.loadResFormat((String)"\u63d0\u793a\u5185\u5bb9\u8f93\u5165\u7684\u5173\u952e\u5b57\uff1a%1\u3002", (String)"ControlMessageSetPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{StringUtils.join(checkResultsContent, (String)"\u3001")}));
        }
        if (checkResultSb.length() > 0) {
            checkResultSb.append(ResManager.loadKDString((String)"\u7cfb\u7edf\u65e0\u6cd5\u8bc6\u522b\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6309\u6587\u672c\u5904\u7406\u3002", (String)"ControlMessageSetPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(checkResultSb.toString(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(SPECIAL_FIELD, (IFormPlugin)this));
        } else {
            List<Long> bills = this.getCurBills();
            boolean saveSuccess = this.saveData(bills);
            if (saveSuccess) {
                OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, null, (MultiLangEnumBridge)new MultiLangEnumBridge("\u4fdd\u5b58", "BillFieldAddPlugin_18", "epm-eb-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f", "BillFieldAddPlugin_15", "epm-eb-formplugin"), null);
            }
            if (saveSuccess && BTN_OK_BACK.equals(key)) {
                this.getView().returnDataToParent((Object)"success");
                this.getView().close();
            }
        }
    }

    @NotNull
    private List<String> getCheckResults(List<String> controlMessageList, ILocaleString textFieldKey) {
        if (textFieldKey == null) {
            return new ArrayList<String>(16);
        }
        ArrayList<String> checkResults = new ArrayList<String>(16);
        for (Map.Entry entry : textFieldKey.entrySet()) {
            String[] strings = org.apache.commons.lang3.StringUtils.substringsBetween((String)((String)entry.getValue()), (String)"{", (String)"}");
            if (strings == null) continue;
            for (String string : strings) {
                if (controlMessageList.contains(string)) continue;
                checkResults.add("{" + string + "}");
            }
        }
        return checkResults;
    }

    private void setDefaultControlMessage() {
        LocaleString title = BgControlUtils.getDefaultMessageTitle();
        this.getModel().setValue(MESSAGE_TITLE, (Object)title);
        LocaleString ls = new LocaleString(DEFAULT_MESSAGE_CONTENT);
        if (title != null) {
            for (String local : title.keySet()) {
                ls.put((Object)local, (Object)DEFAULT_MESSAGE_CONTENT);
            }
        }
        this.getModel().setValue(MESSAGE_CONTENT_TEXT, (Object)ls);
    }

    private void openApplyOtherBill() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_listf7");
        showParameter.setBillFormId("eb_structofbill");
        showParameter.setLookUp(true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, APPLY_OTHER_BILL));
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("780");
        styleCss.setHeight("600");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        Long bill = Long.valueOf(this.getPageCache().get(BILL));
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        qFilterList.add(new QFilter("id", "not in", (Object)bill));
        qFilterList.add(new QFilter("billtype", "=", (Object)BILL));
        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, "parent,number"));
        showParameter.setShowTitle(false);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        TreeNode selectedNode;
        super.treeNodeClick(evt);
        String nodeId = String.valueOf(evt.getNodeId());
        TreeNode rootNode = this.getRootNode();
        if (StringUtils.isNotEmpty((String)nodeId) && rootNode != null && (selectedNode = rootNode.getTreeNode(nodeId, 16)) != null && CollectionUtils.isEmpty((Collection)selectedNode.getChildren())) {
            String postText;
            Map data = (Map)selectedNode.getData();
            String number = (String)data.get("number");
            StringBuilder appendSb = new StringBuilder();
            appendSb.append("{").append(number).append("}");
            IDataModel model = this.getModel();
            String messageContent = String.valueOf(model.getValue(MESSAGE_CONTENT_TEXT));
            int cursorFocusIndex = this.getCursorFocusIndex(this.getView(), TREE_VIEW_MESSAGE, MESSAGE_CONTENT_TEXT);
            if (cursorFocusIndex > messageContent.length()) {
                cursorFocusIndex = messageContent.length();
            }
            if ((postText = messageContent.substring(cursorFocusIndex)).indexOf("{") > postText.indexOf("}") || !postText.contains("{") && postText.contains("}")) {
                cursorFocusIndex += postText.indexOf("}") + 1;
                postText = messageContent.substring(cursorFocusIndex);
            }
            String preText = messageContent.substring(0, cursorFocusIndex);
            StringBuilder showText = new StringBuilder().append(preText).append((CharSequence)appendSb).append(postText);
            ILocaleString ls = (ILocaleString)model.getValue(MESSAGE_CONTENT_TEXT);
            if (ls != null) {
                ls.setLocaleValue(showText.toString());
            }
            model.setValue(MESSAGE_CONTENT_TEXT, (Object)ls);
            HashMap<String, Object> cursorMap = new HashMap<String, Object>(16);
            cursorMap.put("cursorIndex", cursorFocusIndex + appendSb.length());
            cursorMap.put("ctrlKey", MESSAGE_CONTENT_TEXT);
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.addAction("setTextareaCursorPosition", cursorMap);
        }
    }

    private TreeNode getRootNode() {
        String treeCache = this.getPageCache().get(CACHE_TREE_VIEW_MESSAGE);
        return StringUtils.isNotEmpty((String)treeCache) ? (TreeNode)SerializationUtils.fromJsonString((String)treeCache, TreeNode.class) : null;
    }

    private List<String> getControlMessageList() {
        String listCache = this.getPageCache().get(CACHE_CONTROL_MESSAGE_LIST);
        return StringUtils.isNotEmpty((String)listCache) ? SerializationUtils.fromJsonStringToList((String)listCache, String.class) : new ArrayList(16);
    }

    private int getCursorFocusIndex(IFormView view, String buttonKey, String textFieldKey) {
        String textValue = String.valueOf(view.getModel().getValue(textFieldKey));
        int cursorIndex = StringUtils.isEmpty((String)textValue) ? 0 : textValue.length();
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        Object listPostData = proxy.getViewState(buttonKey);
        if (listPostData instanceof Map) {
            Map map = (Map)listPostData;
            if (map.get(FOCUS) != null) {
                Map focus = (Map)map.get(FOCUS);
                if (focus.get(textFieldKey) != null && focus.get(textFieldKey) instanceof Integer) {
                    cursorIndex = (Integer)focus.get(textFieldKey);
                }
            } else if (map.get(textFieldKey) != null) {
                cursorIndex = (Integer)map.get(textFieldKey);
            }
        }
        return cursorIndex;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (key = messageBoxClosedEvent.getCallBackId()) {
            case "special_field": {
                List<Long> bills;
                boolean saveSuccess;
                if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes || !(saveSuccess = this.saveData(bills = this.getCurBills())) || !BTN_OK_BACK.equals(this.getPageCache().get(CACHE_SAVE_TYPE))) break;
                this.getView().returnDataToParent((Object)"success");
                this.getView().close();
                break;
            }
            case "change_message_type": {
                if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                    Long bill = Long.valueOf(this.getPageCache().get(BILL));
                    String messageType = String.valueOf(this.getModel().getValue(MESSAGE_TYPE));
                    this.changeControlMessage(bill, messageType);
                    break;
                }
                this.setOldData(MESSAGE_TYPE);
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (APPLY_OTHER_BILL.equals(actionId) && closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            List<Long> bills = this.getCurBills();
            for (ListSelectedRow selectedRow : returnData) {
                bills.add(IDUtils.toLong((Object)selectedRow.getPrimaryKeyValue()));
            }
            this.saveData(bills);
        }
    }

    @NotNull
    private List<Long> getCurBills() {
        Long bill = Long.valueOf(this.getPageCache().get(BILL));
        ArrayList<Long> bills = new ArrayList<Long>(16);
        bills.add(bill);
        return bills;
    }

    private boolean saveData(List<Long> bills) {
        ILocaleString messageContent = (ILocaleString)this.getModel().getValue(MESSAGE_CONTENT_TEXT);
        if (messageContent == null || StringUtils.isEmpty((String)messageContent.getLocaleValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u63d0\u793a\u5185\u5bb9\u3002", (String)"ControlMessageSetPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        for (Map.Entry entry : messageContent.entrySet()) {
            if (entry.getValue() == null || ((String)entry.getValue()).length() <= 2000) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u63d0\u793a\u5185\u5bb9\u8d85\u51fa\u6700\u5927\u9650\u5236\u957f\u5ea62000\u3002", (String)"ControlMessageSetPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        QFilter qFilter = new QFilter(BILL, "in", bills);
        qFilter.and(new QFilter(MESSAGE_TYPE, "=", this.getModel().getValue(MESSAGE_TYPE)));
        ArrayList<DynamicObject> dynamicObjectListold = new ArrayList<DynamicObject>(bills.size());
        ArrayList<DynamicObject> dynamicObjectListnew = new ArrayList<DynamicObject>(bills.size());
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bgc_controlmessage", (String)"bill,messagetype,messagetitle,messagecontent", (QFilter[])qFilter.toArray());
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (dynamicObject.getDynamicObject(BILL) == null) continue;
            bills.removeIf(e -> e.equals(dynamicObject.getDynamicObject(BILL).getLong("id")));
            this.setControlMessageField(dynamicObject);
            dynamicObjectListold.add(dynamicObject);
        }
        for (Long bill : bills) {
            DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bgc_controlmessage");
            newDynamicObject.set("id", (Object)DBServiceHelper.genGlobalLongId());
            newDynamicObject.set(BILL, (Object)bill);
            this.setControlMessageField(newDynamicObject);
            dynamicObjectListnew.add(newDynamicObject);
        }
        if (!dynamicObjectListold.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])dynamicObjectListold.toArray(new DynamicObject[0]));
        }
        if (!dynamicObjectListnew.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])dynamicObjectListnew.toArray(new DynamicObject[0]));
        }
        this.getPageCache().put(CACHE_MESSAGE_TITLE, JSONUtils.toString((Object)this.getModel().getValue(MESSAGE_TITLE)));
        this.getPageCache().put(CACHE_MESSAGE_CONTENT, JSONUtils.toString((Object)messageContent));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ControlMessageSetPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return true;
    }

    private void setControlMessageField(DynamicObject newDynamicObject) {
        newDynamicObject.set(MESSAGE_TYPE, this.getModel().getValue(MESSAGE_TYPE));
        newDynamicObject.set(MESSAGE_TITLE, this.getModel().getValue(MESSAGE_TITLE));
        newDynamicObject.set(MESSAGE_CONTENT, this.getModel().getValue(MESSAGE_CONTENT_TEXT));
    }
}

