/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.utils.CommonShowDetail;
import kd.epm.eb.common.utils.CommonShowDetailEntry;
import kd.epm.eb.common.utils.ControlLog;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.eums.ControlLogTypeEnum;
import kd.epm.eb.formplugin.control.bgavailablebalance.obj.FlexPanelBuilder;
import kd.epm.eb.formplugin.control.bgavailablebalance.obj.PanelUtils;

public class ControlOperLogDetailNewPlugin
extends AbstractBasePlugIn {
    private static final Log log = LogFactory.getLog(ControlOperLogDetailNewPlugin.class);
    private static final double HEIGH = 30.0;
    private static final String BORDER = "1px solid #B0C4D6";
    private static final String ALIGN_CENTER = "center";
    private static final String ALIGN_TEXT_LEFT = "flex-start";
    private static final String ALIGN_PANEL_LEFT = "flex-start";
    private int WIDTH_TOTAL = 1000;
    private int WIDTH_MENUTYPE = 120;
    private int WIDTH_CONTENTTYPE = 150;
    private int WIDTH_LOGTYPESHOW = 200;
    private int WIDTH_PICRESULT = 70;
    private int WIDTH_TIPS = 0;
    private int WIDTH_CONTENT = this.WIDTH_TOTAL - this.WIDTH_MENUTYPE - this.WIDTH_CONTENTTYPE - this.WIDTH_LOGTYPESHOW - this.WIDTH_PICRESULT - this.WIDTH_TIPS;
    private static final String COL_MENUTYPE = "MENUTYPE";
    private static final String COL_CONTENTTYPE = "CONTENTTYPE";
    private static final String COL_LOGTYPESHOW = "LOGTYPESHOW";
    private static final String COL_PICRESULT = "PICRESULT";
    private static final String COL_TIPS = "TIPS";
    private static final String COL_CONTENT = "CONTENT";

    private int getWidth(String colKey) {
        switch (colKey) {
            case "MENUTYPE": {
                return this.WIDTH_MENUTYPE;
            }
            case "CONTENTTYPE": {
                return this.WIDTH_CONTENTTYPE;
            }
            case "LOGTYPESHOW": {
                return this.WIDTH_LOGTYPESHOW;
            }
            case "PICRESULT": {
                return this.WIDTH_PICRESULT;
            }
            case "TIPS": {
                return this.WIDTH_TIPS;
            }
            case "CONTENT": {
                return this.WIDTH_CONTENT;
            }
        }
        return 0;
    }

    public void initialize() {
        super.initialize();
        Container netherEntryGrid = (Container)this.getView().getControl("flexpanelap");
        netherEntryGrid.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        List<ControlLog> logs = this.getLogs(null);
        LinkedHashMap<String, List<ControlLog>> logMap = this.buildLinkedMap(logs);
        this.storeLogMapToCache(logMap);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        List<ControlLog> logs = this.getLogs(e);
        this.fillValue(e, this.getModel(), logs);
    }

    private void storeLogMapToCache(LinkedHashMap<String, List<ControlLog>> logMap) {
        String cacheString = SerializationUtils.serializeToBase64(logMap);
        if (cacheString.length() < 10000000) {
            this.getPageCache().put("logMap", SerializationUtils.serializeToBase64(logMap));
        }
    }

    private LinkedHashMap<String, List<ControlLog>> getLogMapFromCache() {
        String logstring = this.getPageCache().get("logMap");
        if (StringUtils.isNotEmpty((String)logstring)) {
            return (LinkedHashMap)SerializationUtils.deSerializeFromBase64((String)logstring);
        }
        List<ControlLog> logs = this.getLogs(null);
        LinkedHashMap<String, List<ControlLog>> logMap = this.buildLinkedMap(logs);
        return logMap;
    }

    private LinkedHashMap<String, List<ControlLog>> buildLinkedMap(List<ControlLog> logs) {
        LinkedHashMap<String, List<ControlLog>> logMap = new LinkedHashMap<String, List<ControlLog>>(20);
        if (logs != null) {
            Object type = null;
            for (ControlLog controllog : logs) {
                logMap.computeIfAbsent(controllog.getType(), f -> new ArrayList(2)).add(controllog);
            }
        }
        return logMap;
    }

    private void fillValue(LoadCustomControlMetasArgs e, IDataModel dataModel, List<ControlLog> logs) {
        if (logs == null || logs.isEmpty()) {
            return;
        }
        FlexPanelAp gridflex = FlexPanelBuilder.buildMainAp("flexpanelap", "column", "flex-start", "stretch").addItems((ControlAp<?>)this.drawTitle()).addItems((ControlAp<?>)this.drawGrid(logs)).setName(PanelUtils.getCaptionCalData()).get();
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", "flexpanelap");
        mapHead.put("items", (String)gridflex.createControl().get("items"));
        e.getItems().add(mapHead);
    }

    private FlexPanelAp drawGrid(List<ControlLog> logs) {
        int size = this.calcSize(logs);
        String height = 30.0 * (double)(size + 1) + "px";
        FlexPanelBuilder builder = FlexPanelBuilder.build("flex-start", true, null, height).setOverflow("auto");
        this.drawGgrid(builder, logs);
        return builder.get();
    }

    private int calcSize(List<ControlLog> logs) {
        if (logs == null || logs.isEmpty()) {
            return 0;
        }
        int size = 0;
        for (ControlLog log : logs) {
            size += log.getLineCount();
        }
        return size;
    }

    private FlexPanelAp drawTitle() {
        FlexPanelBuilder headAp = FlexPanelBuilder.build(ALIGN_CENTER, false, "990px", "100%").addBorder(BORDER).setBackColor("#F2F2F2").setKey("maintitle");
        this.addTitle(headAp, ResManager.loadKDString((String)"\u63a7\u5236\u83dc\u5355", (String)"ControlLog_MenuType", (String)"epm-eb-business", (Object[])new Object[0]), COL_MENUTYPE);
        this.addTitle(headAp, ResManager.loadKDString((String)"\u63a7\u5236\u8bbe\u7f6e\u5185\u5bb9", (String)"ControlLog_ContentType", (String)"epm-eb-business", (Object[])new Object[0]), COL_CONTENTTYPE);
        this.addTitle(headAp, ResManager.loadKDString((String)"\u63a7\u5236\u5173\u952e\u914d\u7f6e\u9879", (String)"ControlLog_LogTypeShow", (String)"epm-eb-business", (Object[])new Object[0]), COL_LOGTYPESHOW);
        this.addTitle(headAp, ResManager.loadKDString((String)"\u68c0\u67e5\u7ed3\u679c", (String)"ControlLog_PicResult", (String)"epm-eb-business", (Object[])new Object[0]), COL_PICRESULT);
        this.addTitle(headAp, ResManager.loadKDString((String)"\u63d0\u793a\u4fe1\u606f", (String)"ControlLog_Tips", (String)"epm-eb-business", (Object[])new Object[0]), COL_TIPS);
        this.addTitle(headAp, ResManager.loadKDString((String)"\u63a7\u5236\u8be6\u7ec6\u4fe1\u606f\uff08\u70b9\u51fb\u67e5\u770b\u8be6\u7ec6\uff09", (String)"ControlLog_Content", (String)"epm-eb-business", (Object[])new Object[0]), COL_CONTENT);
        return headAp.get();
    }

    private void addTitle(FlexPanelBuilder headAp, String title, String colKey) {
        FlexPanelAp leftFlex = FlexPanelBuilder.build().addCell(title, this.getWidth(colKey) * 100 / this.WIDTH_TOTAL + "%", "30.0px").setJustifyContent("flex-start").addPadding(null, null, null, "5px").get();
        if (this.getWidth(colKey) == 0) {
            leftFlex.setHidden(true);
        }
        headAp.addItems((ControlAp<?>)leftFlex);
    }

    private void drawGgrid(FlexPanelBuilder builder, List<ControlLog> logs) {
        this.getGridPanel(builder, logs);
        if (logs == null || logs.isEmpty() || logs.size() == 1) {
            builder.setHeight("30.0px");
        }
    }

    private void getGridPanel(FlexPanelBuilder builder, List<ControlLog> logs) {
        if (logs != null && !logs.isEmpty()) {
            LinkedHashMap<String, Map> logMap = new LinkedHashMap<String, Map>(10);
            HashMap<String, Integer> typeCount = new HashMap<String, Integer>(10);
            for (ControlLog controllog : logs) {
                ControlLogTypeEnum type = ControlLogTypeEnum.valueOfNumber((String)controllog.getType());
                if (type == null) {
                    log.info("fillValue-type-error:" + controllog.getType());
                    continue;
                }
                ControlLogTypeEnum type2 = ControlLogTypeEnum.valueOfNumber((String)type.getParentnumber());
                if (type2 == null) {
                    log.info("fillValue-type-error:" + type.getParentnumber());
                    continue;
                }
                ControlLogTypeEnum type1 = ControlLogTypeEnum.valueOfNumber((String)type2.getParentnumber());
                if (type1 == null) {
                    log.info("fillValue-type-error:" + type2.getParentnumber());
                    continue;
                }
                logMap.computeIfAbsent(type1.getNumber(), f -> new LinkedHashMap()).computeIfAbsent(type2.getNumber(), f -> new ArrayList(10)).add(controllog);
                if (controllog.getLineCount() == 0) {
                    controllog.setLineCount(1);
                }
                if (typeCount.containsKey(type1.getNumber())) {
                    typeCount.put(type1.getNumber(), (Integer)typeCount.get(type1.getNumber()) + controllog.getLineCount());
                    continue;
                }
                typeCount.put(type1.getNumber(), controllog.getLineCount());
            }
            FlexPanelBuilder menuLeft = null;
            FlexPanelBuilder menuRight = null;
            FlexPanelBuilder contenttypeLeft = null;
            FlexPanelBuilder contenttypeRight = null;
            FlexPanelBuilder row = null;
            int totalwidth1 = this.WIDTH_TOTAL;
            for (Map.Entry entrymenu : logMap.entrySet()) {
                String height1 = 30.0 * (double)((Integer)typeCount.get(entrymenu.getKey())).intValue() + "px";
                FlexPanelBuilder contentBuilder = FlexPanelBuilder.build("flex-start", true, "990px", height1).setOverflow("hide");
                int width1 = this.getWidth(COL_MENUTYPE) * 100 / totalwidth1;
                ControlLogTypeEnum root = ControlLogTypeEnum.valueOfNumber((String)((String)entrymenu.getKey()));
                menuLeft = ControlLogTypeEnum.P_CONTROLRESULT == root ? FlexPanelBuilder.build().addHyperLink(root.getAlias(), null, (String)entrymenu.getKey(), width1 + "%", height1, null, null, BORDER, BORDER).setJustifyContent("flex-start").addPadding(null, null, null, "5px") : FlexPanelBuilder.build().addCell(root.getAlias(), width1 + "%", height1, null, null, BORDER, BORDER).setJustifyContent("flex-start").addPadding(null, null, null, "5px");
                menuRight = FlexPanelBuilder.build("flex-start", true, 100 - width1 + "%", height1).setOverflow("hide");
                for (Map.Entry entrycontenttype : ((Map)entrymenu.getValue()).entrySet()) {
                    int totalwidth2 = totalwidth1 * (100 - width1) / 100;
                    int width2 = this.getWidth(COL_CONTENTTYPE) * 100 / totalwidth2;
                    String height2 = 30.0 * (double)this.calcSize((List)entrycontenttype.getValue()) + "px";
                    contenttypeLeft = FlexPanelBuilder.build().addCell(ControlLogTypeEnum.valueOfNumber((String)((String)entrycontenttype.getKey())).getAlias(), width2 + "%", height2, null, BORDER, BORDER, BORDER).setJustifyContent("flex-start").addPadding(null, null, null, "5px");
                    contenttypeRight = FlexPanelBuilder.build(ALIGN_CENTER, true, 100 - width2 + "%", height2).setOverflow("hide");
                    int totalWidth3 = totalwidth2 * (100 - width2) / 100;
                    for (ControlLog controllog : (List)entrycontenttype.getValue()) {
                        String h = 30.0 * (double)controllog.getLineCount() + "px";
                        row = FlexPanelBuilder.build(ALIGN_CENTER, true, "100%", h).setOverflow("hide");
                        String message = controllog.getShowMessage() + (this.getWidth(COL_TIPS) == 0 && StringUtils.isNotEmpty((String)controllog.getTips()) ? "(" + controllog.getTips() + ")" : "");
                        StringBuilder showmsg = new StringBuilder();
                        int count = 0;
                        for (String string : message.split("\r\n")) {
                            block18: {
                                if (count >= controllog.getLineCount()) {
                                    showmsg.append("...");
                                    break;
                                }
                                if (showmsg.length() > 0) {
                                    showmsg.append("\r\n");
                                }
                                try {
                                    int maxcharcount = 60;
                                    int charcount = 0;
                                    int charindex = 0;
                                    for (int c = 0; c < string.length(); ++c) {
                                        if (charcount > maxcharcount) {
                                            charindex = c;
                                            break;
                                        }
                                        charcount += String.valueOf(string.charAt(c)).getBytes("GBK").length;
                                    }
                                    if (charindex > 0) {
                                        string = string.substring(0, charindex) + "...";
                                    }
                                }
                                catch (Throwable e) {
                                    if (string.length() <= 30) break block18;
                                    string = string.substring(0, 30) + "...";
                                }
                            }
                            showmsg.append(string);
                            ++count;
                        }
                        ControlLogTypeEnum type = ControlLogTypeEnum.valueOfNumber((String)controllog.getType());
                        String bottomBorder = BORDER;
                        row.addItems((ControlAp<?>)FlexPanelBuilder.build().addCell(type.getAlias(), this.getWidth(COL_LOGTYPESHOW) * 100 / totalWidth3 + "%", h, null, BORDER, bottomBorder, null).setJustifyContent("flex-start").addPadding(null, null, null, "5px").get()).addItems((ControlAp<?>)FlexPanelBuilder.addImage(controllog.getResultImageKey(), this.getWidth(COL_PICRESULT) * 100 / totalWidth3 + "%", h, null, BORDER, bottomBorder, null).setJustifyContent(ALIGN_CENTER).get()).addItems((ControlAp<?>)FlexPanelBuilder.build().addCell(controllog.getTips(), this.getWidth(COL_TIPS) * 100 / totalWidth3 + "%", h, null, BORDER, bottomBorder, null).setJustifyContent("flex-start").addPadding(null, null, null, "5px").setHiden(this.getWidth(COL_TIPS) == 0).get()).addItems((ControlAp<?>)FlexPanelBuilder.build().addHyperLink(showmsg.toString(), message, controllog.getType(), this.getWidth(COL_CONTENT) * 100 / totalWidth3 + "%", h, null, BORDER, bottomBorder, null).setKey(controllog.getType()).setJustifyContent("flex-start").addPadding(null, null, null, "5px").setOverflow("hide").get());
                        contenttypeRight.addItems((ControlAp<?>)row.get());
                    }
                    menuRight.addItems((ControlAp<?>)contenttypeLeft.get());
                    menuRight.addItems((ControlAp<?>)contenttypeRight.get());
                }
                contentBuilder.addItems((ControlAp<?>)menuLeft.get());
                contentBuilder.addItems((ControlAp<?>)menuRight.get());
                builder.addItems((ControlAp<?>)contentBuilder.get());
            }
        }
    }

    protected List<ControlLog> getLogs(LoadCustomControlMetasArgs e) {
        Long globalId = 0L;
        Object obj = null;
        if (e != null && e.getSource() instanceof FormShowParameter) {
            obj = ((FormShowParameter)e.getSource()).getCustomParam("id");
        } else if (this.getView() != null) {
            obj = this.getView().getFormShowParameter().getCustomParam("id");
        }
        if (obj != null) {
            globalId = IDUtils.toLong(obj);
        }
        if (IDUtils.isNull((Long)globalId)) {
            return new ArrayList<ControlLog>(1);
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select flogs from t_eb_bgcontrollogdetail where fid = ?", new Object[]{globalId});
        try (DataSet ds = DB.queryDataSet((String)"queryDetailLogs", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            String logJson;
            byte[] logs;
            if (ds.hasNext() && (logs = (byte[])ds.next().get("flogs")) != null && logs.length > 0 && !StringUtils.isEmpty((String)(logJson = ObjectSerialUtil.uncompress((byte[])logs)))) {
                log.info("detail-logs:" + logJson);
                CollectionType logType = JSONUtils.getMapper().getTypeFactory().constructCollectionType(List.class, ControlLog.class);
                List list = (List)JSONUtils.parse((String)logJson, (JavaType)logType);
                return list;
            }
        }
        return new ArrayList<ControlLog>(1);
    }

    public void onGetControl(OnGetControlArgs e) {
        ControlLogTypeEnum type = ControlLogTypeEnum.valueOfNumberIgnoreCase((String)e.getKey());
        if (type != null) {
            Label label = new Label();
            label.setKey(e.getKey());
            label.setView(this.getView());
            label.addClickListener((ClickListener)this);
            e.setControl((Control)label);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Label) {
            boolean isShowDetail = true;
            ControlLogTypeEnum type = ControlLogTypeEnum.valueOfNumberIgnoreCase((String)((Label)evt.getSource()).getKey());
            if (type == null) {
                return;
            }
            if (type == ControlLogTypeEnum.CONTROLRESULT) {
                isShowDetail = false;
            } else if (type == ControlLogTypeEnum.P_CONTROLRESULT) {
                type = ControlLogTypeEnum.CONTROLRESULT;
            }
            LinkedHashMap<String, List<ControlLog>> logMap = this.getLogMapFromCache();
            if (!logMap.containsKey(type.getNumber())) {
                log.info("no-found-log = " + type.getNumber());
                return;
            }
            List<ControlLog> logs = logMap.get(type.getNumber());
            if (logs.isEmpty()) {
                log.info("empty-log = " + type.getNumber());
                return;
            }
            ControlLog log = logs.get(0);
            if (isShowDetail && log.getDetailMap() != null && log.getDetailMap().size() > 1) {
                String title = ResManager.loadKDString((String)"\u63a7\u5236\u8be6\u7ec6\u4fe1\u606f", (String)"ControlOperLogDetailNewPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                HashMap<String, String> params = new HashMap<String, String>(16);
                params.put("detaildata", CommonShowDetail.compressDetail((Object)log.getDetailMap()));
                params.put("detailtitle", title);
                params.put("detailtypetitle", log.getDetailMapTitle());
                params.put("detailcompress", "detailcompress");
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("eb_bgcommonshowlist");
                parameter.setCustomParams(params);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(parameter);
            } else {
                Serializable detail = log.getDetail();
                if (detail == null && log.getDetailMap() != null && log.getDetailMap().size() == 1) {
                    detail = (Serializable)log.getDetailMap().values().iterator().next();
                }
                if (detail == null && log.isFindParent()) {
                    for (ControlLogTypeEnum type1 : ControlLogTypeEnum.values()) {
                        if (type1 == type || type1.getParentnumber() == null || !type1.getParentnumber().equals(type.getParentnumber()) || logMap.get(type1.getNumber()) == null || logMap.get(type1.getNumber()).isEmpty() || logMap.get(type1.getNumber()).get(0).getDetail() == null) continue;
                        detail = logMap.get(type1.getNumber()).get(0).getDetail();
                        break;
                    }
                }
                if (isShowDetail && detail instanceof CommonShowDetail) {
                    String title = ResManager.loadKDString((String)"\u63a7\u5236\u8be6\u7ec6\u4fe1\u606f", (String)"ControlOperLogDetailNewPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    HashMap<String, String> params = new HashMap<String, String>(16);
                    if (ControlLogTypeEnum.CONTROLRESULT == type) {
                        CommonShowDetail _detail = (CommonShowDetail)detail;
                        for (CommonShowDetailEntry entry : _detail.getEntryMap().values()) {
                            for (CommonShowDetailEntry.Column col : entry.getColumns()) {
                                col.setMaxShowLength(300);
                            }
                        }
                    }
                    params.put("detaildata", CommonShowDetail.compressDetail((Object)detail));
                    params.put("detailtitle", title);
                    params.put("detailcompress", "detailcompress");
                    FormShowParameter parameter = new FormShowParameter();
                    parameter.setFormId("eb_bgcommonshowlist");
                    parameter.setCustomParams(params);
                    parameter.getOpenStyle().setShowType(ShowType.Modal);
                    this.getView().showForm(parameter);
                } else {
                    String msg;
                    String string = msg = isShowDetail ? StringUtils.toNoEmptyString((Object)detail) : log.getShowMessage();
                    if (StringUtils.isEmpty((String)msg)) {
                        msg = log.getShowMessage();
                    }
                    HashMap<String, String> params = new HashMap<String, String>(16);
                    params.put("detailmessage", msg);
                    FormShowParameter parameter = new FormShowParameter();
                    parameter.setFormId("eb_bgcontrollogdetail");
                    parameter.setCustomParams(params);
                    parameter.getOpenStyle().setShowType(ShowType.Modal);
                    this.getView().showForm(parameter);
                }
            }
        }
    }
}

