/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.enums.BgBillTreeTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.shrek.controller.IShrekSave;
import kd.epm.eb.common.shrek.controller.ShrekOlapReader;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CalendarHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.CommonShowDetail;
import kd.epm.eb.common.utils.CommonShowDetailEntry;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.control.BgControlCallerImpl;
import kd.epm.eb.control.eums.ControlLogTypeEnum;
import kd.epm.eb.control.impl.model.AbstractBgControlRecord;
import kd.epm.eb.control.impl.model.BgControlRecord;
import kd.epm.eb.control.utils.BgControlLogUtils;
import kd.epm.eb.control.utils.BgControlRecordUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.dataanalyse.BgDataAnalysePlugin;
import kd.epm.eb.olap.impl.metadata.KDCell;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.jetbrains.annotations.NotNull;

public class ControlOperLogPlugin
extends AbstractListPlugin
implements SearchEnterListener,
ListRowClickListener,
SetFilterListener,
BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(ControlOperLogPlugin.class);
    private static final String COMBO_SYSTEM = "comsystem";
    private static final String COMBO_BILL = "combill";
    private static final String TABLE_LOG_LIST = "controllogs";
    private static final String BTN_RETURN = "btnreturn";
    private static final String BTN_OCCUPATION = "btnoccupation";
    private static final String BTN_EXECUTE = "btnexecute";
    private static final String BTN_CLOSE = "btnclose";
    private static final String BTN_CHECK_ACTUAL = "btncheckactual";
    private static final String BTN_UPDATE_ACTUAL = "btnupdateactual";
    private static final String BTN_CHECK_EXECUTE = "btncheckexecute";
    private static final String BTN_CLOSE_EXECUTE = "btncloseexecute";
    private static final String CLOSE = "close";
    private static final String CLOSE_EXECUTE = "closeexecute";
    private static final String FAIL_BILL = "failBill";
    private static final String CACHE_FAIL_BILL = "failBillCache";
    private static final String CACHE_FAIL_OPERA = "failOperaCache";
    private static final String sql = "insert into t_eb_bgcontroloperlog (fid, fentitynumber, fbillid, fbillnumber, fcreatedate, foperation) values (?,?,?,?,?,?)";
    private Map<Long, IModelCacheHelper> modelCacheMap = new HashMap<Long, IModelCacheHelper>();

    public void initialize() {
        super.initialize();
        Search search = (Search)this.getControl("searchap");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
        this.addClickListeners(new String[]{BTN_RETURN, BTN_OCCUPATION, BTN_EXECUTE, BTN_CLOSE, BTN_CHECK_ACTUAL, BTN_UPDATE_ACTUAL, "releaseentry", BTN_CHECK_EXECUTE, BTN_CLOSE_EXECUTE});
        this.addClickListeners(new String[]{"members"});
        BillList list = (BillList)this.getControl(TABLE_LOG_LIST);
        if (list != null) {
            list.addListRowDoubleClickListener((ListRowClickListener)this);
            list.addSetFilterListener((SetFilterListener)this);
            list.addPackageDataListener(this::packageData);
            list.addHyperClickListener((HyperLinkClickListener)this);
        }
        BasedataEdit model = (BasedataEdit)this.getControl("model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizModel = (BasedataEdit)this.getControl("busmodel");
        bizModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void packageData(PackageDataEvent event) {
        if (!event.getRowData().getBoolean("haslogs")) {
            event.getNoLinkKey().add("billnumber");
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadSystem();
        this.loadBill(null);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnreturn": {
                this.returnBudget();
                break;
            }
            case "btnoccupation": {
                this.requestBudget("submit");
                break;
            }
            case "btnexecute": {
                this.requestBudget("audit");
                break;
            }
            case "btnclose": {
                this.closeBudget();
                break;
            }
            case "btncheckactual": {
                this.click_checkActual(evt);
                break;
            }
            case "btnupdateactual": {
                this.click_updateActual(evt);
                break;
            }
            case "members": {
                BgDataAnalysePlugin.selectMembers(this.getView(), this.getModel(), (IFormPlugin)this, this.getBizModelId(), this.getBusModelId(), null);
                break;
            }
            case "releaseentry": {
                this.releaseEntry();
                break;
            }
            case "btncheckexecute": {
                this.refreshOccList();
                break;
            }
            case "btncloseexecute": {
                this.closeBudgetByExecute();
                break;
            }
        }
    }

    private void closeBudgetByExecute() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selRows = entryGrid.getSelectRows();
        if (selRows == null || selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u6267\u884c\u7684\u5355\u636e\u3002", (String)"ControlOperLogPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(selRows.length);
        DynamicObject row = null;
        int in = selRows.length;
        for (int i = 0; i < in; ++i) {
            row = this.getModel().getEntryRowEntity("entryentity", selRows[i]);
            if (row == null) continue;
            dynamicObjects.add(row);
        }
        HashMap<String, List> entityNumberDynaMap = new HashMap<String, List>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            List dynamicObjectList = entityNumberDynaMap.computeIfAbsent(dynamicObject.getString("entitynumberocc"), f -> new ArrayList(16));
            dynamicObjectList.add(dynamicObject);
        }
        for (Map.Entry entry : entityNumberDynaMap.entrySet()) {
            List<String> billNos;
            String entityNumber = (String)entry.getKey();
            List<Map<String, Object>> bizBills = this.getBizBills(entityNumber, billNos = ((List)entry.getValue()).stream().map(e -> e.getString("biznumberocc")).collect(Collectors.toList()));
            if (bizBills != null && !bizBills.isEmpty()) {
                Date date = new Date();
                ArrayList<String> successBizNumbers = new ArrayList<String>(bizBills.size());
                ArrayList<String> failBizNumbers = new ArrayList<String>(bizBills.size());
                BgControlCallerImpl caller = new BgControlCallerImpl();
                try {
                    for (Map<String, Object> bizBill : bizBills) {
                        String bizId = bizBill.get("id").toString();
                        String bizNumber = (String)bizBill.get("billno");
                        if (bizNumber == null) {
                            bizNumber = (String)bizBill.get("number");
                        }
                        if (StringUtils.isNotEmpty((String)entityNumber) && StringUtils.isNotEmpty((String)bizId) && StringUtils.isNotEmpty((String)bizNumber)) {
                            try {
                                caller.closeBudget(entityNumber, bizId, "closebill");
                                Object[] sqlParams = new Object[]{DBServiceHelper.genGlobalLongId(), entityNumber, bizId, bizNumber, date, "userClose"};
                                this.dbExecute(BgBaseConstant.epm, sql, sqlParams);
                                successBizNumbers.add(bizNumber);
                            }
                            catch (Exception ex) {
                                if (ex instanceof KDBizException && ex.getMessage() != null) {
                                    failBizNumbers.add(ResManager.loadResFormat((String)"%1\u5173\u95ed\u9884\u7b97\u5931\u8d25\uff0c\u201c%2\u201d\u3002", (String)"ControlOperLogPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[]{bizNumber, ex.getMessage()}));
                                    continue;
                                }
                                failBizNumbers.add(bizNumber);
                            }
                            continue;
                        }
                        this.showNotOperationBillTip();
                    }
                    String opera = ResManager.loadKDString((String)"\u5173\u95ed\u64cd\u4f5c", (String)"ControlOperLogPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    this.dealBillOperaResult(successBizNumbers, failBizNumbers, opera);
                }
                catch (Throwable ex) {
                    this.getView().showErrorNotification(ex.getMessage());
                }
                continue;
            }
            this.showNotOperationBillTip();
        }
    }

    private void refreshOccList() {
        this.getModel().deleteEntryData("entryentity");
        List<BgControlRecord> occupationRecordList = this.getOccupationRecordList();
        if (CollectionUtils.isEmpty(occupationRecordList)) {
            return;
        }
        Map<String, BgControlRecord> occupationRecordMap = occupationRecordList.stream().collect(Collectors.toMap(AbstractBgControlRecord::getBizId, v -> v, (o1, o2) -> o2));
        List resultRecords = occupationRecordMap.values().stream().collect(Collectors.toList());
        IDataModel model = this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", resultRecords.size());
        int in = resultRecords.size();
        for (int i = 0; i < in; ++i) {
            BgControlRecord record = (BgControlRecord)resultRecords.get(i);
            DynamicObject entity = model.getEntryRowEntity("entryentity", i);
            entity.set("createtimeocc", (Object)record.getCreateTime());
            entity.set("billidocc", (Object)record.getBizId());
            entity.set("entitynumberocc", (Object)record.getEntityNumber());
            entity.set("biznumberocc", (Object)record.getBizNumber());
            entity.set("occupationoper", (Object)record.getOperation());
            entity.set("remianoccupation", (Object)record.getAmount());
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.setPageIndex(1);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private List<BgControlRecord> getOccupationRecordList() {
        Object billId;
        HashMap<String, Set> bizIdTableMap = new HashMap<String, Set>(16);
        HashSet<String> ebBillIdSet = new HashSet<String>(16);
        String sqlPart2 = "select fbizid from t_eb_bgcontrolrecord";
        try (DataSet ds = DB.queryDataSet((String)"queryBgControlRecord", (DBRoute)DBRoute.of((String)"epm"), (String)sqlPart2);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                billId = row.getString("fbizid");
                ebBillIdSet.add((String)billId);
            }
        }
        bizIdTableMap.put("t_eb_bgcontrolrecord", ebBillIdSet);
        String sqlPart = "select fbizid,ftable from t_eb_bgcontrolindex";
        DataSet ds = DB.queryDataSet((String)"queryBgControlIndex", (DBRoute)DBRoute.of((String)"epm"), (String)sqlPart);
        billId = null;
        try {
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                String billId2 = row.getString("fbizid");
                String table = row.getString("ftable");
                Set billIdSet = bizIdTableMap.computeIfAbsent(table, f -> new LinkedHashSet(16));
                billIdSet.add(billId2);
            }
        }
        catch (Throwable row) {
            billId = row;
            throw row;
        }
        finally {
            if (ds != null) {
                if (billId != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)billId).addSuppressed(row);
                    }
                } else {
                    ds.close();
                }
            }
        }
        ArrayList<BgControlRecord> occupationRecords = new ArrayList<BgControlRecord>(16);
        List records = new ArrayList(16);
        HashSet billIdSetValue = new HashSet(1000);
        for (Map.Entry billIdEntry : bizIdTableMap.entrySet()) {
            Set _billIdSetValue = (Set)billIdEntry.getValue();
            if (_billIdSetValue == null || _billIdSetValue.isEmpty()) continue;
            Iterator it = _billIdSetValue.iterator();
            while (it.hasNext()) {
                billIdSetValue.clear();
                while (billIdSetValue.size() < 1000 && it.hasNext()) {
                    billIdSetValue.add(it.next());
                }
                if (BgControlLogUtils.isNeedLog()) {
                    log.info("billIdSetValue = " + JSONUtils.toString(billIdSetValue));
                }
                try {
                    records = BgControlRecordUtils.query(billIdSetValue);
                }
                catch (Exception e) {
                    log.error("budget-control-log : checkExecute - error :", (Throwable)e);
                }
                if (records == null || records.isEmpty()) continue;
                HashMap<String, Collection> bgRecordMap = new HashMap<String, Collection>(16);
                for (BgControlRecord bgControlRecord : records) {
                    Collection bgRecords = bgRecordMap.computeIfAbsent(bgControlRecord.getBizId(), f -> new ArrayList());
                    bgRecords.add(bgControlRecord);
                }
                for (Map.Entry entry : bgRecordMap.entrySet()) {
                    Collection values = (Collection)entry.getValue();
                    values.removeIf(record -> StringUtils.isNotEmpty((String)record.getRefBizId()) && !record.getBizId().equals(record.getRefBizId()));
                    boolean hasExecute = false;
                    for (BgControlRecord record3 : values) {
                        if (!"Execute".equals(record3.getMemberNumber(SysDimensionEnum.ChangeType.getNumber()))) continue;
                        hasExecute = true;
                        break;
                    }
                    if (!hasExecute) continue;
                    HashMap<String, BigDecimal> occSumValueMap = new HashMap<String, BigDecimal>(16);
                    BigDecimal sumValue = null;
                    BigDecimal occValue = BigDecimal.ZERO;
                    BgControlRecord occupationRecord = new BgControlRecord();
                    for (BgControlRecord record4 : values) {
                        if ("Occupation".equals(record4.getMemberNumber(SysDimensionEnum.ChangeType.getNumber()))) {
                            String periodNumber = record4.getBizModel().isEBByModel() ? record4.getMemberNumber(SysDimensionEnum.Period.getNumber()) : record4.getMemberNumber(SysDimensionEnum.BudgetPeriod.getNumber());
                            if (record4.getOccPeriod() != null) {
                                periodNumber = record4.getOccPeriodNumber();
                            }
                            String memberKey = record4.getMemberKey(true) + periodNumber;
                            sumValue = occSumValueMap.computeIfAbsent(memberKey, f -> BigDecimal.ZERO);
                            sumValue = sumValue.add(record4.getAmount());
                            occSumValueMap.put(memberKey, sumValue);
                        }
                        if (!"Occupation".equals(record4.getMemberNumber(SysDimensionEnum.ChangeType.getNumber())) || record4.getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                        occupationRecord = record4;
                    }
                    boolean hasRemainOcc = false;
                    for (Map.Entry decimalEntry : occSumValueMap.entrySet()) {
                        BigDecimal occSumValue = (BigDecimal)decimalEntry.getValue();
                        if (occSumValue.compareTo(BigDecimal.ZERO) <= 0) continue;
                        hasRemainOcc = true;
                        occValue = occSumValue;
                        break;
                    }
                    if (!hasRemainOcc) continue;
                    occupationRecord.setAmount(occValue);
                    occupationRecords.add(occupationRecord);
                }
            }
        }
        return occupationRecords;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "comsystem": 
            case "combill": 
            case "daterange_enddate": {
                this.refreshList();
                break;
            }
            case "model": {
                this.propertyChanged_model(e);
                break;
            }
            case "busmodel": {
                this.propertyChanged_busModel(e);
                break;
            }
            case "members": {
                this.propertyChanged_members(e);
            }
        }
    }

    protected void propertyChanged_model(PropertyChangedArgs e) {
        ChangeData[] data = e.getChangeSet();
        if (data != null) {
            this.getModel().setValue("busmodel", null);
            this.getModel().deleteEntryData("dimensions");
            BgDataAnalysePlugin.cacheDimension1(this.getPageCache(), null);
            DynamicObject model = (DynamicObject)data[0].getNewValue();
            if (model != null) {
                if (BizModel.isEBByModel((DynamicObject)model)) {
                    this.loadDimension(model, null);
                } else {
                    this.getModel().setValue("busmodel", (Object)BusinessDataServiceHelper.loadSingleFromCache((String)"eb_businessmodel", (String)"id, name, number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)model.getLong("id"))}));
                }
            }
        }
    }

    protected void propertyChanged_busModel(PropertyChangedArgs e) {
        DynamicObject model = this.getBizModelObj();
        if (BizModel.isEBByModel((DynamicObject)model)) {
            this.loadDimension(model, null);
        } else if (this.getModel().getValue("busmodel") != null) {
            this.loadDimension(model, this.getBusModelObj());
        }
    }

    protected void loadDimension(DynamicObject model, DynamicObject busModel) {
        List refDims;
        if (model == null) {
            return;
        }
        IDataModel dataModel = this.getModel();
        dataModel.beginInit();
        dataModel.deleteEntryData("dimensions");
        List dimensions = this.getModelCacheHelper(model.getLong("id")).getDimensionList();
        List<Object> list = refDims = busModel != null ? BusinessModelServiceHelper.getRefDim((Long)busModel.getLong("id"), (List)dimensions) : dimensions;
        if (refDims != null) {
            if (!BizModel.isEBByModel((DynamicObject)model) && busModel != null) {
                Set ctrlDims = BgControlUtils.getControlDimension((DynamicObject)BgControlUtils.queryControlDimension((Long)model.getLong("id"), (Long)busModel.getLong("id")));
                if (ctrlDims == null || ctrlDims.isEmpty()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u672a\u914d\u7f6e\u63a7\u5236\u7ef4\u5ea6\u3002", (String)"ControlOperLogPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    dataModel.endInit();
                    this.getView().updateView("dimensions");
                    return;
                }
                refDims = refDims.stream().filter(dim -> ctrlDims.contains(dim.getId())).collect(Collectors.toList());
            }
            BgDataAnalysePlugin.cacheDimension1(this.getPageCache(), refDims);
            int[] rows = dataModel.batchCreateNewEntryRow("dimensions", refDims.size());
            int in = refDims.size();
            for (int i = 0; i < in; ++i) {
                Dimension dimension = (Dimension)refDims.get(i);
                dataModel.setValue("dimid", (Object)dimension.getId(), rows[i]);
                dataModel.setValue("dimname", (Object)dimension.getName(), rows[i]);
                dataModel.setValue("dimnumber", (Object)dimension.getNumber(), rows[i]);
            }
        }
        dataModel.endInit();
        this.getView().updateView("dimensions");
    }

    protected void propertyChanged_members(PropertyChangedArgs e) {
        ChangeData data;
        ChangeData[] datas = e.getChangeSet();
        if (datas != null && (data = datas[0]) != null && (data.getNewValue() == null || "".equals(data.getNewValue()))) {
            EntryGrid entry = (EntryGrid)this.getControl("dimensions");
            int rowIndex = entry.getEntryState().getFocusRow();
            this.getModel().setDataChanged(false);
            this.getModel().setValue("data", null, rowIndex);
            this.getModel().setValue("members", null, rowIndex);
            this.getModel().setDataChanged(true);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        switch (e.getActionId()) {
            case "selectmembers": {
                BgDataAnalysePlugin.updateMemberData(this.getView(), e.getReturnData());
                break;
            }
        }
    }

    public void search(SearchEnterEvent e) {
        this.getPageCache().put("SEARCH_CACHE_DATA", e.getText());
        this.refreshList();
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent e) {
        if (e == null || e.getRowIndex() < 0) {
            return;
        }
        BillList list = (BillList)this.getControl(TABLE_LOG_LIST);
        Long pk = IDUtils.toLong((Object)list.getFocusRowPkId());
        if (IDUtils.isNull((Long)pk) && list.getCurrentSelectedRowInfo() != null) {
            pk = IDUtils.toLong((Object)list.getCurrentSelectedRowInfo().getPrimaryKeyValue());
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid from t_eb_bgcontrollogdetail where fid = ?", new Object[]{pk});
        boolean hasLogs = false;
        try (DataSet ds = DB.queryDataSet((String)"queryHasLogs", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            hasLogs = ds != null && ds.hasNext();
        }
        if (hasLogs) {
            boolean downloadjson = false;
            if (this.getModel().getDataEntityType().getProperties().containsKey((Object)"downloadjson")) {
                downloadjson = Boolean.TRUE.equals(this.getModel().getValue("downloadjson"));
            }
            if (!downloadjson) {
                HashMap<String, Long> params = new HashMap<String, Long>(16);
                params.put("id", pk);
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("eb_bgcontrollogdetailnew");
                parameter.setCustomParams(params);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(parameter);
            } else {
                sql = new SqlBuilder();
                sql.append("select flogs from t_eb_bgcontrollogdetail where fid = ?", new Object[]{pk});
                try (DataSet ds = DB.queryDataSet((String)"queryDetailLogs", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                    String logJson;
                    byte[] logs;
                    if (ds.hasNext() && (logs = (byte[])ds.next().get("flogs")) != null && logs.length > 0 && !StringUtils.isEmpty((String)(logJson = ObjectSerialUtil.uncompress((byte[])logs)))) {
                        String fileUrl = this.createFileUrl(logJson, ControlLogTypeEnum.CONTROLRESULT.getAlias());
                        this.getClientViewProxy().addAction("download", (Object)fileUrl);
                    }
                }
            }
        }
    }

    public void listRowDoubleClick(ListRowClickEvent e) {
        ListSelectedRow selRow = e.getCurrentListSelectedRow();
        if (selRow != null) {
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("id", selRow.getPrimaryKeyValue());
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("eb_bgcontrollogdetail");
            parameter.setCustomParams(params);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(parameter);
        }
    }

    protected void loadSystem() {
        ComboEdit comSystem = (ComboEdit)this.getControl(COMBO_SYSTEM);
        if (comSystem != null) {
            comSystem.setComboItems(this.getSystemItems());
        }
    }

    protected List<ComboItem> getSystemItems() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        items.add(new ComboItem(new LocaleString(" "), " "));
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("billtype", "=", (Object)BgBillTreeTypeEnum.APPLICATION.getNumber()));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getBillItems", (String)"eb_structofbill", (String)"id, name", (QFilter[])builder.toArrays(), null);){
            if (ds != null) {
                while (ds.hasNext()) {
                    Row row = ds.next();
                    items.add(new ComboItem(new LocaleString(row.getString("name")), row.getString("id")));
                }
            }
        }
        return items;
    }

    protected void loadBill(String applicationId) {
        ComboEdit comBill = (ComboEdit)this.getControl(COMBO_BILL);
        if (comBill != null) {
            comBill.setComboItems(this.getBillItems(applicationId));
        }
    }

    protected List<ComboItem> getBillItems(String applicationId) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        items.add(new ComboItem(new LocaleString(" "), " "));
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("billtype", "=", (Object)BgBillTreeTypeEnum.BILL.getNumber()));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getBillItems", (String)"eb_structofbill", (String)"id, name, fieldtable", (QFilter[])builder.toArrays(), null);){
            if (ds != null) {
                while (ds.hasNext()) {
                    Row row = ds.next();
                    if (!StringUtils.isNotEmpty((String)row.getString("name")) || !StringUtils.isNotEmpty((String)row.getString("fieldtable"))) continue;
                    items.add(new ComboItem(new LocaleString(row.getString("name") + "(" + row.getString("fieldtable") + ")"), row.getString("fieldtable")));
                }
            }
        }
        return items;
    }

    protected void refreshList() {
        BillList list = (BillList)this.getControl(TABLE_LOG_LIST);
        if (list != null) {
            list.clearSelection();
            list.refresh();
        }
    }

    public void setFilter(SetFilterEvent e) {
        if (e.getSource() instanceof BillList) {
            e.getQFilters().addAll(this.getFilters());
            e.setOrderBy("createdate desc");
        }
    }

    protected List<QFilter> getFilters() {
        String searchTxt;
        String entityNumber;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        Date begin = null;
        Date end = null;
        DateRangeEdit dateRange = (DateRangeEdit)this.getControl("daterange");
        if (dateRange != null) {
            begin = (Date)this.getModel().getValue(dateRange.getStartDateFieldKey());
            end = (Date)this.getModel().getValue(dateRange.getEndDateFieldKey());
            CalendarHelper helper = new CalendarHelper();
            if (begin != null) {
                filters.add(new QFilter("createdate", ">=", (Object)helper.getStartDate(begin)));
            }
            if (end != null) {
                filters.add(new QFilter("createdate", "<=", (Object)helper.getBeoverDate(end)));
            }
        }
        if (StringUtils.isNotEmpty((String)(entityNumber = (String)this.getModel().getValue(COMBO_BILL)))) {
            filters.add(new QFilter("entityNumber", "=", (Object)entityNumber));
        }
        if (StringUtils.isNotEmpty((String)(searchTxt = this.getPageCache().get("SEARCH_CACHE_DATA")))) {
            String _search = searchTxt.trim();
            filters.add(new QFilter("billid", "like", (Object)(_search + "%")).or("billnumber", "like", (Object)(_search + "%")));
        }
        if (filters.isEmpty()) {
            filters.add(new QFilter("id", "=", (Object)0));
        } else {
            filters.add(new QFilter("isshow", "=", (Object)Character.valueOf('1')));
        }
        return filters;
    }

    protected void returnBudget() {
        String entityNumber = (String)this.getModel().getValue(COMBO_BILL);
        if (StringUtils.isEmpty((String)entityNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u63a7\u5236\u7684\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\u3002", (String)"ControlOperLogPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        LinkedHashSet bgControlRecordIds = Sets.newLinkedHashSet();
        BillList list = (BillList)this.getControl(TABLE_LOG_LIST);
        ListSelectedRowCollection rows = list.getSelectedRows();
        List<Object> bizBillList = new LinkedList();
        if (rows == null || rows.isEmpty()) {
            bizBillList = this.getBizBills(entityNumber, null);
            if (bizBillList != null) {
                for (Map map : bizBillList) {
                    if (map.get("id") != null) {
                        bgControlRecordIds.add(map.get("id").toString());
                    }
                    map.put("entitynumber", entityNumber);
                    map.put("billid", map.get("id").toString());
                    map.put("billnumber", map.get("billno") != null ? map.get("billno").toString() : map.get("number").toString());
                }
            }
        } else {
            for (ListSelectedRow listSelectedRow : rows) {
                bgControlRecordIds.add(listSelectedRow.getPrimaryKeyValue().toString());
            }
        }
        if (bgControlRecordIds.isEmpty()) {
            return;
        }
        QFBuilder builder = new QFBuilder();
        if (rows == null || rows.isEmpty()) {
            builder.add(new QFilter("billid", "in", (Object)bgControlRecordIds));
        } else {
            builder.add(new QFilter("id", "in", (Object)IDUtils.toLongs((Set)bgControlRecordIds)));
        }
        ArrayList arrayList = new ArrayList();
        Throwable throwable = null;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"query control log", (String)"eb_bgcontroloperlog", (String)"id, billid, billnumber, entitynumber", (QFilter[])builder.toArrays(), null);){
            arrayList.addAll(CommonServiceHelper.transDataSet((DataSet)ds));
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        for (Map map : bizBillList) {
            if (arrayList.stream().anyMatch(k -> k.get("billnumber").toString().equals(m.get("billnumber").toString()))) continue;
            HashMap o = new HashMap();
            o.put("entitynumber", map.get("entitynumber"));
            o.put("billid", map.get("billid"));
            o.put("billnumber", map.get("billnumber"));
            arrayList.add(o);
        }
        if (arrayList != null && !arrayList.isEmpty()) {
            Date date = new Date();
            ArrayList<String> successBizNumbers = new ArrayList<String>(arrayList.size());
            ArrayList<String> failBizNumbers = new ArrayList<String>(arrayList.size());
            HashMap<String, Boolean> validExc = new HashMap<String, Boolean>(16);
            BgControlCallerImpl caller = new BgControlCallerImpl();
            for (Map map : arrayList) {
                entityNumber = (String)map.get("entitynumber");
                String bizId = (String)map.get("billid");
                String string = (String)map.get("billnumber");
                if (validExc.containsKey(bizId) && ((Boolean)validExc.get(bizId)).booleanValue()) continue;
                validExc.put(bizId, true);
                if (StringUtils.isNotEmpty((String)entityNumber) && StringUtils.isNotEmpty((String)bizId) && StringUtils.isNotEmpty((String)string)) {
                    TXHandle tx = TX.required((String)"eb/BgReturnBudgetOpAction/beginOperationTransaction");
                    Throwable throwable4 = null;
                    try {
                        try {
                            caller.returnBudget(entityNumber, bizId, "userReturn");
                            Object[] sqlParams = new Object[]{DBServiceHelper.genGlobalLongId(), entityNumber, bizId, string, date, "userReturn"};
                            this.dbExecute(BgBaseConstant.epm, sql, sqlParams);
                            successBizNumbers.add(string);
                        }
                        catch (Exception ex) {
                            tx.markRollback();
                            if (ex instanceof KDBizException && ex.getMessage() != null) {
                                failBizNumbers.add(ResManager.loadResFormat((String)"%1\u5220\u9664\u9884\u7b97\u5931\u8d25\uff0c\u201c%2\u201d\u3002", (String)"ControlOperLogPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[]{string, ex.getMessage()}));
                                continue;
                            }
                            failBizNumbers.add(string);
                        }
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable4 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (tx == null) continue;
                        if (throwable4 != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable6) {
                                throwable4.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        tx.close();
                        continue;
                    }
                }
                this.showNotOperationBillTip();
            }
            String opera = ResManager.loadKDString((String)"\u8fd4\u8fd8\u64cd\u4f5c", (String)"ControlOperLogPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.dealBillOperaResult(successBizNumbers, failBizNumbers, opera);
        } else {
            this.showNotOperationBillTip();
        }
    }

    private void dealBillOperaResult(List<String> successBizNumbers, List<String> failBizNumbers, String opera) {
        if (CollectionUtils.isNotEmpty(successBizNumbers)) {
            successBizNumbers = successBizNumbers.stream().distinct().sorted().collect(Collectors.toList());
            this.getView().showSuccessNotification(ResManager.loadResFormat((String)"%1\u5b8c\u6210\u7684\u5355\u636e\uff1a%2\u3002", (String)"ControlOperLogPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[]{opera, String.join((CharSequence)",", successBizNumbers)}));
        }
        if (CollectionUtils.isNotEmpty(failBizNumbers)) {
            failBizNumbers = failBizNumbers.stream().distinct().sorted().collect(Collectors.toList());
            this.getPageCache().put(CACHE_FAIL_BILL, String.join((CharSequence)",", failBizNumbers));
            this.getPageCache().put(CACHE_FAIL_OPERA, opera);
            ConfirmCallBackListener callBack = new ConfirmCallBackListener(FAIL_BILL, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u64cd\u4f5c\u5931\u8d25\u7684\u5355\u636e\uff0c\u662f\u5426\u4e0b\u8f7d\uff1f", (String)"ControlOperLogPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, callBack);
        }
    }

    private void showNotOperationBillTip() {
        CodeEdit codeEdit = (CodeEdit)this.getControl("txtbills");
        if (StringUtils.isNotEmpty((String)codeEdit.getText())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u64cd\u4f5c\u7684\u5355\u636e\u3002", (String)"ControlOperLogPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    protected void requestBudget(String operation) {
        String entityNumber = (String)this.getModel().getValue(COMBO_BILL);
        if (StringUtils.isEmpty((String)entityNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u63a7\u5236\u7684\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\u3002", (String)"ControlOperLogPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Map<String, Object>> bizBills = this.getBizBills(entityNumber, null);
        String userOperation = this.getOperation();
        boolean isUseParam = false;
        if (StringUtils.isNotEmpty((String)userOperation)) {
            if ("UseParam".equals(userOperation)) {
                isUseParam = true;
            } else {
                operation = userOperation;
            }
        }
        if (bizBills != null && !bizBills.isEmpty()) {
            Date date = new Date();
            ArrayList<String> successBizNumbers = new ArrayList<String>(bizBills.size());
            ArrayList<String> failBizNumbers = new ArrayList<String>(bizBills.size());
            BgControlCallerImpl caller = new BgControlCallerImpl();
            try {
                for (Map<String, Object> bizBill : bizBills) {
                    String bizId = bizBill.get("id").toString();
                    String bizNumber = (String)bizBill.get("billno");
                    if (bizNumber == null) {
                        bizNumber = (String)bizBill.get("number");
                    }
                    if (StringUtils.isNotEmpty((String)entityNumber) && StringUtils.isNotEmpty((String)bizId) && StringUtils.isNotEmpty((String)bizNumber)) {
                        DynamicObject bill = null;
                        bill = isUseParam ? BusinessDataServiceHelper.loadSingle((Object)bizId, (String)entityNumber, (String)StringUtils.join((Collection)caller.getQueryField(entityNumber), (String)",")) : BusinessDataServiceHelper.loadSingle((Object)bizId, (String)entityNumber);
                        try (TXHandle tx = TX.requiresNew((String)"write-operation-log");){
                            try {
                                Object[] sqlParams = new Object[]{DBServiceHelper.genGlobalLongId(), entityNumber, bizId, bizNumber, date, "userRequest"};
                                this.dbExecute(BgBaseConstant.epm, sql, sqlParams);
                            }
                            catch (Exception e) {
                                log.info(e.getMessage());
                                tx.markRollback();
                            }
                        }
                        tx = TX.required((String)"eb/BgRequestBudgetOpAction/beginOperationTransaction");
                        var17_18 = null;
                        try {
                            try {
                                caller.requestBudgetUser(bill, operation);
                                successBizNumbers.add(bizNumber);
                            }
                            catch (Exception ex) {
                                tx.markRollback();
                                if (ex instanceof KDBizException && ex.getMessage() != null) {
                                    failBizNumbers.add(ResManager.loadResFormat((String)"%1\u6263\u51cf\u9884\u7b97\u5931\u8d25\uff0c\u201c%2\u201d\u3002", (String)"ControlOperLogPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[]{bizNumber, ex.getMessage()}));
                                    continue;
                                }
                                failBizNumbers.add(bizNumber);
                            }
                            continue;
                        }
                        catch (Throwable throwable) {
                            var17_18 = throwable;
                            throw throwable;
                        }
                        finally {
                            if (tx == null) continue;
                            if (var17_18 != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable) {
                                    var17_18.addSuppressed(throwable);
                                }
                                continue;
                            }
                            tx.close();
                            continue;
                        }
                    }
                    this.showNotOperationBillTip();
                }
                String opera = ResManager.loadKDString((String)"\u6263\u51cf\u64cd\u4f5c", (String)"ControlOperLogPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.dealBillOperaResult(successBizNumbers, failBizNumbers, opera);
            }
            catch (Throwable ex) {
                this.getView().showErrorNotification(ex.getMessage());
            }
        } else {
            this.showNotOperationBillTip();
        }
    }

    protected List<Map<String, Object>> getBizBills(String entityNumber, List<String> billNos) {
        if (entityNumber == null) {
            return null;
        }
        String bizNumbers = "";
        if (CollectionUtils.isEmpty(billNos)) {
            CodeEdit codeEdit = (CodeEdit)this.getControl("txtbills");
            bizNumbers = codeEdit.getText();
            String operation = this.getOperation();
            if (operation != null && !StringUtils.isEmpty((String)operation)) {
                bizNumbers = bizNumbers.substring(operation.length() + 1);
            }
        } else {
            bizNumbers = String.join((CharSequence)",", billNos);
        }
        if (StringUtils.isEmpty((String)bizNumbers)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4e1a\u52a1\u5355\u636e\u7f16\u7801\uff0c\u4ee5\u201c,\u201d\u5206\u9694\u3002", (String)"ControlOperLogPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        bizNumbers = bizNumbers.replaceAll(" ", "").replaceAll("\n", "");
        List bizBills = null;
        String[] _numbers = bizNumbers.split(",");
        if (_numbers != null && _numbers.length > 0) {
            HashSet numbers = Sets.newHashSetWithExpectedSize((int)_numbers.length);
            for (String _number : _numbers) {
                if (!StringUtils.isNotEmpty((String)_number)) continue;
                numbers.add(_number);
            }
            if (!numbers.isEmpty()) {
                DynamicProperty _prop;
                boolean hasBillNo = true;
                MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)entityNumber);
                if (dt != null && (_prop = dt.getProperty("billno")) == null) {
                    hasBillNo = false;
                }
                String selector = null;
                QFBuilder builder = new QFBuilder();
                if (hasBillNo) {
                    selector = "id, billno";
                    builder.add(new QFilter("billno", "in", (Object)numbers));
                } else {
                    selector = "id, number";
                    builder.add(new QFilter("number", "in", (Object)numbers));
                }
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)"query bills", (String)entityNumber, (String)selector, (QFilter[])builder.toArrays(), null);){
                    bizBills = CommonServiceHelper.transDataSet((DataSet)ds);
                }
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4e1a\u52a1\u5355\u636e\u7f16\u7801\uff0c\u4ee5\u201c,\u201d\u5206\u9694\u3002", (String)"ControlOperLogPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return bizBills;
    }

    private String getOperation() {
        String opString;
        CodeEdit codeEdit = (CodeEdit)this.getControl("txtbills");
        String bizNumbers = codeEdit.getText();
        if (StringUtils.isEmpty((String)bizNumbers)) {
            return null;
        }
        int index = bizNumbers.indexOf(":");
        if (index > 0 && (opString = bizNumbers.substring(0, index)).matches("[a-zA-Z0-9]+")) {
            return opString;
        }
        return null;
    }

    private void dbExecute(DBRoute eb, String sql, Object[] params) {
        DB.execute((DBRoute)eb, (String)sql, (Object[])params);
    }

    private void closeBudget() {
        String entityNumber = (String)this.getModel().getValue(COMBO_BILL);
        if (StringUtils.isEmpty((String)entityNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u63a7\u5236\u7684\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\u3002", (String)"ControlOperLogPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList bizBills = this.getBizBills(entityNumber, null);
        String operation = this.getOperation();
        if (operation != null && "reopenbudget".equals(operation) && (bizBills == null || bizBills.isEmpty())) {
            CodeEdit codeEdit = (CodeEdit)this.getControl("txtbills");
            String bizNumbers = codeEdit.getText();
            String[] _numbers = (bizNumbers = bizNumbers.substring(operation.length() + 1)).split(",");
            if (_numbers != null && _numbers.length > 0) {
                bizBills = Lists.newArrayListWithExpectedSize((int)_numbers.length);
                for (String _number : _numbers) {
                    if (!StringUtils.isNotEmpty((String)_number)) continue;
                    HashMap id = new HashMap(10);
                    id.put("id", _number);
                    id.put("number", _number);
                    bizBills.add(id);
                }
            }
        }
        if (bizBills != null && !bizBills.isEmpty()) {
            Date date = new Date();
            ArrayList<String> successBizNumbers = new ArrayList<String>(bizBills.size());
            ArrayList<String> failBizNumbers = new ArrayList<String>(bizBills.size());
            BgControlCallerImpl caller = new BgControlCallerImpl();
            try {
                for (Map<String, Object> bizBill : bizBills) {
                    String bizId = bizBill.get("id").toString();
                    String bizNumber = (String)bizBill.get("billno");
                    if (bizNumber == null) {
                        bizNumber = (String)bizBill.get("number");
                    }
                    if (StringUtils.isNotEmpty((String)entityNumber) && StringUtils.isNotEmpty((String)bizId) && StringUtils.isNotEmpty((String)bizNumber)) {
                        try {
                            if (operation != null && "reopenbudget".equals(operation)) {
                                ArrayList billInfos = new ArrayList(1);
                                HashMap<String, String> billMap = new HashMap<String, String>(10);
                                billInfos.add(billMap);
                                billMap.put("id", bizId);
                                billMap.put("bostype", entityNumber);
                                billMap.put("number", bizId);
                                caller.reopenBudget(billInfos);
                            } else {
                                caller.closeBudget(entityNumber, bizId, "closeBudget");
                            }
                            Object[] sqlParams = new Object[]{DBServiceHelper.genGlobalLongId(), entityNumber, bizId, bizNumber, date, "userClose"};
                            this.dbExecute(BgBaseConstant.epm, sql, sqlParams);
                            successBizNumbers.add(bizNumber);
                        }
                        catch (Exception ex) {
                            log.info("closeBudget:" + ex);
                            log.error((Throwable)ex);
                            if (ex instanceof KDBizException && ex.getMessage() != null) {
                                failBizNumbers.add(ResManager.loadResFormat((String)"%1\u5173\u95ed\u9884\u7b97\u5931\u8d25\uff0c\u201c%2\u201d\u3002", (String)"ControlOperLogPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[]{bizNumber, ex.getMessage()}));
                                continue;
                            }
                            failBizNumbers.add(bizNumber);
                        }
                        continue;
                    }
                    this.showNotOperationBillTip();
                }
                String opera = ResManager.loadKDString((String)"\u5173\u95ed\u64cd\u4f5c", (String)"ControlOperLogPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.dealBillOperaResult(successBizNumbers, failBizNumbers, opera);
            }
            catch (Throwable ex) {
                this.getView().showErrorNotification(ex.getMessage());
            }
        } else {
            this.showNotOperationBillTip();
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key;
        switch (key = event.getProperty().getName()) {
            case "model": {
                this.beforeF7Select_model(event);
                break;
            }
            case "busmodel": {
                this.beforeF7Select_busModel(event);
                break;
            }
        }
    }

    protected void beforeF7Select_model(BeforeF7SelectEvent evt) {
    }

    protected void beforeF7Select_busModel(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        ArrayList<QFilter> filters = ((BasedataEdit)evt.getSource()).getQFilters();
        if (filters == null) {
            filters = new ArrayList<QFilter>(16);
        }
        filters.add(new QFilter("model", "=", (Object)this.getBizModelId()));
        showParameter.setListFilterParameter(new ListFilterParameter(filters, null));
    }

    protected DynamicObject getBizModelObj() {
        DynamicObject _model = (DynamicObject)this.getModel().getValue("model");
        if (_model == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u7b97\u4f53\u7cfb\u3002", (String)"ControlOperLogPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return _model;
    }

    protected Long getBizModelId() {
        return this.getBizModelObj().getLong("id");
    }

    protected DynamicObject getBusModelObj() {
        DynamicObject _model = this.getBizModelObj();
        DynamicObject _busModel = (DynamicObject)this.getModel().getValue("busmodel");
        if (_busModel == null && !BizModel.isEBByModel((DynamicObject)_model)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u7b97\u4e1a\u52a1\u6a21\u578b\u3002", (String)"ControlOperLogPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return _busModel;
    }

    protected Long getBusModelId() {
        DynamicObject busModel = this.getBusModelObj();
        if (busModel != null) {
            return this.getBusModelObj().getLong("id");
        }
        return 0L;
    }

    public IModelCacheHelper getModelCacheHelper(Long modelId) {
        if (modelId == null || modelId == 0L) {
            throw new KDBizException("modelId is null.");
        }
        return this.modelCacheMap.computeIfAbsent(modelId, f -> ModelCacheContext.getOrCreate((Long)modelId));
    }

    protected void click_checkActual(EventObject evt) {
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(BTN_CHECK_ACTUAL, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u6839\u636e\u9009\u62e9\u7684\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u53ca\u63a7\u5236\u8bb0\u5f55\u68c0\u67e5\u7d2f\u8ba1\u5b9e\u9645\u6570\u662f\u5426\u6b63\u786e\uff1f", (String)"ControlOperLogPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, callBack);
    }

    protected void click_updateActual(EventObject evt) {
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(BTN_UPDATE_ACTUAL, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u6839\u636e\u9009\u62e9\u7684\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u53ca\u63a7\u5236\u8bb0\u5f55\u66f4\u65b0\u5360\u7528\u53ca\u6267\u884c\u6570\uff1f", (String)"ControlOperLogPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, callBack);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (event.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
            switch (event.getCallBackId()) {
                case "btncheckactual": {
                    this.checkActual();
                    break;
                }
                case "btnupdateactual": {
                    this.updateActual();
                    break;
                }
                case "failBill": {
                    this.downLoadFailBillsText();
                    break;
                }
            }
        }
    }

    private void downLoadFailBillsText() {
        String opera = this.getPageCache().get(CACHE_FAIL_OPERA);
        String fileName = ResManager.loadResFormat((String)"%1\u5931\u8d25\u7684\u5355\u636e\u7f16\u7801%2", (String)"ControlOperLogPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[]{opera, DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss")});
        String failBills = this.getPageCache().get(CACHE_FAIL_BILL);
        if (StringUtils.isNotEmpty((String)failBills)) {
            String fileUrl = this.createFileUrl(failBills, fileName);
            this.getClientViewProxy().addAction("download", (Object)fileUrl);
            this.getPageCache().remove(CACHE_FAIL_BILL);
            this.getPageCache().remove(CACHE_FAIL_OPERA);
        }
    }

    private IClientViewProxy getClientViewProxy() {
        return (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
    }

    private String createFileUrl(String failBills, String fileName) {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            outStream.write(failBills.getBytes());
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
        }
        catch (Throwable ex) {
            throw new KDBizException(ex.getMessage());
        }
        return CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".txt", (InputStream)inStream, 10000);
    }

    protected void checkActual() {
        DynamicObject model = this.getBizModelObj();
        if (BizModel.isEBByModel((DynamicObject)model)) {
            this.checkAndUpdateActualByEb(model, false);
        } else {
            DynamicObject busModel = this.getBusModelObj();
            this.checkAndUpdateActualByBgMd(model, busModel, false);
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u68c0\u67e5\u5b9e\u9645\u6570\u5b8c\u6210\u3002", (String)"ControlOperLogPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    protected void updateActual() {
        DynamicObject model = this.getBizModelObj();
        if (BizModel.isEBByModel((DynamicObject)model)) {
            this.checkAndUpdateActualByEb(model, true);
        } else {
            DynamicObject busModel = this.getBusModelObj();
            this.checkAndUpdateActualByBgMd(model, busModel, true);
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u9645\u6570\u66f4\u65b0\u5df2\u5b8c\u6210\u3002", (String)"ControlOperLogPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    protected void checkAndUpdateActualByEb(DynamicObject model, boolean hasUpdate) {
        this.checkAndUpdateActual(model, null, "t_eb_bgcontrolrecord", hasUpdate);
    }

    protected void checkAndUpdateActualByBgMd(DynamicObject model, DynamicObject busModel, boolean hasUpdate) {
        if (model == null || busModel == null) {
            return;
        }
        Long modelId = model.getLong("id");
        Long busModelId = busModel.getLong("id");
        String table = BgControlUtils.getBgControlRecordTable((Long)modelId, (Long)busModelId);
        this.checkAndUpdateActual(model, busModel, table, hasUpdate);
    }

    protected void checkAndUpdateActual(DynamicObject model, DynamicObject busModel, String table, boolean hasUpdate) {
        String field;
        Dimension dimension;
        int i;
        if (model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7b97\u4f53\u7cfb\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ControlOperLogPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((String)table)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u63a7\u5236\u8bb0\u5f55\u8868\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ControlOperLogPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        LogStats stats = new LogStats("budget-control-log : ");
        stats.addInfo("begin-checkAndUpdateActual");
        BizModel bizModel = new BizModel(model);
        Long modelId = model.getLong("id");
        boolean isEbModel = bizModel.isEBByModel();
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper(modelId);
        List<Dimension> dimensions = modelCacheHelper.getDimensionList();
        Map<String, Dimension> dimensionMap = dimensions.stream().collect(Collectors.toMap(BaseCache::getNumber, Dimension2 -> Dimension2));
        Long busModelId = 0L;
        if (!isEbModel) {
            busModelId = busModel.getLong("id");
            Set ctrlDims = BgControlUtils.getControlDimension((DynamicObject)BgControlUtils.queryControlDimension((Long)modelId, (Long)busModelId));
            if (ctrlDims == null || ctrlDims.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u672a\u914d\u7f6e\u63a7\u5236\u7ef4\u5ea6\u3002", (String)"ControlOperLogPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            dimensions = dimensions.stream().filter(dim -> ctrlDims.contains(dim.getId())).collect(Collectors.toList());
        }
        if (dimensions == null || dimensions.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (String)"MemberF7Parameter_1", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        Map<String, Set<Long>> memberIdMap = BgDataAnalysePlugin.getMembers(this.getModel());
        Map fieldsMap = BgControlRecordUtils.getCommFields((Model)modelCacheHelper.getModelobj());
        SqlBuilder sql = new SqlBuilder();
        sql.append("select ", new Object[0]);
        int in = dimensions.size();
        for (i = 0; i < in; ++i) {
            dimension = (Dimension)dimensions.get(i);
            field = BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension) ? 'f' + dimension.getFieldMapped().replaceFirst("dim", "userdefinedid") : (String)fieldsMap.get(dimension.getNumber());
            sql.append(field, new Object[0]).append(",", new Object[0]);
        }
        sql.append("sum(famount) as famount from ", new Object[0]).append(table, new Object[0]).append(" where ", new Object[0]);
        sql.append("fmodelid = ?", new Object[]{modelId});
        if (!memberIdMap.isEmpty()) {
            for (Map.Entry<String, Set<Long>> _dimMember : memberIdMap.entrySet()) {
                dimension = dimensionMap.get(_dimMember.getKey());
                List leaf = dimension.getLeafMembers(_dimMember.getValue());
                if (dimension == null || leaf == null || leaf.isEmpty()) continue;
                field = BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension) ? 'f' + dimension.getFieldMapped().replaceFirst("dim", "userdefinedid") : (String)fieldsMap.get(dimension.getNumber());
                sql.append(" and ", new Object[0]);
                sql.appendIn(field, leaf.stream().map(BaseCache::getId).collect(Collectors.toList()));
            }
        }
        sql.append(" group by ", new Object[0]);
        in = dimensions.size();
        for (i = 0; i < in; ++i) {
            dimension = (Dimension)dimensions.get(i);
            if (i > 0) {
                sql.append(",", new Object[0]);
            }
            field = BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension) ? 'f' + dimension.getFieldMapped().replaceFirst("dim", "userdefinedid") : (String)fieldsMap.get(dimension.getNumber());
            sql.append(field, new Object[0]);
        }
        LinkedHashMap keySet = Maps.newLinkedHashMap();
        HashMap memberMap = Maps.newHashMapWithExpectedSize((int)dimensions.size());
        log.info(sql.toString());
        try (DataSet ds = DB.queryDataSet((String)"checkActual", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            for (Row row : ds) {
                Object[] keyValue = new Object[dimensions.size() + 1];
                keyValue[0] = row.getBigDecimal("famount");
                int in2 = dimensions.size();
                for (int i2 = 0; i2 < in2; ++i2) {
                    dimension = (Dimension)dimensions.get(i2);
                    Set memberSet = memberMap.computeIfAbsent(dimension.getNumber(), f -> Sets.newLinkedHashSet());
                    field = BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension) ? 'f' + dimension.getFieldMapped().replaceFirst("dim", "userdefinedid") : (String)fieldsMap.get(dimension.getNumber());
                    Long memberId = row.getLong(field);
                    Member member = memberId == null || memberId == 0L ? modelCacheHelper.getMemberByAnyView(busModelId, dimension.getNumber(), dimension.getNoneNumber()) : modelCacheHelper.getMemberByAnyView(busModelId, dimension.getNumber(), memberId);
                    if (member == null) continue;
                    keyValue[i2 + 1] = member.getNumber();
                    memberSet.add(member.getNumber());
                }
                keySet.put(new MembersKey(keyValue), row.getBigDecimal("famount"));
            }
        }
        String[] dimNumbers = new String[dimensions.size()];
        for (int i3 = 0; i3 < dimensions.size(); ++i3) {
            dimNumbers[i3] = ((Dimension)dimensions.get(i3)).getNumber();
        }
        CommonShowDetail detail = new CommonShowDetail("");
        CommonShowDetailEntry entry = detail.getEntry("1", "1");
        this.buildColumn(entry, modelCacheHelper, dimNumbers);
        log.info("update-ActualData-size=" + keySet.size());
        log.info("update-ActualData=" + JSONUtils.toString(keySet.keySet()));
        this.queryAndUpdateData(new BizModel(model), busModel, modelCacheHelper, dimensions, keySet, memberMap, hasUpdate, stats, detail, dimNumbers);
        stats.addInfo("end-checkAndUpdateActual");
        log.info(stats.toString());
    }

    protected void queryAndUpdateData(BizModel model, DynamicObject busModel, IModelCacheHelper cacheHelper, List<Dimension> ctrlDims, Map<MembersKey, BigDecimal> members, Map<String, Set<String>> memberMap, boolean hasUpdate, LogStats stats, @NotNull CommonShowDetail detail, @NotNull String[] dimNumbers) {
        if (cacheHelper.getModelobj().isModelByEB()) {
            this.queryAndUpdateDataByEb(cacheHelper, members, memberMap, hasUpdate, stats, detail);
        } else if (ShrekOlapServiceHelper.isStartShrek()) {
            this.queryAndUpdateDataByBgMd(model, busModel, cacheHelper, ctrlDims, members, memberMap, hasUpdate, stats, detail, dimNumbers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queryAndUpdateDataByEb(IModelCacheHelper cacheHelper, Map<MembersKey, BigDecimal> members, Map<String, Set<String>> memberMap, boolean hasUpdate, LogStats stats, CommonShowDetail detail) {
        if (cacheHelper == null || members == null || members.isEmpty() || stats == null) {
            this.showMsg(detail);
            return;
        }
        String[] metas = null;
        Object[] values = null;
        Model model = cacheHelper.getModelobj();
        List dimensions = cacheHelper.getDimensionList();
        Integer precision = this.getPrecision(model.getId());
        boolean isNeedLog = BgControlLogUtils.isNeedLog();
        String[] dimNumbers = new String[dimensions.size()];
        int in = dimensions.size();
        for (int i = 0; i < in; ++i) {
            dimNumbers[i] = ((Dimension)dimensions.get(i)).getNumber();
        }
        SelectCommandInfo query = new SelectCommandInfo();
        query.addDims(dimNumbers);
        query.addMeasures(new String[]{"FMONEY"});
        for (Dimension dimension : dimensions) {
            Set<String> memberSet = memberMap.get(dimension.getNumber());
            if (memberSet == null) continue;
            query.addFilter(dimension.getNumber(), memberSet.toArray(new String[0]));
        }
        IShrekSave save = null;
        ShrekOlapReader reader = null;
        try {
            BigDecimal oldValue;
            MembersKey oldKey;
            save = ShrekOlapServiceHelper.saveData((Model)model, (String[])dimNumbers, (Map)ShrekIdCodeUtils.getDefaultIdCodes((LogStats)stats));
            reader = ShrekOlapServiceHelper.queryReader((Model)model, (SelectCommandInfo)query, (LogStats)stats);
            while (reader.hasNext()) {
                values = reader.next();
                boolean verify = false;
                oldKey = new MembersKey(values);
                BigDecimal newValue = members.get(oldKey);
                if (newValue != null) {
                    oldValue = ConvertUtils.toDecimal((Object)values[0]);
                    if (oldValue != null) {
                        if (!this.compareValue(newValue, oldValue, isNeedLog, precision)) {
                            verify = true;
                        }
                    } else {
                        verify = true;
                    }
                }
                if (verify) {
                    if (hasUpdate) {
                        values[0] = newValue;
                        save.addValues(values);
                        members.remove(oldKey);
                        continue;
                    }
                    this.addToDetail(dimNumbers, values, ConvertUtils.toDecimal((Object)values[0]), newValue, detail, cacheHelper);
                    continue;
                }
                members.remove(oldKey);
            }
            if (!members.isEmpty()) {
                for (Map.Entry<MembersKey, BigDecimal> member : members.entrySet()) {
                    oldKey = member.getKey();
                    oldValue = member.getValue();
                    if (hasUpdate) {
                        if (metas == null) {
                            metas = new String[dimensions.size()];
                        }
                        System.arraycopy(oldKey.getKeys(), 1, metas, 0, metas.length);
                        save.add(metas, (Object)oldValue);
                        continue;
                    }
                    if (values == null) {
                        values = new Object[oldKey.getKeys().length];
                    }
                    System.arraycopy(oldKey.getKeys(), 0, values, 0, values.length);
                    values[0] = oldValue;
                    this.addToDetail(dimNumbers, values, null, oldValue, detail, cacheHelper);
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (save != null) {
                save.close();
            }
        }
        if (hasUpdate) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5b9e\u9645\u6570\u5df2\u66f4\u65b0\u3002", (String)"ControlOperLogPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.showMsg(detail);
        }
    }

    private boolean compareValue(BigDecimal newValue, BigDecimal oldValue, boolean isNeedLog, Integer precision) {
        block5: {
            if (newValue == null && oldValue == null) {
                return true;
            }
            if (oldValue == null || newValue == null) {
                return false;
            }
            if (precision != null && precision >= 0) {
                try {
                    newValue = newValue.setScale((int)precision, RoundingMode.HALF_UP);
                    oldValue = oldValue.setScale((int)precision, RoundingMode.HALF_UP);
                }
                catch (Throwable e) {
                    if (!isNeedLog) break block5;
                    log.info("compareValue-error{}", (Object)e);
                }
            }
        }
        return newValue.compareTo(oldValue) == 0;
    }

    private Integer getPrecision(Long modelId) {
        if (IDUtils.isNull((Long)modelId)) {
            return null;
        }
        if (Boolean.TRUE.equals(this.getModel().getValue("checkboxprecision"))) {
            HashSet<Long> modelIds = new HashSet<Long>(1);
            modelIds.add(modelId);
            Map checkPrecisionMap = ControlParamsSettingUtil.getBalanceCheckPrecisionByModelSet(modelIds);
            if (checkPrecisionMap != null) {
                return (Integer)checkPrecisionMap.get(modelId);
            }
        }
        return null;
    }

    private Map<String, Integer> buildColumn(@NotNull CommonShowDetailEntry entry, @NotNull IModelCacheHelper cacheHelper, @NotNull String[] dimNumbers) {
        HashMap<String, Integer> columnIndexs = new HashMap<String, Integer>(16);
        ArrayList<String> userDef = new ArrayList<String>(10);
        Dimension dim = null;
        for (String dimNumber : dimNumbers) {
            dim = cacheHelper.getDimension(dimNumber);
            if (dim == null) {
                log.info("buildColumn-dim-null:" + dimNumber);
                continue;
            }
            if (!BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dim)) continue;
            userDef.add(dimNumber);
        }
        ArrayList<String> dimColumns = new ArrayList<String>(10);
        dimColumns.add(SysDimensionEnum.Entity.getNumber());
        dimColumns.add(SysDimensionEnum.Account.getNumber());
        dimColumns.addAll(userDef);
        dimColumns.add(SysDimensionEnum.Currency.getNumber());
        if (cacheHelper.getDimension(SysDimensionEnum.Period.getNumber()) == null) {
            dimColumns.add(SysDimensionEnum.BudgetPeriod.getNumber());
        } else {
            dimColumns.add(SysDimensionEnum.Year.getNumber());
            dimColumns.add(SysDimensionEnum.Period.getNumber());
        }
        dimColumns.add(SysDimensionEnum.AuditTrail.getNumber());
        for (int i = 0; i < dimColumns.size(); ++i) {
            columnIndexs.put((String)dimColumns.get(i), i);
            entry.addColumn((String)dimColumns.get(i), cacheHelper.getDimension((String)dimColumns.get(i)).getName());
        }
        CommonShowDetailEntry.Column col = entry.addColumn("ActualOcc", ResManager.loadKDString((String)"\u5360\u7528\u6570", (String)"ControlOperLogPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        col.setGroupKey("Actual");
        col.setGroupAlias(ResManager.loadKDString((String)"\u5b9e\u9645\u6570", (String)"ControlOperLogPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        col = entry.addColumn("ActualExe", ResManager.loadKDString((String)"\u6267\u884c\u6570", (String)"ControlOperLogPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        col.setGroupKey("Actual");
        col.setGroupAlias(ResManager.loadKDString((String)"\u5b9e\u9645\u6570", (String)"ControlOperLogPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        col = entry.addColumn("CtrlRecordOcc", ResManager.loadKDString((String)"\u5360\u7528\u6570", (String)"ControlOperLogPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        col.setGroupKey("CtrlRecord");
        col.setGroupAlias(ResManager.loadKDString((String)"\u63a7\u5236\u8bb0\u5f55", (String)"ControlOperLogPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        col = entry.addColumn("CtrlRecordExe", ResManager.loadKDString((String)"\u6267\u884c\u6570", (String)"ControlOperLogPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        col.setGroupKey("CtrlRecord");
        col.setGroupAlias(ResManager.loadKDString((String)"\u63a7\u5236\u8bb0\u5f55", (String)"ControlOperLogPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return columnIndexs;
    }

    private void addToDetail(String[] dimNumbers, Object[] values, BigDecimal shrekValue, BigDecimal recordValue, @NotNull CommonShowDetail detail, @NotNull IModelCacheHelper cacheHelper) {
        if (dimNumbers == null || dimNumbers.length == 0 || values == null || detail.getEntryMap().isEmpty()) {
            return;
        }
        CommonShowDetailEntry entry = (CommonShowDetailEntry)detail.getEntryMap().values().iterator().next();
        boolean isocc = true;
        Object[] rowDatas = new Object[entry.getColumns().size()];
        for (int i = 0; i < dimNumbers.length; ++i) {
            String dimNumber = dimNumbers[i];
            if (values.length <= i || values[i + 1] == null) {
                log.info("addToDetail-value-null:" + (i + 1));
                continue;
            }
            String memberNumber = String.valueOf(values[i + 1]);
            if (SysDimensionEnum.ChangeType.getNumber().equals(dimNumber)) {
                isocc = "Occupation".equals(memberNumber);
                continue;
            }
            if (!entry.getColumnIndex().containsKey(dimNumber)) {
                log.info("addToDetail-colIndex-null:" + dimNumber);
                continue;
            }
            Dimension dimension = cacheHelper.getDimension(dimNumber);
            Member member = dimension.getStructOfMember(memberNumber);
            if (member != null) {
                memberNumber = memberNumber + " " + member.getName();
            }
            rowDatas[((Integer)entry.getColumnIndex().get((Object)dimNumber)).intValue()] = memberNumber;
        }
        int skip = isocc ? 0 : 1;
        rowDatas[entry.getColumnIndex().size() - 4 + skip] = shrekValue;
        rowDatas[entry.getColumnIndex().size() - 4 + 2 + skip] = recordValue;
        entry.getDatas().add(rowDatas);
    }

    protected void showMsg(@NotNull CommonShowDetail detail) {
        if (detail.isEmpty()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u672a\u68c0\u67e5\u5230\u5b9e\u9645\u6570\u4e0e\u63a7\u5236\u8bb0\u5f55\u6709\u4e0d\u5339\u914d\u7684\u8bb0\u5f55\u3002", (String)"ControlOperLogPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), null);
        } else {
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("detaildata", detail);
            params.put("detailtitle", ResManager.loadKDString((String)"\u5b9e\u9645\u6570\u68c0\u67e5\u4e0d\u5339\u914d\u8bb0\u5f55", (String)"ControlOperLogPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("eb_bgcommonshowlist");
            parameter.setCustomParams(params);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queryAndUpdateDataByBgMd(BizModel model, DynamicObject busModel, IModelCacheHelper cacheHelper, List<Dimension> ctrlDims, Map<MembersKey, BigDecimal> memberKeys, Map<String, Set<String>> memberMap, boolean hasUpdate, @NotNull LogStats stats, @NotNull CommonShowDetail detail, @NotNull String[] dimNumbers) {
        Map dsMembers;
        if (model == null || busModel == null || cacheHelper == null || ctrlDims == null || memberKeys == null || memberKeys.isEmpty()) {
            this.showMsg(detail);
            return;
        }
        stats.addInfo("begin--update--actual.");
        stats.addInfo("update-data-size=" + memberKeys.size());
        LinkedHashMap dsAccounts = Maps.newLinkedHashMap();
        LinkedHashMap dsMemberKeys = Maps.newLinkedHashMap();
        Dimension account = null;
        int accountIndex = 0;
        int in = ctrlDims.size();
        for (int i = 0; i < in; ++i) {
            Dimension dimension = ctrlDims.get(i);
            if (!SysDimensionEnum.Account.getNumber().equals(dimension.getNumber())) continue;
            account = dimension;
            accountIndex = i + 1;
            break;
        }
        if (account == null) {
            return;
        }
        Integer precision = this.getPrecision(model.getId());
        boolean isNeedLog = BgControlLogUtils.isNeedLog();
        for (Map.Entry<MembersKey, BigDecimal> _memberKey : memberKeys.entrySet()) {
            Member member;
            String memberNum = (String)_memberKey.getKey().getKeys()[accountIndex];
            if (memberNum == null || (member = account.getMember(Long.valueOf(0L), memberNum)) == null) continue;
            Set accounts = dsAccounts.computeIfAbsent(member.getDatasetId(), f -> Sets.newLinkedHashSet());
            accounts.add(memberNum);
            dsMembers = dsMemberKeys.computeIfAbsent(member.getDatasetId(), f -> Maps.newLinkedHashMap());
            dsMembers.put(_memberKey.getKey(), _memberKey.getValue());
        }
        LinkedHashSet valueSets = Sets.newLinkedHashSet();
        LinkedList transErrors = Lists.newLinkedList();
        int transErrorSize = 0;
        Map dimensionMap = cacheHelper.getDimensionMap();
        HashMap memberCache = Maps.newHashMapWithExpectedSize((int)dimensionMap.size());
        String[] _ctrlDims = new String[ctrlDims.size()];
        int in2 = ctrlDims.size();
        for (int i = 0; i < in2; ++i) {
            _ctrlDims[i] = ctrlDims.get(i).getNumber();
        }
        for (Map.Entry _memberKeys : dsMemberKeys.entrySet()) {
            MembersKey oldKey;
            Object[] _tmpMetas;
            Long datasetId = (Long)_memberKeys.getKey();
            dsMembers = (Map)_memberKeys.getValue();
            Dataset dataset = Dataset.of((DynamicObject)DatasetServiceHelper.loadDatasets((Long)datasetId));
            String[] dataDims = cacheHelper.getDimensionNums(datasetId);
            SelectCommandInfo query = new SelectCommandInfo();
            query.addDims(dataDims);
            query.addMeasures(new String[]{"FMONEY"});
            List datasetDims = cacheHelper.getDimensionList(datasetId);
            for (Dimension _dimension : datasetDims) {
                Set<String> set = memberMap.get(_dimension.getNumber());
                if (SysDimensionEnum.Account.getNumber().equals(_dimension.getNumber())) {
                    query.addFilter(_dimension.getNumber(), ((Set)dsAccounts.get(datasetId)).toArray(new String[0]));
                    continue;
                }
                if (set != null && !set.isEmpty()) {
                    query.addFilter(_dimension.getNumber(), set.toArray(new String[0]));
                    continue;
                }
                query.addFilter(_dimension.getNumber(), new String[]{_dimension.getNoneNumber()});
            }
            log.info("update-Actual-command" + query.toString());
            Model _model = cacheHelper.getModelobj();
            valueSets.clear();
            Throwable throwable = null;
            try (ShrekOlapReader reader = ShrekOlapServiceHelper.queryReaderByExcludeDynamicCalc((Model)_model, (Dataset)dataset, (SelectCommandInfo)query, (LogStats)stats);){
                while (reader.hasNext()) {
                    Object[] values = reader.next();
                    if (values == null) continue;
                    _tmpMetas = KDCell.transMetas((Object[])values, (String[])_ctrlDims, (String[])dataDims, (Map)dimensionMap, (Map)memberCache);
                    if (_tmpMetas == null) {
                        transErrors.add(values);
                        ++transErrorSize;
                        continue;
                    }
                    oldKey = new MembersKey(_tmpMetas);
                    BigDecimal newValue = (BigDecimal)dsMembers.remove(oldKey);
                    if (newValue == null || this.compareValue(newValue, ConvertUtils.toDecimal((Object)values[0]), isNeedLog, precision)) continue;
                    if (hasUpdate) {
                        values[0] = newValue;
                        valueSets.add(new MembersKey(values));
                        continue;
                    }
                    this.addToDetail(dimNumbers, oldKey.getKeys(), ConvertUtils.toDecimal((Object)values[0]), newValue, detail, cacheHelper);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            if (!dsMembers.isEmpty()) {
                if (hasUpdate) {
                    for (Map.Entry entry : dsMembers.entrySet()) {
                        _tmpMetas = KDCell.transMetas((Object[])((MembersKey)entry.getKey()).getKeys(), (String[])dataDims, (String[])_ctrlDims, (Map)dimensionMap, (Map)memberCache);
                        if (_tmpMetas != null) {
                            oldKey = new MembersKey(_tmpMetas);
                            oldKey.getKeys()[0] = entry.getValue();
                            valueSets.add(oldKey);
                            continue;
                        }
                        transErrors.add(((MembersKey)entry.getKey()).getKeys());
                        ++transErrorSize;
                    }
                } else {
                    for (MembersKey membersKey : dsMembers.keySet()) {
                        this.addToDetail(dimNumbers, membersKey.getKeys(), null, ConvertUtils.toDecimal((Object)membersKey.getKeys()[0]), detail, cacheHelper);
                    }
                }
            }
            if (valueSets.isEmpty()) continue;
            stats.addInfo("execute-update-actual.");
            stats.addInfo("update-dataset-" + dataset.getNumber());
            stats.addInfo("update-data-size-" + valueSets.size());
            try {
                IShrekSave save = ShrekOlapServiceHelper.saveData((Model)_model, (Dataset)dataset, (String[])dataDims, (Map)ShrekIdCodeUtils.getDefaultIdCodes((LogStats)stats));
                Throwable throwable4 = null;
                try {
                    for (MembersKey _value : valueSets) {
                        save.addValues(_value.getKeys());
                    }
                }
                catch (Throwable throwable5) {
                    Throwable throwable6 = throwable5;
                    throw throwable5;
                }
                finally {
                    if (save == null) continue;
                    if (throwable4 != null) {
                        try {
                            save.close();
                        }
                        catch (Throwable throwable7) {
                            throwable4.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    save.close();
                }
            }
            finally {
                stats.add("end-execute-update-actual.");
            }
        }
        if (!hasUpdate) {
            this.showMsg(detail);
        }
        if (transErrorSize > 0) {
            StringBuilder trans = new StringBuilder();
            trans.append("transError-");
            for (Object[] _tranMeta : transErrors) {
                if (_tranMeta == null) continue;
                trans.append(StringUtils.join((Object[])_tranMeta, (char)',')).append(';');
            }
            log.info(trans.toString());
            stats.addInfo("transErrorSize=" + transErrorSize);
        }
        stats.addInfo("end--update--actual.");
    }

    private void releaseEntry() {
        String entityNumber = (String)this.getModel().getValue(COMBO_BILL);
        if (entityNumber == null) {
            return;
        }
        CodeEdit codeEdit = (CodeEdit)this.getControl("txtbills");
        String text = codeEdit.getText();
        if (StringUtils.isEmpty((String)text) || !text.contains(".")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u201c\u5355\u636eid.\u5206\u5f55id\u201d\u683c\u5f0f\u8981\u6c42\u586b\u5199\uff0c\u591a\u6761\u4ee5\u201c,\u201d\u5206\u9694\u3002\u5982\uff1a10000.1001,10000.1002", (String)"ControlOperLogPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            String[] bills;
            for (String bill : bills = text.split(",")) {
                String[] id = bill.split("\\.");
                this.releaseBdt(entityNumber, id);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5173\u95ed\u3002", (String)"ControlOperLogPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private void releaseBdt(String entityNumber, String[] id) {
        if (id[1] == null) {
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"BgControlService", (String)"closeBudget", (Object[])new Object[]{entityNumber, id[0], "userClose"});
        } else {
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"BgControlService", (String)"releaseBudget", (Object[])new Object[]{entityNumber, id[0], id[1]});
        }
        Object[] sqlParams = new Object[]{DBServiceHelper.genGlobalLongId(), entityNumber, id[0], entityNumber, new Date(), "releaseEntry"};
        this.dbExecute(BgBaseConstant.epm, sql, sqlParams);
    }
}

