/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.epm.eb.common.dao.rulecontrol.GroupDimensionPojo;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class ControlRuleGroupSelectDimPlugin
extends AbstractFormPlugin
implements CellClickListener,
RowClickEventListener {
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    private static final String DIM_ID = "dimid";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String SEL_DIM_ID = "seldimid";
    private static final String SEL_NUMBER = "selnumber";
    private static final String SEL_NAME = "selname";
    private static final String SEL_DESCRIPTION = "seldescription";
    private static final String IS_OBO_DIM = "isobodim";
    private static final String IS_MEMBER_RANGE = "ismemberrange";
    private static final String SEL_ENTRY_ENTITY = "selentryentity";
    private static final String CACHE_CHANGE_CLOSE = "cache_change_close";
    private static final String CACHE_SEL_ENTRY_ENTITY = "cache_sel_entry_entity";
    private static final String CHANGE_CLOSE_FLAG = "change_close_flag";
    private static final String GROUP_MEMBERS_CLEAR = "group_members_clear";
    private static final String YES = "Yes";
    private static final String BTN_REMOVE = "btn_remove";
    private static final String BTN_CLEAR_SELECTED = "btn_clearselected";
    private static final String LEFT_SEARCH = "leftsearch";
    private static final String LEFT_UP = "leftup";
    private static final String LEFT_DOWN = "leftdown";
    private static final String RIGHT_SEARCH = "rightsearch";
    private static final String RIGHT_UP = "rightup";
    private static final String RIGHT_DOWN = "rightdown";
    private static final String CACHE_LEFT_LIST_ROW_INDEX = "cachelistrowindex";
    private static final String CACHE_RIGHT_LIST_ROW_INDEX = "cacherightlistrowindex";

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_REMOVE, BTN_CLEAR_SELECTED, BTN_OK, BTN_CANCEL, LEFT_UP, LEFT_DOWN, RIGHT_UP, RIGHT_DOWN});
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid selEntry = (EntryGrid)this.getControl(SEL_ENTRY_ENTITY);
        selEntry.addCellClickListener((CellClickListener)this);
        Search leftSearch = (Search)this.getControl(LEFT_SEARCH);
        leftSearch.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent var1) {
                if (var1.getText() != null && !"".equals(var1.getText())) {
                    ControlRuleGroupSelectDimPlugin.this.searchList(ControlRuleGroupSelectDimPlugin.LEFT_SEARCH, var1.getText(), true);
                } else {
                    ControlRuleGroupSelectDimPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\uff0c\u518d\u6309\u4e0b\u56de\u8f66\u952e\u3002", (String)"ControlRuleGroupSelectDimPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        });
        Search rightSearch = (Search)this.getControl(RIGHT_SEARCH);
        rightSearch.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent var1) {
                if (var1.getText() != null && !"".equals(var1.getText())) {
                    ControlRuleGroupSelectDimPlugin.this.searchList(ControlRuleGroupSelectDimPlugin.RIGHT_SEARCH, var1.getText(), true);
                } else {
                    ControlRuleGroupSelectDimPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\uff0c\u518d\u6309\u4e0b\u56de\u8f66\u952e\u3002", (String)"ControlRuleGroupSelectDimPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    protected void searchList(@NotNull String key, String searchText, boolean isDown) {
        String entryKey = "entryentity";
        String rowIndexKey = CACHE_LEFT_LIST_ROW_INDEX;
        String nameFiled = NAME;
        String numberFiled = NUMBER;
        if (RIGHT_SEARCH.equals(key)) {
            entryKey = SEL_ENTRY_ENTITY;
            rowIndexKey = CACHE_RIGHT_LIST_ROW_INDEX;
            nameFiled = SEL_NAME;
            numberFiled = SEL_NUMBER;
        }
        DynamicObjectCollection dims = this.getModel().getEntryEntity(entryKey);
        ArrayList<Integer> selectRows = new ArrayList<Integer>();
        if (dims != null && !dims.isEmpty()) {
            DynamicObject dim;
            int rowIndex;
            int selRowIndex = -1;
            String _selRowIndex = this.getPageCache().get(rowIndexKey);
            if (StringUtils.isNotEmpty((String)_selRowIndex)) {
                try {
                    selRowIndex = Integer.parseInt(_selRowIndex);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (isDown) {
                int in = dims.size();
                for (int i = rowIndex = selRowIndex != -1 ? selRowIndex + 1 : 0; i < in; ++i) {
                    dim = (DynamicObject)dims.get(i);
                    if (dim == null || !this.equalsSearchText(dim, searchText, nameFiled, numberFiled)) continue;
                    this.getPageCache().put(rowIndexKey, String.valueOf(i));
                    selectRows.add(i);
                    break;
                }
            } else {
                for (int i = rowIndex = selRowIndex != -1 ? selRowIndex - 1 : dims.size() - 1; i >= 0; --i) {
                    dim = (DynamicObject)dims.get(i);
                    if (dim == null || !this.equalsSearchText(dim, searchText, nameFiled, numberFiled)) continue;
                    this.getPageCache().put(rowIndexKey, String.valueOf(i));
                    selectRows.add(i);
                    break;
                }
            }
        }
        EntryGrid entry = (EntryGrid)this.getControl(entryKey);
        if (selectRows.isEmpty()) {
            int[] selectRows1 = entry.getSelectRows();
            if (selectRows1.length > 0) {
                if (isDown) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u662f\u6700\u540e\u4e00\u6761\u6570\u636e\u3002", (String)"ControlRuleGroupAddPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u662f\u7b2c\u4e00\u6761\u6570\u636e\u3002", (String)"ControlRuleGroupAddPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u9879", (String)"MemberSingleTreeF7_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
            }
        } else if (entry != null) {
            int[] rows = selectRows.stream().mapToInt(x -> x).toArray();
            entry.selectRows(rows, 0);
        }
    }

    private boolean equalsSearchText(@NotNull DynamicObject dim, @NotNull String searchTxt, String nameFiled, String numberFiled) {
        String name = dim.getString(nameFiled);
        String number = dim.getString(numberFiled);
        String _searchTxt = searchTxt.toLowerCase();
        return StringUtils.isNotEmpty((String)name) && name.contains(searchTxt) || StringUtils.isNotEmpty((String)number) && number.toLowerCase().contains(_searchTxt);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initLeftEntryEntity();
        this.initSelEntryEntity();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setChooseLeftEntryEntity();
    }

    private void setChooseLeftEntryEntity() {
        int selEntryCount = this.getModel().getEntryRowCount(SEL_ENTRY_ENTITY);
        if (selEntryCount == 0) {
            return;
        }
        List<Long> selDimIds = this.getSelDimIds();
        int[] selRows = new int[selEntryCount];
        int index = 0;
        int entryCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < entryCount; ++i) {
            Long dimId = (Long)this.getModel().getValue(DIM_ID, i);
            if (!selDimIds.contains(dimId)) continue;
            selRows[index] = i;
            ++index;
        }
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        entry.selectRows(selRows, selRows[0]);
    }

    private void initSelEntryEntity() {
        List groupDimensionPojos;
        String controlUserDefinedDimsStr = (String)this.getView().getFormShowParameter().getCustomParam("controlUserDefinedDims");
        DynamicObjectCollection controlUserDefinedDims = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)controlUserDefinedDimsStr);
        Map<Long, DynamicObject> rowMap = controlUserDefinedDims.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        String selGroupUserDefinedDimsStr = (String)this.getView().getFormShowParameter().getCustomParam("selGroupUserDefinedDims");
        if (StringUtils.isNotEmpty((String)selGroupUserDefinedDimsStr) && CollectionUtils.isNotEmpty((Collection)(groupDimensionPojos = (List)SerializationUtils.deSerializeFromBase64((String)selGroupUserDefinedDimsStr)))) {
            this.getModel().beginInit();
            this.getModel().batchCreateNewEntryRow(SEL_ENTRY_ENTITY, groupDimensionPojos.size());
            for (int i = 0; i < groupDimensionPojos.size(); ++i) {
                DynamicObject dynamicObject;
                GroupDimensionPojo groupDimensionPojo = (GroupDimensionPojo)groupDimensionPojos.get(i);
                Long selDimId = groupDimensionPojo.getGroupDim();
                if (selDimId == null || (dynamicObject = rowMap.get(selDimId)) == null) continue;
                this.getModel().setValue(SEL_DIM_ID, (Object)selDimId, i);
                this.getModel().setValue(SEL_NAME, (Object)dynamicObject.getString(NAME), i);
                this.getModel().setValue(SEL_NUMBER, (Object)dynamicObject.getString(NUMBER), i);
                this.getModel().setValue(SEL_DESCRIPTION, (Object)dynamicObject.getString(DESCRIPTION), i);
                this.getModel().setValue(IS_OBO_DIM, (Object)groupDimensionPojo.getOboDim(), i);
                this.getModel().setValue(IS_MEMBER_RANGE, (Object)groupDimensionPojo.getMemberRange(), i);
            }
            this.getModel().endInit();
            this.getView().updateView(SEL_ENTRY_ENTITY);
        }
    }

    private void initLeftEntryEntity() {
        DynamicObjectCollection controlUserDefinedDims;
        String controlUserDefinedDimsStr = (String)this.getView().getFormShowParameter().getCustomParam("controlUserDefinedDims");
        if (StringUtils.isNotEmpty((String)controlUserDefinedDimsStr) && (controlUserDefinedDims = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)controlUserDefinedDimsStr)) != null && !controlUserDefinedDims.isEmpty()) {
            this.getModel().beginInit();
            this.getModel().batchCreateNewEntryRow("entryentity", controlUserDefinedDims.size());
            for (int i = 0; i < controlUserDefinedDims.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)controlUserDefinedDims.get(i);
                this.getModel().setValue(DIM_ID, (Object)dynamicObject.getLong("id"), i);
                this.getModel().setValue(NAME, (Object)dynamicObject.getString(NAME), i);
                this.getModel().setValue(NUMBER, (Object)dynamicObject.getString(NUMBER), i);
                this.getModel().setValue(DESCRIPTION, (Object)dynamicObject.getString(DESCRIPTION), i);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "ismemberrange": {
                int rowIndex = e.getChangeSet()[0].getRowIndex();
                boolean oboDim = (Boolean)this.getModel().getValue(IS_OBO_DIM, rowIndex);
                boolean newValue = (Boolean)e.getChangeSet()[0].getNewValue();
                if (oboDim || !newValue) break;
                this.getModel().beginInit();
                this.getModel().setValue(IS_MEMBER_RANGE, (Object)false, rowIndex);
                this.getModel().endInit();
                this.getView().updateView(SEL_ENTRY_ENTITY);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9010\u4e00\u6253\u5f00\u6210\u5458\u5206\u7ec4\uff0c\u518d\u6307\u5b9a\u6210\u5458\u8303\u56f4\u3002", (String)"ControlRuleGroupSelectDimPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_remove": {
                this.singleMoveLeft();
                break;
            }
            case "btn_clearselected": {
                this.allMoveLeft();
                break;
            }
            case "btnok": {
                this.returnData();
                break;
            }
            case "leftup": {
                this.clickSearchUpOrDown(LEFT_SEARCH, false);
                break;
            }
            case "leftdown": {
                this.clickSearchUpOrDown(LEFT_SEARCH, true);
                break;
            }
            case "rightup": {
                this.clickSearchUpOrDown(RIGHT_SEARCH, false);
                break;
            }
            case "rightdown": {
                this.clickSearchUpOrDown(RIGHT_SEARCH, true);
                break;
            }
        }
    }

    private void clickSearchUpOrDown(String key, boolean isDown) {
        Search search = (Search)this.getControl(key);
        if (search != null && StringUtils.isNotEmpty((String)search.getSearchKey())) {
            this.searchList(key, search.getSearchKey(), isDown);
        }
    }

    private void returnData() {
        int selEntryCount = this.getModel().getEntryRowCount(SEL_ENTRY_ENTITY);
        ArrayList<GroupDimensionPojo> returnGroupDimensionPojos = new ArrayList<GroupDimensionPojo>(selEntryCount);
        for (int i = 0; i < selEntryCount; ++i) {
            Long dimId = (Long)this.getModel().getValue(SEL_DIM_ID, i);
            Boolean isOboDim = (Boolean)this.getModel().getValue(IS_OBO_DIM, i);
            Boolean isMemberRange = (Boolean)this.getModel().getValue(IS_MEMBER_RANGE, i);
            GroupDimensionPojo pojo = new GroupDimensionPojo(dimId, isOboDim);
            pojo.setMemberRange(isMemberRange);
            returnGroupDimensionPojos.add(pojo);
        }
        String oldSelGroupUserDefinedDimsStr = (String)this.getView().getFormShowParameter().getCustomParam("selGroupUserDefinedDims");
        String selGroupMembersSizeStr = (String)this.getView().getFormShowParameter().getCustomParam("selGroupMembersSize");
        Long size = IDUtils.toLong((Object)selGroupMembersSizeStr);
        String selGroupUserDefinedDimsStr = SerializationUtils.serializeToBase64(returnGroupDimensionPojos);
        HashMap<String, String> returnDataMap = new HashMap<String, String>(16);
        if (!StringUtils.equals((String)oldSelGroupUserDefinedDimsStr, (String)selGroupUserDefinedDimsStr)) {
            if (size > 0L && this.checkGroupDimChange(oldSelGroupUserDefinedDimsStr, selGroupUserDefinedDimsStr)) {
                this.getPageCache().put(CACHE_SEL_ENTRY_ENTITY, selGroupUserDefinedDimsStr);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u91cd\u65b0\u9009\u62e9\u5206\u7ec4\u7ef4\u5ea6\u5c06\u6e05\u9664\u5f53\u524d\u6240\u6709\u5df2\u9009\u62e9\u7684\u5206\u7ec4\u6210\u5458\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ControlRuleGroupSelectDimPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(GROUP_MEMBERS_CLEAR, (IFormPlugin)this));
            } else {
                this.getPageCache().put(CACHE_CHANGE_CLOSE, CHANGE_CLOSE_FLAG);
                returnDataMap.put("groupdimchange", "0");
                returnDataMap.put("returnData", selGroupUserDefinedDimsStr);
                this.getView().returnDataToParent(returnDataMap);
                this.getView().close();
            }
        } else {
            returnDataMap.put("groupdimchange", "0");
            returnDataMap.put("returnData", oldSelGroupUserDefinedDimsStr);
            this.getView().returnDataToParent(returnDataMap);
            this.getView().close();
        }
    }

    private boolean checkGroupDimChange(String oldSelGroupUserDefinedDimsStr, String selGroupUserDefinedDimsStr) {
        List<Long> groupDimIds;
        List oldAllGroupDims = StringUtils.isNotEmpty((String)oldSelGroupUserDefinedDimsStr) ? (List)SerializationUtils.deSerializeFromBase64((String)oldSelGroupUserDefinedDimsStr) : new ArrayList(16);
        List selAllGroupDims = StringUtils.isNotEmpty((String)selGroupUserDefinedDimsStr) ? (List)SerializationUtils.deSerializeFromBase64((String)selGroupUserDefinedDimsStr) : new ArrayList(16);
        Map<Boolean, List<GroupDimensionPojo>> grpOldGroupDimMap = oldAllGroupDims.stream().collect(Collectors.groupingBy(GroupDimensionPojo::getOboDim));
        Map<Boolean, List<GroupDimensionPojo>> grpGroupDimMap = selAllGroupDims.stream().collect(Collectors.groupingBy(GroupDimensionPojo::getOboDim));
        List<GroupDimensionPojo> oldGroupDimensions = grpOldGroupDimMap.get(false);
        List<GroupDimensionPojo> groupDimensions = grpGroupDimMap.get(false);
        if (CollectionUtils.isEmpty(oldGroupDimensions) && CollectionUtils.isEmpty(groupDimensions)) {
            return false;
        }
        if (CollectionUtils.isEmpty(oldGroupDimensions) && CollectionUtils.isNotEmpty(groupDimensions) || CollectionUtils.isNotEmpty(oldGroupDimensions) && CollectionUtils.isEmpty(groupDimensions)) {
            return true;
        }
        if (oldGroupDimensions.size() != groupDimensions.size()) {
            return true;
        }
        List<Long> oldGroupDimIds = oldGroupDimensions.stream().map(GroupDimensionPojo::getGroupDim).collect(Collectors.toList());
        List<Long> differList = this.getDifferListByMap(oldGroupDimIds, groupDimIds = groupDimensions.stream().map(GroupDimensionPojo::getGroupDim).collect(Collectors.toList()));
        return CollectionUtils.isNotEmpty(differList);
    }

    private List<Long> getDifferListByMap(List<Long> oldGroupDimIds, List<Long> groupDimIds) {
        ArrayList<Long> differList = new ArrayList<Long>(16);
        HashMap<Long, Integer> map = new HashMap<Long, Integer>(16);
        for (Long oldGroupDimId : oldGroupDimIds) {
            map.put(oldGroupDimId, 1);
        }
        for (Long l : groupDimIds) {
            Integer integer = (Integer)map.get(l);
            if (integer == null) {
                differList.add(l);
                continue;
            }
            map.put(l, integer + 1);
        }
        for (Map.Entry entry : map.entrySet()) {
            if (!((Integer)entry.getValue()).equals(1)) continue;
            differList.add((Long)entry.getKey());
        }
        return differList;
    }

    private void singleMoveLeft() {
        EntryGrid selEntry = (EntryGrid)this.getControl(SEL_ENTRY_ENTITY);
        if (selEntry != null) {
            int[] rows = selEntry.getSelectRows();
            if (rows == null || rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u7ef4\u5ea6\u3002", (String)"ControlRuleGroupSelectDimPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getModel().beginInit();
                ArrayList<Long> removeSelDimId = new ArrayList<Long>(rows.length);
                for (int row : rows) {
                    Long removeSelDim = (Long)this.getModel().getValue(SEL_DIM_ID, row);
                    removeSelDimId.add(removeSelDim);
                }
                this.getModel().deleteEntryRows(SEL_ENTRY_ENTITY, rows);
                this.getModel().endInit();
                this.getView().updateView(SEL_ENTRY_ENTITY);
                EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                int[] selectRows = entryGrid.getSelectRows();
                List collect = Arrays.stream(selectRows).boxed().collect(Collectors.toList());
                Iterator iterator = collect.iterator();
                while (iterator.hasNext()) {
                    Integer next = (Integer)iterator.next();
                    Long dimId = (Long)this.getModel().getValue(DIM_ID, next.intValue());
                    if (!removeSelDimId.contains(dimId)) continue;
                    iterator.remove();
                }
                int[] newSelectRows = new int[collect.size()];
                for (int i = 0; i < collect.size(); ++i) {
                    newSelectRows[i] = (Integer)collect.get(i);
                }
                entryGrid.selectRows(new int[0], 0);
                if (newSelectRows.length > 0) {
                    entryGrid.selectRows(newSelectRows, newSelectRows[0]);
                }
            }
        }
    }

    private void allMoveLeft() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.selectRows(new int[0], 0);
        this.getModel().deleteEntryData(SEL_ENTRY_ENTITY);
        this.getView().updateView(SEL_ENTRY_ENTITY);
    }

    private void singleMoveRight() {
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        if (entry != null) {
            int[] rows = entry.getSelectRows();
            if (rows == null || rows.length == 0) {
                this.allMoveLeft();
            } else {
                List<Long> selDimIds = this.getSelDimIds();
                ArrayList<Long> chooseLeftDimIds = new ArrayList<Long>(rows.length);
                for (int i = 0; i < rows.length; ++i) {
                    Long leftSelDimId = (Long)this.getModel().getValue(DIM_ID, rows[i]);
                    chooseLeftDimIds.add(leftSelDimId);
                }
                selDimIds.removeAll(chooseLeftDimIds);
                this.removeSelEntryByIds(selDimIds);
                selDimIds = this.getSelDimIds();
                this.getModel().beginInit();
                for (int i = 0; i < rows.length; ++i) {
                    Long leftSelDimId = (Long)this.getModel().getValue(DIM_ID, rows[i]);
                    if (selDimIds.contains(leftSelDimId)) continue;
                    int leftSelRow = rows[i];
                    this.addNewSelEntryRow(leftSelRow);
                }
                this.getModel().endInit();
                this.getView().updateView(SEL_ENTRY_ENTITY);
            }
        }
    }

    private void removeSelEntryByIds(List<Long> removeDimIds) {
        ArrayList<Integer> rows = new ArrayList<Integer>(removeDimIds.size());
        DynamicObjectCollection selDims = this.getModel().getEntryEntity(SEL_ENTRY_ENTITY);
        int in = selDims.size();
        for (int i = 0; i < in; ++i) {
            DynamicObject selDim = (DynamicObject)selDims.get(i);
            if (!removeDimIds.contains(selDim.getLong(SEL_DIM_ID))) continue;
            rows.add(i);
        }
        int[] rowArray = new int[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            rowArray[i] = (Integer)rows.get(i);
        }
        this.getModel().deleteEntryRows(SEL_ENTRY_ENTITY, rowArray);
        this.getView().updateView(SEL_ENTRY_ENTITY);
    }

    private void addNewSelEntryRow(int leftSelRow) {
        int newEntryRow = this.getModel().createNewEntryRow(SEL_ENTRY_ENTITY);
        this.getModel().setValue(SEL_DIM_ID, this.getModel().getValue(DIM_ID, leftSelRow), newEntryRow);
        this.getModel().setValue(SEL_NAME, this.getModel().getValue(NAME, leftSelRow), newEntryRow);
        this.getModel().setValue(SEL_NUMBER, this.getModel().getValue(NUMBER, leftSelRow), newEntryRow);
        this.getModel().setValue(SEL_DESCRIPTION, this.getModel().getValue(DESCRIPTION, leftSelRow), newEntryRow);
    }

    @NotNull
    private List<Long> getSelDimIds() {
        int selEntryCount = this.getModel().getEntryRowCount(SEL_ENTRY_ENTITY);
        ArrayList<Long> selDimIds = new ArrayList<Long>(selEntryCount);
        for (int i = 0; i < selEntryCount; ++i) {
            Long selDimId = (Long)this.getModel().getValue(SEL_DIM_ID, i);
            selDimIds.add(selDimId);
        }
        return selDimIds;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String changeClose = this.getPageCache().get(CACHE_CHANGE_CLOSE);
        if (!StringUtils.equals((String)changeClose, (String)CHANGE_CLOSE_FLAG)) {
            String selGroupUserDefinedDimsStr = (String)this.getView().getFormShowParameter().getCustomParam("selGroupUserDefinedDims");
            HashMap<String, String> returnDataMap = new HashMap<String, String>(16);
            returnDataMap.put("groupdimchange", "0");
            returnDataMap.put("returnData", selGroupUserDefinedDimsStr);
            this.getView().returnDataToParent(returnDataMap);
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String fieldKey;
        switch (fieldKey = cellClickEvent.getFieldKey()) {
            case "isobodim": {
                this.changeIsOboDimRow(cellClickEvent);
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        this.singleMoveRight();
    }

    private void changeIsOboDimRow(CellClickEvent cellClickEvent) {
        int rowIndex = cellClickEvent.getRow();
        if (rowIndex < 0) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)cellClickEvent.getSource();
        Boolean isOboDim = (Boolean)entryGrid.getModel().getValue(IS_OBO_DIM, rowIndex);
        if (isOboDim.booleanValue()) {
            this.getModel().beginInit();
            this.getModel().setValue(IS_MEMBER_RANGE, (Object)false, rowIndex);
            this.getModel().endInit();
            this.getView().updateView(SEL_ENTRY_ENTITY);
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String action;
        super.confirmCallBack(e);
        switch (action = e.getCallBackId()) {
            case "group_members_clear": {
                if (!YES.equals(e.getResultValue())) break;
                this.getPageCache().put(CACHE_CHANGE_CLOSE, CHANGE_CLOSE_FLAG);
                HashMap<String, String> returnDataMap = new HashMap<String, String>(16);
                returnDataMap.put("groupdimchange", "1");
                returnDataMap.put("returnData", this.getPageCache().get(CACHE_SEL_ENTRY_ENTITY));
                this.getView().returnDataToParent(returnDataMap);
                this.getView().close();
                break;
            }
        }
    }
}

