/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.central.OrgMemberDto;
import kd.epm.eb.common.dao.rulecontrol.ControlRuleAllotOrgPojo;
import kd.epm.eb.common.dao.rulecontrol.OboMemberRangePojo;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.RuleControlTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ControlRuleHelper {
    protected static final String MAIN_FIELDS = "controltype,periodclassify,coefficient,isbeyond,isfreetype";
    public static final String MAIN_SELECTFIELDS = "id,bussmodel,model,group,group.groupname,group.groupseq,controltype,periodclassify,coefficient,isbeyond,isfreetype,effectivedate,invaliddate,illustrate,accounts.account.id,accounts.account.name,accounts.account.number,dimentions.userdefined1.id,dimentions.userdefined1.name,dimentions.userdefined1.number,dimentions.userdefined2.id,dimentions.userdefined2.name,dimentions.userdefined2.number,dimentions.userdefined3.id,dimentions.userdefined3.name,dimentions.userdefined3.number,dimentions.userdefined4.id,dimentions.userdefined4.name,dimentions.userdefined4.number,dimentions.userdefined5.id,dimentions.userdefined5.name,dimentions.userdefined5.number,dimentions.userdefined6.id,dimentions.userdefined6.name,dimentions.userdefined6.number,dimentions.userdefined7.id,dimentions.userdefined7.name,dimentions.userdefined7.number,dimentions.userdefineddimid1,dimentions.userdefineddimid2,dimentions.userdefineddimid3,dimentions.userdefineddimid4,dimentions.userdefineddimid5,dimentions.userdefineddimid6,dimentions.userdefineddimid7";
    public static final String ACCOUNT_MAIN_SELECTFIELDS = "id,bussmodel,model,group,group.groupname,group.groupseq,controltype,periodclassify,coefficient,isbeyond,isfreetype,effectivedate,invaliddate,illustrate,accounts.account.id,accounts.account.name,accounts.account.number";
    public static final String USER_DEFINED_SELECTFIELDS = "id,dimentions.userdefined1.id,dimentions.userdefined1.name,dimentions.userdefined1.number,dimentions.userdefined2.id,dimentions.userdefined2.name,dimentions.userdefined2.number,dimentions.userdefined3.id,dimentions.userdefined3.name,dimentions.userdefined3.number,dimentions.userdefined4.id,dimentions.userdefined4.name,dimentions.userdefined4.number,dimentions.userdefined5.id,dimentions.userdefined5.name,dimentions.userdefined5.number,dimentions.userdefined6.id,dimentions.userdefined6.name,dimentions.userdefined6.number,dimentions.userdefined7.id,dimentions.userdefined7.name,dimentions.userdefined7.number,dimentions.userdefineddimid1,dimentions.userdefineddimid2,dimentions.userdefineddimid3,dimentions.userdefineddimid4,dimentions.userdefineddimid5,dimentions.userdefineddimid6,dimentions.userdefineddimid7";
    public static final String CONTROL_RULE_MAIN_SELECTFIELDS = "id,bussmodel,model,group,controltype,periodclassify,coefficient,isbeyond,isfreetype,effectivedate,invaliddate,illustrate";
    public static final String GROUP_DIM_SELECTFIELDS = "id,groupdims.groupdim.id,groupdims.groupdim.name,groupdims.groupdim.number,groupdims.isobodim,groupdims.ismemberrange";
    public static final String OBO_MEMRANGE_SELECTFIELDS = "id,obomemranges.obomember.id,obomemranges.obomember.name,obomemranges.obomember.number,obomemranges.obodim.id,obomemranges.obodim.name,obomemranges.obodim.number,obomemranges.memrange";
    protected static final String ACCOUNT_SELECTFIELDS = "id,account.id,account.number,account.name";
    public static final String DIM_FIELDS = "userdefined1,userdefined2,userdefined3,userdefined4,userdefined5,userdefined6,userdefined7";
    public static final String ACCOUNT_DIM_FIELDS = "groupaccount,userdefined1,userdefined2,userdefined3,userdefined4,userdefined5,userdefined6,userdefined7";
    public static final String DIM_SELECTFIELDS = "id,userdefined1.id,userdefined1.number,userdefined1.name,userdefined2.id,userdefined2.number,userdefined2.name,userdefined3.id,userdefined3.number,userdefined3.name,userdefined4.id,userdefined4.number,userdefined4.name,userdefined5.id,userdefined5.number,userdefined5.name,userdefined6.id,userdefined6.number,userdefined6.name,userdefined7.id,userdefined7.number,userdefined7.name,userdefineddimid1,userdefineddimid2,userdefineddimid3,userdefineddimid4,userdefineddimid5,userdefineddimid6,userdefineddimid7";
    private static final String ORG_SELECTFIELDS = "allotedorg.id as dimid,allotedorg.name as dimname,allotedorg.number as dimnumber,controlrulemainid,id,allotedorgview.id as viewid ,allotedorgview.name as viewname,allotedorgview.number as viewnumber,property,property.id,property.number,property.name,property.property.id,entityview,entityview.id";
    protected static final String GROUP_SELECTFIELDS = "id,groupname,groupseq";
    public static final String DIM_MATE_RULE_SELECTFIELDS = "model,entryentity.subentryentity.bussmodel,entryentity.subentryentity.number,entryentity.subentryentity.userdefineddimid1,entryentity.subentryentity.userdefineddimid2,entryentity.subentryentity.userdefineddimid3,entryentity.subentryentity.userdefineddimid4,entryentity.subentryentity.userdefineddimid5,entryentity.subentryentity.userdefineddimid6,entryentity.subentryentity.userdefined1field,entryentity.subentryentity.userdefined2field,entryentity.subentryentity.userdefined3field,entryentity.subentryentity.userdefined4field,entryentity.subentryentity.userdefined5field,entryentity.subentryentity.userdefined6field";
    public static final int MAX_USER_DEFINED_DIM_NUMBER = 6;
    public static final int CONTROL_RULE_USER_DEFINED_DIM_DB_MAX = 7;
    private static Log log = LogFactory.getLog(ControlRuleHelper.class);

    public static List<Map<String, String>> getAllotorgList(QFilter[] filters) {
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"eb_ocntrolrule_allotorg", (String)ORG_SELECTFIELDS, (QFilter[])filters);
        ArrayList<Map<String, String>> collections = new ArrayList<Map<String, String>>(docs.size());
        docs.stream().forEach(doc -> {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("controlrulemainid", doc.getString("controlrulemainid"));
            map.put("id", doc.getString("id"));
            if (StringUtils.isNotEmpty((CharSequence)doc.getString("property")) && StringUtils.isNotEmpty((CharSequence)doc.getString("property.number")) && !"0".equals(doc.getString("property"))) {
                map.put("orgId", doc.getString("property.id"));
                map.put("orgName", doc.getString("property.name"));
                map.put("orgNumber", doc.getString("property.number"));
                map.put("propertyType", doc.getString("property.property.id"));
                map.put("type", "property");
                map.put("view", doc.getString("entityview.id"));
                collections.add(map);
            } else if (StringUtils.isNotEmpty((CharSequence)doc.getString("viewname")) && !"0".equals(doc.getString("viewid"))) {
                map.put("orgId", doc.getString("viewid"));
                map.put("orgName", doc.getString("viewname"));
                map.put("orgNumber", doc.getString("viewnumber"));
                map.put("type", "view");
                map.put("view", doc.getString("entityview.id"));
                collections.add(map);
            } else if (StringUtils.isNotEmpty((CharSequence)doc.getString("dimname"))) {
                map.put("orgId", doc.getString("dimid"));
                map.put("orgName", doc.getString("dimname"));
                map.put("orgNumber", doc.getString("dimnumber"));
                map.put("view", doc.getString("entityview.id"));
                map.put("type", "org");
                collections.add(map);
            }
        });
        return collections;
    }

    public static List<OrgMemberDto> getOrgList(QFilter[] filters) {
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"eb_ocntrolrule_allotorg", (String)ORG_SELECTFIELDS, (QFilter[])filters);
        ArrayList<OrgMemberDto> collections = new ArrayList<OrgMemberDto>(docs.size());
        docs.stream().forEach(doc -> {
            OrgMemberDto orgMemberDto = new OrgMemberDto();
            orgMemberDto.setId(Long.valueOf(doc.getLong("id")));
            if (StringUtils.isNotEmpty((CharSequence)doc.getString("property")) && !"0".equals(doc.getString("property"))) {
                orgMemberDto.setId(Long.valueOf(doc.getLong("property.id")));
                orgMemberDto.setName(doc.getString("property.name"));
                orgMemberDto.setNumber(doc.getString("property.number"));
                orgMemberDto.setType("property");
                collections.add(orgMemberDto);
            } else if (StringUtils.isNotEmpty((CharSequence)doc.getString("viewname")) && !"0".equals(doc.getString("viewid"))) {
                orgMemberDto.setId(Long.valueOf(doc.getLong("viewid")));
                orgMemberDto.setName(doc.getString("viewname"));
                orgMemberDto.setNumber(doc.getString("viewnumber"));
                orgMemberDto.setType("view");
                collections.add(orgMemberDto);
            } else if (StringUtils.isNotEmpty((CharSequence)doc.getString("dimname"))) {
                orgMemberDto.setId(Long.valueOf(doc.getLong("dimid")));
                orgMemberDto.setName(doc.getString("dimname"));
                orgMemberDto.setNumber(doc.getString("dimnumber"));
                orgMemberDto.setType("org");
                collections.add(orgMemberDto);
            }
        });
        return collections;
    }

    public static String[] getControlStr() {
        return new String[]{ResManager.loadKDString((String)"\u6309\u6708\u63a7\u5236", (String)"ControlRuleHelper_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6309\u5b63\u63a7\u5236", (String)"ControlRuleHelper_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5e74\u5ea6\u603b\u91cf", (String)"ControlRuleHelper_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6309\u6708\u7d2f\u8ba1\uff08\u5e74\u5ea6\uff09", (String)"ControlRuleHelper_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6309\u5b63\u7d2f\u8ba1", (String)"ControlRuleHelper_4", (String)"epm-eb-formplugin", (Object[])new Object[0])};
    }

    public static List<ComboItem> createControlTypeList(List<String> removeNums) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        for (RuleControlTypeEnum ruleControlTypeEnum : RuleControlTypeEnum.values()) {
            if (removeNums.contains(ruleControlTypeEnum.getIndex())) continue;
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(ruleControlTypeEnum.getName()));
            item.setValue(ruleControlTypeEnum.getIndex());
            items.add(item);
        }
        return items;
    }

    public static Map<Integer, Long> getControlDimMap(Long modelId, Long bussModelModelId) {
        HashMap<Integer, Long> controlDimMap = new HashMap<Integer, Long>(16);
        boolean isEB = ModelCacheContext.getOrCreate((Long)modelId).getModelobj().isModelByEB();
        HashSet bgmControlDimIds = new HashSet(10);
        QFBuilder qb1 = new QFBuilder();
        qb1.add(new QFilter("issysdimension", "=", (Object)"0"));
        qb1.and("model", "=", (Object)modelId);
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"epm_dimension", (String)"id,name,issysdimension,number,description,dseq", (QFilter[])qb1.toArray(), (String)"dseq, createtime");
        if (!isEB) {
            Collection bgmControlDims = BusinessDataServiceHelper.loadFromCache((String)"eb_bgmcontroldimension", (QFilter[])new QFilter("model", "=", (Object)modelId).and("businessmodel", "=", (Object)bussModelModelId).toArray()).values();
            List dimIds = bgmControlDims.stream().map(p -> p.getDynamicObjectCollection("entryentity").stream().map(m -> m.getLong("dimensionid")).collect(Collectors.toSet())).collect(Collectors.toList());
            if (dimIds.size() > 0) {
                bgmControlDimIds.addAll((Collection)dimIds.get(0));
            }
            if (bgmControlDimIds.size() > 0) {
                docs.removeIf(p -> !bgmControlDimIds.contains(p.getLong("id")));
            }
            if (bgmControlDimIds.size() == 0) {
                Iterator iterator = docs.iterator();
                while (iterator.hasNext()) {
                    DynamicObject next = (DynamicObject)iterator.next();
                    if (SysDimensionEnum.Account.getNumber().equals(next.getString("number"))) continue;
                    iterator.remove();
                }
            }
        }
        if (docs != null && !docs.isEmpty()) {
            for (int i = 0; i < docs.size(); ++i) {
                controlDimMap.put(i + 1, ((DynamicObject)docs.get(i)).getLong("id"));
            }
        }
        return controlDimMap;
    }

    /*
     * WARNING - void declaration
     */
    public static List<ControlRuleAllotOrgPojo> getControlRuleAllotOrgPojos(DynamicObject[] rules, Map<Integer, Long> controlDimMap, Long accountId, IModelCacheHelper modelcache, Long bussModelId) {
        ArrayList<ControlRuleAllotOrgPojo> ruleAllotOrgPojos = new ArrayList<ControlRuleAllotOrgPojo>(16);
        if (rules == null || rules.length == 0) {
            return ruleAllotOrgPojos;
        }
        String[] arrs = DIM_FIELDS.split(",");
        HashMap<Long, Set> ruleMemberMap = new HashMap<Long, Set>(16);
        for (DynamicObject rule : rules) {
            void var23_26;
            Long groupId = 0L;
            StringBuilder userDefineDimComposeSb = new StringBuilder();
            Integer userDefineDimCount = 0;
            boolean userDefineDimHandleFlag = false;
            ControlRuleAllotOrgPojo ruleAllotOrgPojo = new ControlRuleAllotOrgPojo();
            ruleAllotOrgPojo.setRuleId(Long.valueOf(rule.getLong("id")));
            ruleAllotOrgPojo.setEffectiveDate(rule.getDate("effectivedate"));
            ruleAllotOrgPojo.setInvalidDate(rule.getDate("invaliddate"));
            DynamicObjectCollection accounts = rule.getDynamicObjectCollection("accounts");
            DynamicObjectCollection userDefinedDimensions = rule.getDynamicObjectCollection("dimentions");
            if (rule.get("group") instanceof DynamicObject) {
                DynamicObject group = rule.getDynamicObject("group");
                if (group != null) {
                    groupId = group.getLong("id");
                }
            } else {
                groupId = rule.getLong("group");
            }
            if (IDUtils.isNotEmptyLong((Long)groupId).booleanValue()) {
                Object groupDim22;
                DynamicObject oboDim;
                DynamicObjectCollection groupDims = rule.getDynamicObjectCollection("groupdims");
                DynamicObjectCollection oboMemRanges = rule.getDynamicObjectCollection("obomemranges");
                ArrayList<Object> oboMemberRangePojos = new ArrayList<Object>(16);
                Iterator iterator = oboMemRanges.iterator();
                while (iterator.hasNext()) {
                    DynamicObject dynamicObject = (DynamicObject)iterator.next();
                    OboMemberRangePojo oboMemberRangePojo = new OboMemberRangePojo();
                    Long oboDimId = 0L;
                    if (dynamicObject.get("obodim") instanceof DynamicObject) {
                        oboDim = dynamicObject.getDynamicObject("obodim");
                        if (oboDim != null) {
                            oboDimId = oboDim.getLong("id");
                        }
                    } else {
                        oboDimId = dynamicObject.getLong("obodim");
                    }
                    Long oboMemberId = 0L;
                    if (dynamicObject.get("obomember") instanceof DynamicObject) {
                        DynamicObject oboMember = dynamicObject.getDynamicObject("obomember");
                        if (oboMember != null) {
                            oboMemberId = oboMember.getLong("id");
                        }
                    } else {
                        oboMemberId = dynamicObject.getLong("obomember");
                    }
                    String memRange = dynamicObject.getString("memrange");
                    oboMemberRangePojo.setOboDim(oboDimId);
                    oboMemberRangePojo.setOboMember(oboMemberId);
                    oboMemberRangePojo.setMemRange(memRange);
                    oboMemberRangePojos.add(oboMemberRangePojo);
                }
                Map<Long, List<OboMemberRangePojo>> oboMemberRangesMap = oboMemberRangePojos.stream().collect(Collectors.groupingBy(OboMemberRangePojo::getOboDim));
                Long l = 0L;
                for (Object groupDim22 : groupDims) {
                    void var23_30;
                    if (!groupDim22.getBoolean("isobodim")) continue;
                    if (groupDim22.get("groupdim") instanceof DynamicObject) {
                        oboDim = groupDim22.getDynamicObject("groupdim");
                        if (oboDim != null) {
                            Long l2 = oboDim.getLong("id");
                        }
                    } else {
                        Long l3 = groupDim22.getLong("groupdim");
                    }
                    if (oboMemberRangesMap.containsKey(var23_30)) continue;
                    ruleAllotOrgPojo.getAllMemberDimIds().add(var23_30);
                }
                groupDim22 = oboMemberRangesMap.entrySet().iterator();
                while (groupDim22.hasNext()) {
                    Map.Entry entry = (Map.Entry)groupDim22.next();
                    Long dimId = (Long)entry.getKey();
                    List rangePojos = (List)entry.getValue();
                    Dimension dimension = modelcache.getDimension(dimId);
                    String[] view = modelcache.getViewByBusModelAndDimNumber(bussModelId, dimension.getNumber());
                    Set oboMemberSet = ruleAllotOrgPojo.getNoOblMembers().computeIfAbsent(dimId, f -> new HashSet(16));
                    for (OboMemberRangePojo oboMemberRangePojo : rangePojos) {
                        List childrens;
                        Member member = modelcache.getMember(dimension.getNumber(), (Long)view, oboMemberRangePojo.getOboMember());
                        if (member == null || (childrens = modelcache.getMember(dimension.getNumber(), (Long)view, member.getNumber(), RangeEnum.getRangeByVal((int)Integer.parseInt(oboMemberRangePojo.getMemRange())).getIndex())) == null) continue;
                        oboMemberSet.addAll(childrens.stream().map(BaseCache::getId).collect(Collectors.toSet()));
                    }
                }
                ruleAllotOrgPojo.setOblMembers(new ArrayList(userDefinedDimensions.size()));
                for (DynamicObject userDefinedDimension : userDefinedDimensions) {
                    Set ruleMemberSet;
                    ruleMemberMap.clear();
                    if (userDefinedDimension.get("groupaccount") != null) {
                        Long groupAccount = userDefinedDimension.get("groupaccount") instanceof DynamicObject ? Long.valueOf(userDefinedDimension.getLong("groupaccount.id")) : Long.valueOf(userDefinedDimension.getLong("groupaccount"));
                        ruleMemberSet = ruleMemberMap.computeIfAbsent(accountId, f -> new HashSet(16));
                        if (IDUtils.isNotEmptyLong((Long)groupAccount).booleanValue()) {
                            ruleMemberSet.add(groupAccount);
                        }
                    } else {
                        ruleMemberSet = ruleMemberMap.computeIfAbsent(accountId, f -> new HashSet(16));
                        ControlRuleHelper.addAccountMembers(accounts, ruleMemberSet);
                    }
                    for (String arr : arrs) {
                        String index = arr.replace("userdefined", "");
                        Long controlDimId = controlDimMap.get(Integer.valueOf(index));
                        if (IDUtils.isEmptyLong((Long)controlDimId).booleanValue()) {
                            if (userDefineDimHandleFlag) continue;
                            userDefineDimComposeSb.append('0').append(',');
                            continue;
                        }
                        ruleMemberSet = ruleMemberMap.computeIfAbsent(controlDimId, f -> new HashSet(16));
                        userDefineDimCount = ControlRuleHelper.handleUserDefineMember(userDefineDimComposeSb, userDefineDimCount, userDefineDimHandleFlag, ruleMemberSet, userDefinedDimension, controlDimId);
                        if (!CollectionUtils.isEmpty((Collection)ruleMemberSet)) continue;
                        ruleMemberMap.remove(controlDimId);
                        if (userDefineDimHandleFlag) continue;
                        if (oboMemberRangesMap.containsKey(controlDimId) || ruleAllotOrgPojo.getAllMemberDimIds().contains(controlDimId)) {
                            userDefineDimComposeSb.append('1').append(',');
                            Integer n = userDefineDimCount;
                            Integer n2 = userDefineDimCount = Integer.valueOf(userDefineDimCount + 1);
                            continue;
                        }
                        userDefineDimComposeSb.append('0').append(',');
                    }
                    if (!ruleMemberMap.isEmpty()) {
                        Long[] oblDimIds = ruleAllotOrgPojo.getOblDimIds();
                        if (oblDimIds == null) {
                            oblDimIds = ruleMemberMap.keySet().toArray(new Long[0]);
                            ruleAllotOrgPojo.setOblDimIds(oblDimIds);
                        }
                        Long[] oblMemberIds = new Long[oblDimIds.length];
                        for (int o = 0; o < oblDimIds.length; ++o) {
                            oblMemberIds[o] = (Long)((Set)ruleMemberMap.get(oblDimIds[o])).iterator().next();
                        }
                        ruleAllotOrgPojo.getOblMembers().add(oblMemberIds);
                    }
                    userDefineDimHandleFlag = true;
                }
            } else {
                ruleMemberMap.clear();
                Set ruleMemberSet = ruleMemberMap.computeIfAbsent(accountId, f -> new HashSet(16));
                ControlRuleHelper.addAccountMembers(accounts, ruleMemberSet);
                for (DynamicObject userDefinedDimension : userDefinedDimensions) {
                    for (String arr : arrs) {
                        String index = arr.replace("userdefined", "");
                        Long controlDimId = controlDimMap.get(Integer.valueOf(index));
                        if (IDUtils.isEmptyLong((Long)controlDimId).booleanValue()) {
                            if (userDefineDimHandleFlag) continue;
                            userDefineDimComposeSb.append('0').append(',');
                            continue;
                        }
                        ruleMemberSet = ruleMemberMap.computeIfAbsent(controlDimId, f -> new HashSet(16));
                        userDefineDimCount = ControlRuleHelper.handleUserDefineMember(userDefineDimComposeSb, userDefineDimCount, userDefineDimHandleFlag, ruleMemberSet, userDefinedDimension, controlDimId);
                        if (!CollectionUtils.isEmpty((Collection)ruleMemberSet)) continue;
                        ruleMemberMap.remove(controlDimId);
                        if (userDefineDimHandleFlag) continue;
                        userDefineDimComposeSb.append('0').append(',');
                    }
                    userDefineDimHandleFlag = true;
                }
                ruleAllotOrgPojo.getNoOblMembers().putAll(ruleMemberMap);
            }
            ruleAllotOrgPojo.setUserDefineDimCompose(userDefineDimComposeSb.toString());
            ruleAllotOrgPojo.setUserDefineDimCount(userDefineDimCount);
            HashMap<Long, Map> ruleDimMembersIndexMap = new HashMap<Long, Map>(16);
            if (ruleAllotOrgPojo.getOblMembers() != null) {
                for (int i = 0; i < ruleAllotOrgPojo.getOblMembers().size(); ++i) {
                    Long[] longArray = (Long[])ruleAllotOrgPojo.getOblMembers().get(i);
                    for (int o = 0; o < longArray.length; ++o) {
                        Long dimId = ruleAllotOrgPojo.getOblDimIds()[o];
                        Map ruleMembersIndexMap = ruleDimMembersIndexMap.computeIfAbsent(dimId, f -> new HashMap(16));
                        Set indexSet = ruleMembersIndexMap.computeIfAbsent(longArray[o], f -> new HashSet(16));
                        indexSet.add(i);
                    }
                }
            }
            int max = 0;
            Long l = 0L;
            for (Long controlDimId : controlDimMap.values()) {
                if (ruleDimMembersIndexMap.get(controlDimId) == null || ((Map)ruleDimMembersIndexMap.get(controlDimId)).size() <= max) continue;
                max = ((Map)ruleDimMembersIndexMap.get(controlDimId)).size();
                Long l4 = controlDimId;
            }
            ruleAllotOrgPojo.setMaxNoOblDimCount(Integer.valueOf(max));
            ruleAllotOrgPojo.setMaxCountNoOblDimId((Long)var23_26);
            ruleAllotOrgPojo.setOblIndex(ruleDimMembersIndexMap);
            ruleAllotOrgPojos.add(ruleAllotOrgPojo);
        }
        return ruleAllotOrgPojos;
    }

    private static Integer handleUserDefineMember(StringBuilder userDefineDimComposeSb, Integer userDefineDimCount, boolean userDefineDimDealFlag, Set<Long> ruleMemberSet, DynamicObject userDefinedDimension, Long controlDimId) {
        for (int i = 1; i <= 7; ++i) {
            Long userDimId;
            if (!(userDefinedDimension.get("userdefineddimid" + i) instanceof Long) || !(userDimId = Long.valueOf(userDefinedDimension.getLong("userdefineddimid" + i))).equals(controlDimId)) continue;
            long userDefinedMemberId = userDefinedDimension.get("userdefined" + i) instanceof DynamicObject ? userDefinedDimension.getLong("userdefined" + i + ".id") : userDefinedDimension.getLong("userdefined" + i);
            if (!IDUtils.isNotEmptyLong((Long)userDefinedMemberId).booleanValue()) break;
            if (!userDefineDimDealFlag) {
                userDefineDimComposeSb.append('1').append(',');
                Integer n = userDefineDimCount;
                Integer n2 = userDefineDimCount = Integer.valueOf(userDefineDimCount + 1);
            }
            ruleMemberSet.add(userDefinedMemberId);
            break;
        }
        return userDefineDimCount;
    }

    private static void addAccountMembers(DynamicObjectCollection accounts, Set<Long> ruleMemberSet) {
        ruleMemberSet.addAll(accounts.stream().map(e -> {
            if (e.get("account") instanceof DynamicObject) {
                return e.getLong("account.id");
            }
            return e.getLong("account");
        }).filter(IDUtils::isNotEmptyLong).collect(Collectors.toSet()));
    }

    public static boolean dateOverlap(SimpleDateFormat sdf, Date newEffectiveDate, Date newInvalidDate, Date oldEffectiveDate, Date oldInvalidDate) {
        try {
            newEffectiveDate = newEffectiveDate == null ? sdf.parse("1970-01-01") : sdf.parse(sdf.format(newEffectiveDate));
            newInvalidDate = newInvalidDate == null ? sdf.parse("2300-01-01") : sdf.parse(sdf.format(newInvalidDate));
            oldEffectiveDate = oldEffectiveDate == null ? sdf.parse("1970-01-01") : sdf.parse(sdf.format(oldEffectiveDate));
            oldInvalidDate = oldInvalidDate == null ? sdf.parse("2300-01-01") : sdf.parse(sdf.format(oldInvalidDate));
            return newEffectiveDate.compareTo(oldInvalidDate) <= 0 && oldEffectiveDate.compareTo(newInvalidDate) <= 0;
        }
        catch (ParseException e) {
            log.error(e.toString());
            return false;
        }
    }

    public static List<Long> getGroupRuleGroupDimIdList(Long ruleId) {
        ArrayList<Long> groupDimIdList = new ArrayList<Long>(16);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)ruleId, (String)"eb_bgcontrolrulemain");
        if (dynamicObject == null) {
            return groupDimIdList;
        }
        DynamicObjectCollection groupDims = dynamicObject.getDynamicObjectCollection("groupdims");
        for (DynamicObject groupDim : groupDims) {
            if (groupDim.getDynamicObject("groupdim") == null) continue;
            groupDimIdList.add(groupDim.getDynamicObject("groupdim").getLong("id"));
        }
        return groupDimIdList;
    }
}

