/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.formplugin.utils.SingleMemberF7Util;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;

public class ControlVersionEditPlugin
extends AbstractBasePlugin
implements SingleMemberF7Util.ISingleMemberF7Handle,
BeforeF7SelectListener {
    public static final List<String> DIM_KEYS = Lists.newArrayList((Object[])new String[]{"scenario", "version", "datatype", "audittrail", "changetype"});

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        BasedataEdit bussmodel;
        super.registerListener(e);
        this.addClickListeners(new String[]{"button_ok"});
        TextEdit orgrange = (TextEdit)this.getControl("orgrange");
        orgrange.addClickListener((ClickListener)this);
        BasedataEdit base = (BasedataEdit)this.getControl(this.getModelSign());
        if (base != null) {
            base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bussmodel = (BasedataEdit)this.getControl("bussmodel")) != null) {
            bussmodel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        for (String key : DIM_KEYS) {
            BasedataEdit ba = (BasedataEdit)this.getControl(key);
            if (ba == null) continue;
            ba.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Long model = (Long)PluginUtils.getCustomParams(this.getView(), "KEY_MODEL_ID");
        this.getModel().setValue(this.getModelSign(), (Object)model);
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) {
            this.getModel().setDataChanged(false);
        }
        this.setDTAndATVisible();
    }

    public void afterBindData(EventObject e) {
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) {
            this.getModel().setDataChanged(false);
            boolean isExit = CommonUtils.hasBusinessModel((Long)this.getModelId()) != false ? BgControlUtils.hasBgControlRecord((Long)this.getModelId(), (Long)this.getBussModelId()) : BgControlUtils.hasEbBgControlRecord((Long)this.getModelId());
            if (isExit) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"bussmodel"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"model"});
            }
        }
        this.setDTAndATVisible();
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("button_ok".equals(key)) {
            // empty if block
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("button_ok".equals(key)) {
            this.saveData();
        }
    }

    private void saveData() {
        DynamicObject newobj;
        IDataModel dot = this.getModel();
        Date effectiveTime = (Date)dot.getValue("effectivetime");
        Date invalidTime = (Date)dot.getValue("invalidtime");
        BaseShowParameter base = (BaseShowParameter)this.getView().getFormShowParameter();
        BillOperationStatus billstatus = base.getBillStatus();
        boolean isinvalidtime = this.isInValidtime();
        if (isinvalidtime) {
            return;
        }
        if (BillOperationStatus.ADDNEW.equals((Object)billstatus)) {
            newobj = BusinessDataServiceHelper.newDynamicObject((String)"eb_controlversion");
            Long pkId = GlobalIdUtil.genGlobalLongId();
            newobj.set("id", (Object)pkId);
            base.setPkId((Object)pkId);
            this.checkEdit(effectiveTime, invalidTime, null);
        } else {
            newobj = BusinessDataServiceHelper.loadSingle((Object)base.getPkId(), (String)"eb_controlversion");
            this.checkEdit(effectiveTime, invalidTime, newobj);
        }
        this.initScenVersionModel(newobj);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newobj});
        OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, null, (MultiLangEnumBridge)new MultiLangEnumBridge("\u4fdd\u5b58", "ControlVersionEditPlugin_0", "epm-eb-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f", "ControlVersionEditPlugin_1", "epm-eb-formplugin"), null);
        CacheServiceHelper.clearCacheByScenVer();
        QFilter qFilter = this.getQFilter();
        List<String> messages = this.checkOtherDate(qFilter);
        if (CollectionUtils.isNotEmpty(messages)) {
            this.getView().returnDataToParent(messages);
        } else {
            this.getView().returnDataToParent((Object)"success");
        }
        this.getView().getParentView().setReturnData((Object)"success");
        this.getView().close();
    }

    private boolean isInValidtime() {
        String clearinvalidtime = this.getPageCache().get("clearinvalidtime");
        boolean isinvalidtime = clearinvalidtime != null && System.currentTimeMillis() - Long.parseLong(clearinvalidtime) < 300L;
        return isinvalidtime;
    }

    @Override
    public void beforeSingleMemberF7Select(BeforeF7SelectEvent e) {
        if (DIM_KEYS.contains(e.getProperty().getName()) && this.checkModelNull()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ControlVersionEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private List<String> checkOtherDate(QFilter qFilter) {
        Set modelIds = ModelUtil.getModelIds((IFormView)this.getView().getParentView(), (boolean)false);
        QFilter modelQf = new QFilter("model", "in", (Object)modelIds);
        qFilter.and(modelQf);
        DynamicObject[] query = BusinessDataServiceHelper.load((String)"eb_controlversion", (String)"id,model.id,model.name,bussmodel.id,bussmodel.name,version.name", (QFilter[])new QFilter[]{qFilter}, (String)"model.shownumber,bussmodel.number");
        ArrayList<String> messages = null;
        if (query != null && query.length > 0) {
            messages = new ArrayList<String>(query.length);
            for (DynamicObject dynamicObject : query) {
                if (ModelServiceHelper.isBGMDModel((Long)dynamicObject.getLong("model.id"))) {
                    messages.add(ResManager.loadResFormat((String)"\u4f53\u7cfb\u201c%1\u201d\u4e0b\u7684\u4e1a\u52a1\u6a21\u578b\u201c%2\u201d\u7684\u201c%3\u201d\u7248\u672c\u751f\u6548\u65f6\u95f4\u6bb5\u91cd\u5408\u3002", (String)"ControlVersionEditPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[]{dynamicObject.getString("model.name"), dynamicObject.getString("bussmodel.name"), dynamicObject.getString("version.name")}) + "\r\n");
                    continue;
                }
                messages.add(ResManager.loadResFormat((String)"\u4f53\u7cfb\u201c%1\u201d\u4e0b\u7684\u201c%2\u201d\u7248\u672c\u751f\u6548\u65f6\u95f4\u6bb5\u91cd\u5408\u3002", (String)"ControlVersionEditPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[]{dynamicObject.getString("model.name"), dynamicObject.getString("version.name")}) + "\r\n");
            }
        }
        return messages;
    }

    private QFilter getQFilter() {
        Date effectiveTime = (Date)this.getModel().getValue("effectivetime");
        Date invalidTime = (Date)this.getModel().getValue("invalidtime");
        BaseShowParameter base = (BaseShowParameter)this.getView().getFormShowParameter();
        BillOperationStatus billstatus = base.getBillStatus();
        QFilter qFilter = null;
        QFilter qf1 = null;
        if (invalidTime != null) {
            qf1 = new QFilter("effectivetime", "<=", (Object)invalidTime);
            qf1.and(new QFilter("invalidtime", ">=", (Object)effectiveTime));
            QFilter qf2 = new QFilter("invalidtime", "is null", null);
            qf2.and(new QFilter("effectivetime", "<=", (Object)invalidTime));
            qf1.or(qf2);
        } else {
            qf1 = new QFilter("invalidtime", "is null", null);
            QFilter qf2 = new QFilter("invalidtime", ">=", (Object)effectiveTime);
            qf1.or(qf2);
        }
        qFilter = new QFilter("id", "!=", base.getPkId());
        qFilter.and(qf1);
        return qFilter;
    }

    private void initScenVersionModel(DynamicObject newobj) {
        IDataModel datamodel = this.getModel();
        newobj.set("model", datamodel.getValue("model"));
        newobj.set("scenario", datamodel.getValue("scenario"));
        newobj.set("version", datamodel.getValue("version"));
        newobj.set("datatype", datamodel.getValue("datatype"));
        newobj.set("audittrail", datamodel.getValue("audittrail"));
        newobj.set("changetype", datamodel.getValue("changetype"));
        newobj.set("effectivetime", datamodel.getValue("effectivetime"));
        if (datamodel.getValue("invalidtime") instanceof Date) {
            Calendar endTime = Calendar.getInstance();
            endTime.setTime((Date)datamodel.getValue("invalidtime"));
            endTime.set(11, 23);
            endTime.set(12, 59);
            endTime.set(13, 59);
            newobj.set("invalidtime", (Object)endTime.getTime());
        } else {
            newobj.set("invalidtime", datamodel.getValue("invalidtime"));
        }
        newobj.set("discription", datamodel.getValue("discription"));
        newobj.set("acversion", datamodel.getValue("acversion"));
        newobj.set("orgrange", datamodel.getValue("orgrange"));
        newobj.set("state", datamodel.getValue("state"));
        newobj.set("bussmodel", datamodel.getValue("bussmodel"));
        String userid = RequestContext.getOrCreate().getUserId();
        Date nowtime = TimeServiceHelper.now();
        newobj.set("creator", (Object)userid);
        newobj.set("modifier", (Object)userid);
        newobj.set("createtime", (Object)nowtime);
        newobj.set("modifiertime", (Object)nowtime);
    }

    private void checkEdit(Date effectivetime, Date invalidtime, DynamicObject dynamicObject) {
        Long modelId = this.getModelId();
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        String errMsg = null;
        if (this.isBGMD(modelId).booleanValue()) {
            qFilter.and(new QFilter("bussmodel", "=", (Object)this.getBussModelId()));
            errMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u76f8\u540c\u4f53\u7cfb\u7684\u540c\u4e00\u4e1a\u52a1\u6a21\u578b\u5b58\u5728\u76f8\u540c\u751f\u6548\u65f6\u6bb5\u3002", (String)"ControlVersionEditPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        } else {
            errMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u76f8\u540c\u4f53\u7cfb\u5b58\u5728\u76f8\u540c\u751f\u6548\u65f6\u6bb5\u3002", (String)"ControlVersionEditPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        DynamicObjectCollection dotcollection = QueryServiceHelper.query((String)"eb_controlversion", (String)"id,effectivetime,invalidtime,model.name,model.shownumber", (QFilter[])new QFilter[]{qFilter}, (String)"effectivetime");
        for (DynamicObject doc : dotcollection) {
            if (dynamicObject != null && doc.get("id").toString().equals(dynamicObject.get("id").toString())) continue;
            Date docEffectivetime = doc.getDate("effectivetime");
            Date docInvalidtime = doc.getDate("invalidtime");
            if (effectivetime.after(docEffectivetime)) {
                if (docInvalidtime == null) {
                    Calendar calendareff = Calendar.getInstance();
                    calendareff.setTime(effectivetime);
                    calendareff.setTimeInMillis(calendareff.getTimeInMillis() - 1000L);
                    Calendar calendarmodi = Calendar.getInstance();
                    calendarmodi.setTime((Date)this.getModel().getValue("createtime"));
                    calendarmodi.setTimeInMillis(calendarmodi.getTimeInMillis() - 1000L);
                    DynamicObject sDoc = BusinessDataServiceHelper.loadSingle((Object)doc.getLong("id"), (String)"eb_controlversion");
                    sDoc.set("invalidtime", (Object)calendareff.getTime());
                    sDoc.set("modifiertime", (Object)calendarmodi.getTime());
                    sDoc.set("modifier", (Object)UserUtils.getUserId());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sDoc});
                    OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, null, (MultiLangEnumBridge)new MultiLangEnumBridge("\u4fdd\u5b58", "ControlVersionEditPlugin_0", "epm-eb-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f", "ControlVersionEditPlugin_1", "epm-eb-formplugin"), null);
                    continue;
                }
                if (effectivetime.after(docInvalidtime)) continue;
                throw new KDBizException(errMsg);
            }
            if (effectivetime.compareTo(docEffectivetime) == 0) {
                throw new KDBizException(errMsg);
            }
            if (invalidtime == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u7684\u751f\u6548\u65f6\u95f4\u5728\u5df2\u6709\u8bb0\u5f55\u751f\u6548\u65e5\u671f\u524d\u9762\uff0c\u56e0\u6b64\u5fc5\u987b\u8bbe\u7f6e\u5931\u6548\u65e5\u671f\u3002", (String)"ControlVersionEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (invalidtime.before(docEffectivetime)) continue;
            throw new KDBizException(errMsg);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if (key.equals(this.getModelSign())) {
            if (StringUtils.isNotEmpty((String)this.getModelSign()) && this.getControl(this.getModelSign()) != null) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(this.getModelSign())).getQFilters();
                if (qFilterList == null) {
                    qFilterList = new ArrayList<QFilter>(16);
                }
                Set modelIds = new HashSet(16);
                if (this.getView().getFormShowParameter().getStatus().getValue() == OperationStatus.ADDNEW.getValue()) {
                    modelIds = ModelUtil.getModelIdsWithPermItem((String)"eb_versioncontrollist", (ApplicationTypeEnum)ModelUtil.queryApp((IFormView)this.getView().getParentView()), (String)"47156aff000000ac");
                } else if (this.getView().getFormShowParameter().getStatus().getValue() == OperationStatus.EDIT.getValue()) {
                    modelIds = ModelUtil.getModelIdsWithPermItem((String)"eb_versioncontrollist", (ApplicationTypeEnum)ModelUtil.queryApp((IFormView)this.getView().getParentView()), (String)"4715a0df000000ac");
                }
                qFilterList.add(new QFilter("id", "in", modelIds));
                showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
                NewF7Utils.dealSelectRows((ListShowParameter)showParameter, (BeforeF7SelectEvent)beforeF7SelectEvent);
            }
        } else if (DIM_KEYS.contains(key)) {
            DynamicObject modelObj = (DynamicObject)this.getModel().getValue(this.getModelSign());
            if (modelObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AnalyzeListSet_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Long modelId = modelObj.getLong("id");
            String dimNumber = NewF7Utils.getDimNumber((String)key);
            if (dimNumber != null) {
                MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
                f7Param.setOnlySelLeaf(true);
                f7Param.setCanSelectRoot(false);
                if (this.isBGMD(this.getModelId()).booleanValue()) {
                    f7Param.setBusModelId(this.getBussModelId());
                }
                if (SysDimensionEnum.DataType.getNumber().equalsIgnoreCase(key)) {
                    f7Param.addCustomFilter(new QFilter("number", "not in", (Object)new String[]{"Actual"}));
                } else if (SysDimensionEnum.Version.getNumber().equalsIgnoreCase(key)) {
                    f7Param.addCustomFilter(new QFilter("number", "not in", (Object)new String[]{"ACTUAL"}));
                } else if (SysDimensionEnum.AuditTrail.getNumber().equalsIgnoreCase(key)) {
                    f7Param.setOnlySelLeaf(false);
                }
                NewF7Utils.openF7((BeforeF7SelectEvent)beforeF7SelectEvent, (MemberF7Parameter)f7Param);
            }
        } else if ("bussmodel".equals(key)) {
            DynamicObject model;
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl("bussmodel")).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>(16);
            }
            if ((model = (DynamicObject)this.getModel().getValue(this.getModelSign())) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AnalyzeListSet_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            qFilterList.add(new QFilter("model", "=", (Object)model.getLong("id")));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            NewF7Utils.dealSelectRows((ListShowParameter)showParameter, (BeforeF7SelectEvent)beforeF7SelectEvent);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (oldValue instanceof DynamicObject && oldValue != null && newValue != null && ((DynamicObject)oldValue).getLong("id") == ((DynamicObject)newValue).getLong("id")) {
            return;
        }
        ArrayList<String> updatekeys = new ArrayList<String>(16);
        switch (key) {
            case "version": {
                DynamicObject model = (DynamicObject)this.getModel().getValue("model");
                QFBuilder builder = new QFBuilder();
                builder.add(new QFilter("model", "=", (Object)model.getLong("id")));
                builder.add(new QFilter("number", "=", (Object)"ACTUAL"));
                DynamicObject actual = QueryServiceHelper.queryOne((String)SysDimensionEnum.Version.getMemberTreemodel(), (String)"id,number,name", (QFilter[])builder.toArrays());
                if (actual == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u201c\u7248\u672c\u201d\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ControlVersionEditPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                this.getModel().setValue("acversion", (Object)actual.getLong("id"));
                break;
            }
            case "effectivetime": {
                updatekeys.add("invalidtime");
                this.updateValueForNull(updatekeys);
                break;
            }
            case "invalidtime": {
                this.checkDate();
                break;
            }
            case "model": {
                this.setDTAndATVisible();
                updatekeys.addAll(Lists.newArrayList((Object[])new String[]{"bussmodel", "version", "effectivetime", "invalidtime", "orgrange", "scenario"}));
                this.updateValueForNull(updatekeys);
                this.setNewEbBussModel(this.getModelId());
                break;
            }
        }
        this.getModel().setDataChanged(false);
    }

    private void checkDate() {
        Object effObj = this.getModel().getValue("effectivetime");
        if (effObj == null) {
            this.updateValueForNull(Lists.newArrayList((Object[])new String[]{"invalidtime"}));
        } else {
            Object invaobj = this.getModel().getValue("invalidtime");
            if (invaobj != null && ((Date)invaobj).before((Date)effObj)) {
                boolean isinvalidtime = this.isInValidtime();
                if (!isinvalidtime) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"ControlVersionEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                this.updateValueForNull(Lists.newArrayList((Object[])new String[]{"invalidtime"}));
                this.getPageCache().put("clearinvalidtime", String.valueOf(System.currentTimeMillis()));
            }
        }
    }

    private void updateValueForNull(List<String> keys) {
        this.getModel().beginInit();
        for (String key : keys) {
            this.getModel().setValue(key, null);
            this.getView().updateView(key);
        }
        this.getModel().endInit();
    }

    private boolean checkModelNull() {
        return this.getModel().getValue(this.getModelSign()) == null;
    }

    public String getModelSign() {
        return "model";
    }

    @Override
    public Long getModelId() {
        DynamicObject model = (DynamicObject)this.getModel().getValue(this.getModelSign());
        if (model != null) {
            return model.getLong("id");
        }
        return 0L;
    }

    public String getCurrentDimNumber(String controlKey) {
        if ("datatype".equals(controlKey)) {
            return SysDimensionEnum.DataType.getNumber();
        }
        if ("audittrail".equals(controlKey)) {
            return SysDimensionEnum.AuditTrail.getNumber();
        }
        if ("changetype".equals(controlKey)) {
            return SysDimensionEnum.ChangeType.getNumber();
        }
        return SysDimensionEnum.Version.getNumber();
    }

    private void setDTAndATVisible() {
        DynamicObject modelObj = (DynamicObject)this.getModel().getValue("model");
        if (modelObj == null) {
            return;
        }
        boolean bgModel = ModelUtil.isBGModel((Long)modelObj.getLong("id"));
        if (this.isBGMD(modelObj.getLong("id")).booleanValue() || bgModel) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"datatype", "audittrail", "changetype", "bussmodel"});
            if (bgModel) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bussmodel"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"datatype", "audittrail", "changetype", "bussmodel"});
        }
    }

    private void setNewEbBussModel(Long modelId) {
        DynamicObjectCollection query;
        if (NewEbAppUtil.isNewEbModel((Long)modelId) && (query = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)})) != null && !query.isEmpty()) {
            this.getModel().setValue("bussmodel", (Object)((DynamicObject)query.get(0)).getLong("id"));
        }
    }

    private Boolean isBGMD(Long modelId) {
        DynamicObject model = ModelUtils.getModel((Long)modelId);
        String reportType = model.getString("reporttype");
        return ApplicationTypeEnum.isBGMD((String)reportType);
    }

    private Long getBussModelId() {
        Object bussmodel = this.getModel().getValue("bussmodel");
        if (bussmodel != null) {
            return ((DynamicObject)bussmodel).getLong("id");
        }
        return 0L;
    }

    public String getBizCtrlRangeKey() {
        return "bussmodel";
    }
}

