/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.control.ControlModelFuzzySearchCommon;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class ControlVersionListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener,
BasedataFuzzySearchListener {
    public static final String BTN_ADD = "baritem_add";
    public static final String BTN_ALTER = "baritem_alter";
    public static final String BTN_DEL = "baritem_delete";
    public static final String BTN_REFRESH = "baritem_refresh";
    public static final String CLOSEREFRESHKEY = "closerefreshkey";
    public static final String BUSSMODEL = "bussmodel";
    public static final String DELETE = "delete";
    public static final String CACHE_ITEM_KEY = "cache_itemKey";

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.getView().addCustomControls(new String[]{"model"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.reFreshBillList();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        this.getPageCache().put(CACHE_ITEM_KEY, evt.getItemKey());
        super.beforeItemClick(evt);
        this.getPageCache().remove(CACHE_ITEM_KEY);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "baritem_add": {
                this.showAddForm(0L, BgControlUtils.getAddNewPermissionIncludeUserSelectModelId((String)"eb_versioncontrollist", (IFormView)this.getView()));
                break;
            }
            case "baritem_alter": {
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection rows = billList.getSelectedRows();
                if (rows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"ControlVersionListPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (rows.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8bb0\u5f55\u8fdb\u884c\u4fee\u6539\u3002", (String)"ControlVersionListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showAddForm((Long)rows.get(0).getPrimaryKeyValue(), this.getModelId());
                break;
            }
            case "baritem_delete": {
                BillList billList01 = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection rows01 = billList01.getSelectedRows();
                if (rows01.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u884c\u3002", (String)"ControlVersionListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u9009\u62e9\u7684\u8bb0\u5f55\uff1f", (String)"ControlVersionListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE, (IFormPlugin)this));
                break;
            }
            case "baritem_refresh": {
                this.reFreshBillList();
                break;
            }
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList billList = (BillList)this.getControl("billlistap");
        Object focusRowPkId = billList.getFocusRowPkId();
        this.upgradeIntercept(this.getView(), "");
        DynamicObject doc = QueryServiceHelper.queryOne((String)"eb_controlversion", (String)"model.id", (QFilter[])new QFilter[]{new QFilter("id", "=", focusRowPkId)});
        String entityId = this.getView().getEntityId();
        int is = this.checkItemPermission(this.getUserId(), doc.getLong("model.id"), AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), entityId, "4715a0df000000ac");
        if (is == 0 && !MemberPermHelper.ifUserHasRootPermByModel((Long)this.getUserId(), (Long)doc.getLong("model.id"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"ControlVersionListPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.showAddForm((Long)focusRowPkId, this.getModelId());
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() != null) {
            this.reFreshBillList();
        }
        if (closedCallBackEvent.getActionId().equals(CLOSEREFRESHKEY) && closedCallBackEvent.getReturnData() instanceof List && CollectionUtils.isNotEmpty((Collection)((List)closedCallBackEvent.getReturnData()))) {
            List returnData = (List)closedCallBackEvent.getReturnData();
            String message = BgControlUtils.handleMessageList((String)"\u3001", (List)returnData);
            this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u522b\u7684\u4e1a\u52a1\u6a21\u578b\u7684\u9884\u7b97\u7248\u672c\u7684\u751f\u6548\u65f6\u95f4\u6bb5\u91cd\u5408\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"ControlVersionListPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]), message, MessageTypes.Default);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String confirmId = messageBoxClosedEvent.getCallBackId();
        if (DELETE.equals(confirmId) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.deteControlVersion();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
    }

    public void handleData(BasedataFuzzySearchEvent searchEvent) {
        ControlModelFuzzySearchCommon.getInstance().reWriteData(searchEvent);
    }

    public void setFilter(SetFilterEvent e) {
        BillList billList;
        if (e.getSource() instanceof BillList && "billlistap".equals((billList = (BillList)e.getSource()).getKey())) {
            Set modelIds = ModelUtil.getModelIds((IFormView)this.getView(), (boolean)false);
            e.getQFilters().add(new QFilter("model", "in", (Object)modelIds));
        }
    }

    @Override
    public Long getModelId() {
        Long modelId = 0L;
        BillList billList = (BillList)this.getControl("billlistap");
        Long id = (Long)billList.getFocusRowPkId();
        DynamicObject doc = QueryServiceHelper.queryOne((String)"eb_controlversion", (String)"model.id,bussmodel.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        modelId = BTN_ADD.equals(this.getPageCache().get(CACHE_ITEM_KEY)) || IDUtils.isEmptyLong((Long)id) != false || doc == null ? BgControlUtils.getAddNewPermissionIncludeUserSelectModelId((String)"eb_versioncontrollist", (IFormView)this.getView()) : Long.valueOf(doc.getLong("model.id"));
        return modelId;
    }

    public void deteControlVersion() {
        BillList billList01 = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows01 = billList01.getSelectedRows();
        int allNum = rows01.size();
        List<String> errorInfos = this.checkDelBillListByControlRecordExist(rows01);
        if (rows01.size() > 0) {
            try (TXHandle th = TX.required();){
                try {
                    QFilter idqfilter = new QFilter("id", "in", (Object)rows01.getPrimaryKeyValues());
                    DeleteServiceHelper.delete((String)"eb_controlversion", (QFilter[])new QFilter[]{idqfilter});
                    MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "ControlVersionListPlugin_3", "epm-eb-formplugin");
                    MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u7f16\u53f7\u201c%1$s\u201d\uff0c\u5220\u9664\u6210\u529f\u3002", "AbstractBasePlugin_15", "epm-eb-formplugin");
                    this.writeLog(null, DELETE, opName, opDescription, new String[]{StringUtils.join((Object[])rows01.getPrimaryKeyValues(), (String)",")});
                    CacheServiceHelper.clearCacheByScenVer();
                }
                catch (Exception e) {
                    th.markRollback();
                    MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "ControlVersionListPlugin_3", "epm-eb-formplugin");
                    MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u7f16\u53f7\u201c%1$s\u201d\uff0c\u5220\u9664\u5931\u8d25\u3002", "AbstractBasePlugin_16", "epm-eb-formplugin");
                    this.writeLog(null, DELETE, opName, opDescription, new String[]{StringUtils.join((Object[])rows01.getPrimaryKeyValues(), (String)",")});
                    throw new KDBizException(ResManager.loadResFormat((String)"\u5220\u9664\u5931\u8d25%1", (String)"ControlVersionListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{e.getMessage()}));
                }
            }
        }
        if ((errorInfos = errorInfos.stream().distinct().collect(Collectors.toList())).size() > 0) {
            int sussNum = rows01.size();
            int failNum = allNum - sussNum;
            String title = ResManager.loadResFormat((String)"\u5171%1\u5f20\u5355\u636e\uff0c\u6210\u529f%2\u6761\uff0c\u5931\u8d25%3\u6761", (String)"ControlVersionListPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[]{allNum, sussNum, failNum});
            CommonServiceHelper.showErrorInfoFormWithTitle((IFormView)this.getView(), errorInfos, (String)ResManager.loadKDString((String)"\u5220\u9664\u7ed3\u679c", (String)"ControlVersionListPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]), (String)title);
        }
        this.reFreshBillList();
    }

    @NotNull
    private List<String> checkDelBillListByControlRecordExist(ListSelectedRowCollection rows01) {
        ArrayList<String> errorInfos = new ArrayList<String>(16);
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"eb_controlversion", (String)"id,model.id,model.shownumber,model.name,bussmodel.id,bussmodel.number,bussmodel.name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)rows01.getPrimaryKeyValues())});
        if (docs != null && !docs.isEmpty()) {
            HashMap<String, Boolean> hasErrorMap = new HashMap<String, Boolean>(docs.size());
            for (DynamicObject doc : docs) {
                String key = doc.getString("model.shownumber") + "!" + doc.getString("bussmodel.number");
                boolean isError = hasErrorMap.computeIfAbsent(key, f -> false);
                if (isError) {
                    rows01.removeIf(e -> doc.getString("id").equals(IDUtils.toString((Object)e.getPrimaryKeyValue())));
                    continue;
                }
                long modelId = doc.getLong("model.id");
                Boolean hasBusinessModel = CommonUtils.hasBusinessModel((Long)modelId);
                if (hasBusinessModel.booleanValue()) {
                    long bussModelId = doc.getLong("bussmodel.id");
                    isError = BgControlUtils.hasBgControlRecord((Long)modelId, (Long)bussModelId);
                } else {
                    isError = BgControlUtils.hasEbBgControlRecord((Long)modelId);
                }
                if (!isError) continue;
                hasErrorMap.put(key, true);
                rows01.removeIf(e -> doc.getString("id").equals(IDUtils.toString((Object)e.getPrimaryKeyValue())));
                String modelName = doc.getString("model.name");
                String bussModelName = doc.getString("bussmodel.name");
                if (hasBusinessModel.booleanValue()) {
                    errorInfos.add(ResManager.loadResFormat((String)"\u4f53\u7cfb\u201c%1\u201d\u4e1a\u52a1\u6a21\u578b\u201c%2\u201d\u5df2\u5b58\u5728\u63a7\u5236\u8bb0\u5f55\uff0c\u65e0\u6cd5\u5220\u9664", (String)"ControlVersionListPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[]{modelName, bussModelName}));
                    continue;
                }
                errorInfos.add(ResManager.loadResFormat((String)"\u4f53\u7cfb\u201c%1\u201d\u5df2\u5b58\u5728\u63a7\u5236\u8bb0\u5f55\uff0c\u65e0\u6cd5\u5220\u9664", (String)"ControlVersionListPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[]{modelName}));
            }
        }
        return errorInfos;
    }

    private void reFreshBillList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
    }

    private void showAddForm(Long fpkid, Long modelId) {
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"ControlVersionListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter base = new BaseShowParameter();
        if (fpkid != 0L) {
            HashMap<String, Object> openParameter = new HashMap<String, Object>(16);
            openParameter.put("formId", "eb_controlversion");
            openParameter.put("pkId", String.valueOf(fpkid));
            openParameter.put("KEY_MODEL_ID", modelId);
            base = (BaseShowParameter)FormShowParameter.createFormShowParameter(openParameter);
            base.setPkId((Object)fpkid);
            base.setBillStatus(BillOperationStatus.EDIT);
            base.setCustomParam("model", (Object)modelId);
        } else {
            base.setBillStatus(BillOperationStatus.ADDNEW);
            base.setFormId("eb_controlversion");
            HashMap<String, Long> params = new HashMap<String, Long>(16);
            params.put("KEY_MODEL_ID", modelId);
            base.setCustomParams(params);
        }
        base.getOpenStyle().setShowType(ShowType.Modal);
        base.getOpenStyle().setTargetKey("_submaintab_");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CLOSEREFRESHKEY);
        base.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)base);
    }

    public String getModelFieldKey() {
        return "model";
    }

    @Override
    protected void addColumnKeysToHide(Set<String> colsToHide) {
        super.addColumnKeysToHide(colsToHide);
    }
}

