/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.ObjectSerializer;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.utils.BgMemMappingServiceHelper;
import kd.epm.eb.control.utils.BgMemberMapHisUtils;
import kd.epm.eb.formplugin.utils.PluginUtils;

public class DimMemberHistoryPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String IMPORT_HISTORY = "importhistory";
    private static final String DIM_NUMBER = "dimnumber";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{DIM_NUMBER});
        this.addItemClickListeners(new String[]{"toolbar"});
        BasedataEdit userEdit = (BasedataEdit)this.getControl("members");
        userEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refresh();
    }

    protected DynamicObject getDimension() {
        DynamicObject dimension = null;
        JSONObject model = (JSONObject)PluginUtils.getCustomParams(this.getView(), "MODEL");
        if (model != null) {
            this.getPageCache().put("KEY_MODEL_ID", model.getString("id"));
            String dimJson = this.getPageCache().get("CACHE_DIMENSION");
            if (StringUtils.isNotEmpty((String)dimJson)) {
                dimension = ObjectSerializer.decoded((String)dimJson);
            } else {
                String dimNumber = (String)PluginUtils.getCustomParams(this.getView(), "DIMENSION");
                if (StringUtils.isNotEmpty((String)dimNumber)) {
                    QFBuilder builder = new QFBuilder();
                    builder.add(new QFilter("model", "=", (Object)Long.valueOf(model.getString("id"))));
                    builder.add(new QFilter("number", "=", (Object)dimNumber));
                    dimension = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_dimension", (QFilter[])builder.toArrays());
                    if (dimension != null) {
                        this.getPageCache().put("CACHE_DIMENSION", ObjectSerializer.encoded((DynamicObject)dimension));
                        this.getPageCache().put("CACHE_DIMENSION_ID", dimension.getString("id"));
                        this.getPageCache().put("CACHE_DIMENSION_NUMBER", dimension.getString("number"));
                    }
                }
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4f53\u7cfb", (String)"DimMemberHistoryPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return dimension;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            MainEntityType type = (MainEntityType)e.getOriginalEntityType().clone();
            DynamicObject dimension = this.getDimension();
            if (dimension != null) {
                BasedataProp prop = (BasedataProp)((EntityType)type.getAllEntities().get("entryentity")).getProperty("members");
                prop.setBaseEntityId(dimension.getString("membermodel"));
                prop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)prop.getBaseEntityId()));
            }
            e.setNewEntityType(type);
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "importhistory": {
                this.importHistory();
                break;
            }
            case "btn_refresh": {
                this.refresh();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        Object obj = e.getSource();
        if (obj instanceof BasedataEdit && "members".equals(key = ((BasedataEdit)obj).getKey())) {
            this.beforeF7Select_member(e);
        }
    }

    protected void beforeF7Select_member(BeforeF7SelectEvent e) {
        BasedataEdit edit = (BasedataEdit)e.getSource();
        edit.setF7BatchFill(false);
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        ArrayList<QFilter> filters = edit.getQFilters();
        if (filters == null) {
            filters = new ArrayList<QFilter>(16);
        }
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        String dimensionId = this.getPageCache().get("CACHE_DIMENSION_ID");
        String dimensionNumber = this.getPageCache().get("CACHE_DIMENSION_NUMBER");
        if (StringUtils.isNotEmpty((String)modelId) && StringUtils.isNotEmpty((String)dimensionId)) {
            filters.add(new QFilter("model", "=", (Object)Long.valueOf(modelId)));
            filters.add(new QFilter("dimension", "=", (Object)Long.valueOf(dimensionId)));
        } else {
            filters.add(new QFilter("model", "=", (Object)SqlBatchUtils.noFindId));
            filters.add(new QFilter("dimension", "=", (Object)SqlBatchUtils.noFindId));
        }
        if (SysDimensionEnum.Entity.getNumber().equals(dimensionNumber)) {
            filters.add(new QFilter("number", "!=", (Object)"RatePreset"));
        }
        showParameter.setListFilterParameter(new ListFilterParameter(filters, "longnumber"));
    }

    public void importHistory() {
        String _mappingId = (String)PluginUtils.getCustomParams(this.getView(), "MAPPING_ID");
        if (StringUtils.isEmpty((String)_mappingId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u8bb0\u5f55\u3002", (String)"DimMemberHistoryPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long mappingId = Long.valueOf(_mappingId);
        String businessData = (String)PluginUtils.getCustomParams(this.getView(), "BUSINESSDATABASE");
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        if (entry != null) {
            int[] rows = entry.getSelectRows();
            if (rows == null || rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bfc\u5165\u7684\u6570\u636e\u3002", (String)"DimMemberHistoryPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                DynamicObjectCollection history = this.getModel().getEntryEntity("entryentity");
                if (this.verify(entry, history, rows)) {
                    boolean re = BgMemberMapHisUtils.importHistory((Long)mappingId, (String)businessData, (DynamicObjectCollection)history, (int[])rows);
                    if (re) {
                        this.refresh();
                    }
                    BgMemMappingServiceHelper.clearCacheByMapping((Long)mappingId);
                }
            }
        }
    }

    protected boolean verify(EntryGrid entry, DynamicObjectCollection historys, int[] rows) {
        boolean re = false;
        if (entry == null || historys == null || historys.isEmpty() || rows == null || rows.length == 0) {
            return re;
        }
        re = true;
        DynamicObject history = null;
        int in = rows.length;
        for (int i = 0; i < in; ++i) {
            history = (DynamicObject)historys.get(rows[i]);
            if (history != null && history.get("members") != null) continue;
            re = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bfc\u5165\u7684\u7ef4\u5ea6\u6210\u5458\u3002", (String)"DimMemberHistoryPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            entry.selectRows(rows[i]);
        }
        return re;
    }

    public void refresh() {
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        if (entry != null) {
            entry.selectRows(-1);
        }
        this.getModel().deleteEntryData("entryentity");
        QFBuilder builder = new QFBuilder();
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isNotEmpty((String)modelId)) {
            builder.add(new QFilter("model", "=", (Object)Long.valueOf(modelId)));
        } else {
            builder.add(new QFilter("model", "=", (Object)SqlBatchUtils.noFindId));
        }
        String businessData = (String)PluginUtils.getCustomParams(this.getView(), "BUSINESSDATABASE");
        if (StringUtils.isNotEmpty((String)businessData)) {
            builder.add(new QFilter("businessdata", "=", (Object)businessData));
        } else {
            builder.add(new QFilter("businessdata", "=", (Object)"#"));
        }
        String dimNumber = (String)PluginUtils.getCustomParams(this.getView(), "DIMENSION");
        if (StringUtils.isNotEmpty((String)dimNumber)) {
            builder.add(new QFilter("dimension", "=", (Object)dimNumber));
        } else {
            builder.add(new QFilter("dimension", "=", (Object)"#"));
        }
        List historys = null;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryMappingHistory", (String)"eb_mappinghistory", (String)"id, biznumber, bizname, modifydate, createdate", (QFilter[])builder.toArrays(), (String)"biznumber");){
            historys = CommonServiceHelper.transDataSet((DataSet)ds);
        }
        if (historys != null && !historys.isEmpty()) {
            DynamicObject object = null;
            Map history = null;
            int[] rows = this.getModel().batchCreateNewEntryRow("entryentity", historys.size());
            this.getModel().beginInit();
            int in = historys.size();
            for (int i = 0; i < in; ++i) {
                history = (Map)historys.get(i);
                object = this.getModel().getEntryRowEntity("entryentity", rows[i]);
                object.set("id", history.get("id"));
                object.set("biznumber", history.get("biznumber"));
                object.set("bizname", history.get("bizname"));
                object.set("modify", history.get("modifydate"));
                object.set("create", history.get("createdate"));
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }
}

