/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.billlist.BillListUtil;
import kd.epm.eb.common.enums.BgBillTreeTypeEnum;
import kd.epm.eb.common.enums.BillFieldTypeEmum;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.EpmTreeUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class FieldRegisterList
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final Log log = LogFactory.getLog(FieldRegisterList.class);
    private static final String leftTree = "lefttree";
    public static final String BILLLISTAP = "billlistap";
    public static final String BILLLISTAP1 = "billlistap1";
    private static final String formtype = "formtype";
    protected BillListUtil billListUtil = new BillListUtil();
    private static final String treeviewap = "treeviewap";
    private String billType_application = BgBillTreeTypeEnum.APPLICATION.getNumber();
    private String billType_bill = BgBillTreeTypeEnum.BILL.getNumber();
    private String billType_cloud = BgBillTreeTypeEnum.CLOUD.getNumber();
    private static final int HAS_FIELD = 1;
    private static final int HAS_OPERATOR = 2;

    public void initialize() {
        super.initialize();
        TreeView leftTree = (TreeView)this.getView().getControl(treeviewap);
        leftTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent e) {
                e.getQFilters().add(FieldRegisterList.this.getBillListQFilter("field"));
            }
        });
        billList.addCreateListDataProviderListener(this::beforeCreateListDataProvider);
        BillList billList1 = (BillList)this.getControl(BILLLISTAP1);
        billList1.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent e) {
                e.getQFilters().add(FieldRegisterList.this.getBillListQFilter("operation"));
            }
        });
        billList1.addCreateListDataProviderListener(this::beforeCreateListDataProvider);
        Toolbar toolbar = (Toolbar)this.getControl("toolbarap");
        toolbar.addItemClickListener((ItemClickListener)this);
        this.addClickListeners(new String[]{"btnadd", "btndelete"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initLeftTree();
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "baradd": {
                this.baradd();
                break;
            }
            case "bardelete": {
                Tab tab = (Tab)this.getControl("tabap");
                String currentTab = tab.getCurrentTab();
                String a = "field".equals(currentTab) ? BILLLISTAP : BILLLISTAP1;
                BillList billList = (BillList)this.getView().getControl(a);
                TreeNode currentLeftNode = this.getCurrentLefTreeNode();
                Object[] ids = billList.getSelectedRows().getEntryPrimaryKeyValues();
                if (currentLeftNode == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e", (String)"FieldRegisterList_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (ids == null || ids.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5", (String)"FieldRegisterList_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                ConfirmCallBackListener callBack = new ConfirmCallBackListener("bardelete", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u9009\u62e9\u7684\u5355\u636e\u6ce8\u518c\u5b57\u6bb5\u6216\u8005\u64cd\u4f5c\uff1f", (String)"FieldRegisterList_29", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, callBack);
                break;
            }
            case "bardefault": {
                this.bardefault();
                break;
            }
            case "barrefresh": {
                this.barrefresh();
                break;
            }
            case "baraddoperation": {
                this.baraddoperation();
                break;
            }
            case "barexit": {
                this.getView().close();
                break;
            }
        }
    }

    @Override
    public Long getModelId() {
        return 0L;
    }

    @Override
    public boolean isCheckModel() {
        return false;
    }

    private void baraddoperation() {
        Map nodeData;
        String isFromOuter;
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_addbillfield");
        TreeNode leftClickNode = this.getCurrentLefTreeNode();
        if (leftClickNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u5de6\u4fa7\u6811\u7ed3\u6784\u4e2d\u9009\u62e9\u4e00\u4e2a\u8282\u70b9\u3002", (String)"FieldRegisterList_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (leftClickNode.getData() != null && (isFromOuter = (String)(nodeData = (Map)leftClickNode.getData()).get("isFromOuter")) != null && isFromOuter.equals("true")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5916\u90e8\u5355\u636e\u4e0d\u652f\u6301\u201c\u6dfb\u52a0\u201d\u64cd\u4f5c\u3002", (String)"FieldRegisterList_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> customs = new HashMap<String, String>(16);
        DynamicObject biz = null;
        String bizSystemId = null;
        String bizUnitId = null;
        biz = this.billListUtil.queryFieldTableByID(IDUtils.toLong((Object)leftClickNode.getId()));
        String billType = biz.getString("billtype");
        if (this.billType_application.equals(billType)) {
            bizSystemId = biz.getString("id");
        } else if (this.billType_bill.equals(billType)) {
            bizUnitId = biz.getString("id");
            bizSystemId = biz.getString("parent");
        }
        customs.put("application", bizSystemId);
        customs.put("bill", bizUnitId);
        customs.put(formtype, "operation");
        showParameter.setCustomParams(customs);
        CloseCallBack closeCallBack1 = new CloseCallBack((IFormPlugin)this, "operation");
        showParameter.setCloseCallBack(closeCallBack1);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5355\u636e\u64cd\u4f5c\u6ce8\u518c", (String)"FieldRegisterList_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object nodeId = evt.getNodeId();
        String cachetreenode = this.getPageCache().get("cachetreenode");
        if (cachetreenode == null || !cachetreenode.equals(nodeId)) {
            this.getPageCache().put("cachetreenode", nodeId.toString());
            this.initRightTree();
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnadd": {
                this.btnadd();
                break;
            }
            case "btndelete": {
                TreeNode currentNode = this.getCurrentLefTreeNode();
                if (currentNode == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u5de6\u4fa7\u6811\u7ed3\u6784\u4e2d\u9009\u62e9\u4e00\u4e2a\u8282\u70b9\u3002", (String)"FieldRegisterList_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                ConfirmCallBackListener callBack = new ConfirmCallBackListener("btndelete", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u9009\u62e9\u7684\u5355\u636e\u6ce8\u518c\u4fe1\u606f\uff1f", (String)"FieldRegisterList_30", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, callBack);
            }
        }
    }

    private TreeNode getCurrentLefTreeNode() {
        TreeView treeView = (TreeView)this.getControl(treeviewap);
        String nodeId = treeView.getTreeState().getFocusNodeId();
        if (nodeId != null) {
            TreeNode leftTree = this.getCacheLeftRoot();
            return leftTree.getTreeNode(nodeId, 10);
        }
        TreeNode leftNode = this.billListUtil.getUserBillTree();
        if (leftNode == null) {
            return null;
        }
        TreeNode firstNode = BillListUtil.getFirstBillNode((TreeNode)leftNode);
        return firstNode == null ? null : firstNode;
    }

    private void btnadd() {
        TreeNode currentNode = this.getCurrentLefTreeNode();
        if (currentNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u5de6\u4fa7\u6811\u7ed3\u6784\u4e2d\u9009\u62e9\u4e00\u4e2a\u8282\u70b9\u3002", (String)"FieldRegisterList_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            Map nodeData = (Map)currentNode.getData();
            if (nodeData.get("isFromOuter") != null && ((String)nodeData.get("isFromOuter")).equals("true")) {
                this.showAddOuterBillForm();
            } else {
                this.showAddInsideBillForm();
            }
        }
    }

    private boolean checkNodeIsBill(TreeNode node) {
        Map nodeData;
        String billType;
        return node != null && node.getData() != null && (billType = (String)(nodeData = (Map)node.getData()).get("billType")) != null && billType.equals(this.billType_bill);
    }

    private void showAddInsideBillForm() {
        ListShowParameter formShowParameter = new ListShowParameter();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "addInsideBill");
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.setFormId("eb_addinsidebill");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5185\u90e8\u7cfb\u7edf\u63a7\u5236\u5355\u636e\u6ce8\u518c", (String)"FieldRegisterList_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setHeight("650");
        css.setWidth("1200");
        formShowParameter.getOpenStyle().setInlineStyleCss(css);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void showAddOuterBillForm() {
        ListShowParameter showParameter = new ListShowParameter();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "addOuterBill");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setBillFormId("isc_metadata_schema");
        showParameter.setFormId("bos_templatetreelistf7");
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getListFilterParameter().setFilter(new QFilter("type", "=", (Object)"ENTITY"));
        showParameter.getListFilterParameter().setFilter(new QFilter("name", "!=", (Object)" "));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setHeight("650");
        css.setWidth("1060");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5916\u90e8\u7cfb\u7edf\u63a7\u5236\u5355\u636e\u6ce8\u518c", (String)"FieldRegisterList_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(true);
        showParameter.setShowApproved(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void btndelete() {
        TreeNode currentNode = this.getCurrentLefTreeNode();
        if (currentNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u5de6\u4fa7\u6811\u7ed3\u6784\u4e2d\u9009\u62e9\u4e00\u4e2a\u8282\u70b9\u3002", (String)"FieldRegisterList_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String currentNodeId = currentNode.getId();
        String billTreeType = this.getBillTypeOfNode(currentNode);
        List<String> deleteIds = new ArrayList<String>(16);
        if (this.billType_application.equals(billTreeType)) {
            if (this.ownSysField(currentNodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u7ea7\u6709\u5b57\u6bb5\u7684\u5e94\u7528\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u5b57\u6bb5\u3002", (String)"FieldRegisterList_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            deleteIds.add(currentNodeId);
            deleteIds = this.getBillIdByApplication(deleteIds);
            if (this.checkBillRef(deleteIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8282\u70b9\u4e0b\u6709\u5355\u636e\u5df2\u88ab\u5f15\u7528\uff0c\u7981\u6b62\u5220\u9664", (String)"FieldRegisterList_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String parentId = currentNode.getParentid();
            TreeNode root = this.getCacheLeftRoot();
            TreeNode parentNode = root.getTreeNode(parentId, 4);
            if (parentNode != null && this.checkParentHaveOneChild(parentNode.getId(), currentNodeId) && !BgBillTreeTypeEnum.ROOT.getNumber().equals(this.getBillTypeOfNode(parentNode))) {
                deleteIds.add(parentNode.getId());
            }
            deleteIds.add(currentNodeId);
        } else if (this.billType_bill.equals(billTreeType)) {
            int ownUnitField = this.ownUnitField(currentNodeId);
            StringBuilder message = new StringBuilder();
            if ((1 & ownUnitField) == 1) {
                message.append(ResManager.loadKDString((String)"\u4e0b\u7ea7\u6709\u5b57\u6bb5\u7684\u5355\u636e\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u5b57\u6bb5\u3002", (String)"FieldRegisterList_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if ((2 & ownUnitField) == 2) {
                if (message.length() > 0) {
                    message.append("\r\n");
                }
                message.append(ResManager.loadKDString((String)"\u62e5\u6709\u64cd\u4f5c\u7684\u5355\u636e\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u64cd\u4f5c\u3002", (String)"FieldRegisterList_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (message.length() > 0) {
                this.getView().showTipNotification(message.toString());
                return;
            }
            if (this.checkBillRef(Collections.singletonList(currentNodeId))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8282\u70b9\u4e0b\u6709\u5355\u636e\u5df2\u88ab\u5f15\u7528\uff0c\u7981\u6b62\u5220\u9664", (String)"FieldRegisterList_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String parentId = currentNode.getParentid();
            if (this.checkParentHaveOneChild(parentId, currentNodeId)) {
                deleteIds.add(parentId);
                TreeNode root = this.getCacheLeftRoot();
                TreeNode parentNode = root.getTreeNode(parentId, 4);
                TreeNode pParentNode = root.getTreeNode(parentNode.getParentid(), 4);
                if (pParentNode != null && this.checkParentHaveOneChild(pParentNode.getId(), parentId) && !BgBillTreeTypeEnum.ROOT.getNumber().equals(this.getBillTypeOfNode(pParentNode))) {
                    deleteIds.add(pParentNode.getId());
                }
            }
            deleteIds.add(currentNodeId);
        } else if (BgBillTreeTypeEnum.ROOT.getNumber().equals(billTreeType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"FieldRegisterList_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (this.billType_cloud.equals(billTreeType)) {
            List<String> applicationIds = this.getApplicationByCloud(currentNode.getId());
            if (this.checkCloudFields(applicationIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e94\u7528\u4e0b\u62e5\u6709\u5b57\u6bb5\u7684\u5355\u636e\u4e0d\u80fd\u5220\u9664\u3002", (String)"FieldRegisterList_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            List<String> billIds = this.getBillIdByApplication(applicationIds);
            if (this.checkBillRef(billIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8282\u70b9\u4e0b\u6709\u5355\u636e\u5df2\u88ab\u5f15\u7528\uff0c\u7981\u6b62\u5220\u9664", (String)"FieldRegisterList_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            applicationIds.add(currentNode.getId());
            applicationIds.addAll(billIds);
            deleteIds.addAll(applicationIds);
        }
        if (!deleteIds.isEmpty()) {
            try (TXHandle th = TX.required();){
                try {
                    List collect = deleteIds.stream().map(Convert::toLong).collect(Collectors.toList());
                    DeleteServiceHelper.delete((String)"eb_structofbill", (QFilter[])new QFilter[]{new QFilter("id", "in", collect)});
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"FieldRegisterList_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "FieldRegisterList_11", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5220\u9664\u5355\u636e\u6210\u529f", "FieldRegisterList_12", "epm-eb-formplugin"));
                    this.initLeftTree();
                }
                catch (Exception e) {
                    th.markRollback();
                    this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "FieldRegisterList_11", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5220\u9664\u5355\u636e\u51fa\u9519", "FieldRegisterList_13", "epm-eb-formplugin"), false);
                    throw new KDBizException(ResManager.loadResFormat((String)"\u5220\u9664\u5931\u8d25:%1\u3002", (String)"FieldRegisterList_14", (String)"epm-eb-formplugin", (Object[])new Object[]{e.getMessage()}));
                }
            }
        }
    }

    private boolean checkBillRef(List<String> billIds) {
        boolean isExists = false;
        if (billIds != null && !billIds.isEmpty()) {
            List collect = billIds.stream().map(Convert::toLong).collect(Collectors.toList());
            QFilter qFilter = new QFilter("entryentity.bill", "in", collect);
            isExists = QueryServiceHelper.exists((String)"eb_bgcontrolprocess", (QFilter[])qFilter.toArray());
            QFilter qFilter2 = new QFilter("entryentity.subentryentity.bill", "in", collect);
            isExists = isExists || QueryServiceHelper.exists((String)"eb_dimmaterule", (QFilter[])qFilter2.toArray());
            QFilter qFilter3 = new QFilter("bill.fbasedataid", "in", collect);
            isExists = isExists || QueryServiceHelper.exists((String)"eb_whitelist", (QFilter[])qFilter3.toArray());
        }
        return isExists;
    }

    private String getBillTypeOfNode(TreeNode node) {
        String billType = null;
        Map nodeData = (Map)node.getData();
        if (nodeData != null) {
            billType = (String)nodeData.get("billType");
        }
        return billType;
    }

    private boolean checkParentHaveOneChild(String parentId, String childId) {
        ArrayList<String> childIds = new ArrayList<String>(16);
        QFBuilder qb = new QFBuilder();
        qb.add("parent", "=", (Object)Convert.toLong((Object)parentId));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"checkParentHaveOneChild", (String)"eb_structofbill", (String)"id", (QFilter[])qb.toArrays(), null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String id = row.getString("id");
                childIds.add(id);
                if (childIds.size() <= 2) continue;
                break;
            }
            dataSet.close();
            if (childIds.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            if (childIds.size() == 1 && childId.equals(childIds.get(0))) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private List<String> getApplicationByCloud(String cloudId) {
        ArrayList<String> applicationIds = new ArrayList<String>(16);
        QFBuilder qb = new QFBuilder();
        qb.add("parent", "=", (Object)Convert.toLong((Object)cloudId));
        DataSet applications = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_structofbill", (String)"id", (QFilter[])qb.toArrays(), null);
        while (applications.hasNext()) {
            Row row = applications.next();
            applicationIds.add(row.getString("id"));
        }
        applications.close();
        return applicationIds;
    }

    private List<String> getBillIdByApplication(List<String> applicationIds) {
        ArrayList<String> billIds = new ArrayList<String>(16);
        QFBuilder qb = new QFBuilder();
        qb.add("parent", "in", (Object)IDUtils.toLongs(applicationIds));
        DataSet bills = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_structofbill", (String)"id", (QFilter[])qb.toArrays(), null);
        while (bills.hasNext()) {
            Row row = bills.next();
            billIds.add(row.getString("id"));
        }
        bills.close();
        return billIds;
    }

    private boolean checkCloudFields(List<String> applicationIds) {
        if (!applicationIds.isEmpty()) {
            QFBuilder qb = new QFBuilder();
            List collect = applicationIds.stream().map(Convert::toLong).collect(Collectors.toList());
            qb.add("bizSystemId", "in", (Object)collect.toArray());
            return QueryServiceHelper.exists((String)"eb_bgcontrolbizreg", (QFilter[])qb.toArrays());
        }
        return false;
    }

    private boolean ownSysField(String bizSystemId) {
        QFilter qFilter = new QFilter("bizSystemId", "=", (Object)Convert.toLong((Object)bizSystemId));
        DynamicObjectCollection fields = QueryServiceHelper.query((String)"eb_bgcontrolbizreg", (String)"id,referedstatus", (QFilter[])new QFilter[]{qFilter});
        return fields != null && fields.size() > 0;
    }

    private int ownUnitField(String bizUnitId) {
        int result = 0;
        QFilter qFilter = new QFilter("bizUnitId", "=", (Object)Convert.toLong((Object)bizUnitId));
        String type = null;
        DynamicObjectCollection fields = QueryServiceHelper.query((String)"eb_bgcontrolbizreg", (String)"id,referedstatus,type", (QFilter[])new QFilter[]{qFilter});
        if (fields != null && fields.size() > 0) {
            for (DynamicObject obj : fields) {
                type = obj.getString("type");
                if (BillFieldTypeEmum.CLEAROPERATION.getNumber().equalsIgnoreCase(type) || BillFieldTypeEmum.OPERATION.getNumber().equalsIgnoreCase(type) || BillFieldTypeEmum.RETURNOPERATION.getNumber().equalsIgnoreCase(type) || BillFieldTypeEmum.RUNOPERATION.getNumber().equalsIgnoreCase(type) || BillFieldTypeEmum.TAKEOPERATION.getNumber().equalsIgnoreCase(type)) {
                    result |= 2;
                    continue;
                }
                result |= 1;
            }
        }
        return result;
    }

    private void baradd() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_addbillfield");
        TreeNode currentNode = this.getCurrentLefTreeNode();
        if (currentNode == null || !this.checkNodeIsBill(currentNode)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u5355\u636e\u3002", (String)"FieldRegisterList_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> customs = new HashMap<String, String>(16);
        String bizSystemId = null;
        String bizUnitId = null;
        Map nodeData = (Map)currentNode.getData();
        String isFromOuter = (String)nodeData.get("isFromOuter");
        bizUnitId = (String)nodeData.get("id");
        bizSystemId = currentNode.getParentid();
        customs.put("application", bizSystemId);
        customs.put("bill", bizUnitId);
        customs.put("isFromOuter", isFromOuter);
        customs.put(formtype, "field");
        showParameter.setCustomParams(customs);
        CloseCallBack closeCallBack1 = new CloseCallBack((IFormPlugin)this, "field");
        showParameter.setCloseCallBack(closeCallBack1);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5\u6ce8\u518c", (String)"FieldRegisterList_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private void bardelete() {
        Tab tab = (Tab)this.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        String a = "field".equals(currentTab) ? BILLLISTAP : BILLLISTAP1;
        BillList billList = (BillList)this.getView().getControl(a);
        TreeNode currentLeftNode = this.getCurrentLefTreeNode();
        Object[] ids = billList.getSelectedRows().getEntryPrimaryKeyValues();
        if (currentLeftNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e", (String)"FieldRegisterList_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ids == null || ids.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5", (String)"FieldRegisterList_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long billId = IDUtils.toLong((Object)currentLeftNode.getId());
        Long applicationId = IDUtils.toLong((Object)currentLeftNode.getParentid());
        List entryIds = IDUtils.toLongs((Object[])ids);
        DynamicInfoCollection checkResult = this.billListUtil.checkFieldRef(entryIds, billId, applicationId);
        List entryNums = checkResult.getAllValOfOnePropByAnotherProp("number", "refed_no", (Object)true);
        if (entryNums.size() > 0) {
            DynamicObjectCollection entryentity;
            DynamicObject parent2;
            QFBuilder qb = new QFBuilder();
            qb.add("bill", "=", (Object)billId);
            qb.add("entryentity.number", "in", (Object)entryNums.toArray());
            DynamicObject[] alls = BusinessDataServiceHelper.load((String)"eb_conbizregdata", (String)"bill.id,entryentity.number", (QFilter[])qb.toArrays());
            ArrayList<String> deleteNumbers = new ArrayList<String>(16);
            ArrayList<DynamicObject> parents = new ArrayList<DynamicObject>(Arrays.asList(alls));
            alls = null;
            for (DynamicObject parent2 : parents) {
                entryentity = parent2.getDynamicObjectCollection("entryentity");
                ListIterator iterator = entryentity.listIterator();
                while (iterator.hasNext()) {
                    DynamicObject next = (DynamicObject)iterator.next();
                    String number = next.getString("number");
                    if (!entryNums.contains(number)) continue;
                    iterator.remove();
                }
            }
            Iterator iterator = parents.iterator();
            parent2 = null;
            while (iterator.hasNext()) {
                parent2 = (DynamicObject)iterator.next();
                entryentity = parent2.getDynamicObjectCollection("entryentity");
                if (!entryentity.isEmpty()) continue;
                deleteNumbers.add(parent2.getString("id"));
                iterator.remove();
            }
            try (TXHandle th = TX.required();){
                try {
                    if (!deleteNumbers.isEmpty()) {
                        DeleteServiceHelper.delete((String)"eb_conbizregdata", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)IDUtils.toLongs(deleteNumbers))});
                    }
                    if (!parents.isEmpty()) {
                        SaveServiceHelper.save((DynamicObject[])parents.toArray(new DynamicObject[1]));
                    }
                    QFilter and = new QFilter("bizunitid", "=", (Object)billId).and("number", "in", (Object)entryNums.toArray());
                    DeleteServiceHelper.delete((String)"eb_bgcontrolbizreg", (QFilter[])and.toArray());
                    this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "FieldRegisterList_11", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5b57\u6bb5\u5220\u9664\u6210\u529f", "FieldRegisterList_19", "epm-eb-formplugin"));
                }
                catch (Exception e) {
                    th.markRollback();
                    this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "FieldRegisterList_11", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5b57\u6bb5\u5220\u9664\u5931\u8d25", "FieldRegisterList_20", "epm-eb-formplugin"), false);
                    throw new KDBizException(ResManager.loadResFormat((String)"\u5b57\u6bb5\u5220\u9664\u5931\u8d25\uff1a%1\u3002", (String)"FieldRegisterList_21", (String)"epm-eb-formplugin", (Object[])new Object[]{e.getMessage()}));
                }
            }
            this.initRightTree();
        }
        if (entryNums.size() != ids.length) {
            List warnInfos = this.billListUtil.getRefedInfo(checkResult);
            if (!warnInfos.isEmpty()) {
                CommonServiceHelper.showErrorInfoForm((IFormView)this.getView(), (List)warnInfos, (String)ResManager.loadKDString((String)"\u90e8\u5206\u5b57\u6bb5\u6216\u64cd\u4f5c\u5220\u9664\u5931\u8d25\u3002", (String)"FieldRegisterList_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"FieldRegisterList_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void bardefault() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_bgcontroldefault");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.ADDNEW);
        TreeNode cacheLeftClickTree = this.getCurrentLefTreeNode();
        if (cacheLeftClickTree != null) {
            DynamicObject biz = this.billListUtil.queryFieldTableByID(IDUtils.toLong((Object)cacheLeftClickTree.getId()));
            String billTreeType = biz.getString("billtype");
            if (billTreeType.equals(this.billType_application)) {
                showParameter.setCustomParam("application", (Object)biz.getString("id"));
            } else if (billTreeType.equals(this.billType_bill)) {
                showParameter.setCustomParam("bill", (Object)biz.getString("id"));
                showParameter.setCustomParam("application", (Object)biz.getString("parent"));
                showParameter.setCustomParam("fieldtable", (Object)biz.getString("fieldtable"));
            }
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "defaultConttol");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void barrefresh() {
        this.initLeftTree();
        this.initRightTree();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object backData = null;
        switch (actionId) {
            case "addInsideBill": {
                backData = closedCallBackEvent.getReturnData();
                if (backData == null || !backData.getClass().equals(ListSelectedRowCollection.class)) break;
                try {
                    this.addInsideBill((ListSelectedRowCollection)backData);
                }
                catch (Throwable e) {
                    log.info("addInsideBill-error:{}", (Object)e);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u6ce8\u518c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6ce8\u518c\u7684\u5355\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"FieldRegisterList_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                break;
            }
            case "addOuterBill": {
                backData = closedCallBackEvent.getReturnData();
                if (backData == null || !backData.getClass().equals(ListSelectedRowCollection.class)) break;
                this.addOuterBill((ListSelectedRowCollection)backData);
                break;
            }
            case "field": {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                if (returnData != null && returnData.get("opennewpage") != null && ((Boolean)returnData.get("opennewpage")).booleanValue()) {
                    this.openNewPage(returnData);
                }
                Tab tab = (Tab)this.getControl("tabap");
                tab.activeTab("field");
                this.initRightTree();
                break;
            }
            case "operation": {
                Map returnData2 = (Map)closedCallBackEvent.getReturnData();
                if (returnData2 != null && returnData2.get("opennewpage") != null && ((Boolean)returnData2.get("opennewpage")).booleanValue()) {
                    this.openNewPage(returnData2);
                }
                Tab tab1 = (Tab)this.getControl("tabap");
                tab1.activeTab("operation");
                this.initRightTree();
                break;
            }
            case "defaultConttol": {
                Map rd = (Map)closedCallBackEvent.getReturnData();
                if (rd == null || !"1".equals(rd.get("gotodimmaterule"))) break;
                ListShowParameter lsp = new ListShowParameter();
                lsp.setBillFormId("eb_adddimmaterule");
                lsp.setAppId("bgc");
                lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)lsp);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
            switch (e.getCallBackId()) {
                case "btndelete": {
                    this.btndelete();
                    break;
                }
                case "bardelete": {
                    this.bardelete();
                    break;
                }
            }
        }
    }

    private void addInsideBill(ListSelectedRowCollection rowDatas) {
        List neededCloud;
        Object id;
        ArrayList<String> outerBillNums = new ArrayList<String>(16);
        for (ListSelectedRow row : rowDatas) {
            String number = String.valueOf(row.getNumber());
            outerBillNums.add(number);
        }
        QFBuilder qb = new QFBuilder();
        QFilter qBillNum = new QFilter("number", "in", (Object)outerBillNums.toArray());
        qb.add(qBillNum);
        qb.add("billtype", "=", (Object)this.billType_bill);
        DynamicObjectCollection regedInfos = QueryServiceHelper.query((String)"eb_structofbill", (String)"id,number", (QFilter[])qb.toArrays());
        ArrayList<String> needUpdateBill = new ArrayList<String>(16);
        for (DynamicObject regedBill : regedInfos) {
            String number = regedBill.getString("number");
            if (outerBillNums.contains(number)) {
                needUpdateBill.add(number);
            }
            outerBillNums.remove(number);
        }
        if (!needUpdateBill.isEmpty()) {
            Set<String> c = this.getDefaultBill();
            needUpdateBill.removeAll(c);
            if (!needUpdateBill.isEmpty()) {
                this.updateBill(needUpdateBill);
            }
        }
        if (outerBillNums.isEmpty()) {
            return;
        }
        qBillNum = new QFilter("number", "in", (Object)outerBillNums.toArray());
        DynamicObject[] outerBills = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"id,number,name,bizappid,basedatafield", (QFilter[])new QFilter[]{qBillNum});
        HashSet<String> appOrCloudInfos = new HashSet<String>(16);
        HashMap<String, String> baseDataId = new HashMap<String, String>(16);
        DynamicInfoCollection newEntityInfos = new DynamicInfoCollection(ResManager.loadKDString((String)"\u521b\u5efa\u884c\u7684\u6570\u636e\u4fe1\u606f\u5df2\u6682\u5b58\u3002", (String)"FieldRegisterList_23", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[]{"name", "number", "parentNum", "billTreeNodeType", "billTreeNode"});
        for (DynamicObject outerBill : outerBills) {
            String billNumber = outerBill.getString("number");
            baseDataId.put(billNumber, outerBill.getString("basedatafield"));
        }
        QFilter baseFilter = new QFilter("id", "in", (Object)baseDataId.values().toArray());
        DynamicObject[] entityBills = BusinessDataServiceHelper.load((String)"bos_entitymeta", (String)"id,number,name", (QFilter[])new QFilter[]{baseFilter});
        baseFilter = new QFilter("number", "in", (Object)baseDataId.keySet().toArray());
        baseDataId.clear();
        for (DynamicObject entityBill : entityBills) {
            baseDataId.put(entityBill.getString("id"), entityBill.getString("number"));
        }
        entityBills = BusinessDataServiceHelper.load((String)"bos_entitymeta", (String)"id,number,name", (QFilter[])new QFilter[]{baseFilter});
        HashSet<String> hasNumbers = new HashSet<String>(16);
        for (DynamicObject entityBill : entityBills) {
            hasNumbers.add(entityBill.getString("number"));
        }
        if (outerBills != null) {
            for (DynamicObject outerBill : outerBills) {
                Object name = outerBill.get("name");
                String billNumber = outerBill.getString("number");
                String entityId = outerBill.getString("basedatafield");
                if (baseDataId.containsKey(entityId) && !hasNumbers.contains(billNumber)) {
                    billNumber = (String)baseDataId.get(entityId);
                }
                String bizAppId = outerBill.getString("bizappid");
                newEntityInfos.addInfo(new Object[]{name, billNumber, bizAppId, this.billType_bill, null});
                appOrCloudInfos.add(bizAppId);
            }
        }
        qb = new QFBuilder();
        qb.add("id", "in", (Object)appOrCloudInfos.toArray());
        DynamicObject[] appInfos = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"id,number,name,bizcloud.number,bizcloud.name", (QFilter[])qb.toArrays());
        String insideNodeId = this.getPageCache().get("INSIDE_NODE_ID");
        appOrCloudInfos.clear();
        if (appInfos != null) {
            for (DynamicObject app : appInfos) {
                id = app.getString("id");
                Object name = app.get("name");
                String appNumber = app.getString("number");
                String cloudNum = app.getString("bizcloud.number");
                Object cloudName = app.get("bizcloud.name");
                if (appOrCloudInfos.add(cloudNum)) {
                    newEntityInfos.addInfo(new Object[]{cloudName, cloudNum, insideNodeId, this.billType_cloud, null});
                }
                newEntityInfos.getAllInfoByOneProp("parentNum", id).forEach(info -> info.setValueByPropName("parentNum", (Object)(appNumber + "-" + this.billType_application)));
                newEntityInfos.addInfo(new Object[]{name, appNumber, cloudNum + "-" + this.billType_cloud, this.billType_application, null});
            }
        }
        DynamicInfoCollection regedRowInfos = new DynamicInfoCollection(ResManager.loadKDString((String)"\u5df2\u6ce8\u518c\u884c\u7684\u4fe1\u606f", (String)"FieldRegisterList_24", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[]{"id", "number", "billtype"});
        qb = new QFBuilder();
        QFilter qApp = new QFilter("billtype", "=", (Object)this.billType_application);
        qApp.and("number", "in", (Object)newEntityInfos.getAllValOfOnePropByAnotherProp("number", "billTreeNodeType", (Object)this.billType_application).toArray());
        QFilter qCloud = new QFilter("billtype", "=", (Object)this.billType_cloud);
        qCloud.and("number", "in", (Object)newEntityInfos.getAllValOfOnePropByAnotherProp("number", "billTreeNodeType", (Object)this.billType_cloud).toArray());
        qb.add(qApp.or(qCloud));
        DataSet data = QueryServiceHelper.queryDataSet((String)"FieldRegisterList", (String)"eb_structofbill", (String)"id,number,billtype", (QFilter[])qb.toArrays(), null);
        id = null;
        try {
            while (data.hasNext()) {
                Row rowData = data.next();
                String id2 = rowData.getString("id");
                String number = rowData.getString("number");
                String billType = rowData.getString("billtype");
                regedRowInfos.addInfo(new Object[]{id2, number, billType});
            }
            data.close();
        }
        catch (Throwable rowData) {
            id = rowData;
            throw rowData;
        }
        finally {
            if (data != null) {
                if (id != null) {
                    try {
                        data.close();
                    }
                    catch (Throwable rowData) {
                        ((Throwable)id).addSuppressed(rowData);
                    }
                } else {
                    data.close();
                }
            }
        }
        if (!regedRowInfos.isEmpty()) {
            List regAppNums = regedRowInfos.getAllValOfOnePropByAnotherProp("number", "billtype", (Object)this.billType_application);
            List regCloudNums = regedRowInfos.getAllValOfOnePropByAnotherProp("number", "billtype", (Object)this.billType_cloud);
            Iterator iterator = newEntityInfos.getValues().iterator();
            DynamicInfoCollection.InfoObject infoObject = null;
            while (iterator.hasNext()) {
                infoObject = (DynamicInfoCollection.InfoObject)iterator.next();
                String type = (String)infoObject.getValueByPropName("billTreeNodeType");
                String num = (String)infoObject.getValueByPropName("number");
                if (type.equals(this.billType_application)) {
                    if (!regAppNums.contains(num)) continue;
                    iterator.remove();
                    continue;
                }
                if (!type.equals(this.billType_cloud) || !regCloudNums.contains(num)) continue;
                iterator.remove();
            }
        }
        if ((neededCloud = newEntityInfos.getAllValOfOnePropByAnotherProp("parentNum", "billTreeNodeType", (Object)this.billType_application)) != null) {
            Iterator iterator = newEntityInfos.getValues().iterator();
            DynamicInfoCollection.InfoObject infoObject = null;
            while (iterator.hasNext()) {
                infoObject = (DynamicInfoCollection.InfoObject)iterator.next();
                String type = (String)infoObject.getValueByPropName("billTreeNodeType");
                String num = (String)infoObject.getValueByPropName("number") + "-cloud";
                if (!type.equals(this.billType_cloud) || neededCloud.contains(num)) continue;
                iterator.remove();
            }
        }
        this.batchCreateNode(newEntityInfos, regedRowInfos, this.billType_cloud);
        this.batchCreateNode(newEntityInfos, regedRowInfos, this.billType_application);
        this.batchCreateNode(newEntityInfos, null, this.billType_bill);
        List billEntitys = newEntityInfos.getAllValOfOneProp("billTreeNode");
        SaveServiceHelper.save((DynamicObject[])billEntitys.toArray(new DynamicObject[0]));
        this.writeLog("save", new MultiLangEnumBridge("\u4fdd\u5b58", "FieldRegisterList_25", "epm-eb-formplugin"), new MultiLangEnumBridge("\u6dfb\u52a0\u5185\u90e8\u5355\u636e\u6210\u529f\u3002", "FieldRegisterList_26", "epm-eb-formplugin"));
        this.initLeftTree();
    }

    private Set<String> getDefaultBill() {
        HashSet<String> objects = new HashSet<String>();
        objects.add("er_dailyapplybill");
        objects.add("er_dailyloanbill");
        objects.add("er_dailyreimbursebill");
        objects.add("er_tripreqbill");
        objects.add("er_tripreimbursebill");
        objects.add("er_publicreimbursebill");
        return objects;
    }

    private void updateBill(List<String> needUpdateBill) {
        DynamicObject[] reportInfos;
        String insideNodeId = this.getPageCache().get("INSIDE_NODE_ID");
        QFilter qf1 = new QFilter("number", "in", (Object)needUpdateBill.toArray());
        DynamicObjectCollection outerBill = QueryServiceHelper.query((String)"bos_formmeta", (String)"id,number,name,bizappid", (QFilter[])new QFilter[]{qf1});
        Map<String, String> billNum2AppIdMapping = outerBill.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v.getString("bizappid")));
        QFilter qf2 = new QFilter("id", "in", billNum2AppIdMapping.values());
        DynamicObjectCollection appInfos = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id,number,name,bizcloud.number,bizcloud.name", (QFilter[])qf2.toArray());
        Map<String, DynamicObject> appId2DOJ = appInfos.stream().collect(Collectors.toMap(k -> k.getString("id"), v -> v));
        Map<String, String> app2Cloud = appInfos.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v.getString("bizcloud.number")));
        HashSet<String> strings = new HashSet<String>(16);
        strings.addAll(app2Cloud.keySet());
        strings.addAll(app2Cloud.values());
        strings.addAll(needUpdateBill);
        QFilter qf3 = new QFilter("number", "in", strings);
        DynamicObject[] structofbill = BusinessDataServiceHelper.load((String)"eb_structofbill", (String)"id,number,name,parent.id,billtype", (QFilter[])qf3.toArray());
        Set<String> numbers = Arrays.stream(structofbill).map(doj -> doj.getString("number")).collect(Collectors.toSet());
        strings.removeAll(numbers);
        if (!strings.isEmpty()) {
            this.append2DB(insideNodeId, appInfos, app2Cloud, numbers);
            structofbill = BusinessDataServiceHelper.load((String)"eb_structofbill", (String)"id,number,name,parent,billtype", (QFilter[])qf3.toArray());
        }
        HashMap<String, DynamicObject> billNum2DOJ = new HashMap<String, DynamicObject>(16);
        if (structofbill != null) {
            for (DynamicObject v2 : structofbill) {
                if (!BgBillTreeTypeEnum.BILL.getNumber().equalsIgnoreCase(v2.getString("billtype"))) continue;
                billNum2DOJ.put(v2.getString("number"), v2);
            }
        }
        Map<String, Long> billNum2Id = Arrays.stream(structofbill).filter(v -> BgBillTreeTypeEnum.BILL.getNumber().equalsIgnoreCase(v.getString("billtype"))).collect(Collectors.toMap(k -> k.getString("number"), v -> v.getLong("id")));
        Map<String, Long> billNum2Parent = Arrays.stream(structofbill).filter(v -> BgBillTreeTypeEnum.BILL.getNumber().equalsIgnoreCase(v.getString("billtype"))).collect(Collectors.toMap(k -> k.getString("number"), v -> v.getLong("parent.id")));
        Map<String, DynamicObject> noBillNum2DOJ = Arrays.stream(structofbill).filter(v -> !BgBillTreeTypeEnum.BILL.getNumber().equalsIgnoreCase(v.getString("billtype"))).collect(Collectors.toMap(k -> k.getString("number"), v -> v));
        Map<String, Long> noBillNum2Id = Arrays.stream(structofbill).filter(v -> !BgBillTreeTypeEnum.BILL.getNumber().equalsIgnoreCase(v.getString("billtype"))).collect(Collectors.toMap(k -> k.getString("number"), v -> v.getLong("id")));
        Map<String, Long> noBillNum2Parent = Arrays.stream(structofbill).filter(v -> !BgBillTreeTypeEnum.BILL.getNumber().equalsIgnoreCase(v.getString("billtype"))).collect(Collectors.toMap(k -> k.getString("number"), v -> v.getLong("parent.id")));
        ArrayList<DynamicObject> needUpdate = new ArrayList<DynamicObject>(16);
        for (Map.Entry<String, String> entry : billNum2AppIdMapping.entrySet()) {
            Long _insideNodeId;
            DynamicObject doj2;
            String bill = entry.getKey();
            if (!appId2DOJ.containsKey(entry.getValue()) || (doj2 = appId2DOJ.get(entry.getValue())) == null) continue;
            Long appId = billNum2Parent.get(bill);
            String appNumber = doj2.getString("number");
            Long _appId = noBillNum2Id.get(appNumber);
            if (appId != null && !appId.equals(_appId)) {
                DynamicObject doj1 = (DynamicObject)billNum2DOJ.get(bill);
                doj1.set("parent", (Object)_appId);
                needUpdate.add(doj1);
            }
            Long cloudId = noBillNum2Parent.get(appNumber);
            String coludNumber = doj2.getString("bizcloud.number");
            Long _cloudId = noBillNum2Id.get(coludNumber);
            if (cloudId != null && !cloudId.equals(_cloudId)) {
                DynamicObject doj1 = noBillNum2DOJ.get(appNumber);
                doj1.set("parent", (Object)_cloudId);
                needUpdate.add(doj1);
            }
            if (insideNodeId.equals((_insideNodeId = noBillNum2Parent.get(coludNumber)).toString())) continue;
            DynamicObject doj1 = noBillNum2DOJ.get(coludNumber);
            doj1.set("parent", (Object)insideNodeId);
            needUpdate.add(doj1);
        }
        for (DynamicObject report : reportInfos = BusinessDataServiceHelper.load((String)"eb_structofbill", (String)"id, status, enable", (QFilter[])new QFilter[]{qf1})) {
            report.set("status", (Object)"C");
            report.set("enable", (Object)"1");
        }
        SaveServiceHelper.update((DynamicObject[])reportInfos);
        if (!needUpdate.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])needUpdate.toArray(new DynamicObject[0]));
        }
    }

    private void append2DB(String insideNodeId, DynamicObjectCollection appInfos, Map<String, String> app2Cloud, Set<String> numbers) {
        HashSet<String> strings1 = new HashSet<String>(16);
        strings1.addAll(app2Cloud.values());
        strings1.removeAll(numbers);
        if (!strings1.isEmpty()) {
            ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(strings1.size());
            for (DynamicObject appInfo : appInfos) {
                String cloudNumber = appInfo.getString("bizcloud.number");
                if (strings1.remove(cloudNumber)) {
                    String cloudName = appInfo.getString("bizcloud.name");
                    DynamicObject node = this.createNode(cloudName, cloudNumber, insideNodeId, null, null, this.billType_cloud, false);
                    dynamicObjects.add(node);
                }
                if (!strings1.isEmpty()) continue;
                break;
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        }
        HashSet<String> strings2 = new HashSet<String>(16);
        strings2.addAll(app2Cloud.keySet());
        strings2.removeAll(numbers);
        if (!strings2.isEmpty()) {
            ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(strings2.size());
            for (DynamicObject appInfo : appInfos) {
                String appNumber = appInfo.getString("number");
                if (strings2.contains(appNumber)) {
                    String appName = appInfo.getString("name");
                    String cloudNumber = appInfo.getString("bizcloud.number");
                    QFilter qFilter = new QFilter("number", "=", (Object)cloudNumber);
                    DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_structofbill", (String)"id,number", (QFilter[])qFilter.toArray());
                    DynamicObject node = this.createNode(appName, appNumber, dynamicObject.getString("id"), null, null, this.billType_bill, false);
                    dynamicObjects.add(node);
                    strings2.remove(cloudNumber);
                }
                if (!strings2.isEmpty()) continue;
                break;
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        }
    }

    private void batchCreateNode(DynamicInfoCollection newBillInfo, DynamicInfoCollection regedRowInfos, String billType) {
        List newNodes = newBillInfo.getAllInfoByOneProp("billTreeNodeType", (Object)billType);
        if (!newNodes.isEmpty()) {
            newNodes.forEach(newNode -> {
                String num = (String)newNode.getValueByPropName("number");
                Object name = newNode.getValueByPropName("name");
                String parentId = (String)newNode.getValueByPropName("parentNum");
                DynamicObject node = this.createNode(name, num, parentId, null, null, billType, false);
                if (regedRowInfos != null) {
                    regedRowInfos.addInfo(new Object[]{node.getString("id"), num, billType});
                }
                newNode.setValueByPropName("billTreeNode", (Object)node);
            });
        }
        if (regedRowInfos != null) {
            List regNodeInfo = regedRowInfos.getAllInfoByOneProp("billtype", (Object)billType);
            regNodeInfo.forEach(node -> {
                String aid = (String)node.getValueByPropIndex(0);
                String num = (String)node.getValueByPropIndex(1);
                List newBills = newBillInfo.getAllInfoByOneProp("parentNum", (Object)(num + "-" + billType));
                newBills.forEach(bill -> bill.setValueByPropName("parentNum", (Object)aid));
            });
        }
    }

    private void addOuterBill(ListSelectedRowCollection rowDatas) {
        String groupNum;
        ArrayList<String> outerBillIds = new ArrayList<String>(16);
        for (ListSelectedRow row : rowDatas) {
            outerBillIds.add(Convert.toStr((Object)row.getPrimaryKeyValue()));
        }
        QFBuilder qb = new QFBuilder();
        qb.add("longnumber", "in", (Object)outerBillIds.toArray());
        Row rowData = null;
        String longNumber = null;
        try (DataSet data = QueryServiceHelper.queryDataSet((String)"FieldRegisterList", (String)"eb_structofbill", (String)"id,longnumber", (QFilter[])qb.toArrays(), null);){
            while (data.hasNext()) {
                rowData = data.next();
                longNumber = rowData.getString("longnumber");
                if (!StringUtils.isNotEmpty((String)longNumber)) continue;
                outerBillIds.remove(longNumber);
            }
        }
        qb = new QFBuilder();
        qb.add("id", "in", (Object)IDUtils.toLongs(outerBillIds));
        ArrayList<Object> newOuterBill = new ArrayList<Object>(16);
        HashMap<String, DynamicObject> newGroupRow = new HashMap<String, DynamicObject>(16);
        DynamicObject newBill = null;
        DynamicObject newGroup = null;
        try (DataSet data = QueryServiceHelper.queryDataSet((String)"FieldRegisterList", (String)"isc_metadata_schema", (String)"id,number,name,group.name,group.number,group.id,full_name", (QFilter[])qb.toArrays(), null);){
            while (data.hasNext()) {
                rowData = data.next();
                String outerBillId = rowData.getString("id");
                String outerBillNum = rowData.getString("number");
                String outerBillNanme = rowData.getString("name");
                String groupId = rowData.getString("group.id");
                String groupName = rowData.getString("group.name");
                groupNum = rowData.getString("group.number");
                String fullName = rowData.getString("full_name");
                if (!newGroupRow.containsKey(groupNum)) {
                    newGroup = this.createNode(groupName, groupNum, null, groupId, null, this.billType_application, true);
                    newGroupRow.put(groupNum, newGroup);
                }
                newBill = this.createNode(outerBillNanme, outerBillNum, groupNum, outerBillId, fullName, this.billType_bill, true);
                newOuterBill.add(newBill);
            }
        }
        qb = new QFBuilder();
        qb.add("number", "in", newGroupRow.keySet());
        String groupRowId = null;
        String groupRowNum = null;
        Iterator iterator = null;
        DataSet data = QueryServiceHelper.queryDataSet((String)"FieldRegisterList", (String)"eb_structofbill", (String)"id,number", (QFilter[])qb.toArrays(), null);
        Object object = null;
        try {
            while (data.hasNext()) {
                rowData = data.next();
                groupRowNum = rowData.getString("number");
                groupRowId = rowData.getString("id");
                iterator = newOuterBill.iterator();
                newGroupRow.remove(groupRowNum);
                while (iterator.hasNext()) {
                    DynamicObject bill = (DynamicObject)iterator.next();
                    String parent = bill.getString("parent");
                    if (parent == null || !parent.equals(groupRowNum)) continue;
                    bill.set("parent", (Object)groupRowId);
                }
            }
        }
        catch (Throwable bill) {
            object = bill;
            throw bill;
        }
        finally {
            if (data != null) {
                if (object != null) {
                    try {
                        data.close();
                    }
                    catch (Throwable bill) {
                        ((Throwable)object).addSuppressed(bill);
                    }
                } else {
                    data.close();
                }
            }
        }
        if (!newGroupRow.isEmpty()) {
            String outerNodeId = this.getPageCache().get("OUTER_NODE_ID");
            if (outerNodeId == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u521b\u5efa\u5916\u90e8\u7cfb\u7edf\u8282\u70b9\u3002", (String)"FieldRegisterList_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                for (DynamicObject row : newGroupRow.values()) {
                    row.set("parent", (Object)outerNodeId);
                    String groupId = row.getString("id");
                    groupNum = row.getString("number");
                    for (DynamicObject dynamicObject : newOuterBill) {
                        String parent = dynamicObject.getString("parent");
                        if (parent == null || !parent.equals(groupNum)) continue;
                        dynamicObject.set("parent", (Object)groupId);
                    }
                }
                newOuterBill.addAll(newGroupRow.values());
            }
        }
        SaveServiceHelper.save((DynamicObject[])newOuterBill.toArray(new DynamicObject[0]));
        this.writeLog("save", new MultiLangEnumBridge("\u4fdd\u5b58", "FieldRegisterList_25", "epm-eb-formplugin"), new MultiLangEnumBridge("\u6dfb\u52a0\u5916\u90e8\u5355\u636e\u6210\u529f\u3002", "FieldRegisterList_28", "epm-eb-formplugin"));
        this.initLeftTree();
    }

    private void openNewPage(Map<String, Object> returnData) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_addbillfield");
        showParameter.setCustomParams(returnData);
        if ("operation".equals(returnData.get(formtype))) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u5355\u636e\u64cd\u4f5c\u6ce8\u518c", (String)"FieldRegisterList_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            showParameter.setCaption(ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5\u6ce8\u518c", (String)"FieldRegisterList_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        CloseCallBack closeCallBack1 = new CloseCallBack((IFormPlugin)this, (String)returnData.get(formtype));
        showParameter.setCloseCallBack(closeCallBack1);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void initLeftTree() {
        TreeView treeLeft = (TreeView)this.getView().getControl(treeviewap);
        TreeNode leftNode = this.billListUtil.getUserBillTree();
        TreeNode firstNode = BillListUtil.getFirstBillNode((TreeNode)leftNode);
        this.cacheTopNodeId(leftNode);
        treeLeft.deleteAllNodes();
        treeLeft.updateNode(leftNode);
        this.cacheLeftRoot(leftNode);
        treeLeft.addNode(leftNode);
        if (firstNode != null) {
            treeLeft.focusNode(firstNode);
        }
        EpmTreeUtils.spreadAllNode((TreeNode)leftNode);
    }

    private void cacheTopNodeId(TreeNode leftNode) {
        if (leftNode.getChildren() == null) {
            return;
        }
        leftNode.getChildren().forEach(node -> {
            Map data = (Map)node.getData();
            if (data.get("number") != null && ((String)data.get("number")).equals("INSIDE_NODE")) {
                this.getPageCache().put("INSIDE_NODE_ID", node.getId());
            } else if (data.get("number") != null && ((String)data.get("number")).equals("OUTER_NODE")) {
                this.getPageCache().put("OUTER_NODE_ID", node.getId());
            }
        });
    }

    private void initRightTree() {
        try {
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            billList.clearSelection();
            billList.refresh();
            BillList billList1 = (BillList)this.getControl(BILLLISTAP1);
            billList1.clearSelection();
            billList1.refresh();
            Thread.sleep(500L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private QFilter getBillListQFilter(String type) {
        TreeNode cacheLeftClickTree = this.getCurrentLefTreeNode();
        if (cacheLeftClickTree != null) {
            this.getPageCache().put("cachetreenode", StringUtils.toNoEmptyString((Object)cacheLeftClickTree.getId()));
            List names = BillFieldTypeEmum.getFieldNameByType((String)type);
            QFilter qFilter = new QFilter("bill.id", "=", (Object)IDUtils.toLong((Object)cacheLeftClickTree.getId()));
            qFilter.and("fielddimension", "in", (Object)names);
            return qFilter;
        }
        return new QFilter("1", "=", (Object)2);
    }

    protected TreeNode getCacheLeftRoot() {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(leftTree))) {
            TreeNode leftRoot = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(leftTree), TreeNode.class);
            return leftRoot;
        }
        return null;
    }

    protected void cacheLeftRoot(TreeNode rootleft) {
        this.getPageCache().put(leftTree, SerializationUtils.toJsonString((Object)rootleft));
    }

    private DynamicObject createNode(Object name, String number, String parentId, String longNumber, String longName, String billType, boolean isFromOter) {
        Long userId = UserUtils.getUserId();
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_structofbill");
        dynamicObject.set("id", (Object)DBServiceHelper.genGlobalLongId());
        if (name instanceof ILocaleString) {
            new LocaleString();
            dynamicObject.set("name", (Object)LocaleString.fromMap((Map)((ILocaleString)name)));
        } else {
            dynamicObject.set("name", (Object)new LocaleString(StringUtils.toNoEmptyString((Object)name)));
        }
        dynamicObject.set("number", (Object)number);
        dynamicObject.set("creator", (Object)userId);
        LocalDateTime localDateTime = LocalDateTime.now();
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        Date createTime = Date.from(instant);
        dynamicObject.set("createtime", (Object)createTime);
        dynamicObject.set("enable", (Object)1);
        dynamicObject.set("status", (Object)"C");
        dynamicObject.set("modifytime", (Object)createTime);
        dynamicObject.set("isleaf", (Object)0);
        dynamicObject.set("longnumber", (Object)longNumber);
        dynamicObject.set("billtype", (Object)billType);
        dynamicObject.set("parent", (Object)parentId);
        dynamicObject.set("isfromouter", (Object)isFromOter);
        dynamicObject.set("fullname", (Object)longName);
        if (billType != null && billType.equals(this.billType_bill)) {
            dynamicObject.set("fieldtable", (Object)number);
            dynamicObject.set("isleaf", (Object)1);
        }
        return dynamicObject;
    }

    private void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                int billDataCount = this.getBillDataCount();
                DynamicObjectCollection dynamicObjects = super.getData(start, limit);
                if (!dynamicObjects.isEmpty()) {
                    String insideNodeId = FieldRegisterList.this.getPageCache().get("cachetreenode");
                    if (insideNodeId == null) {
                        return dynamicObjects;
                    }
                    StringBuilder names = new StringBuilder();
                    IDataEntityProperty dp = null;
                    DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(insideNodeId), (String)"eb_structofbill");
                    if (bill == null) {
                        return dynamicObjects;
                    }
                    MainEntityType entityType = null;
                    EntityMetadata entityMeta = null;
                    for (DynamicObject datum : dynamicObjects) {
                        String cnName = datum.getString("fielddimension");
                        BillFieldTypeEmum billField = BillFieldTypeEmum.getNameByCnName((String)cnName);
                        datum.set("fielddimension", (Object)billField.getName());
                        if ("field".equals(billField.getType())) {
                            try {
                                if (entityType == null) {
                                    entityType = EntityMetadataCache.getDataEntityType((String)bill.getString("number"));
                                }
                                if (entityType == null) continue;
                                try {
                                    String field = datum.getString("entryentity.number");
                                    if ((datum.getString("fieldDimension").equals(BillFieldTypeEmum.REGSITFIELD.getName()) || datum.getString("fieldDimension").equals(BillFieldTypeEmum.REGSITFIELD.getCnName())) && field.startsWith("model.")) {
                                        field = field.replace("model.", "");
                                    }
                                    String[] props = field.split("\\.");
                                    names.setLength(0);
                                    MainEntityType de = entityType;
                                    for (String prop : props) {
                                        if (de == null) {
                                            names.setLength(0);
                                            break;
                                        }
                                        dp = (IDataEntityProperty)de.getProperties().get((Object)prop);
                                        if (dp != null) {
                                            if (names.length() > 0) {
                                                names.append(".");
                                            }
                                        } else {
                                            names.setLength(0);
                                            break;
                                        }
                                        names.append(dp.getDisplayName().getLocaleValue());
                                        if (dp instanceof EntryProp) {
                                            de = ((EntryProp)dp).getItemType();
                                            continue;
                                        }
                                        if (!(dp instanceof IComplexProperty)) continue;
                                        de = ((IComplexProperty)dp).getComplexType();
                                    }
                                    if (names.length() <= 0) continue;
                                    datum.set("entryentity.name", (Object)names.toString());
                                }
                                catch (Throwable field) {
                                }
                            }
                            catch (Throwable e) {
                                log.info("no found bill = " + insideNodeId);
                            }
                            continue;
                        }
                        if (!"operation".equals(billField.getType())) continue;
                        try {
                            if (entityMeta == null) {
                                entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)bill.getString("number"), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Entity);
                            }
                            if (entityMeta == null) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u8be5\u5143\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u8be5\u5143\u6570\u636e\u662f\u5426\u5c5e\u4e8e\u5355\u636e\u7c7b\u578b\u3002", (String)"BillFieldAddPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            }
                            MainEntity rootEntity = entityMeta.getRootEntity();
                            List operations = rootEntity.getOperations();
                            String field = datum.getString("entryentity.number");
                            Operation operation = operations.stream().filter(k -> k.getKey().equals(field)).findAny().get();
                            datum.set("entryentity.name", (Object)operation.getName().getLocaleValue());
                        }
                        catch (Exception e) {
                            log.info("no found bill = " + insideNodeId);
                        }
                    }
                }
                this.getQueryResult().setDataCount(billDataCount);
                return dynamicObjects;
            }

            public int getRealCount() {
                return super.getRealCount();
            }

            public List<ListField> getListFields() {
                List fields = super.getListFields();
                HashSet<String> fs = new HashSet<String>(16);
                if (fields != null) {
                    for (ListField f : fields) {
                        fs.add(f.getKey());
                    }
                    if (!fs.contains("number")) {
                        ListField f = new ListField("number");
                        f.setFieldName("entryentity.number");
                        f.setEntityName("entryentity");
                        fields.add(f);
                    }
                }
                return fields;
            }
        });
    }
}

