/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.BgBillTreeTypeEnum;
import kd.epm.eb.common.utils.AppUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.LanguageUtils;

public class InsideBillInputPlugin
extends StandardTreeListPlugin
implements SearchEnterListener {
    public void initialize() {
        super.initialize();
        Search search = (Search)this.getControl("search");
        if (search != null) {
            search.addEnterListener(this::searchBill);
        }
        if (this.getView().getParentView() == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"billlistap"});
        }
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        this.addCloudAppNode(this.getTreeModel().getRoot());
    }

    public void addCloudAppNode(TreeNode root) {
        TreeNode childNode = null;
        Map cloudObjects = AppUtil.getAllCloud();
        Map appObjects = AppUtil.getAllAppId();
        QFBuilder qb = new QFBuilder();
        qb.add(this.getFormTypeQfilter());
        DynamicObjectCollection entitys = QueryServiceHelper.query((String)"bos_formmeta", (String)"number,type,bizappid", (QFilter[])qb.toArrays());
        HashSet<String> appIds = new HashSet<String>(entitys.size());
        for (DynamicObject entity : entitys) {
            String bizAppId = entity.getString("bizappid");
            appIds.add(bizAppId);
        }
        HashMap<String, TreeNode> cloudNodes = new HashMap<String, TreeNode>(cloudObjects.size());
        if (!cloudObjects.isEmpty()) {
            String rootId = root.getId();
            for (DynamicObject cloud : cloudObjects.values()) {
                String id = cloud.getString("id");
                String name = LanguageUtils.getLocaleValue((Object)cloud.get("name"));
                childNode = new TreeNode();
                childNode.setText(name);
                childNode.setId(id);
                childNode.setParentid(rootId);
                childNode.setData((Object)BgBillTreeTypeEnum.CLOUD.getNumber());
                cloudNodes.put(id, childNode);
            }
            if (!appObjects.isEmpty()) {
                for (DynamicObject app : appObjects.values()) {
                    String parentId;
                    TreeNode parentNode;
                    DynamicObject cloud;
                    String id = app.getString("id");
                    String name = LanguageUtils.getLocaleValue((Object)app.get("name"));
                    cloud = app.getDynamicObject("bizcloud");
                    if (cloud == null || (parentNode = (TreeNode)cloudNodes.get(parentId = cloud.getString("id"))) == null || !appIds.contains(id)) continue;
                    childNode = new TreeNode();
                    childNode.setText(name);
                    childNode.setId(id);
                    childNode.setParentid(parentId);
                    childNode.setData((Object)BgBillTreeTypeEnum.APPLICATION.getNumber());
                    parentNode.addChild(childNode);
                }
            }
            root.addChildren(new ArrayList(cloudNodes.values()));
            this.removeNullCloudNode(root);
            root.setData((Object)BgBillTreeTypeEnum.ALL.getNumber());
        }
    }

    public void removeNullCloudNode(TreeNode root) {
        List childs = root.getChildren();
        if (childs != null) {
            Iterator iterator = childs.iterator();
            TreeNode treeNode = null;
            while (iterator.hasNext()) {
                treeNode = (TreeNode)iterator.next();
                if (treeNode.getChildren() != null && !treeNode.getChildren().isEmpty()) continue;
                iterator.remove();
            }
        }
    }

    protected QFilter nodeClickFilter() {
        QFilter qf = null;
        TreeListModel treeModel = (TreeListModel)this.getTreeModel();
        String currentId = String.valueOf(treeModel.getCurrentNodeId());
        if (!currentId.equals("null")) {
            TreeNode root = treeModel.getRoot();
            TreeNode currentNode = root.getTreeNode(currentId, 3);
            String nodeType = String.valueOf(currentNode.getData());
            if (nodeType.equals(BgBillTreeTypeEnum.ALL.getNumber())) {
                qf = new QFilter("id", "!=", (Object)"1");
            } else if (nodeType.equals(BgBillTreeTypeEnum.CLOUD.getNumber())) {
                List childs = currentNode.getChildren();
                ArrayList<String> appIds = new ArrayList<String>(16);
                if (childs != null) {
                    for (TreeNode child : childs) {
                        String appId = child.getId();
                        appIds.add(appId);
                    }
                }
                qf = new QFilter("bizappid", "in", appIds);
            } else if (nodeType.equals(BgBillTreeTypeEnum.APPLICATION.getNumber())) {
                qf = new QFilter("bizappid", "=", (Object)currentId);
            }
        }
        return qf;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(this.getFormTypeQfilter());
    }

    public QFilter getFormTypeQfilter() {
        String _searchText;
        QFilter filter = new QFilter("modeltype", "=", (Object)"BillFormModel");
        Search search = (Search)this.getControl("search");
        if (search != null && StringUtils.isNotEmpty((String)(_searchText = search.getSearchKey()))) {
            filter.and(new QFilter("number", "like", (Object)("%" + _searchText.trim() + "%")).or("name", "like", (Object)("%" + _searchText.trim() + "%")));
        }
        return filter;
    }

    public void searchBill(SearchEnterEvent evt) {
        BillList list = (BillList)this.getControl("billlistap");
        if (list != null) {
            list.refreshData();
        }
    }
}

