/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.CommonServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class RuleControlAccountsInfoPlugin
extends AbstractFormPlugin {
    private static final String treeKey = "treeleft";
    private static final String treeNodeKey = "treeNodeleft";
    private List<String> rightTreeCheckedNodeIds = new ArrayList<String>(16);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"allexpand", "allshrink", "buttonreflesh", "searchbefore", "searchnext"});
        Search sl = (Search)this.getControl("searchapleft");
        sl.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                RuleControlAccountsInfoPlugin.this.searchTreeNodes(event.getText());
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initLeftTree();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String actionKey = ((Control)evt.getSource()).getKey();
        if (actionKey.equals("allexpand")) {
            this.spreadAll();
        } else if (actionKey.equals("allshrink")) {
            this.collapseAll();
        } else if (actionKey.equals("buttonreflesh")) {
            CommonServiceHelper.searchTreeNode((IPageCache)this.getPageCache(), (TreeView)((TreeView)this.getControl(treeNodeKey)), (String)treeNodeKey, (String)"");
            this.initLeftTree();
        } else if (actionKey.equals("searchbefore")) {
            this.searchBefore();
        } else if (actionKey.equals("searchnext")) {
            this.searchNext();
        }
    }

    private void initLeftTree() {
        TreeView leftTree = (TreeView)this.getControl(treeKey);
        TreeNode root = this.getLeftRoot();
        this.dealTree(root);
        leftTree.deleteAllNodes();
        leftTree.addNode(root);
        this.cacheLeftRoot(root);
        if (root.getChildren() != null) {
            root.setIsOpened(true);
            this.spreadChild(root);
        }
    }

    private void searchTreeNodes(String SearchInfo) {
        TreeView leftTreeView;
        IPageCache pageCache = this.getPageCache();
        int result = CommonServiceHelper.searchTreeNode((IPageCache)pageCache, (TreeView)(leftTreeView = (TreeView)this.getControl(treeKey)), (String)treeNodeKey, (String)SearchInfo);
        if (result == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5185\u5bb9\u540e\uff0c\u6309\u56de\u8f66\u952e\u641c\u7d22\u3002", (String)"RuleControlAccountsInfoPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (result == 2) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u54cd\u5e94\u6570\u636e", (String)"RuleControlAccountsInfoPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private Object getInfoFromFormParam(String key) {
        FormShowParameter formParam = this.getView().getFormShowParameter();
        return formParam.getCustomParam(key);
    }

    private TreeNode getLeftRoot() {
        TreeNode membertree = new TreeNode();
        String modelID = String.valueOf(this.getInfoFromFormParam("modelId"));
        QFilter qModel = new QFilter("model", "=", (Object)Long.parseLong(modelID));
        List accounts = null;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getLeftRoot", (String)"epm_accountmembertree", (String)"id,number,name,parent", (QFilter[])qModel.toArray(), (String)"parent");){
            accounts = CommonServiceHelper.transDataSet((DataSet)ds);
        }
        String rootID = String.valueOf(((Map)accounts.get(0)).get("id"));
        membertree.setId(rootID);
        membertree.setText(((Map)accounts.get(0)).get("number") + " " + ((Map)accounts.get(0)).get("name"));
        accounts.remove(0);
        Set noPermMembIds = DimMembPermHelper.getPermMemberIds((String)SysDimensionEnum.Account.getNumber(), (Long)Long.parseLong(modelID), (Long)0L, null, (DimMembPermType)DimMembPermType.READ, (boolean)false);
        Map<String, List<Map<String, String>>> memberList = this.getMemberList(accounts, noPermMembIds, rootID);
        this.setEntryNode(membertree, memberList, rootID);
        return membertree;
    }

    private Map<String, List<Map<String, String>>> getMemberList(List<Map<String, Object>> dcs, Set<Long> noPermMembId, String rootId) {
        HashMap menberList = Maps.newHashMap();
        if (noPermMembId == null) {
            noPermMembId = new HashSet<Long>(16);
        }
        if (dcs != null && dcs.size() > 0) {
            String pid = null;
            for (Map<String, Object> task : dcs) {
                String id = String.valueOf(task.get("id"));
                if (noPermMembId.contains(Long.valueOf(id))) continue;
                HashMap<String, String> memberMap = new HashMap<String, String>();
                memberMap.put("id", task.get("id").toString());
                memberMap.put("number", String.valueOf(task.get("number")));
                memberMap.put("name", task.get("number") + "\n\n" + task.get("name"));
                pid = String.valueOf(task.get("parent"));
                if (noPermMembId.contains(Long.valueOf(pid))) {
                    pid = rootId;
                }
                memberMap.put("parentid", pid);
                menberList.computeIfAbsent(pid, f -> Lists.newArrayList()).add(memberMap);
            }
        }
        return menberList;
    }

    private TreeNode setEntryNode(TreeNode root, Map<String, List<Map<String, String>>> rootNodeList, String headId) {
        if (rootNodeList.get(headId) == null) {
            return root;
        }
        for (Map<String, String> map : rootNodeList.get(headId)) {
            if (!map.get("parentid").equals(headId)) continue;
            TreeNode entry = new TreeNode();
            entry.setParentid(headId);
            entry.setId(map.get("id"));
            entry.setText(map.get("name"));
            String entryHeadId = map.get("id");
            map.put("isNew", "1");
            entry.setData(map);
            this.setEntryNode(entry, rootNodeList, entryHeadId);
            ArrayList<TreeNode> children = root.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>();
                root.setChildren(children);
            }
            children.add(entry);
        }
        return root;
    }

    private boolean dealTree(TreeNode node) {
        boolean haveCheck = true;
        List childs = node.getChildren();
        boolean isCheck = this.checkNodeOfLeftIsChecked(node);
        if (childs == null) {
            haveCheck = isCheck;
        } else {
            ListIterator iterator = childs.listIterator();
            while (iterator.hasNext()) {
                TreeNode childNode = (TreeNode)iterator.next();
                if (this.dealTree(childNode)) continue;
                iterator.remove();
            }
            if (childs.size() == 0) {
                node.setChildren(null);
                haveCheck = isCheck;
            }
        }
        return haveCheck;
    }

    private List<String> getRightCheckNodeIds() {
        Object ids;
        if (this.rightTreeCheckedNodeIds.isEmpty() && (ids = this.getInfoFromFormParam("accountIds")) != null) {
            this.rightTreeCheckedNodeIds = (List)ids;
        }
        return this.rightTreeCheckedNodeIds;
    }

    private boolean checkNodeOfLeftIsChecked(TreeNode node) {
        String nodeId = node.getId();
        List<String> checkIds = this.getRightCheckNodeIds();
        return checkIds.contains(nodeId);
    }

    private void collapseAll() {
        TreeNode leftRoot = this.getCacheLeftRoot();
        if (leftRoot == null) {
            return;
        }
        if (leftRoot.getChildren() != null) {
            this.collapseChild(leftRoot);
        }
        TreeView treeleft = (TreeView)this.getView().getControl(treeKey);
        treeleft.deleteAllNodes();
        treeleft.addNode(leftRoot);
    }

    private void spreadAll() {
        TreeNode leftRoot = this.getCacheLeftRoot();
        if (leftRoot == null) {
            return;
        }
        if (leftRoot.getChildren() != null) {
            leftRoot.setIsOpened(true);
            this.spreadChild(leftRoot);
        }
        TreeView treeleft = (TreeView)this.getView().getControl(treeKey);
        treeleft.deleteAllNodes();
        treeleft.addNode(leftRoot);
    }

    private void spreadChild(TreeNode leftRoot) {
        leftRoot.getChildren().forEach(new Consumer<TreeNode>(){

            @Override
            public void accept(TreeNode t) {
                if (t.getChildren() != null) {
                    t.setIsOpened(true);
                    RuleControlAccountsInfoPlugin.this.spreadChild(t);
                }
            }
        });
    }

    private TreeNode getCacheLeftRoot() {
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(treeNodeKey))) {
            TreeNode leftRoot = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(treeNodeKey), TreeNode.class);
            return leftRoot;
        }
        return null;
    }

    private void cacheLeftRoot(TreeNode rootleft) {
        this.getPageCache().put(treeNodeKey, SerializationUtils.toJsonString((Object)rootleft));
    }

    private void collapseChild(TreeNode leftRoot) {
        leftRoot.getChildren().forEach(new Consumer<TreeNode>(){

            @Override
            public void accept(TreeNode t) {
                if (t.getChildren() != null) {
                    t.setIsOpened(false);
                    RuleControlAccountsInfoPlugin.this.collapseChild(t);
                }
            }
        });
    }

    private void searchNext() {
        TreeView leftTreeView = (TreeView)this.getControl(treeKey);
        int result = CommonServiceHelper.nextOrBeforeMatchNode((IPageCache)this.getPageCache(), (TreeView)leftTreeView, (String)treeNodeKey, (boolean)false);
        if (result == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5185\u5bb9\u540e\uff0c\u6309\u56de\u8f66\u952e\u641c\u7d22\u3002", (String)"RuleControlAccountsInfoPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (result == 2) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u6761\u6570\u636e\u3002", (String)"RuleControlAccountsInfoPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void searchBefore() {
        TreeView leftTreeView = (TreeView)this.getControl(treeKey);
        int result = CommonServiceHelper.nextOrBeforeMatchNode((IPageCache)this.getPageCache(), (TreeView)leftTreeView, (String)treeNodeKey, (boolean)true);
        if (result == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5185\u5bb9\u540e\uff0c\u6309\u56de\u8f66\u952e\u641c\u7d22\u3002", (String)"RuleControlAccountsInfoPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (result == 2) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u7ecf\u662f\u7b2c\u4e00\u6761\u6570\u636e\u3002", (String)"RuleControlAccountsInfoPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }
}

