/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.control.ControlRuleHelper;

public class RuleControlAddDefaultPlugin
extends AbstractFormPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"barsave"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map param = this.getView().getFormShowParameter().getCustomParams();
        String modelId = String.valueOf(param.get("model"));
        String pageState = String.valueOf(param.get("pageState"));
        Long pkid = null;
        if (pageState.equals("edit")) {
            pkid = IDUtils.toLong(param.get("pkid"));
            this.getPageCache().put("pkid", pkid.toString());
            this.setPageData(pkid);
        }
        this.getPageCache().put("modelId", modelId);
        this.getPageCache().put("pageState", pageState);
        this.cacheOldData();
        this.setPeriodclassify();
    }

    private void setPeriodclassify() {
        DynamicObject model = ModelUtils.getModel((Long)IDUtils.toLong((Object)this.getPageCache().get("modelId")));
        String reportType = model.getString("reporttype");
        if (ApplicationTypeEnum.isEB((String)reportType)) {
            String periodclassify = ModelUtils.getDetailedPeriod((Long)model.getLong("id"));
            this.getModel().setValue("periodclassify", (Object)periodclassify);
            this.setControlType(periodclassify, false);
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"periodclassify"});
    }

    private void cacheOldData() {
        String[] params;
        IDataModel model = this.getModel();
        for (String param : params = "controltype,periodclassify,coefficient,isbeyond,isfreetype".split(",")) {
            Object value = model.getValue(param);
            if (value == null) {
                this.getPageCache().put(param, null);
                continue;
            }
            this.getPageCache().put(param, String.valueOf(value));
        }
    }

    private void setPageData(Long pkid) {
        QFilter qEntryId = new QFilter("id", "=", (Object)pkid);
        DynamicObject dy = QueryServiceHelper.queryOne((String)"eb_bgcontrolrulemain", (String)ControlRuleHelper.MAIN_SELECTFIELDS, (QFilter[])new QFilter[]{qEntryId});
        IDataModel model = this.getModel();
        if (dy != null) {
            this.setControlType(dy.getString("periodclassify"), false);
            model.setValue("periodclassify", dy.get("periodclassify"));
            model.setValue("controltype", dy.get("controltype"));
            model.setValue("coefficient", dy.get("coefficient"));
            model.setValue("isbeyond", dy.get("isbeyond"));
            model.setValue("isfreetype", dy.get("isfreetype"));
            model.setValue("effectivedate", dy.get("effectivedate"));
            model.setValue("invaliddate", dy.get("invaliddate"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (key.equals("periodclassify")) {
            String newVal = String.valueOf(e.getChangeSet()[0].getNewValue());
            this.setControlType(newVal, true);
        } else if ("effectivedate".equals(key)) {
            this.updateValueForNull(Collections.singletonList("invaliddate"));
        } else if ("invaliddate".equals(key)) {
            this.checkDate();
        }
    }

    private void checkDate() {
        Object effObj = this.getModel().getValue("effectivedate");
        if (effObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"ControlVersionEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.updateValueForNull(Collections.singletonList("invaliddate"));
        } else {
            Object invaobj = this.getModel().getValue("invaliddate");
            if (invaobj != null && ((Date)invaobj).before((Date)effObj)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"ControlVersionEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.updateValueForNull(Collections.singletonList("invaliddate"));
            }
        }
    }

    private void updateValueForNull(List<String> keys) {
        this.getModel().beginInit();
        for (String key : keys) {
            this.getModel().setValue(key, null);
            this.getView().updateView(key);
        }
        this.getModel().endInit();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String confimeClose = this.getPageCache().get("confimeClose");
        if (confimeClose == null && this.checkDataChanged()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4fee\u6539\u4e14\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u9000\u51fa\uff1f", (String)"RuleControlAddDefaultPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("close", (IFormPlugin)this));
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String actionKey = mbce.getCallBackId();
        if (actionKey.equals("close") && MessageBoxResult.Yes.name().equals(mbce.getResultValue())) {
            this.getPageCache().put("confimeClose", "true");
            this.getView().close();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("barsave".equals(key) && this.saveData()) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"RuleControlAddDefaultPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }

    private boolean saveData() {
        String pageState = this.getPageCache().get("pageState");
        if (pageState.equals("edit")) {
            if (!this.checkData()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u67d4\u6027\u7cfb\u6570\u201d\u3002", (String)"RuleControlAddDefaultPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            String pkid = this.getPageCache().get("pkid");
            DynamicObject mainRow = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"eb_bgcontrolrulemain");
            mainRow.set("modifier", (Object)UserUtils.getUserId());
            mainRow.set("modifydate", (Object)TimeServiceHelper.now());
            mainRow.set("effectivedate", this.getModel().getValue("effectivedate"));
            mainRow.set("invaliddate", this.getModel().getValue("invaliddate"));
            this.setModelData2DynamicObject(mainRow, "controltype,periodclassify,coefficient,isbeyond,isfreetype".split(","));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainRow});
            this.writeLog(pkid, "save", new MultiLangEnumBridge("\u4fee\u6539\u4fdd\u5b58", "RuleControlAddDefaultPlugin_5", "epm-eb-formplugin"), new MultiLangEnumBridge("\u7f16\u53f7\uff1a%1$s\uff0c\u4fdd\u5b58\u6210\u529f\u3002", "RuleControlAddDefaultPlugin_4", "epm-eb-formplugin"), new String[]{pkid});
        } else {
            if (!this.checkData()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u67d4\u6027\u7cfb\u6570\u201d\u3002", (String)"RuleControlAddDefaultPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
            DynamicObject mainRow = BusinessDataServiceHelper.newDynamicObject((String)"eb_bgcontrolrulemain");
            mainRow.set("model", (Object)this.getPageCache().get("modelId"));
            this.setModelData2DynamicObject(mainRow, "controltype,periodclassify,coefficient,isbeyond,isfreetype".split(","));
            mainRow.set("creater", (Object)UserUtils.getUserId());
            mainRow.set("createdate", (Object)TimeServiceHelper.now());
            mainRow.set("isdefault", (Object)1);
            mainRow.set("effectivedate", this.getModel().getValue("effectivedate"));
            mainRow.set("invaliddate", this.getModel().getValue("invaliddate"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainRow});
            this.writeLog(mainRow.getString("id"), "addnew", new MultiLangEnumBridge("\u65b0\u589e\u4fdd\u5b58", "RuleControlAddDefaultPlugin_3", "epm-eb-formplugin"), new MultiLangEnumBridge("\u7f16\u53f7\uff1a%1$s\uff0c\u4fdd\u5b58\u6210\u529f\u3002", "RuleControlAddDefaultPlugin_4", "epm-eb-formplugin"), new String[]{mainRow.getString("id")});
            this.getPageCache().put("pageState", "edit");
            this.getPageCache().put("pkid", mainRow.getString("id"));
        }
        this.cacheOldData();
        return true;
    }

    private boolean checkData() {
        IDataModel model = this.getModel();
        BigDecimal coefficient = (BigDecimal)model.getValue("coefficient");
        return coefficient.compareTo(new BigDecimal("9.99")) <= 0 && coefficient.compareTo(BigDecimal.ZERO) > 0;
    }

    private void setControlType(String periodclassify, boolean needNull) {
        ComboEdit combo = (ComboEdit)this.getControl("controltype");
        List<ComboItem> items = null;
        switch (periodclassify) {
            case "1": {
                items = ControlRuleHelper.createControlTypeList(new ArrayList<String>(16));
                break;
            }
            case "2": {
                items = ControlRuleHelper.createControlTypeList(Arrays.asList("1", "4"));
                break;
            }
            case "3": {
                items = ControlRuleHelper.createControlTypeList(Arrays.asList("1", "4", "2", "5"));
                break;
            }
        }
        combo.setComboItems(items);
        if (needNull) {
            this.getModel().setValue("controltype", null);
        }
    }

    private void setModelData2DynamicObject(DynamicObject dy, String ... keys) {
        IDataModel model = this.getModel();
        for (String key : keys) {
            dy.set(key, model.getValue(key));
        }
    }

    private boolean checkDataChanged() {
        String[] params;
        IDataModel model = this.getModel();
        for (String param : params = "controltype,periodclassify,coefficient,isbeyond,isfreetype".split(",")) {
            String oldVal = this.getPageCache().get(param);
            Object newVal = model.getValue(param);
            if (oldVal != null && newVal != null && !oldVal.equals(String.valueOf(newVal))) {
                return true;
            }
            if ((oldVal != null || newVal == null) && (oldVal == null || newVal != null)) continue;
            return true;
        }
        return false;
    }
}

