/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.central.OrgMemberDto;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SingleF7TypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.log.BcmLogFactory;
import kd.epm.eb.common.log.WatchLogger;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.control.AllotOrg;
import kd.epm.eb.formplugin.control.ControlRuleHelper;
import kd.epm.eb.formplugin.utils.SingleMemberF7Util;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.lang3.StringUtils;

public class RuleControlAddNewPlugin
extends AbstractFormPlugin
implements SingleMemberF7Util.ISingleMemberF7Handle,
BeforeF7SelectListener,
AllotOrg {
    private static Log log1 = LogFactory.getLog(RuleControlAddNewPlugin.class);
    private static final String MODEL_KEY = "model";
    private Map<String, String> customDimKeyNums;
    private static final int DEFAULT_SIZE = 16;
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, RuleControlAddNewPlugin.class);
    private static final String MAIN_FIELDS = "controltype,periodclassify,coefficient,isbeyond,effectivedate,invaliddate";
    private static final String USER_DEFINED_DIM_IDS = "userDefinedDimIds";

    public void initialize() {
        super.initialize();
        this.initDefineF7();
    }

    @Override
    public void registerListener(EventObject e) {
        BasedataEdit basedataEditBuss;
        BasedataEdit basedataEditModel = (BasedataEdit)this.getControl(MODEL_KEY);
        if (basedataEditModel != null) {
            basedataEditModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{"bar_save", "bar_addnew", "orgrange"});
        BasedataEdit dataEdit = (BasedataEdit)this.getControl("mulquota");
        if (dataEdit != null) {
            dataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((basedataEditBuss = (BasedataEdit)this.getControl("bussmodel")) != null) {
            basedataEditBuss.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        for (int i = 1; i <= 7; ++i) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl("userdefined" + i);
            if (basedataEdit == null) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long modelId = Long.valueOf((String)customParams.get(MODEL_KEY));
        String pageState = (String)customParams.get("pageState");
        String userDefinedDimIds = (String)customParams.get(USER_DEFINED_DIM_IDS);
        this.getModel().setValue(MODEL_KEY, (Object)modelId);
        this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
        this.getPageCache().put("pageState", pageState);
        this.getPageCache().put(USER_DEFINED_DIM_IDS, userDefinedDimIds);
        HashMap<String, String> defineDim2F7key = new HashMap<String, String>(16);
        HashMap<String, String> difineDimKey2Names = new HashMap<String, String>(16);
        HashMap<String, Long> difineDimKey2Ids = new HashMap<String, Long>(16);
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"epm_dimension", (String)"id,number,name", (QFilter[])new QFBuilder().add(MODEL_KEY, "=", (Object)modelId).add("issysdimension", "=", (Object)Character.valueOf('0')).toArray(), (String)"dseq");
        List<Long> businessModel = this.getBusinessModel(modelId);
        boolean bgmdModel = CommonUtils.isBgmdModel((Long)modelId);
        int i = 1;
        for (DynamicObject defineDim : dims) {
            Long id = defineDim.getLong("id");
            if (!businessModel.contains(id) && (bgmdModel || ModelUtil.isBGModel((Long)modelId))) continue;
            String name = defineDim.getString("name");
            String number = defineDim.getString("number");
            String f7key = "userdefined" + i++;
            difineDimKey2Names.put(f7key, name);
            defineDim2F7key.put(number, f7key);
            difineDimKey2Ids.put(f7key, id);
            BasedataEdit control = (BasedataEdit)this.getControl(f7key);
            control.setCaption(new LocaleString(name));
            this.getView().setVisible(Boolean.valueOf(true), new String[]{f7key});
        }
        this.getPageCache().put("userdefinedMap", ObjectSerialUtil.toByteSerialized(defineDim2F7key));
        this.getPageCache().put("difineDimNames", ObjectSerialUtil.toByteSerialized(difineDimKey2Names));
        this.getPageCache().put("difineDimIds", ObjectSerialUtil.toByteSerialized(difineDimKey2Ids));
        if (pageState.equals("edit")) {
            Long pkid = IDUtils.toLong(customParams.get("pkid"));
            this.getPageCache().put("pkid", pkid.toString());
            this.backfillData2Page(pkid);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"orgrange", "periodclassify"});
            boolean isExit = BgControlUtils.hasBgControlRecord((Long)this.getModelId(), (Long)this.getBussModelId());
            if (isExit) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"bussmodel"});
            }
        } else if ("add".equalsIgnoreCase(pageState)) {
            Long bussModelId = Long.valueOf((String)customParams.get("bussmodel"));
            this.getModel().setValue("bussmodel", (Object)bussModelId);
        }
        this.setDefVisable(modelId, false);
        this.cacheOldData();
        this.initSingleMemberF7(new ArrayList<String>(difineDimKey2Names.keySet()), SingleF7TypeEnum.LEAF);
        this.setDTAndATVisible();
    }

    private void setDefVisable(Long modelId, Boolean needfresh) {
        HashMap<String, String> difineDimKey2Names = new HashMap<String, String>(16);
        HashMap<String, Long> difineDimKey2Ids = new HashMap<String, Long>(16);
        HashMap<String, String> defineDim2F7key = new HashMap<String, String>(16);
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"epm_dimension", (String)"id,number,name", (QFilter[])new QFBuilder().add(MODEL_KEY, "=", (Object)modelId).add("issysdimension", "=", (Object)"0").toArray(), (String)"dseq");
        List<Long> businessModel = this.getBusinessModel(modelId);
        boolean bgmdModel = CommonUtils.isBgmdModel((Long)modelId);
        List<DynamicObject> defDimension = this.getDefDimension(dims, businessModel, bgmdModel);
        Stream.iterate(1, x -> x + 1).limit(10L).forEach(i -> {
            String f7key = "userdefined" + i;
            this.getView().setVisible(Boolean.valueOf(false), new String[]{f7key});
            if (needfresh.booleanValue()) {
                this.getModel().setValue("mulquota", null);
                this.getModel().setValue(f7key, null);
                this.getView().updateView();
            }
        });
        int i2 = 1;
        if (defDimension.size() != 0) {
            for (DynamicObject defineDim : defDimension) {
                Long id = defineDim.getLong("id");
                if (!businessModel.contains(defineDim.getLong("id")) && (bgmdModel || ModelUtil.isBGModel((Long)modelId))) continue;
                String name = defineDim.getString("name");
                String number = defineDim.getString("number");
                String f7key = "userdefined" + i2++;
                difineDimKey2Names.put(f7key, name);
                defineDim2F7key.put(number, f7key);
                difineDimKey2Ids.put(f7key, id);
                BasedataEdit control = (BasedataEdit)this.getControl(f7key);
                control.setCaption(new LocaleString(name));
                this.getView().setVisible(Boolean.valueOf(true), new String[]{f7key});
            }
        }
        this.getPageCache().put("userdefinedMap", ObjectSerialUtil.toByteSerialized(defineDim2F7key));
        this.getPageCache().put("difineDimNames", ObjectSerialUtil.toByteSerialized(difineDimKey2Names));
        this.getPageCache().put("difineDimIds", ObjectSerialUtil.toByteSerialized(difineDimKey2Ids));
    }

    private List<DynamicObject> getDefDimension(DynamicObjectCollection dims, List<Long> businessModel, Boolean isBgmd) {
        if (isBgmd.booleanValue() || ModelUtil.isBGModel((Long)this.getModelId())) {
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(businessModel.size());
            for (DynamicObject dynamicObject : dims) {
                if (!businessModel.contains(dynamicObject.getLong("id"))) continue;
                list.add(dynamicObject);
            }
            return list;
        }
        return dims.stream().collect(Collectors.toList());
    }

    private void initSingleMemberF7(List<String> dimkeys, SingleF7TypeEnum f7type) {
        HashMap f7map = new HashMap(16);
        if (dimkeys == null) {
            dimkeys = new ArrayList<String>(16);
        }
        dimkeys.forEach(dimkey -> f7map.put(dimkey, f7type));
        this.getView().addCustomControls(f7map.keySet().toArray(new String[0]));
        this.getPageCache().put("dimKeyMap2Type", ObjectSerialUtil.toByteSerialized(f7map));
    }

    private List<Long> getBusinessModel(Long modelid) {
        DynamicObject model = ModelUtils.getModel((Long)modelid);
        ArrayList<Long> dimId = new ArrayList<Long>(16);
        if (ApplicationTypeEnum.BGMD.getIndex().equals(model.get("reporttype")) || ApplicationTypeEnum.BG.getIndex().equals(model.get("reporttype"))) {
            DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_bgmcontroldimension", (String)"entryentity.dimensionid", (QFilter[])new QFilter[]{new QFilter(MODEL_KEY, "=", (Object)model.getLong("id")).and("businessmodel", "=", (Object)this.getBussModelId())});
            for (DynamicObject dynamicObject : query) {
                dimId.add(dynamicObject.getLong("entryentity.dimensionid"));
            }
        }
        return dimId;
    }

    private void backfillData2Page(Long mainid) {
        IDataModel model = this.getModel();
        DynamicObjectCollection mainRows = QueryServiceHelper.query((String)"eb_bgcontrolrulemain", (String)ControlRuleHelper.MAIN_SELECTFIELDS, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)mainid)});
        for (String param : MAIN_FIELDS.split(",")) {
            model.setValue(param, ((DynamicObject)mainRows.get(0)).get(param));
        }
        this.setControlType(((DynamicObject)mainRows.get(0)).getString("periodclassify"), false);
        this.getModel().setValue("bussmodel", (Object)((DynamicObject)mainRows.get(0)).getString("bussmodel"));
        ArrayList<Long> accountIds = new ArrayList<Long>(16);
        for (DynamicObject row : mainRows) {
            accountIds.add((Long)row.get("accounts.account.id"));
        }
        model.setValue("mulquota", (Object)accountIds.toArray());
        String serialized = this.getPageCache().get(USER_DEFINED_DIM_IDS);
        Map userDefinedDimIds = new HashMap(10);
        if (StringUtils.isNotBlank((CharSequence)serialized)) {
            userDefinedDimIds = (Map)SerializationUtils.deSerializeFromBase64((String)serialized);
        }
        block2: for (int i = 1; i <= 7; ++i) {
            Long userDefinedDimId = (Long)userDefinedDimIds.get("userdefined" + i);
            for (int j = 1; j <= 7; ++j) {
                Long userDefinedDimIdByData = ((DynamicObject)mainRows.get(0)).getLong("dimentions.userdefineddimid" + j);
                if (userDefinedDimIdByData == null || userDefinedDimIdByData == 0L || !userDefinedDimIdByData.equals(userDefinedDimId)) continue;
                model.setValue("userdefined" + i, (Object)((DynamicObject)mainRows.get(0)).getString("dimentions.userdefined" + j + ".id"));
                continue block2;
            }
        }
        List<OrgMemberDto> records = ControlRuleHelper.getOrgList(new QFilter[]{new QFilter("controlrulemainid", "=", (Object)mainid)});
        String orgrange = records.stream().map(OrgMemberDto::getName).collect(Collectors.joining(","));
        this.getPageCache().put("checkedOrgs", ObjectSerialUtil.toByteSerialized(records));
        this.getModel().setValue("orgrange", (Object)orgrange);
        DynamicObject illustrateObj = BusinessDataServiceHelper.loadSingle((Object)mainid, (String)"eb_bgcontrolrulemain", (String)"id,illustrate");
        Object illustrate = illustrateObj.get("illustrate");
        this.getModel().setValue("illustrate", illustrate);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    private boolean checkData() {
        IDataModel model = this.getModel();
        BigDecimal coefficient = (BigDecimal)model.getValue("coefficient");
        return coefficient.compareTo(new BigDecimal("9.99")) <= 0 && coefficient.compareTo(new BigDecimal("0")) > 0;
    }

    @Override
    public void beforeSingleMemberF7Select(BeforeF7SelectEvent arg0) {
        String propName = arg0.getProperty().getName();
        FormShowParameter showParam = arg0.getFormShowParameter();
        if (propName.equals("mulquota")) {
            showParam.setCustomParam("isShowExchangeRate", (Object)"false");
        }
        showParam.setCustomParam("addNewShare", null);
        showParam.setCustomParam("showDimCombo", (Object)"false");
        showParam.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"RuleControlAddNewPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private List<String> editData() {
        Long pkid = IDUtils.toLong((Object)this.getPageCache().get("pkid"));
        DynamicObject toUpdateMain = BusinessDataServiceHelper.newDynamicObject((String)"eb_bgcontrolrulemain");
        DynamicObject oldMain = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"eb_bgcontrolrulemain");
        this.setModelData2DynamicObject(toUpdateMain, MAIN_FIELDS.split(","));
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Object illustrate = dataEntity.get("illustrate");
        toUpdateMain.set("id", (Object)pkid.toString());
        toUpdateMain.set("creater", oldMain.get("creater"));
        toUpdateMain.set("createdate", oldMain.get("createdate"));
        toUpdateMain.set("group", oldMain.get("group"));
        toUpdateMain.set(MODEL_KEY, oldMain.get(MODEL_KEY));
        toUpdateMain.set("illustrate", illustrate);
        if (oldMain.get("bussmodel") != null && this.getModel().getValue("bussmodel") != null) {
            if (!((DynamicObject)oldMain.get("bussmodel")).getString("id").equals(((DynamicObject)this.getModel().getValue("bussmodel")).getString("id"))) {
                toUpdateMain.set("bussmodel", (Object)((DynamicObject)this.getModel().getValue("bussmodel")).getString("id"));
            } else {
                toUpdateMain.set("bussmodel", oldMain.get("bussmodel"));
            }
        }
        toUpdateMain.set("modifier", (Object)UserUtils.getUserId());
        toUpdateMain.set("modifydate", (Object)TimeServiceHelper.now());
        DynamicObjectCollection accounts = (DynamicObjectCollection)this.getModel().getValue("mulquota");
        ArrayList accountIds = new ArrayList(16);
        accounts.forEach(account -> {
            String id = account.getString("fbasedataid_id");
            accountIds.add(id);
        });
        DynamicObjectCollection accountNameList = QueryServiceHelper.query((String)"epm_accountmembertree", (String)"name", (QFilter[])new QFilter("id", "in", (Object)IDUtils.toLongs(accountIds)).toArray());
        String showAccount = accountNameList.stream().map(k -> k.getString("name")).collect(Collectors.joining(","));
        if (StringUtils.isNotEmpty((CharSequence)showAccount) && showAccount.length() < 600) {
            toUpdateMain.set("showaccount", (Object)showAccount);
        }
        for (int i = 0; i < accountIds.size(); ++i) {
            DynamicObjectCollection childAccounts = toUpdateMain.getDynamicObjectCollection("accounts");
            DynamicObject rowAccount = new DynamicObject(childAccounts.getDynamicObjectType());
            rowAccount.set("id", (Object)DBServiceHelper.genGlobalLongId());
            rowAccount.set("account", accountIds.get(i));
            childAccounts.add((Object)rowAccount);
        }
        DynamicObjectCollection childDefineds = toUpdateMain.getDynamicObjectCollection("dimentions");
        DynamicObject rowAccount = new DynamicObject(childDefineds.getDynamicObjectType());
        this.setModelData2DynamicObject(rowAccount, "userdefined1,userdefined2,userdefined3,userdefined4,userdefined5,userdefined6,userdefined7".split(","));
        childDefineds.add((Object)rowAccount);
        List result = this.valideBeforeSave(new DynamicObject[]{toUpdateMain});
        if (!result.isEmpty()) {
            return result;
        }
        this.setOrg(toUpdateMain);
        DeleteServiceHelper.delete((String)"eb_bgcontrolrulemain", (QFilter[])new QFilter("id", "=", (Object)pkid).toArray());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{toUpdateMain});
        this.getPageCache().put("editEnd", "true");
        String isbeyond = String.valueOf(this.getModel().getValue("isbeyond"));
        String cacheIsBeyond = this.getPageCache().get("cacheIsBeyond");
        if (cacheIsBeyond != null && !isbeyond.equals(cacheIsBeyond)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL_KEY);
            String modelCode = model.getString("showNumber");
            DynamicObjectCollection mulquota = (DynamicObjectCollection)this.getModel().getValue("mulquota");
            ArrayList<String> accountNames = new ArrayList<String>(mulquota.size());
            for (DynamicObject dynamicObject : mulquota) {
                DynamicObject fbasedataid = (DynamicObject)dynamicObject.get("fbasedataid");
                accountNames.add(String.valueOf(fbasedataid.get("name")));
            }
            String accountName = ((Object)accountNames).toString();
            if ("true".equals(isbeyond)) {
                this.writeLog(null, "save", new MultiLangEnumBridge("\u4fee\u6539\u4fdd\u5b58", "RuleControlAddNewPlugin_1", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4f53\u7cfb\u7f16\u7801\u201c%1$s\u201d\uff0c\u79d1\u76ee\u201c%2$s\u201d\u5df2\u5f00\u542f\u5141\u8bb8\u8d85\u9884\u7b97\u3002", "RuleControlAddNewPlugin_13", "epm-eb-formplugin"), new String[]{modelCode, accountName});
            } else if ("false".equals(isbeyond)) {
                this.writeLog(null, "save", new MultiLangEnumBridge("\u4fee\u6539\u4fdd\u5b58", "RuleControlAddNewPlugin_1", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4f53\u7cfb\u7f16\u7801\u201c%1$s\u201d\uff0c\u79d1\u76ee\u201c%2$s\u201d\u5df2\u5173\u95ed\u5141\u8bb8\u8d85\u9884\u7b97\u3002", "RuleControlAddNewPlugin_14", "epm-eb-formplugin"), new String[]{modelCode, accountName});
            }
        } else {
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fee\u6539\u4fdd\u5b58", "RuleControlAddNewPlugin_1", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u7f16\u53f7\u201c%1$s\u201d\uff0c\u4fdd\u5b58\u6210\u529f\u3002", "RuleControlAddNewPlugin_5", "epm-eb-formplugin");
            OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"save", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[]{String.valueOf(pkid)});
        }
        return result;
    }

    @Override
    public List<OrgMemberDto> getCheckedOrg() {
        String orgIdsStr = this.getPageCache().get("checkedOrgs");
        ArrayList<OrgMemberDto> orgRangeIds = orgIdsStr == null ? new ArrayList(16) : (List)ObjectSerialUtil.deSerializedBytes((String)orgIdsStr);
        return orgRangeIds;
    }

    private List<String> saveData() {
        DynamicObject main = BusinessDataServiceHelper.newDynamicObject((String)"eb_bgcontrolrulemain");
        this.setModelData2DynamicObject(main, MAIN_FIELDS.split(","));
        Long mainId = DBServiceHelper.genGlobalLongId();
        main.set("id", (Object)mainId);
        main.set(MODEL_KEY, (Object)this.getModelId());
        main.set("creater", (Object)UserUtils.getUserId());
        main.set("createdate", (Object)TimeServiceHelper.now());
        main.set("modifier", (Object)UserUtils.getUserId());
        main.set("modifydate", (Object)TimeServiceHelper.now());
        main.set("bussmodel", (Object)this.getBussModelId());
        DynamicObjectCollection accounts = (DynamicObjectCollection)this.getModel().getValue("mulquota");
        ArrayList accountIds = new ArrayList(16);
        accounts.forEach(account -> {
            String id = account.getString("fbasedataid_id");
            accountIds.add(id);
        });
        DynamicObjectCollection accountNameList = QueryServiceHelper.query((String)"epm_accountmembertree", (String)"name", (QFilter[])new QFilter("id", "in", (Object)IDUtils.toLongs(accountIds)).toArray());
        String showAccount = accountNameList.stream().map(k -> k.getString("name")).collect(Collectors.joining(","));
        if (StringUtils.isNotEmpty((CharSequence)showAccount) && showAccount.length() < 600) {
            main.set("showaccount", (Object)showAccount);
        }
        int accountSize = accountIds.size();
        for (int i = 0; i < accountSize; ++i) {
            DynamicObjectCollection childAccounts = main.getDynamicObjectCollection("accounts");
            DynamicObject rowAccount = new DynamicObject(childAccounts.getDynamicObjectType());
            rowAccount.set("id", (Object)DBServiceHelper.genGlobalLongId());
            rowAccount.set("account", accountIds.get(i));
            childAccounts.add((Object)rowAccount);
        }
        DynamicObjectCollection childDefineds = main.getDynamicObjectCollection("dimentions");
        DynamicObject rowAccount = new DynamicObject(childDefineds.getDynamicObjectType());
        this.setModelData2DynamicObject(rowAccount, "userdefined1,userdefined2,userdefined3,userdefined4,userdefined5,userdefined6,userdefined7".split(","));
        childDefineds.add((Object)rowAccount);
        List result = this.valideBeforeSave(new DynamicObject[]{main});
        if (!result.isEmpty()) {
            return result;
        }
        this.setOrg(main);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Object illustrate = dataEntity.get("illustrate");
        main.set("illustrate", illustrate);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{main});
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u65b0\u589e\u4fdd\u5b58", "RuleControlAddNewPlugin_4", "epm-eb-formplugin");
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u7f16\u53f7\u201c%1$s\u201d\uff0c\u4fdd\u5b58\u6210\u529f\u3002", "RuleControlAddNewPlugin_5", "epm-eb-formplugin");
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), (String)this.getBizEntityNumber(), null, (String)"save", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{String.valueOf(mainId)});
        OperationLogUtil.log((AppLogInfo)logInfo);
        return result;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (key.equals("orgrange")) {
            if ("".equals(e.getChangeSet()[0].getNewValue())) {
                this.getPageCache().put("checkedOrgs", null);
            }
        } else if (key.equals("periodclassify")) {
            String newVal = String.valueOf(e.getChangeSet()[0].getNewValue());
            this.setControlType(newVal, true);
        } else if ("effectivedate".equals(key)) {
            this.updateValueForNull(Collections.singletonList("invaliddate"));
        } else if ("invaliddate".equals(key)) {
            this.checkDate();
        } else if ("bussmodel".equals(key)) {
            this.getModel().setValue("orgrange", null);
            this.setDefVisable(this.getModelId(), true);
        } else if ("isbeyond".equals(key)) {
            String isbeyond = String.valueOf(this.getModel().getValue("isbeyond"));
            if ("true".equals(isbeyond)) {
                this.getPageCache().put("cacheIsBeyond", "false");
            } else {
                this.getPageCache().put("cacheIsBeyond", "true");
            }
        }
    }

    private void checkDate() {
        Object effObj = this.getModel().getValue("effectivedate");
        Object invObj = this.getModel().getValue("invaliddate");
        if (invObj != null && effObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"ControlVersionEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.updateValueForNull(Collections.singletonList("invaliddate"));
        } else {
            Object invaobj = this.getModel().getValue("invaliddate");
            if (invaobj != null && ((Date)invaobj).before((Date)effObj)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"ControlVersionEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.updateValueForNull(Collections.singletonList("invaliddate"));
            }
        }
    }

    private void updateValueForNull(List<String> keys) {
        this.getModel().beginInit();
        for (String key : keys) {
            this.getModel().setValue(key, null);
            this.getView().updateView(key);
        }
        this.getModel().endInit();
    }

    private void setModelData2DynamicObject(DynamicObject dy, String ... keys) {
        String serialized = this.getPageCache().get("difineDimIds");
        Map difineDimIds = new HashMap(10);
        if (StringUtils.isNotBlank((CharSequence)serialized)) {
            difineDimIds = (Map)ObjectSerialUtil.deSerializedBytes((String)serialized);
        }
        IDataModel model = this.getModel();
        for (String key : keys) {
            dy.set(key, model.getValue(key));
            if (!key.startsWith("userdefined")) continue;
            Long id = IDUtils.toLong(difineDimIds.get(key));
            if (id == null) {
                id = 0L;
            }
            String replace = key.replace("userdefined", "userdefineddimid");
            dy.set(replace, (Object)id);
        }
    }

    public void initDefineF7() {
        String userdefinedStr = this.getPageCache().get("userdefinedMap");
        if (!StringUtils.isEmpty((CharSequence)userdefinedStr)) {
            Map userdefinedMap = (Map)ObjectSerialUtil.deSerializedBytes((String)userdefinedStr);
            ArrayList difineF7 = Lists.newArrayList(userdefinedMap.values());
            this.initSingleMemberF7(difineF7, SingleF7TypeEnum.LEAF);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        String key;
        switch (key = e.getActionId()) {
            case "mulquota": {
                DynamicObject[] dynamicObjects;
                Map resultMap = (Map)e.getReturnData();
                if (resultMap == null || resultMap.size() <= 0 || (dynamicObjects = (DynamicObject[])resultMap.get("selectRows")) == null) break;
                ArrayList<Long> accountIds = new ArrayList<Long>(dynamicObjects.length);
                for (DynamicObject account : dynamicObjects) {
                    accountIds.add(account.getLong("id"));
                }
                QFilter qIds = new QFilter("id", "in", accountIds);
                String selectField = "id,isleaf,parent";
                DynamicObject[] docs = BusinessDataServiceHelper.load((String)"epm_accountmembertree", (String)selectField, (QFilter[])new QFilter[]{qIds});
                ArrayList<DynamicObject> accounts = new ArrayList<DynamicObject>(16);
                for (DynamicObject doc : docs) {
                    boolean isleaf = doc.getBoolean("isleaf");
                    if (!isleaf) continue;
                    accounts.add(doc);
                }
                DynamicObject[] arr = accounts.toArray(new DynamicObject[accounts.size()]);
                List collect = Stream.of(arr).map(v -> v.getPkValue()).collect(Collectors.toList());
                this.getModel().setValue(key, (Object)collect.toArray());
                break;
            }
            case "orgSelect": {
                if (e.getReturnData() == null) {
                    return;
                }
                DynamicObjectCollection returnData = (DynamicObjectCollection)e.getReturnData();
                List<OrgMemberDto> chooseOrgIds = returnData.stream().map(k -> new OrgMemberDto(k)).collect(Collectors.toList());
                if (chooseOrgIds == null) break;
                this.writebackOrg(chooseOrgIds);
                break;
            }
        }
    }

    private void writebackOrg(List<OrgMemberDto> params) {
        String rangeStr = params.stream().map(k -> k.getName()).collect(Collectors.joining(","));
        this.getModel().setValue("orgrange", (Object)rangeStr);
        this.getPageCache().put("checkedOrgs", ObjectSerialUtil.toByteSerialized(params));
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "bar_save": 
            case "bar_addnew": {
                this.saveOrEdit(key);
                break;
            }
            case "orgrange": {
                if ((CommonUtils.isBgmdModel((Long)this.getModelId()) || ModelUtil.isBGModel((Long)this.getModelId())) && IDUtils.isEmptyLong((Long)this.getBussModelId()).booleanValue()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"AddDimmaterule_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                this.showOrgAllotForm(this);
                break;
            }
        }
    }

    private void saveOrEdit(String key) {
        block25: {
            int is;
            String retMsg;
            if (!this.checkData()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u67d4\u6027\u7cfb\u6570\u201d\u3002", (String)"RuleControlAddNewPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String string = retMsg = "edit".equals(this.getPageCache().get("pageState")) ? "editSuccess" : "addSuccess";
            if ("bar_addnew".equals(key) && (is = this.checkItemPermission(this.getUserId(), this.getModelId(), "bgc", "eb_rulecontrollist", "47156aff000000ac")) != 0) {
                log1.info("saveOrEdit-newAgain");
                retMsg = "newAgain";
            }
            try (TXHandle th = TX.required();){
                List<String> result;
                if ("edit".equals(this.getPageCache().get("pageState"))) {
                    result = this.editData();
                    if (!result.isEmpty()) {
                        CommonServiceHelper.showErrorInfoForm((IFormView)this.getView(), result, (String)ResManager.loadKDString((String)"\u89c4\u5219\u51b2\u7a81\u5217\u8868", (String)"RuleControlAddNewPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.cacheOldData();
                    this.getView().returnDataToParent((Object)retMsg);
                    break block25;
                }
                result = this.saveData();
                if (!result.isEmpty()) {
                    CommonServiceHelper.showErrorInfoForm((IFormView)this.getView(), result, (String)ResManager.loadKDString((String)"\u89c4\u5219\u51b2\u7a81\u5217\u8868", (String)"RuleControlAddNewPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                try {
                    this.cacheOldData();
                    this.getView().returnDataToParent((Object)retMsg);
                }
                catch (Exception e) {
                    th.markRollback();
                    log.error(e.getMessage());
                    throw new KDBizException(e.getMessage());
                }
            }
        }
        this.getView().close();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        if ("bussmodel".equals(((BasedataEdit)event.getSource()).getKey())) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl("bussmodel")).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>(16);
            }
            qFilterList.add(new QFilter(MODEL_KEY, "=", (Object)this.getModelId()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        } else {
            Long modelId = this.getModelId();
            Long busModelId = this.getBussModelId();
            BasedataEdit basedataEdit = (BasedataEdit)event.getSource();
            String currentDimNumber = this.getCurrentDimNumber(basedataEdit.getKey());
            MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)currentDimNumber), (String)ListSelectedRow.class.getName());
            f7Param.setBusModelId(busModelId);
            if (SysDimensionEnum.Account.getNumber().equals(currentDimNumber)) {
                f7Param.setDatasetIds(BusinessModelServiceHelper.getInstance().queryDataSetIds(f7Param.getBusModelId()));
                f7Param.setCanSelectRoot(false);
                f7Param.setMultiSelect(true);
            }
            if (CommonUtils.isBgmdModel((Long)this.getModelId()) || ModelUtil.isBGModel((Long)this.getModelId())) {
                if (busModelId == 0L) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"RuleControlAddNewPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                Long viewId = BusinessModelServiceHelper.getInstance().getViewId(busModelId, currentDimNumber, this.getModelId());
                f7Param.setSwitchViewBySelMem(false);
                f7Param.setViewId(viewId);
            }
            NewF7Utils.openF7((BeforeF7SelectEvent)event, (MemberF7Parameter)f7Param);
        }
    }

    public String getCurrentDimNumber(String controlKey) {
        Map<String, String> customDimKeyNum = this.getCustomDimKeyNum();
        if (customDimKeyNum != null && customDimKeyNum.containsValue(controlKey)) {
            for (Map.Entry<String, String> keyNum : customDimKeyNum.entrySet()) {
                if (!keyNum.getValue().equals(controlKey)) continue;
                return keyNum.getKey();
            }
        }
        if ("mulquota".equals(controlKey)) {
            return SysDimensionEnum.Account.getNumber();
        }
        return null;
    }

    public Map<String, String> getCustomDimKeyNum() {
        String userdefinedStr;
        if (this.customDimKeyNums == null && (userdefinedStr = this.getPageCache().get("userdefinedMap")) != null) {
            this.customDimKeyNums = (Map)ObjectSerialUtil.deSerializedBytes((String)userdefinedStr);
        }
        return this.customDimKeyNums;
    }

    public void onGetControl(OnGetControlArgs e) {
        Map userdefinedMap;
        ArrayList difineF7;
        super.onGetControl(e);
        String f7Key = e.getKey();
        String userdefinedStr = this.getPageCache().get("userdefinedMap");
        if (!StringUtils.isEmpty((CharSequence)userdefinedStr) && (difineF7 = Lists.newArrayList((userdefinedMap = (Map)ObjectSerialUtil.deSerializedBytes((String)userdefinedStr)).values())).contains(f7Key)) {
            BasedataEdit basedataEdit = this.newBaseDataEdit(this.getView(), f7Key);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            e.setControl((Control)basedataEdit);
        }
    }

    private BasedataEdit newBaseDataEdit(IFormView view, String key) {
        BasedataEdit basedataEdit = new BasedataEdit();
        basedataEdit.setKey(key);
        basedataEdit.setView(view);
        basedataEdit.setDisplayProp("name");
        view.createControlIndex((List)Lists.newArrayList((Object[])new Control[]{basedataEdit}));
        return basedataEdit;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setControlType(String periodclassify, boolean needNull) {
        ComboEdit combo = (ComboEdit)this.getControl("controltype");
        List<ComboItem> items = null;
        switch (periodclassify) {
            case "1": {
                items = ControlRuleHelper.createControlTypeList(new ArrayList<String>(16));
                break;
            }
            case "2": {
                items = ControlRuleHelper.createControlTypeList(Arrays.asList("1", "4"));
                break;
            }
            case "3": {
                items = ControlRuleHelper.createControlTypeList(Arrays.asList("1", "4", "2", "5"));
                break;
            }
        }
        combo.setComboItems(items);
        if (needNull) {
            this.getModel().setValue("controltype", null);
        }
    }

    public void cacheOldData() {
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        pageCache.put("oldperiodclassify", String.valueOf(model.getValue("periodclassify")));
        pageCache.put("oldcontroltype", String.valueOf(model.getValue("controltype")));
        pageCache.put("oldcoefficient", String.valueOf(model.getValue("coefficient")));
        pageCache.put("oldisbeyond", String.valueOf(model.getValue("isbeyond")));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (model.getValue("effectivedate") != null) {
            pageCache.put("oldeffectivedate", sdf.format(model.getValue("effectivedate")));
        }
        if (model.getValue("invaliddate") != null) {
            pageCache.put("oldinvaliddate", sdf.format(model.getValue("invaliddate")));
        }
        for (int i = 1; i < 8; ++i) {
            String param = "userdefined" + i;
            Object value = model.getValue(param);
            if (value == null) continue;
            pageCache.put("old" + param, ((DynamicObject)value).getString("id"));
        }
        DynamicObjectCollection accounts = (DynamicObjectCollection)model.getValue("mulquota");
        ArrayList<String> accountIds = new ArrayList<String>(16);
        for (DynamicObject account : accounts) {
            String id = account.getString("fbasedataid_id");
            accountIds.add(id);
        }
        pageCache.put("oldAccountIds", ObjectSerialUtil.toByteSerialized(accountIds));
        this.getPageCache().put("oldorgRangeIds", ObjectSerialUtil.toByteSerialized(this.getCheckedOrg()));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String isClose = this.getPageCache().get("isClose");
        if (!"true".equals(this.getPageCache().get("editEnd")) && isClose == null && this.checkDataChanged()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u66f4\u6539\uff0c\u786e\u8ba4\u4fdd\u5b58\u5e76\u9000\u51fa\uff1f", (String)"RuleControlAddNewPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("isClose"));
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionKey = messageBoxClosedEvent.getCallBackId();
        String okCancle = messageBoxClosedEvent.getResultValue();
        if (actionKey.equals("isClose") && okCancle.equals(MessageBoxResult.Yes.name())) {
            this.getPageCache().put("isClose", "true");
            this.getView().close();
        }
    }

    public boolean checkDataChanged() {
        String[] params;
        IPageCache pageCache = this.getPageCache();
        IDataModel model = this.getModel();
        String oldVal = pageCache.get("oldAccountIds");
        List oldAccountIds = oldVal == null ? new ArrayList(16) : (List)ObjectSerialUtil.deSerializedBytes((String)String.valueOf(oldVal));
        Object newVal = model.getValue("mulquota");
        DynamicObjectCollection accounts = newVal == null ? new DynamicObjectCollection() : (DynamicObjectCollection)newVal;
        ArrayList<String> newAccountIds = new ArrayList<String>(16);
        for (String[] account : accounts) {
            String id = account.getString("fbasedataid_id");
            newAccountIds.add(id);
        }
        if (oldAccountIds.size() != newAccountIds.size()) {
            return true;
        }
        oldAccountIds.removeAll(newAccountIds);
        if (oldAccountIds.size() != 0) {
            return true;
        }
        for (String param : params = MAIN_FIELDS.split(",")) {
            oldVal = pageCache.get("old" + param);
            newVal = model.getValue(param);
            if (newVal != null && oldVal != null && !String.valueOf(newVal).equals(String.valueOf(oldVal))) {
                if (newVal instanceof Date && !String.valueOf(oldVal).equals(new SimpleDateFormat("yyyy-MM-dd").format(newVal))) {
                    return true;
                }
                if (newVal instanceof Date) continue;
                return true;
            }
            if ((newVal == null || oldVal != null) && (newVal != null || oldVal == null)) continue;
            return true;
        }
        for (int i = 1; i <= 7; ++i) {
            oldVal = pageCache.get("olduserdefined" + i);
            newVal = model.getValue("userdefined" + i);
            if (newVal != null) {
                newVal = ((DynamicObject)newVal).getString("id");
            }
            if (!(newVal != null && oldVal != null ? !String.valueOf(newVal).equals(String.valueOf(oldVal)) : newVal != null && oldVal == null || newVal == null && oldVal != null)) continue;
            return true;
        }
        oldVal = pageCache.get("oldorgRangeIds");
        List<OrgMemberDto> oldOrgIds = oldVal == null ? new ArrayList(16) : (List)ObjectSerialUtil.deSerializedBytes((String)String.valueOf(oldVal));
        List<OrgMemberDto> newOrgIds = this.getCheckedOrg();
        if (oldOrgIds.size() != newOrgIds.size()) {
            return true;
        }
        oldOrgIds.removeIf(k -> newOrgIds.stream().anyMatch(v -> v.getId().equals(k.getId())));
        return oldOrgIds.size() != 0;
    }

    @Override
    public Long getModelId() {
        Long modelId = 0L;
        String _modelId = this.getPageCache().get("KEY_MODEL_ID");
        if (_modelId != null) {
            modelId = Long.valueOf(_modelId);
        } else {
            DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL_KEY);
            if (model != null) {
                modelId = model.getLong("id");
            }
        }
        return modelId;
    }

    private void setDTAndATVisible() {
        DynamicObject modelObj = (DynamicObject)this.getModel().getValue(MODEL_KEY);
        if (modelObj == null) {
            return;
        }
        Long modelid = modelObj.getLong("id");
        DynamicObject model = ModelUtils.getModel((Long)modelid);
        String reportType = model.getString("reporttype");
        if (ApplicationTypeEnum.isBGMD((String)reportType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bussmodel"});
        } else if (ApplicationTypeEnum.isEB((String)reportType)) {
            String periodclassify = ModelUtils.getDetailedPeriod((Long)modelid);
            this.getModel().setValue("periodclassify", (Object)periodclassify);
            this.setControlType(periodclassify, false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"bussmodel"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bussmodel"});
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"periodclassify"});
    }

    @Override
    public Long getBussModelId() {
        Object bussmodel = this.getModel().getValue("bussmodel");
        if (bussmodel != null) {
            return ((DynamicObject)bussmodel).getLong("id");
        }
        return 0L;
    }

    public String getBizCtrlRangeKey() {
        return "bussmodel";
    }
}

