/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.ViewMember;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.SqlBatchUtils;
import org.apache.commons.lang3.StringUtils;

public class RuleControlAllotInfoPlugin
extends AbstractFormPlugin {
    private static final String treeKey = "treeleft";
    private static final String treeNodeKey = "treeNodeleft";
    private List<String> rightTreeCheckedNodeIds = new ArrayList<String>(16);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"allexpand", "allshrink", "buttonreflesh", "searchbefore", "searchnext"});
        Search sl = (Search)this.getControl("searchapleft");
        sl.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                RuleControlAllotInfoPlugin.this.searchTreeNodes(event.getText());
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initLeftTree();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String actionKey = ((Control)evt.getSource()).getKey();
        if (actionKey.equals("allexpand")) {
            this.spreadAll();
        } else if (actionKey.equals("allshrink")) {
            this.collapseAll();
        } else if (actionKey.equals("buttonreflesh")) {
            CommonServiceHelper.searchTreeNode((IPageCache)this.getPageCache(), (TreeView)((TreeView)this.getControl(treeNodeKey)), (String)treeNodeKey, (String)"");
            this.initLeftTree();
        } else if (actionKey.equals("searchbefore")) {
            this.searchBefore();
        } else if (actionKey.equals("searchnext")) {
            this.searchNext();
        }
    }

    private void initLeftTree() {
        TreeNode root = this.getLeftRoot();
        this.dealTree(root);
        this.cacheLeftRoot(root);
        if (root.getChildren() != null) {
            root.setIsOpened(true);
            this.spreadChild(root);
        }
        TreeView treeLeft = (TreeView)this.getView().getControl(treeKey);
        treeLeft.deleteAllNodes();
        treeLeft.addNode(root);
    }

    private void searchTreeNodes(String SearchInfo) {
        TreeView leftTreeView;
        IPageCache pageCache = this.getPageCache();
        int result = CommonServiceHelper.searchTreeNode((IPageCache)pageCache, (TreeView)(leftTreeView = (TreeView)this.getControl(treeKey)), (String)treeNodeKey, (String)SearchInfo);
        if (result == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5185\u5bb9\u540e\uff0c\u6309\u56de\u8f66\u952e\u641c\u7d22\u3002", (String)"RuleControlAllotInfoPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (result == 2) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u54cd\u5e94\u6570\u636e", (String)"RuleControlAllotInfoPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private Object getInfoFromFormParam(String key) {
        FormShowParameter formParam = this.getView().getFormShowParameter();
        return formParam.getCustomParam(key);
    }

    private TreeNode getLeftRoot() {
        Object businessModel;
        TreeNode memberTreeNode = new TreeNode();
        String modelID = String.valueOf(this.getInfoFromFormParam("modelId"));
        IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)IDUtils.toLong((Object)modelID));
        QFilter qFilter = new QFilter("model", "=", (Object)IDUtils.toLong((Object)modelID));
        String memberKey = "epm_entitymembertree";
        Object viewId = this.getInfoFromFormParam("viewId");
        DynamicObjectCollection org = null;
        String rootID = null;
        if ((viewId == null || "0".equals(viewId)) && (businessModel = this.getInfoFromFormParam("businessModel")) != null) {
            viewId = cacheHelper.getViewByBusModelAndDimNumber(IDUtils.toLong((Object)businessModel), SysDimensionEnum.Entity.getNumber());
        }
        if (viewId != null) {
            qFilter.and("view", "=", (Object)IDUtils.toLong((Object)viewId));
            memberKey = "eb_viewmember";
            org = QueryServiceHelper.query((String)memberKey, (String)"id,number,name,parent,memberid", (QFilter[])new QFilter[]{qFilter}, (String)"parent");
            Member rootMember = cacheHelper.getRootMember(SysDimensionEnum.Entity.getNumber(), IDUtils.toLong((Object)viewId));
            memberTreeNode = new TreeNode(null, String.valueOf(rootMember), rootMember.getNumber() + " " + rootMember.getName());
            rootID = String.valueOf(((ViewMember)rootMember).getVid());
        } else {
            qFilter.and("isexchangerate", "!=", (Object)"1");
            org = QueryServiceHelper.query((String)memberKey, (String)"id,number,name,parent", (QFilter[])new QFilter[]{qFilter}, (String)"parent");
            rootID = ((DynamicObject)org.get(0)).getString("id");
            memberTreeNode.setId(rootID);
            memberTreeNode.setText(((DynamicObject)org.get(0)).getString("number") + " " + ((DynamicObject)org.get(0)).getString("name"));
        }
        if (org.isEmpty()) {
            return memberTreeNode;
        }
        org.remove(0);
        Set noPermMembIds = DimMembPermHelper.getPermMemberIds((String)SysDimensionEnum.Entity.getNumber(), (Long)Long.parseLong(modelID), (Long)0L, null, (DimMembPermType)DimMembPermType.READ, (boolean)false);
        List<Map<String, String>> memberList = this.getMemberList(org, noPermMembIds, rootID);
        Map<String, List<Map<String, String>>> parentMap = memberList.stream().collect(Collectors.groupingBy(k -> (String)k.get("parentid"), Collectors.toList()));
        List<String> orgIds = this.checkOrgIds();
        this.setEntryNode(memberTreeNode, parentMap, rootID, orgIds);
        return memberTreeNode;
    }

    private List<Map<String, String>> getMemberList(DynamicObjectCollection dcs, Set<Long> noPermMembId, String rootId) {
        ArrayList<Map<String, String>> memberList = new ArrayList<Map<String, String>>(16);
        if (noPermMembId == null) {
            noPermMembId = new HashSet<Long>(16);
        }
        if (dcs != null && dcs.size() > 0) {
            String id = null;
            String pid = null;
            for (DynamicObject task : dcs) {
                id = task.getString("id");
                if (noPermMembId.contains(Long.valueOf(id))) continue;
                HashMap<String, String> memberMap = new HashMap<String, String>();
                memberMap.put("id", task.get("id").toString());
                memberMap.put("number", task.getString("number"));
                memberMap.put("name", task.getString("number") + "\n\n" + task.getString("name"));
                if (task.containsProperty("memberid")) {
                    memberMap.put("memberId", task.getString("memberid"));
                }
                if (noPermMembId.contains(Long.valueOf(pid = task.getString("parent")))) {
                    pid = rootId;
                }
                memberMap.put("parentid", pid);
                memberList.add(memberMap);
            }
        }
        return memberList;
    }

    private TreeNode setEntryNode(TreeNode root, Map<String, List<Map<String, String>>> parentMap, String headId, List<String> orgIds) {
        if (parentMap.get(headId) == null) {
            return root;
        }
        for (Map<String, String> map : parentMap.get(headId)) {
            if (!map.get("parentid").equals(headId)) continue;
            TreeNode entry = new TreeNode();
            entry.setParentid(headId);
            entry.setId(map.get("id"));
            entry.setText(map.get("name"));
            String entryHeadId = map.get("id");
            map.put("isNew", "1");
            entry.setData(map);
            this.setEntryNode(entry, parentMap, entryHeadId, orgIds);
            ArrayList<TreeNode> children = root.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>();
                root.setChildren(children);
            }
            children.add(entry);
        }
        return root;
    }

    private boolean dealTree(TreeNode node) {
        boolean haveCheck = true;
        List childs = node.getChildren();
        boolean isCheck = this.checkNodeOfLeftIsChecked(node);
        if (childs == null) {
            haveCheck = isCheck;
        } else {
            ListIterator iterator = childs.listIterator();
            while (iterator.hasNext()) {
                TreeNode childNode = (TreeNode)iterator.next();
                if (this.dealTree(childNode)) continue;
                iterator.remove();
            }
            if (childs.size() == 0) {
                node.setChildren(null);
                haveCheck = isCheck;
            }
        }
        return haveCheck;
    }

    private List<String> getRightCheckNodeIds() {
        if (this.rightTreeCheckedNodeIds.isEmpty()) {
            this.rightTreeCheckedNodeIds = this.checkOrgIds();
        }
        return this.rightTreeCheckedNodeIds;
    }

    private boolean checkNodeOfLeftIsChecked(TreeNode node) {
        if (node.getData() != null) {
            HashMap data = (HashMap)node.getData();
            if (this.getRightCheckNodeIds().contains(data.get("memberId"))) {
                return true;
            }
        }
        return this.getRightCheckNodeIds().contains(node.getId());
    }

    private void collapseAll() {
        TreeNode leftRoot = this.getCacheLeftRoot();
        if (leftRoot == null) {
            return;
        }
        TreeView treeleft = (TreeView)this.getView().getControl(treeKey);
        if (leftRoot.getChildren() != null) {
            this.collapseChild(leftRoot);
        }
        treeleft.deleteAllNodes();
        treeleft.addNode(leftRoot);
    }

    private void spreadAll() {
        TreeNode leftRoot = this.getCacheLeftRoot();
        if (leftRoot == null) {
            return;
        }
        TreeView treeleft = (TreeView)this.getView().getControl(treeKey);
        if (leftRoot.getChildren() != null) {
            leftRoot.setIsOpened(true);
            this.spreadChild(leftRoot);
        }
        treeleft.deleteAllNodes();
        treeleft.addNode(leftRoot);
    }

    private void spreadChild(TreeNode leftRoot) {
        leftRoot.getChildren().forEach(new Consumer<TreeNode>(){

            @Override
            public void accept(TreeNode t) {
                if (t.getChildren() != null) {
                    t.setIsOpened(true);
                    RuleControlAllotInfoPlugin.this.spreadChild(t);
                }
            }
        });
    }

    private TreeNode getCacheLeftRoot() {
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(treeNodeKey))) {
            TreeNode leftRoot = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(treeNodeKey), TreeNode.class);
            return leftRoot;
        }
        return null;
    }

    private void cacheLeftRoot(TreeNode rootleft) {
        this.getPageCache().put(treeNodeKey, SerializationUtils.toJsonString((Object)rootleft));
    }

    private void collapseChild(TreeNode leftRoot) {
        leftRoot.getChildren().forEach(new Consumer<TreeNode>(){

            @Override
            public void accept(TreeNode t) {
                if (t.getChildren() != null) {
                    t.setIsOpened(false);
                    RuleControlAllotInfoPlugin.this.collapseChild(t);
                }
            }
        });
    }

    private void searchNext() {
        TreeView leftTreeView = (TreeView)this.getControl(treeKey);
        int result = CommonServiceHelper.nextOrBeforeMatchNode((IPageCache)this.getPageCache(), (TreeView)leftTreeView, (String)treeNodeKey, (boolean)false);
        if (result == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5185\u5bb9\u540e\uff0c\u6309\u56de\u8f66\u952e\u641c\u7d22\u3002", (String)"RuleControlAllotInfoPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (result == 2) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u6700\u540e\u4e00\u884c\u6570\u636e\u3002", (String)"RuleControlAllotInfoPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void searchBefore() {
        TreeView leftTreeView = (TreeView)this.getControl(treeKey);
        int result = CommonServiceHelper.nextOrBeforeMatchNode((IPageCache)this.getPageCache(), (TreeView)leftTreeView, (String)treeNodeKey, (boolean)true);
        if (result == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5185\u5bb9\u540e\uff0c\u6309\u56de\u8f66\u952e\u641c\u7d22\u3002", (String)"RuleControlAllotInfoPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (result == 2) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u7b2c\u4e00\u884c\u6570\u636e\u3002", (String)"RuleControlAllotInfoPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private List<String> checkOrgIds() {
        List orgRangeIds = (List)this.getInfoFromFormParam("checkedOrg");
        if (orgRangeIds == null) {
            return (List)this.getInfoFromFormParam("orgIds");
        }
        List<String> orgIds = orgRangeIds.stream().filter(k -> "org".equals(k.get("type"))).map(k -> String.valueOf(k.get("orgId"))).collect(Collectors.toList());
        List propertyIds = orgRangeIds.stream().filter(k -> "property".equals(k.get("type"))).map(k -> IDUtils.toLong(k.get("orgId"))).collect(Collectors.toList());
        if (!propertyIds.isEmpty()) {
            StringBuilder sql = new StringBuilder("select fid from t_eb_memberpropertyvalue where fpropertyvalueid in ");
            ArrayList sqlParams = new ArrayList(propertyIds);
            sql.append("(").append(SqlBatchUtils.getBatchParamsSql((int)propertyIds.size())).append(")");
            try (DataSet rst = DB.queryDataSet((String)"tranOrgIds", (DBRoute)BgBaseConstant.epm, (String)sql.toString(), (Object[])sqlParams.toArray());){
                if (rst != null) {
                    Row row = null;
                    while (rst.hasNext()) {
                        row = rst.next();
                        orgIds.add(row.getString("fid"));
                    }
                }
            }
        }
        return orgIds;
    }
}

