/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.central.OrgMemberDto;
import kd.epm.eb.common.dao.rulecontrol.GroupDimensionPojo;
import kd.epm.eb.common.dao.rulecontrol.OboMemberRangePojo;
import kd.epm.eb.common.dao.rulecontrol.RuleControlImportDataPojo;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.RuleControlTypeEnum;
import kd.epm.eb.common.enums.RulePeriodClassifyEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.control.utils.BgControlRuleUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.ebBusiness.sql.util.DateTimeUtils;
import kd.epm.eb.formplugin.control.AllotOrg;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;

public class RuleControlImportPlugin
extends AbstractFormPlugin
implements UploadListener,
AllotOrg {
    private static final Log log = LogFactory.getLog(RuleControlImportPlugin.class);
    private static final String ACCOUNT = "Account";
    private static final String ENTITY = "Entity";
    private static final int columnMax = 30;
    private boolean erroFlag = false;
    private boolean rowErrorFlag = false;
    private boolean entityBaseViewFlag = false;
    private String cellTypeKey;
    private boolean isLevel;
    private long modelId;
    private long bussModelId;
    private List<OrgMemberDto> getDtoMembers = new ArrayList<OrgMemberDto>(16);
    private Integer successDataNum = 0;
    private static final String[] searchCols = new String[]{"showbizmember", "showbizmemberext", "showdimmember", "bushowdimmember"};

    public static String[] getHeadInfo() {
        return new String[]{RuleControlImportPlugin.getHeadGroupName(), RuleControlImportPlugin.getHeadAccountName(), RuleControlImportPlugin.getHeadAccountNumber()};
    }

    private static String getHeadModelNumber() {
        return ResManager.loadKDString((String)"\u4f53\u7cfb\u7f16\u7801*", (String)"RuleControlImportPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getHeadBussNumber() {
        return ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u7f16\u7801*", (String)"RuleControlImportPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getHeadGroupName() {
        return ResManager.loadKDString((String)"\u5206\u7ec4\u63a7\u5236\u540d\u79f0", (String)"RuleControlImportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getHeadAccountName() {
        return ResManager.loadKDString((String)"\u79d1\u76ee\u540d\u79f0\uff08\u53ef\u591a\u9009\u7528\u9017\u53f7\u5206\u9694\uff09", (String)"RuleControlImportPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getHeadAccountNumber() {
        return ResManager.loadKDString((String)"\u79d1\u76ee\u5185\u7801*\uff08\u53ef\u591a\u9009\u7528\u9017\u53f7\u5206\u9694\uff09", (String)"RuleControlImportPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getYesCn() {
        return ResManager.loadKDString((String)"\u662f", (String)"RuleControlImportPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getNoCn() {
        return ResManager.loadKDString((String)"\u5426", (String)"RuleControlImportPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getPeriodClassifyCn() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u671f\u95f4\u5206\u7c7b*", (String)"RuleControlImportPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getControlTypeCn() {
        return ResManager.loadKDString((String)"\u63a7\u5236\u65b9\u5f0f*", (String)"RuleControlImportPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getNoExistAccountCnByBgm() {
        return ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u79d1\u76ee\u5728\u5bf9\u5e94\u4e1a\u52a1\u6a21\u578b\u4e0b\u4e0d\u5b58\u5728:", (String)"RuleControlImportPlugin_66", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getNoExistAccountCnByEb() {
        return ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u79d1\u76ee\u4e0d\u5b58\u5728:", (String)"RuleControlImportPlugin_67", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getImportCn() {
        return ResManager.loadKDString((String)"\u5bfc\u5165\u7684", (String)"RuleControlImportPlugin_68", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getNoExistCnByBgm() {
        return ResManager.loadKDString((String)"\u5728\u5bf9\u5e94\u4e1a\u52a1\u6a21\u578b\u4e0b\u4e0d\u5b58\u5728:", (String)"RuleControlImportPlugin_69", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getNoExistCnByEb() {
        return ResManager.loadKDString((String)"\u4e0d\u5b58\u5728:", (String)"RuleControlImportPlugin_70", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getNoExistEntityCnByBgm() {
        return ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u7ec4\u7ec7\u5728\u5bf9\u5e94\u4e1a\u52a1\u6a21\u578b\u4e0b\u4e0d\u5b58\u5728:", (String)"RuleControlImportPlugin_71", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getNoExistEntityCnByEb() {
        return ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728:", (String)"RuleControlImportPlugin_72", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getNoExistOboMemberCnByBgm() {
        return ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u9010\u4e00\u5206\u7ec4\u7ef4\u5ea6\u6210\u5458\u5728\u5bf9\u5e94\u4e1a\u52a1\u6a21\u578b\u4e0b\u4e0d\u5b58\u5728:", (String)"RuleControlImportPlugin_81", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getNoExistOboMemberCnByEb() {
        return ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u9010\u4e00\u5206\u7ec4\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728:", (String)"RuleControlImportPlugin_82", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btndownload"});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void click(EventObject evt) {
        String url;
        super.click(evt);
        if ("btnok".equals(((Button)evt.getSource()).getKey())) {
            TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
            try {
                String file_url = this.getPageCache().get("file_url");
                if (file_url == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5bfc\u5165\u6570\u636e\u3002", (String)"RuleControlImportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                List file_urls = (List)SerializationUtils.deSerializeFromBase64((String)file_url);
                if (file_urls.isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5bfc\u5165\u6570\u636e\u3002", (String)"RuleControlImportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                String fileTypes = this.getPageCache().get("fileType");
                List types = (List)SerializationUtils.fromJsonString((String)fileTypes, List.class);
                for (int i = 0; i < file_urls.size(); ++i) {
                    String[] reqParams = new URL((String)file_urls.get(i)).getQuery().split("&");
                    HashMap<String, String> map = new HashMap<String, String>(reqParams.length);
                    for (String param : reqParams) {
                        String[] p = param.split("=");
                        map.put(p[0], p[1]);
                    }
                    TempFileCacheDownloadable.Content content = null;
                    try {
                        content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
                    }
                    catch (Exception e) {
                        log.error("uploadfilesize:" + file_urls.size());
                        throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"RuleControlImportPlugin_74", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    if (content == null) continue;
                    InputStream inputStream = content.getInputStream();
                    if (types.get(i) != null && ((String)types.get(i)).equals("xls")) {
                        this.handleInputStream(inputStream, "xls");
                        continue;
                    }
                    this.handleInputStream(inputStream, "xlsx");
                }
                if (!this.erroFlag) {
                    this.getView().setReturnData((Object)"success");
                    this.getView().returnDataToParent((Object)"success");
                    this.getView().close();
                }
                String message = ResManager.loadKDString((String)"\u5bfc\u5165\u51fa\u9519\uff0c\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u5bfc\u51fa\u6587\u4ef6\u3002", (String)"RuleControlImportPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                if (this.successDataNum > 0) {
                    message = ResManager.loadKDString((String)"\u90e8\u5206\u5bfc\u5165\u51fa\u9519\uff0c\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u6587\u4ef6\u3002", (String)"RuleControlImportPlugin_77", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                this.getView().showTipNotification(message);
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5bfc\u5165", "RuleControlListPlugin_80", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5bfc\u5165\u5931\u8d25\uff0c%1$s\u3002", "RuleControlImportPlugin_99", "epm-eb-formplugin");
                OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"import", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[]{message});
            }
            catch (Exception e) {
                log.error((Throwable)e);
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5bfc\u5165", "RuleControlListPlugin_80", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5bfc\u5165\u5931\u8d25\uff0c%1$s\u3002", "RuleControlImportPlugin_99", "epm-eb-formplugin");
                OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"import", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[]{e.getMessage()});
                throw new KDBizException(e.getMessage());
            }
        } else if ("btndownload".equals(((Button)evt.getSource()).getKey()) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(url = this.handleExport()))) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
    }

    private String handleExport() {
        Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
        Long bussModelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("bussmodel"));
        XSSFWorkbook workBook = BgControlRuleUtils.createWorkBook((Long)modelId, (Long)bussModelId);
        try {
            return ImportAndExportUtil.writeFile((Workbook)workBook, (String)ResManager.loadKDString((String)"\u63a7\u5236\u65b9\u5f0f\u5bfc\u5165\u6a21\u677f", (String)"RuleControlImportPlugin_51", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        catch (IOException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
    }

    private List<Dimension> getBusinessModelList(Long modelid, Long bussmodelid) {
        ArrayList<Object> dimensions = new ArrayList<Dimension>(10);
        if (modelid == null || modelid == 0L) {
            return dimensions;
        }
        if (this.checkBgmdModel(modelid) || ModelUtil.isBGModel((Long)modelid)) {
            DynamicObject query;
            dimensions = new ArrayList(10);
            DynamicObject model = ModelUtils.getModel((Long)modelid);
            QFilter qFilter = new QFilter("model", "=", (Object)model.getLong("id"));
            if (IDUtils.isNotEmptyLong((Long)bussmodelid).booleanValue()) {
                qFilter.and(new QFilter("businessmodel", "=", (Object)bussmodelid));
            }
            if ((query = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_bgmcontroldimension", (QFilter[])new QFilter[]{qFilter})) == null) {
                return dimensions;
            }
            DynamicObjectCollection entryEntity = query.getDynamicObjectCollection("entryentity");
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelid);
            for (DynamicObject dynamicObject : entryEntity) {
                long dimId = dynamicObject.getLong("dimensionid");
                Dimension dimension = modelCache.getDimension(Long.valueOf(dimId));
                if (dimension.isPreset()) continue;
                dimensions.add(dimension);
            }
            dimensions.sort(Comparator.comparingInt(BaseCache::getSeq));
        }
        return dimensions;
    }

    private boolean checkBgmdModel(Long modelid) {
        if (modelid != 0L) {
            DynamicObject model = ModelUtils.getModel((Long)modelid);
            if (ApplicationTypeEnum.BGMD.getIndex().equals(model.get("reporttype"))) {
                return true;
            }
        }
        return false;
    }

    /*
     * Could not resolve type clashes
     */
    private void handleInputStream(InputStream inputStream, String fileType) {
        try {
            Row row4;
            Cell cell;
            HSSFWorkbook errorBook;
            HSSFWorkbook workbook;
            if ("xls".equals(fileType)) {
                workbook = new HSSFWorkbook(inputStream);
                errorBook = new HSSFWorkbook();
            } else {
                workbook = new XSSFWorkbook(inputStream);
                errorBook = new XSSFWorkbook();
            }
            Sheet errorSheet = errorBook.createSheet();
            Sheet firstSheet = workbook.getSheetAt(0);
            this.CheckFormat(firstSheet);
            int columnNum = 0;
            Row columnNameRow = firstSheet.getRow(3);
            while ((cell = columnNameRow.getCell(columnNum)) != null) {
                ++columnNum;
            }
            this.creatErroBookHead(errorSheet, firstSheet, columnNum);
            int rowIndex = 1;
            Row modelNumRow = firstSheet.getRow(rowIndex);
            Row errorRow = errorSheet.createRow(rowIndex);
            this.copyRow(errorRow, modelNumRow, errorSheet, 2);
            int numColNumber = 1;
            Cell modelNumCell = modelNumRow.getCell(numColNumber);
            if (modelNumCell == null || CellType.BLANK.equals((Object)modelNumCell.getCellType())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"RuleControlImportPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (!CellType.STRING.equals((Object)modelNumCell.getCellType()) && !CellType.NUMERIC.equals((Object)modelNumCell.getCellType())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5165\u6587\u672c\u578b\u7684\u5185\u5bb9;", (String)"RuleControlImportPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String modelNumber = this.getCellValue(modelNumCell);
            if (modelNumber.indexOf(13) >= 0 || modelNumber.indexOf(10) >= 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5b58\u5728\u6362\u884c\u7b26;", (String)"RuleControlImportPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            QFilter qModel = new QFilter("shownumber", "=", (Object)modelNumber);
            DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_model", (String)"id,name,shownumber,isdetailtomonth,isdetailtoqrt,isdetailtohalfyear", (QFilter[])new QFilter[]{qModel});
            if (model == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u76f8\u5e94\u7684\u4f53\u7cfb\u7f16\u7801\u3002", (String)"RuleControlImportPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String modelPeriodClassify = this.getModelPeriodClassify(model);
            this.modelId = model.getLong("id");
            Long sourceModelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
            if (this.modelId != sourceModelId) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u4f53\u7cfb\u4e0d\u662f\u5f53\u524d\u9009\u4e2d\u7684\u4f53\u7cfb", (String)"RuleControlImportPlugin_54", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.modelId);
            boolean ebModelFlag = modelCacheHelper.getModelobj().isModelByEB();
            boolean bgModel = ModelUtil.isBGModel((Long)this.modelId);
            boolean bgmdOrBgModelFlag = CommonUtils.isBgmdModel((Long)this.modelId) || bgModel;
            Map dimensionMapByNum = modelCacheHelper.getDimensionMap();
            Row bussModelNumRow = firstSheet.getRow(++rowIndex);
            Row errorRow2 = errorSheet.createRow(rowIndex);
            this.copyRow(errorRow2, bussModelNumRow, errorSheet, 2);
            if (ebModelFlag || ModelUtil.isBGModel((Long)this.modelId)) {
                errorRow2.setZeroHeight(true);
            }
            if (bgmdOrBgModelFlag) {
                Long sourceBussModelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("bussmodel"));
                if (!bgModel) {
                    Cell bussModelNumCell = bussModelNumRow.getCell(numColNumber);
                    if (bussModelNumCell == null || CellType.BLANK.equals((Object)bussModelNumCell.getCellType())) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"RuleControlImportPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    if (!CellType.STRING.equals((Object)bussModelNumCell.getCellType()) && !CellType.NUMERIC.equals((Object)bussModelNumCell.getCellType())) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5165\u6587\u672c\u578b\u7684\u5185\u5bb9;", (String)"RuleControlImportPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    String bussModelNumber = this.getCellValue(bussModelNumCell);
                    if (bussModelNumber.indexOf(13) >= 0 || bussModelNumber.indexOf(10) >= 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5b58\u5728\u6362\u884c\u7b26;", (String)"RuleControlImportPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    QFilter qBussModel1 = new QFilter("number", "=", (Object)bussModelNumber);
                    QFilter qBussModel2 = new QFilter("model", "=", (Object)this.modelId);
                    DynamicObject businessModel = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_businessmodel", (String)"id,name,number", (QFilter[])new QFilter[]{qBussModel1, qBussModel2});
                    if (businessModel == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u76f8\u5e94\u7684\u4e1a\u52a1\u6a21\u578b\u7f16\u7801\u3002", (String)"RuleControlImportPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    this.bussModelId = businessModel.getLong("id");
                } else {
                    this.bussModelId = sourceBussModelId;
                }
                if (this.bussModelId != sourceBussModelId) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u4e1a\u52a1\u6a21\u578b\u4e0d\u662f\u5f53\u524d\u9009\u4e2d\u7684\u4e1a\u52a1\u6a21\u578b", (String)"RuleControlImportPlugin_55", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
            Row row3 = firstSheet.getRow(++rowIndex);
            int userDefinedColNumber = 3;
            HashSet<String> userDefinedDimNumberSet = new HashSet<String>(16);
            Map<Long, DynamicObject> businessModelDimIdAndDim = this.getBusinessModelDimidAndDim(ebModelFlag, bgmdOrBgModelFlag);
            Map<Object, Object> userDefinedDimMap = new HashMap(businessModelDimIdAndDim.size());
            if (ebModelFlag) {
                List userDefineDimensionList = DimensionServiceHelper.getUserDefineDimensionList((long)this.modelId, (boolean)true);
                userDefinedDimMap = userDefineDimensionList.stream().collect(Collectors.toMap(e -> e.getString("number"), Function.identity(), (key1, key2) -> key2));
            }
            if (bgmdOrBgModelFlag) {
                userDefinedDimMap = this.getControlUserDefinedDimMap(businessModelDimIdAndDim, modelCacheHelper);
            }
            List<Object> userDefinedDimIdList = new ArrayList(16);
            Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
            if (bgmdOrBgModelFlag) {
                List<Dimension> businessModelList = this.getBusinessModelList(modelId, this.bussModelId);
                userDefinedDimIdList = businessModelList.stream().map(e -> e.getId().toString()).collect(Collectors.toList());
            } else {
                List userDefineDimensionList = DimensionServiceHelper.getUserDefineDimensionList((long)modelId, (boolean)true);
                userDefinedDimIdList = userDefineDimensionList.stream().map(e -> String.valueOf(e.getLong("id"))).collect(Collectors.toList());
            }
            int userDefineColTotal = 0;
            while (true) {
                Cell cell2;
                if (CellType.BLANK.equals((Object)(cell2 = row3.getCell(userDefinedColNumber)).getCellType())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"RuleControlImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                String value = this.getCellValue(cell2);
                if (value.equalsIgnoreCase(RuleControlImportPlugin.getPeriodClassifyCn())) break;
                if (value.endsWith("number")) {
                    int start = value.indexOf("#");
                    int end = value.indexOf(".");
                    if (start == -1 || end == -1) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"RuleControlImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    if (!userDefinedDimMap.containsKey(value = value.substring(start + 1, end))) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"RuleControlImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    userDefinedDimNumberSet.add(value);
                }
                ++userDefinedColNumber;
                ++userDefineColTotal;
            }
            if (userDefineColTotal % 2 != 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"RuleControlImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if ((row4 = firstSheet.getRow(++rowIndex)) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u4e2d\u5185\u5bb9\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"RuleControlImportPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            Map viewIds = new HashMap(16);
            if (bgmdOrBgModelFlag) {
                viewIds = BusinessModelServiceHelper.getViewIds((Long)this.bussModelId, (boolean)true);
            }
            ArrayList<Long> mainIdList = new ArrayList<Long>(16);
            int validCnt = 0;
            while (true) {
                boolean effectiveDateBlankFlag;
                String illustrate;
                Long viewId;
                String coefficient;
                this.rowErrorFlag = false;
                RuleControlImportDataPojo saveIm = new RuleControlImportDataPojo();
                Row row = firstSheet.getRow(rowIndex);
                if (this.isBreak(row)) break;
                if (this.isEmptyRow(row)) {
                    ++rowIndex;
                    continue;
                }
                ++validCnt;
                Row errorRowNext = errorSheet.createRow(rowIndex);
                this.copyRow(errorRowNext, row, errorSheet, columnNum);
                int colNumber = 0;
                Cell cell3 = row.getCell(colNumber++);
                String groupName = this.getCellValue(cell3);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)groupName) && groupName.length() > 20) {
                    this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u5206\u7ec4\u63a7\u5236\u540d\u79f0\u5e94\u5c0f\u4e8e\u7b49\u4e8e20\u4e2a\u5b57;", (String)"RuleControlImportPlugin_58", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                }
                saveIm.setGroupName(groupName);
                HashMap<Long, Integer> userDefinedDimIdIndexMap = new HashMap<Long, Integer>(16);
                for (int i = 0; i < userDefinedDimIdList.size(); ++i) {
                    userDefinedDimIdIndexMap.put(IDUtils.toLong((Object)userDefinedDimIdList.get(i)), i + 1);
                }
                ArrayList<GroupDimensionPojo> groupDimensions = new ArrayList<GroupDimensionPojo>(16);
                cell3 = row.getCell(colNumber++);
                String groupDims = this.getCellValue(cell3);
                ArrayList<String> groupDimNumbers = new ArrayList<String>(16);
                ArrayList<Long> groupDimIds = new ArrayList<Long>(16);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)groupName) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)groupDims)) {
                    String[] groupDimArray = groupDims.split(",");
                    ArrayList<String> notExistGroupDim = new ArrayList<String>(16);
                    for (String groupDim : groupDimArray) {
                        String[] nameAndNumber = groupDim.split("#");
                        String dimNumber = nameAndNumber[1];
                        Dimension dimension = modelCacheHelper.getDimension(dimNumber);
                        if (dimension != null && !dimension.isPreset() && userDefinedDimIdList.contains(IDUtils.toString((Object)dimension.getId()))) {
                            groupDimensions.add(new GroupDimensionPojo(dimension.getId(), Boolean.valueOf(false), IDUtils.toLong(userDefinedDimIdIndexMap.get(dimension.getId())), Boolean.valueOf(false)));
                            groupDimNumbers.add(dimNumber);
                            groupDimIds.add(dimension.getId());
                            continue;
                        }
                        notExistGroupDim.add(dimNumber);
                    }
                    if (CollectionUtils.isNotEmpty(notExistGroupDim)) {
                        String notExistControlDimJoin = org.apache.commons.lang3.StringUtils.join(notExistGroupDim, (String)",");
                        this.recordErroTip(errorRowNext, ResManager.loadResFormat((String)"\u5206\u7ec4\u7ef4\u5ea6%1\u4e0d\u5728\u9884\u7b97\u63a7\u5236\u7ef4\u5ea6\u7684\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u5185;", (String)"RuleControlImportPlugin_86", (String)"epm-eb-formplugin", (Object[])new Object[]{notExistControlDimJoin}), (Workbook)errorBook);
                    }
                }
                boolean oboDimErrorFlag = false;
                cell3 = row.getCell(colNumber++);
                String oboDimStr = this.getCellValue(cell3);
                String oboDimNumber = "";
                ArrayList<Long> oboDimIds = new ArrayList<Long>(16);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)groupName) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)oboDimStr)) {
                    String[] oboDimArray;
                    ArrayList<String> notExistGroupDim = new ArrayList<String>(16);
                    for (String oboDim : oboDimArray = oboDimStr.split(",")) {
                        String[] nameAndNumber = oboDim.split("#");
                        if (nameAndNumber == null || nameAndNumber.length < 2) {
                            this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u5206\u7ec4\u7ef4\u5ea6\uff08\u9010\u4e00\u5206\u7ec4\u7ef4\u5ea6\uff09\u7ef4\u5ea6\u540d\u79f0\u4e0e\u7ef4\u5ea6\u7f16\u7801\u95f4\u9694\u7b26\u8bf7\u4f7f\u7528#;", (String)"RuleControlImportPlugin_92", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                            continue;
                        }
                        oboDimNumber = nameAndNumber[1];
                        Dimension dimension = modelCacheHelper.getDimension(oboDimNumber);
                        if (dimension != null) {
                            if (userDefinedDimIdList.contains(IDUtils.toString((Object)dimension.getId()))) {
                                oboDimIds.add(dimension.getId());
                                groupDimensions.add(new GroupDimensionPojo(dimension.getId(), Boolean.valueOf(true), IDUtils.toLong(userDefinedDimIdIndexMap.get(dimension.getId())), Boolean.valueOf(false)));
                            } else {
                                notExistGroupDim.add(dimension.getNumber());
                            }
                        } else {
                            this.recordErroTip(errorRowNext, ResManager.loadResFormat((String)"\u9010\u4e00\u5206\u7ec4\u7ef4\u5ea6%1\u5728\u4f53\u7cfb\u5185\u4e0d\u5b58\u5728;", (String)"RuleControlImportPlugin_83", (String)"epm-eb-formplugin", (Object[])new Object[]{oboDimNumber}), (Workbook)errorBook);
                        }
                        if (!groupDimNumbers.contains(oboDimNumber)) continue;
                        oboDimErrorFlag = true;
                        this.recordErroTip(errorRowNext, ResManager.loadResFormat((String)"\u9010\u4e00\u5206\u7ec4\u7ef4\u5ea6%1\u5728\u5206\u7ec4\u7ef4\u5ea6\u4e2d\u5df2\u5b58\u5728;", (String)"RuleControlImportPlugin_95", (String)"epm-eb-formplugin", (Object[])new Object[]{oboDimNumber}), (Workbook)errorBook);
                    }
                    if (CollectionUtils.isNotEmpty(notExistGroupDim)) {
                        String notExistControlDimJoin = org.apache.commons.lang3.StringUtils.join(notExistGroupDim, (String)",");
                        this.recordErroTip(errorRowNext, ResManager.loadResFormat((String)"\u9010\u4e00\u5206\u7ec4\u7ef4\u5ea6%1\u4e0d\u5728\u9884\u7b97\u63a7\u5236\u7ef4\u5ea6\u7684\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u5185;", (String)"RuleControlImportPlugin_93", (String)"epm-eb-formplugin", (Object[])new Object[]{notExistControlDimJoin}), (Workbook)errorBook);
                    }
                }
                saveIm.setGroupDimensions(groupDimensions);
                int n = ++colNumber;
                ++colNumber;
                cell3 = row.getCell(n);
                List<Object> accountMemberList = new ArrayList(16);
                if (cell3 == null || CellType.BLANK.equals((Object)cell3.getCellType())) {
                    this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;", (String)"RuleControlImportPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                } else if (!CellType.STRING.equals((Object)modelNumCell.getCellType()) && !CellType.NUMERIC.equals((Object)modelNumCell.getCellType())) {
                    this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u8bf7\u586b\u5165\u6587\u672c\u578b\u7684\u5185\u5bb9;", (String)"RuleControlImportPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                }
                Dimension accountDimension = (Dimension)dimensionMapByNum.get(ACCOUNT);
                String accountNum = this.getCellValue(cell3);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)accountNum)) {
                    String[] accountNums;
                    if (accountNum.indexOf(13) >= 0 || accountNum.indexOf(10) >= 0) {
                        this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u6570\u636e\u5b58\u5728\u6362\u884c\u7b26;", (String)"RuleControlImportPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                    }
                    if ((accountNums = accountNum.split(",")).length > 0) {
                        HashSet<String> accountNumSet = new HashSet<String>(accountNums.length);
                        accountNumSet.addAll(Arrays.asList(accountNums));
                        List datasetIds = BusinessModelServiceHelper.getInstance().queryDataSetIds(Long.valueOf(this.bussModelId));
                        List accounts = modelCacheHelper.getMembers(accountDimension, null, accountNumSet);
                        if (accounts.isEmpty()) {
                            this.recordErroTip(errorRowNext, ResManager.loadResFormat((String)"\u4f53\u7cfb\u5185\u6ca1\u6709\u4ee5\u4e0b\u79d1\u76ee\u6210\u5458:%1;", (String)"RuleControlImportPlugin_59", (String)"epm-eb-formplugin", (Object[])new Object[]{org.apache.commons.lang3.StringUtils.join(accountNumSet, (String)",")}), (Workbook)errorBook);
                        }
                        if (bgmdOrBgModelFlag) {
                            accounts.removeIf(e -> !datasetIds.contains(e.getDatasetId()));
                        }
                        Map accountMap = accounts.stream().collect(Collectors.toMap(BaseCache::getNumber, Function.identity(), (key1, key2) -> key2));
                        int accountSize = accountNumSet.size();
                        HashSet<String> noExistSet = new HashSet<String>(accountNumSet.size());
                        for (String account : accountNumSet) {
                            if (accountMap.containsKey(account)) continue;
                            noExistSet.add(account);
                        }
                        accountNumSet.removeAll(noExistSet);
                        if (noExistSet.size() > 0) {
                            String noExistAccount = org.apache.commons.lang3.StringUtils.join(noExistSet, (String)",");
                            if (bgmdOrBgModelFlag) {
                                this.recordErroTip(errorRowNext, RuleControlImportPlugin.getNoExistAccountCnByBgm() + (String)noExistAccount + ";", (Workbook)errorBook);
                            }
                            if (ebModelFlag) {
                                this.recordErroTip(errorRowNext, RuleControlImportPlugin.getNoExistAccountCnByEb() + (String)noExistAccount + ";", (Workbook)errorBook);
                            }
                        }
                        if (accountNumSet.size() == accountSize) {
                            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)saveIm.getGroupName())) {
                                accountMemberList.addAll(accounts);
                            } else {
                                for (String account : accounts) {
                                    List accountLeaf = account.getLeaf();
                                    accountMemberList.addAll(accountLeaf);
                                }
                            }
                        }
                        accountMemberList = accountMemberList.stream().distinct().collect(Collectors.toList());
                    }
                    saveIm.setAccountMemberList(accountMemberList);
                }
                HashMap<String, List<String>> userDefinedIdMap = new HashMap<String, List<String>>(16);
                Row threeRow = firstSheet.getRow(3);
                ArrayList<OboMemberRangePojo> oboMemberRanges = new ArrayList<OboMemberRangePojo>(16);
                if (userDefinedDimNumberSet.size() > 0) {
                    for (int i = 0; i < userDefinedDimNumberSet.size(); ++i) {
                        String userDefinedDimNum;
                        List<String> userDefinedMemIdList = new ArrayList(16);
                        Dimension userDefinedDim = null;
                        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(userDefinedDimNum = this.getCellValue(cell3 = threeRow.getCell(++colNumber))))) {
                            if (userDefinedDimNum.equalsIgnoreCase(RuleControlImportPlugin.getPeriodClassifyCn())) break;
                            if (!userDefinedDimNum.endsWith("number")) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"RuleControlImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            }
                            int start = userDefinedDimNum.indexOf("#");
                            int end = userDefinedDimNum.indexOf(".");
                            if (start == -1 || end == -1) {
                                ++colNumber;
                                continue;
                            }
                            userDefinedDim = (Dimension)dimensionMapByNum.get(userDefinedDimNum = userDefinedDimNum.substring(start + 1, end));
                            if (userDefinedDim == null) {
                                ++colNumber;
                                continue;
                            }
                        } else {
                            ++colNumber;
                            continue;
                        }
                        cell3 = row.getCell(colNumber);
                        String userDefinedDimNumStr = this.getCellValue(cell3);
                        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)userDefinedDimNumStr)) {
                            String[] userDefinedNums = userDefinedDimNumStr.split(",");
                            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)groupName) && !oboDimErrorFlag && oboDimIds.contains(userDefinedDim.getId())) {
                                String number = "";
                                Member oboMember = null;
                                String range = "";
                                HashSet<String> noExistSet = new HashSet<String>(userDefinedNums.length);
                                for (String oboMemRange : userDefinedNums) {
                                    if (!oboMemRange.contains("#")) {
                                        this.recordErroTip(errorRowNext, ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u7684\u6210\u5458%2\u672a\u6309\u7ef4\u5ea6\u6210\u5458\u7f16\u7801#\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u7f16\u7801\u7684\u683c\u5f0f\u586b\u5199\u9010\u4e00\u6210\u5458\u5206\u7ec4\u7684\u7ef4\u5ea6\u6210\u5458\u53ca\u8303\u56f4;", (String)"RuleControlImportPlugin_90", (String)"epm-eb-formplugin", (Object[])new Object[]{userDefinedDim.getName(), oboMemRange}), (Workbook)errorBook);
                                        continue;
                                    }
                                    String[] numberAndRange = oboMemRange.split("#");
                                    number = numberAndRange[0];
                                    range = numberAndRange[1];
                                    int rangeIndex = Integer.parseInt(range);
                                    if (rangeIndex == RangeEnum.ALL.getIndex() || rangeIndex == RangeEnum.ALL_DETAIL.getIndex()) {
                                        oboMember = modelCacheHelper.getMemberByAnyView(userDefinedDim.getNumber(), number);
                                        if (oboMember != null) {
                                            oboMemberRanges.add(new OboMemberRangePojo(oboMember.getId(), oboMember.getNumber(), oboMember.getName(), range, userDefinedDim.getId()));
                                            continue;
                                        }
                                        noExistSet.add(number);
                                        continue;
                                    }
                                    this.recordErroTip(errorRowNext, ResManager.loadResFormat((String)"%1\u7684\u8303\u56f4\u4e0d\u5728\u5141\u8bb8\u8303\u56f4\u5185;", (String)"RuleControlImportPlugin_96", (String)"epm-eb-formplugin", (Object[])new Object[]{number}), (Workbook)errorBook);
                                }
                                if (noExistSet.size() > 0) {
                                    String noExistOboMember = org.apache.commons.lang3.StringUtils.join(noExistSet, (String)",");
                                    if (bgmdOrBgModelFlag) {
                                        this.recordErroTip(errorRowNext, RuleControlImportPlugin.getNoExistOboMemberCnByBgm() + noExistOboMember + ";", (Workbook)errorBook);
                                    }
                                    if (ebModelFlag) {
                                        this.recordErroTip(errorRowNext, RuleControlImportPlugin.getNoExistOboMemberCnByEb() + noExistOboMember + ";", (Workbook)errorBook);
                                    }
                                }
                            } else {
                                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)groupName) && !groupDimIds.contains(userDefinedDim.getId())) {
                                    this.recordErroTip(errorRowNext, ResManager.loadResFormat((String)"\u5df2\u586b\u5199\u7ef4\u5ea6\u6210\u5458\u7684\u7ef4\u5ea6%1\u4e0d\u5728\u5206\u7ec4\u7ef4\u5ea6\u5185;", (String)"RuleControlImportPlugin_91", (String)"epm-eb-formplugin", (Object[])new Object[]{userDefinedDim.getName()}), (Workbook)errorBook);
                                    ++colNumber;
                                    continue;
                                }
                                HashSet userDefinedNumSet = new HashSet(userDefinedNums.length);
                                userDefinedNumSet.addAll(Arrays.asList(userDefinedNums));
                                Long viewId2 = viewIds.get(userDefinedDimNum) == null ? Long.valueOf(0L) : (Long)viewIds.get(userDefinedDimNum);
                                List memDys = modelCacheHelper.getMembers(userDefinedDim, viewId2, (Collection)userDefinedNumSet);
                                if (memDys.isEmpty() && userDefinedNumSet.size() > 0) {
                                    this.recordErroTip(errorRowNext, ResManager.loadResFormat((String)"\u8be5\u4f53\u7cfb\u6216\u9ed8\u8ba4\u7ef4\u5ea6\u89c6\u56fe\u4e0b\u6ca1\u6709\u4ee5\u4e0b\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u6210\u5458:%1;", (String)"RuleControlImportPlugin_64", (String)"epm-eb-formplugin", (Object[])new Object[]{org.apache.commons.lang3.StringUtils.join((Iterable)userDefinedNumSet, (String)",")}), (Workbook)errorBook);
                                }
                                if (!memDys.isEmpty()) {
                                    Iterator noExistUserDefined;
                                    Map userDefinedMap = memDys.stream().collect(Collectors.toMap(BaseCache::getNumber, Function.identity(), (key1, key2) -> key2));
                                    int userDefinedSize = userDefinedNumSet.size();
                                    HashSet<String> noExistSet = new HashSet<String>(userDefinedNumSet.size());
                                    Iterator iterator = userDefinedNumSet.iterator();
                                    while (iterator.hasNext()) {
                                        String userDefined = (String)iterator.next();
                                        if (userDefinedMap.containsKey(userDefined)) continue;
                                        noExistSet.add(userDefined);
                                    }
                                    userDefinedNumSet.removeAll(noExistSet);
                                    if (noExistSet.size() > 0) {
                                        noExistUserDefined = org.apache.commons.lang3.StringUtils.join(noExistSet, (String)",");
                                        String userDefinedDimName = modelCacheHelper.getDimension(userDefinedDimNum).getName();
                                        if (bgmdOrBgModelFlag) {
                                            this.recordErroTip(errorRowNext, RuleControlImportPlugin.getImportCn() + userDefinedDimName + RuleControlImportPlugin.getNoExistCnByBgm() + noExistUserDefined + ";", (Workbook)errorBook);
                                        }
                                        if (ebModelFlag) {
                                            this.recordErroTip(errorRowNext, RuleControlImportPlugin.getImportCn() + userDefinedDimName + RuleControlImportPlugin.getNoExistCnByEb() + noExistUserDefined + ";", (Workbook)errorBook);
                                        }
                                    }
                                    if (userDefinedNumSet.size() == userDefinedSize) {
                                        Member userDefined;
                                        String userDefinedNum;
                                        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)saveIm.getGroupName())) {
                                            if (userDefinedNumSet.size() > 1) {
                                                this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u65b0\u589e\u63a7\u5236\u65b9\u5f0f\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u6210\u5458\u4e0d\u80fd\u5927\u4e8e\u4e00;", (String)"RuleControlImportPlugin_52", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                                            } else {
                                                noExistUserDefined = userDefinedNumSet.iterator();
                                                while (noExistUserDefined.hasNext()) {
                                                    userDefinedNum = (String)noExistUserDefined.next();
                                                    userDefined = (Member)userDefinedMap.get(userDefinedNum);
                                                    userDefinedMemIdList.add(IDUtils.toString((Object)userDefined.getId()));
                                                }
                                            }
                                        } else {
                                            if (bgmdOrBgModelFlag) {
                                                userDefinedMemIdList = this.getViewMemberLeafIds(userDefinedDim, memDys, viewId2, userDefinedNumSet);
                                            }
                                            if (ebModelFlag) {
                                                noExistUserDefined = userDefinedNumSet.iterator();
                                                while (noExistUserDefined.hasNext()) {
                                                    userDefinedNum = (String)noExistUserDefined.next();
                                                    userDefined = (Member)userDefinedMap.get(userDefinedNum);
                                                    List leaf = userDefined.getLeaf();
                                                    userDefinedMemIdList.addAll(leaf.stream().map(e -> IDUtils.toString((Object)e.getId())).collect(Collectors.toList()));
                                                }
                                            }
                                            userDefinedMemIdList = userDefinedMemIdList.stream().distinct().collect(Collectors.toList());
                                        }
                                    }
                                }
                                userDefinedIdMap.put(userDefinedDim.getId().toString(), userDefinedMemIdList);
                            }
                        }
                        ++colNumber;
                    }
                }
                saveIm.setOboMemberRanges(oboMemberRanges);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)groupName)) {
                    ArrayList<String> notMembersGroupDim = new ArrayList<String>(16);
                    for (Long groupDimId : groupDimIds) {
                        if (!CollectionUtils.isEmpty((Collection)((Collection)userDefinedIdMap.get(IDUtils.toString((Object)groupDimId))))) continue;
                        notMembersGroupDim.add(modelCacheHelper.getDimension(groupDimId).getNumber());
                    }
                    if (CollectionUtils.isNotEmpty(notMembersGroupDim)) {
                        String notMembersGroupDimJoin = org.apache.commons.lang3.StringUtils.join(notMembersGroupDim, (String)",");
                        this.recordErroTip(errorRowNext, ResManager.loadResFormat((String)"\u5206\u7ec4\u7ef4\u5ea6%1\u672a\u586b\u5199\u7ef4\u5ea6\u6210\u5458;", (String)"RuleControlImportPlugin_87", (String)"epm-eb-formplugin", (Object[])new Object[]{notMembersGroupDimJoin}), (Workbook)errorBook);
                    }
                    for (Map.Entry entry : userDefinedIdMap.entrySet()) {
                        Long userDefinedDimId = IDUtils.toLong(entry.getKey());
                        List userDefinedMemberNumbers = (List)entry.getValue();
                        if (!CollectionUtils.isNotEmpty((Collection)userDefinedMemberNumbers) || groupDimIds.contains(userDefinedDimId)) continue;
                        this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u5206\u7ec4\u7ef4\u5ea6\u4e0e\u5206\u7ec4\u7ef4\u5ea6\u6210\u5458\u672a\u4e00\u4e00\u5bf9\u5e94\uff0c\u8bf7\u68c0\u67e5;", (String)"RuleControlImportPlugin_88", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                    }
                    Map<Long, List<OboMemberRangePojo>> grpOboMemberRangeMap = oboMemberRanges.stream().collect(Collectors.groupingBy(k -> k.getOboDim()));
                    for (GroupDimensionPojo groupDimension : groupDimensions) {
                        if (!groupDimension.getOboDim().booleanValue() || !CollectionUtils.isNotEmpty((Collection)grpOboMemberRangeMap.get(groupDimension.getGroupDim()))) continue;
                        groupDimension.setMemberRange(Boolean.valueOf(true));
                    }
                }
                if ((cell3 = row.getCell(colNumber)) == null || CellType.BLANK.equals((Object)cell3.getCellType())) {
                    this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u660e\u7ec6\u671f\u95f4\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a;", (String)"RuleControlImportPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                } else if (!CellType.STRING.equals((Object)modelNumCell.getCellType()) && !CellType.NUMERIC.equals((Object)modelNumCell.getCellType())) {
                    this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u8bf7\u586b\u5165\u6587\u672c\u578b\u7684\u5185\u5bb9;", (String)"RuleControlImportPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                }
                String periodClassify = this.getCellValue(cell3);
                RulePeriodClassifyEnum rulePeriodClassifyEnum = null;
                boolean modelPeriodClassifyFlag = modelPeriodClassify.equalsIgnoreCase(periodClassify);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)periodClassify)) {
                    if (!modelPeriodClassifyFlag) {
                        this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u660e\u7ec6\u671f\u95f4\u5206\u7c7b\u9700\u4e0e\u4f53\u7cfb\u7684\u4e00\u81f4\uff0c\u8bf7\u786e\u8ba4;", (String)"RuleControlImportPlugin_63", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                    }
                    if (periodClassify.indexOf(13) >= 0 || periodClassify.indexOf(10) >= 0) {
                        this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u6570\u636e\u5b58\u5728\u6362\u884c\u7b26;", (String)"RuleControlImportPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)periodClassify)) {
                        rulePeriodClassifyEnum = RulePeriodClassifyEnum.valueOfName((String)periodClassify);
                        if (rulePeriodClassifyEnum == null) {
                            this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u672a\u5b9a\u4e49\u7684\u660e\u7ec6\u671f\u95f4\u5206\u7c7b;", (String)"RuleControlImportPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                        }
                        saveIm.setPeriodClassify(rulePeriodClassifyEnum != null ? rulePeriodClassifyEnum.getIndex() : "");
                    }
                }
                if ((cell3 = row.getCell(++colNumber)) == null || CellType.BLANK.equals((Object)cell3.getCellType())) {
                    this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u63a7\u5236\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a;", (String)"RuleControlImportPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                } else if (!CellType.STRING.equals((Object)modelNumCell.getCellType()) && !CellType.NUMERIC.equals((Object)modelNumCell.getCellType())) {
                    this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u8bf7\u586b\u5165\u6587\u672c\u578b\u7684\u5185\u5bb9;", (String)"RuleControlImportPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                }
                String controlType = this.getCellValue(cell3);
                RuleControlTypeEnum ruleControlTypeEnum = null;
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)controlType)) {
                    if (controlType.indexOf(13) >= 0 || controlType.indexOf(10) >= 0) {
                        this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u6570\u636e\u5b58\u5728\u6362\u884c\u7b26;", (String)"RuleControlImportPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)controlType)) {
                        ruleControlTypeEnum = RuleControlTypeEnum.valueOfName((String)controlType);
                        if (ruleControlTypeEnum == null) {
                            this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u672a\u5b9a\u4e49\u7684\u63a7\u5236\u65b9\u5f0f;", (String)"RuleControlImportPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                        }
                        saveIm.setControlType(ruleControlTypeEnum != null ? ruleControlTypeEnum.getIndex() : "");
                    }
                }
                if (rulePeriodClassifyEnum != null && ruleControlTypeEnum != null && modelPeriodClassifyFlag) {
                    if (RulePeriodClassifyEnum.IS_DETAIL_TO_MONTH.getName().equalsIgnoreCase(periodClassify)) {
                        ArrayList<String> controlTypeList = new ArrayList<String>(16);
                        for (RuleControlTypeEnum ruleControlTypeEnum1 : RuleControlTypeEnum.values()) {
                            controlTypeList.add(ruleControlTypeEnum1.getName());
                        }
                        if (!controlTypeList.contains(controlType)) {
                            this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u660e\u7ec6\u671f\u95f4\u5206\u7c7b\u548c\u63a7\u5236\u65b9\u5f0f\u7684\u5bf9\u5e94\u5173\u7cfb\u4e0d\u5bf9;", (String)"RuleControlImportPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                        }
                    }
                    if (RulePeriodClassifyEnum.IS_DETAIL_TO_QUARTER.getName().equalsIgnoreCase(periodClassify)) {
                        ArrayList<String> controlTypeList = new ArrayList<String>(16);
                        controlTypeList.add(RuleControlTypeEnum.CONTROL_QUARTER.getName());
                        controlTypeList.add(RuleControlTypeEnum.CONTROL_YEAR.getName());
                        controlTypeList.add(RuleControlTypeEnum.TOTAL_QUARTER.getName());
                        controlTypeList.add(RuleControlTypeEnum.CONTROL_HALF_YEAR.getName());
                        if (!controlTypeList.contains(controlType)) {
                            this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u660e\u7ec6\u671f\u95f4\u5206\u7c7b\u548c\u63a7\u5236\u65b9\u5f0f\u7684\u5bf9\u5e94\u5173\u7cfb\u4e0d\u5bf9;", (String)"RuleControlImportPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                        }
                    }
                    if (RulePeriodClassifyEnum.IS_DETAIL_TO_HALF_YEAR.getName().equalsIgnoreCase(periodClassify)) {
                        ArrayList<String> controlTypeList = new ArrayList<String>(16);
                        controlTypeList.add(RuleControlTypeEnum.CONTROL_HALF_YEAR.getName());
                        controlTypeList.add(RuleControlTypeEnum.CONTROL_YEAR.getName());
                        if (!controlTypeList.contains(controlType)) {
                            this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u660e\u7ec6\u671f\u95f4\u5206\u7c7b\u548c\u63a7\u5236\u65b9\u5f0f\u7684\u5bf9\u5e94\u5173\u7cfb\u4e0d\u5bf9;", (String)"RuleControlImportPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                        }
                    }
                }
                if ((cell3 = row.getCell(++colNumber)) == null || CellType.BLANK.equals((Object)cell3.getCellType())) {
                    this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u67d4\u6027\u7cfb\u6570\u4e0d\u80fd\u4e3a\u7a7a;", (String)"RuleControlImportPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(coefficient = this.getCellValue(cell3)))) {
                    if (coefficient.indexOf(13) >= 0 || coefficient.indexOf(10) >= 0) {
                        this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u6570\u636e\u5b58\u5728\u6362\u884c\u7b26;", (String)"RuleControlImportPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                    }
                    BigDecimal coefficientBd = null;
                    try {
                        coefficientBd = new BigDecimal(coefficient);
                        coefficientBd = coefficientBd.setScale(2, RoundingMode.HALF_UP);
                        if (coefficientBd.equals(BigDecimal.ZERO)) {
                            this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u68c0\u67e5\u67d4\u6027\u7cfb\u6570\u7684\u6570\u636e\u5408\u89c4\u6027;", (String)"RuleControlImportPlugin_97", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                        } else {
                            if (coefficientBd.compareTo(new BigDecimal("9.99")) > 0 || coefficientBd.compareTo(BigDecimal.ZERO) <= 0) {
                                this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u68c0\u67e5\u67d4\u6027\u7cfb\u6570\u7684\u6570\u636e\u5408\u89c4\u6027\uff0c\u8303\u56f4\u5927\u4e8e0\u5c0f\u4e8e10\u4e14\u53ea\u80fd\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570;", (String)"RuleControlImportPlugin_53", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                            }
                            saveIm.setCoefficient(coefficient);
                        }
                    }
                    catch (Exception e2) {
                        log.error((Throwable)e2);
                        this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u67d4\u6027\u7cfb\u6570\u8bf7\u8f93\u5165\u6570\u5b57\u578b\u7684\u5185\u5bb9\u3002", (String)"RuleControlImportPlugin_75", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                    }
                }
                if ((cell3 = row.getCell(++colNumber)) == null || CellType.BLANK.equals((Object)cell3.getCellType())) {
                    this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u662f\u5426\u5141\u8bb8\u8d85\u9884\u7b97\u4e0d\u80fd\u4e3a\u7a7a;", (String)"RuleControlImportPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                } else if (!CellType.STRING.equals((Object)modelNumCell.getCellType()) && !CellType.NUMERIC.equals((Object)modelNumCell.getCellType())) {
                    this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u8bf7\u586b\u5165\u6587\u672c\u578b\u7684\u5185\u5bb9;", (String)"RuleControlImportPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                }
                String isBeyond = this.getCellValue(cell3);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)isBeyond)) {
                    if (isBeyond.indexOf(13) >= 0 || isBeyond.indexOf(10) >= 0) {
                        this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u6570\u636e\u5b58\u5728\u6362\u884c\u7b26;", (String)"RuleControlImportPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                    }
                    ArrayList<String> isBeyondList = new ArrayList<String>(16);
                    isBeyondList.add(RuleControlImportPlugin.getYesCn());
                    isBeyondList.add(RuleControlImportPlugin.getNoCn());
                    if (isBeyondList.contains(isBeyond)) {
                        saveIm.setIsBeyond(isBeyond.equalsIgnoreCase(RuleControlImportPlugin.getYesCn()) ? "1" : (isBeyond.equalsIgnoreCase(RuleControlImportPlugin.getNoCn()) ? "0" : ""));
                    } else {
                        this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u662f\u5426\u5141\u8bb8\u8d85\u9884\u7b97\u53ea\u5141\u8bb8\u586b\u662f\u6216\u8005\u5426;", (String)"RuleControlImportPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                    }
                }
                int n2 = ++colNumber;
                ++colNumber;
                cell3 = row.getCell(n2);
                ArrayList<Member> orgRangeMemberList = new ArrayList<Member>(16);
                String orgRangeNum = this.getCellValue(cell3);
                ArrayList<OrgMemberDto> orgMemberDtos = new ArrayList<OrgMemberDto>(16);
                Dimension orgRangeDimension = (Dimension)dimensionMapByNum.get(ENTITY);
                Long l = viewId = viewIds.get(orgRangeDimension.getNumber()) == null ? Long.valueOf(0L) : (Long)viewIds.get(orgRangeDimension.getNumber());
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orgRangeNum)) {
                    String[] orgRangeNums = orgRangeNum.split(",");
                    if (orgRangeNums.length > 0) {
                        HashSet<String> orgRangeNumSet = new HashSet<String>(orgRangeNums.length);
                        orgRangeNumSet.addAll(Arrays.asList(orgRangeNums));
                        List memDys = modelCacheHelper.getMembers(orgRangeDimension, viewId, orgRangeNumSet);
                        if (memDys.isEmpty() && orgRangeNumSet.size() > 0) {
                            this.recordErroTip(errorRowNext, ResManager.loadResFormat((String)"\u8be5\u4f53\u7cfb\u6216\u9ed8\u8ba4\u7ef4\u5ea6\u89c6\u56fe\u4e0b\u6ca1\u6709\u4ee5\u4e0b\u7ec4\u7ec7\u6210\u5458:%1;", (String)"RuleControlImportPlugin_65", (String)"epm-eb-formplugin", (Object[])new Object[]{org.apache.commons.lang3.StringUtils.join(orgRangeNumSet, (String)",")}), (Workbook)errorBook);
                        }
                        if (!memDys.isEmpty()) {
                            Map orgRangeMap = memDys.stream().collect(Collectors.toMap(BaseCache::getNumber, Function.identity(), (key1, key2) -> key2));
                            int orgRangeSize = orgRangeNumSet.size();
                            HashSet<String> noExistSet = new HashSet<String>(orgRangeNumSet.size());
                            for (String orgRange : orgRangeNumSet) {
                                if (orgRangeMap.containsKey(orgRange)) continue;
                                noExistSet.add(orgRange);
                            }
                            orgRangeNumSet.removeAll(noExistSet);
                            if (noExistSet.size() > 0) {
                                String noExistAccount = org.apache.commons.lang3.StringUtils.join(noExistSet, (String)",");
                                if (bgmdOrBgModelFlag) {
                                    this.recordErroTip(errorRowNext, RuleControlImportPlugin.getNoExistEntityCnByBgm() + (String)noExistAccount + ";", (Workbook)errorBook);
                                }
                                if (ebModelFlag) {
                                    this.recordErroTip(errorRowNext, RuleControlImportPlugin.getNoExistEntityCnByEb() + (String)noExistAccount + ";", (Workbook)errorBook);
                                }
                            }
                            if (orgRangeNumSet.size() == orgRangeSize) {
                                for (Member memDy : memDys) {
                                    orgRangeMemberList.add(memDy);
                                    orgMemberDtos.add(new OrgMemberDto(memDy.getId(), memDy.getNumber(), memDy.getName(), "1", viewId));
                                }
                            }
                        }
                    }
                    saveIm.setOrgRangeList(orgRangeMemberList);
                }
                int n3 = ++colNumber;
                ++colNumber;
                cell3 = row.getCell(n3);
                String propNum = this.getCellValue(cell3);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)propNum)) {
                    MemberPropCache propCache = MemberPropCacheService.getOrCreate((Long)modelId);
                    Set proNums = Arrays.stream(propNum.split(",")).collect(Collectors.toSet());
                    ArrayList<Object> notFoundPro = new ArrayList<Object>(16);
                    for (Object pro : proNums) {
                        Boolean hasProp = false;
                        if (((String)pro).contains("!")) {
                            CustomPropertyValue propValue = propCache.getPropertyValue(orgRangeDimension.getNumber(), ((String)pro).split("!")[0], ((String)pro).split("!")[1]);
                            if (propValue != null) {
                                hasProp = true;
                                orgMemberDtos.add(new OrgMemberDto(propValue.getId(), propValue.getNumber(), propValue.getName(), "2", viewId));
                            }
                        } else {
                            List propertiesDim = propCache.getPropertiesByDim(orgRangeDimension.getId());
                            for (CustomProperty customProperty : propertiesDim) {
                                CustomPropertyValue propValue = propCache.getPropertyValue(orgRangeDimension.getNumber(), customProperty.getNumber(), (String)pro);
                                if (propValue == null) continue;
                                hasProp = true;
                                orgMemberDtos.add(new OrgMemberDto(propValue.getId(), propValue.getNumber(), propValue.getName(), "2", viewId));
                            }
                        }
                        if (hasProp.booleanValue()) continue;
                        notFoundPro.add(pro);
                    }
                    if (!notFoundPro.isEmpty()) {
                        this.recordErroTip(errorRowNext, ResManager.loadResFormat((String)"\u672a\u627e\u5230\u5c5e\u6027\uff1a%s\u3002", (String)"RuleControlImportPlugin_80", (String)"epm-eb-formplugin", (Object[])new Object[]{org.apache.commons.lang3.StringUtils.join(notFoundPro, (String)"\u3001")}), (Workbook)errorBook);
                    }
                }
                saveIm.setOrgMember(orgMemberDtos);
                cell3 = row.getCell(colNumber += 2);
                String curGroupMemberStr = this.getCellValue(cell3);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)groupName) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)curGroupMemberStr)) {
                    Object pro;
                    HashMap<Integer, String> groupDimMap = new HashMap<Integer, String>(16);
                    groupDimMap.put(0, accountDimension.getNumber());
                    int groupIndex = 1;
                    Long userDefinedDimId = 0L;
                    pro = userDefinedDimIdList.iterator();
                    while (pro.hasNext()) {
                        String userDefinedDimIdStr = (String)pro.next();
                        userDefinedDimId = IDUtils.toLong((Object)userDefinedDimIdStr);
                        if (!groupDimIds.contains(userDefinedDimId)) continue;
                        groupDimMap.put(groupIndex, modelCacheHelper.getDimension(userDefinedDimId).getNumber());
                        ++groupIndex;
                    }
                    ArrayList curGroupMemberIds = new ArrayList(16);
                    String[] curGroupMembers = curGroupMemberStr.split(",");
                    String number = "";
                    boolean notExist = false;
                    String notExistNumber = "";
                    HashSet<Member> groupAccountSet = new HashSet<Member>(16);
                    for (String curGroupMember : curGroupMembers) {
                        ArrayList<Long> curGroupMemberId = new ArrayList<Long>(16);
                        if (notExist) break;
                        String[] numberArray = curGroupMember.split("#");
                        for (int i = 0; i < numberArray.length; ++i) {
                            number = numberArray[i];
                            Member member = modelCacheHelper.getMemberByAnyView((String)groupDimMap.get(i), number);
                            if (member == null) {
                                notExist = true;
                                notExistNumber = number;
                                continue;
                            }
                            if (i == 0) {
                                groupAccountSet.add(member);
                            }
                            curGroupMemberId.add(member.getId());
                        }
                        curGroupMemberIds.add(curGroupMemberId);
                    }
                    if (notExist) {
                        this.recordErroTip(errorRowNext, ResManager.loadResFormat((String)"\u5206\u7ec4\u7ef4\u5ea6\u7ec4\u5408\u7f16\u7801\u4e2d%1\u6210\u5458\u4e0d\u5b58\u5728;", (String)"RuleControlImportPlugin_89", (String)"epm-eb-formplugin", (Object[])new Object[]{notExistNumber}), (Workbook)errorBook);
                    } else {
                        saveIm.setCurGroupMemberIds(curGroupMemberIds);
                        saveIm.setAccountMemberList(new ArrayList(groupAccountSet));
                    }
                }
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(illustrate = this.getCellValue(cell3 = row.getCell(++colNumber))))) {
                    illustrate = "";
                }
                if (illustrate.length() > 255) {
                    this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u8bf4\u660e\u7684\u5b57\u6570\u4e0d\u80fd\u8d85\u8fc7255\u4e2a\u5b57\u7b26\u3002", (String)"RuleControlImportPlugin_76", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                }
                saveIm.setIllustrate(illustrate);
                cell3 = row.getCell(++colNumber);
                Date effectiveDate = null;
                if (cell3 != null) {
                    if (!CellType.STRING.equals((Object)cell3.getCellType()) && DateUtil.isCellDateFormatted((Cell)cell3)) {
                        double value = cell3.getNumericCellValue();
                        if (value > 0.0) {
                            effectiveDate = DateUtil.getJavaDate((double)value);
                            saveIm.setEffectiveDate(effectiveDate);
                        }
                    } else {
                        String value = this.getCellValue(cell3);
                        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)value)) {
                            effectiveDate = DateTimeUtils.parseDate((String)value, (String)"yyyy/MM/dd");
                            saveIm.setEffectiveDate(effectiveDate);
                        }
                    }
                }
                cell3 = row.getCell(++colNumber);
                Date invalidDate = null;
                if (cell3 != null) {
                    if (!CellType.STRING.equals((Object)cell3.getCellType()) && DateUtil.isCellDateFormatted((Cell)cell3)) {
                        double value = cell3.getNumericCellValue();
                        if (value > 0.0) {
                            invalidDate = DateUtil.getJavaDate((double)cell3.getNumericCellValue());
                            saveIm.setInvalidDate(invalidDate);
                        }
                    } else {
                        String value = this.getCellValue(cell3);
                        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)value)) {
                            invalidDate = DateTimeUtils.parseDate((String)value, (String)"yyyy/MM/dd");
                            saveIm.setInvalidDate(invalidDate);
                        }
                    }
                }
                boolean bl = effectiveDateBlankFlag = effectiveDate == null && invalidDate != null;
                if (effectiveDateBlankFlag) {
                    saveIm.setInvalidDate(null);
                }
                if (effectiveDate != null && invalidDate != null) {
                    LocalDate invalidLocalDate;
                    ZoneId zoneId = ZoneId.systemDefault();
                    LocalDate effectiveLocalDate = effectiveDate.toInstant().atZone(zoneId).toLocalDate();
                    if (effectiveLocalDate.isAfter(invalidLocalDate = invalidDate.toInstant().atZone(zoneId).toLocalDate())) {
                        this.recordErroTip(errorRowNext, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u665a\u4e8e\u5931\u6548\u65e5\u671f;", (String)"RuleControlImportPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]), (Workbook)errorBook);
                    }
                }
                this.getDtoMembers.clear();
                List<Object> errorList = new ArrayList(16);
                if (!this.rowErrorFlag) {
                    errorList = this.saveRuleControlData(saveIm, userDefinedDimIdList, userDefinedIdMap, mainIdList);
                }
                if (!errorList.isEmpty()) {
                    String errorStr = StringUtils.join(errorList, (String)",");
                    this.recordErroTip(errorRowNext, errorStr, (Workbook)errorBook);
                }
                ++rowIndex;
                if (this.rowErrorFlag) continue;
                Integer n4 = this.successDataNum;
                this.successDataNum = this.successDataNum + 1;
                Integer n5 = this.successDataNum;
            }
            if (CollectionUtils.isNotEmpty(mainIdList)) {
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5bfc\u5165\u4fdd\u5b58", "RuleControlImportPlugin_3", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u7f16\u53f7%1$s\uff0c\u4fdd\u5b58\u6210\u529f\u3002", "RuleControlImportPlugin_100", "epm-eb-formplugin");
                OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"save", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[]{JSONUtils.toString(mainIdList)});
            } else if (validCnt < 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230excel\u65e0\u6709\u6548\u6570\u636e\uff0c\u8bf7\u68c0\u67e5", (String)"RuleControlImportPlugin_98", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (this.erroFlag) {
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)RuleControlImportPlugin.writeFile((Workbook)errorBook, ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u51fa\u9519\u8be6\u60c5", (String)"DimMappingImportPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0])));
            }
        }
        catch (ParseException pe) {
            log.error((Throwable)pe);
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u4e2d\u751f\u6548\u65e5\u671f\u3001\u5931\u6548\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"RuleControlImportPlugin_56", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e3) {
            log.error((Throwable)e3);
            throw new KDBizException(e3.getMessage());
        }
    }

    private List<String> getViewMemberLeafIds(Dimension dimension, List<Member> memDys, Long viewId, Set<String> userDefinedNumSet) {
        ArrayList<String> leafMemberIds = new ArrayList<String>(16);
        if (dimension == null || CollectionUtils.isEmpty(memDys) || CollectionUtils.isEmpty(userDefinedNumSet)) {
            return leafMemberIds;
        }
        List<Long> memberIds = memDys.stream().map(BaseCache::getId).collect(Collectors.toList());
        Collection<DynamicObject> objects = this.getViewMembersByMemberIds(dimension, viewId, memberIds);
        if (CollectionUtils.isNotEmpty(objects)) {
            Map userDefinedMap = objects.stream().collect(Collectors.toMap(e -> e.getString("number"), Function.identity(), (key1, key2) -> key2));
            Map<Long, List<DynamicObject>> userDefinedGroupByParentMap = objects.stream().collect(Collectors.groupingBy(e -> e.getLong("parent.id")));
            HashSet<DynamicObject> leafSet = new HashSet<DynamicObject>(userDefinedNumSet.size());
            for (String num : userDefinedNumSet) {
                DynamicObject userDefined = (DynamicObject)userDefinedMap.get(num);
                if (!userDefined.getBoolean("isleaf")) {
                    long level = userDefined.getLong("level");
                    long id = userDefined.getLong("id");
                    ArrayList<DynamicObject> leafObjects = new ArrayList<DynamicObject>(userDefinedMap.size());
                    this.getDynamicObjectChildren(level, leafObjects, id, userDefinedGroupByParentMap);
                    leafSet.addAll(leafObjects);
                    continue;
                }
                leafSet.add(userDefined);
            }
            leafMemberIds.addAll(leafSet.stream().map(e -> e.getString("memberid")).collect(Collectors.toList()));
        } else {
            Map userDefinedMap = memDys.stream().collect(Collectors.toMap(BaseCache::getNumber, Function.identity(), (key1, key2) -> key2));
            for (String userDefinedNum : userDefinedNumSet) {
                Member userDefined = (Member)userDefinedMap.get(userDefinedNum);
                List leaf = userDefined.getLeaf();
                leafMemberIds.addAll(leaf.stream().map(e -> IDUtils.toString((Object)e.getId())).collect(Collectors.toList()));
            }
        }
        return leafMemberIds;
    }

    @NotNull
    private Collection<DynamicObject> getViewMembersByMemberIds(Dimension dimension, Long viewId, List<Long> memberIds) {
        Collection<Object> objects = new ArrayList<DynamicObject>(16);
        if (dimension == null || CollectionUtils.isEmpty(memberIds)) {
            return objects;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)this.modelId));
        builder.add(new QFilter("dimension", "=", (Object)dimension.getId()));
        builder.add(new QFilter("view", "=", (Object)viewId));
        builder.add(new QFilter("enable", "=", (Object)"1"));
        builder.add(new QFilter("memberid", "in", memberIds));
        objects = BusinessDataServiceHelper.loadFromCache((String)"eb_viewmember", (String)"id, memberid, name, number, longnumber, level, parent.id, aggoprt,dseq,isleaf", (QFilter[])builder.toArrays()).values();
        return objects;
    }

    private String getModelPeriodClassify(DynamicObject model) {
        if (model != null) {
            if (model.getBoolean("isdetailtomonth") && !model.getBoolean("isdetailtoqrt") && !model.getBoolean("isdetailtohalfyear")) {
                return RulePeriodClassifyEnum.IS_DETAIL_TO_MONTH.getName();
            }
            if (!model.getBoolean("isdetailtomonth") && model.getBoolean("isdetailtoqrt") && !model.getBoolean("isdetailtohalfyear")) {
                return RulePeriodClassifyEnum.IS_DETAIL_TO_QUARTER.getName();
            }
            if (!model.getBoolean("isdetailtomonth") && !model.getBoolean("isdetailtoqrt") && model.getBoolean("isdetailtohalfyear")) {
                return RulePeriodClassifyEnum.IS_DETAIL_TO_HALF_YEAR.getName();
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u76f8\u5e94\u7684\u4f53\u7cfb\u7f16\u7801\u3002", (String)"RuleControlImportPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return RulePeriodClassifyEnum.IS_DETAIL_TO_MONTH.getName();
    }

    private void getDynamicObjectChildren(long level, List<DynamicObject> leafObjects, long account, Map<Long, List<DynamicObject>> groupByParentMap) {
        if (level == 0L) {
            return;
        }
        List<DynamicObject> objects = groupByParentMap.get(account);
        if (CollectionUtils.isNotEmpty(objects)) {
            for (DynamicObject object : objects) {
                if (object.getBoolean("isleaf")) {
                    leafObjects.add(object);
                    continue;
                }
                this.getDynamicObjectChildren(object.getLong("level"), leafObjects, object.getLong("id"), groupByParentMap);
            }
            --level;
        }
    }

    private Map<String, DynamicObject> getControlUserDefinedDimMap(Map<Long, DynamicObject> businessModelDimIdAndDim, IModelCacheHelper cacheHelper) {
        QFilter qFilter2;
        HashMap<String, DynamicObject> userDefinedDimMap = new HashMap<String, DynamicObject>(16);
        String fields = "id,model.id,businessmodel.id,entryentity.id,entryentity.dimensionid";
        QFilter qFilter = new QFilter("model", "=", (Object)this.modelId);
        DynamicObject controlDimension = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_bgmcontroldimension", (String)fields, (QFilter[])new QFilter[]{qFilter, qFilter2 = new QFilter("businessmodel", "=", (Object)this.bussModelId)});
        if (controlDimension == null) {
            return userDefinedDimMap;
        }
        DynamicObjectCollection entries = controlDimension.getDynamicObjectCollection("entryentity");
        if (entries != null) {
            for (DynamicObject entry : entries) {
                Dimension dimension;
                long dimensionid = entry.getLong("dimensionid");
                if (!businessModelDimIdAndDim.containsKey(dimensionid) || (dimension = cacheHelper.getDimension(Long.valueOf(dimensionid))) == null) continue;
                userDefinedDimMap.put(dimension.getNumber(), entry);
            }
        }
        return userDefinedDimMap;
    }

    private Map<Long, DynamicObject> getBusinessModelDimidAndDim(boolean ebModelFlag, boolean bgmdModelFlag) {
        Map<Long, Object> objectMap = new HashMap<Long, DynamicObject>(16);
        if (this.modelId == 0L) {
            return objectMap;
        }
        if (bgmdModelFlag || ModelUtil.isBGModel((Long)this.modelId)) {
            DynamicObject query;
            DynamicObject model = ModelUtils.getModel((Long)this.modelId);
            QFilter qFilter = new QFilter("model", "=", (Object)model.getLong("id"));
            if (IDUtils.isNotEmptyLong((Long)this.bussModelId).booleanValue()) {
                qFilter.and(new QFilter("businessmodel", "=", (Object)this.bussModelId));
            }
            if ((query = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_bgmcontroldimension", (QFilter[])new QFilter[]{qFilter})) == null) {
                return objectMap;
            }
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.modelId);
            DynamicObjectCollection entryEntity = query.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryEntity) {
                long dimId = dynamicObject.getLong("dimensionid");
                Dimension dimension = modelCache.getDimension(Long.valueOf(dimId));
                if (dimension.isPreset()) continue;
                objectMap.put(dimId, dynamicObject);
            }
        }
        if (ebModelFlag) {
            List userDefineDimensionList = DimensionServiceHelper.getUserDefineDimensionList((long)this.modelId, (boolean)true);
            objectMap = userDefineDimensionList.stream().collect(Collectors.toMap(e -> e.getLong("id"), Function.identity(), (key1, key2) -> key2));
        }
        return objectMap;
    }

    private List<String> saveRuleControlData(RuleControlImportDataPojo saveIm, List<String> userDefinedDimIdList, Map<String, List<String>> userDefinedIdMap, List<Long> mainIdList) {
        List<String> errorList;
        String showOrg;
        List orgRangeList;
        DynamicObject main = BusinessDataServiceHelper.newDynamicObject((String)"eb_bgcontrolrulemain");
        Long mainId = DBServiceHelper.genGlobalLongId();
        main.set("id", (Object)mainId);
        main.set("model", (Object)this.modelId);
        main.set("bussmodel", (Object)this.bussModelId);
        main.set("periodclassify", (Object)saveIm.getPeriodClassify());
        main.set("controltype", (Object)saveIm.getControlType());
        main.set("coefficient", (Object)saveIm.getCoefficient());
        main.set("isbeyond", (Object)saveIm.getIsBeyond());
        main.set("illustrate", (Object)saveIm.getIllustrate());
        main.set("effectivedate", (Object)saveIm.getEffectiveDate());
        main.set("invaliddate", (Object)saveIm.getInvalidDate());
        main.set("isdefault", (Object)0);
        main.set("creater", (Object)UserUtils.getUserId());
        main.set("createdate", (Object)TimeServiceHelper.now());
        List accountMemberList = saveIm.getAccountMemberList();
        if (CollectionUtils.isNotEmpty((Collection)accountMemberList)) {
            String showAccount = accountMemberList.stream().map(Member::getName).collect(Collectors.joining(","));
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)showAccount) && showAccount.length() < 600) {
                main.set("showaccount", (Object)showAccount);
            }
            for (Member account : accountMemberList) {
                DynamicObjectCollection childAccounts = main.getDynamicObjectCollection("accounts");
                DynamicObject rowAccount = new DynamicObject(childAccounts.getDynamicObjectType());
                rowAccount.set("account", (Object)account.getId());
                childAccounts.add((Object)rowAccount);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(orgRangeList = saveIm.getOrgRangeList())) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(showOrg = orgRangeList.stream().map(Member::getName).collect(Collectors.joining(",")))) && showOrg.length() < 600) {
            main.set("showorgrange", (Object)showOrg);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)saveIm.getGroupName())) {
            int i;
            List oboMemberRanges;
            List groupDimensions = saveIm.getGroupDimensions();
            HashSet<Long> groupDimSet = new HashSet<Long>(16);
            if (CollectionUtils.isNotEmpty((Collection)groupDimensions)) {
                DynamicObjectCollection groupUserDefineDims = main.getDynamicObjectCollection("groupdims");
                for (GroupDimensionPojo groupDimension : groupDimensions) {
                    DynamicObject rowDimention = new DynamicObject(groupUserDefineDims.getDynamicObjectType());
                    rowDimention.set("groupdim", (Object)groupDimension.getGroupDim());
                    rowDimention.set("isobodim", (Object)groupDimension.getOboDim());
                    rowDimention.set("obodimindex", (Object)groupDimension.getDimIndex());
                    rowDimention.set("ismemberrange", (Object)groupDimension.getMemberRange());
                    groupUserDefineDims.add((Object)rowDimention);
                    if (groupDimension.getOboDim().booleanValue()) continue;
                    groupDimSet.add(groupDimension.getGroupDim());
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(oboMemberRanges = saveIm.getOboMemberRanges()))) {
                DynamicObjectCollection oboMemRanges = main.getDynamicObjectCollection("obomemranges");
                for (OboMemberRangePojo oboMemberRange : oboMemberRanges) {
                    DynamicObject dynamicObject = new DynamicObject(oboMemRanges.getDynamicObjectType());
                    dynamicObject.set("obomember", (Object)oboMemberRange.getOboMember());
                    dynamicObject.set("obodim", (Object)oboMemberRange.getOboDim());
                    dynamicObject.set("memrange", (Object)oboMemberRange.getMemRange());
                    oboMemRanges.add((Object)dynamicObject);
                }
            }
            List curGroupMemberIds = saveIm.getCurGroupMemberIds();
            ArrayList<Long> groupDimByIndex = new ArrayList<Long>(userDefinedDimIdList.size());
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.modelId);
            Dimension dimension = modelCacheHelper.getDimension(SysDimensionEnum.Account.getNumber());
            groupDimByIndex.add(dimension.getId());
            if (CollectionUtils.isEmpty((Collection)curGroupMemberIds)) {
                List accountIds = accountMemberList.stream().map(BaseCache::getId).collect(Collectors.toList());
                curGroupMemberIds.add(accountIds);
                for (i = 0; i < 7; ++i) {
                    ArrayList<Long> tempList = new ArrayList<Long>(16);
                    if (userDefinedDimIdList.size() > i) {
                        String userDefinedDimId = userDefinedDimIdList.get(i);
                        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)userDefinedDimId) && CollectionUtils.isNotEmpty((Collection)userDefinedIdMap.get(userDefinedDimId))) {
                            tempList.addAll(IDUtils.toLongs(userDefinedIdMap.get(userDefinedDimId)));
                        } else {
                            tempList.add(0L);
                        }
                    } else {
                        tempList.add(0L);
                    }
                    curGroupMemberIds.add(tempList);
                }
                curGroupMemberIds = Lists.cartesianProduct((List)curGroupMemberIds);
                groupDimByIndex.addAll(IDUtils.toLongs(userDefinedDimIdList));
            } else {
                for (int i2 = 0; i2 < userDefinedDimIdList.size(); ++i2) {
                    Long dimId = IDUtils.toLong((Object)userDefinedDimIdList.get(i2));
                    if (!groupDimSet.contains(dimId)) continue;
                    groupDimByIndex.add(dimId);
                }
            }
            HashMap<Long, Integer> userDefinedDimIdIndexMap = new HashMap<Long, Integer>(16);
            for (i = 0; i < userDefinedDimIdList.size(); ++i) {
                userDefinedDimIdIndexMap.put(IDUtils.toLong((Object)userDefinedDimIdList.get(i)), i + 1);
            }
            DynamicObjectCollection groupMems = main.getDynamicObjectCollection("dimentions");
            for (List curGroupMemberId : curGroupMemberIds) {
                DynamicObject rowDynamicObject = new DynamicObject(groupMems.getDynamicObjectType());
                for (int i3 = 0; i3 < curGroupMemberId.size(); ++i3) {
                    if (i3 > 0) {
                        if (!IDUtils.isNotEmptyLong((Long)((Long)curGroupMemberId.get(i3))).booleanValue()) continue;
                        Long dimId = (Long)groupDimByIndex.get(i3);
                        Integer index = (Integer)userDefinedDimIdIndexMap.get(dimId);
                        rowDynamicObject.set("userdefineddimid" + index, (Object)dimId);
                        rowDynamicObject.set("userdefined" + index, curGroupMemberId.get(i3));
                        continue;
                    }
                    rowDynamicObject.set("groupaccount", curGroupMemberId.get(i3));
                }
                groupMems.add((Object)rowDynamicObject);
            }
        } else {
            ArrayList<DynamicObject> dimRows = new ArrayList<DynamicObject>(16);
            ArrayList<List<String>> lists = new ArrayList<List<String>>(7);
            DynamicObjectCollection childDimentions = main.getDynamicObjectCollection("dimentions");
            if (CollectionUtils.isNotEmpty(userDefinedDimIdList)) {
                int i;
                HashMap<Integer, String> userDefinedDimIdMap = new HashMap<Integer, String>(16);
                for (int i4 = 1; i4 <= 7; ++i4) {
                    List<String> userDefineIdList = new ArrayList(16);
                    if (i4 <= userDefinedDimIdList.size()) {
                        String string = userDefinedDimIdList.get(i4 - 1);
                        userDefinedDimIdMap.put(i4, string);
                        userDefineIdList = userDefinedIdMap.get(string);
                    }
                    lists.add(userDefineIdList);
                }
                int rowLength = 1;
                for (List list : lists) {
                    if (list == null || list.isEmpty()) continue;
                    rowLength *= list.size();
                }
                for (i = 0; i < rowLength; ++i) {
                    DynamicObject dynamicObject = new ORMImpl().newDynamicObject("eb_bgcontrolruledefineds");
                    dimRows.add(dynamicObject);
                }
                this.getNewRows(dimRows, lists, 0);
                for (i = 0; i < dimRows.size(); ++i) {
                    DynamicObject dynamicObject = new DynamicObject(childDimentions.getDynamicObjectType());
                    for (int j = 1; j <= 7; ++j) {
                        if (((DynamicObject)dimRows.get(i)).get("userdefined" + j) == null) continue;
                        dynamicObject.set("userdefined" + j, ((DynamicObject)dimRows.get(i)).get("userdefined" + j));
                        dynamicObject.set("userdefineddimid" + j, userDefinedDimIdMap.get(j));
                    }
                    childDimentions.add((Object)dynamicObject);
                }
            } else {
                DynamicObject rowDimention = new DynamicObject(childDimentions.getDynamicObjectType());
                childDimentions.add((Object)rowDimention);
            }
        }
        ArrayList<String> result = new ArrayList<String>(16);
        this.getDtoMembers.addAll(saveIm.getOrgMember());
        DynamicObject group = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)saveIm.getGroupName())) {
            long groupId = DBServiceHelper.genGlobalLongId();
            main.set("group", (Object)groupId);
            group = BusinessDataServiceHelper.newDynamicObject((String)"eb_bgcontrolrulegroup");
            group.set("groupname", (Object)saveIm.getGroupName());
            int groupSeq = this.initGourpseq();
            group.set("groupseq", (Object)groupSeq);
            group.set("id", (Object)groupId);
        }
        if (!(errorList = this.valideBeforeSave(new DynamicObject[]{main})).isEmpty()) {
            errorList = errorList.stream().distinct().collect(Collectors.toList());
            return errorList;
        }
        this.setOrg(main);
        if (group != null) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{group});
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{main});
        mainIdList.add(mainId);
        return result;
    }

    private List<DynamicObject> getNewRows(List<DynamicObject> dataRows, List<List<String>> lists, int index) {
        if (index < lists.size() - 1) {
            int smallSize;
            List<String> userdefinedList = lists.get(index);
            int bigSize = dataRows.size();
            if (CollectionUtils.isNotEmpty(userdefinedList) && (smallSize = userdefinedList.size()) > 0) {
                for (int i = 0; i < bigSize / smallSize; ++i) {
                    for (int j = 0; j < userdefinedList.size(); ++j) {
                        int indexRow = i * smallSize + j;
                        DynamicObject newRow = dataRows.get(indexRow);
                        newRow.set("userdefined" + (index + 1), (Object)userdefinedList.get(j));
                        dataRows.set(indexRow, newRow);
                    }
                }
            }
            this.getNewRows(dataRows, lists, index + 1);
        }
        return dataRows;
    }

    private int initGourpseq() {
        Object bussmodelId = null;
        int maxSeq = 1;
        QFilter qf = new QFilter("model", "=", (Object)this.modelId);
        DynamicObjectCollection mains = QueryServiceHelper.query((String)"eb_bgcontrolrulemain", (String)"id,bussmodel,model,group,controltype,periodclassify,coefficient,isbeyond,isfreetype,effectivedate,invaliddate,illustrate", (QFilter[])new QFilter[]{qf});
        if (mains.size() > 0) {
            ArrayList<Long> groupIds = new ArrayList<Long>(16);
            for (DynamicObject main : mains) {
                groupIds.add(main.getLong("group"));
            }
            QFilter qfGroup = new QFilter("id", "in", groupIds);
            DynamicObjectCollection groups = QueryServiceHelper.query((String)"eb_bgcontrolrulegroup", (String)"id,groupname,groupseq", (QFilter[])new QFilter[]{qfGroup});
            for (DynamicObject doc : groups) {
                if (doc.getInt("groupseq") == 0 || doc.getInt("groupseq") < maxSeq) continue;
                maxSeq = doc.getInt("groupseq") + 1;
            }
        }
        return maxSeq;
    }

    private String getCellValue(Cell cell) {
        String value = "";
        if (cell != null && (CellType.STRING.equals((Object)cell.getCellType()) || CellType.NUMERIC.equals((Object)cell.getCellType()))) {
            if (CellType.NUMERIC.equals((Object)cell.getCellType())) {
                value = cell != null ? NumberToTextConverter.toText((double)cell.getNumericCellValue()).trim() : null;
            } else {
                String Value;
                String string = Value = cell != null ? cell.getStringCellValue() : null;
                if (Value != null) {
                    value = Value.trim();
                }
            }
        }
        return value;
    }

    private void recordErroTip(Row errorRow, String errorString, Workbook errorBook) {
        this.erroFlag = true;
        this.rowErrorFlag = true;
        if (errorRow != null) {
            String cellValue;
            Cell cell = errorRow.getCell(0);
            if (cell == null) {
                cell = errorRow.createCell(0);
                this.setRedFont(errorBook, cell);
            }
            cellValue = this.isEmptyString(cellValue = cell.getStringCellValue()) ? errorString : cellValue + errorString;
            cellValue = BgControlUtils.subCellString((String)cellValue, (int)SpreadsheetVersion.EXCEL2007.getMaxTextLength());
            cell.setCellValue(cellValue);
        }
    }

    private void setRedFont(Workbook errorBook, Cell cell) {
        CellStyle style = errorBook.createCellStyle();
        Font font = errorBook.createFont();
        font.setColor((short)10);
        style.setFont(font);
        cell.setCellStyle(style);
    }

    private boolean isBreak(Row row) {
        return row == null;
    }

    private boolean isEmptyRow(Row row) {
        if (row == null) {
            return true;
        }
        boolean isEmpty = true;
        for (int i = 0; i < 30; ++i) {
            Cell cell = row.getCell(i);
            String cellValue = this.cellValueToString(cell);
            if (!StringUtils.isNotEmpty((String)cellValue)) continue;
            isEmpty = false;
            break;
        }
        return isEmpty;
    }

    private String cellValueToString(Cell cell) {
        if (cell == null) {
            return null;
        }
        String content = null;
        switch (cell.getCellType()) {
            case NUMERIC: {
                Double doubleValue = cell.getNumericCellValue();
                content = doubleValue.toString();
                break;
            }
            case STRING: {
                content = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                Boolean booleanValue = cell.getBooleanCellValue();
                content = booleanValue.toString();
                break;
            }
            case BLANK: {
                break;
            }
            case FORMULA: {
                content = cell.getCellFormula();
                break;
            }
            case ERROR: {
                break;
            }
        }
        return content;
    }

    private void creatErroBookHead(Sheet errorSheet, Sheet firstSheet, int columnNum) {
        for (int i = 0; i < 4; ++i) {
            Row errorxssfRow = errorSheet.createRow(i);
            if (i == 3) {
                errorxssfRow.createCell(0).setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"RuleControlImportPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.copyRow(errorxssfRow, firstSheet.getRow(i), errorSheet, columnNum);
        }
    }

    private void copyRow(Row errorxssfRow, Row row, Sheet errorSheet, int columnNum) {
        for (int i = 0; i < columnNum; ++i) {
            errorSheet.setColumnWidth(i, 5000);
            Cell xssfCell = row.getCell(i);
            Cell newCell = errorxssfRow.createCell(i + 1);
            if (xssfCell == null) {
                newCell.setCellValue("");
                continue;
            }
            this.copyCell(xssfCell, newCell);
        }
    }

    private void copyCell(Cell xssfCell, Cell newCell) {
        if (CellType.STRING.equals((Object)xssfCell.getCellType())) {
            newCell.setCellValue(xssfCell.getStringCellValue());
            if (CellType.NUMERIC.equals((Object)xssfCell.getCellType())) {
                newCell.setCellValue(NumberToTextConverter.toText((double)xssfCell.getNumericCellValue()).trim());
            }
        } else if (DateUtil.isCellDateFormatted((Cell)xssfCell)) {
            Date date = DateUtil.getJavaDate((double)xssfCell.getNumericCellValue());
            newCell.setCellValue(DateTimeUtils.format((Date)date, (String)"yyyy/MM/dd"));
        } else if (CellType.NUMERIC.equals((Object)xssfCell.getCellType())) {
            newCell.setCellValue(NumberToTextConverter.toText((double)xssfCell.getNumericCellValue()).trim());
        }
    }

    private void CheckFormat(Sheet firstSheet) {
        block8: {
            try {
                Row xssfRow1 = firstSheet.getRow(1);
                if (xssfRow1 == null || !RuleControlImportPlugin.getHeadModelNumber().equalsIgnoreCase(xssfRow1.getCell(0).getStringCellValue())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"RuleControlImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                Row xssfRow2 = firstSheet.getRow(2);
                if (xssfRow2 == null || !RuleControlImportPlugin.getHeadBussNumber().equalsIgnoreCase(xssfRow2.getCell(0).getStringCellValue())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"RuleControlImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                Row xssfRow3 = firstSheet.getRow(3);
                if (xssfRow3 != null) {
                    Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
                    Long bussModelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("bussmodel"));
                    boolean bgmdModelFlag = CommonUtils.isBgmdModel((Long)modelId);
                    List<Object> businessModelList = new ArrayList(16);
                    List userDefineDimensionList = new ArrayList(16);
                    if (bgmdModelFlag || ModelUtil.isBGModel((Long)modelId)) {
                        businessModelList = this.getBusinessModelList(modelId, bussModelId);
                    } else {
                        userDefineDimensionList = DimensionServiceHelper.getUserDefineDimensionList((long)modelId, (boolean)true);
                    }
                    List headerList = BgControlRuleUtils.getHeaderList((Long)modelId, (boolean)bgmdModelFlag, businessModelList, userDefineDimensionList);
                    for (int i = 0; i < headerList.size(); ++i) {
                        if (xssfRow3.getCell(i) != null && xssfRow3.getCell(i).getStringCellValue().equals(headerList.get(i))) continue;
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"RuleControlImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    break block8;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u8868\u5934\u884c\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"RuleControlImportPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                log.error((Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"RuleControlImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean isEmptyString(String value) {
        return value == null || value.length() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFile(Workbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
        }
    }

    public void upload(UploadEvent evt) {
        String urles = "";
        List urls = null;
        List fileType = new ArrayList(16);
        urls = this.getPageCache().get("file_url") == null ? new ArrayList(16) : (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("file_url"));
        fileType = this.getPageCache().get("fileType") == null ? new ArrayList(16) : (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("fileType"), List.class);
        for (Object url : evt.getUrls()) {
            Map fileInfo = (Map)url;
            urls.add(fileInfo.get("url"));
            if (fileInfo.get("name") != null && (((String)fileInfo.get("name")).endsWith("xls") || ((String)fileInfo.get("name")).endsWith("XLS"))) {
                fileType.add("xls");
                continue;
            }
            if (fileInfo.get("name") == null || !((String)fileInfo.get("name")).endsWith("xlsx") && !((String)fileInfo.get("name")).endsWith("XLSX")) continue;
            fileType.add("xlsx");
        }
        this.getPageCache().put("file_url", SerializationUtils.serializeToBase64(urls));
        this.getPageCache().put("fileType", SerializationUtils.toJsonString(fileType));
    }

    public void afterRemove(UploadEvent evt) {
        String urles = "";
        List urls = null;
        if (this.getPageCache().get("file_url") != null) {
            urls = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("file_url"));
            for (Object url : evt.getUrls()) {
                urles = (String)((Map)url).get("url");
                if (!urls.contains(urles)) continue;
                urls.remove(urles);
            }
            this.getPageCache().put("file_url", SerializationUtils.serializeToBase64((Object)urls));
        }
    }

    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }

    @Override
    public List<OrgMemberDto> getCheckedOrg() {
        return this.getDtoMembers;
    }

    @Override
    public Long getBussModelId() {
        return this.bussModelId;
    }
}

