/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.SortType;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.central.OrgMemberDto;
import kd.epm.eb.common.dao.rulecontrol.ControlRuleAllotOrgPojo;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.RuleControlTypeEnum;
import kd.epm.eb.common.enums.RulePeriodClassifyEnum;
import kd.epm.eb.common.enums.SingleF7TypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.log.BcmLogFactory;
import kd.epm.eb.common.log.WatchLogger;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.control.utils.BgControlRuleUtils;
import kd.epm.eb.ebBusiness.sql.util.DateTimeUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.control.AllotOrg;
import kd.epm.eb.formplugin.control.ControlModelFuzzySearchCommon;
import kd.epm.eb.formplugin.control.ControlRuleHelper;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class RuleControlListPlugin
extends AbstractFormPlugin
implements ListRowClickListener,
CreateListColumnsListener,
CreateListDataProviderListener,
SetFilterListener,
BasedataFuzzySearchListener,
BeforeF7SelectListener,
AllotOrg,
AfterF7SelectListener {
    private static Log log1 = LogFactory.getLog(RuleControlListPlugin.class);
    private static final String modelCacheKey = "KEY_MODEL_ID";
    private static final String MODEL_KEY = "model";
    private static final String BILLLISTKEY = "billlistap";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BUSSMODEL = "bussmodelf7";
    private static final String IMPORT = "import";
    private static final String EXPORT = "export";
    private static final String USER_DEFINED_DIM_IDS = "userDefinedDimIds";
    private static final String CACHE_BILL_LIST_AP_ROW = "billListApRowMap";
    private static final String GROUP_DIMS = "groupdims";
    private static final String OBO_MEMRANGES = "obomemranges";
    private static final String CACHE_ISF7_BUSSMODEL_CHANGE = "isF7BussModelChange";
    private static final String STR_TRUE = "true";
    private static final List<String> dimKeys = Lists.newArrayList((Object[])new String[]{"account"});
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, RuleControlListPlugin.class);

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(BILLLISTKEY);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addCreateListColumnsListener((CreateListColumnsListener)this);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        billList.addSetFilterListener((SetFilterListener)this);
        billList.addListRowClickListener((ListRowClickListener)this);
        HashMap<String, SingleF7TypeEnum> map = new HashMap<String, SingleF7TypeEnum>(16);
        this.asMapF7toType(dimKeys, SingleF7TypeEnum.COMMON, map);
        this.initSingleMemberF7(map);
        this.addClickListeners(new String[]{"imageup", "imagedown"});
        Search se = (Search)this.getControl("searchap");
        se.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent var1) {
                if (var1.getText() != null && !"".equals(var1.getText())) {
                    RuleControlListPlugin.this.Search(var1.getText().trim());
                } else {
                    RuleControlListPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\uff0c\u6309\u56de\u8f66\u952e\u3002", (String)"RuleControlListPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        });
        this.getView().addCustomControls(new String[]{MODEL_KEY});
    }

    private void initSingleMemberF7(Map<String, SingleF7TypeEnum> map) {
        this.getView().addCustomControls(map.keySet().toArray(new String[0]));
        this.getPageCache().put("dimKeyMap2Type", ObjectSerialUtil.toByteSerialized(map));
    }

    private void asMapF7toType(List<String> dimKeys, SingleF7TypeEnum type, Map<String, SingleF7TypeEnum> map) {
        dimKeys.forEach(k -> map.put((String)k, type));
    }

    @Override
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit model = (BasedataEdit)this.getControl(BUSSMODEL);
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        model.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRow currentClickRow = evt.getCurrentListSelectedRow();
        String value = currentClickRow == null ? null : String.valueOf(currentClickRow.getPrimaryKeyValue());
        this.getPageCache().put("currentClickRowEntryKey", value);
    }

    public void setFilter(SetFilterEvent e) {
        e.getCustomQFilters().add(this.getQfilter());
        if (e.getQFilters() != null && !e.getQFilters().isEmpty()) {
            for (QFilter qFilter : e.getQFilters()) {
                if ("showaccount".equals(qFilter.getProperty())) {
                    qFilter.__setProperty("accounts.account.name");
                } else if ("showorgrange".equals(qFilter.getProperty())) {
                    Set controlrulemainid;
                    List<Map<String, String>> records;
                    QFilter copyfilter;
                    QFilter modelQflter;
                    if (qFilter.getValue() != null && "not like".equals(qFilter.getCP())) {
                        modelQflter = new QFilter("controlrulemainid.model.id", "=", (Object)this.getModelId());
                        copyfilter = new QFilter(qFilter.getProperty(), "like", qFilter.getValue());
                        copyfilter.__setProperty("allotedorg.name");
                        copyfilter.or("property.name", "like", copyfilter.getValue());
                        modelQflter.and(copyfilter);
                        records = ControlRuleHelper.getAllotorgList(new QFilter[]{modelQflter});
                        controlrulemainid = records.stream().map(k -> IDUtils.toLong(k.get("controlrulemainid"))).collect(Collectors.toSet());
                        qFilter.__setProperty("id");
                        qFilter.__setCP("not in");
                        qFilter.__setValue((Object)controlrulemainid.toArray());
                        qFilter.clearNests();
                    } else if (qFilter.getValue() != null && !qFilter.getValue().toString().contains("EMPTY")) {
                        modelQflter = new QFilter("controlrulemainid.model.id", "=", (Object)this.getModelId());
                        copyfilter = new QFilter(qFilter.getProperty(), qFilter.getCP(), qFilter.getValue());
                        copyfilter.__setProperty("allotedorg.name");
                        if ("!=".equals(copyfilter.getCP()) || "not like".equals(copyfilter.getCP())) {
                            copyfilter.and("property.name", copyfilter.getCP(), copyfilter.getValue());
                        } else {
                            copyfilter.or("property.name", copyfilter.getCP(), copyfilter.getValue());
                        }
                        modelQflter.and(copyfilter);
                        records = ControlRuleHelper.getAllotorgList(new QFilter[]{modelQflter});
                        controlrulemainid = records.stream().map(k -> IDUtils.toLong(k.get("controlrulemainid"))).collect(Collectors.toSet());
                        qFilter.__setProperty("id");
                        qFilter.__setCP("in");
                        qFilter.__setValue((Object)controlrulemainid.toArray());
                    }
                }
                List nests = qFilter.getNests(true);
                for (QFilter.QFilterNest nest : nests) {
                    QFilter filter = nest.getFilter();
                    if ("showaccount".equals(filter.getProperty())) {
                        filter.__setProperty("accounts.account.name");
                        continue;
                    }
                    if (!"showorgrange".equals(filter.getProperty())) continue;
                    QFilter modelQflter = new QFilter("controlrulemainid.model.id", "=", (Object)this.getModelId());
                    QFilter copyfilter = new QFilter(filter.getProperty(), filter.getCP(), filter.getValue());
                    copyfilter.__setProperty("allotedorg.name");
                    copyfilter.or("property.name", copyfilter.getCP(), copyfilter.getValue());
                    modelQflter.and(copyfilter);
                    List<Map<String, String>> records = ControlRuleHelper.getAllotorgList(new QFilter[]{modelQflter});
                    Set controlrulemainid = records.stream().map(k -> IDUtils.toLong(k.get("controlrulemainid"))).collect(Collectors.toSet());
                    filter.__setProperty("id");
                    filter.__setCP("in");
                    filter.__setValue((Object)controlrulemainid.toArray());
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = UserSelectUtils.getUserSelectModelId((IFormView)this.getView());
        if (!IDUtils.isNotNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"RuleControlListPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(MODEL_KEY, (Object)modelId);
        this.getPageCache().put(modelCacheKey, modelId.toString());
        this.getModel().setValue(BUSSMODEL, (Object)this.getBussModelId());
        this.setDTAndATVisible();
        ((ListColumn)this.getView().getControl("bussmodel")).setVisible(0);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (MODEL_KEY.equals(name)) {
            DynamicObject model = this.getSelModel();
            if (model != null) {
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)model.getLong("id"));
                this.getPageCache().put(modelCacheKey, model.getString("id"));
            }
            this.getPageCache().remove("distributemap");
            this.getModel().setValue(BUSSMODEL, null);
            this.getModel().setValue(BUSSMODEL, (Object)this.getBussModelId());
            this.dealModelChanged4Bg(e);
            this.reflushBillList();
        } else if (BUSSMODEL.equals(name) && STR_TRUE.equals(this.getPageCache().get(CACHE_ISF7_BUSSMODEL_CHANGE))) {
            this.reflushBillList();
            this.getPageCache().remove(CACHE_ISF7_BUSSMODEL_CHANGE);
        }
    }

    public DynamicObject getSelModel() {
        Object obj = this.getModel().getValue(MODEL_KEY);
        if (obj instanceof DynamicObject) {
            return (DynamicObject)obj;
        }
        return null;
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        if (evt.getSource() instanceof Control) {
            this.checkPermission(this.getView(), ((Control)evt.getSource()).getKey());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("imageup".equals(key) || "imagedown".equals(key)) {
            String[] btn = new String[]{"imageup", "imagedown"};
            BillList billList = (BillList)this.getControl(BILLLISTKEY);
            this.getUpOrDown(btn, key, billList);
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        this.checkPermission(this.getView(), evt.getItemKey());
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "barsave": {
                break;
            }
            case "baradd": {
                this.showRuleAddForm();
                break;
            }
            case "add_group": {
                this.showAddGroupRuleForm();
                break;
            }
            case "bardelete": {
                this.showDeleteConfim();
                break;
            }
            case "bardefault": {
                this.bardefault();
                break;
            }
            case "barallot": {
                this.showOrgAllotForm();
                break;
            }
            case "baredit": {
                this.showRuleEditForm();
                break;
            }
            case "barshowall": {
                break;
            }
            case "barexit": {
                this.getView().close();
                break;
            }
            case "setwhite": {
                this.openpage();
                break;
            }
            case "btn_refresh": {
                this.reFreshBillList();
                break;
            }
            case "import": {
                this.openImportPage();
                break;
            }
            case "export": {
                this.export();
                break;
            }
            case "upgradeshowcolums": {
                this.upgradeShowColums();
                break;
            }
        }
    }

    private void openImportPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_rulecontrolimport");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam(MODEL_KEY, (Object)String.valueOf(this.getModelId()));
        showParameter.setCustomParam("bussmodel", (Object)String.valueOf(this.getBussModelId()));
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "importPage");
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    public boolean isLimit(Long id) {
        ApplicationTypeEnum application = ModelUtil.queryApp((IFormView)this.getView());
        application = ApplicationTypeEnum.EB;
        Set permIdSet = MemberPermHelper.getLimitedModelListByUser((ApplicationTypeEnum)application);
        Set haspermids = FunPermissionHelper.getEffectiveByPermModel((String)this.getView().getEntityId(), (ApplicationTypeEnum)application);
        Set perRoleids = FunPermissionHelper.getRoleModel((Long)UserUtils.getUserId(), (String)"epm_model", (ApplicationTypeEnum)application, (String)this.getView().getEntityId(), (String)"47150e89000000ac");
        permIdSet.addAll(haspermids);
        permIdSet.addAll(perRoleids);
        return permIdSet.contains(id);
    }

    private void export() {
        Long modelId = this.getModelId();
        Long bussModelId = this.getBussModelId();
        boolean bgmdModelFlag = CommonUtils.isBgmdModel((Long)modelId);
        if (!(bgmdModelFlag || ModelUtil.isBGModel((Long)modelId) || this.isLimit(modelId))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u64cd\u4f5c\u4f53\u7cfb\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"RuleControlListPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        BillList billlist = (BillList)this.getControl(BILLLISTKEY);
        ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
        Map<Object, DynamicObject> ruleObjectMap = new HashMap(16);
        if (selectedRows.size() > 0) {
            ArrayList<Object> pkIds = new ArrayList<Object>(selectedRows.size());
            for (ListSelectedRow listSelectedRow : selectedRows) {
                Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
                pkIds.add(primaryKeyValue);
            }
            QFilter qFilter = new QFilter("id", "in", pkIds);
            ruleObjectMap = BusinessDataServiceHelper.loadFromCache((String)"eb_bgcontrolrulemain", (QFilter[])new QFilter[]{qFilter});
        } else {
            QFilter qFilter = new QFilter("bussmodel", "=", (Object)bussModelId);
            QFilter qFilter1 = new QFilter(MODEL_KEY, "=", (Object)modelId);
            ruleObjectMap = BusinessDataServiceHelper.loadFromCache((String)"eb_bgcontrolrulemain", (QFilter[])new QFilter[]{qFilter, qFilter1});
        }
        if (ruleObjectMap.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"RuleControlListPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (ruleObjectMap.size() == 1) {
            Set<Object> accountSet = new HashSet<Object>(16);
            for (Map.Entry entry : ruleObjectMap.entrySet()) {
                accountSet = ((DynamicObject)entry.getValue()).getDynamicObjectCollection("accounts").stream().map(e -> e.getDynamicObject("account")).collect(Collectors.toSet());
            }
            accountSet.removeIf(Objects::isNull);
            if (CollectionUtils.isEmpty(accountSet)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"RuleControlListPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        String url = this.handleExportData(ruleObjectMap, bgmdModelFlag);
        if (kd.bos.util.StringUtils.isNotEmpty((String)url)) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5bfc\u51fa", "RuleControlListPlugin_88", "epm-eb-formplugin");
        MultiLangEnumBridge multiLangEnumBridge = new MultiLangEnumBridge("\u5bfc\u51fa\u6210\u529f", "RuleControlListPlugin_42", "epm-eb-formplugin");
        OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)EXPORT, (String)EXPORT, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)multiLangEnumBridge, null);
    }

    private String handleExportData(Map<Object, DynamicObject> ruleObjectMap, boolean bgmdModelFlag) {
        if (ruleObjectMap != null && !ruleObjectMap.isEmpty()) {
            Long modelId = this.getModelId();
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            Long bussModelId = this.getBussModelId();
            XSSFWorkbook workBook = BgControlRuleUtils.createWorkBook((Long)modelId, (Long)bussModelId);
            CellStyle textCellStyle = POIUtils.get().getTextCellStyle((Workbook)workBook);
            XSSFSheet xssfSheet = workBook.getSheetAt(0);
            int i = 0;
            try {
                for (Map.Entry<Object, DynamicObject> entry : ruleObjectMap.entrySet()) {
                    int i1;
                    ArrayList<String> row = new ArrayList<String>(16);
                    DynamicObject ruleControl = entry.getValue();
                    boolean isGroup = false;
                    int descartes = 1;
                    if (ruleControl.getDynamicObject("group") != null) {
                        row.add(ruleControl.getDynamicObject("group").getString("groupname"));
                        isGroup = true;
                    } else {
                        row.add("");
                    }
                    DynamicObjectCollection accounts = ruleControl.getDynamicObjectCollection("accounts");
                    if (accounts.isEmpty()) continue;
                    DynamicObjectCollection groupDims = ruleControl.getDynamicObjectCollection(GROUP_DIMS);
                    if (isGroup) {
                        Set groupDimSet = groupDims.stream().filter(e -> !e.getBoolean("isobodim") && e.getDynamicObject("groupdim") != null).map(e -> e.getDynamicObject("groupdim").getString("name") + "#" + e.getDynamicObject("groupdim").getString("number")).collect(Collectors.toSet());
                        if (CollectionUtils.isNotEmpty(groupDimSet)) {
                            String groupDimStr = String.join((CharSequence)",", groupDimSet);
                            if (StringUtils.isNotEmpty((String)groupDimStr)) {
                                row.add(groupDimStr);
                            } else {
                                row.add("");
                            }
                        } else {
                            row.add("");
                        }
                        Set oboDimSet = groupDims.stream().filter(e -> e.getBoolean("isobodim") && e.getDynamicObject("groupdim") != null).map(e -> e.getDynamicObject("groupdim").getString("name") + "#" + e.getDynamicObject("groupdim").getString("number")).collect(Collectors.toSet());
                        if (CollectionUtils.isNotEmpty(oboDimSet)) {
                            String oboDimStr = String.join((CharSequence)",", oboDimSet);
                            if (StringUtils.isNotEmpty((String)oboDimStr)) {
                                row.add(oboDimStr);
                            } else {
                                row.add("");
                            }
                        } else {
                            row.add("");
                        }
                    } else {
                        row.add("");
                        row.add("");
                    }
                    Set accountNumberSet = accounts.stream().map(e -> e.getDynamicObject("account").getString("number")).collect(Collectors.toSet());
                    if (CollectionUtils.isNotEmpty(accountNumberSet)) {
                        List members = modelCacheHelper.getMembers(SysDimensionEnum.Account.getNumber(), null, accountNumberSet);
                        List memberNames = members.stream().map(Member::getName).collect(Collectors.toList());
                        String accountNameStr = String.join((CharSequence)",", memberNames);
                        if (StringUtils.isNotEmpty((String)accountNameStr)) {
                            row.add(accountNameStr);
                        } else {
                            row.add("");
                        }
                    } else {
                        row.add("");
                    }
                    if (CollectionUtils.isNotEmpty(accountNumberSet)) {
                        String accountNumberStr;
                        if (isGroup) {
                            descartes *= accountNumberSet.size();
                        }
                        if (StringUtils.isNotEmpty((String)(accountNumberStr = String.join((CharSequence)",", accountNumberSet)))) {
                            row.add(accountNumberStr);
                        } else {
                            row.add("");
                        }
                    } else {
                        row.add("");
                    }
                    int userDefinedDimNum = 0;
                    HashMap<Integer, Long> userDefinedDimIdIndexMap = new HashMap<Integer, Long>(16);
                    if (bgmdModelFlag || ModelUtil.isBGModel((Long)modelId)) {
                        List businessModelList = BgControlRuleUtils.getBusinessModelList((Long)modelId, (Long)bussModelId);
                        userDefinedDimNum = businessModelList.size();
                        for (i1 = 0; i1 < businessModelList.size(); ++i1) {
                            userDefinedDimIdIndexMap.put(i1, ((Dimension)businessModelList.get(i1)).getId());
                        }
                    } else {
                        List userDefineDimensionList = DimensionServiceHelper.getUserDefineDimensionList((long)modelId, (boolean)true);
                        userDefinedDimNum = userDefineDimensionList.size();
                        for (i1 = 0; i1 < userDefineDimensionList.size(); ++i1) {
                            userDefinedDimIdIndexMap.put(i1, ((DynamicObject)userDefineDimensionList.get(i1)).getLong("id"));
                        }
                    }
                    List oboDims = groupDims.stream().filter(e -> e.getBoolean("isobodim") && e.getDynamicObject("groupdim") != null).map(e -> e.getDynamicObject("groupdim").getLong("id")).collect(Collectors.toList());
                    DynamicObjectCollection oboMemRanges = ruleControl.getDynamicObjectCollection(OBO_MEMRANGES);
                    Map<Long, List<DynamicObject>> grpOboMemberRangeMap = oboMemRanges.stream().filter(e -> e.getDynamicObject("obodim") != null).collect(Collectors.groupingBy(k -> k.getDynamicObject("obodim").getLong("id")));
                    DynamicObjectCollection dimentions = ruleControl.getDynamicObjectCollection("dimentions");
                    for (int j = 0; j < userDefinedDimNum; ++j) {
                        Long dimId = (Long)userDefinedDimIdIndexMap.get(j);
                        if (isGroup && IDUtils.isNotEmptyLong((Long)dimId).booleanValue() && oboDims.contains(dimId) && CollectionUtils.isNotEmpty((Collection)grpOboMemberRangeMap.get(dimId))) {
                            List<DynamicObject> oboMembers = grpOboMemberRangeMap.get(dimId);
                            Set oboMemberNameSet = oboMembers.stream().filter(e -> e.getDynamicObject("obomember") != null).map(e -> e.getDynamicObject("obomember").getString("name") + "#" + RangeEnum.getRangeByVal((int)Integer.parseInt(e.getString("memrange"))).getName()).collect(Collectors.toSet());
                            if (CollectionUtils.isNotEmpty(oboMemberNameSet)) {
                                String oboDimNameStr = String.join((CharSequence)",", oboMemberNameSet);
                                if (StringUtils.isNotEmpty((String)oboDimNameStr)) {
                                    row.add(oboDimNameStr);
                                } else {
                                    row.add("");
                                }
                            } else {
                                row.add("");
                            }
                            Set oboMemberNumberSet = oboMembers.stream().filter(e -> e.getDynamicObject("obomember") != null).map(e -> e.getDynamicObject("obomember").getString("number") + "#" + RangeEnum.getRangeByVal((int)Integer.parseInt(e.getString("memrange"))).getValue()).collect(Collectors.toSet());
                            if (CollectionUtils.isNotEmpty(oboMemberNumberSet)) {
                                String oboDimNumberStr = String.join((CharSequence)",", oboMemberNumberSet);
                                if (StringUtils.isNotEmpty((String)oboDimNumberStr)) {
                                    row.add(oboDimNumberStr);
                                    continue;
                                }
                                row.add("");
                                continue;
                            }
                            row.add("");
                            continue;
                        }
                        int num = j + 1;
                        Set userDefinedNumberSet = dimentions.stream().filter(e -> e.getDynamicObject("userdefined" + num) != null).map(e -> e.getDynamicObject("userdefined" + num)).collect(Collectors.toSet());
                        if (CollectionUtils.isNotEmpty(userDefinedNumberSet)) {
                            List memberNames = userDefinedNumberSet.stream().map(k -> k.getString("name")).collect(Collectors.toList());
                            String userDefinedNameStr = String.join((CharSequence)",", memberNames);
                            if (StringUtils.isNotEmpty((String)userDefinedNameStr)) {
                                row.add(userDefinedNameStr);
                            } else {
                                row.add("");
                            }
                        } else {
                            row.add("");
                        }
                        if (CollectionUtils.isNotEmpty(userDefinedNumberSet)) {
                            String userDefinedNumberStr;
                            if (isGroup) {
                                descartes *= userDefinedNumberSet.size();
                            }
                            if (StringUtils.isNotEmpty((String)(userDefinedNumberStr = userDefinedNumberSet.stream().map(k -> k.getString("number")).collect(Collectors.joining(","))))) {
                                row.add(userDefinedNumberStr);
                                continue;
                            }
                            row.add("");
                            continue;
                        }
                        row.add("");
                    }
                    String periodclassifyIndex = ruleControl.getString("periodclassify");
                    RulePeriodClassifyEnum rulePeriodClassifyEnum = RulePeriodClassifyEnum.valueOfIndex((String)periodclassifyIndex);
                    if (rulePeriodClassifyEnum != null) {
                        row.add(rulePeriodClassifyEnum.getName());
                    } else {
                        row.add("");
                    }
                    String controltypeIndex = ruleControl.getString("controltype");
                    RuleControlTypeEnum ruleControlTypeEnum = RuleControlTypeEnum.valueOfIndex((String)controltypeIndex);
                    if (ruleControlTypeEnum != null) {
                        row.add(ruleControlTypeEnum.getName());
                    } else {
                        row.add("");
                    }
                    BigDecimal coefficient = ruleControl.getBigDecimal("coefficient");
                    coefficient = coefficient.setScale(2, RoundingMode.HALF_UP);
                    row.add(coefficient.toString());
                    if (ruleControl.getBoolean("isbeyond")) {
                        row.add(ResManager.loadKDString((String)"\u662f", (String)"RuleControlListPlugin_60", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    } else {
                        row.add(ResManager.loadKDString((String)"\u5426", (String)"RuleControlListPlugin_59", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    long mainid = ruleControl.getLong("id");
                    List<OrgMemberDto> orgMembers = ControlRuleHelper.getOrgList(new QFilter[]{new QFilter("controlrulemainid", "=", (Object)mainid)});
                    row.add(orgMembers.stream().filter(k -> !"property".equals(k.getType())).map(OrgMemberDto::getNumber).collect(Collectors.joining(",")));
                    row.add(orgMembers.stream().filter(k -> !"property".equals(k.getType())).map(OrgMemberDto::getName).collect(Collectors.joining(",")));
                    row.add(orgMembers.stream().filter(k -> "property".equals(k.getType())).map(OrgMemberDto::getNumber).collect(Collectors.joining(",")));
                    row.add(orgMembers.stream().filter(k -> "property".equals(k.getType())).map(OrgMemberDto::getName).collect(Collectors.joining(",")));
                    if (isGroup) {
                        if (dimentions.size() > 0 && dimentions.size() != descartes) {
                            ArrayList<String> groupByGroupNameList = new ArrayList<String>(16);
                            ArrayList<String> groupByGroupNumberList = new ArrayList<String>(16);
                            for (DynamicObject dimention : dimentions) {
                                ArrayList<String> groupDimNameList = new ArrayList<String>(16);
                                ArrayList<String> groupDimNumberList = new ArrayList<String>(16);
                                if (dimention.getDynamicObject("groupaccount") == null) break;
                                groupDimNameList.add(dimention.getDynamicObject("groupaccount").getString("name"));
                                groupDimNumberList.add(dimention.getDynamicObject("groupaccount").getString("number"));
                                for (int i12 = 0; i12 < userDefinedDimNum; ++i12) {
                                    int j1 = i12 + 1;
                                    if (dimention.getDynamicObject("userdefined" + j1) == null) continue;
                                    groupDimNameList.add(dimention.getDynamicObject("userdefined" + j1).getString("name"));
                                    groupDimNumberList.add(dimention.getDynamicObject("userdefined" + j1).getString("number"));
                                }
                                groupByGroupNameList.add(String.join((CharSequence)"#", groupDimNameList));
                                groupByGroupNumberList.add(String.join((CharSequence)"#", groupDimNumberList));
                            }
                            if (CollectionUtils.isNotEmpty(groupByGroupNameList)) {
                                String groupByGroupNameStr = String.join((CharSequence)",", groupByGroupNameList);
                                if (StringUtils.isNotEmpty((String)groupByGroupNameStr)) {
                                    row.add(groupByGroupNameStr);
                                } else {
                                    row.add("");
                                }
                            } else {
                                row.add("");
                            }
                            if (CollectionUtils.isNotEmpty(groupByGroupNumberList)) {
                                String groupByGroupNumberStr = String.join((CharSequence)",", groupByGroupNumberList);
                                if (StringUtils.isNotEmpty((String)groupByGroupNumberStr)) {
                                    row.add(groupByGroupNumberStr);
                                } else {
                                    row.add("");
                                }
                            } else {
                                row.add("");
                            }
                        } else {
                            row.add("");
                            row.add("");
                        }
                    } else {
                        row.add("");
                        row.add("");
                    }
                    if (StringUtils.isNotEmpty((String)ruleControl.getString("illustrate"))) {
                        row.add(ruleControl.getString("illustrate"));
                    } else {
                        row.add("");
                    }
                    int illustrateColumn = row.size() - 1;
                    Date effectiveDate = ruleControl.getDate("effectivedate");
                    if (effectiveDate != null) {
                        String effectiveDateStr = DateTimeUtils.format((Date)effectiveDate, (String)"yyyy/MM/dd");
                        row.add(effectiveDateStr);
                    } else {
                        row.add("");
                    }
                    Date invalidDate = ruleControl.getDate("invaliddate");
                    if (invalidDate != null) {
                        String invalidDateStr = DateTimeUtils.format((Date)invalidDate, (String)"yyyy/MM/dd");
                        row.add(invalidDateStr);
                    } else {
                        row.add("");
                    }
                    XSSFRow xssfRow = xssfSheet.createRow(4 + i);
                    for (int j = 0; j < row.size(); ++j) {
                        XSSFCell cell = xssfRow.createCell(j);
                        if (j == 0 || j == illustrateColumn) {
                            cell.setCellStyle(textCellStyle);
                        }
                        cell.setCellValue((String)row.get(j));
                    }
                    ++i;
                }
            }
            catch (IllegalArgumentException e2) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u7684\u6570\u636e\u5b57\u7b26\u957f\u5ea6\u8fc7\u957f", (String)"RuleControlListPlugin_61", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            try {
                return ImportAndExportUtil.writeFile((Workbook)workBook, (String)ResManager.loadKDString((String)"\u63a7\u5236\u65b9\u5f0f\u8bbe\u7f6e-\u5bfc\u51fa\u6570\u636e", (String)"RuleControlListPlugin_44", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            catch (IOException ex) {
                throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
            }
        }
        return null;
    }

    private void openpage() {
        ListShowParameter formShowParameter = new ListShowParameter();
        formShowParameter.setBillFormId("eb_whitelist");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u79d1\u76ee\u767d\u540d\u5355\u8bbe\u7f6e\u5217\u8868", (String)"RuleControlListPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        IFormView childFormView = this.getView().getView(formShowParameter.getPageId());
        formShowParameter.setPageId(formShowParameter.getFormId() + "_" + this.getView().getPageId());
        if (childFormView != null) {
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        } else {
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u767d\u540d\u5355\u8bbe\u7f6e", "RuleControlListPlugin_76", "epm-eb-formplugin");
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u767d\u540d\u5355\u8bbe\u7f6e\u6210\u529f\u3002", "RuleControlListPlugin_77", "epm-eb-formplugin");
        OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)"setwhite", (String)"setwhite", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, null);
    }

    private void reFreshBillList() {
        BillList billList = (BillList)this.getControl(BILLLISTKEY);
        billList.clearSelection();
        billList.refresh();
    }

    @Override
    public Long getModelId() {
        DynamicObject model = this.getSelModel();
        if (model != null) {
            return model.getLong("id");
        }
        return 0L;
    }

    @Override
    public boolean isCheckModel() {
        return true;
    }

    public Long getUserId() {
        return super.getUserId();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (MODEL_KEY.equals(key)) {
            PluginUtils.setModelFilter(e, this.getView());
        } else if (BUSSMODEL.equals(key)) {
            this.getPageCache().put(CACHE_ISF7_BUSSMODEL_CHANGE, STR_TRUE);
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(BUSSMODEL)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>(16);
            }
            qFilterList.add(new QFilter(MODEL_KEY, "=", (Object)this.getModelId()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    private void showDeleteConfim() {
        ListSelectedRowCollection selectedRow = ((BillList)this.getControl(BILLLISTKEY)).getSelectedRows();
        if (selectedRow == null || selectedRow.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u884c", (String)"RuleControlListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u5c06\u5220\u9664\u9009\u4e2d\u7684\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"RuleControlListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleterow", (IFormPlugin)this));
        }
    }

    private void showRuleEditForm() {
        BillList bill = (BillList)this.getControl(BILLLISTKEY);
        ListSelectedRowCollection rows = bill.getSelectedRows();
        if (rows.size() != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8bb0\u5f55\u8fdb\u884c\u4fee\u6539\u3002", (String)"RuleControlListPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (rows == null || rows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u884c", (String)"RuleControlListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            HashMap<String, String> params;
            FormShowParameter formShowParameter;
            QFilter mainid = new QFilter("id", "=", (Object)IDUtils.toLong((Object)rows.get(0).getPrimaryKeyValue()));
            DynamicObject obj = QueryServiceHelper.queryOne((String)"eb_bgcontrolrulemain", (String)"id,group.id", (QFilter[])new QFilter[]{mainid});
            if (obj.getLong("group.id") > 0L) {
                formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("eb_controlrulegroupaddnew");
                params = new HashMap<String, String>(16);
                DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL_KEY);
                String modelCode = model.getString("showNumber");
                params.put(MODEL_KEY, String.valueOf(this.getModelId()));
                params.put("bussmodel", String.valueOf(this.getBussModelId()));
                params.put(modelCacheKey, String.valueOf(this.getModelId()));
                params.put("modelCode", modelCode);
                params.put("pkid", String.valueOf(rows.get(0).getPrimaryKeyValue()));
                params.put("pageState", "editGroup");
                params.put(USER_DEFINED_DIM_IDS, this.getPageCache().get(USER_DEFINED_DIM_IDS));
                formShowParameter.setCustomParams(params);
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u63a7\u5236\u65b9\u5f0f\u5206\u7ec4\u4fee\u6539", (String)"RuleControlListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addGroupRule"));
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(formShowParameter);
            } else {
                formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("eb_addbgcontrolrule");
                params = new HashMap(16);
                long modelId = this.getModelId();
                params.put(MODEL_KEY, String.valueOf(modelId));
                params.put("pkid", String.valueOf(rows.get(0).getPrimaryKeyValue()));
                params.put("pageState", "edit");
                params.put(USER_DEFINED_DIM_IDS, this.getPageCache().get(USER_DEFINED_DIM_IDS));
                formShowParameter.setCustomParams(params);
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u63a7\u5236\u65b9\u5f0f\u4fee\u6539", (String)"RuleControlListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "addrule");
                formShowParameter.setCloseCallBack(closeCallBack);
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(formShowParameter);
            }
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fee\u6539", "RuleControlListPlugin_86", "epm-eb-formplugin");
            MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u4fee\u6539\u6210\u529f", "RuleControlListPlugin_16", "epm-eb-formplugin");
            OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)"baredit", (String)"baredit", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, null);
        }
    }

    private void showOrgAllotForm() {
        IModelCacheHelper modelCache;
        Dimension account;
        Long accountId;
        BillList billList = (BillList)this.getControl(BILLLISTKEY);
        List<Object> allotedOrgIds = new ArrayList(16);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u884c", (String)"RuleControlListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> selectedIds = new ArrayList<Long>(16);
        for (ListSelectedRow row : selectedRows) {
            selectedIds.add((Long)row.getPrimaryKeyValue());
        }
        this.getPageCache().put("oldAllotedOrgIds", null);
        if (selectedRows.size() == 1) {
            Long mainid = (Long)selectedRows.get(0).getPrimaryKeyValue();
            QFilter qEntryId = new QFilter("controlrulemainid", "=", (Object)mainid);
            List<OrgMemberDto> orgRange = ControlRuleHelper.getOrgList(new QFilter[]{qEntryId});
            this.getPageCache().put("checkedOrgs", ObjectSerialUtil.toByteSerialized(orgRange));
            allotedOrgIds = orgRange.stream().map(allotOrg -> String.valueOf(allotOrg.getId())).collect(Collectors.toList());
            this.getPageCache().put("oldAllotedOrgIds", ObjectSerialUtil.toByteSerialized(allotedOrgIds));
        }
        Map<Integer, Long> controlDimMap = ControlRuleHelper.getControlDimMap(this.getModelId(), this.getBussModelId());
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"eb_bgcontrolrulemain");
        DynamicObject[] mainObjs = (DynamicObject[])BusinessDataServiceHelper.load((Object[])selectedIds.toArray(), (IDataEntityType)dy.getDataEntityType());
        List<ControlRuleAllotOrgPojo> rules = ControlRuleHelper.getControlRuleAllotOrgPojos(mainObjs, controlDimMap, accountId = (account = (modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId())).getDimension(SysDimensionEnum.Account.getNumber())).getId(), modelCache, this.getBussModelId());
        Set<Long> repeats = this.checkSameMemberCompose(rules, accountId);
        if (!repeats.isEmpty()) {
            String tip = repeats.stream().filter(k -> modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, k) != null).map(k -> modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, k).getName()).collect(Collectors.joining(","));
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5206\u914d\u7ec4\u7ec7\u7684\u63a7\u5236\u65b9\u5f0f\u4e2d\u5305\u542b\u76f8\u540c\u79d1\u76ee\u548c\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u7684\u6210\u5458\u7ec4\u5408\uff0c\u4e0d\u5141\u8bb8\u5206\u914d\u76f8\u540c\u7ec4\u7ec7\u3002\u79d1\u76ee\uff1a%1", (String)"", (String)"", (Object[])new Object[]{tip}));
            return;
        }
        this.getPageCache().put("selectedEntryRowIds", ObjectSerialUtil.toByteSerialized((Object)IDUtils.toStrings(selectedIds)));
        this.showOrgAllotForm(this);
    }

    private Set<Long> checkSameMemberCompose(List<ControlRuleAllotOrgPojo> rules, Long accountId) {
        Map<Integer, Long> controlDimMap = ControlRuleHelper.getControlDimMap(this.getModelId(), this.getBussModelId());
        int length = rules.size();
        HashSet<Long> repeatAccounts = new HashSet<Long>();
        for (int i = 0; i < length; ++i) {
            ControlRuleAllotOrgPojo rule1 = rules.get(i);
            for (int j = i + 1; j < length; ++j) {
                Set oldAccountMemberIndexSet;
                Set accountMemberIndexSet;
                ControlRuleAllotOrgPojo rule2 = rules.get(j);
                Map ruleDimMembersIndexMap = rule1.getOblIndex();
                Map oldRuleDimMembersIndexMap = rule2.getOblIndex();
                Map accountMembersIndexMap = (Map)ruleDimMembersIndexMap.get(accountId);
                Map oldAccountMembersIndexMap = (Map)oldRuleDimMembersIndexMap.get(accountId);
                Long maxCountControlDimId = rule1.getMaxCountNoOblDimId();
                if (rule2.getMaxNoOblDimCount().compareTo(rule1.getMaxNoOblDimCount()) > 0) {
                    maxCountControlDimId = rule2.getMaxCountNoOblDimId();
                }
                Map maxUserDefineMembersIndexMap = (Map)ruleDimMembersIndexMap.get(maxCountControlDimId);
                Map oldMaxUserDefineMembersIndexMap = (Map)oldRuleDimMembersIndexMap.get(maxCountControlDimId);
                ArrayList retainRuleMembers = new ArrayList(16);
                ArrayList oldRetainRuleMembers = new ArrayList(16);
                HashSet accountIndexSet = new HashSet(16);
                HashSet oldAccountIndexSet = new HashSet(16);
                Set accountIds = accountMembersIndexMap == null ? (Set)rule1.getNoOblMembers().get(accountId) : accountMembersIndexMap.keySet();
                Set oldAccountIds = oldAccountMembersIndexMap == null ? (Set)rule2.getNoOblMembers().get(accountId) : oldAccountMembersIndexMap.keySet();
                boolean hasOver = false;
                if (accountIds.size() < oldAccountIds.size()) {
                    for (Long accountMemberId : accountIds) {
                        accountMemberIndexSet = this.getMemberIndexSet(accountMembersIndexMap, accountMemberId);
                        oldAccountMemberIndexSet = this.getMemberIndexSet(oldAccountMembersIndexMap, accountMemberId);
                        if (oldAccountIds.contains(accountMemberId) && rule1.getUserDefineDimCompose().equals(rule2.getUserDefineDimCompose())) {
                            hasOver = this.checkControlRuleSameMembers(controlDimMap, maxCountControlDimId, maxUserDefineMembersIndexMap, oldMaxUserDefineMembersIndexMap, rule1, rule2, retainRuleMembers, oldRetainRuleMembers, accountIndexSet, oldAccountIndexSet, accountMemberIndexSet, oldAccountMemberIndexSet);
                        }
                        if (!hasOver) continue;
                        repeatAccounts.add(accountMemberId);
                    }
                    continue;
                }
                for (Long accountMemberId : oldAccountIds) {
                    accountMemberIndexSet = this.getMemberIndexSet(accountMembersIndexMap, accountMemberId);
                    oldAccountMemberIndexSet = this.getMemberIndexSet(oldAccountMembersIndexMap, accountMemberId);
                    if (accountIds.contains(accountMemberId) && rule1.getUserDefineDimCompose().equals(rule2.getUserDefineDimCompose())) {
                        hasOver = this.checkControlRuleSameMembers(controlDimMap, maxCountControlDimId, maxUserDefineMembersIndexMap, oldMaxUserDefineMembersIndexMap, rule1, rule2, retainRuleMembers, oldRetainRuleMembers, accountIndexSet, oldAccountIndexSet, accountMemberIndexSet, oldAccountMemberIndexSet);
                    }
                    if (!hasOver) continue;
                    repeatAccounts.add(accountMemberId);
                }
            }
        }
        return repeatAccounts;
    }

    private void bardefault() {
        Long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"RuleControlListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qModel = new QFilter(MODEL_KEY, "=", (Object)modelId);
        QFilter qDefault = new QFilter("isdefault", "=", (Object)Character.valueOf('1'));
        DynamicObject dy = QueryServiceHelper.queryOne((String)"eb_bgcontrolrulemain", (String)"id", (QFilter[])new QFilter[]{qModel, qDefault});
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_adddefaultrule");
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put(MODEL_KEY, String.valueOf(modelId));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7f3a\u7701\u63a7\u5236\u65b9\u5f0f", (String)"RuleControlListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "setDefault");
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (dy != null) {
            String pkid = dy.getString("id");
            if (pkid.equals("0")) {
                int num = DeleteServiceHelper.delete((String)"eb_bgcontrolrulemain", (QFilter[])new QFilter[]{qModel, qDefault});
                MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5220\u9664", "RuleControlListPlugin_9", "epm-eb-formplugin");
                MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u5220\u9664%1$s\u5f20\u5355\u636e\u6210\u529f\u3002", "RuleControlListPlugin_10", "epm-eb-formplugin");
                OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)"bardefault", (String)"bardefault", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{String.valueOf(num)});
                if (num != 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e7\u7f3a\u7701\u8bbe\u7f6e\u6570\u636e\u8bfb\u53d6\u51fa\u9519\u3002", (String)"RuleControlListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                params.put("pageState", "new");
            } else {
                params.put("pkid", pkid);
                params.put("pageState", "edit");
            }
        } else {
            params.put("pageState", "new");
        }
        formShowParameter.setCustomParams(params);
        this.getView().showForm(formShowParameter);
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u7f3a\u7701\u8bbe\u7f6e", "RuleControlListPlugin_78", "epm-eb-formplugin");
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u7f3a\u7701\u8bbe\u7f6e\u6210\u529f", "RuleControlListPlugin_79", "epm-eb-formplugin");
        OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)"bardefault", (String)"bardefault", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, null);
    }

    private void bardelete() {
        try (TXHandle th = TX.required();){
            try {
                ListSelectedRowCollection selectedRow = ((BillList)this.getControl(BILLLISTKEY)).getSelectedRows();
                HashSet<Object> mainIds = new HashSet<Object>(16);
                for (ListSelectedRow row : selectedRow) {
                    mainIds.add(row.getPrimaryKeyValue());
                }
                ArrayList<Long> groupIds = new ArrayList<Long>(16);
                ArrayList<String> delList = new ArrayList<String>(mainIds.size());
                DynamicObjectCollection entityInGroup = QueryServiceHelper.query((String)"eb_bgcontrolrulemain", (String)"id,group.id,group.groupname,group.groupseq", (QFilter[])new QFilter[]{new QFilter("id", "in", mainIds)});
                StringBuilder stringBuilder = new StringBuilder();
                for (DynamicObject doc : entityInGroup) {
                    if (!groupIds.contains(doc.get("group.id")) && doc.getInt("group.id") != 0) {
                        groupIds.add(doc.getLong("group.id"));
                        stringBuilder.setLength(0);
                        delList.add(stringBuilder.append(doc.getString("group.groupname")).append("(").append(doc.getInt("group.groupseq")).append(")").toString());
                        continue;
                    }
                    delList.add(String.valueOf(doc.getLong("id")));
                }
                if (!groupIds.isEmpty()) {
                    DeleteServiceHelper.delete((String)"eb_bgcontrolrulegroup", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)groupIds.toArray())});
                }
                DeleteServiceHelper.delete((String)"eb_bgcontrolrulemain", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)IDUtils.toLongs((Object[])mainIds.toArray()))});
                DeleteServiceHelper.delete((String)"eb_ocntrolrule_allotorg", (QFilter[])new QFilter[]{new QFilter("controlrulemainid", "in", (Object)IDUtils.toLongs((Object[])mainIds.toArray()))});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"RuleControlListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5220\u9664", "RuleControlListPlugin_9", "epm-eb-formplugin");
                MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u7f16\u53f7\uff1a\u201c%1$s\u201d\uff0c\u5220\u9664\u6210\u529f\u3002", "RuleControlListPlugin_87", "epm-eb-formplugin");
                OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)"deleterow", (String)"deleterow", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{StringUtils.join(delList, (String)",")});
            }
            catch (Exception e) {
                th.markRollback();
                log.error(e.getMessage());
                throw new KDBizException(e.getMessage());
            }
        }
        this.reflushBillList();
    }

    private void getUpOrDown(String[] btn, String key, BillList billList) {
        String indexListStr = this.getPageCache().get("indexList");
        if (StringUtils.isEmpty((String)indexListStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"RuleControlListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List indexList = (List)SerializationUtils.deSerializeFromBase64((String)indexListStr);
        if (indexList == null || indexList.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"RuleControlListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        int rowCount = Integer.parseInt(this.getPageCache().get("rowCount"));
        if (btn[0].equals(key)) {
            if (0 == rowCount) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u662f\u7b2c\u4e00\u6761\u6570\u636e\u3002", (String)"RuleControlListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            --rowCount;
        } else {
            if (indexList.size() - 1 == rowCount) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u662f\u6700\u540e\u4e00\u6761\u6570\u636e\u3002", (String)"RuleControlListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            ++rowCount;
        }
        this.getPageCache().put("rowCount", String.valueOf(rowCount));
        Integer integer = (Integer)indexList.get(rowCount);
        billList.selectRows(integer.intValue());
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("addGroupRule".equals(actionId)) {
            this.reflushBillList();
            Object backData = evt.getReturnData();
            if (backData != null && backData.equals("newAgain")) {
                this.showAddGroupRuleForm();
            }
        } else if ("addrule".equals(actionId)) {
            this.reflushBillList();
            Object backData = evt.getReturnData();
            log1.info("closedCallBack-newAgain=" + backData);
            if ("newAgain".equals(backData)) {
                this.showRuleAddForm();
            }
            if ("editSuccess".equals(backData)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f", (String)"RuleControlListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if ("addSuccess".equals(backData)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65b0\u589e\u6210\u529f", (String)"RuleControlListPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else if ("orgSelect".equals(actionId)) {
            MultiLangEnumBridge opDescBridge;
            MultiLangEnumBridge opNameBridge;
            if (evt.getReturnData() == null) {
                return;
            }
            DynamicObjectCollection returnData = (DynamicObjectCollection)evt.getReturnData();
            List chooseOrg = returnData.stream().map(k -> new OrgMemberDto(k)).collect(Collectors.toList());
            this.getPageCache().put("checkedOrgs", ObjectSerialUtil.toByteSerialized(chooseOrg));
            List selectedRowIds = (List)IDUtils.$toLongs((Object)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("selectedEntryRowIds")));
            List errorInfo = new ArrayList(16);
            List selRows = IDUtils.toStrings((List)selectedRowIds);
            try {
                DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"eb_bgcontrolrulemain");
                DynamicObject[] choosedObjs = (DynamicObject[])BusinessDataServiceHelper.load((Object[])selectedRowIds.toArray(), (IDataEntityType)dy.getDataEntityType());
                errorInfo = this.valideBeforeSave(choosedObjs);
            }
            catch (Exception e) {
                log.error("rulecontrollist_orgselect_error:", (Throwable)e);
                MultiLangEnumBridge opNameBridge2 = new MultiLangEnumBridge("\u5206\u914d\u7ec4\u7ec7", "RuleControlListPlugin_83", "epm-eb-formplugin");
                MultiLangEnumBridge opDescBridge2 = new MultiLangEnumBridge("\u7f16\u53f7\uff1a\u201c%1$s\u201d\uff0c\u5206\u914d\u7ec4\u7ec7\u5931\u8d25\u3002", "RuleControlListPlugin_85", "epm-eb-formplugin");
                OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)"orgSelect", (String)"orgSelect", (MultiLangEnumBridge)opNameBridge2, (MultiLangEnumBridge)opDescBridge2, (String[])selRows.toArray(new String[0]));
                this.getView().showErrorNotification(e.toString());
            }
            if (!errorInfo.isEmpty()) {
                CommonServiceHelper.showErrorInfoForm((IFormView)this.getView(), new ArrayList(errorInfo), (String)ResManager.loadKDString((String)"\u63a7\u5236\u65b9\u5f0f\u5206\u914d\u7ec4\u7ec7\u5931\u8d25\u3002", (String)"RuleControlListPlugin_65", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                opNameBridge = new MultiLangEnumBridge("\u5206\u914d\u7ec4\u7ec7", "RuleControlListPlugin_83", "epm-eb-formplugin");
                opDescBridge = new MultiLangEnumBridge("\u7f16\u53f7\uff1a\u201c%1$s\u201d\uff0c\u5206\u914d\u7ec4\u7ec7\u5931\u8d25\u3002", "RuleControlListPlugin_85", "epm-eb-formplugin");
                OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)"orgSelect", (String)"orgSelect", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])selRows.toArray(new String[0]));
                return;
            }
            DeleteServiceHelper.delete((String)"eb_ocntrolrule_allotorg", (QFilter[])new QFilter[]{new QFilter("controlrulemainid", "in", (Object)selectedRowIds)});
            selectedRowIds.forEach(rowId -> {
                DynamicObject mainDynamic = BusinessDataServiceHelper.loadSingle((Object)rowId, (String)"eb_bgcontrolrulemain");
                this.setOrg(mainDynamic);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainDynamic});
            });
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f", (String)"RuleControlListPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            opNameBridge = new MultiLangEnumBridge("\u5206\u914d\u7ec4\u7ec7", "RuleControlListPlugin_83", "epm-eb-formplugin");
            opDescBridge = new MultiLangEnumBridge("\u7f16\u53f7\uff1a\u201c%1$s\u201d\uff0c\u5206\u914d\u7ec4\u7ec7\u6210\u529f\u3002", "RuleControlListPlugin_84", "epm-eb-formplugin");
            OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)"orgSelect", (String)"orgSelect", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])selRows.toArray(new String[0]));
            this.reflushBillList();
        } else if (!"setDefault".equals(actionId) && "importPage".equals(actionId) && evt.getReturnData() != null && evt.getReturnData().equals("success")) {
            this.reflushBillList();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"RuleControlListPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5bfc\u5165", "RuleControlListPlugin_80", "epm-eb-formplugin");
            MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u5bfc\u5165\u6210\u529f", "RuleControlListPlugin_81", "epm-eb-formplugin");
            OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)"importPage", (String)"importPage", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, null);
        }
    }

    private boolean dateOverlap(String repeatStrDim, SimpleDateFormat sdf, Date newEffectiveDate, Date newInvalidDate, Date oldEffectiveDate, Date oldInvalidDate) {
        try {
            newEffectiveDate = newEffectiveDate == null ? sdf.parse("1970-01-01") : sdf.parse(sdf.format(newEffectiveDate));
            newInvalidDate = newInvalidDate == null ? sdf.parse("2300-01-01") : sdf.parse(sdf.format(newInvalidDate));
            oldEffectiveDate = oldEffectiveDate == null ? sdf.parse("1970-01-01") : sdf.parse(sdf.format(oldEffectiveDate));
            oldInvalidDate = oldInvalidDate == null ? sdf.parse("2300-01-01") : sdf.parse(sdf.format(oldInvalidDate));
            return newEffectiveDate.compareTo(oldInvalidDate) <= 0 && oldEffectiveDate.compareTo(newInvalidDate) <= 0;
        }
        catch (ParseException e) {
            log.error(e.toString());
            this.getView().showErrorNotification(e.toString());
            return false;
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        super.hyperLinkClick(arg0);
        String column = arg0.getFieldName();
        String rowId = this.getPageCache().get("currentClickRowEntryKey");
        if ("showaccount".equals(column)) {
            this.showAccountsForm(rowId);
        } else if (column.length() == 5 && column.contains("show")) {
            this.showDimsForm(rowId, column.substring(4, 5));
        } else if ("showorgrange".equals(column)) {
            this.showOrgRangeInfoForm(rowId);
        }
    }

    private void showDimsForm(String rowId, String columnIndex) {
        ArrayList<String> memberIds = new ArrayList<String>(16);
        Map<Object, Object> needDefineDimAndId = Maps.newLinkedHashMap();
        Long modelId = this.getModelId();
        needDefineDimAndId = this.checkBgmdModel(modelId) || ModelUtil.isBGModel((Long)modelId) ? this.getUserDefinedDimAndId(modelId) : this.getEbUserDefinedDimAndId(modelId);
        DynamicObject controlRule = BusinessDataServiceHelper.loadSingleFromCache((Object)IDUtils.toLong((Object)rowId), (String)"eb_bgcontrolrulemain");
        DynamicObjectCollection oboMemRanges = controlRule.getDynamicObjectCollection(OBO_MEMRANGES);
        Long userDefinedDimId = (Long)needDefineDimAndId.get("userdefined" + columnIndex);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        if (oboMemRanges != null && !oboMemRanges.isEmpty()) {
            Map<Long, List<DynamicObject>> grpOboMemberRangeMap = oboMemRanges.stream().filter(e -> e.getDynamicObject("obodim") != null).collect(Collectors.groupingBy(k -> k.getDynamicObject("obodim").getLong("id")));
            if (CollectionUtils.isNotEmpty((Collection)grpOboMemberRangeMap.get(userDefinedDimId))) {
                Dimension dimension = modelCache.getDimension(userDefinedDimId);
                ArrayList oboMembers = new ArrayList(16);
                List<DynamicObject> oboMemberDyns = grpOboMemberRangeMap.get(userDefinedDimId);
                for (DynamicObject controlRuleOboMember : oboMemberDyns) {
                    DynamicObject oboMember = controlRuleOboMember.getDynamicObject("obomember");
                    String number = oboMember.getString("number");
                    String scope = controlRuleOboMember.getString("memrange");
                    RangeEnum range = RangeEnum.getRangeByVal((int)Integer.parseInt(scope));
                    List members = modelCache.getMember(dimension.getNumber(), null, number, range.getValue());
                    oboMembers.addAll(members);
                }
                List oboMemberIds = oboMembers.stream().distinct().map(BaseCache::getId).collect(Collectors.toList());
                memberIds.addAll(IDUtils.toStrings(oboMemberIds));
            } else {
                DynamicObjectCollection dims = controlRule.getDynamicObjectCollection("dimentions");
                block1: for (int i = 0; i < dims.size(); ++i) {
                    for (int j = 1; j <= 7; ++j) {
                        Long userDefinedDimIdByData = ((DynamicObject)dims.get(i)).getLong("userdefineddimid" + j);
                        if (userDefinedDimIdByData == null || userDefinedDimIdByData == 0L || !userDefinedDimIdByData.equals(userDefinedDimId)) continue;
                        String id = ((DynamicObject)dims.get(i)).getDynamicObject("userdefined" + j).getString("id");
                        memberIds.add(id);
                        continue block1;
                    }
                }
            }
        } else {
            DynamicObjectCollection dims = controlRule.getDynamicObjectCollection("dimentions");
            block3: for (int i = 0; i < dims.size(); ++i) {
                for (int j = 1; j <= 7; ++j) {
                    Long userDefinedDimIdByData = ((DynamicObject)dims.get(i)).getLong("userdefineddimid" + j);
                    if (userDefinedDimIdByData == null || userDefinedDimIdByData == 0L || !userDefinedDimIdByData.equals(userDefinedDimId)) continue;
                    String id = ((DynamicObject)dims.get(i)).getDynamicObject("userdefined" + j).getString("id");
                    memberIds.add(id);
                    continue block3;
                }
            }
        }
        FormShowParameter formShow = new FormShowParameter();
        formShow.setCustomParam("dimIds", memberIds);
        if (this.checkBgmdModel(this.getModelId()) || ModelUtil.isBGModel((Long)this.getModelId())) {
            String definedNumbers = this.getPageCache().get("definedNumbers");
            List objects = (List)SerializationUtils.fromJsonString((String)definedNumbers, List.class);
            String s = (String)objects.get(Integer.parseInt(columnIndex) - 1);
            Dimension dimension = modelCache.getDimension(s);
            formShow.setCaption(ResManager.loadResFormat((String)"\u63a7\u5236\u65b9\u5f0f\u8bbe\u7f6e_%1\u8be6\u60c5", (String)"RuleControlListPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getName()}));
            formShow.setCustomParam("dimNumber", (Object)s);
        } else {
            formShow.setCustomParam("columnIndex", (Object)columnIndex);
        }
        formShow.setCustomParam("modelId", (Object)this.getModelId());
        formShow.setFormId("eb_controlruledims");
        formShow.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShow);
    }

    private void showAccountsForm(String rowId) {
        QFilter qfRowId = new QFilter("id", "=", (Object)IDUtils.toLong((Object)rowId));
        DynamicObjectCollection accounts = QueryServiceHelper.query((String)"eb_bgcontrolruleaccount", (String)"id,account.id,account.number,account.name", (QFilter[])new QFilter[]{qfRowId});
        ArrayList accountIds = new ArrayList(16);
        accounts.forEach(account -> {
            String id = account.getString("account.id");
            accountIds.add(id);
        });
        FormShowParameter formShow = new FormShowParameter();
        formShow.setCustomParam("accountIds", accountIds);
        formShow.setCustomParam("modelId", (Object)this.getModelId());
        formShow.setFormId("eb_controlruleaccounts");
        formShow.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShow);
    }

    private void showOrgRangeInfoForm(String entryId) {
        QFilter qEntryId = new QFilter("controlrulemainid", "=", (Object)IDUtils.toLong((Object)entryId));
        List<Map<String, String>> docs = ControlRuleHelper.getAllotorgList(new QFilter[]{qEntryId});
        List orgIds = docs.stream().map(item -> (String)item.get("orgId")).collect(Collectors.toList());
        FormShowParameter formShow = new FormShowParameter();
        formShow.setCustomParam("checkedOrg", docs);
        formShow.setCustomParam("orgIds", orgIds);
        formShow.setCustomParam("modelId", (Object)this.getModelId());
        formShow.setCustomParam("businessModel", (Object)this.getBussModelId());
        if (!docs.isEmpty()) {
            formShow.setCustomParam("viewId", (Object)docs.get(0).get("view"));
        }
        formShow.setFormId("eb_ruleallotorginfo");
        formShow.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShow);
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        String callBackId;
        super.confirmCallBack(mbce);
        switch (callBackId = mbce.getCallBackId()) {
            case "deleterow": {
                if (!MessageBoxResult.Yes.name().equals(mbce.getResultValue())) break;
                this.bardelete();
                break;
            }
        }
    }

    private void showRuleAddForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_addbgcontrolrule");
        HashMap<String, String> params = new HashMap<String, String>(16);
        long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"RuleControlListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        params.put(MODEL_KEY, String.valueOf(modelId));
        params.put("pageState", "add");
        Long bussModelId = this.getBussModelId();
        params.put("bussmodel", String.valueOf(bussModelId));
        formShowParameter.setCustomParams(params);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u63a7\u5236\u65b9\u5f0f\u65b0\u589e", (String)"RuleControlListPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "addrule");
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u65b0\u589e", "RuleControlListPlugin_73", "epm-eb-formplugin");
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u65b0\u589e\u6210\u529f", "RuleControlListPlugin_17", "epm-eb-formplugin");
        OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)"baradd", (String)"baradd", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, null);
    }

    private void showAddGroupRuleForm() {
        if (this.getModelId() == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"RuleControlListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_controlrulegroupaddnew");
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put(MODEL_KEY, String.valueOf(this.getModelId()));
        params.put(modelCacheKey, String.valueOf(this.getModelId()));
        params.put("pageState", "addGroup");
        Long bussModelId = this.getBussModelId();
        params.put("bussmodel", String.valueOf(bussModelId));
        formShowParameter.setCustomParams(params);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u63a7\u5236\u65b9\u5f0f\u5206\u7ec4\u65b0\u589e", (String)"RuleControlListPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addGroupRule"));
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(formShowParameter);
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u65b0\u589e\u5206\u7ec4\u63a7\u5236", "RuleControlListPlugin_74", "epm-eb-formplugin");
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u65b0\u589e\u5206\u7ec4\u63a7\u5236\u6210\u529f\u3002", "RuleControlListPlugin_75", "epm-eb-formplugin");
        OperationLogUtil.log((String)this.getBizAppId(), (String)this.getBizEntityNumber(), (String)"add_group", (String)"add_group", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, null);
    }

    private void reflushBillList() {
        if (this.getSelModel() != null) {
            this.setDTAndATVisible();
        }
        BillList list = (BillList)this.getControl(BILLLISTKEY);
        list.setFilter(this.getQfilter());
        list.getSelectedRows().clear();
        list.clearSelection();
        list.refresh();
    }

    private QFilter getQfilter() {
        Long modelId = this.getModelId();
        QFilter qModel = new QFilter(MODEL_KEY, "=", (Object)modelId);
        qModel.and(new QFilter("isdefault", "=", (Object)Character.valueOf('0')));
        Long bussModelId = this.getBussModelId();
        if (this.checkBgmdModel(modelId) && IDUtils.isNotEmptyLong((Long)bussModelId).booleanValue()) {
            qModel.and(new QFilter("bussmodel", "=", (Object)bussModelId));
        }
        return qModel;
    }

    @Override
    public Long getBussModelId() {
        Object obj = this.getModel().getValue(BUSSMODEL);
        if (obj == null) {
            return this.getBussModelIdByNumber("AunnalBudget");
        }
        if (obj instanceof DynamicObject) {
            return ((DynamicObject)obj).getLong("id");
        }
        return 0L;
    }

    private Long getBussModelIdByNumber(String number) {
        Long busModelId = 0L;
        QFilter qf1 = new QFilter(MODEL_KEY, "=", (Object)this.getModelId());
        qf1.and(new QFilter("number", "=", (Object)number));
        Map busModels = BusinessDataServiceHelper.loadFromCache((String)"eb_businessmodel", (String)"id", (QFilter[])new QFilter[]{qf1}, (String)"createdate desc");
        if (busModels == null || busModels.size() == 0) {
            return busModelId;
        }
        DynamicObject busmodel = busModels.values().toArray(new DynamicObject[0])[0];
        if (busmodel != null) {
            busModelId = busmodel.getLong("id");
        }
        return busModelId;
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs arg0) {
        arg0.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                List listFields = super.getListFields();
                for (ListField field : listFields) {
                    if (field.getFieldName().contains("group.groupseq")) {
                        field.setSortType(SortType.ASC);
                    }
                    if (!field.getFieldName().contains("createdate")) continue;
                    field.setSortType(SortType.DESC);
                }
                DynamicObjectCollection allRows = super.getData(start, limit);
                Long modelId = RuleControlListPlugin.this.getModelId();
                if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
                    return allRows;
                }
                List mainIds = allRows.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
                LinkedHashMap billListApRowMap = new LinkedHashMap(mainIds.size());
                for (int i = 0; i < mainIds.size(); ++i) {
                    billListApRowMap.put(mainIds.get(i), i);
                }
                RuleControlListPlugin.this.getPageCache().put(RuleControlListPlugin.CACHE_BILL_LIST_AP_ROW, SerializationUtils.serializeToBase64(billListApRowMap));
                QFilter qfOrg = new QFilter("controlrulemainid", "in", (Object)mainIds.toArray());
                List<Map<String, String>> records = ControlRuleHelper.getAllotorgList(new QFilter[]{qfOrg});
                Map<Long, String> orgRanges = records.stream().collect(Collectors.groupingBy(k -> IDUtils.toLong(k.get("controlrulemainid")), Collectors.mapping(item -> (String)item.get("orgName"), Collectors.joining(","))));
                if (records.size() > 0 && orgRanges.size() > 0) {
                    RuleControlListPlugin.this.getPageCache().put("orgNameMap", SerializationUtils.serializeToBase64(orgRanges));
                }
                for (DynamicObject row2 : allRows) {
                    if (!row2.getDataEntityType().getProperties().containsKey((Object)"showorgrange")) {
                        TextProp showorgrange = new TextProp();
                        showorgrange.setName("showorgrange");
                        row2.getDataEntityType().getProperties().add((Object)showorgrange);
                    }
                    Long entryentityId = row2.getLong("id");
                    String orgRange = orgRanges.get(entryentityId);
                    row2.set("showorgrange", (Object)orgRange);
                }
                Map needDefineDimAndId = RuleControlListPlugin.this.checkBgmdModel(RuleControlListPlugin.this.getModelId()) || ModelUtil.isBGModel((Long)RuleControlListPlugin.this.getModelId()) ? RuleControlListPlugin.this.getUserDefinedDimAndId(RuleControlListPlugin.this.getModelId()) : RuleControlListPlugin.this.getEbUserDefinedDimAndId(RuleControlListPlugin.this.getModelId());
                List controlDims = needDefineDimAndId.values().stream().collect(Collectors.toList());
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
                QFilter qfMainIds = new QFilter("id", "in", (Object)mainIds.toArray());
                DataSet groupDimRows = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"eb_bgcontrolrulemain", (String)"id,groupdims.groupdim.id,groupdims.groupdim.name,groupdims.groupdim.number,groupdims.isobodim,groupdims.ismemberrange", (QFilter[])new QFilter[]{qfMainIds}, (String)"");
                HashMap<String, List> groupDimMap = new HashMap<String, List>(16);
                while (groupDimRows.hasNext()) {
                    Row row3 = groupDimRows.next();
                    String mainId = row3.getString("id");
                    Long groupDimId = row3.getLong("groupdims.groupdim.id");
                    if (IDUtils.isEmptyLong((Long)groupDimId).booleanValue() || modelCacheHelper.getDimension(groupDimId) == null || !controlDims.contains(groupDimId)) continue;
                    String groupDimName = row3.getString("groupdims.groupdim.name");
                    if (row3.getBoolean("groupdims.isobodim").booleanValue()) {
                        groupDimName = ResManager.loadResFormat((String)"%1\uff08\u9010\u4e00\u6210\u5458\u5206\u7ec4\uff09", (String)"ControlRuleGroupAddPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[]{groupDimName});
                    }
                    List groupDimNameList = groupDimMap.computeIfAbsent(mainId, k -> new ArrayList(16));
                    groupDimNameList.add(groupDimName);
                }
                groupDimRows.close();
                DynamicObjectCollection oboMemberRanges = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"eb_bgcontrolrulemain", (String)"id,obomemranges.obomember.id,obomemranges.obomember.name,obomemranges.obomember.number,obomemranges.obodim.id,obomemranges.obodim.name,obomemranges.obodim.number,obomemranges.memrange", (QFilter[])new QFilter[]{qfMainIds}, (String)"");
                HashMap<Long, Map> oboMemberMap = new HashMap<Long, Map>(allRows.size());
                if (oboMemberRanges != null && !oboMemberRanges.isEmpty()) {
                    Map<Long, List<DynamicObject>> grpOboMemberRangeMap = oboMemberRanges.stream().collect(Collectors.groupingBy(k -> k.getLong("id")));
                    for (Map.Entry<Long, List<DynamicObject>> entry : grpOboMemberRangeMap.entrySet()) {
                        Long mainId = entry.getKey();
                        Map<Long, List<DynamicObject>> collect = entry.getValue().stream().collect(Collectors.groupingBy(k -> k.getLong("obomemranges.obodim.id")));
                        for (Map.Entry<Long, List<DynamicObject>> entryByOboDim : collect.entrySet()) {
                            Long oboDimId = entryByOboDim.getKey();
                            Dimension dimension = modelCacheHelper.getDimension(oboDimId);
                            if (dimension == null || !controlDims.contains(oboDimId)) continue;
                            List<DynamicObject> value = entryByOboDim.getValue();
                            ArrayList oboMembers = new ArrayList(oboMemberRanges.size());
                            for (DynamicObject controlRuleOboMember : value) {
                                Long oboMemberId = controlRuleOboMember.getLong("obomemranges.obomember.id");
                                if (IDUtils.isEmptyLong((Long)oboMemberId).booleanValue()) continue;
                                String number = controlRuleOboMember.getString("obomemranges.obomember.number");
                                String string = controlRuleOboMember.getString("obomemranges.memrange");
                                RangeEnum range = RangeEnum.getRangeByVal((int)Integer.parseInt(string));
                                List members = modelCacheHelper.getMember(dimension.getNumber(), null, number, range.getValue());
                                oboMembers.addAll(members);
                            }
                            List oboMemberNames = oboMembers.stream().distinct().map(Member::getName).collect(Collectors.toList());
                            String join = String.join((CharSequence)",", oboMemberNames);
                            String oboMemberKey = "";
                            for (Map.Entry entry2 : needDefineDimAndId.entrySet()) {
                                String key = (String)entry2.getKey();
                                Long dimId = (Long)entry2.getValue();
                                if (dimId <= 0L || !dimId.equals(oboDimId)) continue;
                                oboMemberKey = key.replace("userdefined", "show");
                                break;
                            }
                            Map oboMemberMessageMap = oboMemberMap.computeIfAbsent(mainId, k -> new HashMap(16));
                            oboMemberMessageMap.put(oboMemberKey, join);
                        }
                    }
                }
                DataSet accountRows = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"eb_bgcontrolrulemain", (String)"id,bussmodel,model,group,group.groupname,group.groupseq,controltype,periodclassify,coefficient,isbeyond,isfreetype,effectivedate,invaliddate,illustrate,accounts.account.id,accounts.account.name,accounts.account.number", (QFilter[])new QFilter[]{qfMainIds}, (String)"");
                HashMap<String, String> groupMap = new HashMap<String, String>(16);
                HashMap<String, String> accountMap = new HashMap<String, String>(16);
                HashMap<String, Set> accountNumberSetMap = new HashMap<String, Set>(16);
                while (accountRows.hasNext()) {
                    Row row4 = accountRows.next();
                    String mainid = row4.getString("id");
                    String name = row4.getString("group.groupname");
                    String seq = row4.getString("group.groupseq");
                    if (StringUtils.isNotBlank((String)name)) {
                        groupMap.put(mainid, name + "(" + seq + ")");
                    } else {
                        groupMap.put(mainid, null);
                    }
                    String accountName = row4.getString("accounts.account.name");
                    String accountNumber = row4.getString("accounts.account.number");
                    String oldAccounts = (String)accountMap.get(mainid);
                    Set accountNumberExistSet = accountNumberSetMap.computeIfAbsent(mainid, k -> new HashSet(16));
                    if (!StringUtils.isNotBlank((String)accountNumber)) continue;
                    if (StringUtils.isNotBlank((String)oldAccounts)) {
                        if (!accountNumberExistSet.contains(accountNumber)) {
                            accountMap.put(mainid, oldAccounts + "," + accountName);
                        }
                    } else {
                        accountMap.put(mainid, accountName);
                    }
                    accountNumberExistSet.add(accountNumber);
                }
                accountRows.close();
                DataSet dimRows = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"eb_bgcontrolrulemain", (String)"id,dimentions.userdefined1.id,dimentions.userdefined1.name,dimentions.userdefined1.number,dimentions.userdefined2.id,dimentions.userdefined2.name,dimentions.userdefined2.number,dimentions.userdefined3.id,dimentions.userdefined3.name,dimentions.userdefined3.number,dimentions.userdefined4.id,dimentions.userdefined4.name,dimentions.userdefined4.number,dimentions.userdefined5.id,dimentions.userdefined5.name,dimentions.userdefined5.number,dimentions.userdefined6.id,dimentions.userdefined6.name,dimentions.userdefined6.number,dimentions.userdefined7.id,dimentions.userdefined7.name,dimentions.userdefined7.number,dimentions.userdefineddimid1,dimentions.userdefineddimid2,dimentions.userdefineddimid3,dimentions.userdefineddimid4,dimentions.userdefineddimid5,dimentions.userdefineddimid6,dimentions.userdefineddimid7", (QFilter[])new QFilter[]{qfMainIds}, (String)"");
                HashMap<String, String> dimMap = new HashMap<String, String>(16);
                HashMap<String, Set> dimNumberSetMap = new HashMap<String, Set>(16);
                while (dimRows.hasNext()) {
                    Row row5 = dimRows.next();
                    String mainid = row5.getString("id");
                    for (int i = 1; i <= 7; ++i) {
                        Long userDefinedDimId = (Long)needDefineDimAndId.get("userdefined" + i);
                        String dimName = "";
                        String dimNumber = "";
                        for (int j = 1; j <= 7; ++j) {
                            boolean userDefinedFlag;
                            Long userDefinedDimIdByData = row5.getLong("dimentions.userdefineddimid" + j);
                            Long l = row5.getLong("dimentions.userdefined" + j + ".id");
                            boolean bl = userDefinedFlag = userDefinedDimIdByData == null || userDefinedDimIdByData == 0L;
                            if (l != null && l > 0L && userDefinedFlag) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u63a7\u5236\u65b9\u5f0f\u4e2d\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u7684\u5386\u53f2\u6570\u636e\u672a\u5347\u7ea7\u3002", (String)"RuleControlListPlugin_62", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            }
                            if (userDefinedDimIdByData == null || userDefinedDimIdByData == 0L || !userDefinedDimIdByData.equals(userDefinedDimId)) continue;
                            dimName = row5.getString("dimentions.userdefined" + j + ".name");
                            dimNumber = row5.getString("dimentions.userdefined" + j + ".number");
                            break;
                        }
                        String mapKey = mainid + "-userdefined" + i;
                        String oldValue = (String)dimMap.get(mapKey);
                        Set set = dimNumberSetMap.computeIfAbsent(mapKey, k -> new HashSet(16));
                        if (!StringUtils.isNotBlank((String)dimNumber)) continue;
                        if (StringUtils.isNotBlank((String)oldValue)) {
                            if (!set.contains(dimNumber)) {
                                dimMap.put(mapKey, oldValue + "," + dimName);
                            }
                        } else {
                            dimMap.put(mapKey, dimName);
                        }
                        set.add(dimNumber);
                    }
                }
                dimRows.close();
                for (DynamicObject row6 : allRows) {
                    int n;
                    List groupDimNames;
                    if (!row6.getDataEntityType().getProperties().containsKey((Object)"showgroup")) {
                        TextProp showgroup = new TextProp();
                        showgroup.setName("showgroup");
                        row6.getDataEntityType().getProperties().add((Object)showgroup);
                    }
                    row6.set("showgroup", groupMap.get(row6.getString("id")));
                    if (!row6.getDataEntityType().getProperties().containsKey((Object)"showaccount")) {
                        TextProp showaccount = new TextProp();
                        showaccount.setName("showaccount");
                        row6.getDataEntityType().getProperties().add((Object)showaccount);
                    }
                    row6.set("showaccount", accountMap.get(row6.getString("id")));
                    if (!row6.getDataEntityType().getProperties().containsKey((Object)"showgroupdim")) {
                        TextProp showGroupDim = new TextProp();
                        showGroupDim.setName("showgroupdim");
                        row6.getDataEntityType().getProperties().add((Object)showGroupDim);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(groupDimNames = (List)groupDimMap.get(row6.getString("id"))))) {
                        row6.set("showgroupdim", (Object)String.join((CharSequence)",", groupDimNames));
                    }
                    boolean bl = true;
                    while (n <= 7) {
                        if (!row6.getDataEntityType().getProperties().containsKey((Object)("show" + n))) {
                            TextProp showdim = new TextProp();
                            showdim.setName("show" + n);
                            row6.getDataEntityType().getProperties().add((Object)showdim);
                        }
                        ++n;
                    }
                    Map oboMemberRangeMessageMap = (Map)oboMemberMap.get(row6.getLong("id"));
                    if (oboMemberRangeMessageMap != null && oboMemberRangeMessageMap.size() > 0) {
                        for (n = 1; n <= 7; ++n) {
                            String oboMemberMessage = (String)oboMemberRangeMessageMap.get("show" + n);
                            if (StringUtils.isNotBlank((String)oboMemberMessage)) {
                                row6.set("show" + n, (Object)oboMemberMessage);
                                continue;
                            }
                            row6.set("show" + n, dimMap.get(row6.getString("id") + "-userdefined" + n));
                        }
                        continue;
                    }
                    for (n = 1; n <= 7; ++n) {
                        row6.set("show" + n, dimMap.get(row6.getString("id") + "-userdefined" + n));
                    }
                }
                return allRows;
            }
        });
    }

    private Map<String, Long> getEbUserDefinedDimAndId(Long modelId) {
        HashMap<String, Long> needDefineDimAndId = new HashMap<String, Long>(16);
        List userDefineDimensionList = DimensionServiceHelper.getUserDefineDimensionList((long)modelId, (boolean)true);
        int seq = 1;
        for (DynamicObject dynamicObject : userDefineDimensionList) {
            needDefineDimAndId.put("userdefined" + seq, dynamicObject.getLong("id"));
            ++seq;
        }
        return needDefineDimAndId;
    }

    public void createListColumns(BeforeCreateListColumnsArgs arg0) {
        String key;
        String fieldKey;
        Long modelId = this.getModelId();
        if (modelId == 0L) {
            return;
        }
        Map defineDim = new HashMap(16);
        Map<Object, Object> needDefineDimAndName = new HashMap(16);
        Map<Object, Object> needDefineDimAndId = new HashMap(16);
        if (this.checkBgmdModel(modelId) || ModelUtil.isBGModel((Long)modelId)) {
            needDefineDimAndName = this.getUserDefinedDimAndName(modelId);
            needDefineDimAndId = this.getUserDefinedDimAndId(modelId);
        } else {
            defineDim = DimensionServiceHelper.getUserDefineDimensionNumAndNameByModel((long)modelId, (boolean)true);
            for (String dimName : defineDim.values()) {
                String seq = dimName.substring(dimName.lastIndexOf(46) + 1);
                String name = dimName.substring(0, dimName.lastIndexOf("."));
                needDefineDimAndName.put("userdefined" + seq, name);
            }
            needDefineDimAndId = this.getEbUserDefinedDimAndId(modelId);
        }
        this.getPageCache().put("defineDimAmount", String.valueOf(defineDim.size()));
        this.getPageCache().put("difineDimNames", ObjectSerialUtil.toByteSerialized(needDefineDimAndName));
        this.getPageCache().put(USER_DEFINED_DIM_IDS, SerializationUtils.serializeToBase64(needDefineDimAndId));
        List listColumns = arg0.getListColumns();
        ArrayList<IListColumn> removeListColumns = new ArrayList<IListColumn>(listColumns.size());
        for (IListColumn column : listColumns) {
            fieldKey = column.getListFieldKey();
            if ("bussmodel.name".equals(fieldKey)) {
                removeListColumns.add(column);
            }
            if (fieldKey.length() != 5 || !fieldKey.contains("show") || needDefineDimAndName.get(key = "userdefined" + fieldKey.substring(4, 5)) != null) continue;
            removeListColumns.add(column);
        }
        listColumns.removeAll(removeListColumns);
        for (IListColumn column : arg0.getListColumns()) {
            fieldKey = column.getListFieldKey();
            if (fieldKey.length() != 5 || !fieldKey.contains("show") || needDefineDimAndName.get(key = "userdefined" + fieldKey.substring(4, 5)) == null) continue;
            column.setCaption(new LocaleString((String)needDefineDimAndName.get(key)));
        }
    }

    private Map<String, String> getUserDefinedDimAndName(Long modelId) {
        HashMap<String, String> needDefineDimAndName = new HashMap<String, String>(16);
        if (modelId == null || modelId == 0L) {
            return needDefineDimAndName;
        }
        Map<String, Dimension> userDefinedDim = this.getBusinessModel(modelId);
        int seq = 1;
        for (Map.Entry<String, Dimension> entry : userDefinedDim.entrySet()) {
            String dimName = entry.getValue().getName();
            needDefineDimAndName.put("userdefined" + seq, dimName);
            ++seq;
        }
        return needDefineDimAndName;
    }

    private Map<String, Long> getUserDefinedDimAndId(Long modelId) {
        HashMap<String, Long> needDefineDimAndId = new HashMap<String, Long>(16);
        if (modelId == null || modelId == 0L) {
            return needDefineDimAndId;
        }
        Map<String, Dimension> userDefinedDim = this.getBusinessModel(modelId);
        int seq = 1;
        for (Map.Entry<String, Dimension> entry : userDefinedDim.entrySet()) {
            Long dimId = entry.getValue().getId();
            needDefineDimAndId.put("userdefined" + seq, dimId);
            ++seq;
        }
        return needDefineDimAndId;
    }

    private Map<String, Dimension> getBusinessModel(Long modelid) {
        LinkedHashMap<String, Dimension> dimensionMap = new LinkedHashMap<String, Dimension>(16);
        ArrayList<String> lists = new ArrayList<String>();
        if (modelid == null || modelid == 0L) {
            return dimensionMap;
        }
        if (this.checkBgmdModel(modelid) || ModelUtil.isBGModel((Long)modelid)) {
            ArrayList<Dimension> dimensions = new ArrayList<Dimension>(10);
            DynamicObject model = ModelUtils.getModel((Long)modelid);
            QFilter qFilter = new QFilter(MODEL_KEY, "=", (Object)model.getLong("id"));
            Long bussmodelid = this.getBussModelId();
            if (IDUtils.isNotEmptyLong((Long)bussmodelid).booleanValue()) {
                qFilter.and(new QFilter("businessmodel", "=", (Object)bussmodelid));
            }
            DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_bgmcontroldimension", (String)"entryentity.dimensionid", (QFilter[])new QFilter[]{qFilter});
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelid);
            for (DynamicObject dynamicObject : query) {
                long dimId = dynamicObject.getLong("entryentity.dimensionid");
                Dimension dimension = modelCache.getDimension(Long.valueOf(dimId));
                if (dimension == null || !"epm_userdefinedmembertree".equals(dimension.getMemberModel())) continue;
                dimensions.add(dimension);
            }
            dimensions.sort(Comparator.comparingInt(BaseCache::getSeq));
            for (Dimension dimension : dimensions) {
                lists.add(dimension.getNumber());
                dimensionMap.put(dimension.getNumber(), dimension);
            }
        }
        this.getPageCache().put("definedNumbers", SerializationUtils.toJsonString(lists));
        return dimensionMap;
    }

    private boolean checkBgmdModel(Long modelid) {
        if (modelid != 0L) {
            DynamicObject model = ModelUtils.getModel((Long)modelid);
            if (ApplicationTypeEnum.BGMD.getIndex().equals(model.get("reporttype"))) {
                return true;
            }
        }
        return false;
    }

    protected void Search(String text) {
        ArrayList<Integer> indexList = new ArrayList<Integer>(16);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)this.getClass().getName(), (String)"eb_bgcontrolrulemain", (String)"id,accounts.account.name", (QFilter[])new QFilter[]{this.getQfilter()}, (String)"group.groupseq, createdate desc");
        HashMap orgNameMap = new HashMap(16);
        if (this.getPageCache().get("orgNameMap") != null) {
            orgNameMap.putAll((Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("orgNameMap")));
        }
        LinkedHashMap billListApRowMap = new LinkedHashMap(16);
        if (this.getPageCache().get(CACHE_BILL_LIST_AP_ROW) != null) {
            billListApRowMap.putAll((Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(CACHE_BILL_LIST_AP_ROW)));
        }
        Map accountNameMap = rows.stream().collect(Collectors.groupingBy(k -> k.getLong("id"), LinkedHashMap::new, Collectors.mapping(dynam -> dynam.getString("accounts.account.name"), Collectors.joining())));
        if (rows == null || rows.size() == 0) {
            this.getPageCache().put("indexList", SerializationUtils.serializeToBase64(indexList));
            throw new KDBizException(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"RuleControlListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        for (Map.Entry rowEntry : billListApRowMap.entrySet()) {
            Long mainId = (Long)rowEntry.getKey();
            Integer row = (Integer)rowEntry.getValue();
            if ((!accountNameMap.containsKey(mainId) || !((String)accountNameMap.get(mainId)).contains(text)) && (!orgNameMap.containsKey(mainId) || !((String)orgNameMap.get(mainId)).contains(text))) continue;
            indexList.add(row);
        }
        if (indexList.size() != 0) {
            BillList billList = (BillList)this.getControl(BILLLISTKEY);
            billList.selectRows(((Integer)indexList.get(0)).intValue());
            this.getPageCache().put("rowCount", "0");
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u76f8\u5173\u6570\u636e\u3002", (String)"RuleControlListPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getPageCache().put("indexList", SerializationUtils.serializeToBase64(indexList));
    }

    private List<String> getMainIds(DynamicObjectCollection allRows) {
        ArrayList<String> mainIds = new ArrayList<String>(16);
        for (DynamicObject row : allRows) {
            mainIds.add(row.getString("id"));
        }
        return mainIds;
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (MODEL_KEY.equals(key)) {
            BasedataEdit b = ControlModelFuzzySearchCommon.getInstance().reBuildBasedataEdit(key);
            b.setView(this.getView());
            b.setModel(this.getModel());
            b.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            b.addBasedataFuzzySearchListener((BasedataFuzzySearchListener)this);
            e.setControl((Control)b);
        }
    }

    public void handleData(BasedataFuzzySearchEvent searchEvent) {
        ControlModelFuzzySearchCommon.getInstance().reWriteData(searchEvent);
    }

    private void setDTAndATVisible() {
        if (this.checkBgmdModel(this.getModelId())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BUSSMODEL});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BUSSMODEL});
        }
    }

    private void upgradeShowColums() {
        LinkedList<Long> mainIds = new LinkedList<Long>();
        String sql = "select distinct fid from t_eb_controlruleaccount ";
        try (DataSet ds = DB.queryDataSet((String)"queryAccount", (DBRoute)DBRoute.of((String)"epm"), (String)sql);){
            for (Row row : ds) {
                mainIds.add(row.getLong("fid"));
            }
        }
        QFilter qFilter = new QFilter("id", "in", mainIds);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_bgcontrolrulemain", (String)"id,accounts.account.name", (QFilter[])new QFilter[]{qFilter});
        Map<Long, String> maps = query.stream().filter(k -> StringUtils.isNotEmpty((String)k.getString("accounts.account.name"))).collect(Collectors.groupingBy(k -> k.getLong("id"), Collectors.mapping(k -> k.getString("accounts.account.name"), Collectors.joining(","))));
        maps.forEach((k, v) -> {
            String updatesql = "update t_eb_controlrulemain set fshowaccount = ? where fid = ?";
            if (StringUtils.isNotEmpty((String)v) && v.length() < 600) {
                Object[] param = new Object[]{v, k};
                try {
                    DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)updatesql, (Object[])param);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        LinkedList<Long> allMainIds = new LinkedList<Long>();
        sql = "select distinct fid from t_eb_controlrulemain ";
        try (DataSet ds = DB.queryDataSet((String)"queryOrg", (DBRoute)DBRoute.of((String)"epm"), (String)sql);){
            for (Row row : ds) {
                allMainIds.add(row.getLong("fid"));
            }
        }
        qFilter = new QFilter("controlrulemainid", "in", allMainIds);
        List<Map<String, String>> allotorgList = ControlRuleHelper.getAllotorgList(new QFilter[]{qFilter});
        Map<Long, String> orgRanges = allotorgList.stream().filter(item -> StringUtils.isNotEmpty((String)((String)item.get("orgName")))).collect(Collectors.groupingBy(k -> IDUtils.toLong(k.get("controlrulemainid")), Collectors.mapping(item -> (String)item.get("orgName"), Collectors.joining(","))));
        orgRanges.forEach((k, v) -> {
            String updatesql = "update t_eb_controlrulemain set fshoworgrange = ? where fid = ?";
            if (StringUtils.isNotEmpty((String)v) && v.length() < 600) {
                Object[] param = new Object[]{v, k};
                try {
                    DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)updatesql, (Object[])param);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public String getModelFieldKey() {
        return MODEL_KEY;
    }

    @Override
    public List<OrgMemberDto> getCheckedOrg() {
        String orgIdsStr = this.getPageCache().get("checkedOrgs");
        ArrayList<OrgMemberDto> orgRangeIds = orgIdsStr == null ? new ArrayList(16) : (List)ObjectSerialUtil.deSerializedBytes((String)orgIdsStr);
        return orgRangeIds;
    }

    @Override
    public List<String> checkSelf(List<ControlRuleAllotOrgPojo> rules, IModelCacheHelper modelCache, Long accountId) {
        ArrayList errorList = Lists.newArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Map<Integer, Long> controlDimMap = ControlRuleHelper.getControlDimMap(this.getModelId(), this.getBussModelId());
        HashSet propertyIds = new HashSet(16);
        HashMap orgPropretyIdMap = new HashMap(16);
        ArrayList oldDocs = new ArrayList(16);
        int length = rules.size();
        for (int i = 0; i < length; ++i) {
            ControlRuleAllotOrgPojo rule1 = rules.get(i);
            for (int j = i + 1; j < length; ++j) {
                ControlRuleAllotOrgPojo rule2 = rules.get(j);
                if (!ControlRuleHelper.dateOverlap(sdf, rule1.getEffectiveDate(), rule1.getInvalidDate(), rule2.getEffectiveDate(), rule2.getInvalidDate())) continue;
                this.checkControlRuleAllotOrg(errorList, modelCache, accountId, controlDimMap, propertyIds, orgPropretyIdMap, rule1, rule2, oldDocs);
            }
        }
        return errorList;
    }

    @Override
    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        String name = ((BasedataEdit)afterF7SelectEvent.getSource()).getFieldKey();
        if (BUSSMODEL.equals(name)) {
            this.getPageCache().remove(CACHE_ISF7_BUSSMODEL_CHANGE);
        }
    }
}

