/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.control.bgavailablebalance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.period.BgPeriodHelper;
import kd.epm.eb.formplugin.control.bgavailablebalance.obj.CalcBalanceObj;
import kd.epm.eb.formplugin.control.bgavailablebalance.obj.FlexPanelBuilder;
import kd.epm.eb.formplugin.control.bgavailablebalance.obj.PanelUtils;

public class BalanceCalDetailPlugin
extends AbstractBasePlugIn {
    private static final String BORDER = "1px solid #B0C4D6";
    private static final double HEIGH = 30.0;
    private static final String ALIGN = "center";
    private static final String SPACE = " ";
    private static final String STAR = "*";
    private Map<String, String> periodMapping = new HashMap<String, String>(64);
    private static final Log log = LogFactory.getLog(BalanceCalDetailPlugin.class);
    private static final DecimalFormat decimalFormat = new DecimalFormat("###,###.00");
    private CalcBalanceObj calcBalanceObj;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initCalcBalanceObj();
        this.buildPanel();
    }

    private void initCalcBalanceObj() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map strobj = (Map)SerializationUtils.deSerializeFromBase64((String)((String)formShowParameter.getCustomParam("budgetBalance")));
        this.calcBalanceObj = new CalcBalanceObj(strobj);
    }

    private void buildPanel() {
        FlexPanelAp gridflex = FlexPanelBuilder.buildMainAp("gridflex", "column", "default", "stretch").addItems((ControlAp<?>)this.drawContent()).addItems((ControlAp<?>)this.drawTitle()).addItems((ControlAp<?>)this.drawGrid()).setName(PanelUtils.getCaptionCalData()).get();
        this.getView().updateControlMetadata(gridflex.getKey(), gridflex.createControl());
        FlexPanelAp disciptionflex = FlexPanelBuilder.buildMainAp("disciptionflex", "column", "default", "stretch").addItems((ControlAp<?>)this.drawCaption(ResManager.loadResFormat((String)"\u53ef\u7528\u9884\u7b97\u4f59\u989d\uff1a%1\u3002", (String)"PanelUtils_26", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getAmountStr((BigDecimal)this.calcBalanceObj.getCalObj().get("balance"))}))).addItems((ControlAp<?>)this.drawCalcDetail()).setName(PanelUtils.getCaptionCalProcess()).get();
        this.getView().updateControlMetadata(disciptionflex.getKey(), disciptionflex.createControl());
    }

    private FlexPanelAp drawCaption(String str) {
        FlexPanelAp content = FlexPanelBuilder.build("flex-start", false, "100%", "40px").addBorder(BORDER).addPadding("", "10px", "", "10px").get();
        LabelAp labelAp = this.buildLabelAp("label", str, "16", "#000000");
        content.getItems().add(labelAp);
        return content;
    }

    private FlexPanelAp drawTitle() {
        List<String> title = this.calcBalanceObj.getTitle();
        FlexPanelAp leftFlex = FlexPanelBuilder.build().addCell(title.get(0), "15%", "30.0px").get();
        FlexPanelBuilder rightFlexBuilder = FlexPanelBuilder.build(ALIGN, false, "83%", "30.0px").setOverflow("hide");
        int countUserDefineds = StringUtils.isNotEmpty((String)this.calcBalanceObj.getUserDefinedDimStr()) && this.calcBalanceObj.getUserDefinedDimStr().contains("!") ? this.calcBalanceObj.getUserDefinedDimStr().split("!").length : 1;
        int devide = title.size() - 2 + countUserDefineds;
        double allWidth = 90.0;
        double width = Math.ceil(allWidth / (double)devide);
        for (int i = 0; i < title.size(); ++i) {
            if (i == 0) continue;
            if (i == 1) {
                rightFlexBuilder.addItems((ControlAp<?>)FlexPanelBuilder.build().addCell(title.get(i), width * (double)countUserDefineds + "%", "30.0px").get());
                continue;
            }
            rightFlexBuilder.addItems((ControlAp<?>)FlexPanelBuilder.build().addCell(title.get(i), width + "%", "30.0px").get());
        }
        FlexPanelAp headAp = FlexPanelBuilder.build(ALIGN, false, "", "100%").addBorder(BORDER).setBackColor("#F2F2F2").addItems((ControlAp<?>)leftFlex).addItems((ControlAp<?>)rightFlexBuilder.get()).get();
        return headAp;
    }

    private void drawAccountgrid(FlexPanelBuilder builder) {
        List<String> periods = this.getGridPanel(builder, this.calcBalanceObj.getAccount(), this.calcBalanceObj.getUserDefinedDimStr(), this.calcBalanceObj.getPeriod(), this.calcBalanceObj.getBudgetMap(), this.calcBalanceObj.getOccupationMap(), this.calcBalanceObj.getExecuteMap(), this.calcBalanceObj.getBudgetOccupation(), this.calcBalanceObj.getActualChanges());
        if (periods.size() == 0) {
            builder.setHeight("30.0px");
        }
    }

    private FlexPanelAp drawGrid() {
        String height = 30.0 * (double)(this.calcBalanceObj.getPeriod().size() + 1) + "px";
        if (BgControlSettingTypeEnum.MONTH_ADDUP.getNumber().equals(this.calcBalanceObj.getControlType()) || BgControlSettingTypeEnum.QUARTER_ADDUP.getNumber().equals(this.calcBalanceObj.getControlType()) || BgControlSettingTypeEnum.YEAR.getNumber().equals(this.calcBalanceObj.getControlType()) || this.calcBalanceObj.hasGrpData().booleanValue()) {
            height = "250px";
        }
        FlexPanelBuilder builder = FlexPanelBuilder.build("flex-start", true, null, height).setOverflow("auto");
        if (this.calcBalanceObj.hasGrpData().booleanValue()) {
            this.drawGroupGrid(builder);
        } else {
            this.drawAccountgrid(builder);
        }
        return builder.get();
    }

    private void drawGroupGrid(FlexPanelBuilder builder) {
        Map<String, Map<String, BigDecimal>> extBgMap = this.calcBalanceObj.getExtBgMap();
        Map<String, Map<String, BigDecimal>> extOccupationMap = this.calcBalanceObj.getExtOccupationMap();
        Map<String, Map<String, BigDecimal>> extExecuteMap = this.calcBalanceObj.getExtExecuteMap();
        Map<String, Map<String, BigDecimal>> extBudgetOccupationMap = this.calcBalanceObj.getExtBudgetOccupation();
        Map<String, Map<String, BigDecimal>> extActualChangesMap = this.calcBalanceObj.getExtActualChanges();
        if (!this.calcBalanceObj.hasGrpData().booleanValue()) {
            return;
        }
        HashSet<String> groupAcounts = new HashSet<String>(extBgMap.keySet());
        groupAcounts.addAll(extOccupationMap.keySet());
        groupAcounts.addAll(extExecuteMap.keySet());
        groupAcounts.addAll(extBudgetOccupationMap.keySet());
        groupAcounts.addAll(extActualChangesMap.keySet());
        for (String pcdKey : groupAcounts) {
            ArrayList<String> periodList = new ArrayList<String>(16);
            for (String p : this.calcBalanceObj.getPeriod()) {
                if (extBgMap.containsKey(pcdKey) && extBgMap.get(pcdKey).containsKey(p)) {
                    periodList.add(p);
                    continue;
                }
                if (extOccupationMap.containsKey(pcdKey) && extOccupationMap.get(pcdKey).containsKey(p)) {
                    periodList.add(p);
                    continue;
                }
                if (extExecuteMap.containsKey(pcdKey) && extExecuteMap.get(pcdKey).containsKey(p)) {
                    periodList.add(p);
                    continue;
                }
                if (extBudgetOccupationMap.containsKey(pcdKey) && extBudgetOccupationMap.get(pcdKey).containsKey(p)) {
                    periodList.add(p);
                    continue;
                }
                if (!extActualChangesMap.containsKey(pcdKey) || !extActualChangesMap.get(pcdKey).containsKey(p)) continue;
                periodList.add(p);
            }
            HashMap<String, BigDecimal> bMap = extBgMap.containsKey(pcdKey) ? extBgMap.get(pcdKey) : new HashMap(16);
            HashMap<String, BigDecimal> oMap = extOccupationMap.containsKey(pcdKey) ? extOccupationMap.get(pcdKey) : new HashMap(16);
            HashMap<String, BigDecimal> eMap = extExecuteMap.containsKey(pcdKey) ? extExecuteMap.get(pcdKey) : new HashMap(16);
            HashMap<String, BigDecimal> boMap = extBudgetOccupationMap.containsKey(pcdKey) ? extBudgetOccupationMap.get(pcdKey) : new HashMap(16);
            HashMap<String, BigDecimal> acMap = extActualChangesMap.containsKey(pcdKey) ? extActualChangesMap.get(pcdKey) : new HashMap(16);
            String accountNumber = this.calcBalanceObj.getMemberByDimNumber(pcdKey, "Account");
            String acountName = this.calcBalanceObj.getModelCacheHelper().getMember("Account", null, accountNumber).getName();
            log.info("account:" + acountName);
            log.info("grpPeriodList:" + JSONUtils.toString(periodList));
            log.info("bMap" + JSONUtils.toString(bMap));
            log.info("oMap" + JSONUtils.toString(oMap));
            log.info("eMap" + JSONUtils.toString(eMap));
            log.info("boMap" + JSONUtils.toString(boMap));
            log.info("acMap" + JSONUtils.toString(acMap));
            String userdefs = this.calcBalanceObj.userDefinedDim(pcdKey);
            this.getGridPanel(builder, this.calcBalanceObj.showAccount(acountName, accountNumber), userdefs, periodList, bMap, oMap, eMap, boMap, acMap);
        }
    }

    private FlexPanelAp drawContent() {
        FlexPanelAp content = FlexPanelBuilder.build("flex-start", false, "100%", "60px").setBackColor("#F2F9FF").setRadius("4px").addBorder("1px solid #E0EFFF").addMargin(null, null, "10px", null).addPadding(null, "15px", "", "15px").get();
        String remark = "";
        List<String> hasActualPeriods = this.calcBalanceObj.getHasActualPeriods();
        if (BgControlSettingTypeEnum.MONTH_ADDUP.getNumber().equals(this.calcBalanceObj.getControlType()) || BgControlSettingTypeEnum.HALFYEAR_ADDUP.getNumber().equals(this.calcBalanceObj.getControlType())) {
            remark = hasActualPeriods != null && hasActualPeriods.stream().anyMatch(k -> BgPeriodHelper.compareTo((String)k, (String)this.calcBalanceObj.getCurrPeriod()) > 0) ? PanelUtils.getRemarkAddmonthMore() : PanelUtils.getRemarkAddmonthLess();
        } else if (BgControlSettingTypeEnum.MONTH_HALFYEAR_ADDUP.getNumber().equals(this.calcBalanceObj.getControlType())) {
            remark = hasActualPeriods != null && hasActualPeriods.stream().anyMatch(k -> BgPeriodHelper.compareTo((String)k, (String)this.calcBalanceObj.getCurrPeriod()) > 0) ? PanelUtils.getRemarkAddMonthByHalfYearMore() : PanelUtils.getRemarkAddMonthByHalfYearLess();
        } else if (BgControlSettingTypeEnum.MONTH_QUARTER_ADDUP.getNumber().equals(this.calcBalanceObj.getControlType())) {
            remark = hasActualPeriods != null && hasActualPeriods.stream().anyMatch(k -> BgPeriodHelper.compareTo((String)k, (String)this.calcBalanceObj.getCurrPeriod()) > 0) ? PanelUtils.getRemarkAddMonthByQuarterMore() : PanelUtils.getRemarkAddMonthByQuarterLess();
        } else if (BgControlSettingTypeEnum.QUARTER_ADDUP.getNumber().equals(this.calcBalanceObj.getControlType())) {
            remark = hasActualPeriods != null && hasActualPeriods.stream().anyMatch(k -> BgPeriodHelper.compareTo((String)this.calcBalanceObj.getPeriodListByCurPeriod((String)k, "quarter").get(2), (String)this.calcBalanceObj.getPeriodListByCurPeriod(this.calcBalanceObj.getCurrPeriod(), "quarter").get(2)) > 0) ? PanelUtils.getRemarkAddQuarterMore() : PanelUtils.getRemarkAddQuarterLess();
        } else if (BgControlSettingTypeEnum.MONTH.getNumber().equals(this.calcBalanceObj.getControlType())) {
            remark = PanelUtils.getRemarkMonth();
        } else if (BgControlSettingTypeEnum.YEAR.getNumber().equals(this.calcBalanceObj.getControlType())) {
            remark = PanelUtils.getRemarkYear();
        } else if (BgControlSettingTypeEnum.QUARTER.getNumber().equals(this.calcBalanceObj.getControlType())) {
            remark = PanelUtils.getRemarkQuarter();
        } else if (BgControlSettingTypeEnum.HALFYEAR.getNumber().equals(this.calcBalanceObj.getControlType())) {
            remark = PanelUtils.getRemarkHalfyear();
        }
        VectorAp vectorAp = new VectorAp();
        vectorAp.setKey("vectorAp");
        vectorAp.setfontClass("kdfont kdfont-jingshi2");
        vectorAp.setForeColor("#1E90FF");
        Margin mg = new Margin();
        mg.setRight("5px");
        Style st = new Style();
        st.setMargin(mg);
        vectorAp.setStyle(st);
        LabelAp labelAp = this.buildLabelAp("label", remark, "14", "#696969");
        content.getItems().add(vectorAp);
        content.getItems().add(labelAp);
        return content;
    }

    private FlexPanelAp drawCalcDetail() {
        Long startTime = System.currentTimeMillis();
        log.info("start" + startTime);
        FlexPanelBuilder panelAp = FlexPanelBuilder.buildMainAp("mainDetail", "column", "default", "stretch").addBorder(null, BORDER, BORDER, BORDER).addPadding(null, null, null, "10px");
        String controlType = this.calcBalanceObj.getControlType();
        if (BgControlSettingTypeEnum.MONTH.getNumber().equals(controlType) || BgControlSettingTypeEnum.QUARTER.getNumber().equals(controlType) || BgControlSettingTypeEnum.HALFYEAR.getNumber().equals(controlType) || BgControlSettingTypeEnum.YEAR.getNumber().equals(controlType)) {
            this.drawCalDetail(panelAp, this.calcBalanceObj.getPeriod(), this.calcBalanceObj.getCurrPeriod());
        } else if (BgControlSettingTypeEnum.isMonthAddUp((String)this.calcBalanceObj.getControlType()).booleanValue()) {
            for (String period : this.calcBalanceObj.getPeriod()) {
                if (!period.equals(this.calcBalanceObj.getCurrPeriod()) && (BgPeriodHelper.compareTo((String)period, (String)this.calcBalanceObj.getCurrPeriod()) <= 0 || !this.calcBalanceObj.hasActual(period).booleanValue())) continue;
                this.drawCalDetail(panelAp, this.calcBalanceObj.getPeriod(), period);
            }
        } else if (BgControlSettingTypeEnum.QUARTER_ADDUP.getNumber().equals(this.calcBalanceObj.getControlType())) {
            ArrayList<String> pl = new ArrayList<String>(3);
            String maxMonth = this.calcBalanceObj.getPeriodListByCurPeriod(this.calcBalanceObj.getCurrPeriod(), "quarter").get(2);
            for (String period : this.calcBalanceObj.getPeriod()) {
                pl.add(period);
                String q = this.calcBalanceObj.getPeriodListByCurPeriod(period, "quarter").get(2);
                if (!period.equals(q)) continue;
                List<String> months = this.calcBalanceObj.getPeriodListByCurPeriod(period, "quarter");
                if (!maxMonth.equals(q) && (BgPeriodHelper.compareTo((String)maxMonth, (String)q) >= 0 || !this.calcBalanceObj.hasActual(months).booleanValue())) continue;
                this.drawCalDetail(panelAp, pl, q);
            }
        }
        log.info("end" + System.currentTimeMillis() + "cost:" + (System.currentTimeMillis() - startTime) + "ms");
        return !panelAp.get().getItems().isEmpty() ? panelAp.get() : null;
    }

    /*
     * WARNING - void declaration
     */
    private void drawCalDetail(FlexPanelBuilder builder, List<String> periodList, String period) {
        ArrayList<String> hisBudgets = new ArrayList<String>();
        ArrayList<Object> hisActuals = new ArrayList<Object>();
        BigDecimal balance = BigDecimal.ZERO;
        ArrayList accountNames = Lists.newArrayList((Object[])new String[]{this.calcBalanceObj.getAccount()});
        for (String hisperiod : periodList) {
            String grpAccountName;
            String accountNumber;
            String amt;
            BigDecimal occupation;
            if ((BgControlSettingTypeEnum.isMonthAddUp((String)this.calcBalanceObj.getControlType()).booleanValue() || BgControlSettingTypeEnum.QUARTER_ADDUP.getNumber().equals(this.calcBalanceObj.getControlType())) && BgPeriodHelper.compareTo((String)hisperiod, (String)period) > 0) continue;
            if (this.calcBalanceObj.getBudgetMap().containsKey(hisperiod)) {
                BigDecimal budget = this.calcBalanceObj.getBudgetMap().get(hisperiod);
                if (budget.compareTo(BigDecimal.ZERO) < 0) {
                    hisBudgets.add(PanelUtils.getTxtBracket(this.getAmountStr(budget)));
                } else {
                    hisBudgets.add(this.getAmountStr(budget));
                }
                balance = balance.add(budget.multiply(this.calcBalanceObj.getCoefficient()));
            }
            for (Map.Entry entry : this.calcBalanceObj.getExtBgMap().entrySet()) {
                if (!((Map)entry.getValue()).containsKey(hisperiod)) continue;
                BigDecimal budget = (BigDecimal)((Map)entry.getValue()).get(hisperiod);
                if (budget.compareTo(BigDecimal.ZERO) < 0) {
                    hisBudgets.add(PanelUtils.getTxtBracket(this.getAmountStr(budget)));
                } else {
                    hisBudgets.add(this.getAmountStr(budget));
                }
                balance = balance.add(budget.multiply(this.calcBalanceObj.getCoefficient()));
                String accountNumber2 = this.calcBalanceObj.getMemberByDimNumber((String)entry.getKey(), "Account");
                String grpAccountName2 = this.calcBalanceObj.showAccount(this.calcBalanceObj.getModelCacheHelper().getMember("Account", null, accountNumber2).getName(), accountNumber2);
                if (accountNames.contains(grpAccountName2)) continue;
                accountNames.add(grpAccountName2);
            }
            if (this.calcBalanceObj.getOccupationMap().containsKey(hisperiod)) {
                void var11_15;
                BigDecimal occupation2 = this.calcBalanceObj.getOccupationMap().get(hisperiod);
                String string = this.getAmountStr(occupation2);
                if (string.startsWith("-")) {
                    String string2 = PanelUtils.getTxtBracket(string);
                }
                hisActuals.add(var11_15);
                balance = balance.subtract(occupation2);
            }
            for (Map.Entry entry : this.calcBalanceObj.getExtOccupationMap().entrySet()) {
                if (!((Map)entry.getValue()).containsKey(hisperiod)) continue;
                occupation = (BigDecimal)((Map)entry.getValue()).get(hisperiod);
                amt = this.getAmountStr(occupation);
                if (amt.startsWith("-")) {
                    amt = PanelUtils.getTxtBracket(amt);
                }
                hisActuals.add(amt);
                balance = balance.subtract(occupation);
                accountNumber = this.calcBalanceObj.getMemberByDimNumber((String)entry.getKey(), "Account");
                grpAccountName = this.calcBalanceObj.showAccount(this.calcBalanceObj.getModelCacheHelper().getMember("Account", null, accountNumber).getName(), accountNumber);
                if (accountNames.contains(grpAccountName)) continue;
                accountNames.add(grpAccountName);
            }
            if (this.calcBalanceObj.getExecuteMap().containsKey(hisperiod)) {
                void var11_19;
                BigDecimal execute = this.calcBalanceObj.getExecuteMap().get(hisperiod);
                String string = this.getAmountStr(execute);
                if (string.startsWith("-")) {
                    String string3 = PanelUtils.getTxtBracket(string);
                }
                hisActuals.add(var11_19);
                balance = balance.subtract(execute);
            }
            for (Map.Entry entry : this.calcBalanceObj.getExtExecuteMap().entrySet()) {
                if (!((Map)entry.getValue()).containsKey(hisperiod)) continue;
                occupation = (BigDecimal)((Map)entry.getValue()).get(hisperiod);
                amt = this.getAmountStr(occupation);
                if (amt.startsWith("-")) {
                    amt = PanelUtils.getTxtBracket(amt);
                }
                hisActuals.add(amt);
                balance = balance.subtract(occupation);
                accountNumber = this.calcBalanceObj.getMemberByDimNumber((String)entry.getKey(), "Account");
                grpAccountName = this.calcBalanceObj.showAccount(this.calcBalanceObj.getModelCacheHelper().getMember("Account", null, accountNumber).getName(), accountNumber);
                if (accountNames.contains(grpAccountName)) continue;
                accountNames.add(grpAccountName);
            }
            if (this.calcBalanceObj.getBudgetOccupation().containsKey(hisperiod)) {
                void var11_23;
                BigDecimal budgetOccupation = this.calcBalanceObj.getBudgetOccupation().get(hisperiod);
                String string = this.getAmountStr(budgetOccupation.negate());
                if (string.startsWith("-")) {
                    String string4 = PanelUtils.getTxtBracket(string);
                }
                hisActuals.add(var11_23);
                balance = balance.subtract(budgetOccupation.negate());
            }
            for (Map.Entry entry : this.calcBalanceObj.getExtBudgetOccupation().entrySet()) {
                if (!((Map)entry.getValue()).containsKey(hisperiod)) continue;
                occupation = (BigDecimal)((Map)entry.getValue()).get(hisperiod);
                amt = this.getAmountStr(occupation.negate());
                if (amt.startsWith("-")) {
                    amt = PanelUtils.getTxtBracket(amt);
                }
                hisActuals.add(amt);
                balance = balance.subtract(occupation.negate());
                accountNumber = this.calcBalanceObj.getMemberByDimNumber((String)entry.getKey(), "Account");
                grpAccountName = this.calcBalanceObj.showAccount(this.calcBalanceObj.getModelCacheHelper().getMember("Account", null, accountNumber).getName(), accountNumber);
                if (accountNames.contains(grpAccountName)) continue;
                accountNames.add(grpAccountName);
            }
            if (this.calcBalanceObj.getActualChanges().containsKey(hisperiod)) {
                void var11_27;
                BigDecimal actualChanges = this.calcBalanceObj.getActualChanges().get(hisperiod);
                String string = this.getAmountStr(actualChanges);
                if (string.startsWith("-")) {
                    String string5 = PanelUtils.getTxtBracket(string);
                }
                hisActuals.add(var11_27);
                balance = balance.subtract(actualChanges);
            }
            for (Map.Entry entry : this.calcBalanceObj.getExtActualChanges().entrySet()) {
                if (!((Map)entry.getValue()).containsKey(hisperiod)) continue;
                occupation = (BigDecimal)((Map)entry.getValue()).get(hisperiod);
                amt = this.getAmountStr(occupation);
                if (amt.startsWith("-")) {
                    amt = PanelUtils.getTxtBracket(amt);
                }
                hisActuals.add(amt);
                balance = balance.subtract(occupation);
                accountNumber = this.calcBalanceObj.getMemberByDimNumber((String)entry.getKey(), "Account");
                grpAccountName = this.calcBalanceObj.showAccount(this.calcBalanceObj.getModelCacheHelper().getMember("Account", null, accountNumber).getName(), accountNumber);
                if (accountNames.contains(grpAccountName)) continue;
                accountNames.add(grpAccountName);
            }
        }
        StringBuilder contentPrefix = new StringBuilder();
        StringBuilder contentSuffix = new StringBuilder();
        if (accountNames.size() <= 1) {
            contentPrefix.append((String)accountNames.get(0));
        } else {
            contentPrefix.append(StringUtils.join((Collection)accountNames, (String)" + "));
        }
        if (BgControlSettingTypeEnum.isMonthAddUp((String)this.calcBalanceObj.getControlType()).booleanValue()) {
            contentPrefix.append(this.getPeriodName(period));
            contentPrefix.append(PanelUtils.getTxtBudget());
        } else if (BgControlSettingTypeEnum.QUARTER_ADDUP.getNumber().equals(this.calcBalanceObj.getControlType())) {
            contentPrefix.append(this.calcBalanceObj.getPeriodName(period));
            contentPrefix.append(PanelUtils.getTxtBudget());
        } else {
            contentPrefix.append(SPACE);
            contentPrefix.append(PanelUtils.getTxtCurrentBudget());
        }
        contentPrefix.append(ResManager.loadKDString((String)"\uff1a", (String)"PanelUtils_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        if (hisBudgets.size() > 0) {
            contentSuffix.append(SPACE);
            if (hisBudgets.size() > 1) {
                contentSuffix.append(PanelUtils.getTxtBracket(StringUtils.join(hisBudgets, (String)" + ")));
            } else {
                contentSuffix.append(StringUtils.join(hisBudgets, (String)" + "));
            }
            contentSuffix.append(SPACE);
            contentSuffix.append(STAR);
            contentSuffix.append(SPACE);
            contentSuffix.append(this.calcBalanceObj.getCoefficient());
        } else {
            contentSuffix.append("0.00");
        }
        if (hisActuals.size() > 0) {
            contentSuffix.append(" - ");
            contentSuffix.append(PanelUtils.getTxtBracket(StringUtils.join(hisActuals, (String)" + ")));
        }
        if (hisBudgets.size() > 0 || hisActuals.size() > 0) {
            contentSuffix.append(" = ");
            contentSuffix.append(this.getAmountStr(balance));
        }
        FlexPanelAp contentPanel1 = FlexPanelBuilder.build("flex-start", false, "100%", "").addMargin("5px", null, "5px", null).addItems((ControlAp<?>)this.buildLabelAp("calcDetail", contentPrefix.toString(), "14", "#000000", null, "true")).get();
        FlexPanelAp flexPanelAp = FlexPanelBuilder.build("flex-start", false, "100%", "").addMargin("5px", null, "5px", null).addItems((ControlAp<?>)this.buildLabelAp("calcDetail", contentSuffix.toString(), "14", "#696969", null, "true")).get();
        builder.addItems((ControlAp<?>)contentPanel1).addItems((ControlAp<?>)flexPanelAp);
    }

    private List<String> getGridPanel(FlexPanelBuilder builder, String account, String userDef, List<String> periods, Map<String, BigDecimal> budgetMap, Map<String, BigDecimal> occupationMap, Map<String, BigDecimal> executeMap, Map<String, BigDecimal> budgetOccupationMap, Map<String, BigDecimal> actualChangesMap) {
        List<String> showPeriod;
        Set<String> allPeriod = this.calcBalanceObj.getAllPeriod();
        if (BgControlSettingTypeEnum.isMonthAddUp((String)this.calcBalanceObj.getControlType()).booleanValue()) {
            showPeriod = periods.stream().filter(k -> this.calcBalanceObj.hasActual((String)k) != false || BgPeriodHelper.compareTo((String)k, (String)this.calcBalanceObj.getCurrPeriod()) <= 0 && allPeriod.contains(k)).collect(Collectors.toList());
        } else if (BgControlSettingTypeEnum.QUARTER_ADDUP.getNumber().equals(this.calcBalanceObj.getControlType())) {
            List<String> months = this.calcBalanceObj.getPeriodListByCurPeriod(this.calcBalanceObj.getCurrPeriod(), "quarter");
            String maxMonth = months.get(2);
            showPeriod = periods.stream().filter(k -> this.calcBalanceObj.hasActual((String)k) != false || BgPeriodHelper.compareTo((String)k, (String)maxMonth) <= 0 && allPeriod.contains(k)).collect(Collectors.toList());
        } else {
            showPeriod = periods.stream().filter(k -> allPeriod.contains(k)).collect(Collectors.toList());
        }
        int size = showPeriod.size();
        int countUserDefineds = StringUtils.isNotEmpty((String)userDef) && userDef.contains("!") ? userDef.split("!").length : 1;
        int devide = this.calcBalanceObj.getTitle().size() - 2 + countUserDefineds;
        double allWidth = 90.0;
        double width = Math.ceil(allWidth / (double)devide);
        if (size > 0) {
            FlexPanelBuilder accountFlex = FlexPanelBuilder.build().addCell(account, "15%", 30.0 * (double)size + "px", null, BORDER, BORDER, BORDER);
            FlexPanelBuilder rightPanelBuilder = FlexPanelBuilder.build(ALIGN, true, "83%", 30.0 * (double)size + "px").setOverflow("hide");
            for (String period : showPeriod) {
                String budget = this.getAmountStr(budgetMap.get(period));
                String bottomBorder = BORDER;
                String occupation = this.getAmountStr(occupationMap.get(period));
                String execute = this.getAmountStr(executeMap.get(period));
                rightPanelBuilder.addItems((ControlAp<?>)FlexPanelBuilder.build().addCell(userDef, width * (double)countUserDefineds + "%", "30.0px", null, BORDER, bottomBorder, null).get()).addItems((ControlAp<?>)FlexPanelBuilder.build().addCell(this.getPeriodName(period), width + "%", "30.0px", null, BORDER, bottomBorder, null).get()).addItems((ControlAp<?>)FlexPanelBuilder.build().addCell(budget, width + "%", "30.0px", null, BORDER, bottomBorder, null).setJustifyContent("flex-end").addPadding(null, "3px", null, null).get()).addItems((ControlAp<?>)FlexPanelBuilder.build().addCell(this.calcBalanceObj.getCoefficient().toString(), width + "%", "30.0px", null, BORDER, bottomBorder, null).setJustifyContent("flex-end").addPadding(null, "3px", null, null).get()).addItems((ControlAp<?>)FlexPanelBuilder.build().addCell(occupation, width + "%", "30.0px", null, BORDER, bottomBorder, null).setJustifyContent("flex-end").addPadding(null, "3px", null, null).get()).addItems((ControlAp<?>)FlexPanelBuilder.build().addCell(execute, width + "%", "30.0px", null, BORDER, bottomBorder, null).setJustifyContent("flex-end").addPadding(null, "3px", null, null).get()).addItems((ControlAp<?>)FlexPanelBuilder.build().addCell(budgetOccupationMap.containsKey(period) ? this.getAmountStr(budgetOccupationMap.get(period).negate()) : "0.00", width + "%", "30.0px", null, BORDER, bottomBorder, null).setJustifyContent("flex-end").addPadding(null, "3px", null, null).get(), x -> this.calcBalanceObj.getTitle().contains(PanelUtils.getTitleBo())).addItems((ControlAp<?>)FlexPanelBuilder.build().addCell(this.getAmountStr(actualChangesMap.get(period)), width + "%", "30.0px", null, BORDER, bottomBorder, null).setJustifyContent("flex-end").addPadding(null, "3px", null, null).get(), x -> this.calcBalanceObj.getTitle().contains(PanelUtils.getTitleAc()));
            }
            builder.addItems((ControlAp<?>)accountFlex.get()).addItems((ControlAp<?>)rightPanelBuilder.get());
        }
        BigDecimal sumBudget = BigDecimal.ZERO;
        BigDecimal sumOccupation = BigDecimal.ZERO;
        BigDecimal sumexecute = BigDecimal.ZERO;
        BigDecimal sumBudgetOccupation = BigDecimal.ZERO;
        BigDecimal sumActualChanges = BigDecimal.ZERO;
        for (String p : showPeriod) {
            if (budgetMap.containsKey(p)) {
                sumBudget = sumBudget.add(budgetMap.get(p));
            }
            if (occupationMap.containsKey(p)) {
                sumOccupation = sumOccupation.add(occupationMap.get(p));
            }
            if (executeMap.containsKey(p)) {
                sumexecute = sumexecute.add(executeMap.get(p));
            }
            if (budgetOccupationMap.containsKey(p)) {
                sumBudgetOccupation = sumBudgetOccupation.add(budgetOccupationMap.get(p));
            }
            if (!actualChangesMap.containsKey(p)) continue;
            sumActualChanges = sumActualChanges.add(actualChangesMap.get(p));
        }
        FlexPanelBuilder accountSumFlexPanel = FlexPanelBuilder.build().addCell(PanelUtils.getTxtStatistics(), "15%", "30.0px", null, BORDER, BORDER, BORDER).setBackColor("#FFF1D4");
        FlexPanelBuilder sumrightFlexBuilder = FlexPanelBuilder.build(ALIGN, true, "83%", "30.0px").setOverflow("hide").addItems((ControlAp<?>)FlexPanelBuilder.build().addCell("", width * (double)countUserDefineds + "%", "30.0px", null, BORDER, BORDER, null).get()).addItems((ControlAp<?>)FlexPanelBuilder.build().addCell("", width + "%", "30.0px", null, BORDER, BORDER, null).get()).addItems((ControlAp<?>)FlexPanelBuilder.build().addCell(this.getAmountStr(sumBudget), width + "%", "30.0px", null, BORDER, BORDER, null, "#FF5F1F").setJustifyContent("flex-end").addPadding(null, "3px", null, null).get()).addItems((ControlAp<?>)FlexPanelBuilder.build().addCell("", width + "%", "30.0px", "", BORDER, BORDER, "").get()).addItems((ControlAp<?>)FlexPanelBuilder.build().addCell(this.getAmountStr(sumOccupation), width + "%", "30.0px", null, BORDER, BORDER, null, "#FF5F1F").setJustifyContent("flex-end").addPadding(null, "3px", null, null).get()).addItems((ControlAp<?>)FlexPanelBuilder.build().addCell(this.getAmountStr(sumexecute), width + "%", "30.0px", null, BORDER, BORDER, null, "#FF5F1F").setJustifyContent("flex-end").addPadding(null, "3px", null, null).get()).addItems((ControlAp<?>)FlexPanelBuilder.build().addCell(this.getAmountStr(sumBudgetOccupation.negate()), width + "%", "30.0px", null, BORDER, BORDER, null, "#FF5F1F").setJustifyContent("flex-end").addPadding(null, "3px", null, null).get(), x -> this.calcBalanceObj.getTitle().contains(PanelUtils.getTitleBo())).addItems((ControlAp<?>)FlexPanelBuilder.build().addCell(this.getAmountStr(sumActualChanges), width + "%", "30.0px", null, BORDER, BORDER, null, "#FF5F1F").setJustifyContent("flex-end").addPadding(null, "3px", null, null).get(), x -> this.calcBalanceObj.getTitle().contains(PanelUtils.getTitleAc())).setBackColor("#FFF1D4");
        builder.addItems((ControlAp<?>)accountSumFlexPanel.get()).addItems((ControlAp<?>)sumrightFlexBuilder.get());
        return showPeriod;
    }

    private LabelAp buildLabelAp(String ... pro) {
        LabelAp labelAp = new LabelAp();
        labelAp.setKey(pro[0]);
        labelAp.setName(new LocaleString(pro[1]));
        labelAp.setFontSize(Integer.parseInt(pro[2]));
        labelAp.setForeColor(pro[3]);
        if (pro.length > 4) {
            labelAp.setBackColor(pro[4]);
        }
        if (pro.length > 5) {
            labelAp.setAutoTextWrap(Boolean.parseBoolean(pro[5]));
        } else {
            labelAp.setAutoTextWrap(false);
        }
        return labelAp;
    }

    private String getPeriodName(String periodNumber) {
        if (this.periodMapping.isEmpty()) {
            Long modelId = this.calcBalanceObj.getModelCacheHelper().getModelobj().getId();
            if (ApplicationTypeEnum.EB.getIndex().equals(this.calcBalanceObj.getModelType())) {
                DynamicObjectCollection year = QueryServiceHelper.query((String)SysDimensionEnum.Year.getMemberTreemodel(), (String)"name,number,isleaf", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
                DynamicObjectCollection period = QueryServiceHelper.query((String)SysDimensionEnum.Period.getMemberTreemodel(), (String)"name,number,isleaf", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
                for (DynamicObject dy1 : year) {
                    if (!dy1.getBoolean("isleaf")) continue;
                    for (DynamicObject dy2 : period) {
                        this.periodMapping.put(dy1.getString("number") + "_" + dy2.getString("number"), dy1.getString("name") + dy2.getString("name"));
                    }
                }
            } else {
                DynamicObjectCollection query = QueryServiceHelper.query((String)SysDimensionEnum.BudgetPeriod.getMemberTreemodel(), (String)"name,number,isleaf", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
                Map<String, String> periodmap = query.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v.get("name") != null ? v.getString("name") : v.getString("number")));
                this.periodMapping.putAll(periodmap);
            }
        }
        return this.periodMapping.get(periodNumber);
    }

    private String getAmountStr(BigDecimal amount) {
        if (amount == null || amount.equals(BigDecimal.ZERO) || BigDecimal.ZERO.compareTo(amount) == 0) {
            return "0.00";
        }
        if ((amount = amount.setScale(2, 4)).compareTo(BigDecimal.ONE) < 0 && amount.compareTo(BigDecimal.ZERO) > 0 || amount.compareTo(new BigDecimal("-1")) > 0 && amount.compareTo(BigDecimal.ZERO) < 0) {
            return amount.toPlainString();
        }
        return decimalFormat.format(amount);
    }
}

